# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AzureBackupServerContainerResponse',
    'AzureFileShareProtectionPolicyResponse',
    'AzureFileshareProtectedItemExtendedInfoResponse',
    'AzureFileshareProtectedItemResponse',
    'AzureIaaSClassicComputeVMContainerResponse',
    'AzureIaaSClassicComputeVMProtectedItemResponse',
    'AzureIaaSComputeVMContainerResponse',
    'AzureIaaSComputeVMProtectedItemResponse',
    'AzureIaaSVMHealthDetailsResponse',
    'AzureIaaSVMProtectedItemExtendedInfoResponse',
    'AzureIaaSVMProtectedItemResponse',
    'AzureIaaSVMProtectionPolicyResponse',
    'AzureMonitorAlertSettingsResponse',
    'AzureRecoveryServiceVaultProtectionIntentResponse',
    'AzureResourceProtectionIntentResponse',
    'AzureSQLAGWorkloadContainerProtectionContainerResponse',
    'AzureSqlContainerResponse',
    'AzureSqlProtectedItemExtendedInfoResponse',
    'AzureSqlProtectedItemResponse',
    'AzureSqlProtectionPolicyResponse',
    'AzureStorageContainerResponse',
    'AzureVMAppContainerProtectionContainerResponse',
    'AzureVmWorkloadProtectedItemExtendedInfoResponse',
    'AzureVmWorkloadProtectedItemResponse',
    'AzureVmWorkloadProtectionPolicyResponse',
    'AzureVmWorkloadSAPAseDatabaseProtectedItemResponse',
    'AzureVmWorkloadSAPHanaDBInstanceProtectedItemResponse',
    'AzureVmWorkloadSAPHanaDatabaseProtectedItemResponse',
    'AzureVmWorkloadSQLDatabaseProtectedItemResponse',
    'AzureWorkloadAutoProtectionIntentResponse',
    'AzureWorkloadContainerAutoProtectionIntentResponse',
    'AzureWorkloadContainerExtendedInfoResponse',
    'AzureWorkloadContainerResponse',
    'AzureWorkloadSQLAutoProtectionIntentResponse',
    'ClassicAlertSettingsResponse',
    'CmkKekIdentityResponse',
    'CmkKeyVaultPropertiesResponse',
    'ContainerIdentityInfoResponse',
    'DPMContainerExtendedInfoResponse',
    'DPMProtectedItemExtendedInfoResponse',
    'DPMProtectedItemResponse',
    'DailyRetentionFormatResponse',
    'DailyRetentionScheduleResponse',
    'DailyScheduleResponse',
    'DayResponse',
    'DiskExclusionPropertiesResponse',
    'DistributedNodesInfoResponse',
    'DpmContainerResponse',
    'ErrorDetailResponse',
    'ExtendedPropertiesResponse',
    'GenericContainerExtendedInfoResponse',
    'GenericContainerResponse',
    'GenericProtectedItemResponse',
    'GenericProtectionPolicyResponse',
    'HourlyScheduleResponse',
    'IaaSVMContainerResponse',
    'IdentityDataResponse',
    'ImmutabilitySettingsResponse',
    'InquiryInfoResponse',
    'InquiryValidationResponse',
    'InstantRPAdditionalDetailsResponse',
    'KPIResourceHealthDetailsResponse',
    'LogSchedulePolicyResponse',
    'LongTermRetentionPolicyResponse',
    'LongTermSchedulePolicyResponse',
    'MABContainerHealthDetailsResponse',
    'MabContainerExtendedInfoResponse',
    'MabContainerResponse',
    'MabFileFolderProtectedItemExtendedInfoResponse',
    'MabFileFolderProtectedItemResponse',
    'MabProtectionPolicyResponse',
    'MonitoringSettingsResponse',
    'MonthlyRetentionScheduleResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointConnectionVaultPropertiesResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'ResourceGuardOperationDetailResponse',
    'ResourceGuardProxyBaseResponse',
    'ResourceHealthDetailsResponse',
    'RetentionDurationResponse',
    'SecuritySettingsResponse',
    'SettingsResponse',
    'SimpleRetentionPolicyResponse',
    'SimpleSchedulePolicyResponse',
    'SimpleSchedulePolicyV2Response',
    'SkuResponse',
    'SubProtectionPolicyResponse',
    'SystemDataResponse',
    'TieringPolicyResponse',
    'UpgradeDetailsResponse',
    'UserIdentityResponse',
    'VaultPrivateEndpointConnectionResponse',
    'VaultPrivateLinkServiceConnectionStateResponse',
    'VaultPropertiesResponse',
    'VaultPropertiesResponseEncryption',
    'VaultPropertiesResponseMoveDetails',
    'VaultPropertiesResponseRedundancySettings',
    'WeeklyRetentionFormatResponse',
    'WeeklyRetentionScheduleResponse',
    'WeeklyScheduleResponse',
    'WorkloadInquiryDetailsResponse',
    'YearlyRetentionScheduleResponse',
]

@pulumi.output_type
class AzureBackupServerContainerResponse(dict):
    """
    AzureBackupServer (DPMVenus) workload-specific protection container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerType":
            suggest = "container_type"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "canReRegister":
            suggest = "can_re_register"
        elif key == "containerId":
            suggest = "container_id"
        elif key == "dpmAgentVersion":
            suggest = "dpm_agent_version"
        elif key == "dpmServers":
            suggest = "dpm_servers"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "protectableObjectType":
            suggest = "protectable_object_type"
        elif key == "protectedItemCount":
            suggest = "protected_item_count"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "upgradeAvailable":
            suggest = "upgrade_available"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureBackupServerContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureBackupServerContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureBackupServerContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_type: str,
                 backup_management_type: Optional[str] = None,
                 can_re_register: Optional[bool] = None,
                 container_id: Optional[str] = None,
                 dpm_agent_version: Optional[str] = None,
                 dpm_servers: Optional[Sequence[str]] = None,
                 extended_info: Optional['outputs.DPMContainerExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 protectable_object_type: Optional[str] = None,
                 protected_item_count: Optional[float] = None,
                 protection_status: Optional[str] = None,
                 registration_status: Optional[str] = None,
                 upgrade_available: Optional[bool] = None):
        """
        AzureBackupServer (DPMVenus) workload-specific protection container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'AzureBackupServerContainer'.
        :param str backup_management_type: Type of backup management for the container.
        :param bool can_re_register: Specifies whether the container is re-registrable.
        :param str container_id: ID of container.
        :param str dpm_agent_version: Backup engine Agent version
        :param Sequence[str] dpm_servers: List of BackupEngines protecting the container
        :param 'DPMContainerExtendedInfoResponse' extended_info: Extended Info of the container.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str protectable_object_type: Type of the protectable object associated with this container
        :param float protected_item_count: Number of protected items in the BackupEngine
        :param str protection_status: Protection status of the container.
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param bool upgrade_available: To check if upgrade available
        """
        pulumi.set(__self__, "container_type", 'AzureBackupServerContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if can_re_register is not None:
            pulumi.set(__self__, "can_re_register", can_re_register)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if dpm_agent_version is not None:
            pulumi.set(__self__, "dpm_agent_version", dpm_agent_version)
        if dpm_servers is not None:
            pulumi.set(__self__, "dpm_servers", dpm_servers)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protectable_object_type is not None:
            pulumi.set(__self__, "protectable_object_type", protectable_object_type)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if upgrade_available is not None:
            pulumi.set(__self__, "upgrade_available", upgrade_available)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> str:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'AzureBackupServerContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="canReRegister")
    def can_re_register(self) -> Optional[bool]:
        """
        Specifies whether the container is re-registrable.
        """
        return pulumi.get(self, "can_re_register")

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[str]:
        """
        ID of container.
        """
        return pulumi.get(self, "container_id")

    @property
    @pulumi.getter(name="dpmAgentVersion")
    def dpm_agent_version(self) -> Optional[str]:
        """
        Backup engine Agent version
        """
        return pulumi.get(self, "dpm_agent_version")

    @property
    @pulumi.getter(name="dpmServers")
    def dpm_servers(self) -> Optional[Sequence[str]]:
        """
        List of BackupEngines protecting the container
        """
        return pulumi.get(self, "dpm_servers")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.DPMContainerExtendedInfoResponse']:
        """
        Extended Info of the container.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="protectableObjectType")
    def protectable_object_type(self) -> Optional[str]:
        """
        Type of the protectable object associated with this container
        """
        return pulumi.get(self, "protectable_object_type")

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[float]:
        """
        Number of protected items in the BackupEngine
        """
        return pulumi.get(self, "protected_item_count")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[str]:
        """
        Protection status of the container.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="upgradeAvailable")
    def upgrade_available(self) -> Optional[bool]:
        """
        To check if upgrade available
        """
        return pulumi.get(self, "upgrade_available")


@pulumi.output_type
class AzureFileShareProtectionPolicyResponse(dict):
    """
    AzureStorage backup policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "protectedItemsCount":
            suggest = "protected_items_count"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "retentionPolicy":
            suggest = "retention_policy"
        elif key == "schedulePolicy":
            suggest = "schedule_policy"
        elif key == "timeZone":
            suggest = "time_zone"
        elif key == "workLoadType":
            suggest = "work_load_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFileShareProtectionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFileShareProtectionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFileShareProtectionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 protected_items_count: Optional[int] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 retention_policy: Optional[Any] = None,
                 schedule_policy: Optional[Any] = None,
                 time_zone: Optional[str] = None,
                 work_load_type: Optional[str] = None):
        """
        AzureStorage backup policy.
        :param str backup_management_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'AzureStorage'.
        :param int protected_items_count: Number of items associated with this policy.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuard Operation Requests
        :param Union['LongTermRetentionPolicyResponse', 'SimpleRetentionPolicyResponse'] retention_policy: Retention policy with the details on backup copy retention ranges.
        :param Union['LogSchedulePolicyResponse', 'LongTermSchedulePolicyResponse', 'SimpleSchedulePolicyResponse', 'SimpleSchedulePolicyV2Response'] schedule_policy: Backup schedule specified as part of backup policy.
        :param str time_zone: TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
        :param str work_load_type: Type of workload for the backup management
        """
        pulumi.set(__self__, "backup_management_type", 'AzureStorage')
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if schedule_policy is not None:
            pulumi.set(__self__, "schedule_policy", schedule_policy)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if work_load_type is not None:
            pulumi.set(__self__, "work_load_type", work_load_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'AzureStorage'.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[int]:
        """
        Number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuard Operation Requests
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[Any]:
        """
        Retention policy with the details on backup copy retention ranges.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter(name="schedulePolicy")
    def schedule_policy(self) -> Optional[Any]:
        """
        Backup schedule specified as part of backup policy.
        """
        return pulumi.get(self, "schedule_policy")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="workLoadType")
    def work_load_type(self) -> Optional[str]:
        """
        Type of workload for the backup management
        """
        return pulumi.get(self, "work_load_type")


@pulumi.output_type
class AzureFileshareProtectedItemExtendedInfoResponse(dict):
    """
    Additional information about Azure File Share backup item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceState":
            suggest = "resource_state"
        elif key == "resourceStateSyncTime":
            suggest = "resource_state_sync_time"
        elif key == "oldestRecoveryPoint":
            suggest = "oldest_recovery_point"
        elif key == "policyState":
            suggest = "policy_state"
        elif key == "recoveryPointCount":
            suggest = "recovery_point_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFileshareProtectedItemExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFileshareProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFileshareProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_state: str,
                 resource_state_sync_time: str,
                 oldest_recovery_point: Optional[str] = None,
                 policy_state: Optional[str] = None,
                 recovery_point_count: Optional[int] = None):
        """
        Additional information about Azure File Share backup item.
        :param str resource_state: Indicates the state of this resource. Possible values are from enum ResourceState {Invalid, Active, SoftDeleted, Deleted}
        :param str resource_state_sync_time: The resource state sync time for this backup item.
        :param str oldest_recovery_point: The oldest backup copy available for this item in the service.
        :param str policy_state: Indicates consistency of policy object and policy applied to this backup item.
        :param int recovery_point_count: Number of available backup copies associated with this backup item.
        """
        pulumi.set(__self__, "resource_state", resource_state)
        pulumi.set(__self__, "resource_state_sync_time", resource_state_sync_time)
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if policy_state is not None:
            pulumi.set(__self__, "policy_state", policy_state)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="resourceState")
    def resource_state(self) -> str:
        """
        Indicates the state of this resource. Possible values are from enum ResourceState {Invalid, Active, SoftDeleted, Deleted}
        """
        return pulumi.get(self, "resource_state")

    @property
    @pulumi.getter(name="resourceStateSyncTime")
    def resource_state_sync_time(self) -> str:
        """
        The resource state sync time for this backup item.
        """
        return pulumi.get(self, "resource_state_sync_time")

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[str]:
        """
        The oldest backup copy available for this item in the service.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @property
    @pulumi.getter(name="policyState")
    def policy_state(self) -> Optional[str]:
        """
        Indicates consistency of policy object and policy applied to this backup item.
        """
        return pulumi.get(self, "policy_state")

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[int]:
        """
        Number of available backup copies associated with this backup item.
        """
        return pulumi.get(self, "recovery_point_count")


@pulumi.output_type
class AzureFileshareProtectedItemResponse(dict):
    """
    Azure File Share workload-specific backup item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "workloadType":
            suggest = "workload_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "kpisHealths":
            suggest = "kpis_healths"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "softDeleteRetentionPeriod":
            suggest = "soft_delete_retention_period"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFileshareProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFileshareProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFileshareProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 protected_item_type: str,
                 workload_type: str,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureFileshareProtectedItemExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 is_archive_enabled: Optional[bool] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 kpis_healths: Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']] = None,
                 last_backup_status: Optional[str] = None,
                 last_backup_time: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 protection_status: Optional[str] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 soft_delete_retention_period: Optional[int] = None,
                 source_resource_id: Optional[str] = None):
        """
        Azure File Share workload-specific backup item.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str protected_item_type: backup item type.
               Expected value is 'AzureFileShareProtectedItem'.
        :param str workload_type: Type of workload this item represents.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureFileshareProtectedItemExtendedInfoResponse' extended_info: Additional information with this backup item.
        :param str friendly_name: Friendly name of the fileshare represented by this backup item.
        :param bool is_archive_enabled: Flag to identify whether datasource is protected in archive
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param Mapping[str, 'KPIResourceHealthDetailsResponse'] kpis_healths: Health details of different KPIs
        :param str last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str policy_name: Name of the policy used for protection
        :param str protection_state: Backup state of this backup item.
        :param str protection_status: Backup status of this backup item.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will be performed
        :param int soft_delete_retention_period: Soft delete retention period in days
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "backup_management_type", backup_management_type)
        pulumi.set(__self__, "protected_item_type", 'AzureFileShareProtectedItem')
        pulumi.set(__self__, "workload_type", workload_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if soft_delete_retention_period is not None:
            pulumi.set(__self__, "soft_delete_retention_period", soft_delete_retention_period)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> str:
        """
        backup item type.
        Expected value is 'AzureFileShareProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> str:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureFileshareProtectedItemExtendedInfoResponse']:
        """
        Additional information with this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the fileshare represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        Flag to identify whether datasource is protected in archive
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[str]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Name of the policy used for protection
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[str]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuardOperationRequests on which LAC check will be performed
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="softDeleteRetentionPeriod")
    def soft_delete_retention_period(self) -> Optional[int]:
        """
        Soft delete retention period in days
        """
        return pulumi.get(self, "soft_delete_retention_period")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class AzureIaaSClassicComputeVMContainerResponse(dict):
    """
    IaaS VM workload-specific backup item representing a classic virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerType":
            suggest = "container_type"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "protectableObjectType":
            suggest = "protectable_object_type"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "virtualMachineId":
            suggest = "virtual_machine_id"
        elif key == "virtualMachineVersion":
            suggest = "virtual_machine_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureIaaSClassicComputeVMContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureIaaSClassicComputeVMContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureIaaSClassicComputeVMContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_type: str,
                 backup_management_type: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 protectable_object_type: Optional[str] = None,
                 registration_status: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 virtual_machine_id: Optional[str] = None,
                 virtual_machine_version: Optional[str] = None):
        """
        IaaS VM workload-specific backup item representing a classic virtual machine.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
        :param str backup_management_type: Type of backup management for the container.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str protectable_object_type: Type of the protectable object associated with this container
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param str resource_group: Resource group name of Recovery Services Vault.
        :param str virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        :param str virtual_machine_version: Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        pulumi.set(__self__, "container_type", 'Microsoft.ClassicCompute/virtualMachines')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protectable_object_type is not None:
            pulumi.set(__self__, "protectable_object_type", protectable_object_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if virtual_machine_version is not None:
            pulumi.set(__self__, "virtual_machine_version", virtual_machine_version)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> str:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="protectableObjectType")
    def protectable_object_type(self) -> Optional[str]:
        """
        Type of the protectable object associated with this container
        """
        return pulumi.get(self, "protectable_object_type")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Resource group name of Recovery Services Vault.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[str]:
        """
        Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        """
        return pulumi.get(self, "virtual_machine_id")

    @property
    @pulumi.getter(name="virtualMachineVersion")
    def virtual_machine_version(self) -> Optional[str]:
        """
        Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        return pulumi.get(self, "virtual_machine_version")


@pulumi.output_type
class AzureIaaSClassicComputeVMProtectedItemResponse(dict):
    """
    IaaS VM workload-specific backup item representing the Classic Compute VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "protectedItemDataId":
            suggest = "protected_item_data_id"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "virtualMachineId":
            suggest = "virtual_machine_id"
        elif key == "workloadType":
            suggest = "workload_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "extendedProperties":
            suggest = "extended_properties"
        elif key == "healthDetails":
            suggest = "health_details"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "kpisHealths":
            suggest = "kpis_healths"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "softDeleteRetentionPeriod":
            suggest = "soft_delete_retention_period"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureIaaSClassicComputeVMProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureIaaSClassicComputeVMProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureIaaSClassicComputeVMProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 friendly_name: str,
                 health_status: str,
                 last_backup_time: str,
                 protected_item_data_id: str,
                 protected_item_type: str,
                 virtual_machine_id: str,
                 workload_type: str,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureIaaSVMProtectedItemExtendedInfoResponse'] = None,
                 extended_properties: Optional['outputs.ExtendedPropertiesResponse'] = None,
                 health_details: Optional[Sequence['outputs.AzureIaaSVMHealthDetailsResponse']] = None,
                 is_archive_enabled: Optional[bool] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 kpis_healths: Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']] = None,
                 last_backup_status: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 protection_status: Optional[str] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 soft_delete_retention_period: Optional[int] = None,
                 source_resource_id: Optional[str] = None):
        """
        IaaS VM workload-specific backup item representing the Classic Compute VM.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str friendly_name: Friendly name of the VM represented by this backup item.
        :param str health_status: Health status of protected item.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str protected_item_data_id: Data ID of the protected item.
        :param str protected_item_type: backup item type.
               Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
        :param str virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this item.
        :param str workload_type: Type of workload this item represents.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureIaaSVMProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param 'ExtendedPropertiesResponse' extended_properties: Extended Properties for Azure IaasVM Backup.
        :param Sequence['AzureIaaSVMHealthDetailsResponse'] health_details: Health details on this backup item.
        :param bool is_archive_enabled: Flag to identify whether datasource is protected in archive
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param Mapping[str, 'KPIResourceHealthDetailsResponse'] kpis_healths: Health details of different KPIs
        :param str last_backup_status: Last backup operation status.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str policy_name: Name of the policy used for protection
        :param str protection_state: Backup state of this backup item.
        :param str protection_status: Backup status of this backup item.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will be performed
        :param int soft_delete_retention_period: Soft delete retention period in days
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "backup_management_type", backup_management_type)
        pulumi.set(__self__, "friendly_name", friendly_name)
        pulumi.set(__self__, "health_status", health_status)
        pulumi.set(__self__, "last_backup_time", last_backup_time)
        pulumi.set(__self__, "protected_item_data_id", protected_item_data_id)
        pulumi.set(__self__, "protected_item_type", 'Microsoft.ClassicCompute/virtualMachines')
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        pulumi.set(__self__, "workload_type", workload_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if extended_properties is not None:
            pulumi.set(__self__, "extended_properties", extended_properties)
        if health_details is not None:
            pulumi.set(__self__, "health_details", health_details)
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if soft_delete_retention_period is not None:
            pulumi.set(__self__, "soft_delete_retention_period", soft_delete_retention_period)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> str:
        """
        Friendly name of the VM represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> str:
        """
        Health status of protected item.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> str:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="protectedItemDataId")
    def protected_item_data_id(self) -> str:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_id")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> str:
        """
        backup item type.
        Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> str:
        """
        Fully qualified ARM ID of the virtual machine represented by this item.
        """
        return pulumi.get(self, "virtual_machine_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> str:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureIaaSVMProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="extendedProperties")
    def extended_properties(self) -> Optional['outputs.ExtendedPropertiesResponse']:
        """
        Extended Properties for Azure IaasVM Backup.
        """
        return pulumi.get(self, "extended_properties")

    @property
    @pulumi.getter(name="healthDetails")
    def health_details(self) -> Optional[Sequence['outputs.AzureIaaSVMHealthDetailsResponse']]:
        """
        Health details on this backup item.
        """
        return pulumi.get(self, "health_details")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        Flag to identify whether datasource is protected in archive
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Name of the policy used for protection
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[str]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuardOperationRequests on which LAC check will be performed
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="softDeleteRetentionPeriod")
    def soft_delete_retention_period(self) -> Optional[int]:
        """
        Soft delete retention period in days
        """
        return pulumi.get(self, "soft_delete_retention_period")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class AzureIaaSComputeVMContainerResponse(dict):
    """
    IaaS VM workload-specific backup item representing an Azure Resource Manager virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerType":
            suggest = "container_type"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "protectableObjectType":
            suggest = "protectable_object_type"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "virtualMachineId":
            suggest = "virtual_machine_id"
        elif key == "virtualMachineVersion":
            suggest = "virtual_machine_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureIaaSComputeVMContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureIaaSComputeVMContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureIaaSComputeVMContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_type: str,
                 backup_management_type: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 protectable_object_type: Optional[str] = None,
                 registration_status: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 virtual_machine_id: Optional[str] = None,
                 virtual_machine_version: Optional[str] = None):
        """
        IaaS VM workload-specific backup item representing an Azure Resource Manager virtual machine.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'Microsoft.Compute/virtualMachines'.
        :param str backup_management_type: Type of backup management for the container.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str protectable_object_type: Type of the protectable object associated with this container
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param str resource_group: Resource group name of Recovery Services Vault.
        :param str virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        :param str virtual_machine_version: Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        pulumi.set(__self__, "container_type", 'Microsoft.Compute/virtualMachines')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protectable_object_type is not None:
            pulumi.set(__self__, "protectable_object_type", protectable_object_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if virtual_machine_version is not None:
            pulumi.set(__self__, "virtual_machine_version", virtual_machine_version)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> str:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'Microsoft.Compute/virtualMachines'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="protectableObjectType")
    def protectable_object_type(self) -> Optional[str]:
        """
        Type of the protectable object associated with this container
        """
        return pulumi.get(self, "protectable_object_type")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Resource group name of Recovery Services Vault.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[str]:
        """
        Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        """
        return pulumi.get(self, "virtual_machine_id")

    @property
    @pulumi.getter(name="virtualMachineVersion")
    def virtual_machine_version(self) -> Optional[str]:
        """
        Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        return pulumi.get(self, "virtual_machine_version")


@pulumi.output_type
class AzureIaaSComputeVMProtectedItemResponse(dict):
    """
    IaaS VM workload-specific backup item representing the Azure Resource Manager VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "protectedItemDataId":
            suggest = "protected_item_data_id"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "virtualMachineId":
            suggest = "virtual_machine_id"
        elif key == "workloadType":
            suggest = "workload_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "extendedProperties":
            suggest = "extended_properties"
        elif key == "healthDetails":
            suggest = "health_details"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "kpisHealths":
            suggest = "kpis_healths"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "softDeleteRetentionPeriod":
            suggest = "soft_delete_retention_period"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureIaaSComputeVMProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureIaaSComputeVMProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureIaaSComputeVMProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 friendly_name: str,
                 health_status: str,
                 last_backup_time: str,
                 protected_item_data_id: str,
                 protected_item_type: str,
                 virtual_machine_id: str,
                 workload_type: str,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureIaaSVMProtectedItemExtendedInfoResponse'] = None,
                 extended_properties: Optional['outputs.ExtendedPropertiesResponse'] = None,
                 health_details: Optional[Sequence['outputs.AzureIaaSVMHealthDetailsResponse']] = None,
                 is_archive_enabled: Optional[bool] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 kpis_healths: Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']] = None,
                 last_backup_status: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 protection_status: Optional[str] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 soft_delete_retention_period: Optional[int] = None,
                 source_resource_id: Optional[str] = None):
        """
        IaaS VM workload-specific backup item representing the Azure Resource Manager VM.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str friendly_name: Friendly name of the VM represented by this backup item.
        :param str health_status: Health status of protected item.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str protected_item_data_id: Data ID of the protected item.
        :param str protected_item_type: backup item type.
               Expected value is 'Microsoft.Compute/virtualMachines'.
        :param str virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this item.
        :param str workload_type: Type of workload this item represents.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureIaaSVMProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param 'ExtendedPropertiesResponse' extended_properties: Extended Properties for Azure IaasVM Backup.
        :param Sequence['AzureIaaSVMHealthDetailsResponse'] health_details: Health details on this backup item.
        :param bool is_archive_enabled: Flag to identify whether datasource is protected in archive
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param Mapping[str, 'KPIResourceHealthDetailsResponse'] kpis_healths: Health details of different KPIs
        :param str last_backup_status: Last backup operation status.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str policy_name: Name of the policy used for protection
        :param str protection_state: Backup state of this backup item.
        :param str protection_status: Backup status of this backup item.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will be performed
        :param int soft_delete_retention_period: Soft delete retention period in days
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "backup_management_type", backup_management_type)
        pulumi.set(__self__, "friendly_name", friendly_name)
        pulumi.set(__self__, "health_status", health_status)
        pulumi.set(__self__, "last_backup_time", last_backup_time)
        pulumi.set(__self__, "protected_item_data_id", protected_item_data_id)
        pulumi.set(__self__, "protected_item_type", 'Microsoft.Compute/virtualMachines')
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        pulumi.set(__self__, "workload_type", workload_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if extended_properties is not None:
            pulumi.set(__self__, "extended_properties", extended_properties)
        if health_details is not None:
            pulumi.set(__self__, "health_details", health_details)
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if soft_delete_retention_period is not None:
            pulumi.set(__self__, "soft_delete_retention_period", soft_delete_retention_period)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> str:
        """
        Friendly name of the VM represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> str:
        """
        Health status of protected item.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> str:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="protectedItemDataId")
    def protected_item_data_id(self) -> str:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_id")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> str:
        """
        backup item type.
        Expected value is 'Microsoft.Compute/virtualMachines'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> str:
        """
        Fully qualified ARM ID of the virtual machine represented by this item.
        """
        return pulumi.get(self, "virtual_machine_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> str:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureIaaSVMProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="extendedProperties")
    def extended_properties(self) -> Optional['outputs.ExtendedPropertiesResponse']:
        """
        Extended Properties for Azure IaasVM Backup.
        """
        return pulumi.get(self, "extended_properties")

    @property
    @pulumi.getter(name="healthDetails")
    def health_details(self) -> Optional[Sequence['outputs.AzureIaaSVMHealthDetailsResponse']]:
        """
        Health details on this backup item.
        """
        return pulumi.get(self, "health_details")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        Flag to identify whether datasource is protected in archive
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Name of the policy used for protection
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[str]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuardOperationRequests on which LAC check will be performed
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="softDeleteRetentionPeriod")
    def soft_delete_retention_period(self) -> Optional[int]:
        """
        Soft delete retention period in days
        """
        return pulumi.get(self, "soft_delete_retention_period")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class AzureIaaSVMHealthDetailsResponse(dict):
    """
    Azure IaaS VM workload-specific Health Details.
    """
    def __init__(__self__, *,
                 code: int,
                 message: str,
                 recommendations: Sequence[str],
                 title: str):
        """
        Azure IaaS VM workload-specific Health Details.
        :param int code: Health Code
        :param str message: Health Message
        :param Sequence[str] recommendations: Health Recommended Actions
        :param str title: Health Title
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "recommendations", recommendations)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        Health Code
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Health Message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def recommendations(self) -> Sequence[str]:
        """
        Health Recommended Actions
        """
        return pulumi.get(self, "recommendations")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Health Title
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class AzureIaaSVMProtectedItemExtendedInfoResponse(dict):
    """
    Additional information on Azure IaaS VM specific backup item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newestRecoveryPointInArchive":
            suggest = "newest_recovery_point_in_archive"
        elif key == "oldestRecoveryPoint":
            suggest = "oldest_recovery_point"
        elif key == "oldestRecoveryPointInArchive":
            suggest = "oldest_recovery_point_in_archive"
        elif key == "oldestRecoveryPointInVault":
            suggest = "oldest_recovery_point_in_vault"
        elif key == "policyInconsistent":
            suggest = "policy_inconsistent"
        elif key == "recoveryPointCount":
            suggest = "recovery_point_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureIaaSVMProtectedItemExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureIaaSVMProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureIaaSVMProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 newest_recovery_point_in_archive: Optional[str] = None,
                 oldest_recovery_point: Optional[str] = None,
                 oldest_recovery_point_in_archive: Optional[str] = None,
                 oldest_recovery_point_in_vault: Optional[str] = None,
                 policy_inconsistent: Optional[bool] = None,
                 recovery_point_count: Optional[int] = None):
        """
        Additional information on Azure IaaS VM specific backup item.
        :param str newest_recovery_point_in_archive: The latest backup copy available for this backup item in archive tier
        :param str oldest_recovery_point: The oldest backup copy available for this backup item across all tiers.
        :param str oldest_recovery_point_in_archive: The oldest backup copy available for this backup item in archive tier
        :param str oldest_recovery_point_in_vault: The oldest backup copy available for this backup item in vault tier
        :param bool policy_inconsistent: Specifies if backup policy associated with the backup item is inconsistent.
        :param int recovery_point_count: Number of backup copies available for this backup item.
        """
        if newest_recovery_point_in_archive is not None:
            pulumi.set(__self__, "newest_recovery_point_in_archive", newest_recovery_point_in_archive)
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if oldest_recovery_point_in_archive is not None:
            pulumi.set(__self__, "oldest_recovery_point_in_archive", oldest_recovery_point_in_archive)
        if oldest_recovery_point_in_vault is not None:
            pulumi.set(__self__, "oldest_recovery_point_in_vault", oldest_recovery_point_in_vault)
        if policy_inconsistent is not None:
            pulumi.set(__self__, "policy_inconsistent", policy_inconsistent)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="newestRecoveryPointInArchive")
    def newest_recovery_point_in_archive(self) -> Optional[str]:
        """
        The latest backup copy available for this backup item in archive tier
        """
        return pulumi.get(self, "newest_recovery_point_in_archive")

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[str]:
        """
        The oldest backup copy available for this backup item across all tiers.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @property
    @pulumi.getter(name="oldestRecoveryPointInArchive")
    def oldest_recovery_point_in_archive(self) -> Optional[str]:
        """
        The oldest backup copy available for this backup item in archive tier
        """
        return pulumi.get(self, "oldest_recovery_point_in_archive")

    @property
    @pulumi.getter(name="oldestRecoveryPointInVault")
    def oldest_recovery_point_in_vault(self) -> Optional[str]:
        """
        The oldest backup copy available for this backup item in vault tier
        """
        return pulumi.get(self, "oldest_recovery_point_in_vault")

    @property
    @pulumi.getter(name="policyInconsistent")
    def policy_inconsistent(self) -> Optional[bool]:
        """
        Specifies if backup policy associated with the backup item is inconsistent.
        """
        return pulumi.get(self, "policy_inconsistent")

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[int]:
        """
        Number of backup copies available for this backup item.
        """
        return pulumi.get(self, "recovery_point_count")


@pulumi.output_type
class AzureIaaSVMProtectedItemResponse(dict):
    """
    IaaS VM workload-specific backup item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "protectedItemDataId":
            suggest = "protected_item_data_id"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "virtualMachineId":
            suggest = "virtual_machine_id"
        elif key == "workloadType":
            suggest = "workload_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "extendedProperties":
            suggest = "extended_properties"
        elif key == "healthDetails":
            suggest = "health_details"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "kpisHealths":
            suggest = "kpis_healths"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "softDeleteRetentionPeriod":
            suggest = "soft_delete_retention_period"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureIaaSVMProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureIaaSVMProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureIaaSVMProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 friendly_name: str,
                 health_status: str,
                 last_backup_time: str,
                 protected_item_data_id: str,
                 protected_item_type: str,
                 virtual_machine_id: str,
                 workload_type: str,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureIaaSVMProtectedItemExtendedInfoResponse'] = None,
                 extended_properties: Optional['outputs.ExtendedPropertiesResponse'] = None,
                 health_details: Optional[Sequence['outputs.AzureIaaSVMHealthDetailsResponse']] = None,
                 is_archive_enabled: Optional[bool] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 kpis_healths: Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']] = None,
                 last_backup_status: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 protection_status: Optional[str] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 soft_delete_retention_period: Optional[int] = None,
                 source_resource_id: Optional[str] = None):
        """
        IaaS VM workload-specific backup item.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str friendly_name: Friendly name of the VM represented by this backup item.
        :param str health_status: Health status of protected item.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str protected_item_data_id: Data ID of the protected item.
        :param str protected_item_type: backup item type.
               Expected value is 'AzureIaaSVMProtectedItem'.
        :param str virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this item.
        :param str workload_type: Type of workload this item represents.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureIaaSVMProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param 'ExtendedPropertiesResponse' extended_properties: Extended Properties for Azure IaasVM Backup.
        :param Sequence['AzureIaaSVMHealthDetailsResponse'] health_details: Health details on this backup item.
        :param bool is_archive_enabled: Flag to identify whether datasource is protected in archive
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param Mapping[str, 'KPIResourceHealthDetailsResponse'] kpis_healths: Health details of different KPIs
        :param str last_backup_status: Last backup operation status.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str policy_name: Name of the policy used for protection
        :param str protection_state: Backup state of this backup item.
        :param str protection_status: Backup status of this backup item.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will be performed
        :param int soft_delete_retention_period: Soft delete retention period in days
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "backup_management_type", backup_management_type)
        pulumi.set(__self__, "friendly_name", friendly_name)
        pulumi.set(__self__, "health_status", health_status)
        pulumi.set(__self__, "last_backup_time", last_backup_time)
        pulumi.set(__self__, "protected_item_data_id", protected_item_data_id)
        pulumi.set(__self__, "protected_item_type", 'AzureIaaSVMProtectedItem')
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        pulumi.set(__self__, "workload_type", workload_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if extended_properties is not None:
            pulumi.set(__self__, "extended_properties", extended_properties)
        if health_details is not None:
            pulumi.set(__self__, "health_details", health_details)
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if soft_delete_retention_period is not None:
            pulumi.set(__self__, "soft_delete_retention_period", soft_delete_retention_period)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> str:
        """
        Friendly name of the VM represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> str:
        """
        Health status of protected item.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> str:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="protectedItemDataId")
    def protected_item_data_id(self) -> str:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_id")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> str:
        """
        backup item type.
        Expected value is 'AzureIaaSVMProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> str:
        """
        Fully qualified ARM ID of the virtual machine represented by this item.
        """
        return pulumi.get(self, "virtual_machine_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> str:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureIaaSVMProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="extendedProperties")
    def extended_properties(self) -> Optional['outputs.ExtendedPropertiesResponse']:
        """
        Extended Properties for Azure IaasVM Backup.
        """
        return pulumi.get(self, "extended_properties")

    @property
    @pulumi.getter(name="healthDetails")
    def health_details(self) -> Optional[Sequence['outputs.AzureIaaSVMHealthDetailsResponse']]:
        """
        Health details on this backup item.
        """
        return pulumi.get(self, "health_details")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        Flag to identify whether datasource is protected in archive
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Name of the policy used for protection
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[str]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuardOperationRequests on which LAC check will be performed
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="softDeleteRetentionPeriod")
    def soft_delete_retention_period(self) -> Optional[int]:
        """
        Soft delete retention period in days
        """
        return pulumi.get(self, "soft_delete_retention_period")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class AzureIaaSVMProtectionPolicyResponse(dict):
    """
    IaaS VM workload-specific backup policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "instantRPDetails":
            suggest = "instant_rp_details"
        elif key == "instantRpRetentionRangeInDays":
            suggest = "instant_rp_retention_range_in_days"
        elif key == "policyType":
            suggest = "policy_type"
        elif key == "protectedItemsCount":
            suggest = "protected_items_count"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "retentionPolicy":
            suggest = "retention_policy"
        elif key == "schedulePolicy":
            suggest = "schedule_policy"
        elif key == "tieringPolicy":
            suggest = "tiering_policy"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureIaaSVMProtectionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureIaaSVMProtectionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureIaaSVMProtectionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 instant_rp_details: Optional['outputs.InstantRPAdditionalDetailsResponse'] = None,
                 instant_rp_retention_range_in_days: Optional[int] = None,
                 policy_type: Optional[str] = None,
                 protected_items_count: Optional[int] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 retention_policy: Optional[Any] = None,
                 schedule_policy: Optional[Any] = None,
                 tiering_policy: Optional[Mapping[str, 'outputs.TieringPolicyResponse']] = None,
                 time_zone: Optional[str] = None):
        """
        IaaS VM workload-specific backup policy.
        :param str backup_management_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'AzureIaasVM'.
        :param int instant_rp_retention_range_in_days: Instant RP retention policy range in days
        :param int protected_items_count: Number of items associated with this policy.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuard Operation Requests
        :param Union['LongTermRetentionPolicyResponse', 'SimpleRetentionPolicyResponse'] retention_policy: Retention policy with the details on backup copy retention ranges.
        :param Union['LogSchedulePolicyResponse', 'LongTermSchedulePolicyResponse', 'SimpleSchedulePolicyResponse', 'SimpleSchedulePolicyV2Response'] schedule_policy: Backup schedule specified as part of backup policy.
        :param Mapping[str, 'TieringPolicyResponse'] tiering_policy: Tiering policy to automatically move RPs to another tier
               Key is Target Tier, defined in RecoveryPointTierType enum.
               Tiering policy specifies the criteria to move RP to the target tier.
        :param str time_zone: TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
        """
        pulumi.set(__self__, "backup_management_type", 'AzureIaasVM')
        if instant_rp_details is not None:
            pulumi.set(__self__, "instant_rp_details", instant_rp_details)
        if instant_rp_retention_range_in_days is not None:
            pulumi.set(__self__, "instant_rp_retention_range_in_days", instant_rp_retention_range_in_days)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if schedule_policy is not None:
            pulumi.set(__self__, "schedule_policy", schedule_policy)
        if tiering_policy is not None:
            pulumi.set(__self__, "tiering_policy", tiering_policy)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'AzureIaasVM'.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="instantRPDetails")
    def instant_rp_details(self) -> Optional['outputs.InstantRPAdditionalDetailsResponse']:
        return pulumi.get(self, "instant_rp_details")

    @property
    @pulumi.getter(name="instantRpRetentionRangeInDays")
    def instant_rp_retention_range_in_days(self) -> Optional[int]:
        """
        Instant RP retention policy range in days
        """
        return pulumi.get(self, "instant_rp_retention_range_in_days")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[str]:
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[int]:
        """
        Number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuard Operation Requests
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[Any]:
        """
        Retention policy with the details on backup copy retention ranges.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter(name="schedulePolicy")
    def schedule_policy(self) -> Optional[Any]:
        """
        Backup schedule specified as part of backup policy.
        """
        return pulumi.get(self, "schedule_policy")

    @property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> Optional[Mapping[str, 'outputs.TieringPolicyResponse']]:
        """
        Tiering policy to automatically move RPs to another tier
        Key is Target Tier, defined in RecoveryPointTierType enum.
        Tiering policy specifies the criteria to move RP to the target tier.
        """
        return pulumi.get(self, "tiering_policy")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class AzureMonitorAlertSettingsResponse(dict):
    """
    Settings for Azure Monitor based alerts
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertsForAllJobFailures":
            suggest = "alerts_for_all_job_failures"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureMonitorAlertSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureMonitorAlertSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureMonitorAlertSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alerts_for_all_job_failures: Optional[str] = None):
        """
        Settings for Azure Monitor based alerts
        """
        if alerts_for_all_job_failures is not None:
            pulumi.set(__self__, "alerts_for_all_job_failures", alerts_for_all_job_failures)

    @property
    @pulumi.getter(name="alertsForAllJobFailures")
    def alerts_for_all_job_failures(self) -> Optional[str]:
        return pulumi.get(self, "alerts_for_all_job_failures")


@pulumi.output_type
class AzureRecoveryServiceVaultProtectionIntentResponse(dict):
    """
    Azure Recovery Services Vault specific protection intent item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protectionIntentItemType":
            suggest = "protection_intent_item_type"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "itemId":
            suggest = "item_id"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureRecoveryServiceVaultProtectionIntentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureRecoveryServiceVaultProtectionIntentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureRecoveryServiceVaultProtectionIntentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protection_intent_item_type: str,
                 backup_management_type: Optional[str] = None,
                 item_id: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 source_resource_id: Optional[str] = None):
        """
        Azure Recovery Services Vault specific protection intent item.
        :param str protection_intent_item_type: backup protectionIntent type.
               Expected value is 'RecoveryServiceVaultItem'.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str item_id: ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str protection_state: Backup state of this backup item.
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "protection_intent_item_type", 'RecoveryServiceVaultItem')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if item_id is not None:
            pulumi.set(__self__, "item_id", item_id)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="protectionIntentItemType")
    def protection_intent_item_type(self) -> str:
        """
        backup protectionIntent type.
        Expected value is 'RecoveryServiceVaultItem'.
        """
        return pulumi.get(self, "protection_intent_item_type")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="itemId")
    def item_id(self) -> Optional[str]:
        """
        ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
        """
        return pulumi.get(self, "item_id")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class AzureResourceProtectionIntentResponse(dict):
    """
    IaaS VM specific backup protection intent item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protectionIntentItemType":
            suggest = "protection_intent_item_type"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "itemId":
            suggest = "item_id"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureResourceProtectionIntentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureResourceProtectionIntentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureResourceProtectionIntentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protection_intent_item_type: str,
                 backup_management_type: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 item_id: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 source_resource_id: Optional[str] = None):
        """
        IaaS VM specific backup protection intent item.
        :param str protection_intent_item_type: backup protectionIntent type.
               Expected value is 'AzureResourceItem'.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str friendly_name: Friendly name of the VM represented by this backup item.
        :param str item_id: ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str protection_state: Backup state of this backup item.
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "protection_intent_item_type", 'AzureResourceItem')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if item_id is not None:
            pulumi.set(__self__, "item_id", item_id)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="protectionIntentItemType")
    def protection_intent_item_type(self) -> str:
        """
        backup protectionIntent type.
        Expected value is 'AzureResourceItem'.
        """
        return pulumi.get(self, "protection_intent_item_type")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the VM represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="itemId")
    def item_id(self) -> Optional[str]:
        """
        ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
        """
        return pulumi.get(self, "item_id")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class AzureSQLAGWorkloadContainerProtectionContainerResponse(dict):
    """
    Container for SQL workloads under SQL Availability Group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerType":
            suggest = "container_type"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "lastUpdatedTime":
            suggest = "last_updated_time"
        elif key == "operationType":
            suggest = "operation_type"
        elif key == "protectableObjectType":
            suggest = "protectable_object_type"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSQLAGWorkloadContainerProtectionContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSQLAGWorkloadContainerProtectionContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSQLAGWorkloadContainerProtectionContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_type: str,
                 backup_management_type: Optional[str] = None,
                 extended_info: Optional['outputs.AzureWorkloadContainerExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 last_updated_time: Optional[str] = None,
                 operation_type: Optional[str] = None,
                 protectable_object_type: Optional[str] = None,
                 registration_status: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        Container for SQL workloads under SQL Availability Group.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'SQLAGWorkLoadContainer'.
        :param str backup_management_type: Type of backup management for the container.
        :param 'AzureWorkloadContainerExtendedInfoResponse' extended_info: Additional details of a workload container.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str last_updated_time: Time stamp when this container was updated.
        :param str operation_type: Re-Do Operation
        :param str protectable_object_type: Type of the protectable object associated with this container
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param str source_resource_id: ARM ID of the virtual machine represented by this Azure Workload Container
        :param str workload_type: Workload type for which registration was sent.
        """
        pulumi.set(__self__, "container_type", 'SQLAGWorkLoadContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if operation_type is not None:
            pulumi.set(__self__, "operation_type", operation_type)
        if protectable_object_type is not None:
            pulumi.set(__self__, "protectable_object_type", protectable_object_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> str:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'SQLAGWorkLoadContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureWorkloadContainerExtendedInfoResponse']:
        """
        Additional details of a workload container.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[str]:
        """
        Time stamp when this container was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> Optional[str]:
        """
        Re-Do Operation
        """
        return pulumi.get(self, "operation_type")

    @property
    @pulumi.getter(name="protectableObjectType")
    def protectable_object_type(self) -> Optional[str]:
        """
        Type of the protectable object associated with this container
        """
        return pulumi.get(self, "protectable_object_type")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the virtual machine represented by this Azure Workload Container
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Workload type for which registration was sent.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class AzureSqlContainerResponse(dict):
    """
    Azure Sql workload-specific container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerType":
            suggest = "container_type"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "protectableObjectType":
            suggest = "protectable_object_type"
        elif key == "registrationStatus":
            suggest = "registration_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSqlContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSqlContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSqlContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_type: str,
                 backup_management_type: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 protectable_object_type: Optional[str] = None,
                 registration_status: Optional[str] = None):
        """
        Azure Sql workload-specific container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'AzureSqlContainer'.
        :param str backup_management_type: Type of backup management for the container.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str protectable_object_type: Type of the protectable object associated with this container
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        """
        pulumi.set(__self__, "container_type", 'AzureSqlContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protectable_object_type is not None:
            pulumi.set(__self__, "protectable_object_type", protectable_object_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> str:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'AzureSqlContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="protectableObjectType")
    def protectable_object_type(self) -> Optional[str]:
        """
        Type of the protectable object associated with this container
        """
        return pulumi.get(self, "protectable_object_type")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")


@pulumi.output_type
class AzureSqlProtectedItemExtendedInfoResponse(dict):
    """
    Additional information on Azure Sql specific protected item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oldestRecoveryPoint":
            suggest = "oldest_recovery_point"
        elif key == "policyState":
            suggest = "policy_state"
        elif key == "recoveryPointCount":
            suggest = "recovery_point_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSqlProtectedItemExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSqlProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSqlProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oldest_recovery_point: Optional[str] = None,
                 policy_state: Optional[str] = None,
                 recovery_point_count: Optional[int] = None):
        """
        Additional information on Azure Sql specific protected item.
        :param str oldest_recovery_point: The oldest backup copy available for this item in the service.
        :param str policy_state: State of the backup policy associated with this backup item.
        :param int recovery_point_count: Number of available backup copies associated with this backup item.
        """
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if policy_state is not None:
            pulumi.set(__self__, "policy_state", policy_state)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[str]:
        """
        The oldest backup copy available for this item in the service.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @property
    @pulumi.getter(name="policyState")
    def policy_state(self) -> Optional[str]:
        """
        State of the backup policy associated with this backup item.
        """
        return pulumi.get(self, "policy_state")

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[int]:
        """
        Number of available backup copies associated with this backup item.
        """
        return pulumi.get(self, "recovery_point_count")


@pulumi.output_type
class AzureSqlProtectedItemResponse(dict):
    """
    Azure SQL workload-specific backup item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "workloadType":
            suggest = "workload_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "protectedItemDataId":
            suggest = "protected_item_data_id"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "softDeleteRetentionPeriod":
            suggest = "soft_delete_retention_period"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSqlProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSqlProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSqlProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 protected_item_type: str,
                 workload_type: str,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureSqlProtectedItemExtendedInfoResponse'] = None,
                 is_archive_enabled: Optional[bool] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 last_recovery_point: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 protected_item_data_id: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 soft_delete_retention_period: Optional[int] = None,
                 source_resource_id: Optional[str] = None):
        """
        Azure SQL workload-specific backup item.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str protected_item_type: backup item type.
               Expected value is 'Microsoft.Sql/servers/databases'.
        :param str workload_type: Type of workload this item represents.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureSqlProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param bool is_archive_enabled: Flag to identify whether datasource is protected in archive
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str policy_name: Name of the policy used for protection
        :param str protected_item_data_id: Internal ID of a backup item. Used by Azure SQL Backup engine to contact Recovery Services.
        :param str protection_state: Backup state of the backed up item.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will be performed
        :param int soft_delete_retention_period: Soft delete retention period in days
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "backup_management_type", backup_management_type)
        pulumi.set(__self__, "protected_item_type", 'Microsoft.Sql/servers/databases')
        pulumi.set(__self__, "workload_type", workload_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if protected_item_data_id is not None:
            pulumi.set(__self__, "protected_item_data_id", protected_item_data_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if soft_delete_retention_period is not None:
            pulumi.set(__self__, "soft_delete_retention_period", soft_delete_retention_period)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> str:
        """
        backup item type.
        Expected value is 'Microsoft.Sql/servers/databases'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> str:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureSqlProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        Flag to identify whether datasource is protected in archive
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Name of the policy used for protection
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="protectedItemDataId")
    def protected_item_data_id(self) -> Optional[str]:
        """
        Internal ID of a backup item. Used by Azure SQL Backup engine to contact Recovery Services.
        """
        return pulumi.get(self, "protected_item_data_id")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of the backed up item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuardOperationRequests on which LAC check will be performed
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="softDeleteRetentionPeriod")
    def soft_delete_retention_period(self) -> Optional[int]:
        """
        Soft delete retention period in days
        """
        return pulumi.get(self, "soft_delete_retention_period")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class AzureSqlProtectionPolicyResponse(dict):
    """
    Azure SQL workload-specific backup policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "protectedItemsCount":
            suggest = "protected_items_count"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "retentionPolicy":
            suggest = "retention_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSqlProtectionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSqlProtectionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSqlProtectionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 protected_items_count: Optional[int] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 retention_policy: Optional[Any] = None):
        """
        Azure SQL workload-specific backup policy.
        :param str backup_management_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'AzureSql'.
        :param int protected_items_count: Number of items associated with this policy.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuard Operation Requests
        :param Union['LongTermRetentionPolicyResponse', 'SimpleRetentionPolicyResponse'] retention_policy: Retention policy details.
        """
        pulumi.set(__self__, "backup_management_type", 'AzureSql')
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'AzureSql'.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[int]:
        """
        Number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuard Operation Requests
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[Any]:
        """
        Retention policy details.
        """
        return pulumi.get(self, "retention_policy")


@pulumi.output_type
class AzureStorageContainerResponse(dict):
    """
    Azure Storage Account workload-specific container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerType":
            suggest = "container_type"
        elif key == "acquireStorageAccountLock":
            suggest = "acquire_storage_account_lock"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "protectableObjectType":
            suggest = "protectable_object_type"
        elif key == "protectedItemCount":
            suggest = "protected_item_count"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "storageAccountVersion":
            suggest = "storage_account_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureStorageContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureStorageContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureStorageContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_type: str,
                 acquire_storage_account_lock: Optional[str] = None,
                 backup_management_type: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 protectable_object_type: Optional[str] = None,
                 protected_item_count: Optional[float] = None,
                 registration_status: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 storage_account_version: Optional[str] = None):
        """
        Azure Storage Account workload-specific container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'StorageContainer'.
        :param str acquire_storage_account_lock: Whether storage account lock is to be acquired for this container or not.
        :param str backup_management_type: Type of backup management for the container.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str protectable_object_type: Type of the protectable object associated with this container
        :param float protected_item_count: Number of items backed up in this container.
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param str resource_group: Resource group name of Recovery Services Vault.
        :param str source_resource_id: Fully qualified ARM url.
        :param str storage_account_version: Storage account version.
        """
        pulumi.set(__self__, "container_type", 'StorageContainer')
        if acquire_storage_account_lock is not None:
            pulumi.set(__self__, "acquire_storage_account_lock", acquire_storage_account_lock)
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protectable_object_type is not None:
            pulumi.set(__self__, "protectable_object_type", protectable_object_type)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if storage_account_version is not None:
            pulumi.set(__self__, "storage_account_version", storage_account_version)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> str:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'StorageContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="acquireStorageAccountLock")
    def acquire_storage_account_lock(self) -> Optional[str]:
        """
        Whether storage account lock is to be acquired for this container or not.
        """
        return pulumi.get(self, "acquire_storage_account_lock")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="protectableObjectType")
    def protectable_object_type(self) -> Optional[str]:
        """
        Type of the protectable object associated with this container
        """
        return pulumi.get(self, "protectable_object_type")

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[float]:
        """
        Number of items backed up in this container.
        """
        return pulumi.get(self, "protected_item_count")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Resource group name of Recovery Services Vault.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        Fully qualified ARM url.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="storageAccountVersion")
    def storage_account_version(self) -> Optional[str]:
        """
        Storage account version.
        """
        return pulumi.get(self, "storage_account_version")


@pulumi.output_type
class AzureVMAppContainerProtectionContainerResponse(dict):
    """
    Container for SQL workloads under Azure Virtual Machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerType":
            suggest = "container_type"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "lastUpdatedTime":
            suggest = "last_updated_time"
        elif key == "operationType":
            suggest = "operation_type"
        elif key == "protectableObjectType":
            suggest = "protectable_object_type"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureVMAppContainerProtectionContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureVMAppContainerProtectionContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureVMAppContainerProtectionContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_type: str,
                 backup_management_type: Optional[str] = None,
                 extended_info: Optional['outputs.AzureWorkloadContainerExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 last_updated_time: Optional[str] = None,
                 operation_type: Optional[str] = None,
                 protectable_object_type: Optional[str] = None,
                 registration_status: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        Container for SQL workloads under Azure Virtual Machines.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'VMAppContainer'.
        :param str backup_management_type: Type of backup management for the container.
        :param 'AzureWorkloadContainerExtendedInfoResponse' extended_info: Additional details of a workload container.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str last_updated_time: Time stamp when this container was updated.
        :param str operation_type: Re-Do Operation
        :param str protectable_object_type: Type of the protectable object associated with this container
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param str source_resource_id: ARM ID of the virtual machine represented by this Azure Workload Container
        :param str workload_type: Workload type for which registration was sent.
        """
        pulumi.set(__self__, "container_type", 'VMAppContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if operation_type is not None:
            pulumi.set(__self__, "operation_type", operation_type)
        if protectable_object_type is not None:
            pulumi.set(__self__, "protectable_object_type", protectable_object_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> str:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'VMAppContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureWorkloadContainerExtendedInfoResponse']:
        """
        Additional details of a workload container.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[str]:
        """
        Time stamp when this container was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> Optional[str]:
        """
        Re-Do Operation
        """
        return pulumi.get(self, "operation_type")

    @property
    @pulumi.getter(name="protectableObjectType")
    def protectable_object_type(self) -> Optional[str]:
        """
        Type of the protectable object associated with this container
        """
        return pulumi.get(self, "protectable_object_type")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the virtual machine represented by this Azure Workload Container
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Workload type for which registration was sent.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class AzureVmWorkloadProtectedItemExtendedInfoResponse(dict):
    """
    Additional information on Azure Workload for SQL specific backup item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newestRecoveryPointInArchive":
            suggest = "newest_recovery_point_in_archive"
        elif key == "oldestRecoveryPoint":
            suggest = "oldest_recovery_point"
        elif key == "oldestRecoveryPointInArchive":
            suggest = "oldest_recovery_point_in_archive"
        elif key == "oldestRecoveryPointInVault":
            suggest = "oldest_recovery_point_in_vault"
        elif key == "policyState":
            suggest = "policy_state"
        elif key == "recoveryModel":
            suggest = "recovery_model"
        elif key == "recoveryPointCount":
            suggest = "recovery_point_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureVmWorkloadProtectedItemExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureVmWorkloadProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureVmWorkloadProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 newest_recovery_point_in_archive: Optional[str] = None,
                 oldest_recovery_point: Optional[str] = None,
                 oldest_recovery_point_in_archive: Optional[str] = None,
                 oldest_recovery_point_in_vault: Optional[str] = None,
                 policy_state: Optional[str] = None,
                 recovery_model: Optional[str] = None,
                 recovery_point_count: Optional[int] = None):
        """
        Additional information on Azure Workload for SQL specific backup item.
        :param str newest_recovery_point_in_archive: The latest backup copy available for this backup item in archive tier
        :param str oldest_recovery_point: The oldest backup copy available for this backup item across all tiers.
        :param str oldest_recovery_point_in_archive: The oldest backup copy available for this backup item in archive tier
        :param str oldest_recovery_point_in_vault: The oldest backup copy available for this backup item in vault tier
        :param str policy_state: Indicates consistency of policy object and policy applied to this backup item.
        :param str recovery_model: Indicates consistency of policy object and policy applied to this backup item.
        :param int recovery_point_count: Number of backup copies available for this backup item.
        """
        if newest_recovery_point_in_archive is not None:
            pulumi.set(__self__, "newest_recovery_point_in_archive", newest_recovery_point_in_archive)
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if oldest_recovery_point_in_archive is not None:
            pulumi.set(__self__, "oldest_recovery_point_in_archive", oldest_recovery_point_in_archive)
        if oldest_recovery_point_in_vault is not None:
            pulumi.set(__self__, "oldest_recovery_point_in_vault", oldest_recovery_point_in_vault)
        if policy_state is not None:
            pulumi.set(__self__, "policy_state", policy_state)
        if recovery_model is not None:
            pulumi.set(__self__, "recovery_model", recovery_model)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="newestRecoveryPointInArchive")
    def newest_recovery_point_in_archive(self) -> Optional[str]:
        """
        The latest backup copy available for this backup item in archive tier
        """
        return pulumi.get(self, "newest_recovery_point_in_archive")

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[str]:
        """
        The oldest backup copy available for this backup item across all tiers.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @property
    @pulumi.getter(name="oldestRecoveryPointInArchive")
    def oldest_recovery_point_in_archive(self) -> Optional[str]:
        """
        The oldest backup copy available for this backup item in archive tier
        """
        return pulumi.get(self, "oldest_recovery_point_in_archive")

    @property
    @pulumi.getter(name="oldestRecoveryPointInVault")
    def oldest_recovery_point_in_vault(self) -> Optional[str]:
        """
        The oldest backup copy available for this backup item in vault tier
        """
        return pulumi.get(self, "oldest_recovery_point_in_vault")

    @property
    @pulumi.getter(name="policyState")
    def policy_state(self) -> Optional[str]:
        """
        Indicates consistency of policy object and policy applied to this backup item.
        """
        return pulumi.get(self, "policy_state")

    @property
    @pulumi.getter(name="recoveryModel")
    def recovery_model(self) -> Optional[str]:
        """
        Indicates consistency of policy object and policy applied to this backup item.
        """
        return pulumi.get(self, "recovery_model")

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[int]:
        """
        Number of backup copies available for this backup item.
        """
        return pulumi.get(self, "recovery_point_count")


@pulumi.output_type
class AzureVmWorkloadProtectedItemResponse(dict):
    """
    Azure VM workload-specific protected item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "workloadType":
            suggest = "workload_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "kpisHealths":
            suggest = "kpis_healths"
        elif key == "lastBackupErrorDetail":
            suggest = "last_backup_error_detail"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "parentName":
            suggest = "parent_name"
        elif key == "parentType":
            suggest = "parent_type"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "protectedItemDataSourceId":
            suggest = "protected_item_data_source_id"
        elif key == "protectedItemHealthStatus":
            suggest = "protected_item_health_status"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "softDeleteRetentionPeriod":
            suggest = "soft_delete_retention_period"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureVmWorkloadProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureVmWorkloadProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureVmWorkloadProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 friendly_name: str,
                 protected_item_type: str,
                 protection_status: str,
                 workload_type: str,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse'] = None,
                 is_archive_enabled: Optional[bool] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 kpis_healths: Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']] = None,
                 last_backup_error_detail: Optional['outputs.ErrorDetailResponse'] = None,
                 last_backup_status: Optional[str] = None,
                 last_backup_time: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 parent_name: Optional[str] = None,
                 parent_type: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 protected_item_data_source_id: Optional[str] = None,
                 protected_item_health_status: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 server_name: Optional[str] = None,
                 soft_delete_retention_period: Optional[int] = None,
                 source_resource_id: Optional[str] = None):
        """
        Azure VM workload-specific protected item.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str friendly_name: Friendly name of the DB represented by this backup item.
        :param str protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadProtectedItem'.
        :param str protection_status: Backup status of this backup item.
        :param str workload_type: Type of workload this item represents.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureVmWorkloadProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param bool is_archive_enabled: Flag to identify whether datasource is protected in archive
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param Mapping[str, 'KPIResourceHealthDetailsResponse'] kpis_healths: Health details of different KPIs
        :param 'ErrorDetailResponse' last_backup_error_detail: Error details in last backup
        :param str last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str parent_name: Parent name of the DB such as Instance or Availability Group.
        :param str parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str policy_name: Name of the policy used for protection
        :param str protected_item_data_source_id: Data ID of the protected item.
        :param str protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param str protection_state: Backup state of this backup item.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will be performed
        :param str server_name: Host/Cluster Name for instance or AG
        :param int soft_delete_retention_period: Soft delete retention period in days
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "backup_management_type", backup_management_type)
        pulumi.set(__self__, "friendly_name", friendly_name)
        pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadProtectedItem')
        pulumi.set(__self__, "protection_status", protection_status)
        pulumi.set(__self__, "workload_type", workload_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_error_detail is not None:
            pulumi.set(__self__, "last_backup_error_detail", last_backup_error_detail)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if soft_delete_retention_period is not None:
            pulumi.set(__self__, "soft_delete_retention_period", soft_delete_retention_period)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> str:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> str:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> str:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> str:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        Flag to identify whether datasource is protected in archive
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @property
    @pulumi.getter(name="lastBackupErrorDetail")
    def last_backup_error_detail(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        Error details in last backup
        """
        return pulumi.get(self, "last_backup_error_detail")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[str]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[str]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[str]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Name of the policy used for protection
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[str]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[str]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuardOperationRequests on which LAC check will be performed
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="softDeleteRetentionPeriod")
    def soft_delete_retention_period(self) -> Optional[int]:
        """
        Soft delete retention period in days
        """
        return pulumi.get(self, "soft_delete_retention_period")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class AzureVmWorkloadProtectionPolicyResponse(dict):
    """
    Azure VM (Mercury) workload-specific backup policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "makePolicyConsistent":
            suggest = "make_policy_consistent"
        elif key == "protectedItemsCount":
            suggest = "protected_items_count"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "subProtectionPolicy":
            suggest = "sub_protection_policy"
        elif key == "workLoadType":
            suggest = "work_load_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureVmWorkloadProtectionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureVmWorkloadProtectionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureVmWorkloadProtectionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 make_policy_consistent: Optional[bool] = None,
                 protected_items_count: Optional[int] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 settings: Optional['outputs.SettingsResponse'] = None,
                 sub_protection_policy: Optional[Sequence['outputs.SubProtectionPolicyResponse']] = None,
                 work_load_type: Optional[str] = None):
        """
        Azure VM (Mercury) workload-specific backup policy.
        :param str backup_management_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'AzureWorkload'.
        :param bool make_policy_consistent: Fix the policy inconsistency
        :param int protected_items_count: Number of items associated with this policy.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuard Operation Requests
        :param 'SettingsResponse' settings: Common settings for the backup management
        :param Sequence['SubProtectionPolicyResponse'] sub_protection_policy: List of sub-protection policies which includes schedule and retention
        :param str work_load_type: Type of workload for the backup management
        """
        pulumi.set(__self__, "backup_management_type", 'AzureWorkload')
        if make_policy_consistent is not None:
            pulumi.set(__self__, "make_policy_consistent", make_policy_consistent)
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if sub_protection_policy is not None:
            pulumi.set(__self__, "sub_protection_policy", sub_protection_policy)
        if work_load_type is not None:
            pulumi.set(__self__, "work_load_type", work_load_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'AzureWorkload'.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="makePolicyConsistent")
    def make_policy_consistent(self) -> Optional[bool]:
        """
        Fix the policy inconsistency
        """
        return pulumi.get(self, "make_policy_consistent")

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[int]:
        """
        Number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuard Operation Requests
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter
    def settings(self) -> Optional['outputs.SettingsResponse']:
        """
        Common settings for the backup management
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="subProtectionPolicy")
    def sub_protection_policy(self) -> Optional[Sequence['outputs.SubProtectionPolicyResponse']]:
        """
        List of sub-protection policies which includes schedule and retention
        """
        return pulumi.get(self, "sub_protection_policy")

    @property
    @pulumi.getter(name="workLoadType")
    def work_load_type(self) -> Optional[str]:
        """
        Type of workload for the backup management
        """
        return pulumi.get(self, "work_load_type")


@pulumi.output_type
class AzureVmWorkloadSAPAseDatabaseProtectedItemResponse(dict):
    """
    Azure VM workload-specific protected item representing SAP ASE Database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "workloadType":
            suggest = "workload_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "kpisHealths":
            suggest = "kpis_healths"
        elif key == "lastBackupErrorDetail":
            suggest = "last_backup_error_detail"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "parentName":
            suggest = "parent_name"
        elif key == "parentType":
            suggest = "parent_type"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "protectedItemDataSourceId":
            suggest = "protected_item_data_source_id"
        elif key == "protectedItemHealthStatus":
            suggest = "protected_item_health_status"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "softDeleteRetentionPeriod":
            suggest = "soft_delete_retention_period"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureVmWorkloadSAPAseDatabaseProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureVmWorkloadSAPAseDatabaseProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureVmWorkloadSAPAseDatabaseProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 friendly_name: str,
                 protected_item_type: str,
                 protection_status: str,
                 workload_type: str,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse'] = None,
                 is_archive_enabled: Optional[bool] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 kpis_healths: Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']] = None,
                 last_backup_error_detail: Optional['outputs.ErrorDetailResponse'] = None,
                 last_backup_status: Optional[str] = None,
                 last_backup_time: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 parent_name: Optional[str] = None,
                 parent_type: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 protected_item_data_source_id: Optional[str] = None,
                 protected_item_health_status: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 server_name: Optional[str] = None,
                 soft_delete_retention_period: Optional[int] = None,
                 source_resource_id: Optional[str] = None):
        """
        Azure VM workload-specific protected item representing SAP ASE Database.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str friendly_name: Friendly name of the DB represented by this backup item.
        :param str protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadSAPAseDatabase'.
        :param str protection_status: Backup status of this backup item.
        :param str workload_type: Type of workload this item represents.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureVmWorkloadProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param bool is_archive_enabled: Flag to identify whether datasource is protected in archive
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param Mapping[str, 'KPIResourceHealthDetailsResponse'] kpis_healths: Health details of different KPIs
        :param 'ErrorDetailResponse' last_backup_error_detail: Error details in last backup
        :param str last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str parent_name: Parent name of the DB such as Instance or Availability Group.
        :param str parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str policy_name: Name of the policy used for protection
        :param str protected_item_data_source_id: Data ID of the protected item.
        :param str protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param str protection_state: Backup state of this backup item.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will be performed
        :param str server_name: Host/Cluster Name for instance or AG
        :param int soft_delete_retention_period: Soft delete retention period in days
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "backup_management_type", backup_management_type)
        pulumi.set(__self__, "friendly_name", friendly_name)
        pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadSAPAseDatabase')
        pulumi.set(__self__, "protection_status", protection_status)
        pulumi.set(__self__, "workload_type", workload_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_error_detail is not None:
            pulumi.set(__self__, "last_backup_error_detail", last_backup_error_detail)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if soft_delete_retention_period is not None:
            pulumi.set(__self__, "soft_delete_retention_period", soft_delete_retention_period)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> str:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> str:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadSAPAseDatabase'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> str:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> str:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        Flag to identify whether datasource is protected in archive
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @property
    @pulumi.getter(name="lastBackupErrorDetail")
    def last_backup_error_detail(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        Error details in last backup
        """
        return pulumi.get(self, "last_backup_error_detail")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[str]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[str]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[str]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Name of the policy used for protection
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[str]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[str]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuardOperationRequests on which LAC check will be performed
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="softDeleteRetentionPeriod")
    def soft_delete_retention_period(self) -> Optional[int]:
        """
        Soft delete retention period in days
        """
        return pulumi.get(self, "soft_delete_retention_period")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class AzureVmWorkloadSAPHanaDBInstanceProtectedItemResponse(dict):
    """
    Azure VM workload-specific protected item representing SAP HANA DBInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "workloadType":
            suggest = "workload_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "kpisHealths":
            suggest = "kpis_healths"
        elif key == "lastBackupErrorDetail":
            suggest = "last_backup_error_detail"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "parentName":
            suggest = "parent_name"
        elif key == "parentType":
            suggest = "parent_type"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "protectedItemDataSourceId":
            suggest = "protected_item_data_source_id"
        elif key == "protectedItemHealthStatus":
            suggest = "protected_item_health_status"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "softDeleteRetentionPeriod":
            suggest = "soft_delete_retention_period"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureVmWorkloadSAPHanaDBInstanceProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureVmWorkloadSAPHanaDBInstanceProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureVmWorkloadSAPHanaDBInstanceProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 friendly_name: str,
                 protected_item_type: str,
                 protection_status: str,
                 workload_type: str,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse'] = None,
                 is_archive_enabled: Optional[bool] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 kpis_healths: Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']] = None,
                 last_backup_error_detail: Optional['outputs.ErrorDetailResponse'] = None,
                 last_backup_status: Optional[str] = None,
                 last_backup_time: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 parent_name: Optional[str] = None,
                 parent_type: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 protected_item_data_source_id: Optional[str] = None,
                 protected_item_health_status: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 server_name: Optional[str] = None,
                 soft_delete_retention_period: Optional[int] = None,
                 source_resource_id: Optional[str] = None):
        """
        Azure VM workload-specific protected item representing SAP HANA DBInstance.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str friendly_name: Friendly name of the DB represented by this backup item.
        :param str protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadSAPHanaDBInstance'.
        :param str protection_status: Backup status of this backup item.
        :param str workload_type: Type of workload this item represents.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureVmWorkloadProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param bool is_archive_enabled: Flag to identify whether datasource is protected in archive
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param Mapping[str, 'KPIResourceHealthDetailsResponse'] kpis_healths: Health details of different KPIs
        :param 'ErrorDetailResponse' last_backup_error_detail: Error details in last backup
        :param str last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str parent_name: Parent name of the DB such as Instance or Availability Group.
        :param str parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str policy_name: Name of the policy used for protection
        :param str protected_item_data_source_id: Data ID of the protected item.
        :param str protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param str protection_state: Backup state of this backup item.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will be performed
        :param str server_name: Host/Cluster Name for instance or AG
        :param int soft_delete_retention_period: Soft delete retention period in days
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "backup_management_type", backup_management_type)
        pulumi.set(__self__, "friendly_name", friendly_name)
        pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadSAPHanaDBInstance')
        pulumi.set(__self__, "protection_status", protection_status)
        pulumi.set(__self__, "workload_type", workload_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_error_detail is not None:
            pulumi.set(__self__, "last_backup_error_detail", last_backup_error_detail)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if soft_delete_retention_period is not None:
            pulumi.set(__self__, "soft_delete_retention_period", soft_delete_retention_period)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> str:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> str:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadSAPHanaDBInstance'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> str:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> str:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        Flag to identify whether datasource is protected in archive
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @property
    @pulumi.getter(name="lastBackupErrorDetail")
    def last_backup_error_detail(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        Error details in last backup
        """
        return pulumi.get(self, "last_backup_error_detail")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[str]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[str]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[str]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Name of the policy used for protection
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[str]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[str]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuardOperationRequests on which LAC check will be performed
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="softDeleteRetentionPeriod")
    def soft_delete_retention_period(self) -> Optional[int]:
        """
        Soft delete retention period in days
        """
        return pulumi.get(self, "soft_delete_retention_period")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class AzureVmWorkloadSAPHanaDatabaseProtectedItemResponse(dict):
    """
    Azure VM workload-specific protected item representing SAP HANA Database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "workloadType":
            suggest = "workload_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "kpisHealths":
            suggest = "kpis_healths"
        elif key == "lastBackupErrorDetail":
            suggest = "last_backup_error_detail"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "parentName":
            suggest = "parent_name"
        elif key == "parentType":
            suggest = "parent_type"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "protectedItemDataSourceId":
            suggest = "protected_item_data_source_id"
        elif key == "protectedItemHealthStatus":
            suggest = "protected_item_health_status"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "softDeleteRetentionPeriod":
            suggest = "soft_delete_retention_period"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureVmWorkloadSAPHanaDatabaseProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureVmWorkloadSAPHanaDatabaseProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureVmWorkloadSAPHanaDatabaseProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 friendly_name: str,
                 protected_item_type: str,
                 protection_status: str,
                 workload_type: str,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse'] = None,
                 is_archive_enabled: Optional[bool] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 kpis_healths: Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']] = None,
                 last_backup_error_detail: Optional['outputs.ErrorDetailResponse'] = None,
                 last_backup_status: Optional[str] = None,
                 last_backup_time: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 parent_name: Optional[str] = None,
                 parent_type: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 protected_item_data_source_id: Optional[str] = None,
                 protected_item_health_status: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 server_name: Optional[str] = None,
                 soft_delete_retention_period: Optional[int] = None,
                 source_resource_id: Optional[str] = None):
        """
        Azure VM workload-specific protected item representing SAP HANA Database.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str friendly_name: Friendly name of the DB represented by this backup item.
        :param str protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadSAPHanaDatabase'.
        :param str protection_status: Backup status of this backup item.
        :param str workload_type: Type of workload this item represents.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureVmWorkloadProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param bool is_archive_enabled: Flag to identify whether datasource is protected in archive
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param Mapping[str, 'KPIResourceHealthDetailsResponse'] kpis_healths: Health details of different KPIs
        :param 'ErrorDetailResponse' last_backup_error_detail: Error details in last backup
        :param str last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str parent_name: Parent name of the DB such as Instance or Availability Group.
        :param str parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str policy_name: Name of the policy used for protection
        :param str protected_item_data_source_id: Data ID of the protected item.
        :param str protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param str protection_state: Backup state of this backup item.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will be performed
        :param str server_name: Host/Cluster Name for instance or AG
        :param int soft_delete_retention_period: Soft delete retention period in days
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "backup_management_type", backup_management_type)
        pulumi.set(__self__, "friendly_name", friendly_name)
        pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadSAPHanaDatabase')
        pulumi.set(__self__, "protection_status", protection_status)
        pulumi.set(__self__, "workload_type", workload_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_error_detail is not None:
            pulumi.set(__self__, "last_backup_error_detail", last_backup_error_detail)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if soft_delete_retention_period is not None:
            pulumi.set(__self__, "soft_delete_retention_period", soft_delete_retention_period)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> str:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> str:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadSAPHanaDatabase'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> str:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> str:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        Flag to identify whether datasource is protected in archive
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @property
    @pulumi.getter(name="lastBackupErrorDetail")
    def last_backup_error_detail(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        Error details in last backup
        """
        return pulumi.get(self, "last_backup_error_detail")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[str]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[str]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[str]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Name of the policy used for protection
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[str]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[str]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuardOperationRequests on which LAC check will be performed
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="softDeleteRetentionPeriod")
    def soft_delete_retention_period(self) -> Optional[int]:
        """
        Soft delete retention period in days
        """
        return pulumi.get(self, "soft_delete_retention_period")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class AzureVmWorkloadSQLDatabaseProtectedItemResponse(dict):
    """
    Azure VM workload-specific protected item representing SQL Database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "workloadType":
            suggest = "workload_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "kpisHealths":
            suggest = "kpis_healths"
        elif key == "lastBackupErrorDetail":
            suggest = "last_backup_error_detail"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "parentName":
            suggest = "parent_name"
        elif key == "parentType":
            suggest = "parent_type"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "protectedItemDataSourceId":
            suggest = "protected_item_data_source_id"
        elif key == "protectedItemHealthStatus":
            suggest = "protected_item_health_status"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "softDeleteRetentionPeriod":
            suggest = "soft_delete_retention_period"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureVmWorkloadSQLDatabaseProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureVmWorkloadSQLDatabaseProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureVmWorkloadSQLDatabaseProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 friendly_name: str,
                 protected_item_type: str,
                 protection_status: str,
                 workload_type: str,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse'] = None,
                 is_archive_enabled: Optional[bool] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 kpis_healths: Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']] = None,
                 last_backup_error_detail: Optional['outputs.ErrorDetailResponse'] = None,
                 last_backup_status: Optional[str] = None,
                 last_backup_time: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 parent_name: Optional[str] = None,
                 parent_type: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 protected_item_data_source_id: Optional[str] = None,
                 protected_item_health_status: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 server_name: Optional[str] = None,
                 soft_delete_retention_period: Optional[int] = None,
                 source_resource_id: Optional[str] = None):
        """
        Azure VM workload-specific protected item representing SQL Database.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str friendly_name: Friendly name of the DB represented by this backup item.
        :param str protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadSQLDatabase'.
        :param str protection_status: Backup status of this backup item.
        :param str workload_type: Type of workload this item represents.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureVmWorkloadProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param bool is_archive_enabled: Flag to identify whether datasource is protected in archive
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param Mapping[str, 'KPIResourceHealthDetailsResponse'] kpis_healths: Health details of different KPIs
        :param 'ErrorDetailResponse' last_backup_error_detail: Error details in last backup
        :param str last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str parent_name: Parent name of the DB such as Instance or Availability Group.
        :param str parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str policy_name: Name of the policy used for protection
        :param str protected_item_data_source_id: Data ID of the protected item.
        :param str protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param str protection_state: Backup state of this backup item.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will be performed
        :param str server_name: Host/Cluster Name for instance or AG
        :param int soft_delete_retention_period: Soft delete retention period in days
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "backup_management_type", backup_management_type)
        pulumi.set(__self__, "friendly_name", friendly_name)
        pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadSQLDatabase')
        pulumi.set(__self__, "protection_status", protection_status)
        pulumi.set(__self__, "workload_type", workload_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_error_detail is not None:
            pulumi.set(__self__, "last_backup_error_detail", last_backup_error_detail)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if soft_delete_retention_period is not None:
            pulumi.set(__self__, "soft_delete_retention_period", soft_delete_retention_period)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> str:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> str:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadSQLDatabase'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> str:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> str:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        Flag to identify whether datasource is protected in archive
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[Mapping[str, 'outputs.KPIResourceHealthDetailsResponse']]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @property
    @pulumi.getter(name="lastBackupErrorDetail")
    def last_backup_error_detail(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        Error details in last backup
        """
        return pulumi.get(self, "last_backup_error_detail")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[str]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[str]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[str]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Name of the policy used for protection
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[str]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[str]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuardOperationRequests on which LAC check will be performed
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="softDeleteRetentionPeriod")
    def soft_delete_retention_period(self) -> Optional[int]:
        """
        Soft delete retention period in days
        """
        return pulumi.get(self, "soft_delete_retention_period")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class AzureWorkloadAutoProtectionIntentResponse(dict):
    """
    Azure Recovery Services Vault specific protection intent item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protectionIntentItemType":
            suggest = "protection_intent_item_type"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "itemId":
            suggest = "item_id"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureWorkloadAutoProtectionIntentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureWorkloadAutoProtectionIntentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureWorkloadAutoProtectionIntentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protection_intent_item_type: str,
                 backup_management_type: Optional[str] = None,
                 item_id: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 source_resource_id: Optional[str] = None):
        """
        Azure Recovery Services Vault specific protection intent item.
        :param str protection_intent_item_type: backup protectionIntent type.
               Expected value is 'AzureWorkloadAutoProtectionIntent'.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str item_id: ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str protection_state: Backup state of this backup item.
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "protection_intent_item_type", 'AzureWorkloadAutoProtectionIntent')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if item_id is not None:
            pulumi.set(__self__, "item_id", item_id)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="protectionIntentItemType")
    def protection_intent_item_type(self) -> str:
        """
        backup protectionIntent type.
        Expected value is 'AzureWorkloadAutoProtectionIntent'.
        """
        return pulumi.get(self, "protection_intent_item_type")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="itemId")
    def item_id(self) -> Optional[str]:
        """
        ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
        """
        return pulumi.get(self, "item_id")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class AzureWorkloadContainerAutoProtectionIntentResponse(dict):
    """
    Azure workload specific protection intent item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protectionIntentItemType":
            suggest = "protection_intent_item_type"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "itemId":
            suggest = "item_id"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureWorkloadContainerAutoProtectionIntentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureWorkloadContainerAutoProtectionIntentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureWorkloadContainerAutoProtectionIntentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protection_intent_item_type: str,
                 backup_management_type: Optional[str] = None,
                 item_id: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 source_resource_id: Optional[str] = None):
        """
        Azure workload specific protection intent item.
        :param str protection_intent_item_type: backup protectionIntent type.
               Expected value is 'AzureWorkloadContainerAutoProtectionIntent'.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str item_id: ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str protection_state: Backup state of this backup item.
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "protection_intent_item_type", 'AzureWorkloadContainerAutoProtectionIntent')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if item_id is not None:
            pulumi.set(__self__, "item_id", item_id)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="protectionIntentItemType")
    def protection_intent_item_type(self) -> str:
        """
        backup protectionIntent type.
        Expected value is 'AzureWorkloadContainerAutoProtectionIntent'.
        """
        return pulumi.get(self, "protection_intent_item_type")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="itemId")
    def item_id(self) -> Optional[str]:
        """
        ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
        """
        return pulumi.get(self, "item_id")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class AzureWorkloadContainerExtendedInfoResponse(dict):
    """
    Extended information of the container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostServerName":
            suggest = "host_server_name"
        elif key == "inquiryInfo":
            suggest = "inquiry_info"
        elif key == "nodesList":
            suggest = "nodes_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureWorkloadContainerExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureWorkloadContainerExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureWorkloadContainerExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_server_name: Optional[str] = None,
                 inquiry_info: Optional['outputs.InquiryInfoResponse'] = None,
                 nodes_list: Optional[Sequence['outputs.DistributedNodesInfoResponse']] = None):
        """
        Extended information of the container.
        :param str host_server_name: Host Os Name in case of Stand Alone and Cluster Name in case of distributed container.
        :param 'InquiryInfoResponse' inquiry_info: Inquiry Status for the container.
        :param Sequence['DistributedNodesInfoResponse'] nodes_list: List of the nodes in case of distributed container.
        """
        if host_server_name is not None:
            pulumi.set(__self__, "host_server_name", host_server_name)
        if inquiry_info is not None:
            pulumi.set(__self__, "inquiry_info", inquiry_info)
        if nodes_list is not None:
            pulumi.set(__self__, "nodes_list", nodes_list)

    @property
    @pulumi.getter(name="hostServerName")
    def host_server_name(self) -> Optional[str]:
        """
        Host Os Name in case of Stand Alone and Cluster Name in case of distributed container.
        """
        return pulumi.get(self, "host_server_name")

    @property
    @pulumi.getter(name="inquiryInfo")
    def inquiry_info(self) -> Optional['outputs.InquiryInfoResponse']:
        """
        Inquiry Status for the container.
        """
        return pulumi.get(self, "inquiry_info")

    @property
    @pulumi.getter(name="nodesList")
    def nodes_list(self) -> Optional[Sequence['outputs.DistributedNodesInfoResponse']]:
        """
        List of the nodes in case of distributed container.
        """
        return pulumi.get(self, "nodes_list")


@pulumi.output_type
class AzureWorkloadContainerResponse(dict):
    """
    Container for the workloads running inside Azure Compute or Classic Compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerType":
            suggest = "container_type"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "lastUpdatedTime":
            suggest = "last_updated_time"
        elif key == "operationType":
            suggest = "operation_type"
        elif key == "protectableObjectType":
            suggest = "protectable_object_type"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureWorkloadContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureWorkloadContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureWorkloadContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_type: str,
                 backup_management_type: Optional[str] = None,
                 extended_info: Optional['outputs.AzureWorkloadContainerExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 last_updated_time: Optional[str] = None,
                 operation_type: Optional[str] = None,
                 protectable_object_type: Optional[str] = None,
                 registration_status: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        Container for the workloads running inside Azure Compute or Classic Compute.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'AzureWorkloadContainer'.
        :param str backup_management_type: Type of backup management for the container.
        :param 'AzureWorkloadContainerExtendedInfoResponse' extended_info: Additional details of a workload container.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str last_updated_time: Time stamp when this container was updated.
        :param str operation_type: Re-Do Operation
        :param str protectable_object_type: Type of the protectable object associated with this container
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param str source_resource_id: ARM ID of the virtual machine represented by this Azure Workload Container
        :param str workload_type: Workload type for which registration was sent.
        """
        pulumi.set(__self__, "container_type", 'AzureWorkloadContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if operation_type is not None:
            pulumi.set(__self__, "operation_type", operation_type)
        if protectable_object_type is not None:
            pulumi.set(__self__, "protectable_object_type", protectable_object_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> str:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'AzureWorkloadContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureWorkloadContainerExtendedInfoResponse']:
        """
        Additional details of a workload container.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[str]:
        """
        Time stamp when this container was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> Optional[str]:
        """
        Re-Do Operation
        """
        return pulumi.get(self, "operation_type")

    @property
    @pulumi.getter(name="protectableObjectType")
    def protectable_object_type(self) -> Optional[str]:
        """
        Type of the protectable object associated with this container
        """
        return pulumi.get(self, "protectable_object_type")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the virtual machine represented by this Azure Workload Container
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Workload type for which registration was sent.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class AzureWorkloadSQLAutoProtectionIntentResponse(dict):
    """
    Azure Workload SQL Auto Protection intent item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protectionIntentItemType":
            suggest = "protection_intent_item_type"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "itemId":
            suggest = "item_id"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "workloadItemType":
            suggest = "workload_item_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureWorkloadSQLAutoProtectionIntentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureWorkloadSQLAutoProtectionIntentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureWorkloadSQLAutoProtectionIntentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protection_intent_item_type: str,
                 backup_management_type: Optional[str] = None,
                 item_id: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 workload_item_type: Optional[str] = None):
        """
        Azure Workload SQL Auto Protection intent item.
        :param str protection_intent_item_type: backup protectionIntent type.
               Expected value is 'AzureWorkloadSQLAutoProtectionIntent'.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str item_id: ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str protection_state: Backup state of this backup item.
        :param str source_resource_id: ARM ID of the resource to be backed up.
        :param str workload_item_type: Workload item type of the item for which intent is to be set
        """
        pulumi.set(__self__, "protection_intent_item_type", 'AzureWorkloadSQLAutoProtectionIntent')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if item_id is not None:
            pulumi.set(__self__, "item_id", item_id)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_item_type is not None:
            pulumi.set(__self__, "workload_item_type", workload_item_type)

    @property
    @pulumi.getter(name="protectionIntentItemType")
    def protection_intent_item_type(self) -> str:
        """
        backup protectionIntent type.
        Expected value is 'AzureWorkloadSQLAutoProtectionIntent'.
        """
        return pulumi.get(self, "protection_intent_item_type")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="itemId")
    def item_id(self) -> Optional[str]:
        """
        ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
        """
        return pulumi.get(self, "item_id")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="workloadItemType")
    def workload_item_type(self) -> Optional[str]:
        """
        Workload item type of the item for which intent is to be set
        """
        return pulumi.get(self, "workload_item_type")


@pulumi.output_type
class ClassicAlertSettingsResponse(dict):
    """
    Settings for classic alerts
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertsForCriticalOperations":
            suggest = "alerts_for_critical_operations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassicAlertSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassicAlertSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassicAlertSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alerts_for_critical_operations: Optional[str] = None):
        """
        Settings for classic alerts
        """
        if alerts_for_critical_operations is not None:
            pulumi.set(__self__, "alerts_for_critical_operations", alerts_for_critical_operations)

    @property
    @pulumi.getter(name="alertsForCriticalOperations")
    def alerts_for_critical_operations(self) -> Optional[str]:
        return pulumi.get(self, "alerts_for_critical_operations")


@pulumi.output_type
class CmkKekIdentityResponse(dict):
    """
    The details of the identity used for CMK
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useSystemAssignedIdentity":
            suggest = "use_system_assigned_identity"
        elif key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CmkKekIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CmkKekIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CmkKekIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_system_assigned_identity: Optional[bool] = None,
                 user_assigned_identity: Optional[str] = None):
        """
        The details of the identity used for CMK
        :param bool use_system_assigned_identity: Indicate that system assigned identity should be used. Mutually exclusive with 'userAssignedIdentity' field
        :param str user_assigned_identity: The user assigned identity to be used to grant permissions in case the type of identity used is UserAssigned
        """
        if use_system_assigned_identity is not None:
            pulumi.set(__self__, "use_system_assigned_identity", use_system_assigned_identity)
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="useSystemAssignedIdentity")
    def use_system_assigned_identity(self) -> Optional[bool]:
        """
        Indicate that system assigned identity should be used. Mutually exclusive with 'userAssignedIdentity' field
        """
        return pulumi.get(self, "use_system_assigned_identity")

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[str]:
        """
        The user assigned identity to be used to grant permissions in case the type of identity used is UserAssigned
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class CmkKeyVaultPropertiesResponse(dict):
    """
    The properties of the Key Vault which hosts CMK
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUri":
            suggest = "key_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CmkKeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CmkKeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CmkKeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_uri: Optional[str] = None):
        """
        The properties of the Key Vault which hosts CMK
        :param str key_uri: The key uri of the Customer Managed Key
        """
        if key_uri is not None:
            pulumi.set(__self__, "key_uri", key_uri)

    @property
    @pulumi.getter(name="keyUri")
    def key_uri(self) -> Optional[str]:
        """
        The key uri of the Customer Managed Key
        """
        return pulumi.get(self, "key_uri")


@pulumi.output_type
class ContainerIdentityInfoResponse(dict):
    """
    Container identity information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aadTenantId":
            suggest = "aad_tenant_id"
        elif key == "servicePrincipalClientId":
            suggest = "service_principal_client_id"
        elif key == "uniqueName":
            suggest = "unique_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerIdentityInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerIdentityInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerIdentityInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aad_tenant_id: Optional[str] = None,
                 audience: Optional[str] = None,
                 service_principal_client_id: Optional[str] = None,
                 unique_name: Optional[str] = None):
        """
        Container identity information
        :param str aad_tenant_id: Protection container identity - AAD Tenant
        :param str audience: Protection container identity - Audience
        :param str service_principal_client_id: Protection container identity - AAD Service Principal
        :param str unique_name: Unique name of the container
        """
        if aad_tenant_id is not None:
            pulumi.set(__self__, "aad_tenant_id", aad_tenant_id)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if service_principal_client_id is not None:
            pulumi.set(__self__, "service_principal_client_id", service_principal_client_id)
        if unique_name is not None:
            pulumi.set(__self__, "unique_name", unique_name)

    @property
    @pulumi.getter(name="aadTenantId")
    def aad_tenant_id(self) -> Optional[str]:
        """
        Protection container identity - AAD Tenant
        """
        return pulumi.get(self, "aad_tenant_id")

    @property
    @pulumi.getter
    def audience(self) -> Optional[str]:
        """
        Protection container identity - Audience
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="servicePrincipalClientId")
    def service_principal_client_id(self) -> Optional[str]:
        """
        Protection container identity - AAD Service Principal
        """
        return pulumi.get(self, "service_principal_client_id")

    @property
    @pulumi.getter(name="uniqueName")
    def unique_name(self) -> Optional[str]:
        """
        Unique name of the container
        """
        return pulumi.get(self, "unique_name")


@pulumi.output_type
class DPMContainerExtendedInfoResponse(dict):
    """
    Additional information of the DPMContainer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastRefreshedAt":
            suggest = "last_refreshed_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DPMContainerExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DPMContainerExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DPMContainerExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_refreshed_at: Optional[str] = None):
        """
        Additional information of the DPMContainer.
        :param str last_refreshed_at: Last refresh time of the DPMContainer.
        """
        if last_refreshed_at is not None:
            pulumi.set(__self__, "last_refreshed_at", last_refreshed_at)

    @property
    @pulumi.getter(name="lastRefreshedAt")
    def last_refreshed_at(self) -> Optional[str]:
        """
        Last refresh time of the DPMContainer.
        """
        return pulumi.get(self, "last_refreshed_at")


@pulumi.output_type
class DPMProtectedItemExtendedInfoResponse(dict):
    """
    Additional information of DPM Protected item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskStorageUsedInBytes":
            suggest = "disk_storage_used_in_bytes"
        elif key == "isCollocated":
            suggest = "is_collocated"
        elif key == "isPresentOnCloud":
            suggest = "is_present_on_cloud"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastRefreshedAt":
            suggest = "last_refreshed_at"
        elif key == "oldestRecoveryPoint":
            suggest = "oldest_recovery_point"
        elif key == "onPremiseLatestRecoveryPoint":
            suggest = "on_premise_latest_recovery_point"
        elif key == "onPremiseOldestRecoveryPoint":
            suggest = "on_premise_oldest_recovery_point"
        elif key == "onPremiseRecoveryPointCount":
            suggest = "on_premise_recovery_point_count"
        elif key == "protectableObjectLoadPath":
            suggest = "protectable_object_load_path"
        elif key == "protectionGroupName":
            suggest = "protection_group_name"
        elif key == "recoveryPointCount":
            suggest = "recovery_point_count"
        elif key == "totalDiskStorageSizeInBytes":
            suggest = "total_disk_storage_size_in_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DPMProtectedItemExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DPMProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DPMProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_storage_used_in_bytes: Optional[str] = None,
                 is_collocated: Optional[bool] = None,
                 is_present_on_cloud: Optional[bool] = None,
                 last_backup_status: Optional[str] = None,
                 last_refreshed_at: Optional[str] = None,
                 oldest_recovery_point: Optional[str] = None,
                 on_premise_latest_recovery_point: Optional[str] = None,
                 on_premise_oldest_recovery_point: Optional[str] = None,
                 on_premise_recovery_point_count: Optional[int] = None,
                 protectable_object_load_path: Optional[Mapping[str, str]] = None,
                 protected: Optional[bool] = None,
                 protection_group_name: Optional[str] = None,
                 recovery_point_count: Optional[int] = None,
                 total_disk_storage_size_in_bytes: Optional[str] = None):
        """
        Additional information of DPM Protected item.
        :param str disk_storage_used_in_bytes: Used Disk storage in bytes.
        :param bool is_collocated: To check if backup item is collocated.
        :param bool is_present_on_cloud: To check if backup item is cloud protected.
        :param str last_backup_status: Last backup status information on backup item.
        :param str last_refreshed_at: Last refresh time on backup item.
        :param str oldest_recovery_point: Oldest cloud recovery point time.
        :param str on_premise_latest_recovery_point: latest disk recovery point time.
        :param str on_premise_oldest_recovery_point: Oldest disk recovery point time.
        :param int on_premise_recovery_point_count: disk recovery point count.
        :param Mapping[str, str] protectable_object_load_path: Attribute to provide information on various DBs.
        :param bool protected: To check if backup item is disk protected.
        :param str protection_group_name: Protection group name of the backup item.
        :param int recovery_point_count: cloud recovery point count.
        :param str total_disk_storage_size_in_bytes: total Disk storage in bytes.
        """
        if disk_storage_used_in_bytes is not None:
            pulumi.set(__self__, "disk_storage_used_in_bytes", disk_storage_used_in_bytes)
        if is_collocated is not None:
            pulumi.set(__self__, "is_collocated", is_collocated)
        if is_present_on_cloud is not None:
            pulumi.set(__self__, "is_present_on_cloud", is_present_on_cloud)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_refreshed_at is not None:
            pulumi.set(__self__, "last_refreshed_at", last_refreshed_at)
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if on_premise_latest_recovery_point is not None:
            pulumi.set(__self__, "on_premise_latest_recovery_point", on_premise_latest_recovery_point)
        if on_premise_oldest_recovery_point is not None:
            pulumi.set(__self__, "on_premise_oldest_recovery_point", on_premise_oldest_recovery_point)
        if on_premise_recovery_point_count is not None:
            pulumi.set(__self__, "on_premise_recovery_point_count", on_premise_recovery_point_count)
        if protectable_object_load_path is not None:
            pulumi.set(__self__, "protectable_object_load_path", protectable_object_load_path)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)
        if protection_group_name is not None:
            pulumi.set(__self__, "protection_group_name", protection_group_name)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)
        if total_disk_storage_size_in_bytes is not None:
            pulumi.set(__self__, "total_disk_storage_size_in_bytes", total_disk_storage_size_in_bytes)

    @property
    @pulumi.getter(name="diskStorageUsedInBytes")
    def disk_storage_used_in_bytes(self) -> Optional[str]:
        """
        Used Disk storage in bytes.
        """
        return pulumi.get(self, "disk_storage_used_in_bytes")

    @property
    @pulumi.getter(name="isCollocated")
    def is_collocated(self) -> Optional[bool]:
        """
        To check if backup item is collocated.
        """
        return pulumi.get(self, "is_collocated")

    @property
    @pulumi.getter(name="isPresentOnCloud")
    def is_present_on_cloud(self) -> Optional[bool]:
        """
        To check if backup item is cloud protected.
        """
        return pulumi.get(self, "is_present_on_cloud")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup status information on backup item.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastRefreshedAt")
    def last_refreshed_at(self) -> Optional[str]:
        """
        Last refresh time on backup item.
        """
        return pulumi.get(self, "last_refreshed_at")

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[str]:
        """
        Oldest cloud recovery point time.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @property
    @pulumi.getter(name="onPremiseLatestRecoveryPoint")
    def on_premise_latest_recovery_point(self) -> Optional[str]:
        """
        latest disk recovery point time.
        """
        return pulumi.get(self, "on_premise_latest_recovery_point")

    @property
    @pulumi.getter(name="onPremiseOldestRecoveryPoint")
    def on_premise_oldest_recovery_point(self) -> Optional[str]:
        """
        Oldest disk recovery point time.
        """
        return pulumi.get(self, "on_premise_oldest_recovery_point")

    @property
    @pulumi.getter(name="onPremiseRecoveryPointCount")
    def on_premise_recovery_point_count(self) -> Optional[int]:
        """
        disk recovery point count.
        """
        return pulumi.get(self, "on_premise_recovery_point_count")

    @property
    @pulumi.getter(name="protectableObjectLoadPath")
    def protectable_object_load_path(self) -> Optional[Mapping[str, str]]:
        """
        Attribute to provide information on various DBs.
        """
        return pulumi.get(self, "protectable_object_load_path")

    @property
    @pulumi.getter
    def protected(self) -> Optional[bool]:
        """
        To check if backup item is disk protected.
        """
        return pulumi.get(self, "protected")

    @property
    @pulumi.getter(name="protectionGroupName")
    def protection_group_name(self) -> Optional[str]:
        """
        Protection group name of the backup item.
        """
        return pulumi.get(self, "protection_group_name")

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[int]:
        """
        cloud recovery point count.
        """
        return pulumi.get(self, "recovery_point_count")

    @property
    @pulumi.getter(name="totalDiskStorageSizeInBytes")
    def total_disk_storage_size_in_bytes(self) -> Optional[str]:
        """
        total Disk storage in bytes.
        """
        return pulumi.get(self, "total_disk_storage_size_in_bytes")


@pulumi.output_type
class DPMProtectedItemResponse(dict):
    """
    Additional information on Backup engine specific backup item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "workloadType":
            suggest = "workload_type"
        elif key == "backupEngineName":
            suggest = "backup_engine_name"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "softDeleteRetentionPeriod":
            suggest = "soft_delete_retention_period"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DPMProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DPMProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DPMProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 protected_item_type: str,
                 workload_type: str,
                 backup_engine_name: Optional[str] = None,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.DPMProtectedItemExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 is_archive_enabled: Optional[bool] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 last_recovery_point: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 soft_delete_retention_period: Optional[int] = None,
                 source_resource_id: Optional[str] = None):
        """
        Additional information on Backup engine specific backup item.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str protected_item_type: backup item type.
               Expected value is 'DPMProtectedItem'.
        :param str workload_type: Type of workload this item represents.
        :param str backup_engine_name: Backup Management server protecting this backup item
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'DPMProtectedItemExtendedInfoResponse' extended_info: Extended info of the backup item.
        :param str friendly_name: Friendly name of the managed item
        :param bool is_archive_enabled: Flag to identify whether datasource is protected in archive
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str policy_name: Name of the policy used for protection
        :param str protection_state: Protection state of the backup engine
        :param Sequence[str] resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will be performed
        :param int soft_delete_retention_period: Soft delete retention period in days
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "backup_management_type", backup_management_type)
        pulumi.set(__self__, "protected_item_type", 'DPMProtectedItem')
        pulumi.set(__self__, "workload_type", workload_type)
        if backup_engine_name is not None:
            pulumi.set(__self__, "backup_engine_name", backup_engine_name)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if soft_delete_retention_period is not None:
            pulumi.set(__self__, "soft_delete_retention_period", soft_delete_retention_period)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> str:
        """
        backup item type.
        Expected value is 'DPMProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> str:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @property
    @pulumi.getter(name="backupEngineName")
    def backup_engine_name(self) -> Optional[str]:
        """
        Backup Management server protecting this backup item
        """
        return pulumi.get(self, "backup_engine_name")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.DPMProtectedItemExtendedInfoResponse']:
        """
        Extended info of the backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the managed item
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        Flag to identify whether datasource is protected in archive
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Name of the policy used for protection
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Protection state of the backup engine
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuardOperationRequests on which LAC check will be performed
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="softDeleteRetentionPeriod")
    def soft_delete_retention_period(self) -> Optional[int]:
        """
        Soft delete retention period in days
        """
        return pulumi.get(self, "soft_delete_retention_period")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class DailyRetentionFormatResponse(dict):
    """
    Daily retention format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysOfTheMonth":
            suggest = "days_of_the_month"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DailyRetentionFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DailyRetentionFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DailyRetentionFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_of_the_month: Optional[Sequence['outputs.DayResponse']] = None):
        """
        Daily retention format.
        :param Sequence['DayResponse'] days_of_the_month: List of days of the month.
        """
        if days_of_the_month is not None:
            pulumi.set(__self__, "days_of_the_month", days_of_the_month)

    @property
    @pulumi.getter(name="daysOfTheMonth")
    def days_of_the_month(self) -> Optional[Sequence['outputs.DayResponse']]:
        """
        List of days of the month.
        """
        return pulumi.get(self, "days_of_the_month")


@pulumi.output_type
class DailyRetentionScheduleResponse(dict):
    """
    Daily retention schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionDuration":
            suggest = "retention_duration"
        elif key == "retentionTimes":
            suggest = "retention_times"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DailyRetentionScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DailyRetentionScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DailyRetentionScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_duration: Optional['outputs.RetentionDurationResponse'] = None,
                 retention_times: Optional[Sequence[str]] = None):
        """
        Daily retention schedule.
        :param 'RetentionDurationResponse' retention_duration: Retention duration of retention Policy.
        :param Sequence[str] retention_times: Retention times of retention policy.
        """
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_times is not None:
            pulumi.set(__self__, "retention_times", retention_times)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional['outputs.RetentionDurationResponse']:
        """
        Retention duration of retention Policy.
        """
        return pulumi.get(self, "retention_duration")

    @property
    @pulumi.getter(name="retentionTimes")
    def retention_times(self) -> Optional[Sequence[str]]:
        """
        Retention times of retention policy.
        """
        return pulumi.get(self, "retention_times")


@pulumi.output_type
class DailyScheduleResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleRunTimes":
            suggest = "schedule_run_times"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DailyScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DailyScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DailyScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_run_times: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] schedule_run_times: List of times of day this schedule has to be run.
        """
        if schedule_run_times is not None:
            pulumi.set(__self__, "schedule_run_times", schedule_run_times)

    @property
    @pulumi.getter(name="scheduleRunTimes")
    def schedule_run_times(self) -> Optional[Sequence[str]]:
        """
        List of times of day this schedule has to be run.
        """
        return pulumi.get(self, "schedule_run_times")


@pulumi.output_type
class DayResponse(dict):
    """
    Day of the week.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isLast":
            suggest = "is_last"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[int] = None,
                 is_last: Optional[bool] = None):
        """
        Day of the week.
        :param int date: Date of the month
        :param bool is_last: Whether Date is last date of month
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if is_last is not None:
            pulumi.set(__self__, "is_last", is_last)

    @property
    @pulumi.getter
    def date(self) -> Optional[int]:
        """
        Date of the month
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter(name="isLast")
    def is_last(self) -> Optional[bool]:
        """
        Whether Date is last date of month
        """
        return pulumi.get(self, "is_last")


@pulumi.output_type
class DiskExclusionPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskLunList":
            suggest = "disk_lun_list"
        elif key == "isInclusionList":
            suggest = "is_inclusion_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskExclusionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskExclusionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskExclusionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_lun_list: Optional[Sequence[int]] = None,
                 is_inclusion_list: Optional[bool] = None):
        """
        :param Sequence[int] disk_lun_list: List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
        :param bool is_inclusion_list: Flag to indicate whether DiskLunList is to be included/ excluded from backup.
        """
        if disk_lun_list is not None:
            pulumi.set(__self__, "disk_lun_list", disk_lun_list)
        if is_inclusion_list is not None:
            pulumi.set(__self__, "is_inclusion_list", is_inclusion_list)

    @property
    @pulumi.getter(name="diskLunList")
    def disk_lun_list(self) -> Optional[Sequence[int]]:
        """
        List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
        """
        return pulumi.get(self, "disk_lun_list")

    @property
    @pulumi.getter(name="isInclusionList")
    def is_inclusion_list(self) -> Optional[bool]:
        """
        Flag to indicate whether DiskLunList is to be included/ excluded from backup.
        """
        return pulumi.get(self, "is_inclusion_list")


@pulumi.output_type
class DistributedNodesInfoResponse(dict):
    """
    This is used to represent the various nodes of the distributed container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorDetail":
            suggest = "error_detail"
        elif key == "nodeName":
            suggest = "node_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributedNodesInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributedNodesInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributedNodesInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_detail: Optional['outputs.ErrorDetailResponse'] = None,
                 node_name: Optional[str] = None,
                 status: Optional[str] = None):
        """
        This is used to represent the various nodes of the distributed container.
        :param 'ErrorDetailResponse' error_detail: Error Details if the Status is non-success.
        :param str node_name: Name of the node under a distributed container.
        :param str status: Status of this Node.
               Failed | Succeeded
        """
        if error_detail is not None:
            pulumi.set(__self__, "error_detail", error_detail)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="errorDetail")
    def error_detail(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        Error Details if the Status is non-success.
        """
        return pulumi.get(self, "error_detail")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[str]:
        """
        Name of the node under a distributed container.
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of this Node.
        Failed | Succeeded
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DpmContainerResponse(dict):
    """
    DPM workload-specific protection container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerType":
            suggest = "container_type"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "canReRegister":
            suggest = "can_re_register"
        elif key == "containerId":
            suggest = "container_id"
        elif key == "dpmAgentVersion":
            suggest = "dpm_agent_version"
        elif key == "dpmServers":
            suggest = "dpm_servers"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "protectableObjectType":
            suggest = "protectable_object_type"
        elif key == "protectedItemCount":
            suggest = "protected_item_count"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "upgradeAvailable":
            suggest = "upgrade_available"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DpmContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DpmContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DpmContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_type: str,
                 backup_management_type: Optional[str] = None,
                 can_re_register: Optional[bool] = None,
                 container_id: Optional[str] = None,
                 dpm_agent_version: Optional[str] = None,
                 dpm_servers: Optional[Sequence[str]] = None,
                 extended_info: Optional['outputs.DPMContainerExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 protectable_object_type: Optional[str] = None,
                 protected_item_count: Optional[float] = None,
                 protection_status: Optional[str] = None,
                 registration_status: Optional[str] = None,
                 upgrade_available: Optional[bool] = None):
        """
        DPM workload-specific protection container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'DPMContainer'.
        :param str backup_management_type: Type of backup management for the container.
        :param bool can_re_register: Specifies whether the container is re-registrable.
        :param str container_id: ID of container.
        :param str dpm_agent_version: Backup engine Agent version
        :param Sequence[str] dpm_servers: List of BackupEngines protecting the container
        :param 'DPMContainerExtendedInfoResponse' extended_info: Extended Info of the container.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str protectable_object_type: Type of the protectable object associated with this container
        :param float protected_item_count: Number of protected items in the BackupEngine
        :param str protection_status: Protection status of the container.
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param bool upgrade_available: To check if upgrade available
        """
        pulumi.set(__self__, "container_type", 'DPMContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if can_re_register is not None:
            pulumi.set(__self__, "can_re_register", can_re_register)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if dpm_agent_version is not None:
            pulumi.set(__self__, "dpm_agent_version", dpm_agent_version)
        if dpm_servers is not None:
            pulumi.set(__self__, "dpm_servers", dpm_servers)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protectable_object_type is not None:
            pulumi.set(__self__, "protectable_object_type", protectable_object_type)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if upgrade_available is not None:
            pulumi.set(__self__, "upgrade_available", upgrade_available)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> str:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'DPMContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="canReRegister")
    def can_re_register(self) -> Optional[bool]:
        """
        Specifies whether the container is re-registrable.
        """
        return pulumi.get(self, "can_re_register")

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[str]:
        """
        ID of container.
        """
        return pulumi.get(self, "container_id")

    @property
    @pulumi.getter(name="dpmAgentVersion")
    def dpm_agent_version(self) -> Optional[str]:
        """
        Backup engine Agent version
        """
        return pulumi.get(self, "dpm_agent_version")

    @property
    @pulumi.getter(name="dpmServers")
    def dpm_servers(self) -> Optional[Sequence[str]]:
        """
        List of BackupEngines protecting the container
        """
        return pulumi.get(self, "dpm_servers")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.DPMContainerExtendedInfoResponse']:
        """
        Extended Info of the container.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="protectableObjectType")
    def protectable_object_type(self) -> Optional[str]:
        """
        Type of the protectable object associated with this container
        """
        return pulumi.get(self, "protectable_object_type")

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[float]:
        """
        Number of protected items in the BackupEngine
        """
        return pulumi.get(self, "protected_item_count")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[str]:
        """
        Protection status of the container.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="upgradeAvailable")
    def upgrade_available(self) -> Optional[bool]:
        """
        To check if upgrade available
        """
        return pulumi.get(self, "upgrade_available")


@pulumi.output_type
class ErrorDetailResponse(dict):
    """
    Error Detail class which encapsulates Code, Message and Recommendations.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 recommendations: Sequence[str]):
        """
        Error Detail class which encapsulates Code, Message and Recommendations.
        :param str code: Error code.
        :param str message: Error Message related to the Code.
        :param Sequence[str] recommendations: List of recommendation strings.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "recommendations", recommendations)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Error Message related to the Code.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def recommendations(self) -> Sequence[str]:
        """
        List of recommendation strings.
        """
        return pulumi.get(self, "recommendations")


@pulumi.output_type
class ExtendedPropertiesResponse(dict):
    """
    Extended Properties for Azure IaasVM Backup.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskExclusionProperties":
            suggest = "disk_exclusion_properties"
        elif key == "linuxVmApplicationName":
            suggest = "linux_vm_application_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtendedPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtendedPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtendedPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_exclusion_properties: Optional['outputs.DiskExclusionPropertiesResponse'] = None,
                 linux_vm_application_name: Optional[str] = None):
        """
        Extended Properties for Azure IaasVM Backup.
        :param 'DiskExclusionPropertiesResponse' disk_exclusion_properties: Extended Properties for Disk Exclusion.
        :param str linux_vm_application_name: Linux VM name
        """
        if disk_exclusion_properties is not None:
            pulumi.set(__self__, "disk_exclusion_properties", disk_exclusion_properties)
        if linux_vm_application_name is not None:
            pulumi.set(__self__, "linux_vm_application_name", linux_vm_application_name)

    @property
    @pulumi.getter(name="diskExclusionProperties")
    def disk_exclusion_properties(self) -> Optional['outputs.DiskExclusionPropertiesResponse']:
        """
        Extended Properties for Disk Exclusion.
        """
        return pulumi.get(self, "disk_exclusion_properties")

    @property
    @pulumi.getter(name="linuxVmApplicationName")
    def linux_vm_application_name(self) -> Optional[str]:
        """
        Linux VM name
        """
        return pulumi.get(self, "linux_vm_application_name")


@pulumi.output_type
class GenericContainerExtendedInfoResponse(dict):
    """
    Container extended information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerIdentityInfo":
            suggest = "container_identity_info"
        elif key == "rawCertData":
            suggest = "raw_cert_data"
        elif key == "serviceEndpoints":
            suggest = "service_endpoints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GenericContainerExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GenericContainerExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GenericContainerExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_identity_info: Optional['outputs.ContainerIdentityInfoResponse'] = None,
                 raw_cert_data: Optional[str] = None,
                 service_endpoints: Optional[Mapping[str, str]] = None):
        """
        Container extended information
        :param 'ContainerIdentityInfoResponse' container_identity_info: Container identity information
        :param str raw_cert_data: Public key of container cert
        :param Mapping[str, str] service_endpoints: Azure Backup Service Endpoints for the container
        """
        if container_identity_info is not None:
            pulumi.set(__self__, "container_identity_info", container_identity_info)
        if raw_cert_data is not None:
            pulumi.set(__self__, "raw_cert_data", raw_cert_data)
        if service_endpoints is not None:
            pulumi.set(__self__, "service_endpoints", service_endpoints)

    @property
    @pulumi.getter(name="containerIdentityInfo")
    def container_identity_info(self) -> Optional['outputs.ContainerIdentityInfoResponse']:
        """
        Container identity information
        """
        return pulumi.get(self, "container_identity_info")

    @property
    @pulumi.getter(name="rawCertData")
    def raw_cert_data(self) -> Optional[str]:
        """
        Public key of container cert
        """
        return pulumi.get(self, "raw_cert_data")

    @property
    @pulumi.getter(name="serviceEndpoints")
    def service_endpoints(self) -> Optional[Mapping[str, str]]:
        """
        Azure Backup Service Endpoints for the container
        """
        return pulumi.get(self, "service_endpoints")


@pulumi.output_type
class GenericContainerResponse(dict):
    """
    Base class for generic container of backup items
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerType":
            suggest = "container_type"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "extendedInformation":
            suggest = "extended_information"
        elif key == "fabricName":
            suggest = "fabric_name"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "protectableObjectType":
            suggest = "protectable_object_type"
        elif key == "registrationStatus":
            suggest = "registration_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GenericContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GenericContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GenericContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_type: str,
                 backup_management_type: Optional[str] = None,
                 extended_information: Optional['outputs.GenericContainerExtendedInfoResponse'] = None,
                 fabric_name: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 protectable_object_type: Optional[str] = None,
                 registration_status: Optional[str] = None):
        """
        Base class for generic container of backup items
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'GenericContainer'.
        :param str backup_management_type: Type of backup management for the container.
        :param 'GenericContainerExtendedInfoResponse' extended_information: Extended information (not returned in List container API calls)
        :param str fabric_name: Name of the container's fabric
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str protectable_object_type: Type of the protectable object associated with this container
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        """
        pulumi.set(__self__, "container_type", 'GenericContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if extended_information is not None:
            pulumi.set(__self__, "extended_information", extended_information)
        if fabric_name is not None:
            pulumi.set(__self__, "fabric_name", fabric_name)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protectable_object_type is not None:
            pulumi.set(__self__, "protectable_object_type", protectable_object_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> str:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'GenericContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="extendedInformation")
    def extended_information(self) -> Optional['outputs.GenericContainerExtendedInfoResponse']:
        """
        Extended information (not returned in List container API calls)
        """
        return pulumi.get(self, "extended_information")

    @property
    @pulumi.getter(name="fabricName")
    def fabric_name(self) -> Optional[str]:
        """
        Name of the container's fabric
        """
        return pulumi.get(self, "fabric_name")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="protectableObjectType")
    def protectable_object_type(self) -> Optional[str]:
        """
        Type of the protectable object associated with this container
        """
        return pulumi.get(self, "protectable_object_type")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")


@pulumi.output_type
class GenericProtectedItemResponse(dict):
    """
    Base class for backup items.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "workloadType":
            suggest = "workload_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "fabricName":
            suggest = "fabric_name"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "policyState":
            suggest = "policy_state"
        elif key == "protectedItemId":
            suggest = "protected_item_id"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "softDeleteRetentionPeriod":
            suggest = "soft_delete_retention_period"
        elif key == "sourceAssociations":
            suggest = "source_associations"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GenericProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GenericProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GenericProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 protected_item_type: str,
                 workload_type: str,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 fabric_name: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 is_archive_enabled: Optional[bool] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 last_recovery_point: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 policy_state: Optional[str] = None,
                 protected_item_id: Optional[float] = None,
                 protection_state: Optional[str] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 soft_delete_retention_period: Optional[int] = None,
                 source_associations: Optional[Mapping[str, str]] = None,
                 source_resource_id: Optional[str] = None):
        """
        Base class for backup items.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str protected_item_type: backup item type.
               Expected value is 'GenericProtectedItem'.
        :param str workload_type: Type of workload this item represents.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param str fabric_name: Name of this backup item's fabric.
        :param str friendly_name: Friendly name of the container.
        :param bool is_archive_enabled: Flag to identify whether datasource is protected in archive
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str policy_name: Name of the policy used for protection
        :param str policy_state: Indicates consistency of policy object and policy applied to this backup item.
        :param float protected_item_id: Data Plane Service ID of the protected item.
        :param str protection_state: Backup state of this backup item.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will be performed
        :param int soft_delete_retention_period: Soft delete retention period in days
        :param Mapping[str, str] source_associations: Loosely coupled (type, value) associations (example - parent of a protected item)
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "backup_management_type", backup_management_type)
        pulumi.set(__self__, "protected_item_type", 'GenericProtectedItem')
        pulumi.set(__self__, "workload_type", workload_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if fabric_name is not None:
            pulumi.set(__self__, "fabric_name", fabric_name)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if policy_state is not None:
            pulumi.set(__self__, "policy_state", policy_state)
        if protected_item_id is not None:
            pulumi.set(__self__, "protected_item_id", protected_item_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if soft_delete_retention_period is not None:
            pulumi.set(__self__, "soft_delete_retention_period", soft_delete_retention_period)
        if source_associations is not None:
            pulumi.set(__self__, "source_associations", source_associations)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> str:
        """
        backup item type.
        Expected value is 'GenericProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> str:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="fabricName")
    def fabric_name(self) -> Optional[str]:
        """
        Name of this backup item's fabric.
        """
        return pulumi.get(self, "fabric_name")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        Flag to identify whether datasource is protected in archive
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Name of the policy used for protection
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="policyState")
    def policy_state(self) -> Optional[str]:
        """
        Indicates consistency of policy object and policy applied to this backup item.
        """
        return pulumi.get(self, "policy_state")

    @property
    @pulumi.getter(name="protectedItemId")
    def protected_item_id(self) -> Optional[float]:
        """
        Data Plane Service ID of the protected item.
        """
        return pulumi.get(self, "protected_item_id")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuardOperationRequests on which LAC check will be performed
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="softDeleteRetentionPeriod")
    def soft_delete_retention_period(self) -> Optional[int]:
        """
        Soft delete retention period in days
        """
        return pulumi.get(self, "soft_delete_retention_period")

    @property
    @pulumi.getter(name="sourceAssociations")
    def source_associations(self) -> Optional[Mapping[str, str]]:
        """
        Loosely coupled (type, value) associations (example - parent of a protected item)
        """
        return pulumi.get(self, "source_associations")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class GenericProtectionPolicyResponse(dict):
    """
    Azure VM (Mercury) workload-specific backup policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "fabricName":
            suggest = "fabric_name"
        elif key == "protectedItemsCount":
            suggest = "protected_items_count"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "subProtectionPolicy":
            suggest = "sub_protection_policy"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GenericProtectionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GenericProtectionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GenericProtectionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 fabric_name: Optional[str] = None,
                 protected_items_count: Optional[int] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 sub_protection_policy: Optional[Sequence['outputs.SubProtectionPolicyResponse']] = None,
                 time_zone: Optional[str] = None):
        """
        Azure VM (Mercury) workload-specific backup policy.
        :param str backup_management_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'GenericProtectionPolicy'.
        :param str fabric_name: Name of this policy's fabric.
        :param int protected_items_count: Number of items associated with this policy.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuard Operation Requests
        :param Sequence['SubProtectionPolicyResponse'] sub_protection_policy: List of sub-protection policies which includes schedule and retention
        :param str time_zone: TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
        """
        pulumi.set(__self__, "backup_management_type", 'GenericProtectionPolicy')
        if fabric_name is not None:
            pulumi.set(__self__, "fabric_name", fabric_name)
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if sub_protection_policy is not None:
            pulumi.set(__self__, "sub_protection_policy", sub_protection_policy)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'GenericProtectionPolicy'.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="fabricName")
    def fabric_name(self) -> Optional[str]:
        """
        Name of this policy's fabric.
        """
        return pulumi.get(self, "fabric_name")

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[int]:
        """
        Number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuard Operation Requests
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="subProtectionPolicy")
    def sub_protection_policy(self) -> Optional[Sequence['outputs.SubProtectionPolicyResponse']]:
        """
        List of sub-protection policies which includes schedule and retention
        """
        return pulumi.get(self, "sub_protection_policy")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class HourlyScheduleResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleWindowDuration":
            suggest = "schedule_window_duration"
        elif key == "scheduleWindowStartTime":
            suggest = "schedule_window_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HourlyScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HourlyScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HourlyScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval: Optional[int] = None,
                 schedule_window_duration: Optional[int] = None,
                 schedule_window_start_time: Optional[str] = None):
        """
        :param int interval: Interval at which backup needs to be triggered. For hourly the value
                can be 4/6/8/12
        :param int schedule_window_duration: To specify duration of the backup window
        :param str schedule_window_start_time: To specify start time of the backup window
        """
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if schedule_window_duration is not None:
            pulumi.set(__self__, "schedule_window_duration", schedule_window_duration)
        if schedule_window_start_time is not None:
            pulumi.set(__self__, "schedule_window_start_time", schedule_window_start_time)

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        Interval at which backup needs to be triggered. For hourly the value
         can be 4/6/8/12
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="scheduleWindowDuration")
    def schedule_window_duration(self) -> Optional[int]:
        """
        To specify duration of the backup window
        """
        return pulumi.get(self, "schedule_window_duration")

    @property
    @pulumi.getter(name="scheduleWindowStartTime")
    def schedule_window_start_time(self) -> Optional[str]:
        """
        To specify start time of the backup window
        """
        return pulumi.get(self, "schedule_window_start_time")


@pulumi.output_type
class IaaSVMContainerResponse(dict):
    """
    IaaS VM workload-specific container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerType":
            suggest = "container_type"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "protectableObjectType":
            suggest = "protectable_object_type"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "virtualMachineId":
            suggest = "virtual_machine_id"
        elif key == "virtualMachineVersion":
            suggest = "virtual_machine_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IaaSVMContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IaaSVMContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IaaSVMContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_type: str,
                 backup_management_type: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 protectable_object_type: Optional[str] = None,
                 registration_status: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 virtual_machine_id: Optional[str] = None,
                 virtual_machine_version: Optional[str] = None):
        """
        IaaS VM workload-specific container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'IaasVMContainer'.
        :param str backup_management_type: Type of backup management for the container.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str protectable_object_type: Type of the protectable object associated with this container
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param str resource_group: Resource group name of Recovery Services Vault.
        :param str virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        :param str virtual_machine_version: Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        pulumi.set(__self__, "container_type", 'IaasVMContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protectable_object_type is not None:
            pulumi.set(__self__, "protectable_object_type", protectable_object_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if virtual_machine_version is not None:
            pulumi.set(__self__, "virtual_machine_version", virtual_machine_version)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> str:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'IaasVMContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="protectableObjectType")
    def protectable_object_type(self) -> Optional[str]:
        """
        Type of the protectable object associated with this container
        """
        return pulumi.get(self, "protectable_object_type")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Resource group name of Recovery Services Vault.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[str]:
        """
        Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        """
        return pulumi.get(self, "virtual_machine_id")

    @property
    @pulumi.getter(name="virtualMachineVersion")
    def virtual_machine_version(self) -> Optional[str]:
        """
        Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        return pulumi.get(self, "virtual_machine_version")


@pulumi.output_type
class IdentityDataResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserIdentityResponse']] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
        :param Mapping[str, 'UserIdentityResponse'] user_assigned_identities: The list of user-assigned identities associated with the resource. The user-assigned identity dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserIdentityResponse']]:
        """
        The list of user-assigned identities associated with the resource. The user-assigned identity dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class ImmutabilitySettingsResponse(dict):
    """
    Immutability Settings of vault
    """
    def __init__(__self__, *,
                 state: Optional[str] = None):
        """
        Immutability Settings of vault
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        return pulumi.get(self, "state")


@pulumi.output_type
class InquiryInfoResponse(dict):
    """
    Details about inquired protectable items under a given container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorDetail":
            suggest = "error_detail"
        elif key == "inquiryDetails":
            suggest = "inquiry_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InquiryInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InquiryInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InquiryInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_detail: Optional['outputs.ErrorDetailResponse'] = None,
                 inquiry_details: Optional[Sequence['outputs.WorkloadInquiryDetailsResponse']] = None,
                 status: Optional[str] = None):
        """
        Details about inquired protectable items under a given container.
        :param 'ErrorDetailResponse' error_detail: Error Details if the Status is non-success.
        :param Sequence['WorkloadInquiryDetailsResponse'] inquiry_details: Inquiry Details which will have workload specific details.
               For e.g. - For SQL and oracle this will contain different details.
        :param str status: Inquiry Status for this container such as
               InProgress | Failed | Succeeded
        """
        if error_detail is not None:
            pulumi.set(__self__, "error_detail", error_detail)
        if inquiry_details is not None:
            pulumi.set(__self__, "inquiry_details", inquiry_details)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="errorDetail")
    def error_detail(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        Error Details if the Status is non-success.
        """
        return pulumi.get(self, "error_detail")

    @property
    @pulumi.getter(name="inquiryDetails")
    def inquiry_details(self) -> Optional[Sequence['outputs.WorkloadInquiryDetailsResponse']]:
        """
        Inquiry Details which will have workload specific details.
        For e.g. - For SQL and oracle this will contain different details.
        """
        return pulumi.get(self, "inquiry_details")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Inquiry Status for this container such as
        InProgress | Failed | Succeeded
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class InquiryValidationResponse(dict):
    """
    Validation for inquired protectable items under a given container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalDetail":
            suggest = "additional_detail"
        elif key == "errorDetail":
            suggest = "error_detail"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InquiryValidationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InquiryValidationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InquiryValidationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_detail: str,
                 error_detail: Optional['outputs.ErrorDetailResponse'] = None,
                 status: Optional[str] = None):
        """
        Validation for inquired protectable items under a given container.
        :param str additional_detail: Error Additional Detail in case the status is non-success.
        :param 'ErrorDetailResponse' error_detail: Error Detail in case the status is non-success.
        :param str status: Status for the Inquiry Validation.
        """
        pulumi.set(__self__, "additional_detail", additional_detail)
        if error_detail is not None:
            pulumi.set(__self__, "error_detail", error_detail)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="additionalDetail")
    def additional_detail(self) -> str:
        """
        Error Additional Detail in case the status is non-success.
        """
        return pulumi.get(self, "additional_detail")

    @property
    @pulumi.getter(name="errorDetail")
    def error_detail(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        Error Detail in case the status is non-success.
        """
        return pulumi.get(self, "error_detail")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status for the Inquiry Validation.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class InstantRPAdditionalDetailsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureBackupRGNamePrefix":
            suggest = "azure_backup_rg_name_prefix"
        elif key == "azureBackupRGNameSuffix":
            suggest = "azure_backup_rg_name_suffix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstantRPAdditionalDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstantRPAdditionalDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstantRPAdditionalDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_backup_rg_name_prefix: Optional[str] = None,
                 azure_backup_rg_name_suffix: Optional[str] = None):
        if azure_backup_rg_name_prefix is not None:
            pulumi.set(__self__, "azure_backup_rg_name_prefix", azure_backup_rg_name_prefix)
        if azure_backup_rg_name_suffix is not None:
            pulumi.set(__self__, "azure_backup_rg_name_suffix", azure_backup_rg_name_suffix)

    @property
    @pulumi.getter(name="azureBackupRGNamePrefix")
    def azure_backup_rg_name_prefix(self) -> Optional[str]:
        return pulumi.get(self, "azure_backup_rg_name_prefix")

    @property
    @pulumi.getter(name="azureBackupRGNameSuffix")
    def azure_backup_rg_name_suffix(self) -> Optional[str]:
        return pulumi.get(self, "azure_backup_rg_name_suffix")


@pulumi.output_type
class KPIResourceHealthDetailsResponse(dict):
    """
    KPI Resource Health Details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceHealthDetails":
            suggest = "resource_health_details"
        elif key == "resourceHealthStatus":
            suggest = "resource_health_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KPIResourceHealthDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KPIResourceHealthDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KPIResourceHealthDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_health_details: Optional[Sequence['outputs.ResourceHealthDetailsResponse']] = None,
                 resource_health_status: Optional[str] = None):
        """
        KPI Resource Health Details
        :param Sequence['ResourceHealthDetailsResponse'] resource_health_details: Resource Health Status
        :param str resource_health_status: Resource Health Status
        """
        if resource_health_details is not None:
            pulumi.set(__self__, "resource_health_details", resource_health_details)
        if resource_health_status is not None:
            pulumi.set(__self__, "resource_health_status", resource_health_status)

    @property
    @pulumi.getter(name="resourceHealthDetails")
    def resource_health_details(self) -> Optional[Sequence['outputs.ResourceHealthDetailsResponse']]:
        """
        Resource Health Status
        """
        return pulumi.get(self, "resource_health_details")

    @property
    @pulumi.getter(name="resourceHealthStatus")
    def resource_health_status(self) -> Optional[str]:
        """
        Resource Health Status
        """
        return pulumi.get(self, "resource_health_status")


@pulumi.output_type
class LogSchedulePolicyResponse(dict):
    """
    Log policy schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schedulePolicyType":
            suggest = "schedule_policy_type"
        elif key == "scheduleFrequencyInMins":
            suggest = "schedule_frequency_in_mins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogSchedulePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogSchedulePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogSchedulePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_policy_type: str,
                 schedule_frequency_in_mins: Optional[int] = None):
        """
        Log policy schedule.
        :param str schedule_policy_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'LogSchedulePolicy'.
        :param int schedule_frequency_in_mins: Frequency of the log schedule operation of this policy in minutes.
        """
        pulumi.set(__self__, "schedule_policy_type", 'LogSchedulePolicy')
        if schedule_frequency_in_mins is not None:
            pulumi.set(__self__, "schedule_frequency_in_mins", schedule_frequency_in_mins)

    @property
    @pulumi.getter(name="schedulePolicyType")
    def schedule_policy_type(self) -> str:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'LogSchedulePolicy'.
        """
        return pulumi.get(self, "schedule_policy_type")

    @property
    @pulumi.getter(name="scheduleFrequencyInMins")
    def schedule_frequency_in_mins(self) -> Optional[int]:
        """
        Frequency of the log schedule operation of this policy in minutes.
        """
        return pulumi.get(self, "schedule_frequency_in_mins")


@pulumi.output_type
class LongTermRetentionPolicyResponse(dict):
    """
    Long term retention policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPolicyType":
            suggest = "retention_policy_type"
        elif key == "dailySchedule":
            suggest = "daily_schedule"
        elif key == "monthlySchedule":
            suggest = "monthly_schedule"
        elif key == "weeklySchedule":
            suggest = "weekly_schedule"
        elif key == "yearlySchedule":
            suggest = "yearly_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LongTermRetentionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LongTermRetentionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LongTermRetentionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_policy_type: str,
                 daily_schedule: Optional['outputs.DailyRetentionScheduleResponse'] = None,
                 monthly_schedule: Optional['outputs.MonthlyRetentionScheduleResponse'] = None,
                 weekly_schedule: Optional['outputs.WeeklyRetentionScheduleResponse'] = None,
                 yearly_schedule: Optional['outputs.YearlyRetentionScheduleResponse'] = None):
        """
        Long term retention policy.
        :param str retention_policy_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'LongTermRetentionPolicy'.
        :param 'DailyRetentionScheduleResponse' daily_schedule: Daily retention schedule of the protection policy.
        :param 'MonthlyRetentionScheduleResponse' monthly_schedule: Monthly retention schedule of the protection policy.
        :param 'WeeklyRetentionScheduleResponse' weekly_schedule: Weekly retention schedule of the protection policy.
        :param 'YearlyRetentionScheduleResponse' yearly_schedule: Yearly retention schedule of the protection policy.
        """
        pulumi.set(__self__, "retention_policy_type", 'LongTermRetentionPolicy')
        if daily_schedule is not None:
            pulumi.set(__self__, "daily_schedule", daily_schedule)
        if monthly_schedule is not None:
            pulumi.set(__self__, "monthly_schedule", monthly_schedule)
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)
        if yearly_schedule is not None:
            pulumi.set(__self__, "yearly_schedule", yearly_schedule)

    @property
    @pulumi.getter(name="retentionPolicyType")
    def retention_policy_type(self) -> str:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'LongTermRetentionPolicy'.
        """
        return pulumi.get(self, "retention_policy_type")

    @property
    @pulumi.getter(name="dailySchedule")
    def daily_schedule(self) -> Optional['outputs.DailyRetentionScheduleResponse']:
        """
        Daily retention schedule of the protection policy.
        """
        return pulumi.get(self, "daily_schedule")

    @property
    @pulumi.getter(name="monthlySchedule")
    def monthly_schedule(self) -> Optional['outputs.MonthlyRetentionScheduleResponse']:
        """
        Monthly retention schedule of the protection policy.
        """
        return pulumi.get(self, "monthly_schedule")

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional['outputs.WeeklyRetentionScheduleResponse']:
        """
        Weekly retention schedule of the protection policy.
        """
        return pulumi.get(self, "weekly_schedule")

    @property
    @pulumi.getter(name="yearlySchedule")
    def yearly_schedule(self) -> Optional['outputs.YearlyRetentionScheduleResponse']:
        """
        Yearly retention schedule of the protection policy.
        """
        return pulumi.get(self, "yearly_schedule")


@pulumi.output_type
class LongTermSchedulePolicyResponse(dict):
    """
    Long term policy schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schedulePolicyType":
            suggest = "schedule_policy_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LongTermSchedulePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LongTermSchedulePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LongTermSchedulePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_policy_type: str):
        """
        Long term policy schedule.
        :param str schedule_policy_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'LongTermSchedulePolicy'.
        """
        pulumi.set(__self__, "schedule_policy_type", 'LongTermSchedulePolicy')

    @property
    @pulumi.getter(name="schedulePolicyType")
    def schedule_policy_type(self) -> str:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'LongTermSchedulePolicy'.
        """
        return pulumi.get(self, "schedule_policy_type")


@pulumi.output_type
class MABContainerHealthDetailsResponse(dict):
    """
    MAB workload-specific Health Details.
    """
    def __init__(__self__, *,
                 code: Optional[int] = None,
                 message: Optional[str] = None,
                 recommendations: Optional[Sequence[str]] = None,
                 title: Optional[str] = None):
        """
        MAB workload-specific Health Details.
        :param int code: Health Code
        :param str message: Health Message
        :param Sequence[str] recommendations: Health Recommended Actions
        :param str title: Health Title
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if recommendations is not None:
            pulumi.set(__self__, "recommendations", recommendations)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def code(self) -> Optional[int]:
        """
        Health Code
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Health Message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def recommendations(self) -> Optional[Sequence[str]]:
        """
        Health Recommended Actions
        """
        return pulumi.get(self, "recommendations")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        Health Title
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class MabContainerExtendedInfoResponse(dict):
    """
    Additional information of the container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupItemType":
            suggest = "backup_item_type"
        elif key == "backupItems":
            suggest = "backup_items"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastRefreshedAt":
            suggest = "last_refreshed_at"
        elif key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MabContainerExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MabContainerExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MabContainerExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_item_type: Optional[str] = None,
                 backup_items: Optional[Sequence[str]] = None,
                 last_backup_status: Optional[str] = None,
                 last_refreshed_at: Optional[str] = None,
                 policy_name: Optional[str] = None):
        """
        Additional information of the container.
        :param str backup_item_type: Type of backup items associated with this container.
        :param Sequence[str] backup_items: List of backup items associated with this container.
        :param str last_backup_status: Latest backup status of this container.
        :param str last_refreshed_at: Time stamp when this container was refreshed.
        :param str policy_name: Backup policy associated with this container.
        """
        if backup_item_type is not None:
            pulumi.set(__self__, "backup_item_type", backup_item_type)
        if backup_items is not None:
            pulumi.set(__self__, "backup_items", backup_items)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_refreshed_at is not None:
            pulumi.set(__self__, "last_refreshed_at", last_refreshed_at)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter(name="backupItemType")
    def backup_item_type(self) -> Optional[str]:
        """
        Type of backup items associated with this container.
        """
        return pulumi.get(self, "backup_item_type")

    @property
    @pulumi.getter(name="backupItems")
    def backup_items(self) -> Optional[Sequence[str]]:
        """
        List of backup items associated with this container.
        """
        return pulumi.get(self, "backup_items")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Latest backup status of this container.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastRefreshedAt")
    def last_refreshed_at(self) -> Optional[str]:
        """
        Time stamp when this container was refreshed.
        """
        return pulumi.get(self, "last_refreshed_at")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Backup policy associated with this container.
        """
        return pulumi.get(self, "policy_name")


@pulumi.output_type
class MabContainerResponse(dict):
    """
    Container with items backed up using MAB backup engine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerType":
            suggest = "container_type"
        elif key == "agentVersion":
            suggest = "agent_version"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "canReRegister":
            suggest = "can_re_register"
        elif key == "containerHealthState":
            suggest = "container_health_state"
        elif key == "containerId":
            suggest = "container_id"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "mabContainerHealthDetails":
            suggest = "mab_container_health_details"
        elif key == "protectableObjectType":
            suggest = "protectable_object_type"
        elif key == "protectedItemCount":
            suggest = "protected_item_count"
        elif key == "registrationStatus":
            suggest = "registration_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MabContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MabContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MabContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_type: str,
                 agent_version: Optional[str] = None,
                 backup_management_type: Optional[str] = None,
                 can_re_register: Optional[bool] = None,
                 container_health_state: Optional[str] = None,
                 container_id: Optional[float] = None,
                 extended_info: Optional['outputs.MabContainerExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 mab_container_health_details: Optional[Sequence['outputs.MABContainerHealthDetailsResponse']] = None,
                 protectable_object_type: Optional[str] = None,
                 protected_item_count: Optional[float] = None,
                 registration_status: Optional[str] = None):
        """
        Container with items backed up using MAB backup engine.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'Windows'.
        :param str agent_version: Agent version of this container.
        :param str backup_management_type: Type of backup management for the container.
        :param bool can_re_register: Can the container be registered one more time.
        :param str container_health_state: Health state of mab container.
        :param float container_id: ContainerID represents the container.
        :param 'MabContainerExtendedInfoResponse' extended_info: Additional information for this container
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param Sequence['MABContainerHealthDetailsResponse'] mab_container_health_details: Health details on this mab container.
        :param str protectable_object_type: Type of the protectable object associated with this container
        :param float protected_item_count: Number of items backed up in this container.
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        """
        pulumi.set(__self__, "container_type", 'Windows')
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if can_re_register is not None:
            pulumi.set(__self__, "can_re_register", can_re_register)
        if container_health_state is not None:
            pulumi.set(__self__, "container_health_state", container_health_state)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if mab_container_health_details is not None:
            pulumi.set(__self__, "mab_container_health_details", mab_container_health_details)
        if protectable_object_type is not None:
            pulumi.set(__self__, "protectable_object_type", protectable_object_type)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> str:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'Windows'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[str]:
        """
        Agent version of this container.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="canReRegister")
    def can_re_register(self) -> Optional[bool]:
        """
        Can the container be registered one more time.
        """
        return pulumi.get(self, "can_re_register")

    @property
    @pulumi.getter(name="containerHealthState")
    def container_health_state(self) -> Optional[str]:
        """
        Health state of mab container.
        """
        return pulumi.get(self, "container_health_state")

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[float]:
        """
        ContainerID represents the container.
        """
        return pulumi.get(self, "container_id")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.MabContainerExtendedInfoResponse']:
        """
        Additional information for this container
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="mabContainerHealthDetails")
    def mab_container_health_details(self) -> Optional[Sequence['outputs.MABContainerHealthDetailsResponse']]:
        """
        Health details on this mab container.
        """
        return pulumi.get(self, "mab_container_health_details")

    @property
    @pulumi.getter(name="protectableObjectType")
    def protectable_object_type(self) -> Optional[str]:
        """
        Type of the protectable object associated with this container
        """
        return pulumi.get(self, "protectable_object_type")

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[float]:
        """
        Number of items backed up in this container.
        """
        return pulumi.get(self, "protected_item_count")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")


@pulumi.output_type
class MabFileFolderProtectedItemExtendedInfoResponse(dict):
    """
    Additional information on the backed up item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastRefreshedAt":
            suggest = "last_refreshed_at"
        elif key == "oldestRecoveryPoint":
            suggest = "oldest_recovery_point"
        elif key == "recoveryPointCount":
            suggest = "recovery_point_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MabFileFolderProtectedItemExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MabFileFolderProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MabFileFolderProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_refreshed_at: Optional[str] = None,
                 oldest_recovery_point: Optional[str] = None,
                 recovery_point_count: Optional[int] = None):
        """
        Additional information on the backed up item.
        :param str last_refreshed_at: Last time when the agent data synced to service.
        :param str oldest_recovery_point: The oldest backup copy available.
        :param int recovery_point_count: Number of backup copies associated with the backup item.
        """
        if last_refreshed_at is not None:
            pulumi.set(__self__, "last_refreshed_at", last_refreshed_at)
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="lastRefreshedAt")
    def last_refreshed_at(self) -> Optional[str]:
        """
        Last time when the agent data synced to service.
        """
        return pulumi.get(self, "last_refreshed_at")

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[str]:
        """
        The oldest backup copy available.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[int]:
        """
        Number of backup copies associated with the backup item.
        """
        return pulumi.get(self, "recovery_point_count")


@pulumi.output_type
class MabFileFolderProtectedItemResponse(dict):
    """
    MAB workload-specific backup item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "workloadType":
            suggest = "workload_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "computerName":
            suggest = "computer_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteSyncTimeInUTC":
            suggest = "deferred_delete_sync_time_in_utc"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "softDeleteRetentionPeriod":
            suggest = "soft_delete_retention_period"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MabFileFolderProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MabFileFolderProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MabFileFolderProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 protected_item_type: str,
                 workload_type: str,
                 backup_set_name: Optional[str] = None,
                 computer_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_sync_time_in_utc: Optional[float] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.MabFileFolderProtectedItemExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 is_archive_enabled: Optional[bool] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 last_backup_status: Optional[str] = None,
                 last_backup_time: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 soft_delete_retention_period: Optional[int] = None,
                 source_resource_id: Optional[str] = None):
        """
        MAB workload-specific backup item.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str protected_item_type: backup item type.
               Expected value is 'MabFileFolderProtectedItem'.
        :param str workload_type: Type of workload this item represents.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str computer_name: Name of the computer associated with this backup item.
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param float deferred_delete_sync_time_in_utc: Sync time for deferred deletion in UTC
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'MabFileFolderProtectedItemExtendedInfoResponse' extended_info: Additional information with this backup item.
        :param str friendly_name: Friendly name of this backup item.
        :param bool is_archive_enabled: Flag to identify whether datasource is protected in archive
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param str last_backup_status: Status of last backup operation.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str policy_name: Name of the policy used for protection
        :param str protection_state: Protected, ProtectionStopped, IRPending or ProtectionError
        :param Sequence[str] resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will be performed
        :param int soft_delete_retention_period: Soft delete retention period in days
        :param str source_resource_id: ARM ID of the resource to be backed up.
        """
        pulumi.set(__self__, "backup_management_type", backup_management_type)
        pulumi.set(__self__, "protected_item_type", 'MabFileFolderProtectedItem')
        pulumi.set(__self__, "workload_type", workload_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_sync_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_sync_time_in_utc", deferred_delete_sync_time_in_utc)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if soft_delete_retention_period is not None:
            pulumi.set(__self__, "soft_delete_retention_period", soft_delete_retention_period)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> str:
        """
        backup item type.
        Expected value is 'MabFileFolderProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> str:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[str]:
        """
        Name of the computer associated with this backup item.
        """
        return pulumi.get(self, "computer_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteSyncTimeInUTC")
    def deferred_delete_sync_time_in_utc(self) -> Optional[float]:
        """
        Sync time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_sync_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.MabFileFolderProtectedItemExtendedInfoResponse']:
        """
        Additional information with this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        Flag to identify whether datasource is protected in archive
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Status of last backup operation.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[str]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Name of the policy used for protection
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Protected, ProtectionStopped, IRPending or ProtectionError
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuardOperationRequests on which LAC check will be performed
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="softDeleteRetentionPeriod")
    def soft_delete_retention_period(self) -> Optional[int]:
        """
        Soft delete retention period in days
        """
        return pulumi.get(self, "soft_delete_retention_period")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")


@pulumi.output_type
class MabProtectionPolicyResponse(dict):
    """
    Mab container-specific backup policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "protectedItemsCount":
            suggest = "protected_items_count"
        elif key == "resourceGuardOperationRequests":
            suggest = "resource_guard_operation_requests"
        elif key == "retentionPolicy":
            suggest = "retention_policy"
        elif key == "schedulePolicy":
            suggest = "schedule_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MabProtectionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MabProtectionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MabProtectionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: str,
                 protected_items_count: Optional[int] = None,
                 resource_guard_operation_requests: Optional[Sequence[str]] = None,
                 retention_policy: Optional[Any] = None,
                 schedule_policy: Optional[Any] = None):
        """
        Mab container-specific backup policy.
        :param str backup_management_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'MAB'.
        :param int protected_items_count: Number of items associated with this policy.
        :param Sequence[str] resource_guard_operation_requests: ResourceGuard Operation Requests
        :param Union['LongTermRetentionPolicyResponse', 'SimpleRetentionPolicyResponse'] retention_policy: Retention policy details.
        :param Union['LogSchedulePolicyResponse', 'LongTermSchedulePolicyResponse', 'SimpleSchedulePolicyResponse', 'SimpleSchedulePolicyV2Response'] schedule_policy: Backup schedule of backup policy.
        """
        pulumi.set(__self__, "backup_management_type", 'MAB')
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if resource_guard_operation_requests is not None:
            pulumi.set(__self__, "resource_guard_operation_requests", resource_guard_operation_requests)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if schedule_policy is not None:
            pulumi.set(__self__, "schedule_policy", schedule_policy)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> str:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'MAB'.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[int]:
        """
        Number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @property
    @pulumi.getter(name="resourceGuardOperationRequests")
    def resource_guard_operation_requests(self) -> Optional[Sequence[str]]:
        """
        ResourceGuard Operation Requests
        """
        return pulumi.get(self, "resource_guard_operation_requests")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[Any]:
        """
        Retention policy details.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter(name="schedulePolicy")
    def schedule_policy(self) -> Optional[Any]:
        """
        Backup schedule of backup policy.
        """
        return pulumi.get(self, "schedule_policy")


@pulumi.output_type
class MonitoringSettingsResponse(dict):
    """
    Monitoring Settings of the vault
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureMonitorAlertSettings":
            suggest = "azure_monitor_alert_settings"
        elif key == "classicAlertSettings":
            suggest = "classic_alert_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_monitor_alert_settings: Optional['outputs.AzureMonitorAlertSettingsResponse'] = None,
                 classic_alert_settings: Optional['outputs.ClassicAlertSettingsResponse'] = None):
        """
        Monitoring Settings of the vault
        :param 'AzureMonitorAlertSettingsResponse' azure_monitor_alert_settings: Settings for Azure Monitor based alerts
        :param 'ClassicAlertSettingsResponse' classic_alert_settings: Settings for classic alerts
        """
        if azure_monitor_alert_settings is not None:
            pulumi.set(__self__, "azure_monitor_alert_settings", azure_monitor_alert_settings)
        if classic_alert_settings is not None:
            pulumi.set(__self__, "classic_alert_settings", classic_alert_settings)

    @property
    @pulumi.getter(name="azureMonitorAlertSettings")
    def azure_monitor_alert_settings(self) -> Optional['outputs.AzureMonitorAlertSettingsResponse']:
        """
        Settings for Azure Monitor based alerts
        """
        return pulumi.get(self, "azure_monitor_alert_settings")

    @property
    @pulumi.getter(name="classicAlertSettings")
    def classic_alert_settings(self) -> Optional['outputs.ClassicAlertSettingsResponse']:
        """
        Settings for classic alerts
        """
        return pulumi.get(self, "classic_alert_settings")


@pulumi.output_type
class MonthlyRetentionScheduleResponse(dict):
    """
    Monthly retention schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionDuration":
            suggest = "retention_duration"
        elif key == "retentionScheduleDaily":
            suggest = "retention_schedule_daily"
        elif key == "retentionScheduleFormatType":
            suggest = "retention_schedule_format_type"
        elif key == "retentionScheduleWeekly":
            suggest = "retention_schedule_weekly"
        elif key == "retentionTimes":
            suggest = "retention_times"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonthlyRetentionScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonthlyRetentionScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonthlyRetentionScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_duration: Optional['outputs.RetentionDurationResponse'] = None,
                 retention_schedule_daily: Optional['outputs.DailyRetentionFormatResponse'] = None,
                 retention_schedule_format_type: Optional[str] = None,
                 retention_schedule_weekly: Optional['outputs.WeeklyRetentionFormatResponse'] = None,
                 retention_times: Optional[Sequence[str]] = None):
        """
        Monthly retention schedule.
        :param 'RetentionDurationResponse' retention_duration: Retention duration of retention Policy.
        :param 'DailyRetentionFormatResponse' retention_schedule_daily: Daily retention format for monthly retention policy.
        :param str retention_schedule_format_type: Retention schedule format type for monthly retention policy.
        :param 'WeeklyRetentionFormatResponse' retention_schedule_weekly: Weekly retention format for monthly retention policy.
        :param Sequence[str] retention_times: Retention times of retention policy.
        """
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_schedule_daily is not None:
            pulumi.set(__self__, "retention_schedule_daily", retention_schedule_daily)
        if retention_schedule_format_type is not None:
            pulumi.set(__self__, "retention_schedule_format_type", retention_schedule_format_type)
        if retention_schedule_weekly is not None:
            pulumi.set(__self__, "retention_schedule_weekly", retention_schedule_weekly)
        if retention_times is not None:
            pulumi.set(__self__, "retention_times", retention_times)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional['outputs.RetentionDurationResponse']:
        """
        Retention duration of retention Policy.
        """
        return pulumi.get(self, "retention_duration")

    @property
    @pulumi.getter(name="retentionScheduleDaily")
    def retention_schedule_daily(self) -> Optional['outputs.DailyRetentionFormatResponse']:
        """
        Daily retention format for monthly retention policy.
        """
        return pulumi.get(self, "retention_schedule_daily")

    @property
    @pulumi.getter(name="retentionScheduleFormatType")
    def retention_schedule_format_type(self) -> Optional[str]:
        """
        Retention schedule format type for monthly retention policy.
        """
        return pulumi.get(self, "retention_schedule_format_type")

    @property
    @pulumi.getter(name="retentionScheduleWeekly")
    def retention_schedule_weekly(self) -> Optional['outputs.WeeklyRetentionFormatResponse']:
        """
        Weekly retention format for monthly retention policy.
        """
        return pulumi.get(self, "retention_schedule_weekly")

    @property
    @pulumi.getter(name="retentionTimes")
    def retention_times(self) -> Optional[Sequence[str]]:
        """
        Retention times of retention policy.
        """
        return pulumi.get(self, "retention_times")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    Private Endpoint Connection Response Properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStateResponse'] = None,
                 provisioning_state: Optional[str] = None):
        """
        Private Endpoint Connection Response Properties
        :param 'PrivateEndpointResponse' private_endpoint: Gets or sets private endpoint associated with the private endpoint connection
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: Gets or sets private link service connection state
        :param str provisioning_state: Gets or sets provisioning state of the private endpoint connection
        """
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        Gets or sets private endpoint associated with the private endpoint connection
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStateResponse']:
        """
        Gets or sets private link service connection state
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets provisioning state of the private endpoint connection
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class PrivateEndpointConnectionVaultPropertiesResponse(dict):
    """
    Information to be stored in Vault properties as an element of privateEndpointConnections List.
    """
    def __init__(__self__, *,
                 id: str,
                 location: str,
                 name: str,
                 properties: 'outputs.VaultPrivateEndpointConnectionResponse',
                 type: str):
        """
        Information to be stored in Vault properties as an element of privateEndpointConnections List.
        :param str id: Format of id subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.[Service]/{resource}/{resourceName}/privateEndpointConnections/{connectionName}.
        :param str location: The location of the private Endpoint connection
        :param str name: The name of the private Endpoint Connection
        :param 'VaultPrivateEndpointConnectionResponse' properties: Private Endpoint Connection Response Properties.
        :param str type: The type, which will be of the format, Microsoft.RecoveryServices/vaults/privateEndpointConnections
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Format of id subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.[Service]/{resource}/{resourceName}/privateEndpointConnections/{connectionName}.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location of the private Endpoint connection
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the private Endpoint Connection
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.VaultPrivateEndpointConnectionResponse':
        """
        Private Endpoint Connection Response Properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type, which will be of the format, Microsoft.RecoveryServices/vaults/privateEndpointConnections
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint network resource that is linked to the Private Endpoint connection.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The Private Endpoint network resource that is linked to the Private Endpoint connection.
        :param str id: Gets or sets id.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets or sets id.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    Private Link Service Connection State
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionRequired":
            suggest = "action_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        Private Link Service Connection State
        :param str action_required: Gets or sets actions required
        :param str description: Gets or sets description
        :param str status: Gets or sets the status
        """
        if action_required is not None:
            pulumi.set(__self__, "action_required", action_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionRequired")
    def action_required(self) -> Optional[str]:
        """
        Gets or sets actions required
        """
        return pulumi.get(self, "action_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Gets or sets description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Gets or sets the status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ResourceGuardOperationDetailResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultResourceRequest":
            suggest = "default_resource_request"
        elif key == "vaultCriticalOperation":
            suggest = "vault_critical_operation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceGuardOperationDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceGuardOperationDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceGuardOperationDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_resource_request: Optional[str] = None,
                 vault_critical_operation: Optional[str] = None):
        if default_resource_request is not None:
            pulumi.set(__self__, "default_resource_request", default_resource_request)
        if vault_critical_operation is not None:
            pulumi.set(__self__, "vault_critical_operation", vault_critical_operation)

    @property
    @pulumi.getter(name="defaultResourceRequest")
    def default_resource_request(self) -> Optional[str]:
        return pulumi.get(self, "default_resource_request")

    @property
    @pulumi.getter(name="vaultCriticalOperation")
    def vault_critical_operation(self) -> Optional[str]:
        return pulumi.get(self, "vault_critical_operation")


@pulumi.output_type
class ResourceGuardProxyBaseResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdatedTime":
            suggest = "last_updated_time"
        elif key == "resourceGuardOperationDetails":
            suggest = "resource_guard_operation_details"
        elif key == "resourceGuardResourceId":
            suggest = "resource_guard_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceGuardProxyBaseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceGuardProxyBaseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceGuardProxyBaseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 last_updated_time: Optional[str] = None,
                 resource_guard_operation_details: Optional[Sequence['outputs.ResourceGuardOperationDetailResponse']] = None,
                 resource_guard_resource_id: Optional[str] = None):
        if description is not None:
            pulumi.set(__self__, "description", description)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if resource_guard_operation_details is not None:
            pulumi.set(__self__, "resource_guard_operation_details", resource_guard_operation_details)
        if resource_guard_resource_id is not None:
            pulumi.set(__self__, "resource_guard_resource_id", resource_guard_resource_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[str]:
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter(name="resourceGuardOperationDetails")
    def resource_guard_operation_details(self) -> Optional[Sequence['outputs.ResourceGuardOperationDetailResponse']]:
        return pulumi.get(self, "resource_guard_operation_details")

    @property
    @pulumi.getter(name="resourceGuardResourceId")
    def resource_guard_resource_id(self) -> Optional[str]:
        return pulumi.get(self, "resource_guard_resource_id")


@pulumi.output_type
class ResourceHealthDetailsResponse(dict):
    """
    Health Details for backup items.
    """
    def __init__(__self__, *,
                 code: int,
                 message: str,
                 recommendations: Sequence[str],
                 title: str):
        """
        Health Details for backup items.
        :param int code: Health Code
        :param str message: Health Message
        :param Sequence[str] recommendations: Health Recommended Actions
        :param str title: Health Title
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "recommendations", recommendations)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        Health Code
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Health Message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def recommendations(self) -> Sequence[str]:
        """
        Health Recommended Actions
        """
        return pulumi.get(self, "recommendations")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Health Title
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class RetentionDurationResponse(dict):
    """
    Retention duration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationType":
            suggest = "duration_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetentionDurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetentionDurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetentionDurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[int] = None,
                 duration_type: Optional[str] = None):
        """
        Retention duration.
        :param int count: Count of duration types. Retention duration is obtained by the counting the duration type Count times.
               For example, when Count = 3 and DurationType = Weeks, retention duration will be three weeks.
        :param str duration_type: Retention duration type of retention policy.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if duration_type is not None:
            pulumi.set(__self__, "duration_type", duration_type)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        Count of duration types. Retention duration is obtained by the counting the duration type Count times.
        For example, when Count = 3 and DurationType = Weeks, retention duration will be three weeks.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="durationType")
    def duration_type(self) -> Optional[str]:
        """
        Retention duration type of retention policy.
        """
        return pulumi.get(self, "duration_type")


@pulumi.output_type
class SecuritySettingsResponse(dict):
    """
    Security Settings of the vault
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "immutabilitySettings":
            suggest = "immutability_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecuritySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecuritySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecuritySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 immutability_settings: Optional['outputs.ImmutabilitySettingsResponse'] = None):
        """
        Security Settings of the vault
        :param 'ImmutabilitySettingsResponse' immutability_settings: Immutability Settings of a vault
        """
        if immutability_settings is not None:
            pulumi.set(__self__, "immutability_settings", immutability_settings)

    @property
    @pulumi.getter(name="immutabilitySettings")
    def immutability_settings(self) -> Optional['outputs.ImmutabilitySettingsResponse']:
        """
        Immutability Settings of a vault
        """
        return pulumi.get(self, "immutability_settings")


@pulumi.output_type
class SettingsResponse(dict):
    """
    Common settings field for backup management
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isCompression":
            suggest = "is_compression"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_compression: Optional[bool] = None,
                 issqlcompression: Optional[bool] = None,
                 time_zone: Optional[str] = None):
        """
        Common settings field for backup management
        :param bool is_compression: Workload compression flag. This has been added so that 'isSqlCompression'
               will be deprecated once clients upgrade to consider this flag.
        :param bool issqlcompression: SQL compression flag
        :param str time_zone: TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
        """
        if is_compression is not None:
            pulumi.set(__self__, "is_compression", is_compression)
        if issqlcompression is not None:
            pulumi.set(__self__, "issqlcompression", issqlcompression)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="isCompression")
    def is_compression(self) -> Optional[bool]:
        """
        Workload compression flag. This has been added so that 'isSqlCompression'
        will be deprecated once clients upgrade to consider this flag.
        """
        return pulumi.get(self, "is_compression")

    @property
    @pulumi.getter
    def issqlcompression(self) -> Optional[bool]:
        """
        SQL compression flag
        """
        return pulumi.get(self, "issqlcompression")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class SimpleRetentionPolicyResponse(dict):
    """
    Simple policy retention.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPolicyType":
            suggest = "retention_policy_type"
        elif key == "retentionDuration":
            suggest = "retention_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SimpleRetentionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SimpleRetentionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SimpleRetentionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_policy_type: str,
                 retention_duration: Optional['outputs.RetentionDurationResponse'] = None):
        """
        Simple policy retention.
        :param str retention_policy_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'SimpleRetentionPolicy'.
        :param 'RetentionDurationResponse' retention_duration: Retention duration of the protection policy.
        """
        pulumi.set(__self__, "retention_policy_type", 'SimpleRetentionPolicy')
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)

    @property
    @pulumi.getter(name="retentionPolicyType")
    def retention_policy_type(self) -> str:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'SimpleRetentionPolicy'.
        """
        return pulumi.get(self, "retention_policy_type")

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional['outputs.RetentionDurationResponse']:
        """
        Retention duration of the protection policy.
        """
        return pulumi.get(self, "retention_duration")


@pulumi.output_type
class SimpleSchedulePolicyResponse(dict):
    """
    Simple policy schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schedulePolicyType":
            suggest = "schedule_policy_type"
        elif key == "hourlySchedule":
            suggest = "hourly_schedule"
        elif key == "scheduleRunDays":
            suggest = "schedule_run_days"
        elif key == "scheduleRunFrequency":
            suggest = "schedule_run_frequency"
        elif key == "scheduleRunTimes":
            suggest = "schedule_run_times"
        elif key == "scheduleWeeklyFrequency":
            suggest = "schedule_weekly_frequency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SimpleSchedulePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SimpleSchedulePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SimpleSchedulePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_policy_type: str,
                 hourly_schedule: Optional['outputs.HourlyScheduleResponse'] = None,
                 schedule_run_days: Optional[Sequence[str]] = None,
                 schedule_run_frequency: Optional[str] = None,
                 schedule_run_times: Optional[Sequence[str]] = None,
                 schedule_weekly_frequency: Optional[int] = None):
        """
        Simple policy schedule.
        :param str schedule_policy_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'SimpleSchedulePolicy'.
        :param 'HourlyScheduleResponse' hourly_schedule: Hourly Schedule of this Policy
        :param Sequence[str] schedule_run_days: List of days of week this schedule has to be run.
        :param str schedule_run_frequency: Frequency of the schedule operation of this policy.
        :param Sequence[str] schedule_run_times: List of times of day this schedule has to be run.
        :param int schedule_weekly_frequency: At every number weeks this schedule has to be run.
        """
        pulumi.set(__self__, "schedule_policy_type", 'SimpleSchedulePolicy')
        if hourly_schedule is not None:
            pulumi.set(__self__, "hourly_schedule", hourly_schedule)
        if schedule_run_days is not None:
            pulumi.set(__self__, "schedule_run_days", schedule_run_days)
        if schedule_run_frequency is not None:
            pulumi.set(__self__, "schedule_run_frequency", schedule_run_frequency)
        if schedule_run_times is not None:
            pulumi.set(__self__, "schedule_run_times", schedule_run_times)
        if schedule_weekly_frequency is not None:
            pulumi.set(__self__, "schedule_weekly_frequency", schedule_weekly_frequency)

    @property
    @pulumi.getter(name="schedulePolicyType")
    def schedule_policy_type(self) -> str:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'SimpleSchedulePolicy'.
        """
        return pulumi.get(self, "schedule_policy_type")

    @property
    @pulumi.getter(name="hourlySchedule")
    def hourly_schedule(self) -> Optional['outputs.HourlyScheduleResponse']:
        """
        Hourly Schedule of this Policy
        """
        return pulumi.get(self, "hourly_schedule")

    @property
    @pulumi.getter(name="scheduleRunDays")
    def schedule_run_days(self) -> Optional[Sequence[str]]:
        """
        List of days of week this schedule has to be run.
        """
        return pulumi.get(self, "schedule_run_days")

    @property
    @pulumi.getter(name="scheduleRunFrequency")
    def schedule_run_frequency(self) -> Optional[str]:
        """
        Frequency of the schedule operation of this policy.
        """
        return pulumi.get(self, "schedule_run_frequency")

    @property
    @pulumi.getter(name="scheduleRunTimes")
    def schedule_run_times(self) -> Optional[Sequence[str]]:
        """
        List of times of day this schedule has to be run.
        """
        return pulumi.get(self, "schedule_run_times")

    @property
    @pulumi.getter(name="scheduleWeeklyFrequency")
    def schedule_weekly_frequency(self) -> Optional[int]:
        """
        At every number weeks this schedule has to be run.
        """
        return pulumi.get(self, "schedule_weekly_frequency")


@pulumi.output_type
class SimpleSchedulePolicyV2Response(dict):
    """
    The V2 policy schedule for IaaS that supports hourly backups.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schedulePolicyType":
            suggest = "schedule_policy_type"
        elif key == "dailySchedule":
            suggest = "daily_schedule"
        elif key == "hourlySchedule":
            suggest = "hourly_schedule"
        elif key == "scheduleRunFrequency":
            suggest = "schedule_run_frequency"
        elif key == "weeklySchedule":
            suggest = "weekly_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SimpleSchedulePolicyV2Response. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SimpleSchedulePolicyV2Response.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SimpleSchedulePolicyV2Response.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_policy_type: str,
                 daily_schedule: Optional['outputs.DailyScheduleResponse'] = None,
                 hourly_schedule: Optional['outputs.HourlyScheduleResponse'] = None,
                 schedule_run_frequency: Optional[str] = None,
                 weekly_schedule: Optional['outputs.WeeklyScheduleResponse'] = None):
        """
        The V2 policy schedule for IaaS that supports hourly backups.
        :param str schedule_policy_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'SimpleSchedulePolicyV2'.
        :param 'DailyScheduleResponse' daily_schedule: Daily schedule of this policy
        :param 'HourlyScheduleResponse' hourly_schedule: hourly schedule of this policy
        :param str schedule_run_frequency: Frequency of the schedule operation of this policy.
        :param 'WeeklyScheduleResponse' weekly_schedule: Weekly schedule of this policy
        """
        pulumi.set(__self__, "schedule_policy_type", 'SimpleSchedulePolicyV2')
        if daily_schedule is not None:
            pulumi.set(__self__, "daily_schedule", daily_schedule)
        if hourly_schedule is not None:
            pulumi.set(__self__, "hourly_schedule", hourly_schedule)
        if schedule_run_frequency is not None:
            pulumi.set(__self__, "schedule_run_frequency", schedule_run_frequency)
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)

    @property
    @pulumi.getter(name="schedulePolicyType")
    def schedule_policy_type(self) -> str:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'SimpleSchedulePolicyV2'.
        """
        return pulumi.get(self, "schedule_policy_type")

    @property
    @pulumi.getter(name="dailySchedule")
    def daily_schedule(self) -> Optional['outputs.DailyScheduleResponse']:
        """
        Daily schedule of this policy
        """
        return pulumi.get(self, "daily_schedule")

    @property
    @pulumi.getter(name="hourlySchedule")
    def hourly_schedule(self) -> Optional['outputs.HourlyScheduleResponse']:
        """
        hourly schedule of this policy
        """
        return pulumi.get(self, "hourly_schedule")

    @property
    @pulumi.getter(name="scheduleRunFrequency")
    def schedule_run_frequency(self) -> Optional[str]:
        """
        Frequency of the schedule operation of this policy.
        """
        return pulumi.get(self, "schedule_run_frequency")

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional['outputs.WeeklyScheduleResponse']:
        """
        Weekly schedule of this policy
        """
        return pulumi.get(self, "weekly_schedule")


@pulumi.output_type
class SkuResponse(dict):
    """
    Identifies the unique system identifier for each Azure resource.
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[str] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        Identifies the unique system identifier for each Azure resource.
        :param str name: Name of SKU is RS0 (Recovery Services 0th version) and the tier is standard tier. They do not have affect on backend storage redundancy or any other vault settings. To manage storage redundancy, use the backupstorageconfig
        :param str capacity: The sku capacity
        :param str family: The sku family
        :param str size: The sku size
        :param str tier: The Sku tier.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of SKU is RS0 (Recovery Services 0th version) and the tier is standard tier. They do not have affect on backend storage redundancy or any other vault settings. To manage storage redundancy, use the backupstorageconfig
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[str]:
        """
        The sku capacity
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        The sku family
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The sku size
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The Sku tier.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SubProtectionPolicyResponse(dict):
    """
    Sub-protection policy which includes schedule and retention
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyType":
            suggest = "policy_type"
        elif key == "retentionPolicy":
            suggest = "retention_policy"
        elif key == "schedulePolicy":
            suggest = "schedule_policy"
        elif key == "tieringPolicy":
            suggest = "tiering_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubProtectionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubProtectionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubProtectionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_type: Optional[str] = None,
                 retention_policy: Optional[Any] = None,
                 schedule_policy: Optional[Any] = None,
                 tiering_policy: Optional[Mapping[str, 'outputs.TieringPolicyResponse']] = None):
        """
        Sub-protection policy which includes schedule and retention
        :param str policy_type: Type of backup policy type
        :param Union['LongTermRetentionPolicyResponse', 'SimpleRetentionPolicyResponse'] retention_policy: Retention policy with the details on backup copy retention ranges.
        :param Union['LogSchedulePolicyResponse', 'LongTermSchedulePolicyResponse', 'SimpleSchedulePolicyResponse', 'SimpleSchedulePolicyV2Response'] schedule_policy: Backup schedule specified as part of backup policy.
        :param Mapping[str, 'TieringPolicyResponse'] tiering_policy: Tiering policy to automatically move RPs to another tier.
               Key is Target Tier, defined in RecoveryPointTierType enum.
               Tiering policy specifies the criteria to move RP to the target tier.
        """
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if schedule_policy is not None:
            pulumi.set(__self__, "schedule_policy", schedule_policy)
        if tiering_policy is not None:
            pulumi.set(__self__, "tiering_policy", tiering_policy)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[str]:
        """
        Type of backup policy type
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[Any]:
        """
        Retention policy with the details on backup copy retention ranges.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter(name="schedulePolicy")
    def schedule_policy(self) -> Optional[Any]:
        """
        Backup schedule specified as part of backup policy.
        """
        return pulumi.get(self, "schedule_policy")

    @property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> Optional[Mapping[str, 'outputs.TieringPolicyResponse']]:
        """
        Tiering policy to automatically move RPs to another tier.
        Key is Target Tier, defined in RecoveryPointTierType enum.
        Tiering policy specifies the criteria to move RP to the target tier.
        """
        return pulumi.get(self, "tiering_policy")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The type of identity that last modified the resource.
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TieringPolicyResponse(dict):
    """
    Tiering Policy for a target tier.
    If the policy is not specified for a given target tier, service retains the existing configured tiering policy for that tier
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationType":
            suggest = "duration_type"
        elif key == "tieringMode":
            suggest = "tiering_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TieringPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TieringPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TieringPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: Optional[int] = None,
                 duration_type: Optional[str] = None,
                 tiering_mode: Optional[str] = None):
        """
        Tiering Policy for a target tier.
        If the policy is not specified for a given target tier, service retains the existing configured tiering policy for that tier
        :param int duration: Number of days/weeks/months/years to retain backups in current tier before tiering.
               Used only if TieringMode is set to TierAfter
        :param str duration_type: Retention duration type: days/weeks/months/years
               Used only if TieringMode is set to TierAfter
        :param str tiering_mode: Tiering Mode to control automatic tiering of recovery points. Supported values are:
               1. TierRecommended: Tier all recovery points recommended to be tiered
               2. TierAfter: Tier all recovery points after a fixed period, as specified in duration + durationType below.
               3. DoNotTier: Do not tier any recovery points
        """
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if duration_type is not None:
            pulumi.set(__self__, "duration_type", duration_type)
        if tiering_mode is not None:
            pulumi.set(__self__, "tiering_mode", tiering_mode)

    @property
    @pulumi.getter
    def duration(self) -> Optional[int]:
        """
        Number of days/weeks/months/years to retain backups in current tier before tiering.
        Used only if TieringMode is set to TierAfter
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="durationType")
    def duration_type(self) -> Optional[str]:
        """
        Retention duration type: days/weeks/months/years
        Used only if TieringMode is set to TierAfter
        """
        return pulumi.get(self, "duration_type")

    @property
    @pulumi.getter(name="tieringMode")
    def tiering_mode(self) -> Optional[str]:
        """
        Tiering Mode to control automatic tiering of recovery points. Supported values are:
        1. TierRecommended: Tier all recovery points recommended to be tiered
        2. TierAfter: Tier all recovery points after a fixed period, as specified in duration + durationType below.
        3. DoNotTier: Do not tier any recovery points
        """
        return pulumi.get(self, "tiering_mode")


@pulumi.output_type
class UpgradeDetailsResponse(dict):
    """
    Details for upgrading vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTimeUtc":
            suggest = "end_time_utc"
        elif key == "lastUpdatedTimeUtc":
            suggest = "last_updated_time_utc"
        elif key == "operationId":
            suggest = "operation_id"
        elif key == "previousResourceId":
            suggest = "previous_resource_id"
        elif key == "startTimeUtc":
            suggest = "start_time_utc"
        elif key == "triggerType":
            suggest = "trigger_type"
        elif key == "upgradedResourceId":
            suggest = "upgraded_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpgradeDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpgradeDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpgradeDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time_utc: str,
                 last_updated_time_utc: str,
                 message: str,
                 operation_id: str,
                 previous_resource_id: str,
                 start_time_utc: str,
                 status: str,
                 trigger_type: str,
                 upgraded_resource_id: str):
        """
        Details for upgrading vault.
        :param str end_time_utc: UTC time at which the upgrade operation has ended.
        :param str last_updated_time_utc: UTC time at which the upgrade operation status was last updated.
        :param str message: Message to the user containing information about the upgrade operation.
        :param str operation_id: ID of the vault upgrade operation.
        :param str previous_resource_id: Resource ID of the vault before the upgrade.
        :param str start_time_utc: UTC time at which the upgrade operation has started.
        :param str status: Status of the vault upgrade operation.
        :param str trigger_type: The way the vault upgrade was triggered.
        :param str upgraded_resource_id: Resource ID of the upgraded vault.
        """
        pulumi.set(__self__, "end_time_utc", end_time_utc)
        pulumi.set(__self__, "last_updated_time_utc", last_updated_time_utc)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "operation_id", operation_id)
        pulumi.set(__self__, "previous_resource_id", previous_resource_id)
        pulumi.set(__self__, "start_time_utc", start_time_utc)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "trigger_type", trigger_type)
        pulumi.set(__self__, "upgraded_resource_id", upgraded_resource_id)

    @property
    @pulumi.getter(name="endTimeUtc")
    def end_time_utc(self) -> str:
        """
        UTC time at which the upgrade operation has ended.
        """
        return pulumi.get(self, "end_time_utc")

    @property
    @pulumi.getter(name="lastUpdatedTimeUtc")
    def last_updated_time_utc(self) -> str:
        """
        UTC time at which the upgrade operation status was last updated.
        """
        return pulumi.get(self, "last_updated_time_utc")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Message to the user containing information about the upgrade operation.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> str:
        """
        ID of the vault upgrade operation.
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter(name="previousResourceId")
    def previous_resource_id(self) -> str:
        """
        Resource ID of the vault before the upgrade.
        """
        return pulumi.get(self, "previous_resource_id")

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> str:
        """
        UTC time at which the upgrade operation has started.
        """
        return pulumi.get(self, "start_time_utc")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the vault upgrade operation.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> str:
        """
        The way the vault upgrade was triggered.
        """
        return pulumi.get(self, "trigger_type")

    @property
    @pulumi.getter(name="upgradedResourceId")
    def upgraded_resource_id(self) -> str:
        """
        Resource ID of the upgraded vault.
        """
        return pulumi.get(self, "upgraded_resource_id")


@pulumi.output_type
class UserIdentityResponse(dict):
    """
    A resource identity that is managed by the user of the service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        A resource identity that is managed by the user of the service.
        :param str client_id: The client ID of the user-assigned identity.
        :param str principal_id: The principal ID of the user-assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID of the user-assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the user-assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class VaultPrivateEndpointConnectionResponse(dict):
    """
    Private Endpoint Connection Response Properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "groupIds":
            suggest = "group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_endpoint: 'outputs.PrivateEndpointResponse',
                 private_link_service_connection_state: 'outputs.VaultPrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str,
                 group_ids: Optional[Sequence[str]] = None):
        """
        Private Endpoint Connection Response Properties.
        :param 'PrivateEndpointResponse' private_endpoint: The Private Endpoint network resource that is linked to the Private Endpoint connection.
        :param 'VaultPrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: Gets or sets private link service connection state.
        :param str provisioning_state: Gets or sets provisioning state of the private endpoint connection.
        :param Sequence[str] group_ids: Group Ids for the Private Endpoint
        """
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> 'outputs.PrivateEndpointResponse':
        """
        The Private Endpoint network resource that is linked to the Private Endpoint connection.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.VaultPrivateLinkServiceConnectionStateResponse':
        """
        Gets or sets private link service connection state.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets or sets provisioning state of the private endpoint connection.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[Sequence[str]]:
        """
        Group Ids for the Private Endpoint
        """
        return pulumi.get(self, "group_ids")


@pulumi.output_type
class VaultPrivateLinkServiceConnectionStateResponse(dict):
    """
    Gets or sets private link service connection state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: str,
                 description: str,
                 status: str):
        """
        Gets or sets private link service connection state.
        :param str actions_required: Gets or sets actions required.
        :param str description: Gets or sets description.
        :param str status: Gets or sets the status.
        """
        pulumi.set(__self__, "actions_required", actions_required)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> str:
        """
        Gets or sets actions required.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Gets or sets description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Gets or sets the status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class VaultPropertiesResponse(dict):
    """
    Properties of the vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupStorageVersion":
            suggest = "backup_storage_version"
        elif key == "moveState":
            suggest = "move_state"
        elif key == "privateEndpointConnections":
            suggest = "private_endpoint_connections"
        elif key == "privateEndpointStateForBackup":
            suggest = "private_endpoint_state_for_backup"
        elif key == "privateEndpointStateForSiteRecovery":
            suggest = "private_endpoint_state_for_site_recovery"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "monitoringSettings":
            suggest = "monitoring_settings"
        elif key == "moveDetails":
            suggest = "move_details"
        elif key == "publicNetworkAccess":
            suggest = "public_network_access"
        elif key == "redundancySettings":
            suggest = "redundancy_settings"
        elif key == "securitySettings":
            suggest = "security_settings"
        elif key == "upgradeDetails":
            suggest = "upgrade_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_storage_version: str,
                 move_state: str,
                 private_endpoint_connections: Sequence['outputs.PrivateEndpointConnectionVaultPropertiesResponse'],
                 private_endpoint_state_for_backup: str,
                 private_endpoint_state_for_site_recovery: str,
                 provisioning_state: str,
                 encryption: Optional['outputs.VaultPropertiesResponseEncryption'] = None,
                 monitoring_settings: Optional['outputs.MonitoringSettingsResponse'] = None,
                 move_details: Optional['outputs.VaultPropertiesResponseMoveDetails'] = None,
                 public_network_access: Optional[str] = None,
                 redundancy_settings: Optional['outputs.VaultPropertiesResponseRedundancySettings'] = None,
                 security_settings: Optional['outputs.SecuritySettingsResponse'] = None,
                 upgrade_details: Optional['outputs.UpgradeDetailsResponse'] = None):
        """
        Properties of the vault.
        :param str backup_storage_version: Backup storage version
        :param str move_state: The State of the Resource after the move operation
        :param Sequence['PrivateEndpointConnectionVaultPropertiesResponse'] private_endpoint_connections: List of private endpoint connection.
        :param str private_endpoint_state_for_backup: Private endpoint state for backup.
        :param str private_endpoint_state_for_site_recovery: Private endpoint state for site recovery.
        :param str provisioning_state: Provisioning State.
        :param 'VaultPropertiesResponseEncryption' encryption: Customer Managed Key details of the resource.
        :param 'MonitoringSettingsResponse' monitoring_settings: Monitoring Settings of the vault
        :param 'VaultPropertiesResponseMoveDetails' move_details: The details of the latest move operation performed on the Azure Resource
        :param str public_network_access: property to enable or disable resource provider inbound network traffic from public clients
        :param 'VaultPropertiesResponseRedundancySettings' redundancy_settings: The redundancy Settings of a Vault
        :param 'SecuritySettingsResponse' security_settings: Security Settings of the vault
        :param 'UpgradeDetailsResponse' upgrade_details: Details for upgrading vault.
        """
        pulumi.set(__self__, "backup_storage_version", backup_storage_version)
        pulumi.set(__self__, "move_state", move_state)
        pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        pulumi.set(__self__, "private_endpoint_state_for_backup", private_endpoint_state_for_backup)
        pulumi.set(__self__, "private_endpoint_state_for_site_recovery", private_endpoint_state_for_site_recovery)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if monitoring_settings is not None:
            pulumi.set(__self__, "monitoring_settings", monitoring_settings)
        if move_details is not None:
            pulumi.set(__self__, "move_details", move_details)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if redundancy_settings is not None:
            pulumi.set(__self__, "redundancy_settings", redundancy_settings)
        if security_settings is not None:
            pulumi.set(__self__, "security_settings", security_settings)
        if upgrade_details is not None:
            pulumi.set(__self__, "upgrade_details", upgrade_details)

    @property
    @pulumi.getter(name="backupStorageVersion")
    def backup_storage_version(self) -> str:
        """
        Backup storage version
        """
        return pulumi.get(self, "backup_storage_version")

    @property
    @pulumi.getter(name="moveState")
    def move_state(self) -> str:
        """
        The State of the Resource after the move operation
        """
        return pulumi.get(self, "move_state")

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Sequence['outputs.PrivateEndpointConnectionVaultPropertiesResponse']:
        """
        List of private endpoint connection.
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter(name="privateEndpointStateForBackup")
    def private_endpoint_state_for_backup(self) -> str:
        """
        Private endpoint state for backup.
        """
        return pulumi.get(self, "private_endpoint_state_for_backup")

    @property
    @pulumi.getter(name="privateEndpointStateForSiteRecovery")
    def private_endpoint_state_for_site_recovery(self) -> str:
        """
        Private endpoint state for site recovery.
        """
        return pulumi.get(self, "private_endpoint_state_for_site_recovery")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning State.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.VaultPropertiesResponseEncryption']:
        """
        Customer Managed Key details of the resource.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="monitoringSettings")
    def monitoring_settings(self) -> Optional['outputs.MonitoringSettingsResponse']:
        """
        Monitoring Settings of the vault
        """
        return pulumi.get(self, "monitoring_settings")

    @property
    @pulumi.getter(name="moveDetails")
    def move_details(self) -> Optional['outputs.VaultPropertiesResponseMoveDetails']:
        """
        The details of the latest move operation performed on the Azure Resource
        """
        return pulumi.get(self, "move_details")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        """
        property to enable or disable resource provider inbound network traffic from public clients
        """
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter(name="redundancySettings")
    def redundancy_settings(self) -> Optional['outputs.VaultPropertiesResponseRedundancySettings']:
        """
        The redundancy Settings of a Vault
        """
        return pulumi.get(self, "redundancy_settings")

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> Optional['outputs.SecuritySettingsResponse']:
        """
        Security Settings of the vault
        """
        return pulumi.get(self, "security_settings")

    @property
    @pulumi.getter(name="upgradeDetails")
    def upgrade_details(self) -> Optional['outputs.UpgradeDetailsResponse']:
        """
        Details for upgrading vault.
        """
        return pulumi.get(self, "upgrade_details")


@pulumi.output_type
class VaultPropertiesResponseEncryption(dict):
    """
    Customer Managed Key details of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "infrastructureEncryption":
            suggest = "infrastructure_encryption"
        elif key == "kekIdentity":
            suggest = "kek_identity"
        elif key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPropertiesResponseEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPropertiesResponseEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPropertiesResponseEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 infrastructure_encryption: Optional[str] = None,
                 kek_identity: Optional['outputs.CmkKekIdentityResponse'] = None,
                 key_vault_properties: Optional['outputs.CmkKeyVaultPropertiesResponse'] = None):
        """
        Customer Managed Key details of the resource.
        :param str infrastructure_encryption: Enabling/Disabling the Double Encryption state
        :param 'CmkKekIdentityResponse' kek_identity: The details of the identity used for CMK
        :param 'CmkKeyVaultPropertiesResponse' key_vault_properties: The properties of the Key Vault which hosts CMK
        """
        if infrastructure_encryption is not None:
            pulumi.set(__self__, "infrastructure_encryption", infrastructure_encryption)
        if kek_identity is not None:
            pulumi.set(__self__, "kek_identity", kek_identity)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)

    @property
    @pulumi.getter(name="infrastructureEncryption")
    def infrastructure_encryption(self) -> Optional[str]:
        """
        Enabling/Disabling the Double Encryption state
        """
        return pulumi.get(self, "infrastructure_encryption")

    @property
    @pulumi.getter(name="kekIdentity")
    def kek_identity(self) -> Optional['outputs.CmkKekIdentityResponse']:
        """
        The details of the identity used for CMK
        """
        return pulumi.get(self, "kek_identity")

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional['outputs.CmkKeyVaultPropertiesResponse']:
        """
        The properties of the Key Vault which hosts CMK
        """
        return pulumi.get(self, "key_vault_properties")


@pulumi.output_type
class VaultPropertiesResponseMoveDetails(dict):
    """
    The details of the latest move operation performed on the Azure Resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completionTimeUtc":
            suggest = "completion_time_utc"
        elif key == "operationId":
            suggest = "operation_id"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "startTimeUtc":
            suggest = "start_time_utc"
        elif key == "targetResourceId":
            suggest = "target_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPropertiesResponseMoveDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPropertiesResponseMoveDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPropertiesResponseMoveDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completion_time_utc: str,
                 operation_id: str,
                 source_resource_id: str,
                 start_time_utc: str,
                 target_resource_id: str):
        """
        The details of the latest move operation performed on the Azure Resource
        :param str completion_time_utc: End Time of the Resource Move Operation
        :param str operation_id: OperationId of the Resource Move Operation
        :param str source_resource_id: Source Resource of the Resource Move Operation
        :param str start_time_utc: Start Time of the Resource Move Operation
        :param str target_resource_id: Target Resource of the Resource Move Operation
        """
        pulumi.set(__self__, "completion_time_utc", completion_time_utc)
        pulumi.set(__self__, "operation_id", operation_id)
        pulumi.set(__self__, "source_resource_id", source_resource_id)
        pulumi.set(__self__, "start_time_utc", start_time_utc)
        pulumi.set(__self__, "target_resource_id", target_resource_id)

    @property
    @pulumi.getter(name="completionTimeUtc")
    def completion_time_utc(self) -> str:
        """
        End Time of the Resource Move Operation
        """
        return pulumi.get(self, "completion_time_utc")

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> str:
        """
        OperationId of the Resource Move Operation
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> str:
        """
        Source Resource of the Resource Move Operation
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> str:
        """
        Start Time of the Resource Move Operation
        """
        return pulumi.get(self, "start_time_utc")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> str:
        """
        Target Resource of the Resource Move Operation
        """
        return pulumi.get(self, "target_resource_id")


@pulumi.output_type
class VaultPropertiesResponseRedundancySettings(dict):
    """
    The redundancy Settings of a Vault
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crossRegionRestore":
            suggest = "cross_region_restore"
        elif key == "standardTierStorageRedundancy":
            suggest = "standard_tier_storage_redundancy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPropertiesResponseRedundancySettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPropertiesResponseRedundancySettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPropertiesResponseRedundancySettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cross_region_restore: str,
                 standard_tier_storage_redundancy: str):
        """
        The redundancy Settings of a Vault
        :param str cross_region_restore: Flag to show if Cross Region Restore is enabled on the Vault or not
        :param str standard_tier_storage_redundancy: The storage redundancy setting of a vault
        """
        pulumi.set(__self__, "cross_region_restore", cross_region_restore)
        pulumi.set(__self__, "standard_tier_storage_redundancy", standard_tier_storage_redundancy)

    @property
    @pulumi.getter(name="crossRegionRestore")
    def cross_region_restore(self) -> str:
        """
        Flag to show if Cross Region Restore is enabled on the Vault or not
        """
        return pulumi.get(self, "cross_region_restore")

    @property
    @pulumi.getter(name="standardTierStorageRedundancy")
    def standard_tier_storage_redundancy(self) -> str:
        """
        The storage redundancy setting of a vault
        """
        return pulumi.get(self, "standard_tier_storage_redundancy")


@pulumi.output_type
class WeeklyRetentionFormatResponse(dict):
    """
    Weekly retention format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysOfTheWeek":
            suggest = "days_of_the_week"
        elif key == "weeksOfTheMonth":
            suggest = "weeks_of_the_month"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WeeklyRetentionFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WeeklyRetentionFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WeeklyRetentionFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_of_the_week: Optional[Sequence[str]] = None,
                 weeks_of_the_month: Optional[Sequence[str]] = None):
        """
        Weekly retention format.
        :param Sequence[str] days_of_the_week: List of days of the week.
        :param Sequence[str] weeks_of_the_month: List of weeks of month.
        """
        if days_of_the_week is not None:
            pulumi.set(__self__, "days_of_the_week", days_of_the_week)
        if weeks_of_the_month is not None:
            pulumi.set(__self__, "weeks_of_the_month", weeks_of_the_month)

    @property
    @pulumi.getter(name="daysOfTheWeek")
    def days_of_the_week(self) -> Optional[Sequence[str]]:
        """
        List of days of the week.
        """
        return pulumi.get(self, "days_of_the_week")

    @property
    @pulumi.getter(name="weeksOfTheMonth")
    def weeks_of_the_month(self) -> Optional[Sequence[str]]:
        """
        List of weeks of month.
        """
        return pulumi.get(self, "weeks_of_the_month")


@pulumi.output_type
class WeeklyRetentionScheduleResponse(dict):
    """
    Weekly retention schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysOfTheWeek":
            suggest = "days_of_the_week"
        elif key == "retentionDuration":
            suggest = "retention_duration"
        elif key == "retentionTimes":
            suggest = "retention_times"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WeeklyRetentionScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WeeklyRetentionScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WeeklyRetentionScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_of_the_week: Optional[Sequence[str]] = None,
                 retention_duration: Optional['outputs.RetentionDurationResponse'] = None,
                 retention_times: Optional[Sequence[str]] = None):
        """
        Weekly retention schedule.
        :param Sequence[str] days_of_the_week: List of days of week for weekly retention policy.
        :param 'RetentionDurationResponse' retention_duration: Retention duration of retention Policy.
        :param Sequence[str] retention_times: Retention times of retention policy.
        """
        if days_of_the_week is not None:
            pulumi.set(__self__, "days_of_the_week", days_of_the_week)
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_times is not None:
            pulumi.set(__self__, "retention_times", retention_times)

    @property
    @pulumi.getter(name="daysOfTheWeek")
    def days_of_the_week(self) -> Optional[Sequence[str]]:
        """
        List of days of week for weekly retention policy.
        """
        return pulumi.get(self, "days_of_the_week")

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional['outputs.RetentionDurationResponse']:
        """
        Retention duration of retention Policy.
        """
        return pulumi.get(self, "retention_duration")

    @property
    @pulumi.getter(name="retentionTimes")
    def retention_times(self) -> Optional[Sequence[str]]:
        """
        Retention times of retention policy.
        """
        return pulumi.get(self, "retention_times")


@pulumi.output_type
class WeeklyScheduleResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleRunDays":
            suggest = "schedule_run_days"
        elif key == "scheduleRunTimes":
            suggest = "schedule_run_times"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WeeklyScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WeeklyScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WeeklyScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_run_days: Optional[Sequence[str]] = None,
                 schedule_run_times: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] schedule_run_times: List of times of day this schedule has to be run.
        """
        if schedule_run_days is not None:
            pulumi.set(__self__, "schedule_run_days", schedule_run_days)
        if schedule_run_times is not None:
            pulumi.set(__self__, "schedule_run_times", schedule_run_times)

    @property
    @pulumi.getter(name="scheduleRunDays")
    def schedule_run_days(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "schedule_run_days")

    @property
    @pulumi.getter(name="scheduleRunTimes")
    def schedule_run_times(self) -> Optional[Sequence[str]]:
        """
        List of times of day this schedule has to be run.
        """
        return pulumi.get(self, "schedule_run_times")


@pulumi.output_type
class WorkloadInquiryDetailsResponse(dict):
    """
    Details of an inquired protectable item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inquiryValidation":
            suggest = "inquiry_validation"
        elif key == "itemCount":
            suggest = "item_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadInquiryDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadInquiryDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadInquiryDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inquiry_validation: Optional['outputs.InquiryValidationResponse'] = None,
                 item_count: Optional[float] = None,
                 type: Optional[str] = None):
        """
        Details of an inquired protectable item.
        :param 'InquiryValidationResponse' inquiry_validation: Inquiry validation such as permissions and other backup validations.
        :param float item_count: Contains the protectable item Count inside this Container.
        :param str type: Type of the Workload such as SQL, Oracle etc.
        """
        if inquiry_validation is not None:
            pulumi.set(__self__, "inquiry_validation", inquiry_validation)
        if item_count is not None:
            pulumi.set(__self__, "item_count", item_count)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="inquiryValidation")
    def inquiry_validation(self) -> Optional['outputs.InquiryValidationResponse']:
        """
        Inquiry validation such as permissions and other backup validations.
        """
        return pulumi.get(self, "inquiry_validation")

    @property
    @pulumi.getter(name="itemCount")
    def item_count(self) -> Optional[float]:
        """
        Contains the protectable item Count inside this Container.
        """
        return pulumi.get(self, "item_count")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the Workload such as SQL, Oracle etc.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class YearlyRetentionScheduleResponse(dict):
    """
    Yearly retention schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monthsOfYear":
            suggest = "months_of_year"
        elif key == "retentionDuration":
            suggest = "retention_duration"
        elif key == "retentionScheduleDaily":
            suggest = "retention_schedule_daily"
        elif key == "retentionScheduleFormatType":
            suggest = "retention_schedule_format_type"
        elif key == "retentionScheduleWeekly":
            suggest = "retention_schedule_weekly"
        elif key == "retentionTimes":
            suggest = "retention_times"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in YearlyRetentionScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        YearlyRetentionScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        YearlyRetentionScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 months_of_year: Optional[Sequence[str]] = None,
                 retention_duration: Optional['outputs.RetentionDurationResponse'] = None,
                 retention_schedule_daily: Optional['outputs.DailyRetentionFormatResponse'] = None,
                 retention_schedule_format_type: Optional[str] = None,
                 retention_schedule_weekly: Optional['outputs.WeeklyRetentionFormatResponse'] = None,
                 retention_times: Optional[Sequence[str]] = None):
        """
        Yearly retention schedule.
        :param Sequence[str] months_of_year: List of months of year of yearly retention policy.
        :param 'RetentionDurationResponse' retention_duration: Retention duration of retention Policy.
        :param 'DailyRetentionFormatResponse' retention_schedule_daily: Daily retention format for yearly retention policy.
        :param str retention_schedule_format_type: Retention schedule format for yearly retention policy.
        :param 'WeeklyRetentionFormatResponse' retention_schedule_weekly: Weekly retention format for yearly retention policy.
        :param Sequence[str] retention_times: Retention times of retention policy.
        """
        if months_of_year is not None:
            pulumi.set(__self__, "months_of_year", months_of_year)
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_schedule_daily is not None:
            pulumi.set(__self__, "retention_schedule_daily", retention_schedule_daily)
        if retention_schedule_format_type is not None:
            pulumi.set(__self__, "retention_schedule_format_type", retention_schedule_format_type)
        if retention_schedule_weekly is not None:
            pulumi.set(__self__, "retention_schedule_weekly", retention_schedule_weekly)
        if retention_times is not None:
            pulumi.set(__self__, "retention_times", retention_times)

    @property
    @pulumi.getter(name="monthsOfYear")
    def months_of_year(self) -> Optional[Sequence[str]]:
        """
        List of months of year of yearly retention policy.
        """
        return pulumi.get(self, "months_of_year")

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional['outputs.RetentionDurationResponse']:
        """
        Retention duration of retention Policy.
        """
        return pulumi.get(self, "retention_duration")

    @property
    @pulumi.getter(name="retentionScheduleDaily")
    def retention_schedule_daily(self) -> Optional['outputs.DailyRetentionFormatResponse']:
        """
        Daily retention format for yearly retention policy.
        """
        return pulumi.get(self, "retention_schedule_daily")

    @property
    @pulumi.getter(name="retentionScheduleFormatType")
    def retention_schedule_format_type(self) -> Optional[str]:
        """
        Retention schedule format for yearly retention policy.
        """
        return pulumi.get(self, "retention_schedule_format_type")

    @property
    @pulumi.getter(name="retentionScheduleWeekly")
    def retention_schedule_weekly(self) -> Optional['outputs.WeeklyRetentionFormatResponse']:
        """
        Weekly retention format for yearly retention policy.
        """
        return pulumi.get(self, "retention_schedule_weekly")

    @property
    @pulumi.getter(name="retentionTimes")
    def retention_times(self) -> Optional[Sequence[str]]:
        """
        Retention times of retention policy.
        """
        return pulumi.get(self, "retention_times")


