# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AutomaticResolutionPropertiesResponse',
    'AvailabilitySetResourceSettingsResponse',
    'DiskEncryptionSetResourceSettingsResponse',
    'IdentityResponse',
    'JobStatusResponse',
    'KeyVaultResourceSettingsResponse',
    'LBBackendAddressPoolResourceSettingsResponse',
    'LBFrontendIPConfigurationResourceSettingsResponse',
    'LoadBalancerBackendAddressPoolReferenceResponse',
    'LoadBalancerNatRuleReferenceResponse',
    'LoadBalancerResourceSettingsResponse',
    'ManualResolutionPropertiesResponse',
    'MoveCollectionPropertiesResponse',
    'MoveCollectionPropertiesResponseErrors',
    'MoveResourceDependencyOverrideResponse',
    'MoveResourceDependencyResponse',
    'MoveResourceErrorBodyResponse',
    'MoveResourceErrorResponse',
    'MoveResourcePropertiesResponse',
    'MoveResourcePropertiesResponseErrors',
    'MoveResourcePropertiesResponseMoveStatus',
    'NetworkInterfaceResourceSettingsResponse',
    'NetworkSecurityGroupResourceSettingsResponse',
    'NicIpConfigurationResourceSettingsResponse',
    'NsgReferenceResponse',
    'NsgSecurityRuleResponse',
    'PublicIPAddressResourceSettingsResponse',
    'PublicIpReferenceResponse',
    'ResourceGroupResourceSettingsResponse',
    'SqlDatabaseResourceSettingsResponse',
    'SqlElasticPoolResourceSettingsResponse',
    'SqlServerResourceSettingsResponse',
    'SubnetReferenceResponse',
    'SubnetResourceSettingsResponse',
    'VirtualMachineResourceSettingsResponse',
    'VirtualNetworkResourceSettingsResponse',
]

@pulumi.output_type
class AutomaticResolutionPropertiesResponse(dict):
    """
    Defines the properties for automatic resolution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "moveResourceId":
            suggest = "move_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomaticResolutionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomaticResolutionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomaticResolutionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 move_resource_id: Optional[str] = None):
        """
        Defines the properties for automatic resolution.
        :param str move_resource_id: Gets the MoveResource ARM ID of
               the dependent resource if the resolution type is Automatic.
        """
        if move_resource_id is not None:
            pulumi.set(__self__, "move_resource_id", move_resource_id)

    @property
    @pulumi.getter(name="moveResourceId")
    def move_resource_id(self) -> Optional[str]:
        """
        Gets the MoveResource ARM ID of
        the dependent resource if the resolution type is Automatic.
        """
        return pulumi.get(self, "move_resource_id")


@pulumi.output_type
class AvailabilitySetResourceSettingsResponse(dict):
    """
    Gets or sets the availability set resource settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "targetResourceName":
            suggest = "target_resource_name"
        elif key == "faultDomain":
            suggest = "fault_domain"
        elif key == "updateDomain":
            suggest = "update_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AvailabilitySetResourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AvailabilitySetResourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AvailabilitySetResourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: str,
                 target_resource_name: str,
                 fault_domain: Optional[int] = None,
                 update_domain: Optional[int] = None):
        """
        Gets or sets the availability set resource settings.
        :param str resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Compute/availabilitySets'.
        :param str target_resource_name: Gets or sets the target Resource name.
        :param int fault_domain: Gets or sets the target fault domain.
        :param int update_domain: Gets or sets the target update domain.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Compute/availabilitySets')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if update_domain is not None:
            pulumi.set(__self__, "update_domain", update_domain)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Compute/availabilitySets'.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> str:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[int]:
        """
        Gets or sets the target fault domain.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="updateDomain")
    def update_domain(self) -> Optional[int]:
        """
        Gets or sets the target update domain.
        """
        return pulumi.get(self, "update_domain")


@pulumi.output_type
class DiskEncryptionSetResourceSettingsResponse(dict):
    """
    Defines the disk encryption set resource settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "targetResourceName":
            suggest = "target_resource_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskEncryptionSetResourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskEncryptionSetResourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskEncryptionSetResourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: str,
                 target_resource_name: str):
        """
        Defines the disk encryption set resource settings.
        :param str resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Compute/diskEncryptionSets'.
        :param str target_resource_name: Gets or sets the target Resource name.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Compute/diskEncryptionSets')
        pulumi.set(__self__, "target_resource_name", target_resource_name)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Compute/diskEncryptionSets'.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> str:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Defines the MSI properties of the Move Collection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Defines the MSI properties of the Move Collection.
        :param str principal_id: Gets or sets the principal id.
        :param str tenant_id: Gets or sets the tenant id.
        :param str type: The type of identity used for the resource mover service.
        """
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        """
        Gets or sets the principal id.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Gets or sets the tenant id.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of identity used for the resource mover service.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobStatusResponse(dict):
    """
    Defines the job status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobName":
            suggest = "job_name"
        elif key == "jobProgress":
            suggest = "job_progress"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_name: str,
                 job_progress: str):
        """
        Defines the job status.
        :param str job_name: Defines the job name.
        :param str job_progress: Gets or sets the monitoring job percentage.
        """
        pulumi.set(__self__, "job_name", job_name)
        pulumi.set(__self__, "job_progress", job_progress)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> str:
        """
        Defines the job name.
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter(name="jobProgress")
    def job_progress(self) -> str:
        """
        Gets or sets the monitoring job percentage.
        """
        return pulumi.get(self, "job_progress")


@pulumi.output_type
class KeyVaultResourceSettingsResponse(dict):
    """
    Defines the key vault resource settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "targetResourceName":
            suggest = "target_resource_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultResourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultResourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultResourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: str,
                 target_resource_name: str):
        """
        Defines the key vault resource settings.
        :param str resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.KeyVault/vaults'.
        :param str target_resource_name: Gets or sets the target Resource name.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.KeyVault/vaults')
        pulumi.set(__self__, "target_resource_name", target_resource_name)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.KeyVault/vaults'.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> str:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")


@pulumi.output_type
class LBBackendAddressPoolResourceSettingsResponse(dict):
    """
    Defines load balancer backend address pool properties.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Defines load balancer backend address pool properties.
        :param str name: Gets or sets the backend address pool name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the backend address pool name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LBFrontendIPConfigurationResourceSettingsResponse(dict):
    """
    Defines load balancer frontend IP configuration properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "privateIpAllocationMethod":
            suggest = "private_ip_allocation_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LBFrontendIPConfigurationResourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LBFrontendIPConfigurationResourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LBFrontendIPConfigurationResourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 subnet: Optional['outputs.SubnetReferenceResponse'] = None,
                 zones: Optional[str] = None):
        """
        Defines load balancer frontend IP configuration properties.
        :param str name: Gets or sets the frontend IP configuration name.
        :param str private_ip_address: Gets or sets the IP address of the Load Balancer.This is only specified if a specific
               private IP address shall be allocated from the subnet specified in subnetRef.
        :param str private_ip_allocation_method: Gets or sets PrivateIP allocation method (Static/Dynamic).
        :param 'SubnetReferenceResponse' subnet: Defines reference to subnet.
        :param str zones: Gets or sets the csv list of zones.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the frontend IP configuration name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        Gets or sets the IP address of the Load Balancer.This is only specified if a specific
        private IP address shall be allocated from the subnet specified in subnetRef.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIpAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        Gets or sets PrivateIP allocation method (Static/Dynamic).
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetReferenceResponse']:
        """
        Defines reference to subnet.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def zones(self) -> Optional[str]:
        """
        Gets or sets the csv list of zones.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class LoadBalancerBackendAddressPoolReferenceResponse(dict):
    """
    Defines reference to load balancer backend address pools.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceArmResourceId":
            suggest = "source_arm_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerBackendAddressPoolReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerBackendAddressPoolReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerBackendAddressPoolReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_arm_resource_id: str,
                 name: Optional[str] = None):
        """
        Defines reference to load balancer backend address pools.
        :param str source_arm_resource_id: Gets the ARM resource ID of the tracked resource being referenced.
        :param str name: Gets the name of the proxy resource on the target side.
        """
        pulumi.set(__self__, "source_arm_resource_id", source_arm_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="sourceArmResourceId")
    def source_arm_resource_id(self) -> str:
        """
        Gets the ARM resource ID of the tracked resource being referenced.
        """
        return pulumi.get(self, "source_arm_resource_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets the name of the proxy resource on the target side.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LoadBalancerNatRuleReferenceResponse(dict):
    """
    Defines reference to load balancer NAT rules.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceArmResourceId":
            suggest = "source_arm_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerNatRuleReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerNatRuleReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerNatRuleReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_arm_resource_id: str,
                 name: Optional[str] = None):
        """
        Defines reference to load balancer NAT rules.
        :param str source_arm_resource_id: Gets the ARM resource ID of the tracked resource being referenced.
        :param str name: Gets the name of the proxy resource on the target side.
        """
        pulumi.set(__self__, "source_arm_resource_id", source_arm_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="sourceArmResourceId")
    def source_arm_resource_id(self) -> str:
        """
        Gets the ARM resource ID of the tracked resource being referenced.
        """
        return pulumi.get(self, "source_arm_resource_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets the name of the proxy resource on the target side.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LoadBalancerResourceSettingsResponse(dict):
    """
    Defines the load balancer resource settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "targetResourceName":
            suggest = "target_resource_name"
        elif key == "backendAddressPools":
            suggest = "backend_address_pools"
        elif key == "frontendIPConfigurations":
            suggest = "frontend_ip_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerResourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerResourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerResourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: str,
                 target_resource_name: str,
                 backend_address_pools: Optional[Sequence['outputs.LBBackendAddressPoolResourceSettingsResponse']] = None,
                 frontend_ip_configurations: Optional[Sequence['outputs.LBFrontendIPConfigurationResourceSettingsResponse']] = None,
                 sku: Optional[str] = None,
                 zones: Optional[str] = None):
        """
        Defines the load balancer resource settings.
        :param str resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Network/loadBalancers'.
        :param str target_resource_name: Gets or sets the target Resource name.
        :param Sequence['LBBackendAddressPoolResourceSettingsResponse'] backend_address_pools: Gets or sets the backend address pools of the load balancer.
        :param Sequence['LBFrontendIPConfigurationResourceSettingsResponse'] frontend_ip_configurations: Gets or sets the frontend IP configurations of the load balancer.
        :param str sku: Gets or sets load balancer sku (Basic/Standard).
        :param str zones: Gets or sets the csv list of zones common for all frontend IP configurations. Note this is given
                precedence only if frontend IP configurations settings are not present.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Network/loadBalancers')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if backend_address_pools is not None:
            pulumi.set(__self__, "backend_address_pools", backend_address_pools)
        if frontend_ip_configurations is not None:
            pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Network/loadBalancers'.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> str:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @property
    @pulumi.getter(name="backendAddressPools")
    def backend_address_pools(self) -> Optional[Sequence['outputs.LBBackendAddressPoolResourceSettingsResponse']]:
        """
        Gets or sets the backend address pools of the load balancer.
        """
        return pulumi.get(self, "backend_address_pools")

    @property
    @pulumi.getter(name="frontendIPConfigurations")
    def frontend_ip_configurations(self) -> Optional[Sequence['outputs.LBFrontendIPConfigurationResourceSettingsResponse']]:
        """
        Gets or sets the frontend IP configurations of the load balancer.
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @property
    @pulumi.getter
    def sku(self) -> Optional[str]:
        """
        Gets or sets load balancer sku (Basic/Standard).
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def zones(self) -> Optional[str]:
        """
        Gets or sets the csv list of zones common for all frontend IP configurations. Note this is given
         precedence only if frontend IP configurations settings are not present.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class ManualResolutionPropertiesResponse(dict):
    """
    Defines the properties for manual resolution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetId":
            suggest = "target_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManualResolutionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManualResolutionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManualResolutionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_id: Optional[str] = None):
        """
        Defines the properties for manual resolution.
        :param str target_id: Gets or sets the target resource ARM ID of the dependent resource if the resource type is Manual.
        """
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        """
        Gets or sets the target resource ARM ID of the dependent resource if the resource type is Manual.
        """
        return pulumi.get(self, "target_id")


@pulumi.output_type
class MoveCollectionPropertiesResponse(dict):
    """
    Defines the move collection properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "sourceRegion":
            suggest = "source_region"
        elif key == "targetRegion":
            suggest = "target_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MoveCollectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MoveCollectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MoveCollectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 errors: 'outputs.MoveCollectionPropertiesResponseErrors',
                 provisioning_state: str,
                 source_region: str,
                 target_region: str):
        """
        Defines the move collection properties.
        :param 'MoveCollectionPropertiesResponseErrors' errors: Defines the move collection errors.
        :param str provisioning_state: Defines the provisioning states.
        :param str source_region: Gets or sets the source region.
        :param str target_region: Gets or sets the target region.
        """
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "source_region", source_region)
        pulumi.set(__self__, "target_region", target_region)

    @property
    @pulumi.getter
    def errors(self) -> 'outputs.MoveCollectionPropertiesResponseErrors':
        """
        Defines the move collection errors.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Defines the provisioning states.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> str:
        """
        Gets or sets the source region.
        """
        return pulumi.get(self, "source_region")

    @property
    @pulumi.getter(name="targetRegion")
    def target_region(self) -> str:
        """
        Gets or sets the target region.
        """
        return pulumi.get(self, "target_region")


@pulumi.output_type
class MoveCollectionPropertiesResponseErrors(dict):
    """
    Defines the move collection errors.
    """
    def __init__(__self__, *,
                 properties: Optional['outputs.MoveResourceErrorBodyResponse'] = None):
        """
        Defines the move collection errors.
        :param 'MoveResourceErrorBodyResponse' properties: The move resource error body.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.MoveResourceErrorBodyResponse']:
        """
        The move resource error body.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class MoveResourceDependencyOverrideResponse(dict):
    """
    Defines the dependency override of the move resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetId":
            suggest = "target_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MoveResourceDependencyOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MoveResourceDependencyOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MoveResourceDependencyOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 target_id: Optional[str] = None):
        """
        Defines the dependency override of the move resource.
        :param str id: Gets or sets the ARM ID of the dependent resource.
        :param str target_id: Gets or sets the resource ARM id of either the MoveResource or the resource ARM ID of
               the dependent resource.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Gets or sets the ARM ID of the dependent resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        """
        Gets or sets the resource ARM id of either the MoveResource or the resource ARM ID of
        the dependent resource.
        """
        return pulumi.get(self, "target_id")


@pulumi.output_type
class MoveResourceDependencyResponse(dict):
    """
    Defines the dependency of the move resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automaticResolution":
            suggest = "automatic_resolution"
        elif key == "dependencyType":
            suggest = "dependency_type"
        elif key == "isOptional":
            suggest = "is_optional"
        elif key == "manualResolution":
            suggest = "manual_resolution"
        elif key == "resolutionStatus":
            suggest = "resolution_status"
        elif key == "resolutionType":
            suggest = "resolution_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MoveResourceDependencyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MoveResourceDependencyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MoveResourceDependencyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic_resolution: Optional['outputs.AutomaticResolutionPropertiesResponse'] = None,
                 dependency_type: Optional[str] = None,
                 id: Optional[str] = None,
                 is_optional: Optional[str] = None,
                 manual_resolution: Optional['outputs.ManualResolutionPropertiesResponse'] = None,
                 resolution_status: Optional[str] = None,
                 resolution_type: Optional[str] = None):
        """
        Defines the dependency of the move resource.
        :param 'AutomaticResolutionPropertiesResponse' automatic_resolution: Defines the properties for automatic resolution.
        :param str dependency_type: Defines the dependency type.
        :param str id: Gets the source ARM ID of the dependent resource.
        :param str is_optional: Gets or sets a value indicating whether the dependency is optional.
        :param 'ManualResolutionPropertiesResponse' manual_resolution: Defines the properties for manual resolution.
        :param str resolution_status: Gets the dependency resolution status.
        :param str resolution_type: Defines the resolution type.
        """
        if automatic_resolution is not None:
            pulumi.set(__self__, "automatic_resolution", automatic_resolution)
        if dependency_type is not None:
            pulumi.set(__self__, "dependency_type", dependency_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_optional is not None:
            pulumi.set(__self__, "is_optional", is_optional)
        if manual_resolution is not None:
            pulumi.set(__self__, "manual_resolution", manual_resolution)
        if resolution_status is not None:
            pulumi.set(__self__, "resolution_status", resolution_status)
        if resolution_type is not None:
            pulumi.set(__self__, "resolution_type", resolution_type)

    @property
    @pulumi.getter(name="automaticResolution")
    def automatic_resolution(self) -> Optional['outputs.AutomaticResolutionPropertiesResponse']:
        """
        Defines the properties for automatic resolution.
        """
        return pulumi.get(self, "automatic_resolution")

    @property
    @pulumi.getter(name="dependencyType")
    def dependency_type(self) -> Optional[str]:
        """
        Defines the dependency type.
        """
        return pulumi.get(self, "dependency_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Gets the source ARM ID of the dependent resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isOptional")
    def is_optional(self) -> Optional[str]:
        """
        Gets or sets a value indicating whether the dependency is optional.
        """
        return pulumi.get(self, "is_optional")

    @property
    @pulumi.getter(name="manualResolution")
    def manual_resolution(self) -> Optional['outputs.ManualResolutionPropertiesResponse']:
        """
        Defines the properties for manual resolution.
        """
        return pulumi.get(self, "manual_resolution")

    @property
    @pulumi.getter(name="resolutionStatus")
    def resolution_status(self) -> Optional[str]:
        """
        Gets the dependency resolution status.
        """
        return pulumi.get(self, "resolution_status")

    @property
    @pulumi.getter(name="resolutionType")
    def resolution_type(self) -> Optional[str]:
        """
        Defines the resolution type.
        """
        return pulumi.get(self, "resolution_type")


@pulumi.output_type
class MoveResourceErrorBodyResponse(dict):
    """
    An error response from the Azure Migrate service.
    """
    def __init__(__self__, *,
                 code: str,
                 details: Sequence['outputs.MoveResourceErrorBodyResponse'],
                 message: str,
                 target: str):
        """
        An error response from the Azure Migrate service.
        :param str code: An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
        :param Sequence['MoveResourceErrorBodyResponse'] details: A list of additional details about the error.
        :param str message: A message describing the error, intended to be suitable for display in a user interface.
        :param str target: The target of the particular error. For example, the name of the property in error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.MoveResourceErrorBodyResponse']:
        """
        A list of additional details about the error.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A message describing the error, intended to be suitable for display in a user interface.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        The target of the particular error. For example, the name of the property in error.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class MoveResourceErrorResponse(dict):
    """
    An error response from the azure resource mover service.
    """
    def __init__(__self__, *,
                 properties: Optional['outputs.MoveResourceErrorBodyResponse'] = None):
        """
        An error response from the azure resource mover service.
        :param 'MoveResourceErrorBodyResponse' properties: The move resource error body.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.MoveResourceErrorBodyResponse']:
        """
        The move resource error body.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class MoveResourcePropertiesResponse(dict):
    """
    Defines the move resource properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOn":
            suggest = "depends_on"
        elif key == "isResolveRequired":
            suggest = "is_resolve_required"
        elif key == "moveStatus":
            suggest = "move_status"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "sourceId":
            suggest = "source_id"
        elif key == "sourceResourceSettings":
            suggest = "source_resource_settings"
        elif key == "targetId":
            suggest = "target_id"
        elif key == "dependsOnOverrides":
            suggest = "depends_on_overrides"
        elif key == "existingTargetId":
            suggest = "existing_target_id"
        elif key == "resourceSettings":
            suggest = "resource_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MoveResourcePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MoveResourcePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MoveResourcePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 depends_on: Sequence['outputs.MoveResourceDependencyResponse'],
                 errors: 'outputs.MoveResourcePropertiesResponseErrors',
                 is_resolve_required: bool,
                 move_status: 'outputs.MoveResourcePropertiesResponseMoveStatus',
                 provisioning_state: str,
                 source_id: str,
                 source_resource_settings: Any,
                 target_id: str,
                 depends_on_overrides: Optional[Sequence['outputs.MoveResourceDependencyOverrideResponse']] = None,
                 existing_target_id: Optional[str] = None,
                 resource_settings: Optional[Any] = None):
        """
        Defines the move resource properties.
        :param Sequence['MoveResourceDependencyResponse'] depends_on: Gets or sets the move resource dependencies.
        :param 'MoveResourcePropertiesResponseErrors' errors: Defines the move resource errors.
        :param bool is_resolve_required: Gets a value indicating whether the resolve action is required over the move collection.
        :param 'MoveResourcePropertiesResponseMoveStatus' move_status: Defines the move resource status.
        :param str provisioning_state: Defines the provisioning states.
        :param str source_id: Gets or sets the Source ARM Id of the resource.
        :param Union['AvailabilitySetResourceSettingsResponse', 'DiskEncryptionSetResourceSettingsResponse', 'KeyVaultResourceSettingsResponse', 'LoadBalancerResourceSettingsResponse', 'NetworkInterfaceResourceSettingsResponse', 'NetworkSecurityGroupResourceSettingsResponse', 'PublicIPAddressResourceSettingsResponse', 'ResourceGroupResourceSettingsResponse', 'SqlDatabaseResourceSettingsResponse', 'SqlElasticPoolResourceSettingsResponse', 'SqlServerResourceSettingsResponse', 'VirtualMachineResourceSettingsResponse', 'VirtualNetworkResourceSettingsResponse'] source_resource_settings: Gets or sets the source resource settings.
        :param str target_id: Gets or sets the Target ARM Id of the resource.
        :param Sequence['MoveResourceDependencyOverrideResponse'] depends_on_overrides: Gets or sets the move resource dependencies overrides.
        :param str existing_target_id: Gets or sets the existing target ARM Id of the resource.
        :param Union['AvailabilitySetResourceSettingsResponse', 'DiskEncryptionSetResourceSettingsResponse', 'KeyVaultResourceSettingsResponse', 'LoadBalancerResourceSettingsResponse', 'NetworkInterfaceResourceSettingsResponse', 'NetworkSecurityGroupResourceSettingsResponse', 'PublicIPAddressResourceSettingsResponse', 'ResourceGroupResourceSettingsResponse', 'SqlDatabaseResourceSettingsResponse', 'SqlElasticPoolResourceSettingsResponse', 'SqlServerResourceSettingsResponse', 'VirtualMachineResourceSettingsResponse', 'VirtualNetworkResourceSettingsResponse'] resource_settings: Gets or sets the resource settings.
        """
        pulumi.set(__self__, "depends_on", depends_on)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "is_resolve_required", is_resolve_required)
        pulumi.set(__self__, "move_status", move_status)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "source_id", source_id)
        pulumi.set(__self__, "source_resource_settings", source_resource_settings)
        pulumi.set(__self__, "target_id", target_id)
        if depends_on_overrides is not None:
            pulumi.set(__self__, "depends_on_overrides", depends_on_overrides)
        if existing_target_id is not None:
            pulumi.set(__self__, "existing_target_id", existing_target_id)
        if resource_settings is not None:
            pulumi.set(__self__, "resource_settings", resource_settings)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Sequence['outputs.MoveResourceDependencyResponse']:
        """
        Gets or sets the move resource dependencies.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def errors(self) -> 'outputs.MoveResourcePropertiesResponseErrors':
        """
        Defines the move resource errors.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="isResolveRequired")
    def is_resolve_required(self) -> bool:
        """
        Gets a value indicating whether the resolve action is required over the move collection.
        """
        return pulumi.get(self, "is_resolve_required")

    @property
    @pulumi.getter(name="moveStatus")
    def move_status(self) -> 'outputs.MoveResourcePropertiesResponseMoveStatus':
        """
        Defines the move resource status.
        """
        return pulumi.get(self, "move_status")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Defines the provisioning states.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> str:
        """
        Gets or sets the Source ARM Id of the resource.
        """
        return pulumi.get(self, "source_id")

    @property
    @pulumi.getter(name="sourceResourceSettings")
    def source_resource_settings(self) -> Any:
        """
        Gets or sets the source resource settings.
        """
        return pulumi.get(self, "source_resource_settings")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        Gets or sets the Target ARM Id of the resource.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="dependsOnOverrides")
    def depends_on_overrides(self) -> Optional[Sequence['outputs.MoveResourceDependencyOverrideResponse']]:
        """
        Gets or sets the move resource dependencies overrides.
        """
        return pulumi.get(self, "depends_on_overrides")

    @property
    @pulumi.getter(name="existingTargetId")
    def existing_target_id(self) -> Optional[str]:
        """
        Gets or sets the existing target ARM Id of the resource.
        """
        return pulumi.get(self, "existing_target_id")

    @property
    @pulumi.getter(name="resourceSettings")
    def resource_settings(self) -> Optional[Any]:
        """
        Gets or sets the resource settings.
        """
        return pulumi.get(self, "resource_settings")


@pulumi.output_type
class MoveResourcePropertiesResponseErrors(dict):
    """
    Defines the move resource errors.
    """
    def __init__(__self__, *,
                 properties: Optional['outputs.MoveResourceErrorBodyResponse'] = None):
        """
        Defines the move resource errors.
        :param 'MoveResourceErrorBodyResponse' properties: The move resource error body.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.MoveResourceErrorBodyResponse']:
        """
        The move resource error body.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class MoveResourcePropertiesResponseMoveStatus(dict):
    """
    Defines the move resource status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "moveState":
            suggest = "move_state"
        elif key == "jobStatus":
            suggest = "job_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MoveResourcePropertiesResponseMoveStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MoveResourcePropertiesResponseMoveStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MoveResourcePropertiesResponseMoveStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 move_state: str,
                 errors: Optional['outputs.MoveResourceErrorResponse'] = None,
                 job_status: Optional['outputs.JobStatusResponse'] = None):
        """
        Defines the move resource status.
        :param str move_state: Defines the MoveResource states.
        :param 'MoveResourceErrorResponse' errors: An error response from the azure resource mover service.
        :param 'JobStatusResponse' job_status: Defines the job status.
        """
        pulumi.set(__self__, "move_state", move_state)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if job_status is not None:
            pulumi.set(__self__, "job_status", job_status)

    @property
    @pulumi.getter(name="moveState")
    def move_state(self) -> str:
        """
        Defines the MoveResource states.
        """
        return pulumi.get(self, "move_state")

    @property
    @pulumi.getter
    def errors(self) -> Optional['outputs.MoveResourceErrorResponse']:
        """
        An error response from the azure resource mover service.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="jobStatus")
    def job_status(self) -> Optional['outputs.JobStatusResponse']:
        """
        Defines the job status.
        """
        return pulumi.get(self, "job_status")


@pulumi.output_type
class NetworkInterfaceResourceSettingsResponse(dict):
    """
    Defines the network interface resource settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "targetResourceName":
            suggest = "target_resource_name"
        elif key == "enableAcceleratedNetworking":
            suggest = "enable_accelerated_networking"
        elif key == "ipConfigurations":
            suggest = "ip_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceResourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceResourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceResourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: str,
                 target_resource_name: str,
                 enable_accelerated_networking: Optional[bool] = None,
                 ip_configurations: Optional[Sequence['outputs.NicIpConfigurationResourceSettingsResponse']] = None):
        """
        Defines the network interface resource settings.
        :param str resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Network/networkInterfaces'.
        :param str target_resource_name: Gets or sets the target Resource name.
        :param bool enable_accelerated_networking: Gets or sets a value indicating whether accelerated networking is enabled.
        :param Sequence['NicIpConfigurationResourceSettingsResponse'] ip_configurations: Gets or sets the IP configurations of the NIC.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Network/networkInterfaces')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if enable_accelerated_networking is not None:
            pulumi.set(__self__, "enable_accelerated_networking", enable_accelerated_networking)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Network/networkInterfaces'.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> str:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @property
    @pulumi.getter(name="enableAcceleratedNetworking")
    def enable_accelerated_networking(self) -> Optional[bool]:
        """
        Gets or sets a value indicating whether accelerated networking is enabled.
        """
        return pulumi.get(self, "enable_accelerated_networking")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[Sequence['outputs.NicIpConfigurationResourceSettingsResponse']]:
        """
        Gets or sets the IP configurations of the NIC.
        """
        return pulumi.get(self, "ip_configurations")


@pulumi.output_type
class NetworkSecurityGroupResourceSettingsResponse(dict):
    """
    Defines the NSG resource settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "targetResourceName":
            suggest = "target_resource_name"
        elif key == "securityRules":
            suggest = "security_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkSecurityGroupResourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkSecurityGroupResourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkSecurityGroupResourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: str,
                 target_resource_name: str,
                 security_rules: Optional[Sequence['outputs.NsgSecurityRuleResponse']] = None):
        """
        Defines the NSG resource settings.
        :param str resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Network/networkSecurityGroups'.
        :param str target_resource_name: Gets or sets the target Resource name.
        :param Sequence['NsgSecurityRuleResponse'] security_rules: Gets or sets Security rules of network security group.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Network/networkSecurityGroups')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if security_rules is not None:
            pulumi.set(__self__, "security_rules", security_rules)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Network/networkSecurityGroups'.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> str:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[Sequence['outputs.NsgSecurityRuleResponse']]:
        """
        Gets or sets Security rules of network security group.
        """
        return pulumi.get(self, "security_rules")


@pulumi.output_type
class NicIpConfigurationResourceSettingsResponse(dict):
    """
    Defines NIC IP configuration properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadBalancerBackendAddressPools":
            suggest = "load_balancer_backend_address_pools"
        elif key == "loadBalancerNatRules":
            suggest = "load_balancer_nat_rules"
        elif key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "privateIpAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "publicIp":
            suggest = "public_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NicIpConfigurationResourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NicIpConfigurationResourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NicIpConfigurationResourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 load_balancer_backend_address_pools: Optional[Sequence['outputs.LoadBalancerBackendAddressPoolReferenceResponse']] = None,
                 load_balancer_nat_rules: Optional[Sequence['outputs.LoadBalancerNatRuleReferenceResponse']] = None,
                 name: Optional[str] = None,
                 primary: Optional[bool] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 public_ip: Optional['outputs.PublicIpReferenceResponse'] = None,
                 subnet: Optional['outputs.SubnetReferenceResponse'] = None):
        """
        Defines NIC IP configuration properties.
        :param Sequence['LoadBalancerBackendAddressPoolReferenceResponse'] load_balancer_backend_address_pools: Gets or sets the references of the load balancer backend address pools.
        :param Sequence['LoadBalancerNatRuleReferenceResponse'] load_balancer_nat_rules: Gets or sets the references of the load balancer NAT rules.
        :param str name: Gets or sets the IP configuration name.
        :param bool primary: Gets or sets a value indicating whether this IP configuration is the primary.
        :param str private_ip_address: Gets or sets the private IP address of the network interface IP Configuration.
        :param str private_ip_allocation_method: Gets or sets the private IP address allocation method.
        :param 'PublicIpReferenceResponse' public_ip: Defines reference to a public IP.
        :param 'SubnetReferenceResponse' subnet: Defines reference to subnet.
        """
        if load_balancer_backend_address_pools is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pools", load_balancer_backend_address_pools)
        if load_balancer_nat_rules is not None:
            pulumi.set(__self__, "load_balancer_nat_rules", load_balancer_nat_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="loadBalancerBackendAddressPools")
    def load_balancer_backend_address_pools(self) -> Optional[Sequence['outputs.LoadBalancerBackendAddressPoolReferenceResponse']]:
        """
        Gets or sets the references of the load balancer backend address pools.
        """
        return pulumi.get(self, "load_balancer_backend_address_pools")

    @property
    @pulumi.getter(name="loadBalancerNatRules")
    def load_balancer_nat_rules(self) -> Optional[Sequence['outputs.LoadBalancerNatRuleReferenceResponse']]:
        """
        Gets or sets the references of the load balancer NAT rules.
        """
        return pulumi.get(self, "load_balancer_nat_rules")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the IP configuration name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Gets or sets a value indicating whether this IP configuration is the primary.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        Gets or sets the private IP address of the network interface IP Configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIpAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        Gets or sets the private IP address allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional['outputs.PublicIpReferenceResponse']:
        """
        Defines reference to a public IP.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetReferenceResponse']:
        """
        Defines reference to subnet.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class NsgReferenceResponse(dict):
    """
    Defines reference to NSG.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceArmResourceId":
            suggest = "source_arm_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NsgReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NsgReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NsgReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_arm_resource_id: str):
        """
        Defines reference to NSG.
        :param str source_arm_resource_id: Gets the ARM resource ID of the tracked resource being referenced.
        """
        pulumi.set(__self__, "source_arm_resource_id", source_arm_resource_id)

    @property
    @pulumi.getter(name="sourceArmResourceId")
    def source_arm_resource_id(self) -> str:
        """
        Gets the ARM resource ID of the tracked resource being referenced.
        """
        return pulumi.get(self, "source_arm_resource_id")


@pulumi.output_type
class NsgSecurityRuleResponse(dict):
    """
    Security Rule data model for Network Security Groups.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationAddressPrefix":
            suggest = "destination_address_prefix"
        elif key == "destinationPortRange":
            suggest = "destination_port_range"
        elif key == "sourceAddressPrefix":
            suggest = "source_address_prefix"
        elif key == "sourcePortRange":
            suggest = "source_port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NsgSecurityRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NsgSecurityRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NsgSecurityRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access: Optional[str] = None,
                 description: Optional[str] = None,
                 destination_address_prefix: Optional[str] = None,
                 destination_port_range: Optional[str] = None,
                 direction: Optional[str] = None,
                 name: Optional[str] = None,
                 priority: Optional[int] = None,
                 protocol: Optional[str] = None,
                 source_address_prefix: Optional[str] = None,
                 source_port_range: Optional[str] = None):
        """
        Security Rule data model for Network Security Groups.
        :param str access: Gets or sets whether network traffic is allowed or denied.
               Possible values are “Allow” and “Deny”.
        :param str description: Gets or sets a description for this rule. Restricted to 140 chars.
        :param str destination_address_prefix: Gets or sets destination address prefix. CIDR or source IP range.
                A “*” can also be used to match all source IPs. Default tags such
               as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be used.
        :param str destination_port_range: Gets or sets Destination Port or Range. Integer or range between
               0 and 65535. A “*” can also be used to match all ports.
        :param str direction: Gets or sets the direction of the rule.InBound or Outbound. The
               direction specifies if rule will be evaluated on incoming or outgoing traffic.
        :param str name: Gets or sets the Security rule name.
        :param int priority: Gets or sets the priority of the rule. The value can be between
               100 and 4096. The priority number must be unique for each rule in the collection.
               The lower the priority number, the higher the priority of the rule.
        :param str protocol: Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*).
        :param str source_address_prefix: Gets or sets source address prefix. CIDR or source IP range. A
               “*” can also be used to match all source IPs.  Default tags such as ‘VirtualNetwork’,
               ‘AzureLoadBalancer’ and ‘Internet’ can also be used. If this is an ingress
               rule, specifies where network traffic originates from.
        :param str source_port_range: Gets or sets Source Port or Range. Integer or range between 0 and
               65535. A “*” can also be used to match all ports.
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_address_prefix is not None:
            pulumi.set(__self__, "destination_address_prefix", destination_address_prefix)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_address_prefix is not None:
            pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)

    @property
    @pulumi.getter
    def access(self) -> Optional[str]:
        """
        Gets or sets whether network traffic is allowed or denied.
        Possible values are “Allow” and “Deny”.
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Gets or sets a description for this rule. Restricted to 140 chars.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationAddressPrefix")
    def destination_address_prefix(self) -> Optional[str]:
        """
        Gets or sets destination address prefix. CIDR or source IP range.
         A “*” can also be used to match all source IPs. Default tags such
        as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be used.
        """
        return pulumi.get(self, "destination_address_prefix")

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[str]:
        """
        Gets or sets Destination Port or Range. Integer or range between
        0 and 65535. A “*” can also be used to match all ports.
        """
        return pulumi.get(self, "destination_port_range")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        Gets or sets the direction of the rule.InBound or Outbound. The
        direction specifies if rule will be evaluated on incoming or outgoing traffic.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the Security rule name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Gets or sets the priority of the rule. The value can be between
        100 and 4096. The priority number must be unique for each rule in the collection.
        The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*).
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> Optional[str]:
        """
        Gets or sets source address prefix. CIDR or source IP range. A
        “*” can also be used to match all source IPs.  Default tags such as ‘VirtualNetwork’,
        ‘AzureLoadBalancer’ and ‘Internet’ can also be used. If this is an ingress
        rule, specifies where network traffic originates from.
        """
        return pulumi.get(self, "source_address_prefix")

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[str]:
        """
        Gets or sets Source Port or Range. Integer or range between 0 and
        65535. A “*” can also be used to match all ports.
        """
        return pulumi.get(self, "source_port_range")


@pulumi.output_type
class PublicIPAddressResourceSettingsResponse(dict):
    """
    Defines the public IP address resource settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "targetResourceName":
            suggest = "target_resource_name"
        elif key == "domainNameLabel":
            suggest = "domain_name_label"
        elif key == "publicIpAllocationMethod":
            suggest = "public_ip_allocation_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicIPAddressResourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicIPAddressResourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicIPAddressResourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: str,
                 target_resource_name: str,
                 domain_name_label: Optional[str] = None,
                 fqdn: Optional[str] = None,
                 public_ip_allocation_method: Optional[str] = None,
                 sku: Optional[str] = None,
                 zones: Optional[str] = None):
        """
        Defines the public IP address resource settings.
        :param str resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Network/publicIPAddresses'.
        :param str target_resource_name: Gets or sets the target Resource name.
        :param str domain_name_label: Gets or sets the domain name label.
        :param str fqdn: Gets or sets the fully qualified domain name.
        :param str public_ip_allocation_method: Gets or sets public IP allocation method.
        :param str sku: Gets or sets public IP sku.
        :param str zones: Gets or sets public IP zones.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Network/publicIPAddresses')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if domain_name_label is not None:
            pulumi.set(__self__, "domain_name_label", domain_name_label)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if public_ip_allocation_method is not None:
            pulumi.set(__self__, "public_ip_allocation_method", public_ip_allocation_method)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Network/publicIPAddresses'.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> str:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> Optional[str]:
        """
        Gets or sets the domain name label.
        """
        return pulumi.get(self, "domain_name_label")

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        Gets or sets the fully qualified domain name.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="publicIpAllocationMethod")
    def public_ip_allocation_method(self) -> Optional[str]:
        """
        Gets or sets public IP allocation method.
        """
        return pulumi.get(self, "public_ip_allocation_method")

    @property
    @pulumi.getter
    def sku(self) -> Optional[str]:
        """
        Gets or sets public IP sku.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def zones(self) -> Optional[str]:
        """
        Gets or sets public IP zones.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class PublicIpReferenceResponse(dict):
    """
    Defines reference to a public IP.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceArmResourceId":
            suggest = "source_arm_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicIpReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicIpReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicIpReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_arm_resource_id: str):
        """
        Defines reference to a public IP.
        :param str source_arm_resource_id: Gets the ARM resource ID of the tracked resource being referenced.
        """
        pulumi.set(__self__, "source_arm_resource_id", source_arm_resource_id)

    @property
    @pulumi.getter(name="sourceArmResourceId")
    def source_arm_resource_id(self) -> str:
        """
        Gets the ARM resource ID of the tracked resource being referenced.
        """
        return pulumi.get(self, "source_arm_resource_id")


@pulumi.output_type
class ResourceGroupResourceSettingsResponse(dict):
    """
    Defines the resource group resource settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "targetResourceName":
            suggest = "target_resource_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceGroupResourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceGroupResourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceGroupResourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: str,
                 target_resource_name: str):
        """
        Defines the resource group resource settings.
        :param str resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'resourceGroups'.
        :param str target_resource_name: Gets or sets the target Resource name.
        """
        pulumi.set(__self__, "resource_type", 'resourceGroups')
        pulumi.set(__self__, "target_resource_name", target_resource_name)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'resourceGroups'.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> str:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")


@pulumi.output_type
class SqlDatabaseResourceSettingsResponse(dict):
    """
    Defines the Sql Database resource settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "targetResourceName":
            suggest = "target_resource_name"
        elif key == "zoneRedundant":
            suggest = "zone_redundant"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlDatabaseResourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlDatabaseResourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlDatabaseResourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: str,
                 target_resource_name: str,
                 zone_redundant: Optional[str] = None):
        """
        Defines the Sql Database resource settings.
        :param str resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Sql/servers/databases'.
        :param str target_resource_name: Gets or sets the target Resource name.
        :param str zone_redundant: Defines the zone redundant resource setting.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Sql/servers/databases')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if zone_redundant is not None:
            pulumi.set(__self__, "zone_redundant", zone_redundant)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Sql/servers/databases'.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> str:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> Optional[str]:
        """
        Defines the zone redundant resource setting.
        """
        return pulumi.get(self, "zone_redundant")


@pulumi.output_type
class SqlElasticPoolResourceSettingsResponse(dict):
    """
    Defines the Sql ElasticPool resource settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "targetResourceName":
            suggest = "target_resource_name"
        elif key == "zoneRedundant":
            suggest = "zone_redundant"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlElasticPoolResourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlElasticPoolResourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlElasticPoolResourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: str,
                 target_resource_name: str,
                 zone_redundant: Optional[str] = None):
        """
        Defines the Sql ElasticPool resource settings.
        :param str resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Sql/servers/elasticPools'.
        :param str target_resource_name: Gets or sets the target Resource name.
        :param str zone_redundant: Defines the zone redundant resource setting.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Sql/servers/elasticPools')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if zone_redundant is not None:
            pulumi.set(__self__, "zone_redundant", zone_redundant)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Sql/servers/elasticPools'.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> str:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> Optional[str]:
        """
        Defines the zone redundant resource setting.
        """
        return pulumi.get(self, "zone_redundant")


@pulumi.output_type
class SqlServerResourceSettingsResponse(dict):
    """
    Defines the SQL Server resource settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "targetResourceName":
            suggest = "target_resource_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlServerResourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlServerResourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlServerResourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: str,
                 target_resource_name: str):
        """
        Defines the SQL Server resource settings.
        :param str resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Sql/servers'.
        :param str target_resource_name: Gets or sets the target Resource name.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Sql/servers')
        pulumi.set(__self__, "target_resource_name", target_resource_name)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Sql/servers'.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> str:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")


@pulumi.output_type
class SubnetReferenceResponse(dict):
    """
    Defines reference to subnet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceArmResourceId":
            suggest = "source_arm_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubnetReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubnetReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubnetReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_arm_resource_id: str,
                 name: Optional[str] = None):
        """
        Defines reference to subnet.
        :param str source_arm_resource_id: Gets the ARM resource ID of the tracked resource being referenced.
        :param str name: Gets the name of the proxy resource on the target side.
        """
        pulumi.set(__self__, "source_arm_resource_id", source_arm_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="sourceArmResourceId")
    def source_arm_resource_id(self) -> str:
        """
        Gets the ARM resource ID of the tracked resource being referenced.
        """
        return pulumi.get(self, "source_arm_resource_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets the name of the proxy resource on the target side.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SubnetResourceSettingsResponse(dict):
    """
    Defines the virtual network subnets resource settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "networkSecurityGroup":
            suggest = "network_security_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubnetResourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubnetResourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubnetResourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_prefix: Optional[str] = None,
                 name: Optional[str] = None,
                 network_security_group: Optional['outputs.NsgReferenceResponse'] = None):
        """
        Defines the virtual network subnets resource settings.
        :param str address_prefix: Gets or sets address prefix for the subnet.
        :param str name: Gets or sets the Subnet name.
        :param 'NsgReferenceResponse' network_security_group: Defines reference to NSG.
        """
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_security_group is not None:
            pulumi.set(__self__, "network_security_group", network_security_group)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        Gets or sets address prefix for the subnet.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the Subnet name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkSecurityGroup")
    def network_security_group(self) -> Optional['outputs.NsgReferenceResponse']:
        """
        Defines reference to NSG.
        """
        return pulumi.get(self, "network_security_group")


@pulumi.output_type
class VirtualMachineResourceSettingsResponse(dict):
    """
    Gets or sets the virtual machine resource settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "targetResourceName":
            suggest = "target_resource_name"
        elif key == "targetAvailabilitySetId":
            suggest = "target_availability_set_id"
        elif key == "targetAvailabilityZone":
            suggest = "target_availability_zone"
        elif key == "targetVmSize":
            suggest = "target_vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineResourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineResourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineResourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: str,
                 target_resource_name: str,
                 target_availability_set_id: Optional[str] = None,
                 target_availability_zone: Optional[str] = None,
                 target_vm_size: Optional[str] = None):
        """
        Gets or sets the virtual machine resource settings.
        :param str resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Compute/virtualMachines'.
        :param str target_resource_name: Gets or sets the target Resource name.
        :param str target_availability_set_id: Gets or sets the target availability set id for virtual machines not in an availability set at source.
        :param str target_availability_zone: Gets or sets the target availability zone.
        :param str target_vm_size: Gets or sets the target virtual machine size.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Compute/virtualMachines')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if target_availability_set_id is not None:
            pulumi.set(__self__, "target_availability_set_id", target_availability_set_id)
        if target_availability_zone is not None:
            pulumi.set(__self__, "target_availability_zone", target_availability_zone)
        if target_vm_size is not None:
            pulumi.set(__self__, "target_vm_size", target_vm_size)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Compute/virtualMachines'.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> str:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @property
    @pulumi.getter(name="targetAvailabilitySetId")
    def target_availability_set_id(self) -> Optional[str]:
        """
        Gets or sets the target availability set id for virtual machines not in an availability set at source.
        """
        return pulumi.get(self, "target_availability_set_id")

    @property
    @pulumi.getter(name="targetAvailabilityZone")
    def target_availability_zone(self) -> Optional[str]:
        """
        Gets or sets the target availability zone.
        """
        return pulumi.get(self, "target_availability_zone")

    @property
    @pulumi.getter(name="targetVmSize")
    def target_vm_size(self) -> Optional[str]:
        """
        Gets or sets the target virtual machine size.
        """
        return pulumi.get(self, "target_vm_size")


@pulumi.output_type
class VirtualNetworkResourceSettingsResponse(dict):
    """
    Defines the virtual network resource settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "targetResourceName":
            suggest = "target_resource_name"
        elif key == "addressSpace":
            suggest = "address_space"
        elif key == "dnsServers":
            suggest = "dns_servers"
        elif key == "enableDdosProtection":
            suggest = "enable_ddos_protection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkResourceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkResourceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkResourceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: str,
                 target_resource_name: str,
                 address_space: Optional[Sequence[str]] = None,
                 dns_servers: Optional[Sequence[str]] = None,
                 enable_ddos_protection: Optional[bool] = None,
                 subnets: Optional[Sequence['outputs.SubnetResourceSettingsResponse']] = None):
        """
        Defines the virtual network resource settings.
        :param str resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Network/virtualNetworks'.
        :param str target_resource_name: Gets or sets the target Resource name.
        :param Sequence[str] address_space: Gets or sets the address prefixes for the virtual network.
        :param Sequence[str] dns_servers: Gets or sets DHCPOptions that contains an array of DNS servers available to VMs
               deployed in the virtual network.
        :param bool enable_ddos_protection: Gets or sets a value indicating whether gets or sets whether the
               DDOS protection should be switched on.
        :param Sequence['SubnetResourceSettingsResponse'] subnets: Gets or sets List of subnets in a VirtualNetwork.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Network/virtualNetworks')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if address_space is not None:
            pulumi.set(__self__, "address_space", address_space)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if enable_ddos_protection is not None:
            pulumi.set(__self__, "enable_ddos_protection", enable_ddos_protection)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Network/virtualNetworks'.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> str:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @property
    @pulumi.getter(name="addressSpace")
    def address_space(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the address prefixes for the virtual network.
        """
        return pulumi.get(self, "address_space")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[str]]:
        """
        Gets or sets DHCPOptions that contains an array of DNS servers available to VMs
        deployed in the virtual network.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="enableDdosProtection")
    def enable_ddos_protection(self) -> Optional[bool]:
        """
        Gets or sets a value indicating whether gets or sets whether the
        DDOS protection should be switched on.
        """
        return pulumi.get(self, "enable_ddos_protection")

    @property
    @pulumi.getter
    def subnets(self) -> Optional[Sequence['outputs.SubnetResourceSettingsResponse']]:
        """
        Gets or sets List of subnets in a VirtualNetwork.
        """
        return pulumi.get(self, "subnets")


