# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AddressSpaceResponse',
    'ApplicationGatewayBackendAddressPoolResponse',
    'ApplicationGatewayBackendAddressResponse',
    'ApplicationGatewayBackendHttpSettingsResponse',
    'ApplicationGatewayFrontendIPConfigurationResponse',
    'ApplicationGatewayFrontendPortResponse',
    'ApplicationGatewayHttpListenerResponse',
    'ApplicationGatewayIPConfigurationResponse',
    'ApplicationGatewayRequestRoutingRuleResponse',
    'ApplicationGatewaySkuResponse',
    'ApplicationGatewaySslCertificateResponse',
    'BackendAddressPoolResponse',
    'DhcpOptionsResponse',
    'ExpressRouteCircuitAuthorizationResponse',
    'ExpressRouteCircuitPeeringConfigResponse',
    'ExpressRouteCircuitPeeringResponse',
    'ExpressRouteCircuitServiceProviderPropertiesResponse',
    'ExpressRouteCircuitSkuResponse',
    'ExpressRouteCircuitStatsResponse',
    'FrontendIpConfigurationResponse',
    'InboundNatPoolResponse',
    'InboundNatRuleResponse',
    'LoadBalancingRuleResponse',
    'NetworkInterfaceDnsSettingsResponse',
    'NetworkInterfaceIpConfigurationResponse',
    'OutboundNatRuleResponse',
    'ProbeResponse',
    'PublicIpAddressDnsSettingsResponse',
    'RouteResponse',
    'SecurityRuleResponse',
    'SubResourceResponse',
    'SubnetResponse',
]

@pulumi.output_type
class AddressSpaceResponse(dict):
    """
    AddressSpace contains an array of IP address ranges that can be used by subnets
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPrefixes":
            suggest = "address_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddressSpaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddressSpaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddressSpaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_prefixes: Optional[Sequence[str]] = None):
        """
        AddressSpace contains an array of IP address ranges that can be used by subnets
        :param Sequence[str] address_prefixes: Gets or sets List of address blocks reserved for this virtual network in CIDR notation
        """
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[Sequence[str]]:
        """
        Gets or sets List of address blocks reserved for this virtual network in CIDR notation
        """
        return pulumi.get(self, "address_prefixes")


@pulumi.output_type
class ApplicationGatewayBackendAddressPoolResponse(dict):
    """
    Backend Address Pool of application gateway
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendAddresses":
            suggest = "backend_addresses"
        elif key == "backendIPConfigurations":
            suggest = "backend_ip_configurations"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayBackendAddressPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayBackendAddressPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayBackendAddressPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_addresses: Optional[Sequence['outputs.ApplicationGatewayBackendAddressResponse']] = None,
                 backend_ip_configurations: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Backend Address Pool of application gateway
        :param Sequence['ApplicationGatewayBackendAddressResponse'] backend_addresses: Gets or sets the backend addresses
        :param Sequence['SubResourceResponse'] backend_ip_configurations: Gets or sets backendIPConfiguration of application gateway 
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param str id: Resource Id
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param str provisioning_state: Gets or sets Provisioning state of the backend address pool resource Updating/Deleting/Failed
        """
        if backend_addresses is not None:
            pulumi.set(__self__, "backend_addresses", backend_addresses)
        if backend_ip_configurations is not None:
            pulumi.set(__self__, "backend_ip_configurations", backend_ip_configurations)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="backendAddresses")
    def backend_addresses(self) -> Optional[Sequence['outputs.ApplicationGatewayBackendAddressResponse']]:
        """
        Gets or sets the backend addresses
        """
        return pulumi.get(self, "backend_addresses")

    @property
    @pulumi.getter(name="backendIPConfigurations")
    def backend_ip_configurations(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Gets or sets backendIPConfiguration of application gateway 
        """
        return pulumi.get(self, "backend_ip_configurations")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the backend address pool resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class ApplicationGatewayBackendAddressResponse(dict):
    """
    Backend Address of application gateway
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayBackendAddressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayBackendAddressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayBackendAddressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: Optional[str] = None,
                 ip_address: Optional[str] = None):
        """
        Backend Address of application gateway
        :param str fqdn: Gets or sets the dns name
        :param str ip_address: Gets or sets the ip address
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        Gets or sets the dns name
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        Gets or sets the ip address
        """
        return pulumi.get(self, "ip_address")


@pulumi.output_type
class ApplicationGatewayBackendHttpSettingsResponse(dict):
    """
    Backend address pool settings of application gateway
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieBasedAffinity":
            suggest = "cookie_based_affinity"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayBackendHttpSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayBackendHttpSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayBackendHttpSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookie_based_affinity: Optional[str] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 port: Optional[int] = None,
                 protocol: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Backend address pool settings of application gateway
        :param str cookie_based_affinity: Gets or sets the cookie affinity
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param str id: Resource Id
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param int port: Gets or sets the port
        :param str protocol: Gets or sets the protocol
        :param str provisioning_state: Gets or sets Provisioning state of the backend http settings resource Updating/Deleting/Failed
        """
        if cookie_based_affinity is not None:
            pulumi.set(__self__, "cookie_based_affinity", cookie_based_affinity)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="cookieBasedAffinity")
    def cookie_based_affinity(self) -> Optional[str]:
        """
        Gets or sets the cookie affinity
        """
        return pulumi.get(self, "cookie_based_affinity")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Gets or sets the port
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Gets or sets the protocol
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the backend http settings resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class ApplicationGatewayFrontendIPConfigurationResponse(dict):
    """
    Frontend IP configuration of application gateway
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayFrontendIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayFrontendIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayFrontendIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 public_ip_address: Optional['outputs.SubResourceResponse'] = None,
                 subnet: Optional['outputs.SubResourceResponse'] = None):
        """
        Frontend IP configuration of application gateway
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param str id: Resource Id
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param str private_ip_address: Gets or sets the privateIPAddress of the Network Interface IP Configuration
        :param str private_ip_allocation_method: Gets or sets PrivateIP allocation method (Static/Dynamic)
        :param str provisioning_state: Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        :param 'SubResourceResponse' public_ip_address: Gets or sets the reference of the PublicIP resource
        :param 'SubResourceResponse' subnet: Gets or sets the reference of the subnet resource
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        Gets or sets the privateIPAddress of the Network Interface IP Configuration
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        Gets or sets PrivateIP allocation method (Static/Dynamic)
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets the reference of the PublicIP resource
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets the reference of the subnet resource
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class ApplicationGatewayFrontendPortResponse(dict):
    """
    Frontend Port of application gateway
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayFrontendPortResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayFrontendPortResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayFrontendPortResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 port: Optional[int] = None,
                 provisioning_state: Optional[str] = None):
        """
        Frontend Port of application gateway
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param str id: Resource Id
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param int port: Gets or sets the frontend port
        :param str provisioning_state: Gets or sets Provisioning state of the frontend port resource Updating/Deleting/Failed
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Gets or sets the frontend port
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the frontend port resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class ApplicationGatewayHttpListenerResponse(dict):
    """
    Http listener of application gateway
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "frontendIPConfiguration":
            suggest = "frontend_ip_configuration"
        elif key == "frontendPort":
            suggest = "frontend_port"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "sslCertificate":
            suggest = "ssl_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayHttpListenerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayHttpListenerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayHttpListenerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 frontend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 frontend_port: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 protocol: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 ssl_certificate: Optional['outputs.SubResourceResponse'] = None):
        """
        Http listener of application gateway
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param 'SubResourceResponse' frontend_ip_configuration: Gets or sets frontend IP configuration resource of application gateway 
        :param 'SubResourceResponse' frontend_port: Gets or sets frontend port resource of application gateway 
        :param str id: Resource Id
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param str protocol: Gets or sets the protocol
        :param str provisioning_state: Gets or sets Provisioning state of the http listener resource Updating/Deleting/Failed
        :param 'SubResourceResponse' ssl_certificate: Gets or sets ssl certificate resource of application gateway 
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if frontend_port is not None:
            pulumi.set(__self__, "frontend_port", frontend_port)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets frontend IP configuration resource of application gateway 
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets frontend port resource of application gateway 
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Gets or sets the protocol
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the http listener resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets ssl certificate resource of application gateway 
        """
        return pulumi.get(self, "ssl_certificate")


@pulumi.output_type
class ApplicationGatewayIPConfigurationResponse(dict):
    """
    IP configuration of application gateway
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 subnet: Optional['outputs.SubResourceResponse'] = None):
        """
        IP configuration of application gateway
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param str id: Resource Id
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param str provisioning_state: Gets or sets Provisioning state of the application gateway subnet resource Updating/Deleting/Failed
        :param 'SubResourceResponse' subnet: Gets or sets the reference of the subnet resource.A subnet from where application gateway gets its private address 
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the application gateway subnet resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets the reference of the subnet resource.A subnet from where application gateway gets its private address 
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class ApplicationGatewayRequestRoutingRuleResponse(dict):
    """
    Request routing rule of application gateway
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendAddressPool":
            suggest = "backend_address_pool"
        elif key == "backendHttpSettings":
            suggest = "backend_http_settings"
        elif key == "httpListener":
            suggest = "http_listener"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "ruleType":
            suggest = "rule_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayRequestRoutingRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayRequestRoutingRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayRequestRoutingRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_address_pool: Optional['outputs.SubResourceResponse'] = None,
                 backend_http_settings: Optional['outputs.SubResourceResponse'] = None,
                 etag: Optional[str] = None,
                 http_listener: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 rule_type: Optional[str] = None):
        """
        Request routing rule of application gateway
        :param 'SubResourceResponse' backend_address_pool: Gets or sets backend address pool resource of application gateway 
        :param 'SubResourceResponse' backend_http_settings: Gets or sets frontend port resource of application gateway 
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param 'SubResourceResponse' http_listener: Gets or sets http listener resource of application gateway 
        :param str id: Resource Id
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param str provisioning_state: Gets or sets Provisioning state of the request routing rule resource Updating/Deleting/Failed
        :param str rule_type: Gets or sets the rule type
        """
        if backend_address_pool is not None:
            pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        if backend_http_settings is not None:
            pulumi.set(__self__, "backend_http_settings", backend_http_settings)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if http_listener is not None:
            pulumi.set(__self__, "http_listener", http_listener)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if rule_type is not None:
            pulumi.set(__self__, "rule_type", rule_type)

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets backend address pool resource of application gateway 
        """
        return pulumi.get(self, "backend_address_pool")

    @property
    @pulumi.getter(name="backendHttpSettings")
    def backend_http_settings(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets frontend port resource of application gateway 
        """
        return pulumi.get(self, "backend_http_settings")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="httpListener")
    def http_listener(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets http listener resource of application gateway 
        """
        return pulumi.get(self, "http_listener")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the request routing rule resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> Optional[str]:
        """
        Gets or sets the rule type
        """
        return pulumi.get(self, "rule_type")


@pulumi.output_type
class ApplicationGatewaySkuResponse(dict):
    """
    SKU of application gateway
    """
    def __init__(__self__, *,
                 capacity: Optional[int] = None,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        SKU of application gateway
        :param int capacity: Gets or sets capacity (instance count) of application gateway
        :param str name: Gets or sets name of application gateway SKU
        :param str tier: Gets or sets tier of application gateway
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Gets or sets capacity (instance count) of application gateway
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets name of application gateway SKU
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Gets or sets tier of application gateway
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class ApplicationGatewaySslCertificateResponse(dict):
    """
    SSL certificates of application gateway
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicCertData":
            suggest = "public_cert_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewaySslCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewaySslCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewaySslCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data: Optional[str] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 password: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 public_cert_data: Optional[str] = None):
        """
        SSL certificates of application gateway
        :param str data: Gets or sets the certificate data 
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param str id: Resource Id
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param str password: Gets or sets the certificate password 
        :param str provisioning_state: Gets or sets Provisioning state of the ssl certificate resource Updating/Deleting/Failed
        :param str public_cert_data: Gets or sets the certificate public data 
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_cert_data is not None:
            pulumi.set(__self__, "public_cert_data", public_cert_data)

    @property
    @pulumi.getter
    def data(self) -> Optional[str]:
        """
        Gets or sets the certificate data 
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Gets or sets the certificate password 
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the ssl certificate resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicCertData")
    def public_cert_data(self) -> Optional[str]:
        """
        Gets or sets the certificate public data 
        """
        return pulumi.get(self, "public_cert_data")


@pulumi.output_type
class BackendAddressPoolResponse(dict):
    """
    Pool of backend IP addresses
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendIPConfigurations":
            suggest = "backend_ip_configurations"
        elif key == "loadBalancingRules":
            suggest = "load_balancing_rules"
        elif key == "outboundNatRule":
            suggest = "outbound_nat_rule"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendAddressPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendAddressPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendAddressPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_ip_configurations: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 load_balancing_rules: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 name: Optional[str] = None,
                 outbound_nat_rule: Optional['outputs.SubResourceResponse'] = None,
                 provisioning_state: Optional[str] = None):
        """
        Pool of backend IP addresses
        :param Sequence['SubResourceResponse'] backend_ip_configurations: Gets collection of references to IPs defined in NICs
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param str id: Resource Id
        :param Sequence['SubResourceResponse'] load_balancing_rules: Gets Load Balancing rules that use this Backend Address Pool
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param 'SubResourceResponse' outbound_nat_rule: Gets outbound rules that use this Backend Address Pool
        :param str provisioning_state: Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        if backend_ip_configurations is not None:
            pulumi.set(__self__, "backend_ip_configurations", backend_ip_configurations)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancing_rules is not None:
            pulumi.set(__self__, "load_balancing_rules", load_balancing_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_nat_rule is not None:
            pulumi.set(__self__, "outbound_nat_rule", outbound_nat_rule)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="backendIPConfigurations")
    def backend_ip_configurations(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Gets collection of references to IPs defined in NICs
        """
        return pulumi.get(self, "backend_ip_configurations")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancingRules")
    def load_balancing_rules(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Gets Load Balancing rules that use this Backend Address Pool
        """
        return pulumi.get(self, "load_balancing_rules")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundNatRule")
    def outbound_nat_rule(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets outbound rules that use this Backend Address Pool
        """
        return pulumi.get(self, "outbound_nat_rule")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class DhcpOptionsResponse(dict):
    """
    DHCPOptions contains an array of DNS servers available to VMs deployed in the virtual networkStandard DHCP option for a subnet overrides VNET DHCP options.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServers":
            suggest = "dns_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DhcpOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DhcpOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DhcpOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_servers: Optional[Sequence[str]] = None):
        """
        DHCPOptions contains an array of DNS servers available to VMs deployed in the virtual networkStandard DHCP option for a subnet overrides VNET DHCP options.
        :param Sequence[str] dns_servers: Gets or sets list of DNS servers IP addresses
        """
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[str]]:
        """
        Gets or sets list of DNS servers IP addresses
        """
        return pulumi.get(self, "dns_servers")


@pulumi.output_type
class ExpressRouteCircuitAuthorizationResponse(dict):
    """
    Authorization in a ExpressRouteCircuit resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationKey":
            suggest = "authorization_key"
        elif key == "authorizationUseStatus":
            suggest = "authorization_use_status"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitAuthorizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitAuthorizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitAuthorizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_key: Optional[str] = None,
                 authorization_use_status: Optional[str] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Authorization in a ExpressRouteCircuit resource
        :param str authorization_key: Gets or sets the authorization key
        :param str authorization_use_status: Gets or sets AuthorizationUseStatus
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param str id: Resource Id
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param str provisioning_state: Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if authorization_use_status is not None:
            pulumi.set(__self__, "authorization_use_status", authorization_use_status)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[str]:
        """
        Gets or sets the authorization key
        """
        return pulumi.get(self, "authorization_key")

    @property
    @pulumi.getter(name="authorizationUseStatus")
    def authorization_use_status(self) -> Optional[str]:
        """
        Gets or sets AuthorizationUseStatus
        """
        return pulumi.get(self, "authorization_use_status")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class ExpressRouteCircuitPeeringConfigResponse(dict):
    """
    Specifies the peering config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advertisedPublicPrefixes":
            suggest = "advertised_public_prefixes"
        elif key == "advertisedPublicPrefixesState":
            suggest = "advertised_public_prefixes_state"
        elif key == "customerASN":
            suggest = "customer_asn"
        elif key == "routingRegistryName":
            suggest = "routing_registry_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitPeeringConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitPeeringConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitPeeringConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advertised_public_prefixes: Optional[Sequence[str]] = None,
                 advertised_public_prefixes_state: Optional[str] = None,
                 customer_asn: Optional[int] = None,
                 routing_registry_name: Optional[str] = None):
        """
        Specifies the peering config
        :param Sequence[str] advertised_public_prefixes: Gets or sets the reference of AdvertisedPublicPrefixes
        :param str advertised_public_prefixes_state: Gets or sets AdvertisedPublicPrefixState of the Peering resource 
        :param int customer_asn: Gets or Sets CustomerAsn of the peering.
        :param str routing_registry_name: Gets or Sets RoutingRegistryName of the config.
        """
        if advertised_public_prefixes is not None:
            pulumi.set(__self__, "advertised_public_prefixes", advertised_public_prefixes)
        if advertised_public_prefixes_state is not None:
            pulumi.set(__self__, "advertised_public_prefixes_state", advertised_public_prefixes_state)
        if customer_asn is not None:
            pulumi.set(__self__, "customer_asn", customer_asn)
        if routing_registry_name is not None:
            pulumi.set(__self__, "routing_registry_name", routing_registry_name)

    @property
    @pulumi.getter(name="advertisedPublicPrefixes")
    def advertised_public_prefixes(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the reference of AdvertisedPublicPrefixes
        """
        return pulumi.get(self, "advertised_public_prefixes")

    @property
    @pulumi.getter(name="advertisedPublicPrefixesState")
    def advertised_public_prefixes_state(self) -> Optional[str]:
        """
        Gets or sets AdvertisedPublicPrefixState of the Peering resource 
        """
        return pulumi.get(self, "advertised_public_prefixes_state")

    @property
    @pulumi.getter(name="customerASN")
    def customer_asn(self) -> Optional[int]:
        """
        Gets or Sets CustomerAsn of the peering.
        """
        return pulumi.get(self, "customer_asn")

    @property
    @pulumi.getter(name="routingRegistryName")
    def routing_registry_name(self) -> Optional[str]:
        """
        Gets or Sets RoutingRegistryName of the config.
        """
        return pulumi.get(self, "routing_registry_name")


@pulumi.output_type
class ExpressRouteCircuitPeeringResponse(dict):
    """
    Peering in a ExpressRouteCircuit resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureASN":
            suggest = "azure_asn"
        elif key == "microsoftPeeringConfig":
            suggest = "microsoft_peering_config"
        elif key == "peerASN":
            suggest = "peer_asn"
        elif key == "peeringType":
            suggest = "peering_type"
        elif key == "primaryAzurePort":
            suggest = "primary_azure_port"
        elif key == "primaryPeerAddressPrefix":
            suggest = "primary_peer_address_prefix"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "secondaryAzurePort":
            suggest = "secondary_azure_port"
        elif key == "secondaryPeerAddressPrefix":
            suggest = "secondary_peer_address_prefix"
        elif key == "sharedKey":
            suggest = "shared_key"
        elif key == "vlanId":
            suggest = "vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitPeeringResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitPeeringResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitPeeringResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_asn: Optional[int] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 microsoft_peering_config: Optional['outputs.ExpressRouteCircuitPeeringConfigResponse'] = None,
                 name: Optional[str] = None,
                 peer_asn: Optional[int] = None,
                 peering_type: Optional[str] = None,
                 primary_azure_port: Optional[str] = None,
                 primary_peer_address_prefix: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 secondary_azure_port: Optional[str] = None,
                 secondary_peer_address_prefix: Optional[str] = None,
                 shared_key: Optional[str] = None,
                 state: Optional[str] = None,
                 stats: Optional['outputs.ExpressRouteCircuitStatsResponse'] = None,
                 vlan_id: Optional[int] = None):
        """
        Peering in a ExpressRouteCircuit resource
        :param int azure_asn: Gets or sets the azure ASN
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param str id: Resource Id
        :param 'ExpressRouteCircuitPeeringConfigResponse' microsoft_peering_config: Gets or sets the Microsoft peering config
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param int peer_asn: Gets or sets the peer ASN
        :param str peering_type: Gets or sets PeeringType
        :param str primary_azure_port: Gets or sets the primary port
        :param str primary_peer_address_prefix: Gets or sets the primary address prefix
        :param str provisioning_state: Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        :param str secondary_azure_port: Gets or sets the secondary port
        :param str secondary_peer_address_prefix: Gets or sets the secondary address prefix
        :param str shared_key: Gets or sets the shared key
        :param str state: Gets or sets state of Peering
        :param 'ExpressRouteCircuitStatsResponse' stats: Gets or peering stats
        :param int vlan_id: Gets or sets the vlan id
        """
        if azure_asn is not None:
            pulumi.set(__self__, "azure_asn", azure_asn)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if microsoft_peering_config is not None:
            pulumi.set(__self__, "microsoft_peering_config", microsoft_peering_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peering_type is not None:
            pulumi.set(__self__, "peering_type", peering_type)
        if primary_azure_port is not None:
            pulumi.set(__self__, "primary_azure_port", primary_azure_port)
        if primary_peer_address_prefix is not None:
            pulumi.set(__self__, "primary_peer_address_prefix", primary_peer_address_prefix)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if secondary_azure_port is not None:
            pulumi.set(__self__, "secondary_azure_port", secondary_azure_port)
        if secondary_peer_address_prefix is not None:
            pulumi.set(__self__, "secondary_peer_address_prefix", secondary_peer_address_prefix)
        if shared_key is not None:
            pulumi.set(__self__, "shared_key", shared_key)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stats is not None:
            pulumi.set(__self__, "stats", stats)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter(name="azureASN")
    def azure_asn(self) -> Optional[int]:
        """
        Gets or sets the azure ASN
        """
        return pulumi.get(self, "azure_asn")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="microsoftPeeringConfig")
    def microsoft_peering_config(self) -> Optional['outputs.ExpressRouteCircuitPeeringConfigResponse']:
        """
        Gets or sets the Microsoft peering config
        """
        return pulumi.get(self, "microsoft_peering_config")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerASN")
    def peer_asn(self) -> Optional[int]:
        """
        Gets or sets the peer ASN
        """
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="peeringType")
    def peering_type(self) -> Optional[str]:
        """
        Gets or sets PeeringType
        """
        return pulumi.get(self, "peering_type")

    @property
    @pulumi.getter(name="primaryAzurePort")
    def primary_azure_port(self) -> Optional[str]:
        """
        Gets or sets the primary port
        """
        return pulumi.get(self, "primary_azure_port")

    @property
    @pulumi.getter(name="primaryPeerAddressPrefix")
    def primary_peer_address_prefix(self) -> Optional[str]:
        """
        Gets or sets the primary address prefix
        """
        return pulumi.get(self, "primary_peer_address_prefix")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="secondaryAzurePort")
    def secondary_azure_port(self) -> Optional[str]:
        """
        Gets or sets the secondary port
        """
        return pulumi.get(self, "secondary_azure_port")

    @property
    @pulumi.getter(name="secondaryPeerAddressPrefix")
    def secondary_peer_address_prefix(self) -> Optional[str]:
        """
        Gets or sets the secondary address prefix
        """
        return pulumi.get(self, "secondary_peer_address_prefix")

    @property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> Optional[str]:
        """
        Gets or sets the shared key
        """
        return pulumi.get(self, "shared_key")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Gets or sets state of Peering
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def stats(self) -> Optional['outputs.ExpressRouteCircuitStatsResponse']:
        """
        Gets or peering stats
        """
        return pulumi.get(self, "stats")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[int]:
        """
        Gets or sets the vlan id
        """
        return pulumi.get(self, "vlan_id")


@pulumi.output_type
class ExpressRouteCircuitServiceProviderPropertiesResponse(dict):
    """
    Contains ServiceProviderProperties in an ExpressRouteCircuit
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bandwidthInMbps":
            suggest = "bandwidth_in_mbps"
        elif key == "peeringLocation":
            suggest = "peering_location"
        elif key == "serviceProviderName":
            suggest = "service_provider_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitServiceProviderPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitServiceProviderPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitServiceProviderPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth_in_mbps: Optional[int] = None,
                 peering_location: Optional[str] = None,
                 service_provider_name: Optional[str] = None):
        """
        Contains ServiceProviderProperties in an ExpressRouteCircuit
        :param int bandwidth_in_mbps: Gets or sets BandwidthInMbps.
        :param str peering_location: Gets or sets peering location.
        :param str service_provider_name: Gets or sets serviceProviderName.
        """
        if bandwidth_in_mbps is not None:
            pulumi.set(__self__, "bandwidth_in_mbps", bandwidth_in_mbps)
        if peering_location is not None:
            pulumi.set(__self__, "peering_location", peering_location)
        if service_provider_name is not None:
            pulumi.set(__self__, "service_provider_name", service_provider_name)

    @property
    @pulumi.getter(name="bandwidthInMbps")
    def bandwidth_in_mbps(self) -> Optional[int]:
        """
        Gets or sets BandwidthInMbps.
        """
        return pulumi.get(self, "bandwidth_in_mbps")

    @property
    @pulumi.getter(name="peeringLocation")
    def peering_location(self) -> Optional[str]:
        """
        Gets or sets peering location.
        """
        return pulumi.get(self, "peering_location")

    @property
    @pulumi.getter(name="serviceProviderName")
    def service_provider_name(self) -> Optional[str]:
        """
        Gets or sets serviceProviderName.
        """
        return pulumi.get(self, "service_provider_name")


@pulumi.output_type
class ExpressRouteCircuitSkuResponse(dict):
    """
    Contains sku in an ExpressRouteCircuit
    """
    def __init__(__self__, *,
                 family: Optional[str] = None,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        Contains sku in an ExpressRouteCircuit
        :param str family: Gets or sets family of the sku.
        :param str name: Gets or sets name of the sku.
        :param str tier: Gets or sets tier of the sku.
        """
        if family is not None:
            pulumi.set(__self__, "family", family)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        Gets or sets family of the sku.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets name of the sku.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Gets or sets tier of the sku.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class ExpressRouteCircuitStatsResponse(dict):
    """
    Contains Stats associated with the peering
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bytesIn":
            suggest = "bytes_in"
        elif key == "bytesOut":
            suggest = "bytes_out"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitStatsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitStatsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitStatsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bytes_in: Optional[int] = None,
                 bytes_out: Optional[int] = None):
        """
        Contains Stats associated with the peering
        :param int bytes_in: Gets BytesIn of the peering.
        :param int bytes_out: Gets BytesOut of the peering.
        """
        if bytes_in is not None:
            pulumi.set(__self__, "bytes_in", bytes_in)
        if bytes_out is not None:
            pulumi.set(__self__, "bytes_out", bytes_out)

    @property
    @pulumi.getter(name="bytesIn")
    def bytes_in(self) -> Optional[int]:
        """
        Gets BytesIn of the peering.
        """
        return pulumi.get(self, "bytes_in")

    @property
    @pulumi.getter(name="bytesOut")
    def bytes_out(self) -> Optional[int]:
        """
        Gets BytesOut of the peering.
        """
        return pulumi.get(self, "bytes_out")


@pulumi.output_type
class FrontendIpConfigurationResponse(dict):
    """
    Frontend IP address of the load balancer
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inboundNatPools":
            suggest = "inbound_nat_pools"
        elif key == "inboundNatRules":
            suggest = "inbound_nat_rules"
        elif key == "loadBalancingRules":
            suggest = "load_balancing_rules"
        elif key == "outboundNatRules":
            suggest = "outbound_nat_rules"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontendIpConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontendIpConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontendIpConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 inbound_nat_pools: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 inbound_nat_rules: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 load_balancing_rules: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 name: Optional[str] = None,
                 outbound_nat_rules: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 public_ip_address: Optional['outputs.SubResourceResponse'] = None,
                 subnet: Optional['outputs.SubResourceResponse'] = None):
        """
        Frontend IP address of the load balancer
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param str id: Resource Id
        :param Sequence['SubResourceResponse'] inbound_nat_pools: Read only.Inbound pools URIs that use this frontend IP
        :param Sequence['SubResourceResponse'] inbound_nat_rules: Read only.Inbound rules URIs that use this frontend IP
        :param Sequence['SubResourceResponse'] load_balancing_rules: Gets Load Balancing rules URIs that use this frontend IP
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param Sequence['SubResourceResponse'] outbound_nat_rules: Read only.Outbound rules URIs that use this frontend IP
        :param str private_ip_address: Gets or sets the IP address of the Load Balancer.This is only specified if a specific private IP address shall be allocated from the subnet specified in subnetRef
        :param str private_ip_allocation_method: Gets or sets PrivateIP allocation method (Static/Dynamic)
        :param str provisioning_state: Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        :param 'SubResourceResponse' public_ip_address: Gets or sets the reference of the PublicIP resource
        :param 'SubResourceResponse' subnet: Gets or sets the reference of the subnet resource.A subnet from where the load balancer gets its private frontend address 
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if inbound_nat_pools is not None:
            pulumi.set(__self__, "inbound_nat_pools", inbound_nat_pools)
        if inbound_nat_rules is not None:
            pulumi.set(__self__, "inbound_nat_rules", inbound_nat_rules)
        if load_balancing_rules is not None:
            pulumi.set(__self__, "load_balancing_rules", load_balancing_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_nat_rules is not None:
            pulumi.set(__self__, "outbound_nat_rules", outbound_nat_rules)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inboundNatPools")
    def inbound_nat_pools(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Read only.Inbound pools URIs that use this frontend IP
        """
        return pulumi.get(self, "inbound_nat_pools")

    @property
    @pulumi.getter(name="inboundNatRules")
    def inbound_nat_rules(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Read only.Inbound rules URIs that use this frontend IP
        """
        return pulumi.get(self, "inbound_nat_rules")

    @property
    @pulumi.getter(name="loadBalancingRules")
    def load_balancing_rules(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Gets Load Balancing rules URIs that use this frontend IP
        """
        return pulumi.get(self, "load_balancing_rules")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundNatRules")
    def outbound_nat_rules(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Read only.Outbound rules URIs that use this frontend IP
        """
        return pulumi.get(self, "outbound_nat_rules")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        Gets or sets the IP address of the Load Balancer.This is only specified if a specific private IP address shall be allocated from the subnet specified in subnetRef
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        Gets or sets PrivateIP allocation method (Static/Dynamic)
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets the reference of the PublicIP resource
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets the reference of the subnet resource.A subnet from where the load balancer gets its private frontend address 
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class InboundNatPoolResponse(dict):
    """
    Inbound NAT pool of the loadbalancer
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPort":
            suggest = "backend_port"
        elif key == "frontendPortRangeEnd":
            suggest = "frontend_port_range_end"
        elif key == "frontendPortRangeStart":
            suggest = "frontend_port_range_start"
        elif key == "frontendIPConfiguration":
            suggest = "frontend_ip_configuration"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundNatPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundNatPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundNatPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_port: int,
                 frontend_port_range_end: int,
                 frontend_port_range_start: int,
                 protocol: str,
                 etag: Optional[str] = None,
                 frontend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Inbound NAT pool of the loadbalancer
        :param int backend_port: Gets or sets a port used for internal connections on the endpoint. The localPort attribute maps the eternal port of the endpoint to an internal port on a role. This is useful in scenarios where a role must communicate to an internal component on a port that is different from the one that is exposed externally. If not specified, the value of localPort is the same as the port attribute. Set the value of localPort to '*' to automatically assign an unallocated port that is discoverable using the runtime API
        :param int frontend_port_range_end: Gets or sets the ending port range for the NAT pool. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive
        :param int frontend_port_range_start: Gets or sets the starting port range for the NAT pool. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive
        :param str protocol: Gets or sets the transport protocol for the external endpoint. Possible values are Udp or Tcp
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param 'SubResourceResponse' frontend_ip_configuration: Gets or sets a reference to frontend IP Addresses
        :param str id: Resource Id
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param str provisioning_state: Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port_range_end", frontend_port_range_end)
        pulumi.set(__self__, "frontend_port_range_start", frontend_port_range_start)
        pulumi.set(__self__, "protocol", protocol)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> int:
        """
        Gets or sets a port used for internal connections on the endpoint. The localPort attribute maps the eternal port of the endpoint to an internal port on a role. This is useful in scenarios where a role must communicate to an internal component on a port that is different from the one that is exposed externally. If not specified, the value of localPort is the same as the port attribute. Set the value of localPort to '*' to automatically assign an unallocated port that is discoverable using the runtime API
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="frontendPortRangeEnd")
    def frontend_port_range_end(self) -> int:
        """
        Gets or sets the ending port range for the NAT pool. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive
        """
        return pulumi.get(self, "frontend_port_range_end")

    @property
    @pulumi.getter(name="frontendPortRangeStart")
    def frontend_port_range_start(self) -> int:
        """
        Gets or sets the starting port range for the NAT pool. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive
        """
        return pulumi.get(self, "frontend_port_range_start")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Gets or sets the transport protocol for the external endpoint. Possible values are Udp or Tcp
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets a reference to frontend IP Addresses
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class InboundNatRuleResponse(dict):
    """
    Inbound NAT rule of the loadbalancer
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableFloatingIP":
            suggest = "enable_floating_ip"
        elif key == "frontendPort":
            suggest = "frontend_port"
        elif key == "backendIPConfiguration":
            suggest = "backend_ip_configuration"
        elif key == "backendPort":
            suggest = "backend_port"
        elif key == "frontendIPConfiguration":
            suggest = "frontend_ip_configuration"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundNatRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundNatRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundNatRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_floating_ip: bool,
                 frontend_port: int,
                 protocol: str,
                 backend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 backend_port: Optional[int] = None,
                 etag: Optional[str] = None,
                 frontend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 idle_timeout_in_minutes: Optional[int] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Inbound NAT rule of the loadbalancer
        :param bool enable_floating_ip: Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn availability Group. This setting is required when using the SQL Always ON availability Groups in SQL server. This setting can't be changed after you create the endpoint
        :param int frontend_port: Gets or sets the port for the external endpoint. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive
        :param str protocol: Gets or sets the transport protocol for the external endpoint. Possible values are Udp or Tcp
        :param 'SubResourceResponse' backend_ip_configuration: Gets or sets a reference to a private ip address defined on a NetworkInterface of a VM. Traffic sent to frontendPort of each of the frontendIPConfigurations is forwarded to the backed IP
        :param int backend_port: Gets or sets a port used for internal connections on the endpoint. The localPort attribute maps the eternal port of the endpoint to an internal port on a role. This is useful in scenarios where a role must communicate to an internal component on a port that is different from the one that is exposed externally. If not specified, the value of localPort is the same as the port attribute. Set the value of localPort to '*' to automatically assign an unallocated port that is discoverable using the runtime API
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param 'SubResourceResponse' frontend_ip_configuration: Gets or sets a reference to frontend IP Addresses
        :param str id: Resource Id
        :param int idle_timeout_in_minutes: Gets or sets the timeout for the Tcp idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to Tcp
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param str provisioning_state: Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "protocol", protocol)
        if backend_ip_configuration is not None:
            pulumi.set(__self__, "backend_ip_configuration", backend_ip_configuration)
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="enableFloatingIP")
    def enable_floating_ip(self) -> bool:
        """
        Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn availability Group. This setting is required when using the SQL Always ON availability Groups in SQL server. This setting can't be changed after you create the endpoint
        """
        return pulumi.get(self, "enable_floating_ip")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> int:
        """
        Gets or sets the port for the external endpoint. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Gets or sets the transport protocol for the external endpoint. Possible values are Udp or Tcp
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="backendIPConfiguration")
    def backend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets a reference to a private ip address defined on a NetworkInterface of a VM. Traffic sent to frontendPort of each of the frontendIPConfigurations is forwarded to the backed IP
        """
        return pulumi.get(self, "backend_ip_configuration")

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[int]:
        """
        Gets or sets a port used for internal connections on the endpoint. The localPort attribute maps the eternal port of the endpoint to an internal port on a role. This is useful in scenarios where a role must communicate to an internal component on a port that is different from the one that is exposed externally. If not specified, the value of localPort is the same as the port attribute. Set the value of localPort to '*' to automatically assign an unallocated port that is discoverable using the runtime API
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets a reference to frontend IP Addresses
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        Gets or sets the timeout for the Tcp idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to Tcp
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class LoadBalancingRuleResponse(dict):
    """
    Rules of the load balancer
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendAddressPool":
            suggest = "backend_address_pool"
        elif key == "enableFloatingIP":
            suggest = "enable_floating_ip"
        elif key == "frontendPort":
            suggest = "frontend_port"
        elif key == "backendPort":
            suggest = "backend_port"
        elif key == "frontendIPConfiguration":
            suggest = "frontend_ip_configuration"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "loadDistribution":
            suggest = "load_distribution"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancingRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancingRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancingRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_address_pool: 'outputs.SubResourceResponse',
                 enable_floating_ip: bool,
                 frontend_port: int,
                 protocol: str,
                 backend_port: Optional[int] = None,
                 etag: Optional[str] = None,
                 frontend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 idle_timeout_in_minutes: Optional[int] = None,
                 load_distribution: Optional[str] = None,
                 name: Optional[str] = None,
                 probe: Optional['outputs.SubResourceResponse'] = None,
                 provisioning_state: Optional[str] = None):
        """
        Rules of the load balancer
        :param 'SubResourceResponse' backend_address_pool: Gets or sets  a reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs
        :param bool enable_floating_ip: Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn availability Group. This setting is required when using the SQL Always ON availability Groups in SQL server. This setting can't be changed after you create the endpoint
        :param int frontend_port: Gets or sets the port for the external endpoint. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive
        :param str protocol: Gets or sets the transport protocol for the external endpoint. Possible values are Udp or Tcp
        :param int backend_port: Gets or sets a port used for internal connections on the endpoint. The localPort attribute maps the eternal port of the endpoint to an internal port on a role. This is useful in scenarios where a role must communicate to an internal component on a port that is different from the one that is exposed externally. If not specified, the value of localPort is the same as the port attribute. Set the value of localPort to '*' to automatically assign an unallocated port that is discoverable using the runtime API
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param 'SubResourceResponse' frontend_ip_configuration: Gets or sets a reference to frontend IP Addresses
        :param str id: Resource Id
        :param int idle_timeout_in_minutes: Gets or sets the timeout for the Tcp idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to Tcp
        :param str load_distribution: Gets or sets the load distribution policy for this rule
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param 'SubResourceResponse' probe: Gets or sets the reference of the load balancer probe used by the Load Balancing rule.
        :param str provisioning_state: Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "protocol", protocol)
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if load_distribution is not None:
            pulumi.set(__self__, "load_distribution", load_distribution)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if probe is not None:
            pulumi.set(__self__, "probe", probe)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> 'outputs.SubResourceResponse':
        """
        Gets or sets  a reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs
        """
        return pulumi.get(self, "backend_address_pool")

    @property
    @pulumi.getter(name="enableFloatingIP")
    def enable_floating_ip(self) -> bool:
        """
        Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn availability Group. This setting is required when using the SQL Always ON availability Groups in SQL server. This setting can't be changed after you create the endpoint
        """
        return pulumi.get(self, "enable_floating_ip")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> int:
        """
        Gets or sets the port for the external endpoint. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Gets or sets the transport protocol for the external endpoint. Possible values are Udp or Tcp
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[int]:
        """
        Gets or sets a port used for internal connections on the endpoint. The localPort attribute maps the eternal port of the endpoint to an internal port on a role. This is useful in scenarios where a role must communicate to an internal component on a port that is different from the one that is exposed externally. If not specified, the value of localPort is the same as the port attribute. Set the value of localPort to '*' to automatically assign an unallocated port that is discoverable using the runtime API
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets a reference to frontend IP Addresses
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        Gets or sets the timeout for the Tcp idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to Tcp
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="loadDistribution")
    def load_distribution(self) -> Optional[str]:
        """
        Gets or sets the load distribution policy for this rule
        """
        return pulumi.get(self, "load_distribution")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def probe(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets the reference of the load balancer probe used by the Load Balancing rule.
        """
        return pulumi.get(self, "probe")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class NetworkInterfaceDnsSettingsResponse(dict):
    """
    Dns Settings of a network interface
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appliedDnsServers":
            suggest = "applied_dns_servers"
        elif key == "dnsServers":
            suggest = "dns_servers"
        elif key == "internalDnsNameLabel":
            suggest = "internal_dns_name_label"
        elif key == "internalFqdn":
            suggest = "internal_fqdn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceDnsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceDnsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceDnsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applied_dns_servers: Optional[Sequence[str]] = None,
                 dns_servers: Optional[Sequence[str]] = None,
                 internal_dns_name_label: Optional[str] = None,
                 internal_fqdn: Optional[str] = None):
        """
        Dns Settings of a network interface
        :param Sequence[str] applied_dns_servers: Gets or sets list of Applied DNS servers IP addresses
        :param Sequence[str] dns_servers: Gets or sets list of DNS servers IP addresses
        :param str internal_dns_name_label: Gets or sets the Internal DNS name
        :param str internal_fqdn: Gets or sets full IDNS name in the form, DnsName.VnetId.ZoneId.TopLevelSuffix. This is set when the NIC is associated to a VM
        """
        if applied_dns_servers is not None:
            pulumi.set(__self__, "applied_dns_servers", applied_dns_servers)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if internal_dns_name_label is not None:
            pulumi.set(__self__, "internal_dns_name_label", internal_dns_name_label)
        if internal_fqdn is not None:
            pulumi.set(__self__, "internal_fqdn", internal_fqdn)

    @property
    @pulumi.getter(name="appliedDnsServers")
    def applied_dns_servers(self) -> Optional[Sequence[str]]:
        """
        Gets or sets list of Applied DNS servers IP addresses
        """
        return pulumi.get(self, "applied_dns_servers")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[str]]:
        """
        Gets or sets list of DNS servers IP addresses
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="internalDnsNameLabel")
    def internal_dns_name_label(self) -> Optional[str]:
        """
        Gets or sets the Internal DNS name
        """
        return pulumi.get(self, "internal_dns_name_label")

    @property
    @pulumi.getter(name="internalFqdn")
    def internal_fqdn(self) -> Optional[str]:
        """
        Gets or sets full IDNS name in the form, DnsName.VnetId.ZoneId.TopLevelSuffix. This is set when the NIC is associated to a VM
        """
        return pulumi.get(self, "internal_fqdn")


@pulumi.output_type
class NetworkInterfaceIpConfigurationResponse(dict):
    """
    IPConfiguration in a NetworkInterface
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadBalancerBackendAddressPools":
            suggest = "load_balancer_backend_address_pools"
        elif key == "loadBalancerInboundNatRules":
            suggest = "load_balancer_inbound_nat_rules"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceIpConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceIpConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceIpConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 load_balancer_backend_address_pools: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 load_balancer_inbound_nat_rules: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 name: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 public_ip_address: Optional['outputs.SubResourceResponse'] = None,
                 subnet: Optional['outputs.SubResourceResponse'] = None):
        """
        IPConfiguration in a NetworkInterface
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param str id: Resource Id
        :param Sequence['SubResourceResponse'] load_balancer_backend_address_pools: Gets or sets the reference of LoadBalancerBackendAddressPool resource
        :param Sequence['SubResourceResponse'] load_balancer_inbound_nat_rules: Gets or sets list of references of LoadBalancerInboundNatRules
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param str private_ip_address: Gets or sets the privateIPAddress of the Network Interface IP Configuration
        :param str private_ip_allocation_method: Gets or sets PrivateIP allocation method (Static/Dynamic)
        :param str provisioning_state: Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        :param 'SubResourceResponse' public_ip_address: Gets or sets the reference of the PublicIP resource
        :param 'SubResourceResponse' subnet: Gets or sets the reference of the subnet resource
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancer_backend_address_pools is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pools", load_balancer_backend_address_pools)
        if load_balancer_inbound_nat_rules is not None:
            pulumi.set(__self__, "load_balancer_inbound_nat_rules", load_balancer_inbound_nat_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancerBackendAddressPools")
    def load_balancer_backend_address_pools(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Gets or sets the reference of LoadBalancerBackendAddressPool resource
        """
        return pulumi.get(self, "load_balancer_backend_address_pools")

    @property
    @pulumi.getter(name="loadBalancerInboundNatRules")
    def load_balancer_inbound_nat_rules(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Gets or sets list of references of LoadBalancerInboundNatRules
        """
        return pulumi.get(self, "load_balancer_inbound_nat_rules")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        Gets or sets the privateIPAddress of the Network Interface IP Configuration
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        Gets or sets PrivateIP allocation method (Static/Dynamic)
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets the reference of the PublicIP resource
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets the reference of the subnet resource
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class OutboundNatRuleResponse(dict):
    """
    Outbound NAT pool of the loadbalancer
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocatedOutboundPorts":
            suggest = "allocated_outbound_ports"
        elif key == "backendAddressPool":
            suggest = "backend_address_pool"
        elif key == "frontendIPConfigurations":
            suggest = "frontend_ip_configurations"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutboundNatRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutboundNatRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutboundNatRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocated_outbound_ports: int,
                 backend_address_pool: 'outputs.SubResourceResponse',
                 etag: Optional[str] = None,
                 frontend_ip_configurations: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Outbound NAT pool of the loadbalancer
        :param int allocated_outbound_ports: Gets or sets the number of outbound ports to be used for SNAT
        :param 'SubResourceResponse' backend_address_pool: Gets or sets a reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param Sequence['SubResourceResponse'] frontend_ip_configurations: Gets or sets Frontend IP addresses of the load balancer
        :param str id: Resource Id
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param str provisioning_state: Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        pulumi.set(__self__, "allocated_outbound_ports", allocated_outbound_ports)
        pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if frontend_ip_configurations is not None:
            pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="allocatedOutboundPorts")
    def allocated_outbound_ports(self) -> int:
        """
        Gets or sets the number of outbound ports to be used for SNAT
        """
        return pulumi.get(self, "allocated_outbound_ports")

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> 'outputs.SubResourceResponse':
        """
        Gets or sets a reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs
        """
        return pulumi.get(self, "backend_address_pool")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendIPConfigurations")
    def frontend_ip_configurations(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Gets or sets Frontend IP addresses of the load balancer
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class ProbeResponse(dict):
    """
    Load balancer Probe
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "loadBalancingRules":
            suggest = "load_balancing_rules"
        elif key == "numberOfProbes":
            suggest = "number_of_probes"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "requestPath":
            suggest = "request_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProbeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProbeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProbeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: int,
                 protocol: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 interval_in_seconds: Optional[int] = None,
                 load_balancing_rules: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 name: Optional[str] = None,
                 number_of_probes: Optional[int] = None,
                 provisioning_state: Optional[str] = None,
                 request_path: Optional[str] = None):
        """
        Load balancer Probe
        :param int port: Gets or sets Port for communicating the probe. Possible values range from 1 to 65535, inclusive.
        :param str protocol: Gets or sets the protocol of the end point. Possible values are http pr Tcp. If Tcp is specified, a received ACK is required for the probe to be successful. If http is specified,a 200 OK response from the specifies URI is required for the probe to be successful
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param str id: Resource Id
        :param int interval_in_seconds: Gets or sets the interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5
        :param Sequence['SubResourceResponse'] load_balancing_rules: Gets Load balancer rules that use this probe
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param int number_of_probes: Gets or sets the number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure. 
        :param str provisioning_state: Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        :param str request_path: Gets or sets the URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if load_balancing_rules is not None:
            pulumi.set(__self__, "load_balancing_rules", load_balancing_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_probes is not None:
            pulumi.set(__self__, "number_of_probes", number_of_probes)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if request_path is not None:
            pulumi.set(__self__, "request_path", request_path)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Gets or sets Port for communicating the probe. Possible values range from 1 to 65535, inclusive.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Gets or sets the protocol of the end point. Possible values are http pr Tcp. If Tcp is specified, a received ACK is required for the probe to be successful. If http is specified,a 200 OK response from the specifies URI is required for the probe to be successful
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[int]:
        """
        Gets or sets the interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter(name="loadBalancingRules")
    def load_balancing_rules(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Gets Load balancer rules that use this probe
        """
        return pulumi.get(self, "load_balancing_rules")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfProbes")
    def number_of_probes(self) -> Optional[int]:
        """
        Gets or sets the number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure. 
        """
        return pulumi.get(self, "number_of_probes")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> Optional[str]:
        """
        Gets or sets the URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value
        """
        return pulumi.get(self, "request_path")


@pulumi.output_type
class PublicIpAddressDnsSettingsResponse(dict):
    """
    Contains FQDN of the DNS record associated with the public IP address
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainNameLabel":
            suggest = "domain_name_label"
        elif key == "reverseFqdn":
            suggest = "reverse_fqdn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicIpAddressDnsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicIpAddressDnsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicIpAddressDnsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name_label: Optional[str] = None,
                 fqdn: Optional[str] = None,
                 reverse_fqdn: Optional[str] = None):
        """
        Contains FQDN of the DNS record associated with the public IP address
        :param str domain_name_label: Gets or sets the Domain name label.The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        :param str fqdn: Gets the FQDN, Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
        :param str reverse_fqdn: Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN. 
        """
        if domain_name_label is not None:
            pulumi.set(__self__, "domain_name_label", domain_name_label)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if reverse_fqdn is not None:
            pulumi.set(__self__, "reverse_fqdn", reverse_fqdn)

    @property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> Optional[str]:
        """
        Gets or sets the Domain name label.The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        """
        return pulumi.get(self, "domain_name_label")

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        Gets the FQDN, Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="reverseFqdn")
    def reverse_fqdn(self) -> Optional[str]:
        """
        Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN. 
        """
        return pulumi.get(self, "reverse_fqdn")


@pulumi.output_type
class RouteResponse(dict):
    """
    Route resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nextHopType":
            suggest = "next_hop_type"
        elif key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "nextHopIpAddress":
            suggest = "next_hop_ip_address"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 next_hop_type: str,
                 address_prefix: Optional[str] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 next_hop_ip_address: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Route resource
        :param str next_hop_type: Gets or sets the type of Azure hop the packet should be sent to.
        :param str address_prefix: Gets or sets the destination CIDR to which the route applies.
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param str id: Resource Id
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param str next_hop_ip_address: Gets or sets the IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
        :param str provisioning_state: Gets or sets Provisioning state of the resource Updating/Deleting/Failed
        """
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_ip_address is not None:
            pulumi.set(__self__, "next_hop_ip_address", next_hop_ip_address)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> str:
        """
        Gets or sets the type of Azure hop the packet should be sent to.
        """
        return pulumi.get(self, "next_hop_type")

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        Gets or sets the destination CIDR to which the route applies.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextHopIpAddress")
    def next_hop_ip_address(self) -> Optional[str]:
        """
        Gets or sets the IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
        """
        return pulumi.get(self, "next_hop_ip_address")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class SecurityRuleResponse(dict):
    """
    Network security rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationAddressPrefix":
            suggest = "destination_address_prefix"
        elif key == "sourceAddressPrefix":
            suggest = "source_address_prefix"
        elif key == "destinationPortRange":
            suggest = "destination_port_range"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "sourcePortRange":
            suggest = "source_port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access: str,
                 destination_address_prefix: str,
                 direction: str,
                 protocol: str,
                 source_address_prefix: str,
                 description: Optional[str] = None,
                 destination_port_range: Optional[str] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 priority: Optional[int] = None,
                 provisioning_state: Optional[str] = None,
                 source_port_range: Optional[str] = None):
        """
        Network security rule
        :param str access: Gets or sets network traffic is allowed or denied. Possible values are 'Allow' and 'Deny'
        :param str destination_address_prefix: Gets or sets destination address prefix. CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. 
        :param str direction: Gets or sets the direction of the rule.InBound or Outbound. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
        :param str protocol: Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*).
        :param str source_address_prefix: Gets or sets source address prefix. CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from. 
        :param str description: Gets or sets a description for this rule. Restricted to 140 chars.
        :param str destination_port_range: Gets or sets Destination Port or Range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param str id: Resource Id
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param int priority: Gets or sets the priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param str provisioning_state: Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        :param str source_port_range: Gets or sets Source Port or Range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "destination_address_prefix", destination_address_prefix)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)

    @property
    @pulumi.getter
    def access(self) -> str:
        """
        Gets or sets network traffic is allowed or denied. Possible values are 'Allow' and 'Deny'
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter(name="destinationAddressPrefix")
    def destination_address_prefix(self) -> str:
        """
        Gets or sets destination address prefix. CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. 
        """
        return pulumi.get(self, "destination_address_prefix")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        Gets or sets the direction of the rule.InBound or Outbound. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*).
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> str:
        """
        Gets or sets source address prefix. CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from. 
        """
        return pulumi.get(self, "source_address_prefix")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Gets or sets a description for this rule. Restricted to 140 chars.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[str]:
        """
        Gets or sets Destination Port or Range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        """
        return pulumi.get(self, "destination_port_range")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Gets or sets the priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[str]:
        """
        Gets or sets Source Port or Range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        """
        return pulumi.get(self, "source_port_range")


@pulumi.output_type
class SubResourceResponse(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        :param str id: Resource Id
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SubnetResponse(dict):
    """
    Subnet in a VirtualNetwork resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "networkSecurityGroup":
            suggest = "network_security_group"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "routeTable":
            suggest = "route_table"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubnetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubnetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubnetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_prefix: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 ip_configurations: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 name: Optional[str] = None,
                 network_security_group: Optional['outputs.SubResourceResponse'] = None,
                 provisioning_state: Optional[str] = None,
                 route_table: Optional['outputs.SubResourceResponse'] = None):
        """
        Subnet in a VirtualNetwork resource
        :param str address_prefix: Gets or sets Address prefix for the subnet.
        :param str etag: A unique read-only string that changes whenever the resource is updated
        :param str id: Resource Id
        :param Sequence['SubResourceResponse'] ip_configurations: Gets array of references to the network interface IP configurations using subnet
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        :param 'SubResourceResponse' network_security_group: Gets or sets the reference of the NetworkSecurityGroup resource
        :param str provisioning_state: Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        :param 'SubResourceResponse' route_table: Gets or sets the reference of the RouteTable resource
        """
        pulumi.set(__self__, "address_prefix", address_prefix)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_security_group is not None:
            pulumi.set(__self__, "network_security_group", network_security_group)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if route_table is not None:
            pulumi.set(__self__, "route_table", route_table)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> str:
        """
        Gets or sets Address prefix for the subnet.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Gets array of references to the network interface IP configurations using subnet
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkSecurityGroup")
    def network_security_group(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets the reference of the NetworkSecurityGroup resource
        """
        return pulumi.get(self, "network_security_group")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="routeTable")
    def route_table(self) -> Optional['outputs.SubResourceResponse']:
        """
        Gets or sets the reference of the RouteTable resource
        """
        return pulumi.get(self, "route_table")


