# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AADProfileArgs',
    'AddonProfilesArgs',
    'AgentPoolExtendedLocationArgs',
    'AgentPoolProvisioningStatusErrorArgs',
    'AgentPoolProvisioningStatusProvisioningStatusArgs',
    'AgentPoolProvisioningStatusStatusArgs',
    'ArcAgentProfileArgs',
    'CloudProviderProfileInfraNetworkProfileArgs',
    'CloudProviderProfileInfraStorageProfileArgs',
    'CloudProviderProfileArgs',
    'ControlPlaneEndpointProfileControlPlaneEndpointArgs',
    'ControlPlaneProfileArgs',
    'HttpProxyConfigArgs',
    'LinuxProfilePropertiesPublicKeysArgs',
    'LinuxProfilePropertiesSshArgs',
    'LinuxProfilePropertiesArgs',
    'LoadBalancerProfileArgs',
    'NamedAgentPoolProfileArgs',
    'NetworkProfileArgs',
    'ProvisionedClusterIdentityArgs',
    'ProvisionedClustersAllPropertiesArgs',
    'ProvisionedClustersCommonPropertiesFeaturesArgs',
    'ProvisionedClustersExtendedLocationArgs',
    'StorageSpacesExtendedLocationArgs',
    'StorageSpacesPropertiesErrorArgs',
    'StorageSpacesPropertiesHciStorageProfileArgs',
    'StorageSpacesPropertiesProvisioningStatusArgs',
    'StorageSpacesPropertiesStatusArgs',
    'StorageSpacesPropertiesVmwareStorageProfileArgs',
    'StorageSpacesPropertiesArgs',
    'VirtualNetworksExtendedLocationArgs',
    'VirtualNetworksPropertiesHciArgs',
    'VirtualNetworksPropertiesInfraVnetProfileArgs',
    'VirtualNetworksPropertiesKubevirtArgs',
    'VirtualNetworksPropertiesVipPoolArgs',
    'VirtualNetworksPropertiesVmipPoolArgs',
    'VirtualNetworksPropertiesVmwareArgs',
    'VirtualNetworksPropertiesArgs',
    'WindowsProfileArgs',
]

@pulumi.input_type
class AADProfileArgs:
    def __init__(__self__, *,
                 admin_group_object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_app_id: Optional[pulumi.Input[str]] = None,
                 enable_azure_rbac: Optional[pulumi.Input[bool]] = None,
                 managed: Optional[pulumi.Input[bool]] = None,
                 server_app_id: Optional[pulumi.Input[str]] = None,
                 server_app_secret: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        AAD Profile specifies attributes for Azure Active Directory integration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admin_group_object_ids: The list of AAD group object IDs that will have admin role of the cluster.
        :param pulumi.Input[str] client_app_id: The client AAD application ID.
        :param pulumi.Input[bool] enable_azure_rbac: Whether to enable Azure RBAC for Kubernetes authorization.
        :param pulumi.Input[bool] managed: Whether to enable managed AAD.
        :param pulumi.Input[str] server_app_id: The server AAD application ID.
        :param pulumi.Input[str] server_app_secret: The server AAD application secret.
        :param pulumi.Input[str] tenant_id: The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
        """
        if admin_group_object_ids is not None:
            pulumi.set(__self__, "admin_group_object_ids", admin_group_object_ids)
        if client_app_id is not None:
            pulumi.set(__self__, "client_app_id", client_app_id)
        if enable_azure_rbac is not None:
            pulumi.set(__self__, "enable_azure_rbac", enable_azure_rbac)
        if managed is not None:
            pulumi.set(__self__, "managed", managed)
        if server_app_id is not None:
            pulumi.set(__self__, "server_app_id", server_app_id)
        if server_app_secret is not None:
            pulumi.set(__self__, "server_app_secret", server_app_secret)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="adminGroupObjectIDs")
    def admin_group_object_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of AAD group object IDs that will have admin role of the cluster.
        """
        return pulumi.get(self, "admin_group_object_ids")

    @admin_group_object_ids.setter
    def admin_group_object_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "admin_group_object_ids", value)

    @property
    @pulumi.getter(name="clientAppID")
    def client_app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client AAD application ID.
        """
        return pulumi.get(self, "client_app_id")

    @client_app_id.setter
    def client_app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_app_id", value)

    @property
    @pulumi.getter(name="enableAzureRbac")
    def enable_azure_rbac(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Azure RBAC for Kubernetes authorization.
        """
        return pulumi.get(self, "enable_azure_rbac")

    @enable_azure_rbac.setter
    def enable_azure_rbac(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_azure_rbac", value)

    @property
    @pulumi.getter
    def managed(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable managed AAD.
        """
        return pulumi.get(self, "managed")

    @managed.setter
    def managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "managed", value)

    @property
    @pulumi.getter(name="serverAppID")
    def server_app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The server AAD application ID.
        """
        return pulumi.get(self, "server_app_id")

    @server_app_id.setter
    def server_app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_app_id", value)

    @property
    @pulumi.getter(name="serverAppSecret")
    def server_app_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The server AAD application secret.
        """
        return pulumi.get(self, "server_app_secret")

    @server_app_secret.setter
    def server_app_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_app_secret", value)

    @property
    @pulumi.getter(name="tenantID")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class AddonProfilesArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Addon configurations
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] config: Config - Key-value pairs for configuring an add-on.
        :param pulumi.Input[bool] enabled: Enabled - Whether the add-on is enabled or not.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Config - Key-value pairs for configuring an add-on.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabled - Whether the add-on is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class AgentPoolExtendedLocationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The extended location name.
        :param pulumi.Input[str] type: The extended location type.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The extended location name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The extended location type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class AgentPoolProvisioningStatusErrorArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None):
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)


@pulumi.input_type
class AgentPoolProvisioningStatusProvisioningStatusArgs:
    def __init__(__self__, *,
                 error: Optional[pulumi.Input['AgentPoolProvisioningStatusErrorArgs']] = None,
                 operation_id: Optional[pulumi.Input[str]] = None,
                 phase: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Contains Provisioning errors
        :param pulumi.Input[str] phase: Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
        """
        if error is not None:
            pulumi.set(__self__, "error", error)
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def error(self) -> Optional[pulumi.Input['AgentPoolProvisioningStatusErrorArgs']]:
        return pulumi.get(self, "error")

    @error.setter
    def error(self, value: Optional[pulumi.Input['AgentPoolProvisioningStatusErrorArgs']]):
        pulumi.set(self, "error", value)

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "operation_id")

    @operation_id.setter
    def operation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation_id", value)

    @property
    @pulumi.getter
    def phase(self) -> Optional[pulumi.Input[str]]:
        """
        Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
        """
        return pulumi.get(self, "phase")

    @phase.setter
    def phase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class AgentPoolProvisioningStatusStatusArgs:
    def __init__(__self__, *,
                 error_message: Optional[pulumi.Input[str]] = None,
                 provisioning_status: Optional[pulumi.Input['AgentPoolProvisioningStatusProvisioningStatusArgs']] = None,
                 ready_replicas: Optional[pulumi.Input[int]] = None,
                 replicas: Optional[pulumi.Input[int]] = None):
        """
        HybridAKSNodePoolStatus defines the observed state of HybridAKSNodePool
        :param pulumi.Input[str] error_message: ErrorMessage - Error messages during creation of cluster
        :param pulumi.Input['AgentPoolProvisioningStatusProvisioningStatusArgs'] provisioning_status: Contains Provisioning errors
        :param pulumi.Input[int] ready_replicas: Total number of ready machines targeted by this deployment.
        :param pulumi.Input[int] replicas: Total number of non-terminated machines targeted by this deployment
        """
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if provisioning_status is not None:
            pulumi.set(__self__, "provisioning_status", provisioning_status)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[pulumi.Input[str]]:
        """
        ErrorMessage - Error messages during creation of cluster
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_message", value)

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> Optional[pulumi.Input['AgentPoolProvisioningStatusProvisioningStatusArgs']]:
        """
        Contains Provisioning errors
        """
        return pulumi.get(self, "provisioning_status")

    @provisioning_status.setter
    def provisioning_status(self, value: Optional[pulumi.Input['AgentPoolProvisioningStatusProvisioningStatusArgs']]):
        pulumi.set(self, "provisioning_status", value)

    @property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        Total number of ready machines targeted by this deployment.
        """
        return pulumi.get(self, "ready_replicas")

    @ready_replicas.setter
    def ready_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ready_replicas", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[int]]:
        """
        Total number of non-terminated machines targeted by this deployment
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replicas", value)


@pulumi.input_type
class ArcAgentProfileArgs:
    def __init__(__self__, *,
                 agent_auto_upgrade: Optional[pulumi.Input[Union[str, 'AutoUpgradeOptions']]] = None,
                 agent_version: Optional[pulumi.Input[str]] = None):
        """
        Defines the Arc Agent properties for the Provisioned clusters.
        :param pulumi.Input[Union[str, 'AutoUpgradeOptions']] agent_auto_upgrade: Indicates whether the Arc agents on the provisioned clusters be upgraded automatically to the latest version. Defaults to Enabled.
        :param pulumi.Input[str] agent_version: Version of the Arc agents to be installed on the provisioned Provisioned cluster resource
        """
        if agent_auto_upgrade is None:
            agent_auto_upgrade = 'Enabled'
        if agent_auto_upgrade is not None:
            pulumi.set(__self__, "agent_auto_upgrade", agent_auto_upgrade)
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)

    @property
    @pulumi.getter(name="agentAutoUpgrade")
    def agent_auto_upgrade(self) -> Optional[pulumi.Input[Union[str, 'AutoUpgradeOptions']]]:
        """
        Indicates whether the Arc agents on the provisioned clusters be upgraded automatically to the latest version. Defaults to Enabled.
        """
        return pulumi.get(self, "agent_auto_upgrade")

    @agent_auto_upgrade.setter
    def agent_auto_upgrade(self, value: Optional[pulumi.Input[Union[str, 'AutoUpgradeOptions']]]):
        pulumi.set(self, "agent_auto_upgrade", value)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the Arc agents to be installed on the provisioned Provisioned cluster resource
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_version", value)


@pulumi.input_type
class CloudProviderProfileInfraNetworkProfileArgs:
    def __init__(__self__, *,
                 vnet_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        InfraNetworkProfile - List of infra network profiles for the provisioned cluster
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vnet_subnet_ids: Array of references to azure resource corresponding to the new HybridAKSNetwork object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/virtualNetworks/{virtualNetworkName}
        """
        if vnet_subnet_ids is not None:
            pulumi.set(__self__, "vnet_subnet_ids", vnet_subnet_ids)

    @property
    @pulumi.getter(name="vnetSubnetIds")
    def vnet_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of references to azure resource corresponding to the new HybridAKSNetwork object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/virtualNetworks/{virtualNetworkName}
        """
        return pulumi.get(self, "vnet_subnet_ids")

    @vnet_subnet_ids.setter
    def vnet_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vnet_subnet_ids", value)


@pulumi.input_type
class CloudProviderProfileInfraStorageProfileArgs:
    def __init__(__self__, *,
                 storage_space_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        InfraStorageProfile - List of infra storage profiles for the provisioned cluster
        :param pulumi.Input[Sequence[pulumi.Input[str]]] storage_space_ids: Reference to azure resource corresponding to the new HybridAKSStorage object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/storageSpaces/{storageSpaceName}
        """
        if storage_space_ids is not None:
            pulumi.set(__self__, "storage_space_ids", storage_space_ids)

    @property
    @pulumi.getter(name="storageSpaceIds")
    def storage_space_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Reference to azure resource corresponding to the new HybridAKSStorage object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/storageSpaces/{storageSpaceName}
        """
        return pulumi.get(self, "storage_space_ids")

    @storage_space_ids.setter
    def storage_space_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "storage_space_ids", value)


@pulumi.input_type
class CloudProviderProfileArgs:
    def __init__(__self__, *,
                 infra_network_profile: Optional[pulumi.Input['CloudProviderProfileInfraNetworkProfileArgs']] = None,
                 infra_storage_profile: Optional[pulumi.Input['CloudProviderProfileInfraStorageProfileArgs']] = None):
        """
        CloudProviderProfile - The underlying cloud infra provider properties.
        :param pulumi.Input['CloudProviderProfileInfraNetworkProfileArgs'] infra_network_profile: InfraNetworkProfile - List of infra network profiles for the provisioned cluster
        :param pulumi.Input['CloudProviderProfileInfraStorageProfileArgs'] infra_storage_profile: InfraStorageProfile - List of infra storage profiles for the provisioned cluster
        """
        if infra_network_profile is not None:
            pulumi.set(__self__, "infra_network_profile", infra_network_profile)
        if infra_storage_profile is not None:
            pulumi.set(__self__, "infra_storage_profile", infra_storage_profile)

    @property
    @pulumi.getter(name="infraNetworkProfile")
    def infra_network_profile(self) -> Optional[pulumi.Input['CloudProviderProfileInfraNetworkProfileArgs']]:
        """
        InfraNetworkProfile - List of infra network profiles for the provisioned cluster
        """
        return pulumi.get(self, "infra_network_profile")

    @infra_network_profile.setter
    def infra_network_profile(self, value: Optional[pulumi.Input['CloudProviderProfileInfraNetworkProfileArgs']]):
        pulumi.set(self, "infra_network_profile", value)

    @property
    @pulumi.getter(name="infraStorageProfile")
    def infra_storage_profile(self) -> Optional[pulumi.Input['CloudProviderProfileInfraStorageProfileArgs']]:
        """
        InfraStorageProfile - List of infra storage profiles for the provisioned cluster
        """
        return pulumi.get(self, "infra_storage_profile")

    @infra_storage_profile.setter
    def infra_storage_profile(self, value: Optional[pulumi.Input['CloudProviderProfileInfraStorageProfileArgs']]):
        pulumi.set(self, "infra_storage_profile", value)


@pulumi.input_type
class ControlPlaneEndpointProfileControlPlaneEndpointArgs:
    def __init__(__self__, *,
                 host_ip: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None):
        """
        API server endpoint for the control plane
        :param pulumi.Input[str] host_ip: Host IP address for API server
        :param pulumi.Input[str] port: Port for the API server
        """
        if host_ip is not None:
            pulumi.set(__self__, "host_ip", host_ip)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="hostIP")
    def host_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Host IP address for API server
        """
        return pulumi.get(self, "host_ip")

    @host_ip.setter
    def host_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_ip", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        Port for the API server
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ControlPlaneProfileArgs:
    def __init__(__self__, *,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_provider_profile: Optional[pulumi.Input['CloudProviderProfileArgs']] = None,
                 control_plane_endpoint: Optional[pulumi.Input['ControlPlaneEndpointProfileControlPlaneEndpointArgs']] = None,
                 count: Optional[pulumi.Input[int]] = None,
                 linux_profile: Optional[pulumi.Input['LinuxProfilePropertiesArgs']] = None,
                 max_count: Optional[pulumi.Input[int]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 min_count: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'Mode']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_image_version: Optional[pulumi.Input[str]] = None,
                 node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_type: Optional[pulumi.Input[Union[str, 'OsType']]] = None,
                 vm_size: Optional[pulumi.Input[str]] = None):
        """
        ControlPlaneProfile - The control plane properties for the provisioned cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
        :param pulumi.Input['CloudProviderProfileArgs'] cloud_provider_profile: The underlying cloud infra provider properties.
        :param pulumi.Input['ControlPlaneEndpointProfileControlPlaneEndpointArgs'] control_plane_endpoint: API server endpoint for the control plane
        :param pulumi.Input[int] count: Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
        :param pulumi.Input['LinuxProfilePropertiesArgs'] linux_profile: Profile for Linux VMs in the container service cluster.
        :param pulumi.Input[int] max_count: The maximum number of nodes for auto-scaling
        :param pulumi.Input[int] max_pods: The maximum number of pods that can run on a node.
        :param pulumi.Input[int] min_count: The minimum number of nodes for auto-scaling
        :param pulumi.Input[Union[str, 'Mode']] mode: Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
        :param pulumi.Input[str] name: Unique name of the agent pool profile in the context of the subscription and resource group.
        :param pulumi.Input[str] node_image_version: The version of node image
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] node_labels: NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_taints: NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
        :param pulumi.Input[Union[str, 'OsType']] os_type: OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
        :param pulumi.Input[str] vm_size: VmSize - The size of the agent pool VMs.
        """
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if cloud_provider_profile is not None:
            pulumi.set(__self__, "cloud_provider_profile", cloud_provider_profile)
        if control_plane_endpoint is not None:
            pulumi.set(__self__, "control_plane_endpoint", control_plane_endpoint)
        if count is None:
            count = 1
        if count is not None:
            pulumi.set(__self__, "count", count)
        if linux_profile is not None:
            pulumi.set(__self__, "linux_profile", linux_profile)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if mode is None:
            mode = 'User'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_image_version is not None:
            pulumi.set(__self__, "node_image_version", node_image_version)
        if node_labels is not None:
            pulumi.set(__self__, "node_labels", node_labels)
        if node_taints is not None:
            pulumi.set(__self__, "node_taints", node_taints)
        if os_type is None:
            os_type = 'Linux'
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="cloudProviderProfile")
    def cloud_provider_profile(self) -> Optional[pulumi.Input['CloudProviderProfileArgs']]:
        """
        The underlying cloud infra provider properties.
        """
        return pulumi.get(self, "cloud_provider_profile")

    @cloud_provider_profile.setter
    def cloud_provider_profile(self, value: Optional[pulumi.Input['CloudProviderProfileArgs']]):
        pulumi.set(self, "cloud_provider_profile", value)

    @property
    @pulumi.getter(name="controlPlaneEndpoint")
    def control_plane_endpoint(self) -> Optional[pulumi.Input['ControlPlaneEndpointProfileControlPlaneEndpointArgs']]:
        """
        API server endpoint for the control plane
        """
        return pulumi.get(self, "control_plane_endpoint")

    @control_plane_endpoint.setter
    def control_plane_endpoint(self, value: Optional[pulumi.Input['ControlPlaneEndpointProfileControlPlaneEndpointArgs']]):
        pulumi.set(self, "control_plane_endpoint", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="linuxProfile")
    def linux_profile(self) -> Optional[pulumi.Input['LinuxProfilePropertiesArgs']]:
        """
        Profile for Linux VMs in the container service cluster.
        """
        return pulumi.get(self, "linux_profile")

    @linux_profile.setter
    def linux_profile(self, value: Optional[pulumi.Input['LinuxProfilePropertiesArgs']]):
        pulumi.set(self, "linux_profile", value)

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes for auto-scaling
        """
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_count", value)

    @property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of pods that can run on a node.
        """
        return pulumi.get(self, "max_pods")

    @max_pods.setter
    def max_pods(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods", value)

    @property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of nodes for auto-scaling
        """
        return pulumi.get(self, "min_count")

    @min_count.setter
    def min_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_count", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'Mode']]]:
        """
        Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'Mode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the agent pool profile in the context of the subscription and resource group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeImageVersion")
    def node_image_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of node image
        """
        return pulumi.get(self, "node_image_version")

    @node_image_version.setter
    def node_image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_image_version", value)

    @property
    @pulumi.getter(name="nodeLabels")
    def node_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
        """
        return pulumi.get(self, "node_labels")

    @node_labels.setter
    def node_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "node_labels", value)

    @property
    @pulumi.getter(name="nodeTaints")
    def node_taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
        """
        return pulumi.get(self, "node_taints")

    @node_taints.setter
    def node_taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_taints", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[Union[str, 'OsType']]]:
        """
        OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[Union[str, 'OsType']]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        VmSize - The size of the agent pool VMs.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_size", value)


@pulumi.input_type
class HttpProxyConfigArgs:
    def __init__(__self__, *,
                 http_proxy: Optional[pulumi.Input[str]] = None,
                 https_proxy: Optional[pulumi.Input[str]] = None,
                 no_proxy: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 trusted_ca: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Configurations for provisioning the cluster with HTTP proxy servers.
        :param pulumi.Input[str] http_proxy: The HTTP proxy server endpoint to use.
        :param pulumi.Input[str] https_proxy: The HTTPS proxy server endpoint to use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] no_proxy: The endpoints that should not go through proxy.
        :param pulumi.Input[str] password: Password to use for connecting to proxy server
        :param pulumi.Input[str] trusted_ca: Alternative CA cert to use for connecting to proxy servers.
        :param pulumi.Input[str] username: Username to use for connecting to proxy server
        """
        if http_proxy is not None:
            pulumi.set(__self__, "http_proxy", http_proxy)
        if https_proxy is not None:
            pulumi.set(__self__, "https_proxy", https_proxy)
        if no_proxy is not None:
            pulumi.set(__self__, "no_proxy", no_proxy)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if trusted_ca is not None:
            pulumi.set(__self__, "trusted_ca", trusted_ca)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="httpProxy")
    def http_proxy(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP proxy server endpoint to use.
        """
        return pulumi.get(self, "http_proxy")

    @http_proxy.setter
    def http_proxy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_proxy", value)

    @property
    @pulumi.getter(name="httpsProxy")
    def https_proxy(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTPS proxy server endpoint to use.
        """
        return pulumi.get(self, "https_proxy")

    @https_proxy.setter
    def https_proxy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "https_proxy", value)

    @property
    @pulumi.getter(name="noProxy")
    def no_proxy(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The endpoints that should not go through proxy.
        """
        return pulumi.get(self, "no_proxy")

    @no_proxy.setter
    def no_proxy(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "no_proxy", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password to use for connecting to proxy server
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="trustedCa")
    def trusted_ca(self) -> Optional[pulumi.Input[str]]:
        """
        Alternative CA cert to use for connecting to proxy servers.
        """
        return pulumi.get(self, "trusted_ca")

    @trusted_ca.setter
    def trusted_ca(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trusted_ca", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username to use for connecting to proxy server
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class LinuxProfilePropertiesPublicKeysArgs:
    def __init__(__self__, *,
                 key_data: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key_data: KeyData - Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
        """
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[pulumi.Input[str]]:
        """
        KeyData - Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
        """
        return pulumi.get(self, "key_data")

    @key_data.setter
    def key_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_data", value)


@pulumi.input_type
class LinuxProfilePropertiesSshArgs:
    def __init__(__self__, *,
                 public_keys: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxProfilePropertiesPublicKeysArgs']]]] = None):
        """
        SSH - SSH configuration for Linux-based VMs running on Azure.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxProfilePropertiesPublicKeysArgs']]] public_keys: PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxProfilePropertiesPublicKeysArgs']]]]:
        """
        PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
        """
        return pulumi.get(self, "public_keys")

    @public_keys.setter
    def public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxProfilePropertiesPublicKeysArgs']]]]):
        pulumi.set(self, "public_keys", value)


@pulumi.input_type
class LinuxProfilePropertiesArgs:
    def __init__(__self__, *,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 ssh: Optional[pulumi.Input['LinuxProfilePropertiesSshArgs']] = None):
        """
        LinuxProfile - Profile for Linux VMs in the container service cluster.
        :param pulumi.Input[str] admin_username: AdminUsername - The administrator username to use for Linux VMs.
        :param pulumi.Input['LinuxProfilePropertiesSshArgs'] ssh: SSH - SSH configuration for Linux-based VMs running on Azure.
        """
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[str]]:
        """
        AdminUsername - The administrator username to use for Linux VMs.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter
    def ssh(self) -> Optional[pulumi.Input['LinuxProfilePropertiesSshArgs']]:
        """
        SSH - SSH configuration for Linux-based VMs running on Azure.
        """
        return pulumi.get(self, "ssh")

    @ssh.setter
    def ssh(self, value: Optional[pulumi.Input['LinuxProfilePropertiesSshArgs']]):
        pulumi.set(self, "ssh", value)


@pulumi.input_type
class LoadBalancerProfileArgs:
    def __init__(__self__, *,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_provider_profile: Optional[pulumi.Input['CloudProviderProfileArgs']] = None,
                 count: Optional[pulumi.Input[int]] = None,
                 linux_profile: Optional[pulumi.Input['LinuxProfilePropertiesArgs']] = None,
                 max_count: Optional[pulumi.Input[int]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 min_count: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'Mode']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_image_version: Optional[pulumi.Input[str]] = None,
                 node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_type: Optional[pulumi.Input[Union[str, 'OsType']]] = None,
                 vm_size: Optional[pulumi.Input[str]] = None):
        """
        LoadBalancerProfile - Profile of the cluster load balancer.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
        :param pulumi.Input['CloudProviderProfileArgs'] cloud_provider_profile: The underlying cloud infra provider properties.
        :param pulumi.Input[int] count: Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
        :param pulumi.Input['LinuxProfilePropertiesArgs'] linux_profile: Profile for Linux VMs in the container service cluster.
        :param pulumi.Input[int] max_count: The maximum number of nodes for auto-scaling
        :param pulumi.Input[int] max_pods: The maximum number of pods that can run on a node.
        :param pulumi.Input[int] min_count: The minimum number of nodes for auto-scaling
        :param pulumi.Input[Union[str, 'Mode']] mode: Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
        :param pulumi.Input[str] name: Unique name of the agent pool profile in the context of the subscription and resource group.
        :param pulumi.Input[str] node_image_version: The version of node image
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] node_labels: NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_taints: NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
        :param pulumi.Input[Union[str, 'OsType']] os_type: OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
        :param pulumi.Input[str] vm_size: VmSize - The size of the agent pool VMs.
        """
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if cloud_provider_profile is not None:
            pulumi.set(__self__, "cloud_provider_profile", cloud_provider_profile)
        if count is None:
            count = 1
        if count is not None:
            pulumi.set(__self__, "count", count)
        if linux_profile is not None:
            pulumi.set(__self__, "linux_profile", linux_profile)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if mode is None:
            mode = 'User'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_image_version is not None:
            pulumi.set(__self__, "node_image_version", node_image_version)
        if node_labels is not None:
            pulumi.set(__self__, "node_labels", node_labels)
        if node_taints is not None:
            pulumi.set(__self__, "node_taints", node_taints)
        if os_type is None:
            os_type = 'Linux'
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="cloudProviderProfile")
    def cloud_provider_profile(self) -> Optional[pulumi.Input['CloudProviderProfileArgs']]:
        """
        The underlying cloud infra provider properties.
        """
        return pulumi.get(self, "cloud_provider_profile")

    @cloud_provider_profile.setter
    def cloud_provider_profile(self, value: Optional[pulumi.Input['CloudProviderProfileArgs']]):
        pulumi.set(self, "cloud_provider_profile", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="linuxProfile")
    def linux_profile(self) -> Optional[pulumi.Input['LinuxProfilePropertiesArgs']]:
        """
        Profile for Linux VMs in the container service cluster.
        """
        return pulumi.get(self, "linux_profile")

    @linux_profile.setter
    def linux_profile(self, value: Optional[pulumi.Input['LinuxProfilePropertiesArgs']]):
        pulumi.set(self, "linux_profile", value)

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes for auto-scaling
        """
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_count", value)

    @property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of pods that can run on a node.
        """
        return pulumi.get(self, "max_pods")

    @max_pods.setter
    def max_pods(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods", value)

    @property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of nodes for auto-scaling
        """
        return pulumi.get(self, "min_count")

    @min_count.setter
    def min_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_count", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'Mode']]]:
        """
        Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'Mode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the agent pool profile in the context of the subscription and resource group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeImageVersion")
    def node_image_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of node image
        """
        return pulumi.get(self, "node_image_version")

    @node_image_version.setter
    def node_image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_image_version", value)

    @property
    @pulumi.getter(name="nodeLabels")
    def node_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
        """
        return pulumi.get(self, "node_labels")

    @node_labels.setter
    def node_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "node_labels", value)

    @property
    @pulumi.getter(name="nodeTaints")
    def node_taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
        """
        return pulumi.get(self, "node_taints")

    @node_taints.setter
    def node_taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_taints", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[Union[str, 'OsType']]]:
        """
        OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[Union[str, 'OsType']]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        VmSize - The size of the agent pool VMs.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_size", value)


@pulumi.input_type
class NamedAgentPoolProfileArgs:
    def __init__(__self__, *,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_provider_profile: Optional[pulumi.Input['CloudProviderProfileArgs']] = None,
                 count: Optional[pulumi.Input[int]] = None,
                 max_count: Optional[pulumi.Input[int]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 min_count: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'Mode']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_image_version: Optional[pulumi.Input[str]] = None,
                 node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_type: Optional[pulumi.Input[Union[str, 'OsType']]] = None,
                 vm_size: Optional[pulumi.Input[str]] = None):
        """
        Agent pool profile along with a name parameter
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
        :param pulumi.Input['CloudProviderProfileArgs'] cloud_provider_profile: The underlying cloud infra provider properties.
        :param pulumi.Input[int] count: Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
        :param pulumi.Input[int] max_count: The maximum number of nodes for auto-scaling
        :param pulumi.Input[int] max_pods: The maximum number of pods that can run on a node.
        :param pulumi.Input[int] min_count: The minimum number of nodes for auto-scaling
        :param pulumi.Input[Union[str, 'Mode']] mode: Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
        :param pulumi.Input[str] name: Unique name of the agent pool profile in the context of the subscription and resource group.
        :param pulumi.Input[str] node_image_version: The version of node image
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] node_labels: NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_taints: NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
        :param pulumi.Input[Union[str, 'OsType']] os_type: OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
        :param pulumi.Input[str] vm_size: VmSize - The size of the agent pool VMs.
        """
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if cloud_provider_profile is not None:
            pulumi.set(__self__, "cloud_provider_profile", cloud_provider_profile)
        if count is None:
            count = 1
        if count is not None:
            pulumi.set(__self__, "count", count)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if mode is None:
            mode = 'User'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_image_version is not None:
            pulumi.set(__self__, "node_image_version", node_image_version)
        if node_labels is not None:
            pulumi.set(__self__, "node_labels", node_labels)
        if node_taints is not None:
            pulumi.set(__self__, "node_taints", node_taints)
        if os_type is None:
            os_type = 'Linux'
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="cloudProviderProfile")
    def cloud_provider_profile(self) -> Optional[pulumi.Input['CloudProviderProfileArgs']]:
        """
        The underlying cloud infra provider properties.
        """
        return pulumi.get(self, "cloud_provider_profile")

    @cloud_provider_profile.setter
    def cloud_provider_profile(self, value: Optional[pulumi.Input['CloudProviderProfileArgs']]):
        pulumi.set(self, "cloud_provider_profile", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes for auto-scaling
        """
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_count", value)

    @property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of pods that can run on a node.
        """
        return pulumi.get(self, "max_pods")

    @max_pods.setter
    def max_pods(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods", value)

    @property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of nodes for auto-scaling
        """
        return pulumi.get(self, "min_count")

    @min_count.setter
    def min_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_count", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'Mode']]]:
        """
        Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'Mode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the agent pool profile in the context of the subscription and resource group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeImageVersion")
    def node_image_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of node image
        """
        return pulumi.get(self, "node_image_version")

    @node_image_version.setter
    def node_image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_image_version", value)

    @property
    @pulumi.getter(name="nodeLabels")
    def node_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
        """
        return pulumi.get(self, "node_labels")

    @node_labels.setter
    def node_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "node_labels", value)

    @property
    @pulumi.getter(name="nodeTaints")
    def node_taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
        """
        return pulumi.get(self, "node_taints")

    @node_taints.setter
    def node_taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_taints", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[Union[str, 'OsType']]]:
        """
        OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[Union[str, 'OsType']]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        VmSize - The size of the agent pool VMs.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_size", value)


@pulumi.input_type
class NetworkProfileArgs:
    def __init__(__self__, *,
                 dns_service_ip: Optional[pulumi.Input[str]] = None,
                 load_balancer_profile: Optional[pulumi.Input['LoadBalancerProfileArgs']] = None,
                 load_balancer_sku: Optional[pulumi.Input[Union[str, 'LoadBalancerSku']]] = None,
                 network_policy: Optional[pulumi.Input[Union[str, 'NetworkPolicy']]] = None,
                 pod_cidr: Optional[pulumi.Input[str]] = None,
                 pod_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 service_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        NetworkProfile - Profile of network configuration.
        :param pulumi.Input[str] dns_service_ip: DNSServiceIP - An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        :param pulumi.Input['LoadBalancerProfileArgs'] load_balancer_profile: LoadBalancerProfile - Profile of the cluster load balancer.
        :param pulumi.Input[Union[str, 'LoadBalancerSku']] load_balancer_sku: LoadBalancerSku - The load balancer sku for the provisioned cluster. Possible values: 'unstacked-haproxy', 'stacked-kube-vip', 'stacked-metallb', 'unmanaged'. The default is 'unmanaged'.
        :param pulumi.Input[Union[str, 'NetworkPolicy']] network_policy: NetworkPolicy - Network policy used for building Kubernetes network. Possible values include: 'calico', 'flannel'. Default is 'calico'
        :param pulumi.Input[str] pod_cidr: PodCidr - A CIDR notation IP range from which to assign pod IPs when kubenet is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_cidrs: The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
        :param pulumi.Input[str] service_cidr: ServiceCidr - A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_cidrs: The CIDR notation IP ranges from which to assign service cluster IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
        """
        if dns_service_ip is not None:
            pulumi.set(__self__, "dns_service_ip", dns_service_ip)
        if load_balancer_profile is not None:
            pulumi.set(__self__, "load_balancer_profile", load_balancer_profile)
        if load_balancer_sku is None:
            load_balancer_sku = 'unmanaged'
        if load_balancer_sku is not None:
            pulumi.set(__self__, "load_balancer_sku", load_balancer_sku)
        if network_policy is None:
            network_policy = 'calico'
        if network_policy is not None:
            pulumi.set(__self__, "network_policy", network_policy)
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if pod_cidrs is not None:
            pulumi.set(__self__, "pod_cidrs", pod_cidrs)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if service_cidrs is not None:
            pulumi.set(__self__, "service_cidrs", service_cidrs)

    @property
    @pulumi.getter(name="dnsServiceIP")
    def dns_service_ip(self) -> Optional[pulumi.Input[str]]:
        """
        DNSServiceIP - An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        """
        return pulumi.get(self, "dns_service_ip")

    @dns_service_ip.setter
    def dns_service_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_service_ip", value)

    @property
    @pulumi.getter(name="loadBalancerProfile")
    def load_balancer_profile(self) -> Optional[pulumi.Input['LoadBalancerProfileArgs']]:
        """
        LoadBalancerProfile - Profile of the cluster load balancer.
        """
        return pulumi.get(self, "load_balancer_profile")

    @load_balancer_profile.setter
    def load_balancer_profile(self, value: Optional[pulumi.Input['LoadBalancerProfileArgs']]):
        pulumi.set(self, "load_balancer_profile", value)

    @property
    @pulumi.getter(name="loadBalancerSku")
    def load_balancer_sku(self) -> Optional[pulumi.Input[Union[str, 'LoadBalancerSku']]]:
        """
        LoadBalancerSku - The load balancer sku for the provisioned cluster. Possible values: 'unstacked-haproxy', 'stacked-kube-vip', 'stacked-metallb', 'unmanaged'. The default is 'unmanaged'.
        """
        return pulumi.get(self, "load_balancer_sku")

    @load_balancer_sku.setter
    def load_balancer_sku(self, value: Optional[pulumi.Input[Union[str, 'LoadBalancerSku']]]):
        pulumi.set(self, "load_balancer_sku", value)

    @property
    @pulumi.getter(name="networkPolicy")
    def network_policy(self) -> Optional[pulumi.Input[Union[str, 'NetworkPolicy']]]:
        """
        NetworkPolicy - Network policy used for building Kubernetes network. Possible values include: 'calico', 'flannel'. Default is 'calico'
        """
        return pulumi.get(self, "network_policy")

    @network_policy.setter
    def network_policy(self, value: Optional[pulumi.Input[Union[str, 'NetworkPolicy']]]):
        pulumi.set(self, "network_policy", value)

    @property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        PodCidr - A CIDR notation IP range from which to assign pod IPs when kubenet is used.
        """
        return pulumi.get(self, "pod_cidr")

    @pod_cidr.setter
    def pod_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_cidr", value)

    @property
    @pulumi.getter(name="podCidrs")
    def pod_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
        """
        return pulumi.get(self, "pod_cidrs")

    @pod_cidrs.setter
    def pod_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pod_cidrs", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        ServiceCidr - A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter(name="serviceCidrs")
    def service_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The CIDR notation IP ranges from which to assign service cluster IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
        """
        return pulumi.get(self, "service_cidrs")

    @service_cidrs.setter
    def service_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_cidrs", value)


@pulumi.input_type
class ProvisionedClusterIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['ResourceIdentityType']):
        """
        Identity for the Provisioned cluster.
        :param pulumi.Input['ResourceIdentityType'] type: The type of identity used for the provisioned cluster. The type SystemAssigned, includes a system created identity. The type None means no identity is assigned to the provisioned cluster.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['ResourceIdentityType']:
        """
        The type of identity used for the provisioned cluster. The type SystemAssigned, includes a system created identity. The type None means no identity is assigned to the provisioned cluster.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['ResourceIdentityType']):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ProvisionedClustersAllPropertiesArgs:
    def __init__(__self__, *,
                 aad_profile: Optional[pulumi.Input['AADProfileArgs']] = None,
                 addon_profiles: Optional[pulumi.Input[Mapping[str, pulumi.Input['AddonProfilesArgs']]]] = None,
                 agent_pool_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['NamedAgentPoolProfileArgs']]]] = None,
                 cloud_provider_profile: Optional[pulumi.Input['CloudProviderProfileArgs']] = None,
                 control_plane: Optional[pulumi.Input['ControlPlaneProfileArgs']] = None,
                 enable_rbac: Optional[pulumi.Input[bool]] = None,
                 features: Optional[pulumi.Input['ProvisionedClustersCommonPropertiesFeaturesArgs']] = None,
                 http_proxy_config: Optional[pulumi.Input['HttpProxyConfigArgs']] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 linux_profile: Optional[pulumi.Input['LinuxProfilePropertiesArgs']] = None,
                 network_profile: Optional[pulumi.Input['NetworkProfileArgs']] = None,
                 node_resource_group: Optional[pulumi.Input[str]] = None,
                 windows_profile: Optional[pulumi.Input['WindowsProfileArgs']] = None):
        """
        All properties of the provisioned cluster
        :param pulumi.Input['AADProfileArgs'] aad_profile: AAD profile for the provisioned cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input['AddonProfilesArgs']]] addon_profiles: AddonProfiles - Profile of managed cluster add-on.
        :param pulumi.Input[Sequence[pulumi.Input['NamedAgentPoolProfileArgs']]] agent_pool_profiles: The agent pools of the cluster.
        :param pulumi.Input['CloudProviderProfileArgs'] cloud_provider_profile: The underlying cloud infra provider properties.
        :param pulumi.Input['ControlPlaneProfileArgs'] control_plane: ControlPlane - ControlPlane Configuration
        :param pulumi.Input[bool] enable_rbac: EnableRBAC - Whether to enable Kubernetes Role-Based Access Control.
        :param pulumi.Input['ProvisionedClustersCommonPropertiesFeaturesArgs'] features: Additional features specs like Arc Agent Onboarding.
        :param pulumi.Input['HttpProxyConfigArgs'] http_proxy_config: HttpProxyConfig - Configurations for provisioning the cluster with HTTP proxy servers.
        :param pulumi.Input[str] kubernetes_version: KubernetesVersion - Version of Kubernetes specified when creating the managed cluster.
        :param pulumi.Input['LinuxProfilePropertiesArgs'] linux_profile: LinuxProfile - The profile for Linux VMs in the Provisioned Cluster.
        :param pulumi.Input['NetworkProfileArgs'] network_profile: NetworkProfile - Profile of network configuration.
        :param pulumi.Input[str] node_resource_group: NodeResourceGroup - Name of the resource group containing agent pool nodes.
        :param pulumi.Input['WindowsProfileArgs'] windows_profile: WindowsProfile - Profile for Windows VMs in the Provisioned Cluster.
        """
        if aad_profile is not None:
            pulumi.set(__self__, "aad_profile", aad_profile)
        if addon_profiles is not None:
            pulumi.set(__self__, "addon_profiles", addon_profiles)
        if agent_pool_profiles is not None:
            pulumi.set(__self__, "agent_pool_profiles", agent_pool_profiles)
        if cloud_provider_profile is not None:
            pulumi.set(__self__, "cloud_provider_profile", cloud_provider_profile)
        if control_plane is not None:
            pulumi.set(__self__, "control_plane", control_plane)
        if enable_rbac is not None:
            pulumi.set(__self__, "enable_rbac", enable_rbac)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if http_proxy_config is not None:
            pulumi.set(__self__, "http_proxy_config", http_proxy_config)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if linux_profile is not None:
            pulumi.set(__self__, "linux_profile", linux_profile)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if node_resource_group is not None:
            pulumi.set(__self__, "node_resource_group", node_resource_group)
        if windows_profile is not None:
            pulumi.set(__self__, "windows_profile", windows_profile)

    @property
    @pulumi.getter(name="aadProfile")
    def aad_profile(self) -> Optional[pulumi.Input['AADProfileArgs']]:
        """
        AAD profile for the provisioned cluster.
        """
        return pulumi.get(self, "aad_profile")

    @aad_profile.setter
    def aad_profile(self, value: Optional[pulumi.Input['AADProfileArgs']]):
        pulumi.set(self, "aad_profile", value)

    @property
    @pulumi.getter(name="addonProfiles")
    def addon_profiles(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['AddonProfilesArgs']]]]:
        """
        AddonProfiles - Profile of managed cluster add-on.
        """
        return pulumi.get(self, "addon_profiles")

    @addon_profiles.setter
    def addon_profiles(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['AddonProfilesArgs']]]]):
        pulumi.set(self, "addon_profiles", value)

    @property
    @pulumi.getter(name="agentPoolProfiles")
    def agent_pool_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamedAgentPoolProfileArgs']]]]:
        """
        The agent pools of the cluster.
        """
        return pulumi.get(self, "agent_pool_profiles")

    @agent_pool_profiles.setter
    def agent_pool_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamedAgentPoolProfileArgs']]]]):
        pulumi.set(self, "agent_pool_profiles", value)

    @property
    @pulumi.getter(name="cloudProviderProfile")
    def cloud_provider_profile(self) -> Optional[pulumi.Input['CloudProviderProfileArgs']]:
        """
        The underlying cloud infra provider properties.
        """
        return pulumi.get(self, "cloud_provider_profile")

    @cloud_provider_profile.setter
    def cloud_provider_profile(self, value: Optional[pulumi.Input['CloudProviderProfileArgs']]):
        pulumi.set(self, "cloud_provider_profile", value)

    @property
    @pulumi.getter(name="controlPlane")
    def control_plane(self) -> Optional[pulumi.Input['ControlPlaneProfileArgs']]:
        """
        ControlPlane - ControlPlane Configuration
        """
        return pulumi.get(self, "control_plane")

    @control_plane.setter
    def control_plane(self, value: Optional[pulumi.Input['ControlPlaneProfileArgs']]):
        pulumi.set(self, "control_plane", value)

    @property
    @pulumi.getter(name="enableRbac")
    def enable_rbac(self) -> Optional[pulumi.Input[bool]]:
        """
        EnableRBAC - Whether to enable Kubernetes Role-Based Access Control.
        """
        return pulumi.get(self, "enable_rbac")

    @enable_rbac.setter
    def enable_rbac(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_rbac", value)

    @property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input['ProvisionedClustersCommonPropertiesFeaturesArgs']]:
        """
        Additional features specs like Arc Agent Onboarding.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input['ProvisionedClustersCommonPropertiesFeaturesArgs']]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter(name="httpProxyConfig")
    def http_proxy_config(self) -> Optional[pulumi.Input['HttpProxyConfigArgs']]:
        """
        HttpProxyConfig - Configurations for provisioning the cluster with HTTP proxy servers.
        """
        return pulumi.get(self, "http_proxy_config")

    @http_proxy_config.setter
    def http_proxy_config(self, value: Optional[pulumi.Input['HttpProxyConfigArgs']]):
        pulumi.set(self, "http_proxy_config", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[str]]:
        """
        KubernetesVersion - Version of Kubernetes specified when creating the managed cluster.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter(name="linuxProfile")
    def linux_profile(self) -> Optional[pulumi.Input['LinuxProfilePropertiesArgs']]:
        """
        LinuxProfile - The profile for Linux VMs in the Provisioned Cluster.
        """
        return pulumi.get(self, "linux_profile")

    @linux_profile.setter
    def linux_profile(self, value: Optional[pulumi.Input['LinuxProfilePropertiesArgs']]):
        pulumi.set(self, "linux_profile", value)

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input['NetworkProfileArgs']]:
        """
        NetworkProfile - Profile of network configuration.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input['NetworkProfileArgs']]):
        pulumi.set(self, "network_profile", value)

    @property
    @pulumi.getter(name="nodeResourceGroup")
    def node_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        NodeResourceGroup - Name of the resource group containing agent pool nodes.
        """
        return pulumi.get(self, "node_resource_group")

    @node_resource_group.setter
    def node_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_resource_group", value)

    @property
    @pulumi.getter(name="windowsProfile")
    def windows_profile(self) -> Optional[pulumi.Input['WindowsProfileArgs']]:
        """
        WindowsProfile - Profile for Windows VMs in the Provisioned Cluster.
        """
        return pulumi.get(self, "windows_profile")

    @windows_profile.setter
    def windows_profile(self, value: Optional[pulumi.Input['WindowsProfileArgs']]):
        pulumi.set(self, "windows_profile", value)


@pulumi.input_type
class ProvisionedClustersCommonPropertiesFeaturesArgs:
    def __init__(__self__, *,
                 arc_agent_profile: Optional[pulumi.Input['ArcAgentProfileArgs']] = None):
        """
        Additional features specs like Arc Agent Onboarding.
        :param pulumi.Input['ArcAgentProfileArgs'] arc_agent_profile: Arc agentry configuration for the provisioned cluster.
        """
        if arc_agent_profile is not None:
            pulumi.set(__self__, "arc_agent_profile", arc_agent_profile)

    @property
    @pulumi.getter(name="arcAgentProfile")
    def arc_agent_profile(self) -> Optional[pulumi.Input['ArcAgentProfileArgs']]:
        """
        Arc agentry configuration for the provisioned cluster.
        """
        return pulumi.get(self, "arc_agent_profile")

    @arc_agent_profile.setter
    def arc_agent_profile(self, value: Optional[pulumi.Input['ArcAgentProfileArgs']]):
        pulumi.set(self, "arc_agent_profile", value)


@pulumi.input_type
class ProvisionedClustersExtendedLocationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The extended location name.
        :param pulumi.Input[str] type: The extended location type.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The extended location name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The extended location type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class StorageSpacesExtendedLocationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The extended location name.
        :param pulumi.Input[str] type: The extended location type.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The extended location name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The extended location type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class StorageSpacesPropertiesErrorArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None):
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)


@pulumi.input_type
class StorageSpacesPropertiesHciStorageProfileArgs:
    def __init__(__self__, *,
                 moc_group: Optional[pulumi.Input[str]] = None,
                 moc_location: Optional[pulumi.Input[str]] = None,
                 moc_storage_container: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] moc_group: Resource group in MOC(Microsoft On-premises Cloud)
        :param pulumi.Input[str] moc_location: Location in MOC(Microsoft On-premises Cloud)
        :param pulumi.Input[str] moc_storage_container: Name of the storage container in MOC(Microsoft On-premises Cloud)
        """
        if moc_group is not None:
            pulumi.set(__self__, "moc_group", moc_group)
        if moc_location is not None:
            pulumi.set(__self__, "moc_location", moc_location)
        if moc_storage_container is not None:
            pulumi.set(__self__, "moc_storage_container", moc_storage_container)

    @property
    @pulumi.getter(name="mocGroup")
    def moc_group(self) -> Optional[pulumi.Input[str]]:
        """
        Resource group in MOC(Microsoft On-premises Cloud)
        """
        return pulumi.get(self, "moc_group")

    @moc_group.setter
    def moc_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "moc_group", value)

    @property
    @pulumi.getter(name="mocLocation")
    def moc_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location in MOC(Microsoft On-premises Cloud)
        """
        return pulumi.get(self, "moc_location")

    @moc_location.setter
    def moc_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "moc_location", value)

    @property
    @pulumi.getter(name="mocStorageContainer")
    def moc_storage_container(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the storage container in MOC(Microsoft On-premises Cloud)
        """
        return pulumi.get(self, "moc_storage_container")

    @moc_storage_container.setter
    def moc_storage_container(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "moc_storage_container", value)


@pulumi.input_type
class StorageSpacesPropertiesProvisioningStatusArgs:
    def __init__(__self__, *,
                 error: Optional[pulumi.Input['StorageSpacesPropertiesErrorArgs']] = None,
                 operation_id: Optional[pulumi.Input[str]] = None,
                 phase: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Contains Provisioning errors
        :param pulumi.Input[str] phase: Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
        """
        if error is not None:
            pulumi.set(__self__, "error", error)
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def error(self) -> Optional[pulumi.Input['StorageSpacesPropertiesErrorArgs']]:
        return pulumi.get(self, "error")

    @error.setter
    def error(self, value: Optional[pulumi.Input['StorageSpacesPropertiesErrorArgs']]):
        pulumi.set(self, "error", value)

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "operation_id")

    @operation_id.setter
    def operation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation_id", value)

    @property
    @pulumi.getter
    def phase(self) -> Optional[pulumi.Input[str]]:
        """
        Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
        """
        return pulumi.get(self, "phase")

    @phase.setter
    def phase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class StorageSpacesPropertiesStatusArgs:
    def __init__(__self__, *,
                 provisioning_status: Optional[pulumi.Input['StorageSpacesPropertiesProvisioningStatusArgs']] = None):
        """
        HybridAKSStorageStatus defines the observed state of HybridAKSStorage
        :param pulumi.Input['StorageSpacesPropertiesProvisioningStatusArgs'] provisioning_status: Contains Provisioning errors
        """
        if provisioning_status is not None:
            pulumi.set(__self__, "provisioning_status", provisioning_status)

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> Optional[pulumi.Input['StorageSpacesPropertiesProvisioningStatusArgs']]:
        """
        Contains Provisioning errors
        """
        return pulumi.get(self, "provisioning_status")

    @provisioning_status.setter
    def provisioning_status(self, value: Optional[pulumi.Input['StorageSpacesPropertiesProvisioningStatusArgs']]):
        pulumi.set(self, "provisioning_status", value)


@pulumi.input_type
class StorageSpacesPropertiesVmwareStorageProfileArgs:
    def __init__(__self__, *,
                 datacenter: Optional[pulumi.Input[str]] = None,
                 datastore: Optional[pulumi.Input[str]] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 resource_pool: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] datacenter: Name of the datacenter in VSphere
        :param pulumi.Input[str] datastore: Name of the datastore in VSphere
        :param pulumi.Input[str] folder: Name of the folder in VSphere
        :param pulumi.Input[str] resource_pool: Name of the resource pool in VSphere
        """
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if datastore is not None:
            pulumi.set(__self__, "datastore", datastore)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if resource_pool is not None:
            pulumi.set(__self__, "resource_pool", resource_pool)

    @property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the datacenter in VSphere
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datacenter", value)

    @property
    @pulumi.getter
    def datastore(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the datastore in VSphere
        """
        return pulumi.get(self, "datastore")

    @datastore.setter
    def datastore(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datastore", value)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the folder in VSphere
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter(name="resourcePool")
    def resource_pool(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource pool in VSphere
        """
        return pulumi.get(self, "resource_pool")

    @resource_pool.setter
    def resource_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_pool", value)


@pulumi.input_type
class StorageSpacesPropertiesArgs:
    def __init__(__self__, *,
                 hci_storage_profile: Optional[pulumi.Input['StorageSpacesPropertiesHciStorageProfileArgs']] = None,
                 status: Optional[pulumi.Input['StorageSpacesPropertiesStatusArgs']] = None,
                 vmware_storage_profile: Optional[pulumi.Input['StorageSpacesPropertiesVmwareStorageProfileArgs']] = None):
        """
        HybridAKSStorageSpec defines the desired state of HybridAKSStorage
        :param pulumi.Input['StorageSpacesPropertiesStatusArgs'] status: HybridAKSStorageStatus defines the observed state of HybridAKSStorage
        """
        if hci_storage_profile is not None:
            pulumi.set(__self__, "hci_storage_profile", hci_storage_profile)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vmware_storage_profile is not None:
            pulumi.set(__self__, "vmware_storage_profile", vmware_storage_profile)

    @property
    @pulumi.getter(name="hciStorageProfile")
    def hci_storage_profile(self) -> Optional[pulumi.Input['StorageSpacesPropertiesHciStorageProfileArgs']]:
        return pulumi.get(self, "hci_storage_profile")

    @hci_storage_profile.setter
    def hci_storage_profile(self, value: Optional[pulumi.Input['StorageSpacesPropertiesHciStorageProfileArgs']]):
        pulumi.set(self, "hci_storage_profile", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['StorageSpacesPropertiesStatusArgs']]:
        """
        HybridAKSStorageStatus defines the observed state of HybridAKSStorage
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['StorageSpacesPropertiesStatusArgs']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="vmwareStorageProfile")
    def vmware_storage_profile(self) -> Optional[pulumi.Input['StorageSpacesPropertiesVmwareStorageProfileArgs']]:
        return pulumi.get(self, "vmware_storage_profile")

    @vmware_storage_profile.setter
    def vmware_storage_profile(self, value: Optional[pulumi.Input['StorageSpacesPropertiesVmwareStorageProfileArgs']]):
        pulumi.set(self, "vmware_storage_profile", value)


@pulumi.input_type
class VirtualNetworksExtendedLocationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The extended location name.
        :param pulumi.Input[str] type: The extended location type.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The extended location name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The extended location type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class VirtualNetworksPropertiesHciArgs:
    def __init__(__self__, *,
                 moc_group: Optional[pulumi.Input[str]] = None,
                 moc_location: Optional[pulumi.Input[str]] = None,
                 moc_vnet_name: Optional[pulumi.Input[str]] = None):
        """
        Infra network profile for HCI platform
        :param pulumi.Input[str] moc_group: Resource group in MOC(Microsoft On-premises Cloud)
        :param pulumi.Input[str] moc_location: Location in MOC(Microsoft On-premises Cloud)
        :param pulumi.Input[str] moc_vnet_name: Virtual Network name in MOC(Microsoft On-premises Cloud)
        """
        if moc_group is not None:
            pulumi.set(__self__, "moc_group", moc_group)
        if moc_location is not None:
            pulumi.set(__self__, "moc_location", moc_location)
        if moc_vnet_name is not None:
            pulumi.set(__self__, "moc_vnet_name", moc_vnet_name)

    @property
    @pulumi.getter(name="mocGroup")
    def moc_group(self) -> Optional[pulumi.Input[str]]:
        """
        Resource group in MOC(Microsoft On-premises Cloud)
        """
        return pulumi.get(self, "moc_group")

    @moc_group.setter
    def moc_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "moc_group", value)

    @property
    @pulumi.getter(name="mocLocation")
    def moc_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location in MOC(Microsoft On-premises Cloud)
        """
        return pulumi.get(self, "moc_location")

    @moc_location.setter
    def moc_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "moc_location", value)

    @property
    @pulumi.getter(name="mocVnetName")
    def moc_vnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Network name in MOC(Microsoft On-premises Cloud)
        """
        return pulumi.get(self, "moc_vnet_name")

    @moc_vnet_name.setter
    def moc_vnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "moc_vnet_name", value)


@pulumi.input_type
class VirtualNetworksPropertiesInfraVnetProfileArgs:
    def __init__(__self__, *,
                 hci: Optional[pulumi.Input['VirtualNetworksPropertiesHciArgs']] = None,
                 kubevirt: Optional[pulumi.Input['VirtualNetworksPropertiesKubevirtArgs']] = None,
                 vmware: Optional[pulumi.Input['VirtualNetworksPropertiesVmwareArgs']] = None):
        """
        :param pulumi.Input['VirtualNetworksPropertiesHciArgs'] hci: Infra network profile for HCI platform
        :param pulumi.Input['VirtualNetworksPropertiesKubevirtArgs'] kubevirt: Infra network profile for KubeVirt platform
        :param pulumi.Input['VirtualNetworksPropertiesVmwareArgs'] vmware: Infra network profile for VMware platform
        """
        if hci is not None:
            pulumi.set(__self__, "hci", hci)
        if kubevirt is not None:
            pulumi.set(__self__, "kubevirt", kubevirt)
        if vmware is not None:
            pulumi.set(__self__, "vmware", vmware)

    @property
    @pulumi.getter
    def hci(self) -> Optional[pulumi.Input['VirtualNetworksPropertiesHciArgs']]:
        """
        Infra network profile for HCI platform
        """
        return pulumi.get(self, "hci")

    @hci.setter
    def hci(self, value: Optional[pulumi.Input['VirtualNetworksPropertiesHciArgs']]):
        pulumi.set(self, "hci", value)

    @property
    @pulumi.getter
    def kubevirt(self) -> Optional[pulumi.Input['VirtualNetworksPropertiesKubevirtArgs']]:
        """
        Infra network profile for KubeVirt platform
        """
        return pulumi.get(self, "kubevirt")

    @kubevirt.setter
    def kubevirt(self, value: Optional[pulumi.Input['VirtualNetworksPropertiesKubevirtArgs']]):
        pulumi.set(self, "kubevirt", value)

    @property
    @pulumi.getter
    def vmware(self) -> Optional[pulumi.Input['VirtualNetworksPropertiesVmwareArgs']]:
        """
        Infra network profile for VMware platform
        """
        return pulumi.get(self, "vmware")

    @vmware.setter
    def vmware(self, value: Optional[pulumi.Input['VirtualNetworksPropertiesVmwareArgs']]):
        pulumi.set(self, "vmware", value)


@pulumi.input_type
class VirtualNetworksPropertiesKubevirtArgs:
    def __init__(__self__, *,
                 vnet_name: Optional[pulumi.Input[str]] = None):
        """
        Infra network profile for KubeVirt platform
        :param pulumi.Input[str] vnet_name: Name of the network in KubeVirt
        """
        if vnet_name is not None:
            pulumi.set(__self__, "vnet_name", vnet_name)

    @property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the network in KubeVirt
        """
        return pulumi.get(self, "vnet_name")

    @vnet_name.setter
    def vnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnet_name", value)


@pulumi.input_type
class VirtualNetworksPropertiesVipPoolArgs:
    def __init__(__self__, *,
                 end_ip: Optional[pulumi.Input[str]] = None,
                 start_ip: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] end_ip: Ending IP address for the IP Pool
        :param pulumi.Input[str] start_ip: Starting IP address for the IP Pool
        """
        if end_ip is not None:
            pulumi.set(__self__, "end_ip", end_ip)
        if start_ip is not None:
            pulumi.set(__self__, "start_ip", start_ip)

    @property
    @pulumi.getter(name="endIP")
    def end_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Ending IP address for the IP Pool
        """
        return pulumi.get(self, "end_ip")

    @end_ip.setter
    def end_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_ip", value)

    @property
    @pulumi.getter(name="startIP")
    def start_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Starting IP address for the IP Pool
        """
        return pulumi.get(self, "start_ip")

    @start_ip.setter
    def start_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_ip", value)


@pulumi.input_type
class VirtualNetworksPropertiesVmipPoolArgs:
    def __init__(__self__, *,
                 end_ip: Optional[pulumi.Input[str]] = None,
                 start_ip: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] end_ip: Ending IP address for the IP Pool
        :param pulumi.Input[str] start_ip: Starting IP address for the IP Pool
        """
        if end_ip is not None:
            pulumi.set(__self__, "end_ip", end_ip)
        if start_ip is not None:
            pulumi.set(__self__, "start_ip", start_ip)

    @property
    @pulumi.getter(name="endIP")
    def end_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Ending IP address for the IP Pool
        """
        return pulumi.get(self, "end_ip")

    @end_ip.setter
    def end_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_ip", value)

    @property
    @pulumi.getter(name="startIP")
    def start_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Starting IP address for the IP Pool
        """
        return pulumi.get(self, "start_ip")

    @start_ip.setter
    def start_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_ip", value)


@pulumi.input_type
class VirtualNetworksPropertiesVmwareArgs:
    def __init__(__self__, *,
                 segment_name: Optional[pulumi.Input[str]] = None):
        """
        Infra network profile for VMware platform
        :param pulumi.Input[str] segment_name: Name of the network segment in VSphere
        """
        if segment_name is not None:
            pulumi.set(__self__, "segment_name", segment_name)

    @property
    @pulumi.getter(name="segmentName")
    def segment_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the network segment in VSphere
        """
        return pulumi.get(self, "segment_name")

    @segment_name.setter
    def segment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "segment_name", value)


@pulumi.input_type
class VirtualNetworksPropertiesArgs:
    def __init__(__self__, *,
                 infra_vnet_profile: Optional[pulumi.Input['VirtualNetworksPropertiesInfraVnetProfileArgs']] = None,
                 vip_pool: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworksPropertiesVipPoolArgs']]]] = None,
                 vmip_pool: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworksPropertiesVmipPoolArgs']]]] = None):
        """
        HybridAKSNetworkSpec defines the desired state of HybridAKSNetwork
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworksPropertiesVipPoolArgs']]] vip_pool: Virtual IP Pool for Kubernetes
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworksPropertiesVmipPoolArgs']]] vmip_pool: IP Pool for Virtual Machines
        """
        if infra_vnet_profile is not None:
            pulumi.set(__self__, "infra_vnet_profile", infra_vnet_profile)
        if vip_pool is not None:
            pulumi.set(__self__, "vip_pool", vip_pool)
        if vmip_pool is not None:
            pulumi.set(__self__, "vmip_pool", vmip_pool)

    @property
    @pulumi.getter(name="infraVnetProfile")
    def infra_vnet_profile(self) -> Optional[pulumi.Input['VirtualNetworksPropertiesInfraVnetProfileArgs']]:
        return pulumi.get(self, "infra_vnet_profile")

    @infra_vnet_profile.setter
    def infra_vnet_profile(self, value: Optional[pulumi.Input['VirtualNetworksPropertiesInfraVnetProfileArgs']]):
        pulumi.set(self, "infra_vnet_profile", value)

    @property
    @pulumi.getter(name="vipPool")
    def vip_pool(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworksPropertiesVipPoolArgs']]]]:
        """
        Virtual IP Pool for Kubernetes
        """
        return pulumi.get(self, "vip_pool")

    @vip_pool.setter
    def vip_pool(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworksPropertiesVipPoolArgs']]]]):
        pulumi.set(self, "vip_pool", value)

    @property
    @pulumi.getter(name="vmipPool")
    def vmip_pool(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworksPropertiesVmipPoolArgs']]]]:
        """
        IP Pool for Virtual Machines
        """
        return pulumi.get(self, "vmip_pool")

    @vmip_pool.setter
    def vmip_pool(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworksPropertiesVmipPoolArgs']]]]):
        pulumi.set(self, "vmip_pool", value)


@pulumi.input_type
class WindowsProfileArgs:
    def __init__(__self__, *,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 enable_csi_proxy: Optional[pulumi.Input[bool]] = None,
                 license_type: Optional[pulumi.Input[Union[str, 'LicenseType']]] = None):
        """
        WindowsProfile - Profile for Windows VMs in the container service cluster.
        :param pulumi.Input[str] admin_password: AdminPassword - Specifies the password of the administrator account. <br><br> **Minimum-length:** 8 characters <br><br> **Max-length:** 123 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
        :param pulumi.Input[str] admin_username: AdminUsername - Specifies the name of the administrator account. <br><br> **restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length:** 1 character <br><br> **Max-length:** 20 characters
        :param pulumi.Input[bool] enable_csi_proxy: EnableCSIProxy - Whether to enable CSI proxy.
        :param pulumi.Input[Union[str, 'LicenseType']] license_type: LicenseType - The licenseType to use for Windows VMs. Windows_Server is used to enable Azure Hybrid User Benefits for Windows VMs. Possible values include: 'None', 'Windows_Server'
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if enable_csi_proxy is not None:
            pulumi.set(__self__, "enable_csi_proxy", enable_csi_proxy)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        AdminPassword - Specifies the password of the administrator account. <br><br> **Minimum-length:** 8 characters <br><br> **Max-length:** 123 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[str]]:
        """
        AdminUsername - Specifies the name of the administrator account. <br><br> **restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length:** 1 character <br><br> **Max-length:** 20 characters
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="enableCsiProxy")
    def enable_csi_proxy(self) -> Optional[pulumi.Input[bool]]:
        """
        EnableCSIProxy - Whether to enable CSI proxy.
        """
        return pulumi.get(self, "enable_csi_proxy")

    @enable_csi_proxy.setter
    def enable_csi_proxy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_csi_proxy", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[Union[str, 'LicenseType']]]:
        """
        LicenseType - The licenseType to use for Windows VMs. Windows_Server is used to enable Azure Hybrid User Benefits for Windows VMs. Possible values include: 'None', 'Windows_Server'
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[Union[str, 'LicenseType']]]):
        pulumi.set(self, "license_type", value)


