# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'CaptureDescriptionArgs',
    'ClusterSkuArgs',
    'ConnectionStateArgs',
    'DestinationArgs',
    'EncryptionArgs',
    'IdentityArgs',
    'KeyVaultPropertiesArgs',
    'NWRuleSetIpRulesArgs',
    'NWRuleSetVirtualNetworkRulesArgs',
    'PrivateEndpointConnectionArgs',
    'PrivateEndpointArgs',
    'RetentionDescriptionArgs',
    'SkuArgs',
    'SubnetArgs',
    'ThrottlingPolicyArgs',
    'UserAssignedIdentityPropertiesArgs',
]

@pulumi.input_type
class CaptureDescriptionArgs:
    def __init__(__self__, *,
                 destination: Optional[pulumi.Input['DestinationArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 encoding: Optional[pulumi.Input['EncodingCaptureDescription']] = None,
                 interval_in_seconds: Optional[pulumi.Input[int]] = None,
                 size_limit_in_bytes: Optional[pulumi.Input[int]] = None,
                 skip_empty_archives: Optional[pulumi.Input[bool]] = None):
        """
        Properties to configure capture description for eventhub
        :param pulumi.Input['DestinationArgs'] destination: Properties of Destination where capture will be stored. (Storage Account, Blob Names)
        :param pulumi.Input[bool] enabled: A value that indicates whether capture description is enabled. 
        :param pulumi.Input['EncodingCaptureDescription'] encoding: Enumerates the possible values for the encoding format of capture description. Note: 'AvroDeflate' will be deprecated in New API Version
        :param pulumi.Input[int] interval_in_seconds: The time window allows you to set the frequency with which the capture to Azure Blobs will happen, value should between 60 to 900 seconds
        :param pulumi.Input[int] size_limit_in_bytes: The size window defines the amount of data built up in your Event Hub before an capture operation, value should be between 10485760 to 524288000 bytes
        :param pulumi.Input[bool] skip_empty_archives: A value that indicates whether to Skip Empty Archives
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if size_limit_in_bytes is not None:
            pulumi.set(__self__, "size_limit_in_bytes", size_limit_in_bytes)
        if skip_empty_archives is not None:
            pulumi.set(__self__, "skip_empty_archives", skip_empty_archives)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['DestinationArgs']]:
        """
        Properties of Destination where capture will be stored. (Storage Account, Blob Names)
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['DestinationArgs']]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        A value that indicates whether capture description is enabled. 
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input['EncodingCaptureDescription']]:
        """
        Enumerates the possible values for the encoding format of capture description. Note: 'AvroDeflate' will be deprecated in New API Version
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input['EncodingCaptureDescription']]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The time window allows you to set the frequency with which the capture to Azure Blobs will happen, value should between 60 to 900 seconds
        """
        return pulumi.get(self, "interval_in_seconds")

    @interval_in_seconds.setter
    def interval_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval_in_seconds", value)

    @property
    @pulumi.getter(name="sizeLimitInBytes")
    def size_limit_in_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The size window defines the amount of data built up in your Event Hub before an capture operation, value should be between 10485760 to 524288000 bytes
        """
        return pulumi.get(self, "size_limit_in_bytes")

    @size_limit_in_bytes.setter
    def size_limit_in_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_limit_in_bytes", value)

    @property
    @pulumi.getter(name="skipEmptyArchives")
    def skip_empty_archives(self) -> Optional[pulumi.Input[bool]]:
        """
        A value that indicates whether to Skip Empty Archives
        """
        return pulumi.get(self, "skip_empty_archives")

    @skip_empty_archives.setter
    def skip_empty_archives(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_empty_archives", value)


@pulumi.input_type
class ClusterSkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'ClusterSkuName']],
                 capacity: Optional[pulumi.Input[int]] = None):
        """
        SKU parameters particular to a cluster instance.
        :param pulumi.Input[Union[str, 'ClusterSkuName']] name: Name of this SKU.
        :param pulumi.Input[int] capacity: The quantity of Event Hubs Cluster Capacity Units contained in this cluster.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'ClusterSkuName']]:
        """
        Name of this SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'ClusterSkuName']]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The quantity of Event Hubs Cluster Capacity Units contained in this cluster.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)


@pulumi.input_type
class ConnectionStateArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateLinkConnectionStatus']]] = None):
        """
        ConnectionState information.
        :param pulumi.Input[str] description: Description of the connection state.
        :param pulumi.Input[Union[str, 'PrivateLinkConnectionStatus']] status: Status of the connection.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the connection state.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateLinkConnectionStatus']]]:
        """
        Status of the connection.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateLinkConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class DestinationArgs:
    def __init__(__self__, *,
                 archive_name_format: Optional[pulumi.Input[str]] = None,
                 blob_container: Optional[pulumi.Input[str]] = None,
                 data_lake_account_name: Optional[pulumi.Input[str]] = None,
                 data_lake_folder_path: Optional[pulumi.Input[str]] = None,
                 data_lake_subscription_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 storage_account_resource_id: Optional[pulumi.Input[str]] = None):
        """
        Capture storage details for capture description
        :param pulumi.Input[str] archive_name_format: Blob naming convention for archive, e.g. {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order
        :param pulumi.Input[str] blob_container: Blob container Name
        :param pulumi.Input[str] data_lake_account_name: The Azure Data Lake Store name for the captured events
        :param pulumi.Input[str] data_lake_folder_path: The destination folder path for the captured events
        :param pulumi.Input[str] data_lake_subscription_id: Subscription Id of Azure Data Lake Store
        :param pulumi.Input[str] name: Name for capture destination
        :param pulumi.Input[str] storage_account_resource_id: Resource id of the storage account to be used to create the blobs
        """
        if archive_name_format is not None:
            pulumi.set(__self__, "archive_name_format", archive_name_format)
        if blob_container is not None:
            pulumi.set(__self__, "blob_container", blob_container)
        if data_lake_account_name is not None:
            pulumi.set(__self__, "data_lake_account_name", data_lake_account_name)
        if data_lake_folder_path is not None:
            pulumi.set(__self__, "data_lake_folder_path", data_lake_folder_path)
        if data_lake_subscription_id is not None:
            pulumi.set(__self__, "data_lake_subscription_id", data_lake_subscription_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_account_resource_id is not None:
            pulumi.set(__self__, "storage_account_resource_id", storage_account_resource_id)

    @property
    @pulumi.getter(name="archiveNameFormat")
    def archive_name_format(self) -> Optional[pulumi.Input[str]]:
        """
        Blob naming convention for archive, e.g. {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order
        """
        return pulumi.get(self, "archive_name_format")

    @archive_name_format.setter
    def archive_name_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "archive_name_format", value)

    @property
    @pulumi.getter(name="blobContainer")
    def blob_container(self) -> Optional[pulumi.Input[str]]:
        """
        Blob container Name
        """
        return pulumi.get(self, "blob_container")

    @blob_container.setter
    def blob_container(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "blob_container", value)

    @property
    @pulumi.getter(name="dataLakeAccountName")
    def data_lake_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Data Lake Store name for the captured events
        """
        return pulumi.get(self, "data_lake_account_name")

    @data_lake_account_name.setter
    def data_lake_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_lake_account_name", value)

    @property
    @pulumi.getter(name="dataLakeFolderPath")
    def data_lake_folder_path(self) -> Optional[pulumi.Input[str]]:
        """
        The destination folder path for the captured events
        """
        return pulumi.get(self, "data_lake_folder_path")

    @data_lake_folder_path.setter
    def data_lake_folder_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_lake_folder_path", value)

    @property
    @pulumi.getter(name="dataLakeSubscriptionId")
    def data_lake_subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Subscription Id of Azure Data Lake Store
        """
        return pulumi.get(self, "data_lake_subscription_id")

    @data_lake_subscription_id.setter
    def data_lake_subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_lake_subscription_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for capture destination
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="storageAccountResourceId")
    def storage_account_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource id of the storage account to be used to create the blobs
        """
        return pulumi.get(self, "storage_account_resource_id")

    @storage_account_resource_id.setter
    def storage_account_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_resource_id", value)


@pulumi.input_type
class EncryptionArgs:
    def __init__(__self__, *,
                 key_source: Optional[pulumi.Input['KeySource']] = None,
                 key_vault_properties: Optional[pulumi.Input[Sequence[pulumi.Input['KeyVaultPropertiesArgs']]]] = None,
                 require_infrastructure_encryption: Optional[pulumi.Input[bool]] = None):
        """
        Properties to configure Encryption
        :param pulumi.Input['KeySource'] key_source: Enumerates the possible value of keySource for Encryption
        :param pulumi.Input[Sequence[pulumi.Input['KeyVaultPropertiesArgs']]] key_vault_properties: Properties of KeyVault
        :param pulumi.Input[bool] require_infrastructure_encryption: Enable Infrastructure Encryption (Double Encryption)
        """
        if key_source is None:
            key_source = 'Microsoft.KeyVault'
        if key_source is not None:
            pulumi.set(__self__, "key_source", key_source)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        if require_infrastructure_encryption is not None:
            pulumi.set(__self__, "require_infrastructure_encryption", require_infrastructure_encryption)

    @property
    @pulumi.getter(name="keySource")
    def key_source(self) -> Optional[pulumi.Input['KeySource']]:
        """
        Enumerates the possible value of keySource for Encryption
        """
        return pulumi.get(self, "key_source")

    @key_source.setter
    def key_source(self, value: Optional[pulumi.Input['KeySource']]):
        pulumi.set(self, "key_source", value)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyVaultPropertiesArgs']]]]:
        """
        Properties of KeyVault
        """
        return pulumi.get(self, "key_vault_properties")

    @key_vault_properties.setter
    def key_vault_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyVaultPropertiesArgs']]]]):
        pulumi.set(self, "key_vault_properties", value)

    @property
    @pulumi.getter(name="requireInfrastructureEncryption")
    def require_infrastructure_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Infrastructure Encryption (Double Encryption)
        """
        return pulumi.get(self, "require_infrastructure_encryption")

    @require_infrastructure_encryption.setter
    def require_infrastructure_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_infrastructure_encryption", value)


@pulumi.input_type
class IdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ManagedServiceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Properties to configure Identity for Bring your Own Keys
        :param pulumi.Input['ManagedServiceIdentityType'] type: Type of managed service identity.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: Properties for User Assigned Identities
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ManagedServiceIdentityType']]:
        """
        Type of managed service identity.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ManagedServiceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Properties for User Assigned Identities
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class KeyVaultPropertiesArgs:
    def __init__(__self__, *,
                 identity: Optional[pulumi.Input['UserAssignedIdentityPropertiesArgs']] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 key_vault_uri: Optional[pulumi.Input[str]] = None,
                 key_version: Optional[pulumi.Input[str]] = None):
        """
        Properties to configure keyVault Properties
        :param pulumi.Input[str] key_name: Name of the Key from KeyVault
        :param pulumi.Input[str] key_vault_uri: Uri of KeyVault
        :param pulumi.Input[str] key_version: Key Version
        """
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_vault_uri is not None:
            pulumi.set(__self__, "key_vault_uri", key_vault_uri)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['UserAssignedIdentityPropertiesArgs']]:
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['UserAssignedIdentityPropertiesArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Key from KeyVault
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Uri of KeyVault
        """
        return pulumi.get(self, "key_vault_uri")

    @key_vault_uri.setter
    def key_vault_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_uri", value)

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[pulumi.Input[str]]:
        """
        Key Version
        """
        return pulumi.get(self, "key_version")

    @key_version.setter
    def key_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_version", value)


@pulumi.input_type
class NWRuleSetIpRulesArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[Union[str, 'NetworkRuleIPAction']]] = None,
                 ip_mask: Optional[pulumi.Input[str]] = None):
        """
        The response from the List namespace operation.
        :param pulumi.Input[Union[str, 'NetworkRuleIPAction']] action: The IP Filter Action
        :param pulumi.Input[str] ip_mask: IP Mask
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if ip_mask is not None:
            pulumi.set(__self__, "ip_mask", ip_mask)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[Union[str, 'NetworkRuleIPAction']]]:
        """
        The IP Filter Action
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[Union[str, 'NetworkRuleIPAction']]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> Optional[pulumi.Input[str]]:
        """
        IP Mask
        """
        return pulumi.get(self, "ip_mask")

    @ip_mask.setter
    def ip_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_mask", value)


@pulumi.input_type
class NWRuleSetVirtualNetworkRulesArgs:
    def __init__(__self__, *,
                 ignore_missing_vnet_service_endpoint: Optional[pulumi.Input[bool]] = None,
                 subnet: Optional[pulumi.Input['SubnetArgs']] = None):
        """
        The response from the List namespace operation.
        :param pulumi.Input[bool] ignore_missing_vnet_service_endpoint: Value that indicates whether to ignore missing Vnet Service Endpoint
        :param pulumi.Input['SubnetArgs'] subnet: Subnet properties
        """
        if ignore_missing_vnet_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_vnet_service_endpoint", ignore_missing_vnet_service_endpoint)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="ignoreMissingVnetServiceEndpoint")
    def ignore_missing_vnet_service_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Value that indicates whether to ignore missing Vnet Service Endpoint
        """
        return pulumi.get(self, "ignore_missing_vnet_service_endpoint")

    @ignore_missing_vnet_service_endpoint.setter
    def ignore_missing_vnet_service_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_missing_vnet_service_endpoint", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubnetArgs']]:
        """
        Subnet properties
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubnetArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class PrivateEndpointConnectionArgs:
    def __init__(__self__, *,
                 private_endpoint: Optional[pulumi.Input['PrivateEndpointArgs']] = None,
                 private_link_service_connection_state: Optional[pulumi.Input['ConnectionStateArgs']] = None,
                 provisioning_state: Optional[pulumi.Input[Union[str, 'EndPointProvisioningState']]] = None):
        """
        Properties of the PrivateEndpointConnection.
        :param pulumi.Input['PrivateEndpointArgs'] private_endpoint: The Private Endpoint resource for this Connection.
        :param pulumi.Input['ConnectionStateArgs'] private_link_service_connection_state: Details about the state of the connection.
        :param pulumi.Input[Union[str, 'EndPointProvisioningState']] provisioning_state: Provisioning state of the Private Endpoint Connection.
        """
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional[pulumi.Input['PrivateEndpointArgs']]:
        """
        The Private Endpoint resource for this Connection.
        """
        return pulumi.get(self, "private_endpoint")

    @private_endpoint.setter
    def private_endpoint(self, value: Optional[pulumi.Input['PrivateEndpointArgs']]):
        pulumi.set(self, "private_endpoint", value)

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional[pulumi.Input['ConnectionStateArgs']]:
        """
        Details about the state of the connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @private_link_service_connection_state.setter
    def private_link_service_connection_state(self, value: Optional[pulumi.Input['ConnectionStateArgs']]):
        pulumi.set(self, "private_link_service_connection_state", value)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[pulumi.Input[Union[str, 'EndPointProvisioningState']]]:
        """
        Provisioning state of the Private Endpoint Connection.
        """
        return pulumi.get(self, "provisioning_state")

    @provisioning_state.setter
    def provisioning_state(self, value: Optional[pulumi.Input[Union[str, 'EndPointProvisioningState']]]):
        pulumi.set(self, "provisioning_state", value)


@pulumi.input_type
class PrivateEndpointArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        PrivateEndpoint information.
        :param pulumi.Input[str] id: The ARM identifier for Private Endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARM identifier for Private Endpoint.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class RetentionDescriptionArgs:
    def __init__(__self__, *,
                 cleanup_policy: Optional[pulumi.Input[Union[str, 'CleanupPolicyRetentionDescription']]] = None,
                 retention_time_in_hours: Optional[pulumi.Input[float]] = None,
                 tombstone_retention_time_in_hours: Optional[pulumi.Input[int]] = None):
        """
        Properties to configure retention settings for the  eventhub
        :param pulumi.Input[Union[str, 'CleanupPolicyRetentionDescription']] cleanup_policy: Enumerates the possible values for cleanup policy
        :param pulumi.Input[float] retention_time_in_hours: Number of hours to retain the events for this Event Hub. This value is only used when cleanupPolicy is Delete. If cleanupPolicy is Compaction the returned value of this property is Long.MaxValue 
        :param pulumi.Input[int] tombstone_retention_time_in_hours: Number of hours to retain the tombstone markers of a compacted Event Hub. This value is only used when cleanupPolicy is Compaction. Consumer must complete reading the tombstone marker within this specified amount of time if consumer begins from starting offset to ensure they get a valid snapshot for the specific key described by the tombstone marker within the compacted Event Hub
        """
        if cleanup_policy is not None:
            pulumi.set(__self__, "cleanup_policy", cleanup_policy)
        if retention_time_in_hours is not None:
            pulumi.set(__self__, "retention_time_in_hours", retention_time_in_hours)
        if tombstone_retention_time_in_hours is not None:
            pulumi.set(__self__, "tombstone_retention_time_in_hours", tombstone_retention_time_in_hours)

    @property
    @pulumi.getter(name="cleanupPolicy")
    def cleanup_policy(self) -> Optional[pulumi.Input[Union[str, 'CleanupPolicyRetentionDescription']]]:
        """
        Enumerates the possible values for cleanup policy
        """
        return pulumi.get(self, "cleanup_policy")

    @cleanup_policy.setter
    def cleanup_policy(self, value: Optional[pulumi.Input[Union[str, 'CleanupPolicyRetentionDescription']]]):
        pulumi.set(self, "cleanup_policy", value)

    @property
    @pulumi.getter(name="retentionTimeInHours")
    def retention_time_in_hours(self) -> Optional[pulumi.Input[float]]:
        """
        Number of hours to retain the events for this Event Hub. This value is only used when cleanupPolicy is Delete. If cleanupPolicy is Compaction the returned value of this property is Long.MaxValue 
        """
        return pulumi.get(self, "retention_time_in_hours")

    @retention_time_in_hours.setter
    def retention_time_in_hours(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "retention_time_in_hours", value)

    @property
    @pulumi.getter(name="tombstoneRetentionTimeInHours")
    def tombstone_retention_time_in_hours(self) -> Optional[pulumi.Input[int]]:
        """
        Number of hours to retain the tombstone markers of a compacted Event Hub. This value is only used when cleanupPolicy is Compaction. Consumer must complete reading the tombstone marker within this specified amount of time if consumer begins from starting offset to ensure they get a valid snapshot for the specific key described by the tombstone marker within the compacted Event Hub
        """
        return pulumi.get(self, "tombstone_retention_time_in_hours")

    @tombstone_retention_time_in_hours.setter
    def tombstone_retention_time_in_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tombstone_retention_time_in_hours", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'SkuName']],
                 capacity: Optional[pulumi.Input[int]] = None,
                 tier: Optional[pulumi.Input[Union[str, 'SkuTier']]] = None):
        """
        SKU parameters supplied to the create namespace operation
        :param pulumi.Input[Union[str, 'SkuName']] name: Name of this SKU.
        :param pulumi.Input[int] capacity: The Event Hubs throughput units for Basic or Standard tiers, where value should be 0 to 20 throughput units. The Event Hubs premium units for Premium tier, where value should be 0 to 10 premium units.
        :param pulumi.Input[Union[str, 'SkuTier']] tier: The billing tier of this particular SKU.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'SkuName']]:
        """
        Name of this SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'SkuName']]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The Event Hubs throughput units for Basic or Standard tiers, where value should be 0 to 20 throughput units. The Event Hubs premium units for Premium tier, where value should be 0 to 10 premium units.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[Union[str, 'SkuTier']]]:
        """
        The billing tier of this particular SKU.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[Union[str, 'SkuTier']]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SubnetArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Properties supplied for Subnet
        :param pulumi.Input[str] id: Resource ID of Virtual Network Subnet
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID of Virtual Network Subnet
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class ThrottlingPolicyArgs:
    def __init__(__self__, *,
                 metric_id: pulumi.Input[Union[str, 'MetricId']],
                 name: pulumi.Input[str],
                 rate_limit_threshold: pulumi.Input[float],
                 type: pulumi.Input[str]):
        """
        Properties of the throttling policy
        :param pulumi.Input[Union[str, 'MetricId']] metric_id: Metric Id on which the throttle limit should be set, MetricId can be discovered by hovering over Metric in the Metrics section of Event Hub Namespace inside Azure Portal
        :param pulumi.Input[str] name: The Name of this policy
        :param pulumi.Input[float] rate_limit_threshold: The Threshold limit above which the application group will be throttled.Rate limit is always per second.
        :param pulumi.Input[str] type: Application Group Policy types
               Expected value is 'ThrottlingPolicy'.
        """
        pulumi.set(__self__, "metric_id", metric_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rate_limit_threshold", rate_limit_threshold)
        pulumi.set(__self__, "type", 'ThrottlingPolicy')

    @property
    @pulumi.getter(name="metricId")
    def metric_id(self) -> pulumi.Input[Union[str, 'MetricId']]:
        """
        Metric Id on which the throttle limit should be set, MetricId can be discovered by hovering over Metric in the Metrics section of Event Hub Namespace inside Azure Portal
        """
        return pulumi.get(self, "metric_id")

    @metric_id.setter
    def metric_id(self, value: pulumi.Input[Union[str, 'MetricId']]):
        pulumi.set(self, "metric_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The Name of this policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rateLimitThreshold")
    def rate_limit_threshold(self) -> pulumi.Input[float]:
        """
        The Threshold limit above which the application group will be throttled.Rate limit is always per second.
        """
        return pulumi.get(self, "rate_limit_threshold")

    @rate_limit_threshold.setter
    def rate_limit_threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "rate_limit_threshold", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Application Group Policy types
        Expected value is 'ThrottlingPolicy'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class UserAssignedIdentityPropertiesArgs:
    def __init__(__self__, *,
                 user_assigned_identity: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] user_assigned_identity: ARM ID of user Identity selected for encryption
        """
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of user Identity selected for encryption
        """
        return pulumi.get(self, "user_assigned_identity")

    @user_assigned_identity.setter
    def user_assigned_identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_assigned_identity", value)


