# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'FileDestinationArgs',
    'NotificationPropertiesArgs',
    'SchedulePropertiesArgs',
]

@pulumi.input_type
class FileDestinationArgs:
    def __init__(__self__, *,
                 file_formats: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FileFormat']]]]] = None):
        """
        Destination of the view data. This is optional. Currently only csv format is supported.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'FileFormat']]]] file_formats: Destination of the view data. Currently only csv format is supported.
        """
        if file_formats is not None:
            pulumi.set(__self__, "file_formats", file_formats)

    @property
    @pulumi.getter(name="fileFormats")
    def file_formats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FileFormat']]]]]:
        """
        Destination of the view data. Currently only csv format is supported.
        """
        return pulumi.get(self, "file_formats")

    @file_formats.setter
    def file_formats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FileFormat']]]]]):
        pulumi.set(self, "file_formats", value)


@pulumi.input_type
class NotificationPropertiesArgs:
    def __init__(__self__, *,
                 subject: pulumi.Input[str],
                 to: pulumi.Input[Sequence[pulumi.Input[str]]],
                 message: Optional[pulumi.Input[str]] = None):
        """
        The properties of the scheduled action notification.
        :param pulumi.Input[str] subject: Subject of the email. Length is limited to 70 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] to: Array of email addresses.
        :param pulumi.Input[str] message: Optional message to be added in the email. Length is limited to 250 characters.
        """
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "to", to)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def subject(self) -> pulumi.Input[str]:
        """
        Subject of the email. Length is limited to 70 characters.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: pulumi.Input[str]):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter
    def to(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Array of email addresses.
        """
        return pulumi.get(self, "to")

    @to.setter
    def to(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "to", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Optional message to be added in the email. Length is limited to 250 characters.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)


@pulumi.input_type
class SchedulePropertiesArgs:
    def __init__(__self__, *,
                 end_date: pulumi.Input[str],
                 frequency: pulumi.Input[Union[str, 'ScheduleFrequency']],
                 start_date: pulumi.Input[str],
                 day_of_month: Optional[pulumi.Input[int]] = None,
                 days_of_week: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'DaysOfWeek']]]]] = None,
                 hour_of_day: Optional[pulumi.Input[int]] = None,
                 weeks_of_month: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'WeeksOfMonth']]]]] = None):
        """
        The properties of the schedule.
        :param pulumi.Input[str] end_date: The end date and time of the scheduled action (UTC).
        :param pulumi.Input[Union[str, 'ScheduleFrequency']] frequency: Frequency of the schedule.
        :param pulumi.Input[str] start_date: The start date and time of the scheduled action (UTC).
        :param pulumi.Input[int] day_of_month: UTC day on which cost analysis data will be emailed. Must be between 1 and 31. This property is applicable when frequency is Monthly and overrides weeksOfMonth or daysOfWeek.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'DaysOfWeek']]]] days_of_week: Day names in english on which cost analysis data will be emailed. This property is applicable when frequency is Weekly or Monthly.
        :param pulumi.Input[int] hour_of_day: UTC time at which cost analysis data will be emailed.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'WeeksOfMonth']]]] weeks_of_month: Weeks in which cost analysis data will be emailed. This property is applicable when frequency is Monthly and used in combination with daysOfWeek.
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "start_date", start_date)
        if day_of_month is not None:
            pulumi.set(__self__, "day_of_month", day_of_month)
        if days_of_week is not None:
            pulumi.set(__self__, "days_of_week", days_of_week)
        if hour_of_day is not None:
            pulumi.set(__self__, "hour_of_day", hour_of_day)
        if weeks_of_month is not None:
            pulumi.set(__self__, "weeks_of_month", weeks_of_month)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> pulumi.Input[str]:
        """
        The end date and time of the scheduled action (UTC).
        """
        return pulumi.get(self, "end_date")

    @end_date.setter
    def end_date(self, value: pulumi.Input[str]):
        pulumi.set(self, "end_date", value)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[Union[str, 'ScheduleFrequency']]:
        """
        Frequency of the schedule.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[Union[str, 'ScheduleFrequency']]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> pulumi.Input[str]:
        """
        The start date and time of the scheduled action (UTC).
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_date", value)

    @property
    @pulumi.getter(name="dayOfMonth")
    def day_of_month(self) -> Optional[pulumi.Input[int]]:
        """
        UTC day on which cost analysis data will be emailed. Must be between 1 and 31. This property is applicable when frequency is Monthly and overrides weeksOfMonth or daysOfWeek.
        """
        return pulumi.get(self, "day_of_month")

    @day_of_month.setter
    def day_of_month(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "day_of_month", value)

    @property
    @pulumi.getter(name="daysOfWeek")
    def days_of_week(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'DaysOfWeek']]]]]:
        """
        Day names in english on which cost analysis data will be emailed. This property is applicable when frequency is Weekly or Monthly.
        """
        return pulumi.get(self, "days_of_week")

    @days_of_week.setter
    def days_of_week(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'DaysOfWeek']]]]]):
        pulumi.set(self, "days_of_week", value)

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> Optional[pulumi.Input[int]]:
        """
        UTC time at which cost analysis data will be emailed.
        """
        return pulumi.get(self, "hour_of_day")

    @hour_of_day.setter
    def hour_of_day(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hour_of_day", value)

    @property
    @pulumi.getter(name="weeksOfMonth")
    def weeks_of_month(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'WeeksOfMonth']]]]]:
        """
        Weeks in which cost analysis data will be emailed. This property is applicable when frequency is Monthly and used in combination with daysOfWeek.
        """
        return pulumi.get(self, "weeks_of_month")

    @weeks_of_month.setter
    def weeks_of_month(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'WeeksOfMonth']]]]]):
        pulumi.set(self, "weeks_of_month", value)


