# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ExtendedLocationArgs',
    'IPPoolArgs',
    'InterfaceDNSSettingsArgs',
    'IpConfigurationPropertiesArgs',
    'IpConfigurationSubnetArgs',
    'IpConfigurationArgs',
    'VirtualmachinesPropertiesDataDisksArgs',
    'VirtualmachinesPropertiesDynamicMemoryConfigArgs',
    'VirtualmachinesPropertiesHardwareProfileArgs',
    'VirtualmachinesPropertiesImageReferenceArgs',
    'VirtualmachinesPropertiesLinuxConfigurationArgs',
    'VirtualmachinesPropertiesNetworkInterfacesArgs',
    'VirtualmachinesPropertiesNetworkProfileArgs',
    'VirtualmachinesPropertiesOsProfileArgs',
    'VirtualmachinesPropertiesPublicKeysPublicKeysArgs',
    'VirtualmachinesPropertiesPublicKeysArgs',
    'VirtualmachinesPropertiesSecurityProfileArgs',
    'VirtualmachinesPropertiesSshSshArgs',
    'VirtualmachinesPropertiesSshArgs',
    'VirtualmachinesPropertiesStorageProfileArgs',
    'VirtualmachinesPropertiesWindowsConfigurationArgs',
    'VirtualnetworksPropertiesIpConfigurationReferencesArgs',
    'VirtualnetworksPropertiesRouteTableArgs',
    'VirtualnetworksPropertiesRoutesArgs',
    'VirtualnetworksPropertiesSubnetsArgs',
]

@pulumi.input_type
class ExtendedLocationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]] = None):
        """
        The complex type of the extended location.
        :param pulumi.Input[str] name: The name of the extended location.
        :param pulumi.Input[Union[str, 'ExtendedLocationTypes']] type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class IPPoolArgs:
    def __init__(__self__, *,
                 end: Optional[pulumi.Input[str]] = None,
                 ip_pool_type: Optional[pulumi.Input['IPPoolTypeEnum']] = None,
                 start: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] end: Last IP in the pool
        :param pulumi.Input['IPPoolTypeEnum'] ip_pool_type: ip pool type
        :param pulumi.Input[str] start: First IP in the pool
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if ip_pool_type is not None:
            pulumi.set(__self__, "ip_pool_type", ip_pool_type)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[str]]:
        """
        Last IP in the pool
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter(name="ipPoolType")
    def ip_pool_type(self) -> Optional[pulumi.Input['IPPoolTypeEnum']]:
        """
        ip pool type
        """
        return pulumi.get(self, "ip_pool_type")

    @ip_pool_type.setter
    def ip_pool_type(self, value: Optional[pulumi.Input['IPPoolTypeEnum']]):
        pulumi.set(self, "ip_pool_type", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[str]]:
        """
        First IP in the pool
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class InterfaceDNSSettingsArgs:
    def __init__(__self__, *,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: List of DNS server IP Addresses for the interface
        """
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of DNS server IP Addresses for the interface
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers", value)


@pulumi.input_type
class IpConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 prefix_length: Optional[pulumi.Input[str]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[Union[str, 'PrivateIPAllocationMethodEnum']]] = None,
                 subnet: Optional[pulumi.Input['IpConfigurationSubnetArgs']] = None):
        """
        InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
        :param pulumi.Input[str] prefix_length: prefixLength for network interface
        :param pulumi.Input[str] private_ip_address: PrivateIPAddress - Private IP address of the IP configuration.
        :param pulumi.Input[Union[str, 'PrivateIPAllocationMethodEnum']] private_ip_allocation_method: PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
        :param pulumi.Input['IpConfigurationSubnetArgs'] subnet: Subnet - Name of Subnet bound to the IP configuration.
        """
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[pulumi.Input[str]]:
        """
        prefixLength for network interface
        """
        return pulumi.get(self, "prefix_length")

    @prefix_length.setter
    def prefix_length(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix_length", value)

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        PrivateIPAddress - Private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[pulumi.Input[Union[str, 'PrivateIPAllocationMethodEnum']]]:
        """
        PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @private_ip_allocation_method.setter
    def private_ip_allocation_method(self, value: Optional[pulumi.Input[Union[str, 'PrivateIPAllocationMethodEnum']]]):
        pulumi.set(self, "private_ip_allocation_method", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['IpConfigurationSubnetArgs']]:
        """
        Subnet - Name of Subnet bound to the IP configuration.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['IpConfigurationSubnetArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class IpConfigurationSubnetArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Subnet - Name of Subnet bound to the IP configuration.
        :param pulumi.Input[str] id: ID - The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        ID - The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class IpConfigurationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['IpConfigurationPropertiesArgs']] = None):
        """
        InterfaceIPConfiguration iPConfiguration in a network interface.
        :param pulumi.Input[str] name: Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input['IpConfigurationPropertiesArgs'] properties: InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['IpConfigurationPropertiesArgs']]:
        """
        InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['IpConfigurationPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class VirtualmachinesPropertiesDataDisksArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class VirtualmachinesPropertiesDynamicMemoryConfigArgs:
    def __init__(__self__, *,
                 maximum_memory_gb: Optional[pulumi.Input[float]] = None,
                 minimum_memory_gb: Optional[pulumi.Input[float]] = None,
                 target_memory_buffer: Optional[pulumi.Input[int]] = None):
        if maximum_memory_gb is not None:
            pulumi.set(__self__, "maximum_memory_gb", maximum_memory_gb)
        if minimum_memory_gb is not None:
            pulumi.set(__self__, "minimum_memory_gb", minimum_memory_gb)
        if target_memory_buffer is not None:
            pulumi.set(__self__, "target_memory_buffer", target_memory_buffer)

    @property
    @pulumi.getter(name="maximumMemoryGB")
    def maximum_memory_gb(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "maximum_memory_gb")

    @maximum_memory_gb.setter
    def maximum_memory_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "maximum_memory_gb", value)

    @property
    @pulumi.getter(name="minimumMemoryGB")
    def minimum_memory_gb(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "minimum_memory_gb")

    @minimum_memory_gb.setter
    def minimum_memory_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "minimum_memory_gb", value)

    @property
    @pulumi.getter(name="targetMemoryBuffer")
    def target_memory_buffer(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "target_memory_buffer")

    @target_memory_buffer.setter
    def target_memory_buffer(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_memory_buffer", value)


@pulumi.input_type
class VirtualmachinesPropertiesHardwareProfileArgs:
    def __init__(__self__, *,
                 dynamic_memory_config: Optional[pulumi.Input['VirtualmachinesPropertiesDynamicMemoryConfigArgs']] = None,
                 memory_gb: Optional[pulumi.Input[int]] = None,
                 processors: Optional[pulumi.Input[int]] = None,
                 vm_size: Optional[pulumi.Input[str]] = None):
        """
        HardwareProfile - Specifies the hardware settings for the virtual machine.
        :param pulumi.Input[int] memory_gb: RAM in gb for the virtual machine
        :param pulumi.Input[int] processors: number of processors for the virtual machine
        """
        if dynamic_memory_config is not None:
            pulumi.set(__self__, "dynamic_memory_config", dynamic_memory_config)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if processors is not None:
            pulumi.set(__self__, "processors", processors)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="dynamicMemoryConfig")
    def dynamic_memory_config(self) -> Optional[pulumi.Input['VirtualmachinesPropertiesDynamicMemoryConfigArgs']]:
        return pulumi.get(self, "dynamic_memory_config")

    @dynamic_memory_config.setter
    def dynamic_memory_config(self, value: Optional[pulumi.Input['VirtualmachinesPropertiesDynamicMemoryConfigArgs']]):
        pulumi.set(self, "dynamic_memory_config", value)

    @property
    @pulumi.getter(name="memoryGB")
    def memory_gb(self) -> Optional[pulumi.Input[int]]:
        """
        RAM in gb for the virtual machine
        """
        return pulumi.get(self, "memory_gb")

    @memory_gb.setter
    def memory_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_gb", value)

    @property
    @pulumi.getter
    def processors(self) -> Optional[pulumi.Input[int]]:
        """
        number of processors for the virtual machine
        """
        return pulumi.get(self, "processors")

    @processors.setter
    def processors(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "processors", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_size", value)


@pulumi.input_type
class VirtualmachinesPropertiesImageReferenceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Which Image to use for the virtual machine
        :param pulumi.Input[str] name: Name - Name of the image
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name - Name of the image
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class VirtualmachinesPropertiesLinuxConfigurationArgs:
    def __init__(__self__, *,
                 disable_password_authentication: Optional[pulumi.Input[bool]] = None,
                 ssh: Optional[pulumi.Input['VirtualmachinesPropertiesSshArgs']] = None):
        """
        LinuxConfiguration - linux specific configuration values for the virtual machine
        :param pulumi.Input[bool] disable_password_authentication: DisablePasswordAuthentication - whether password authentication should be disabled
        :param pulumi.Input['VirtualmachinesPropertiesSshArgs'] ssh: SSH - contains settings related to ssh configuration
        """
        if disable_password_authentication is not None:
            pulumi.set(__self__, "disable_password_authentication", disable_password_authentication)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> Optional[pulumi.Input[bool]]:
        """
        DisablePasswordAuthentication - whether password authentication should be disabled
        """
        return pulumi.get(self, "disable_password_authentication")

    @disable_password_authentication.setter
    def disable_password_authentication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_password_authentication", value)

    @property
    @pulumi.getter
    def ssh(self) -> Optional[pulumi.Input['VirtualmachinesPropertiesSshArgs']]:
        """
        SSH - contains settings related to ssh configuration
        """
        return pulumi.get(self, "ssh")

    @ssh.setter
    def ssh(self, value: Optional[pulumi.Input['VirtualmachinesPropertiesSshArgs']]):
        pulumi.set(self, "ssh", value)


@pulumi.input_type
class VirtualmachinesPropertiesNetworkInterfacesArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: Name of the network interface
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the network interface
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class VirtualmachinesPropertiesNetworkProfileArgs:
    def __init__(__self__, *,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualmachinesPropertiesNetworkInterfacesArgs']]]] = None):
        """
        NetworkProfile - describes the network configuration the virtual machine
        :param pulumi.Input[Sequence[pulumi.Input['VirtualmachinesPropertiesNetworkInterfacesArgs']]] network_interfaces: NetworkInterfaces - list of network interfaces to be attached to the virtual machine
        """
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualmachinesPropertiesNetworkInterfacesArgs']]]]:
        """
        NetworkInterfaces - list of network interfaces to be attached to the virtual machine
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualmachinesPropertiesNetworkInterfacesArgs']]]]):
        pulumi.set(self, "network_interfaces", value)


@pulumi.input_type
class VirtualmachinesPropertiesOsProfileArgs:
    def __init__(__self__, *,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 computer_name: Optional[pulumi.Input[str]] = None,
                 linux_configuration: Optional[pulumi.Input['VirtualmachinesPropertiesLinuxConfigurationArgs']] = None,
                 os_type: Optional[pulumi.Input[Union[str, 'OsTypeEnum']]] = None,
                 windows_configuration: Optional[pulumi.Input['VirtualmachinesPropertiesWindowsConfigurationArgs']] = None):
        """
        OsProfile - describes the configuration of the operating system and sets login data
        :param pulumi.Input[str] admin_password: AdminPassword - admin password
        :param pulumi.Input[str] admin_username: AdminUsername - admin username
        :param pulumi.Input[str] computer_name: ComputerName - name of the compute
        :param pulumi.Input['VirtualmachinesPropertiesLinuxConfigurationArgs'] linux_configuration: LinuxConfiguration - linux specific configuration values for the virtual machine
        :param pulumi.Input[Union[str, 'OsTypeEnum']] os_type: OsType - string specifying whether the OS is Linux or Windows
        :param pulumi.Input['VirtualmachinesPropertiesWindowsConfigurationArgs'] windows_configuration: Windows Configuration for the virtual machine 
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        AdminPassword - admin password
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[str]]:
        """
        AdminUsername - admin username
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[pulumi.Input[str]]:
        """
        ComputerName - name of the compute
        """
        return pulumi.get(self, "computer_name")

    @computer_name.setter
    def computer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "computer_name", value)

    @property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional[pulumi.Input['VirtualmachinesPropertiesLinuxConfigurationArgs']]:
        """
        LinuxConfiguration - linux specific configuration values for the virtual machine
        """
        return pulumi.get(self, "linux_configuration")

    @linux_configuration.setter
    def linux_configuration(self, value: Optional[pulumi.Input['VirtualmachinesPropertiesLinuxConfigurationArgs']]):
        pulumi.set(self, "linux_configuration", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[Union[str, 'OsTypeEnum']]]:
        """
        OsType - string specifying whether the OS is Linux or Windows
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[Union[str, 'OsTypeEnum']]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional[pulumi.Input['VirtualmachinesPropertiesWindowsConfigurationArgs']]:
        """
        Windows Configuration for the virtual machine 
        """
        return pulumi.get(self, "windows_configuration")

    @windows_configuration.setter
    def windows_configuration(self, value: Optional[pulumi.Input['VirtualmachinesPropertiesWindowsConfigurationArgs']]):
        pulumi.set(self, "windows_configuration", value)


@pulumi.input_type
class VirtualmachinesPropertiesPublicKeysPublicKeysArgs:
    def __init__(__self__, *,
                 key_data: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key_data: KeyData - SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Li      nux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param pulumi.Input[str] path: Path - Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[pulumi.Input[str]]:
        """
        KeyData - SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Li      nux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "key_data")

    @key_data.setter
    def key_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_data", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path - Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class VirtualmachinesPropertiesPublicKeysArgs:
    def __init__(__self__, *,
                 key_data: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key_data: KeyData - SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Li      nux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param pulumi.Input[str] path: Path - Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[pulumi.Input[str]]:
        """
        KeyData - SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Li      nux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "key_data")

    @key_data.setter
    def key_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_data", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path - Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class VirtualmachinesPropertiesSecurityProfileArgs:
    def __init__(__self__, *,
                 enable_tpm: Optional[pulumi.Input[bool]] = None):
        """
        SecurityProfile - Specifies the security settings for the virtual machine.
        """
        if enable_tpm is not None:
            pulumi.set(__self__, "enable_tpm", enable_tpm)

    @property
    @pulumi.getter(name="enableTPM")
    def enable_tpm(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enable_tpm")

    @enable_tpm.setter
    def enable_tpm(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_tpm", value)


@pulumi.input_type
class VirtualmachinesPropertiesSshSshArgs:
    def __init__(__self__, *,
                 public_keys: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualmachinesPropertiesPublicKeysPublicKeysArgs']]]] = None):
        """
        SSH Configuration
        :param pulumi.Input[Sequence[pulumi.Input['VirtualmachinesPropertiesPublicKeysPublicKeysArgs']]] public_keys: PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualmachinesPropertiesPublicKeysPublicKeysArgs']]]]:
        """
        PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
        """
        return pulumi.get(self, "public_keys")

    @public_keys.setter
    def public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualmachinesPropertiesPublicKeysPublicKeysArgs']]]]):
        pulumi.set(self, "public_keys", value)


@pulumi.input_type
class VirtualmachinesPropertiesSshArgs:
    def __init__(__self__, *,
                 public_keys: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualmachinesPropertiesPublicKeysArgs']]]] = None):
        """
        SSH - contains settings related to ssh configuration
        :param pulumi.Input[Sequence[pulumi.Input['VirtualmachinesPropertiesPublicKeysArgs']]] public_keys: PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualmachinesPropertiesPublicKeysArgs']]]]:
        """
        PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
        """
        return pulumi.get(self, "public_keys")

    @public_keys.setter
    def public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualmachinesPropertiesPublicKeysArgs']]]]):
        pulumi.set(self, "public_keys", value)


@pulumi.input_type
class VirtualmachinesPropertiesStorageProfileArgs:
    def __init__(__self__, *,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualmachinesPropertiesDataDisksArgs']]]] = None,
                 image_reference: Optional[pulumi.Input['VirtualmachinesPropertiesImageReferenceArgs']] = None):
        """
        StorageProfile - contains information about the disks and storage information for the virtual machine
        :param pulumi.Input[Sequence[pulumi.Input['VirtualmachinesPropertiesDataDisksArgs']]] data_disks: adds data disks to the virtual machine
        :param pulumi.Input['VirtualmachinesPropertiesImageReferenceArgs'] image_reference: Which Image to use for the virtual machine
        """
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if image_reference is not None:
            pulumi.set(__self__, "image_reference", image_reference)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualmachinesPropertiesDataDisksArgs']]]]:
        """
        adds data disks to the virtual machine
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualmachinesPropertiesDataDisksArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> Optional[pulumi.Input['VirtualmachinesPropertiesImageReferenceArgs']]:
        """
        Which Image to use for the virtual machine
        """
        return pulumi.get(self, "image_reference")

    @image_reference.setter
    def image_reference(self, value: Optional[pulumi.Input['VirtualmachinesPropertiesImageReferenceArgs']]):
        pulumi.set(self, "image_reference", value)


@pulumi.input_type
class VirtualmachinesPropertiesWindowsConfigurationArgs:
    def __init__(__self__, *,
                 enable_automatic_updates: Optional[pulumi.Input[bool]] = None,
                 ssh: Optional[pulumi.Input['VirtualmachinesPropertiesSshSshArgs']] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        Windows Configuration for the virtual machine 
        :param pulumi.Input[bool] enable_automatic_updates: Whether to EnableAutomaticUpdates on the machine
        :param pulumi.Input['VirtualmachinesPropertiesSshSshArgs'] ssh: SSH Configuration
        :param pulumi.Input[str] time_zone: TimeZone for the virtual machine
        """
        if enable_automatic_updates is not None:
            pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="enableAutomaticUpdates")
    def enable_automatic_updates(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to EnableAutomaticUpdates on the machine
        """
        return pulumi.get(self, "enable_automatic_updates")

    @enable_automatic_updates.setter
    def enable_automatic_updates(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_automatic_updates", value)

    @property
    @pulumi.getter
    def ssh(self) -> Optional[pulumi.Input['VirtualmachinesPropertiesSshSshArgs']]:
        """
        SSH Configuration
        """
        return pulumi.get(self, "ssh")

    @ssh.setter
    def ssh(self, value: Optional[pulumi.Input['VirtualmachinesPropertiesSshSshArgs']]):
        pulumi.set(self, "ssh", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        TimeZone for the virtual machine
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class VirtualnetworksPropertiesIpConfigurationReferencesArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        IPConfigurationReference - Describes a IPConfiguration under the virtual network
        :param pulumi.Input[str] id: Name of the Ip Configuration
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Ip Configuration
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class VirtualnetworksPropertiesRouteTableArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualnetworksPropertiesRoutesArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        RouteTable for the subnet
        :param pulumi.Input[str] id: route ID - ID of the IP route
        :param pulumi.Input[str] name: Name - READ-ONLY; Resource name.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualnetworksPropertiesRoutesArgs']]] routes: Routes - Collection of routes contained within a route table.
        :param pulumi.Input[str] type: Type - READ-ONLY; Resource type.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        route ID - ID of the IP route
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name - READ-ONLY; Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualnetworksPropertiesRoutesArgs']]]]:
        """
        Routes - Collection of routes contained within a route table.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualnetworksPropertiesRoutesArgs']]]]):
        pulumi.set(self, "routes", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type - READ-ONLY; Resource type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class VirtualnetworksPropertiesRoutesArgs:
    def __init__(__self__, *,
                 address_prefix: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 next_hop_ip_address: Optional[pulumi.Input[str]] = None):
        """
        Route is associated with a subnet.
        :param pulumi.Input[str] address_prefix: AddressPrefix - The destination CIDR to which the route applies.
        :param pulumi.Input[str] name: Name - name of the subnet
        :param pulumi.Input[str] next_hop_ip_address: NextHopIPAddress - The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
        """
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_ip_address is not None:
            pulumi.set(__self__, "next_hop_ip_address", next_hop_ip_address)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        AddressPrefix - The destination CIDR to which the route applies.
        """
        return pulumi.get(self, "address_prefix")

    @address_prefix.setter
    def address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_prefix", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name - name of the subnet
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nextHopIpAddress")
    def next_hop_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        NextHopIPAddress - The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
        """
        return pulumi.get(self, "next_hop_ip_address")

    @next_hop_ip_address.setter
    def next_hop_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_ip_address", value)


@pulumi.input_type
class VirtualnetworksPropertiesSubnetsArgs:
    def __init__(__self__, *,
                 address_prefix: Optional[pulumi.Input[str]] = None,
                 address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_allocation_method: Optional[pulumi.Input[Union[str, 'IpAllocationMethodEnum']]] = None,
                 ip_configuration_references: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualnetworksPropertiesIpConfigurationReferencesArgs']]]] = None,
                 ip_pools: Optional[pulumi.Input[Sequence[pulumi.Input['IPPoolArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 route_table: Optional[pulumi.Input['VirtualnetworksPropertiesRouteTableArgs']] = None,
                 vlan: Optional[pulumi.Input[int]] = None):
        """
        Subnet subnet in a virtual network resource.
        :param pulumi.Input[str] address_prefix: Cidr for this subnet - IPv4, IPv6
        :param pulumi.Input[Sequence[pulumi.Input[str]]] address_prefixes: AddressPrefixes - List of address prefixes for the subnet.
        :param pulumi.Input[Union[str, 'IpAllocationMethodEnum']] ip_allocation_method: IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
        :param pulumi.Input[Sequence[pulumi.Input['VirtualnetworksPropertiesIpConfigurationReferencesArgs']]] ip_configuration_references: IPConfigurationReferences - list of IPConfigurationReferences
        :param pulumi.Input[Sequence[pulumi.Input['IPPoolArgs']]] ip_pools: network associated pool of IP Addresses
        :param pulumi.Input[str] name: Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input['VirtualnetworksPropertiesRouteTableArgs'] route_table: RouteTable for the subnet
        :param pulumi.Input[int] vlan: Vlan to use for the subnet
        """
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)
        if ip_allocation_method is not None:
            pulumi.set(__self__, "ip_allocation_method", ip_allocation_method)
        if ip_configuration_references is not None:
            pulumi.set(__self__, "ip_configuration_references", ip_configuration_references)
        if ip_pools is not None:
            pulumi.set(__self__, "ip_pools", ip_pools)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if route_table is not None:
            pulumi.set(__self__, "route_table", route_table)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Cidr for this subnet - IPv4, IPv6
        """
        return pulumi.get(self, "address_prefix")

    @address_prefix.setter
    def address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_prefix", value)

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AddressPrefixes - List of address prefixes for the subnet.
        """
        return pulumi.get(self, "address_prefixes")

    @address_prefixes.setter
    def address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "address_prefixes", value)

    @property
    @pulumi.getter(name="ipAllocationMethod")
    def ip_allocation_method(self) -> Optional[pulumi.Input[Union[str, 'IpAllocationMethodEnum']]]:
        """
        IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
        """
        return pulumi.get(self, "ip_allocation_method")

    @ip_allocation_method.setter
    def ip_allocation_method(self, value: Optional[pulumi.Input[Union[str, 'IpAllocationMethodEnum']]]):
        pulumi.set(self, "ip_allocation_method", value)

    @property
    @pulumi.getter(name="ipConfigurationReferences")
    def ip_configuration_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualnetworksPropertiesIpConfigurationReferencesArgs']]]]:
        """
        IPConfigurationReferences - list of IPConfigurationReferences
        """
        return pulumi.get(self, "ip_configuration_references")

    @ip_configuration_references.setter
    def ip_configuration_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualnetworksPropertiesIpConfigurationReferencesArgs']]]]):
        pulumi.set(self, "ip_configuration_references", value)

    @property
    @pulumi.getter(name="ipPools")
    def ip_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IPPoolArgs']]]]:
        """
        network associated pool of IP Addresses
        """
        return pulumi.get(self, "ip_pools")

    @ip_pools.setter
    def ip_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IPPoolArgs']]]]):
        pulumi.set(self, "ip_pools", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="routeTable")
    def route_table(self) -> Optional[pulumi.Input['VirtualnetworksPropertiesRouteTableArgs']]:
        """
        RouteTable for the subnet
        """
        return pulumi.get(self, "route_table")

    @route_table.setter
    def route_table(self, value: Optional[pulumi.Input['VirtualnetworksPropertiesRouteTableArgs']]):
        pulumi.set(self, "route_table", value)

    @property
    @pulumi.getter
    def vlan(self) -> Optional[pulumi.Input[int]]:
        """
        Vlan to use for the subnet
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan", value)


