# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetLinkedSubscriptionResult',
    'AwaitableGetLinkedSubscriptionResult',
    'get_linked_subscription',
    'get_linked_subscription_output',
]

@pulumi.output_type
class GetLinkedSubscriptionResult:
    """
    Linked Subscription information.
    """
    def __init__(__self__, device_connection_status=None, device_id=None, device_link_state=None, device_object_id=None, etag=None, id=None, kind=None, last_connected_time=None, linked_subscription_id=None, location=None, name=None, registration_resource_id=None, system_data=None, tags=None, type=None):
        if device_connection_status and not isinstance(device_connection_status, str):
            raise TypeError("Expected argument 'device_connection_status' to be a str")
        pulumi.set(__self__, "device_connection_status", device_connection_status)
        if device_id and not isinstance(device_id, str):
            raise TypeError("Expected argument 'device_id' to be a str")
        pulumi.set(__self__, "device_id", device_id)
        if device_link_state and not isinstance(device_link_state, str):
            raise TypeError("Expected argument 'device_link_state' to be a str")
        pulumi.set(__self__, "device_link_state", device_link_state)
        if device_object_id and not isinstance(device_object_id, str):
            raise TypeError("Expected argument 'device_object_id' to be a str")
        pulumi.set(__self__, "device_object_id", device_object_id)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if last_connected_time and not isinstance(last_connected_time, str):
            raise TypeError("Expected argument 'last_connected_time' to be a str")
        pulumi.set(__self__, "last_connected_time", last_connected_time)
        if linked_subscription_id and not isinstance(linked_subscription_id, str):
            raise TypeError("Expected argument 'linked_subscription_id' to be a str")
        pulumi.set(__self__, "linked_subscription_id", linked_subscription_id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if registration_resource_id and not isinstance(registration_resource_id, str):
            raise TypeError("Expected argument 'registration_resource_id' to be a str")
        pulumi.set(__self__, "registration_resource_id", registration_resource_id)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="deviceConnectionStatus")
    def device_connection_status(self) -> str:
        """
        The status of the remote management connection of the Azure Stack device.
        """
        return pulumi.get(self, "device_connection_status")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> str:
        """
        The identifier of the Azure Stack device for remote management.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="deviceLinkState")
    def device_link_state(self) -> str:
        """
        The connection state of the Azure Stack device.
        """
        return pulumi.get(self, "device_link_state")

    @property
    @pulumi.getter(name="deviceObjectId")
    def device_object_id(self) -> str:
        """
        The object identifier associated with the Azure Stack device connecting to Azure.
        """
        return pulumi.get(self, "device_object_id")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        The entity tag used for optimistic concurrency when modifying the resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The kind of the resource.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="lastConnectedTime")
    def last_connected_time(self) -> str:
        """
        The last remote management connection time for the Azure Stack device connected to the linked subscription resource.
        """
        return pulumi.get(self, "last_connected_time")

    @property
    @pulumi.getter(name="linkedSubscriptionId")
    def linked_subscription_id(self) -> Optional[str]:
        """
        The identifier associated with the device subscription.
        """
        return pulumi.get(self, "linked_subscription_id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="registrationResourceId")
    def registration_resource_id(self) -> Optional[str]:
        """
        The identifier associated with the device registration.
        """
        return pulumi.get(self, "registration_resource_id")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Custom tags for the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of Resource.
        """
        return pulumi.get(self, "type")


class AwaitableGetLinkedSubscriptionResult(GetLinkedSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLinkedSubscriptionResult(
            device_connection_status=self.device_connection_status,
            device_id=self.device_id,
            device_link_state=self.device_link_state,
            device_object_id=self.device_object_id,
            etag=self.etag,
            id=self.id,
            kind=self.kind,
            last_connected_time=self.last_connected_time,
            linked_subscription_id=self.linked_subscription_id,
            location=self.location,
            name=self.name,
            registration_resource_id=self.registration_resource_id,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type)


def get_linked_subscription(linked_subscription_name: Optional[str] = None,
                            resource_group: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLinkedSubscriptionResult:
    """
    Returns the properties of a Linked Subscription resource.
    API Version: 2020-06-01-preview.


    :param str linked_subscription_name: Name of the Linked Subscription resource.
    :param str resource_group: Name of the resource group.
    """
    __args__ = dict()
    __args__['linkedSubscriptionName'] = linked_subscription_name
    __args__['resourceGroup'] = resource_group
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:azurestack:getLinkedSubscription', __args__, opts=opts, typ=GetLinkedSubscriptionResult).value

    return AwaitableGetLinkedSubscriptionResult(
        device_connection_status=__ret__.device_connection_status,
        device_id=__ret__.device_id,
        device_link_state=__ret__.device_link_state,
        device_object_id=__ret__.device_object_id,
        etag=__ret__.etag,
        id=__ret__.id,
        kind=__ret__.kind,
        last_connected_time=__ret__.last_connected_time,
        linked_subscription_id=__ret__.linked_subscription_id,
        location=__ret__.location,
        name=__ret__.name,
        registration_resource_id=__ret__.registration_resource_id,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_linked_subscription)
def get_linked_subscription_output(linked_subscription_name: Optional[pulumi.Input[str]] = None,
                                   resource_group: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLinkedSubscriptionResult]:
    """
    Returns the properties of a Linked Subscription resource.
    API Version: 2020-06-01-preview.


    :param str linked_subscription_name: Name of the Linked Subscription resource.
    :param str resource_group: Name of the resource group.
    """
    ...
