# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AddonHcxPropertiesResponse',
    'AddonSrmPropertiesResponse',
    'AddonVrPropertiesResponse',
    'AvailabilityPropertiesResponse',
    'CircuitResponse',
    'DiskPoolVolumeResponse',
    'EncryptionKeyVaultPropertiesResponse',
    'EncryptionResponse',
    'EndpointsResponse',
    'IdentitySourceResponse',
    'ManagementClusterResponse',
    'NetAppVolumeResponse',
    'PSCredentialExecutionParameterResponse',
    'PrivateCloudIdentityResponse',
    'ScriptSecureStringExecutionParameterResponse',
    'ScriptStringExecutionParameterResponse',
    'SkuResponse',
    'VmHostPlacementPolicyPropertiesResponse',
    'VmVmPlacementPolicyPropertiesResponse',
    'WorkloadNetworkDhcpRelayResponse',
    'WorkloadNetworkDhcpServerResponse',
    'WorkloadNetworkSegmentPortVifResponse',
    'WorkloadNetworkSegmentSubnetResponse',
]

@pulumi.output_type
class AddonHcxPropertiesResponse(dict):
    """
    The properties of an HCX addon
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addonType":
            suggest = "addon_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddonHcxPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddonHcxPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddonHcxPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 addon_type: str,
                 offer: str,
                 provisioning_state: str):
        """
        The properties of an HCX addon
        :param str addon_type: The type of private cloud addon
               Expected value is 'HCX'.
        :param str offer: The HCX offer, example VMware MaaS Cloud Provider (Enterprise)
        :param str provisioning_state: The state of the addon provisioning
        """
        pulumi.set(__self__, "addon_type", 'HCX')
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="addonType")
    def addon_type(self) -> str:
        """
        The type of private cloud addon
        Expected value is 'HCX'.
        """
        return pulumi.get(self, "addon_type")

    @property
    @pulumi.getter
    def offer(self) -> str:
        """
        The HCX offer, example VMware MaaS Cloud Provider (Enterprise)
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The state of the addon provisioning
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class AddonSrmPropertiesResponse(dict):
    """
    The properties of a Site Recovery Manager (SRM) addon
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addonType":
            suggest = "addon_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "licenseKey":
            suggest = "license_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddonSrmPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddonSrmPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddonSrmPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 addon_type: str,
                 provisioning_state: str,
                 license_key: Optional[str] = None):
        """
        The properties of a Site Recovery Manager (SRM) addon
        :param str addon_type: The type of private cloud addon
               Expected value is 'SRM'.
        :param str provisioning_state: The state of the addon provisioning
        :param str license_key: The Site Recovery Manager (SRM) license
        """
        pulumi.set(__self__, "addon_type", 'SRM')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if license_key is not None:
            pulumi.set(__self__, "license_key", license_key)

    @property
    @pulumi.getter(name="addonType")
    def addon_type(self) -> str:
        """
        The type of private cloud addon
        Expected value is 'SRM'.
        """
        return pulumi.get(self, "addon_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The state of the addon provisioning
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> Optional[str]:
        """
        The Site Recovery Manager (SRM) license
        """
        return pulumi.get(self, "license_key")


@pulumi.output_type
class AddonVrPropertiesResponse(dict):
    """
    The properties of a vSphere Replication (VR) addon
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addonType":
            suggest = "addon_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "vrsCount":
            suggest = "vrs_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddonVrPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddonVrPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddonVrPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 addon_type: str,
                 provisioning_state: str,
                 vrs_count: int):
        """
        The properties of a vSphere Replication (VR) addon
        :param str addon_type: The type of private cloud addon
               Expected value is 'VR'.
        :param str provisioning_state: The state of the addon provisioning
        :param int vrs_count: The vSphere Replication Server (VRS) count
        """
        pulumi.set(__self__, "addon_type", 'VR')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "vrs_count", vrs_count)

    @property
    @pulumi.getter(name="addonType")
    def addon_type(self) -> str:
        """
        The type of private cloud addon
        Expected value is 'VR'.
        """
        return pulumi.get(self, "addon_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The state of the addon provisioning
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="vrsCount")
    def vrs_count(self) -> int:
        """
        The vSphere Replication Server (VRS) count
        """
        return pulumi.get(self, "vrs_count")


@pulumi.output_type
class AvailabilityPropertiesResponse(dict):
    """
    The properties describing private cloud availability zone distribution
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secondaryZone":
            suggest = "secondary_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AvailabilityPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AvailabilityPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AvailabilityPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secondary_zone: Optional[int] = None,
                 strategy: Optional[str] = None,
                 zone: Optional[int] = None):
        """
        The properties describing private cloud availability zone distribution
        :param int secondary_zone: The secondary availability zone for the private cloud
        :param str strategy: The availability strategy for the private cloud
        :param int zone: The primary availability zone for the private cloud
        """
        if secondary_zone is not None:
            pulumi.set(__self__, "secondary_zone", secondary_zone)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> Optional[int]:
        """
        The secondary availability zone for the private cloud
        """
        return pulumi.get(self, "secondary_zone")

    @property
    @pulumi.getter
    def strategy(self) -> Optional[str]:
        """
        The availability strategy for the private cloud
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter
    def zone(self) -> Optional[int]:
        """
        The primary availability zone for the private cloud
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class CircuitResponse(dict):
    """
    An ExpressRoute Circuit
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expressRouteID":
            suggest = "express_route_id"
        elif key == "expressRoutePrivatePeeringID":
            suggest = "express_route_private_peering_id"
        elif key == "primarySubnet":
            suggest = "primary_subnet"
        elif key == "secondarySubnet":
            suggest = "secondary_subnet"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CircuitResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CircuitResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CircuitResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 express_route_id: str,
                 express_route_private_peering_id: str,
                 primary_subnet: str,
                 secondary_subnet: str):
        """
        An ExpressRoute Circuit
        :param str express_route_id: Identifier of the ExpressRoute Circuit (Microsoft Colo only)
        :param str express_route_private_peering_id: ExpressRoute Circuit private peering identifier
        :param str primary_subnet: CIDR of primary subnet
        :param str secondary_subnet: CIDR of secondary subnet
        """
        pulumi.set(__self__, "express_route_id", express_route_id)
        pulumi.set(__self__, "express_route_private_peering_id", express_route_private_peering_id)
        pulumi.set(__self__, "primary_subnet", primary_subnet)
        pulumi.set(__self__, "secondary_subnet", secondary_subnet)

    @property
    @pulumi.getter(name="expressRouteID")
    def express_route_id(self) -> str:
        """
        Identifier of the ExpressRoute Circuit (Microsoft Colo only)
        """
        return pulumi.get(self, "express_route_id")

    @property
    @pulumi.getter(name="expressRoutePrivatePeeringID")
    def express_route_private_peering_id(self) -> str:
        """
        ExpressRoute Circuit private peering identifier
        """
        return pulumi.get(self, "express_route_private_peering_id")

    @property
    @pulumi.getter(name="primarySubnet")
    def primary_subnet(self) -> str:
        """
        CIDR of primary subnet
        """
        return pulumi.get(self, "primary_subnet")

    @property
    @pulumi.getter(name="secondarySubnet")
    def secondary_subnet(self) -> str:
        """
        CIDR of secondary subnet
        """
        return pulumi.get(self, "secondary_subnet")


@pulumi.output_type
class DiskPoolVolumeResponse(dict):
    """
    An iSCSI volume from Microsoft.StoragePool provider
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lunName":
            suggest = "lun_name"
        elif key == "targetId":
            suggest = "target_id"
        elif key == "mountOption":
            suggest = "mount_option"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskPoolVolumeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskPoolVolumeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskPoolVolumeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lun_name: str,
                 path: str,
                 target_id: str,
                 mount_option: Optional[str] = None):
        """
        An iSCSI volume from Microsoft.StoragePool provider
        :param str lun_name: Name of the LUN to be used for datastore
        :param str path: Device path
        :param str target_id: Azure resource ID of the iSCSI target
        :param str mount_option: Mode that describes whether the LUN has to be mounted as a datastore or attached as a LUN
        """
        pulumi.set(__self__, "lun_name", lun_name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "target_id", target_id)
        if mount_option is None:
            mount_option = 'MOUNT'
        if mount_option is not None:
            pulumi.set(__self__, "mount_option", mount_option)

    @property
    @pulumi.getter(name="lunName")
    def lun_name(self) -> str:
        """
        Name of the LUN to be used for datastore
        """
        return pulumi.get(self, "lun_name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Device path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        Azure resource ID of the iSCSI target
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="mountOption")
    def mount_option(self) -> Optional[str]:
        """
        Mode that describes whether the LUN has to be mounted as a datastore or attached as a LUN
        """
        return pulumi.get(self, "mount_option")


@pulumi.output_type
class EncryptionKeyVaultPropertiesResponse(dict):
    """
    An Encryption Key
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyState":
            suggest = "key_state"
        elif key == "versionType":
            suggest = "version_type"
        elif key == "keyName":
            suggest = "key_name"
        elif key == "keyVaultUrl":
            suggest = "key_vault_url"
        elif key == "keyVersion":
            suggest = "key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionKeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionKeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionKeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_state: str,
                 version_type: str,
                 key_name: Optional[str] = None,
                 key_vault_url: Optional[str] = None,
                 key_version: Optional[str] = None):
        """
        An Encryption Key
        :param str key_state: The state of key provided
        :param str version_type: Property of the key if user provided or auto detected
        :param str key_name: The name of the key.
        :param str key_vault_url: The URL of the vault.
        :param str key_version: The version of the key.
        """
        pulumi.set(__self__, "key_state", key_state)
        pulumi.set(__self__, "version_type", version_type)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_vault_url is not None:
            pulumi.set(__self__, "key_vault_url", key_vault_url)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)

    @property
    @pulumi.getter(name="keyState")
    def key_state(self) -> str:
        """
        The state of key provided
        """
        return pulumi.get(self, "key_state")

    @property
    @pulumi.getter(name="versionType")
    def version_type(self) -> str:
        """
        Property of the key if user provided or auto detected
        """
        return pulumi.get(self, "version_type")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[str]:
        """
        The name of the key.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyVaultUrl")
    def key_vault_url(self) -> Optional[str]:
        """
        The URL of the vault.
        """
        return pulumi.get(self, "key_vault_url")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[str]:
        """
        The version of the key.
        """
        return pulumi.get(self, "key_version")


@pulumi.output_type
class EncryptionResponse(dict):
    """
    The properties of customer managed encryption key
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_vault_properties: Optional['outputs.EncryptionKeyVaultPropertiesResponse'] = None,
                 status: Optional[str] = None):
        """
        The properties of customer managed encryption key
        :param 'EncryptionKeyVaultPropertiesResponse' key_vault_properties: The key vault where the encryption key is stored
        :param str status: Status of customer managed encryption key
        """
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional['outputs.EncryptionKeyVaultPropertiesResponse']:
        """
        The key vault where the encryption key is stored
        """
        return pulumi.get(self, "key_vault_properties")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of customer managed encryption key
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class EndpointsResponse(dict):
    """
    Endpoint addresses
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hcxCloudManager":
            suggest = "hcx_cloud_manager"
        elif key == "nsxtManager":
            suggest = "nsxt_manager"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hcx_cloud_manager: str,
                 nsxt_manager: str,
                 vcsa: str):
        """
        Endpoint addresses
        :param str hcx_cloud_manager: Endpoint for the HCX Cloud Manager
        :param str nsxt_manager: Endpoint for the NSX-T Data Center manager
        :param str vcsa: Endpoint for Virtual Center Server Appliance
        """
        pulumi.set(__self__, "hcx_cloud_manager", hcx_cloud_manager)
        pulumi.set(__self__, "nsxt_manager", nsxt_manager)
        pulumi.set(__self__, "vcsa", vcsa)

    @property
    @pulumi.getter(name="hcxCloudManager")
    def hcx_cloud_manager(self) -> str:
        """
        Endpoint for the HCX Cloud Manager
        """
        return pulumi.get(self, "hcx_cloud_manager")

    @property
    @pulumi.getter(name="nsxtManager")
    def nsxt_manager(self) -> str:
        """
        Endpoint for the NSX-T Data Center manager
        """
        return pulumi.get(self, "nsxt_manager")

    @property
    @pulumi.getter
    def vcsa(self) -> str:
        """
        Endpoint for Virtual Center Server Appliance
        """
        return pulumi.get(self, "vcsa")


@pulumi.output_type
class IdentitySourceResponse(dict):
    """
    vCenter Single Sign On Identity Source
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseGroupDN":
            suggest = "base_group_dn"
        elif key == "baseUserDN":
            suggest = "base_user_dn"
        elif key == "primaryServer":
            suggest = "primary_server"
        elif key == "secondaryServer":
            suggest = "secondary_server"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentitySourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentitySourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentitySourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alias: Optional[str] = None,
                 base_group_dn: Optional[str] = None,
                 base_user_dn: Optional[str] = None,
                 domain: Optional[str] = None,
                 name: Optional[str] = None,
                 password: Optional[str] = None,
                 primary_server: Optional[str] = None,
                 secondary_server: Optional[str] = None,
                 ssl: Optional[str] = None,
                 username: Optional[str] = None):
        """
        vCenter Single Sign On Identity Source
        :param str alias: The domain's NetBIOS name
        :param str base_group_dn: The base distinguished name for groups
        :param str base_user_dn: The base distinguished name for users
        :param str domain: The domain's dns name
        :param str name: The name of the identity source
        :param str password: The password of the Active Directory user with a minimum of read-only access to Base DN for users and groups.
        :param str primary_server: Primary server URL
        :param str secondary_server: Secondary server URL
        :param str ssl: Protect LDAP communication using SSL certificate (LDAPS)
        :param str username: The ID of an Active Directory user with a minimum of read-only access to Base DN for users and group
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if base_group_dn is not None:
            pulumi.set(__self__, "base_group_dn", base_group_dn)
        if base_user_dn is not None:
            pulumi.set(__self__, "base_user_dn", base_user_dn)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if primary_server is not None:
            pulumi.set(__self__, "primary_server", primary_server)
        if secondary_server is not None:
            pulumi.set(__self__, "secondary_server", secondary_server)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def alias(self) -> Optional[str]:
        """
        The domain's NetBIOS name
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="baseGroupDN")
    def base_group_dn(self) -> Optional[str]:
        """
        The base distinguished name for groups
        """
        return pulumi.get(self, "base_group_dn")

    @property
    @pulumi.getter(name="baseUserDN")
    def base_user_dn(self) -> Optional[str]:
        """
        The base distinguished name for users
        """
        return pulumi.get(self, "base_user_dn")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The domain's dns name
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the identity source
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password of the Active Directory user with a minimum of read-only access to Base DN for users and groups.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="primaryServer")
    def primary_server(self) -> Optional[str]:
        """
        Primary server URL
        """
        return pulumi.get(self, "primary_server")

    @property
    @pulumi.getter(name="secondaryServer")
    def secondary_server(self) -> Optional[str]:
        """
        Secondary server URL
        """
        return pulumi.get(self, "secondary_server")

    @property
    @pulumi.getter
    def ssl(self) -> Optional[str]:
        """
        Protect LDAP communication using SSL certificate (LDAPS)
        """
        return pulumi.get(self, "ssl")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The ID of an Active Directory user with a minimum of read-only access to Base DN for users and group
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ManagementClusterResponse(dict):
    """
    The properties of a management cluster
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"
        elif key == "clusterSize":
            suggest = "cluster_size"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementClusterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementClusterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementClusterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: int,
                 cluster_size: int,
                 provisioning_state: str,
                 hosts: Optional[Sequence[str]] = None):
        """
        The properties of a management cluster
        :param int cluster_id: The identity
        :param int cluster_size: The cluster size
        :param str provisioning_state: The state of the cluster provisioning
        :param Sequence[str] hosts: The hosts
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "cluster_size", cluster_size)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> int:
        """
        The identity
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> int:
        """
        The cluster size
        """
        return pulumi.get(self, "cluster_size")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The state of the cluster provisioning
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence[str]]:
        """
        The hosts
        """
        return pulumi.get(self, "hosts")


@pulumi.output_type
class NetAppVolumeResponse(dict):
    """
    An Azure NetApp Files volume from Microsoft.NetApp provider
    """
    def __init__(__self__, *,
                 id: str):
        """
        An Azure NetApp Files volume from Microsoft.NetApp provider
        :param str id: Azure resource ID of the NetApp volume
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Azure resource ID of the NetApp volume
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PSCredentialExecutionParameterResponse(dict):
    """
    a powershell credential object
    """
    def __init__(__self__, *,
                 name: str,
                 type: str,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        a powershell credential object
        :param str name: The parameter name
        :param str type: The type of execution parameter
               Expected value is 'Credential'.
        :param str password: password for login
        :param str username: username for login
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'Credential')
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The parameter name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of execution parameter
        Expected value is 'Credential'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        password for login
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        username for login
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class PrivateCloudIdentityResponse(dict):
    """
    Identity for the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity for the virtual machine.
        :param str principal_id: The principal ID of private cloud identity. This property will only be provided for a system assigned identity.
        :param str tenant_id: The tenant ID associated with the private cloud. This property will only be provided for a system assigned identity.
        :param str type: The type of identity used for the private cloud. The type 'SystemAssigned' refers to an implicitly created identity. The type 'None' will remove any identities from the Private Cloud.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of private cloud identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID associated with the private cloud. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of identity used for the private cloud. The type 'SystemAssigned' refers to an implicitly created identity. The type 'None' will remove any identities from the Private Cloud.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ScriptSecureStringExecutionParameterResponse(dict):
    """
    a plain text value execution parameter
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secureValue":
            suggest = "secure_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScriptSecureStringExecutionParameterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScriptSecureStringExecutionParameterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScriptSecureStringExecutionParameterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 secure_value: Optional[str] = None):
        """
        a plain text value execution parameter
        :param str name: The parameter name
        :param str type: The type of execution parameter
               Expected value is 'SecureValue'.
        :param str secure_value: A secure value for the passed parameter, not to be stored in logs
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'SecureValue')
        if secure_value is not None:
            pulumi.set(__self__, "secure_value", secure_value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The parameter name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of execution parameter
        Expected value is 'SecureValue'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="secureValue")
    def secure_value(self) -> Optional[str]:
        """
        A secure value for the passed parameter, not to be stored in logs
        """
        return pulumi.get(self, "secure_value")


@pulumi.output_type
class ScriptStringExecutionParameterResponse(dict):
    """
    a plain text value execution parameter
    """
    def __init__(__self__, *,
                 name: str,
                 type: str,
                 value: Optional[str] = None):
        """
        a plain text value execution parameter
        :param str name: The parameter name
        :param str type: The type of execution parameter
               Expected value is 'Value'.
        :param str value: The value for the passed parameter
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'Value')
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The parameter name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of execution parameter
        Expected value is 'Value'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value for the passed parameter
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SkuResponse(dict):
    """
    The resource model definition representing SKU
    """
    def __init__(__self__, *,
                 name: str):
        """
        The resource model definition representing SKU
        :param str name: The name of the SKU.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class VmHostPlacementPolicyPropertiesResponse(dict):
    """
    VM-Host placement policy properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "affinityType":
            suggest = "affinity_type"
        elif key == "hostMembers":
            suggest = "host_members"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "vmMembers":
            suggest = "vm_members"
        elif key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmHostPlacementPolicyPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmHostPlacementPolicyPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmHostPlacementPolicyPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 affinity_type: str,
                 host_members: Sequence[str],
                 provisioning_state: str,
                 type: str,
                 vm_members: Sequence[str],
                 display_name: Optional[str] = None,
                 state: Optional[str] = None):
        """
        VM-Host placement policy properties
        :param str affinity_type: placement policy affinity type
        :param Sequence[str] host_members: Host members list
        :param str provisioning_state: The provisioning state
        :param str type: placement policy type
               Expected value is 'VmHost'.
        :param Sequence[str] vm_members: Virtual machine members list
        :param str display_name: Display name of the placement policy
        :param str state: Whether the placement policy is enabled or disabled
        """
        pulumi.set(__self__, "affinity_type", affinity_type)
        pulumi.set(__self__, "host_members", host_members)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", 'VmHost')
        pulumi.set(__self__, "vm_members", vm_members)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="affinityType")
    def affinity_type(self) -> str:
        """
        placement policy affinity type
        """
        return pulumi.get(self, "affinity_type")

    @property
    @pulumi.getter(name="hostMembers")
    def host_members(self) -> Sequence[str]:
        """
        Host members list
        """
        return pulumi.get(self, "host_members")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        placement policy type
        Expected value is 'VmHost'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vmMembers")
    def vm_members(self) -> Sequence[str]:
        """
        Virtual machine members list
        """
        return pulumi.get(self, "vm_members")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the placement policy
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Whether the placement policy is enabled or disabled
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class VmVmPlacementPolicyPropertiesResponse(dict):
    """
    VM-VM placement policy properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "affinityType":
            suggest = "affinity_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "vmMembers":
            suggest = "vm_members"
        elif key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmVmPlacementPolicyPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmVmPlacementPolicyPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmVmPlacementPolicyPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 affinity_type: str,
                 provisioning_state: str,
                 type: str,
                 vm_members: Sequence[str],
                 display_name: Optional[str] = None,
                 state: Optional[str] = None):
        """
        VM-VM placement policy properties
        :param str affinity_type: placement policy affinity type
        :param str provisioning_state: The provisioning state
        :param str type: placement policy type
               Expected value is 'VmVm'.
        :param Sequence[str] vm_members: Virtual machine members list
        :param str display_name: Display name of the placement policy
        :param str state: Whether the placement policy is enabled or disabled
        """
        pulumi.set(__self__, "affinity_type", affinity_type)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", 'VmVm')
        pulumi.set(__self__, "vm_members", vm_members)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="affinityType")
    def affinity_type(self) -> str:
        """
        placement policy affinity type
        """
        return pulumi.get(self, "affinity_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        placement policy type
        Expected value is 'VmVm'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vmMembers")
    def vm_members(self) -> Sequence[str]:
        """
        Virtual machine members list
        """
        return pulumi.get(self, "vm_members")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the placement policy
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Whether the placement policy is enabled or disabled
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class WorkloadNetworkDhcpRelayResponse(dict):
    """
    NSX DHCP Relay
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dhcpType":
            suggest = "dhcp_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "serverAddresses":
            suggest = "server_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadNetworkDhcpRelayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadNetworkDhcpRelayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadNetworkDhcpRelayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dhcp_type: str,
                 provisioning_state: str,
                 segments: Sequence[str],
                 display_name: Optional[str] = None,
                 revision: Optional[float] = None,
                 server_addresses: Optional[Sequence[str]] = None):
        """
        NSX DHCP Relay
        :param str dhcp_type: Type of DHCP: SERVER or RELAY.
               Expected value is 'RELAY'.
        :param str provisioning_state: The provisioning state
        :param Sequence[str] segments: NSX Segments consuming DHCP.
        :param str display_name: Display name of the DHCP entity.
        :param float revision: NSX revision number.
        :param Sequence[str] server_addresses: DHCP Relay Addresses. Max 3.
        """
        pulumi.set(__self__, "dhcp_type", 'RELAY')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "segments", segments)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if server_addresses is not None:
            pulumi.set(__self__, "server_addresses", server_addresses)

    @property
    @pulumi.getter(name="dhcpType")
    def dhcp_type(self) -> str:
        """
        Type of DHCP: SERVER or RELAY.
        Expected value is 'RELAY'.
        """
        return pulumi.get(self, "dhcp_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def segments(self) -> Sequence[str]:
        """
        NSX Segments consuming DHCP.
        """
        return pulumi.get(self, "segments")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the DHCP entity.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def revision(self) -> Optional[float]:
        """
        NSX revision number.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="serverAddresses")
    def server_addresses(self) -> Optional[Sequence[str]]:
        """
        DHCP Relay Addresses. Max 3.
        """
        return pulumi.get(self, "server_addresses")


@pulumi.output_type
class WorkloadNetworkDhcpServerResponse(dict):
    """
    NSX DHCP Server
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dhcpType":
            suggest = "dhcp_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "leaseTime":
            suggest = "lease_time"
        elif key == "serverAddress":
            suggest = "server_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadNetworkDhcpServerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadNetworkDhcpServerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadNetworkDhcpServerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dhcp_type: str,
                 provisioning_state: str,
                 segments: Sequence[str],
                 display_name: Optional[str] = None,
                 lease_time: Optional[float] = None,
                 revision: Optional[float] = None,
                 server_address: Optional[str] = None):
        """
        NSX DHCP Server
        :param str dhcp_type: Type of DHCP: SERVER or RELAY.
               Expected value is 'SERVER'.
        :param str provisioning_state: The provisioning state
        :param Sequence[str] segments: NSX Segments consuming DHCP.
        :param str display_name: Display name of the DHCP entity.
        :param float lease_time: DHCP Server Lease Time.
        :param float revision: NSX revision number.
        :param str server_address: DHCP Server Address.
        """
        pulumi.set(__self__, "dhcp_type", 'SERVER')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "segments", segments)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if lease_time is not None:
            pulumi.set(__self__, "lease_time", lease_time)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if server_address is not None:
            pulumi.set(__self__, "server_address", server_address)

    @property
    @pulumi.getter(name="dhcpType")
    def dhcp_type(self) -> str:
        """
        Type of DHCP: SERVER or RELAY.
        Expected value is 'SERVER'.
        """
        return pulumi.get(self, "dhcp_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def segments(self) -> Sequence[str]:
        """
        NSX Segments consuming DHCP.
        """
        return pulumi.get(self, "segments")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the DHCP entity.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="leaseTime")
    def lease_time(self) -> Optional[float]:
        """
        DHCP Server Lease Time.
        """
        return pulumi.get(self, "lease_time")

    @property
    @pulumi.getter
    def revision(self) -> Optional[float]:
        """
        NSX revision number.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="serverAddress")
    def server_address(self) -> Optional[str]:
        """
        DHCP Server Address.
        """
        return pulumi.get(self, "server_address")


@pulumi.output_type
class WorkloadNetworkSegmentPortVifResponse(dict):
    """
    Ports and any VIF attached to segment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portName":
            suggest = "port_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadNetworkSegmentPortVifResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadNetworkSegmentPortVifResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadNetworkSegmentPortVifResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port_name: Optional[str] = None):
        """
        Ports and any VIF attached to segment.
        :param str port_name: Name of port or VIF attached to segment.
        """
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[str]:
        """
        Name of port or VIF attached to segment.
        """
        return pulumi.get(self, "port_name")


@pulumi.output_type
class WorkloadNetworkSegmentSubnetResponse(dict):
    """
    Subnet configuration for segment
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dhcpRanges":
            suggest = "dhcp_ranges"
        elif key == "gatewayAddress":
            suggest = "gateway_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadNetworkSegmentSubnetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadNetworkSegmentSubnetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadNetworkSegmentSubnetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dhcp_ranges: Optional[Sequence[str]] = None,
                 gateway_address: Optional[str] = None):
        """
        Subnet configuration for segment
        :param Sequence[str] dhcp_ranges: DHCP Range assigned for subnet.
        :param str gateway_address: Gateway address.
        """
        if dhcp_ranges is not None:
            pulumi.set(__self__, "dhcp_ranges", dhcp_ranges)
        if gateway_address is not None:
            pulumi.set(__self__, "gateway_address", gateway_address)

    @property
    @pulumi.getter(name="dhcpRanges")
    def dhcp_ranges(self) -> Optional[Sequence[str]]:
        """
        DHCP Range assigned for subnet.
        """
        return pulumi.get(self, "dhcp_ranges")

    @property
    @pulumi.getter(name="gatewayAddress")
    def gateway_address(self) -> Optional[str]:
        """
        Gateway address.
        """
        return pulumi.get(self, "gateway_address")


