# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApiKeyResponse',
    'ResourceIdentityResponse',
    'SkuResponse',
    'UserIdentityResponse',
]

@pulumi.output_type
class ApiKeyResponse(dict):
    """
    An API key used for authenticating with a configuration store endpoint.
    """
    def __init__(__self__, *,
                 connection_string: str,
                 id: str,
                 last_modified: str,
                 name: str,
                 read_only: bool,
                 value: str):
        """
        An API key used for authenticating with a configuration store endpoint.
        :param str connection_string: A connection string that can be used by supporting clients for authentication.
        :param str id: The key ID.
        :param str last_modified: The last time any of the key's properties were modified.
        :param str name: A name for the key describing its usage.
        :param bool read_only: Whether this key can only be used for read operations.
        :param str value: The value of the key that is used for authentication purposes.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_modified", last_modified)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        A connection string that can be used by supporting clients for authentication.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The key ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> str:
        """
        The last time any of the key's properties were modified.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name for the key describing its usage.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> bool:
        """
        Whether this key can only be used for read operations.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the key that is used for authentication purposes.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ResourceIdentityResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserIdentityResponse']] = None):
        """
        :param str principal_id: The principal id of the identity. This property will only be provided for a system-assigned identity.
        :param str tenant_id: The tenant id associated with the resource's identity. This property will only be provided for a system-assigned identity.
        :param str type: The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
        :param Mapping[str, 'UserIdentityResponse'] user_assigned_identities: The list of user-assigned identities associated with the resource. The user-assigned identity dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of the identity. This property will only be provided for a system-assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id associated with the resource's identity. This property will only be provided for a system-assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserIdentityResponse']]:
        """
        The list of user-assigned identities associated with the resource. The user-assigned identity dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class SkuResponse(dict):
    """
    Describes a configuration store SKU.
    """
    def __init__(__self__, *,
                 name: str):
        """
        Describes a configuration store SKU.
        :param str name: The SKU name of the configuration store.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The SKU name of the configuration store.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class UserIdentityResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        :param str client_id: The client ID of the user-assigned identity.
        :param str principal_id: The principal ID of the user-assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID of the user-assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the user-assigned identity.
        """
        return pulumi.get(self, "principal_id")


