# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = ['IPv6FirewallRuleArgs', 'IPv6FirewallRule']

@pulumi.input_type
class IPv6FirewallRuleArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 server_name: pulumi.Input[str],
                 end_i_pv6_address: Optional[pulumi.Input[str]] = None,
                 firewall_rule_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 start_i_pv6_address: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IPv6FirewallRule resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        :param pulumi.Input[str] server_name: The name of the server.
        :param pulumi.Input[str] end_i_pv6_address: The end IP address of the firewall rule. Must be IPv6 format. Must be greater than or equal to startIpAddress.
        :param pulumi.Input[str] firewall_rule_name: The name of the firewall rule.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[str] start_i_pv6_address: The start IP address of the firewall rule. Must be IPv6 format.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "server_name", server_name)
        if end_i_pv6_address is not None:
            pulumi.set(__self__, "end_i_pv6_address", end_i_pv6_address)
        if firewall_rule_name is not None:
            pulumi.set(__self__, "firewall_rule_name", firewall_rule_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if start_i_pv6_address is not None:
            pulumi.set(__self__, "start_i_pv6_address", start_i_pv6_address)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="endIPv6Address")
    def end_i_pv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        The end IP address of the firewall rule. Must be IPv6 format. Must be greater than or equal to startIpAddress.
        """
        return pulumi.get(self, "end_i_pv6_address")

    @end_i_pv6_address.setter
    def end_i_pv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_i_pv6_address", value)

    @property
    @pulumi.getter(name="firewallRuleName")
    def firewall_rule_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the firewall rule.
        """
        return pulumi.get(self, "firewall_rule_name")

    @firewall_rule_name.setter
    def firewall_rule_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_rule_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="startIPv6Address")
    def start_i_pv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        The start IP address of the firewall rule. Must be IPv6 format.
        """
        return pulumi.get(self, "start_i_pv6_address")

    @start_i_pv6_address.setter
    def start_i_pv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_i_pv6_address", value)


class IPv6FirewallRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 end_i_pv6_address: Optional[pulumi.Input[str]] = None,
                 firewall_rule_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 start_i_pv6_address: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        An IPv6 server firewall rule.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] end_i_pv6_address: The end IP address of the firewall rule. Must be IPv6 format. Must be greater than or equal to startIpAddress.
        :param pulumi.Input[str] firewall_rule_name: The name of the firewall rule.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[str] resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        :param pulumi.Input[str] server_name: The name of the server.
        :param pulumi.Input[str] start_i_pv6_address: The start IP address of the firewall rule. Must be IPv6 format.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IPv6FirewallRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An IPv6 server firewall rule.

        :param str resource_name: The name of the resource.
        :param IPv6FirewallRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IPv6FirewallRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 end_i_pv6_address: Optional[pulumi.Input[str]] = None,
                 firewall_rule_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 start_i_pv6_address: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IPv6FirewallRuleArgs.__new__(IPv6FirewallRuleArgs)

            __props__.__dict__["end_i_pv6_address"] = end_i_pv6_address
            __props__.__dict__["firewall_rule_name"] = firewall_rule_name
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if server_name is None and not opts.urn:
                raise TypeError("Missing required property 'server_name'")
            __props__.__dict__["server_name"] = server_name
            __props__.__dict__["start_i_pv6_address"] = start_i_pv6_address
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:sql:IPv6FirewallRule"), pulumi.Alias(type_="azure-native:sql/v20210801preview:IPv6FirewallRule"), pulumi.Alias(type_="azure-native:sql/v20211101preview:IPv6FirewallRule"), pulumi.Alias(type_="azure-native:sql/v20220201preview:IPv6FirewallRule"), pulumi.Alias(type_="azure-native:sql/v20220501preview:IPv6FirewallRule"), pulumi.Alias(type_="azure-native:sql/v20220801preview:IPv6FirewallRule")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(IPv6FirewallRule, __self__).__init__(
            'azure-native:sql/v20211101:IPv6FirewallRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'IPv6FirewallRule':
        """
        Get an existing IPv6FirewallRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IPv6FirewallRuleArgs.__new__(IPv6FirewallRuleArgs)

        __props__.__dict__["end_i_pv6_address"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["start_i_pv6_address"] = None
        __props__.__dict__["type"] = None
        return IPv6FirewallRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="endIPv6Address")
    def end_i_pv6_address(self) -> pulumi.Output[Optional[str]]:
        """
        The end IP address of the firewall rule. Must be IPv6 format. Must be greater than or equal to startIpAddress.
        """
        return pulumi.get(self, "end_i_pv6_address")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="startIPv6Address")
    def start_i_pv6_address(self) -> pulumi.Output[Optional[str]]:
        """
        The start IP address of the firewall rule. Must be IPv6 format.
        """
        return pulumi.get(self, "start_i_pv6_address")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

