# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = ['ExtendedServerBlobAuditingPolicyArgs', 'ExtendedServerBlobAuditingPolicy']

@pulumi.input_type
class ExtendedServerBlobAuditingPolicyArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 server_name: pulumi.Input[str],
                 state: pulumi.Input['BlobAuditingPolicyState'],
                 audit_actions_and_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blob_auditing_policy_name: Optional[pulumi.Input[str]] = None,
                 is_azure_monitor_target_enabled: Optional[pulumi.Input[bool]] = None,
                 is_storage_secondary_key_in_use: Optional[pulumi.Input[bool]] = None,
                 predicate_expression: Optional[pulumi.Input[str]] = None,
                 queue_delay_ms: Optional[pulumi.Input[int]] = None,
                 retention_days: Optional[pulumi.Input[int]] = None,
                 storage_account_access_key: Optional[pulumi.Input[str]] = None,
                 storage_account_subscription_id: Optional[pulumi.Input[str]] = None,
                 storage_endpoint: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ExtendedServerBlobAuditingPolicy resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        :param pulumi.Input[str] server_name: The name of the server.
        :param pulumi.Input['BlobAuditingPolicyState'] state: Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.
               
               The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
               
               BATCH_COMPLETED_GROUP,
               SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
               FAILED_DATABASE_AUTHENTICATION_GROUP.
               
               This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
               
               The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
               
               APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
               BACKUP_RESTORE_GROUP
               DATABASE_LOGOUT_GROUP
               DATABASE_OBJECT_CHANGE_GROUP
               DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
               DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
               DATABASE_OPERATION_GROUP
               DATABASE_PERMISSION_CHANGE_GROUP
               DATABASE_PRINCIPAL_CHANGE_GROUP
               DATABASE_PRINCIPAL_IMPERSONATION_GROUP
               DATABASE_ROLE_MEMBER_CHANGE_GROUP
               FAILED_DATABASE_AUTHENTICATION_GROUP
               SCHEMA_OBJECT_ACCESS_GROUP
               SCHEMA_OBJECT_CHANGE_GROUP
               SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
               SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
               SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
               USER_CHANGE_PASSWORD_GROUP
               BATCH_STARTED_GROUP
               BATCH_COMPLETED_GROUP
               DBCC_GROUP
               DATABASE_OWNERSHIP_CHANGE_GROUP
               DATABASE_CHANGE_GROUP
               
               These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
               
               For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
               
               For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
               SELECT
               UPDATE
               INSERT
               DELETE
               EXECUTE
               RECEIVE
               REFERENCES
               
               The general form for defining an action to be audited is:
               {action} ON {object} BY {principal}
               
               Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
               
               For example:
               SELECT on dbo.myTable by public
               SELECT on DATABASE::myDatabase by public
               SELECT on SCHEMA::mySchema by public
               
               For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
        :param pulumi.Input[str] blob_auditing_policy_name: The name of the blob auditing policy.
        :param pulumi.Input[bool] is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure Monitor. 
               In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
               
               When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
               Note that for server level audit you should use the 'master' database as {databaseName}.
               
               Diagnostic Settings URI format:
               PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
               
               For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
               or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
        :param pulumi.Input[bool] is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is the storage's secondary key.
        :param pulumi.Input[str] predicate_expression: Specifies condition of where clause when creating an audit.
        :param pulumi.Input[int] queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
               The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
        :param pulumi.Input[int] retention_days: Specifies the number of days to keep in the audit logs in the storage account.
        :param pulumi.Input[str] storage_account_access_key: Specifies the identifier key of the auditing storage account. 
               If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
               Prerequisites for using managed identity authentication:
               1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
               2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
               For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
        :param pulumi.Input[str] storage_account_subscription_id: Specifies the blob storage subscription Id.
        :param pulumi.Input[str] storage_endpoint: Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "state", state)
        if audit_actions_and_groups is not None:
            pulumi.set(__self__, "audit_actions_and_groups", audit_actions_and_groups)
        if blob_auditing_policy_name is not None:
            pulumi.set(__self__, "blob_auditing_policy_name", blob_auditing_policy_name)
        if is_azure_monitor_target_enabled is not None:
            pulumi.set(__self__, "is_azure_monitor_target_enabled", is_azure_monitor_target_enabled)
        if is_storage_secondary_key_in_use is not None:
            pulumi.set(__self__, "is_storage_secondary_key_in_use", is_storage_secondary_key_in_use)
        if predicate_expression is not None:
            pulumi.set(__self__, "predicate_expression", predicate_expression)
        if queue_delay_ms is not None:
            pulumi.set(__self__, "queue_delay_ms", queue_delay_ms)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_account_subscription_id is not None:
            pulumi.set(__self__, "storage_account_subscription_id", storage_account_subscription_id)
        if storage_endpoint is not None:
            pulumi.set(__self__, "storage_endpoint", storage_endpoint)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input['BlobAuditingPolicyState']:
        """
        Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input['BlobAuditingPolicyState']):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="auditActionsAndGroups")
    def audit_actions_and_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the Actions-Groups and Actions to audit.
        
        The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
        
        BATCH_COMPLETED_GROUP,
        SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
        FAILED_DATABASE_AUTHENTICATION_GROUP.
        
        This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
        
        The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
        
        APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
        BACKUP_RESTORE_GROUP
        DATABASE_LOGOUT_GROUP
        DATABASE_OBJECT_CHANGE_GROUP
        DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
        DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
        DATABASE_OPERATION_GROUP
        DATABASE_PERMISSION_CHANGE_GROUP
        DATABASE_PRINCIPAL_CHANGE_GROUP
        DATABASE_PRINCIPAL_IMPERSONATION_GROUP
        DATABASE_ROLE_MEMBER_CHANGE_GROUP
        FAILED_DATABASE_AUTHENTICATION_GROUP
        SCHEMA_OBJECT_ACCESS_GROUP
        SCHEMA_OBJECT_CHANGE_GROUP
        SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
        SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
        SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
        USER_CHANGE_PASSWORD_GROUP
        BATCH_STARTED_GROUP
        BATCH_COMPLETED_GROUP
        DBCC_GROUP
        DATABASE_OWNERSHIP_CHANGE_GROUP
        DATABASE_CHANGE_GROUP
        
        These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
        
        For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
        
        For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
        SELECT
        UPDATE
        INSERT
        DELETE
        EXECUTE
        RECEIVE
        REFERENCES
        
        The general form for defining an action to be audited is:
        {action} ON {object} BY {principal}
        
        Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
        
        For example:
        SELECT on dbo.myTable by public
        SELECT on DATABASE::myDatabase by public
        SELECT on SCHEMA::mySchema by public
        
        For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
        """
        return pulumi.get(self, "audit_actions_and_groups")

    @audit_actions_and_groups.setter
    def audit_actions_and_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "audit_actions_and_groups", value)

    @property
    @pulumi.getter(name="blobAuditingPolicyName")
    def blob_auditing_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the blob auditing policy.
        """
        return pulumi.get(self, "blob_auditing_policy_name")

    @blob_auditing_policy_name.setter
    def blob_auditing_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "blob_auditing_policy_name", value)

    @property
    @pulumi.getter(name="isAzureMonitorTargetEnabled")
    def is_azure_monitor_target_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether audit events are sent to Azure Monitor. 
        In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
        
        When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
        Note that for server level audit you should use the 'master' database as {databaseName}.
        
        Diagnostic Settings URI format:
        PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
        
        For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
        or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
        """
        return pulumi.get(self, "is_azure_monitor_target_enabled")

    @is_azure_monitor_target_enabled.setter
    def is_azure_monitor_target_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_azure_monitor_target_enabled", value)

    @property
    @pulumi.getter(name="isStorageSecondaryKeyInUse")
    def is_storage_secondary_key_in_use(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether storageAccountAccessKey value is the storage's secondary key.
        """
        return pulumi.get(self, "is_storage_secondary_key_in_use")

    @is_storage_secondary_key_in_use.setter
    def is_storage_secondary_key_in_use(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_storage_secondary_key_in_use", value)

    @property
    @pulumi.getter(name="predicateExpression")
    def predicate_expression(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies condition of where clause when creating an audit.
        """
        return pulumi.get(self, "predicate_expression")

    @predicate_expression.setter
    def predicate_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "predicate_expression", value)

    @property
    @pulumi.getter(name="queueDelayMs")
    def queue_delay_ms(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
        The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
        """
        return pulumi.get(self, "queue_delay_ms")

    @queue_delay_ms.setter
    def queue_delay_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queue_delay_ms", value)

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days to keep in the audit logs in the storage account.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_days", value)

    @property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier key of the auditing storage account. 
        If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
        Prerequisites for using managed identity authentication:
        1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
        2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
        For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @property
    @pulumi.getter(name="storageAccountSubscriptionId")
    def storage_account_subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the blob storage subscription Id.
        """
        return pulumi.get(self, "storage_account_subscription_id")

    @storage_account_subscription_id.setter
    def storage_account_subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_subscription_id", value)

    @property
    @pulumi.getter(name="storageEndpoint")
    def storage_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
        """
        return pulumi.get(self, "storage_endpoint")

    @storage_endpoint.setter
    def storage_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_endpoint", value)


class ExtendedServerBlobAuditingPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_actions_and_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blob_auditing_policy_name: Optional[pulumi.Input[str]] = None,
                 is_azure_monitor_target_enabled: Optional[pulumi.Input[bool]] = None,
                 is_storage_secondary_key_in_use: Optional[pulumi.Input[bool]] = None,
                 predicate_expression: Optional[pulumi.Input[str]] = None,
                 queue_delay_ms: Optional[pulumi.Input[int]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 retention_days: Optional[pulumi.Input[int]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['BlobAuditingPolicyState']] = None,
                 storage_account_access_key: Optional[pulumi.Input[str]] = None,
                 storage_account_subscription_id: Optional[pulumi.Input[str]] = None,
                 storage_endpoint: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        An extended server blob auditing policy.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.
               
               The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
               
               BATCH_COMPLETED_GROUP,
               SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
               FAILED_DATABASE_AUTHENTICATION_GROUP.
               
               This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
               
               The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
               
               APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
               BACKUP_RESTORE_GROUP
               DATABASE_LOGOUT_GROUP
               DATABASE_OBJECT_CHANGE_GROUP
               DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
               DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
               DATABASE_OPERATION_GROUP
               DATABASE_PERMISSION_CHANGE_GROUP
               DATABASE_PRINCIPAL_CHANGE_GROUP
               DATABASE_PRINCIPAL_IMPERSONATION_GROUP
               DATABASE_ROLE_MEMBER_CHANGE_GROUP
               FAILED_DATABASE_AUTHENTICATION_GROUP
               SCHEMA_OBJECT_ACCESS_GROUP
               SCHEMA_OBJECT_CHANGE_GROUP
               SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
               SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
               SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
               USER_CHANGE_PASSWORD_GROUP
               BATCH_STARTED_GROUP
               BATCH_COMPLETED_GROUP
               DBCC_GROUP
               DATABASE_OWNERSHIP_CHANGE_GROUP
               DATABASE_CHANGE_GROUP
               
               These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
               
               For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
               
               For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
               SELECT
               UPDATE
               INSERT
               DELETE
               EXECUTE
               RECEIVE
               REFERENCES
               
               The general form for defining an action to be audited is:
               {action} ON {object} BY {principal}
               
               Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
               
               For example:
               SELECT on dbo.myTable by public
               SELECT on DATABASE::myDatabase by public
               SELECT on SCHEMA::mySchema by public
               
               For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
        :param pulumi.Input[str] blob_auditing_policy_name: The name of the blob auditing policy.
        :param pulumi.Input[bool] is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure Monitor. 
               In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
               
               When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
               Note that for server level audit you should use the 'master' database as {databaseName}.
               
               Diagnostic Settings URI format:
               PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
               
               For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
               or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
        :param pulumi.Input[bool] is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is the storage's secondary key.
        :param pulumi.Input[str] predicate_expression: Specifies condition of where clause when creating an audit.
        :param pulumi.Input[int] queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
               The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
        :param pulumi.Input[str] resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        :param pulumi.Input[int] retention_days: Specifies the number of days to keep in the audit logs in the storage account.
        :param pulumi.Input[str] server_name: The name of the server.
        :param pulumi.Input['BlobAuditingPolicyState'] state: Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
        :param pulumi.Input[str] storage_account_access_key: Specifies the identifier key of the auditing storage account. 
               If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
               Prerequisites for using managed identity authentication:
               1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
               2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
               For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
        :param pulumi.Input[str] storage_account_subscription_id: Specifies the blob storage subscription Id.
        :param pulumi.Input[str] storage_endpoint: Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExtendedServerBlobAuditingPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An extended server blob auditing policy.

        :param str resource_name: The name of the resource.
        :param ExtendedServerBlobAuditingPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExtendedServerBlobAuditingPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_actions_and_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blob_auditing_policy_name: Optional[pulumi.Input[str]] = None,
                 is_azure_monitor_target_enabled: Optional[pulumi.Input[bool]] = None,
                 is_storage_secondary_key_in_use: Optional[pulumi.Input[bool]] = None,
                 predicate_expression: Optional[pulumi.Input[str]] = None,
                 queue_delay_ms: Optional[pulumi.Input[int]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 retention_days: Optional[pulumi.Input[int]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['BlobAuditingPolicyState']] = None,
                 storage_account_access_key: Optional[pulumi.Input[str]] = None,
                 storage_account_subscription_id: Optional[pulumi.Input[str]] = None,
                 storage_endpoint: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExtendedServerBlobAuditingPolicyArgs.__new__(ExtendedServerBlobAuditingPolicyArgs)

            __props__.__dict__["audit_actions_and_groups"] = audit_actions_and_groups
            __props__.__dict__["blob_auditing_policy_name"] = blob_auditing_policy_name
            __props__.__dict__["is_azure_monitor_target_enabled"] = is_azure_monitor_target_enabled
            __props__.__dict__["is_storage_secondary_key_in_use"] = is_storage_secondary_key_in_use
            __props__.__dict__["predicate_expression"] = predicate_expression
            __props__.__dict__["queue_delay_ms"] = queue_delay_ms
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["retention_days"] = retention_days
            if server_name is None and not opts.urn:
                raise TypeError("Missing required property 'server_name'")
            __props__.__dict__["server_name"] = server_name
            if state is None and not opts.urn:
                raise TypeError("Missing required property 'state'")
            __props__.__dict__["state"] = state
            __props__.__dict__["storage_account_access_key"] = storage_account_access_key
            __props__.__dict__["storage_account_subscription_id"] = storage_account_subscription_id
            __props__.__dict__["storage_endpoint"] = storage_endpoint
            __props__.__dict__["name"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:sql:ExtendedServerBlobAuditingPolicy"), pulumi.Alias(type_="azure-native:sql/v20200202preview:ExtendedServerBlobAuditingPolicy"), pulumi.Alias(type_="azure-native:sql/v20200801preview:ExtendedServerBlobAuditingPolicy"), pulumi.Alias(type_="azure-native:sql/v20201101preview:ExtendedServerBlobAuditingPolicy"), pulumi.Alias(type_="azure-native:sql/v20210201preview:ExtendedServerBlobAuditingPolicy"), pulumi.Alias(type_="azure-native:sql/v20210501preview:ExtendedServerBlobAuditingPolicy"), pulumi.Alias(type_="azure-native:sql/v20210801preview:ExtendedServerBlobAuditingPolicy"), pulumi.Alias(type_="azure-native:sql/v20211101:ExtendedServerBlobAuditingPolicy"), pulumi.Alias(type_="azure-native:sql/v20211101preview:ExtendedServerBlobAuditingPolicy"), pulumi.Alias(type_="azure-native:sql/v20220201preview:ExtendedServerBlobAuditingPolicy"), pulumi.Alias(type_="azure-native:sql/v20220501preview:ExtendedServerBlobAuditingPolicy"), pulumi.Alias(type_="azure-native:sql/v20220801preview:ExtendedServerBlobAuditingPolicy")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ExtendedServerBlobAuditingPolicy, __self__).__init__(
            'azure-native:sql/v20170301preview:ExtendedServerBlobAuditingPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ExtendedServerBlobAuditingPolicy':
        """
        Get an existing ExtendedServerBlobAuditingPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ExtendedServerBlobAuditingPolicyArgs.__new__(ExtendedServerBlobAuditingPolicyArgs)

        __props__.__dict__["audit_actions_and_groups"] = None
        __props__.__dict__["is_azure_monitor_target_enabled"] = None
        __props__.__dict__["is_storage_secondary_key_in_use"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["predicate_expression"] = None
        __props__.__dict__["queue_delay_ms"] = None
        __props__.__dict__["retention_days"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["storage_account_subscription_id"] = None
        __props__.__dict__["storage_endpoint"] = None
        __props__.__dict__["type"] = None
        return ExtendedServerBlobAuditingPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="auditActionsAndGroups")
    def audit_actions_and_groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies the Actions-Groups and Actions to audit.
        
        The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
        
        BATCH_COMPLETED_GROUP,
        SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
        FAILED_DATABASE_AUTHENTICATION_GROUP.
        
        This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
        
        The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
        
        APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
        BACKUP_RESTORE_GROUP
        DATABASE_LOGOUT_GROUP
        DATABASE_OBJECT_CHANGE_GROUP
        DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
        DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
        DATABASE_OPERATION_GROUP
        DATABASE_PERMISSION_CHANGE_GROUP
        DATABASE_PRINCIPAL_CHANGE_GROUP
        DATABASE_PRINCIPAL_IMPERSONATION_GROUP
        DATABASE_ROLE_MEMBER_CHANGE_GROUP
        FAILED_DATABASE_AUTHENTICATION_GROUP
        SCHEMA_OBJECT_ACCESS_GROUP
        SCHEMA_OBJECT_CHANGE_GROUP
        SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
        SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
        SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
        USER_CHANGE_PASSWORD_GROUP
        BATCH_STARTED_GROUP
        BATCH_COMPLETED_GROUP
        DBCC_GROUP
        DATABASE_OWNERSHIP_CHANGE_GROUP
        DATABASE_CHANGE_GROUP
        
        These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
        
        For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
        
        For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
        SELECT
        UPDATE
        INSERT
        DELETE
        EXECUTE
        RECEIVE
        REFERENCES
        
        The general form for defining an action to be audited is:
        {action} ON {object} BY {principal}
        
        Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
        
        For example:
        SELECT on dbo.myTable by public
        SELECT on DATABASE::myDatabase by public
        SELECT on SCHEMA::mySchema by public
        
        For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
        """
        return pulumi.get(self, "audit_actions_and_groups")

    @property
    @pulumi.getter(name="isAzureMonitorTargetEnabled")
    def is_azure_monitor_target_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether audit events are sent to Azure Monitor. 
        In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
        
        When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
        Note that for server level audit you should use the 'master' database as {databaseName}.
        
        Diagnostic Settings URI format:
        PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
        
        For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
        or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
        """
        return pulumi.get(self, "is_azure_monitor_target_enabled")

    @property
    @pulumi.getter(name="isStorageSecondaryKeyInUse")
    def is_storage_secondary_key_in_use(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether storageAccountAccessKey value is the storage's secondary key.
        """
        return pulumi.get(self, "is_storage_secondary_key_in_use")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="predicateExpression")
    def predicate_expression(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies condition of where clause when creating an audit.
        """
        return pulumi.get(self, "predicate_expression")

    @property
    @pulumi.getter(name="queueDelayMs")
    def queue_delay_ms(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
        The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
        """
        return pulumi.get(self, "queue_delay_ms")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the number of days to keep in the audit logs in the storage account.
        """
        return pulumi.get(self, "retention_days")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageAccountSubscriptionId")
    def storage_account_subscription_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the blob storage subscription Id.
        """
        return pulumi.get(self, "storage_account_subscription_id")

    @property
    @pulumi.getter(name="storageEndpoint")
    def storage_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
        """
        return pulumi.get(self, "storage_endpoint")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

