# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = ['SqlVulnerabilityAssessmentBaselineRuleArgs', 'SqlVulnerabilityAssessmentBaselineRule']

@pulumi.input_type
class SqlVulnerabilityAssessmentBaselineRuleArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[str],
                 workspace_id: pulumi.Input[str],
                 latest_scan: Optional[pulumi.Input[bool]] = None,
                 results: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SqlVulnerabilityAssessmentBaselineRule resource.
        :param pulumi.Input[str] resource_id: The identifier of the resource.
        :param pulumi.Input[str] workspace_id: The workspace Id.
        :param pulumi.Input[bool] latest_scan: Take results from latest scan.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]] results: Expected results to be inserted into the baseline.
               Leave this field empty it LatestScan == true.
        :param pulumi.Input[str] rule_id: The rule Id.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if latest_scan is not None:
            pulumi.set(__self__, "latest_scan", latest_scan)
        if results is not None:
            pulumi.set(__self__, "results", results)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The identifier of the resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        The workspace Id.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter(name="latestScan")
    def latest_scan(self) -> Optional[pulumi.Input[bool]]:
        """
        Take results from latest scan.
        """
        return pulumi.get(self, "latest_scan")

    @latest_scan.setter
    def latest_scan(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "latest_scan", value)

    @property
    @pulumi.getter
    def results(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]]:
        """
        Expected results to be inserted into the baseline.
        Leave this field empty it LatestScan == true.
        """
        return pulumi.get(self, "results")

    @results.setter
    def results(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]]):
        pulumi.set(self, "results", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[str]]:
        """
        The rule Id.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_id", value)


class SqlVulnerabilityAssessmentBaselineRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 latest_scan: Optional[pulumi.Input[bool]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 results: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Rule results.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] latest_scan: Take results from latest scan.
        :param pulumi.Input[str] resource_id: The identifier of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]] results: Expected results to be inserted into the baseline.
               Leave this field empty it LatestScan == true.
        :param pulumi.Input[str] rule_id: The rule Id.
        :param pulumi.Input[str] workspace_id: The workspace Id.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlVulnerabilityAssessmentBaselineRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Rule results.

        :param str resource_name: The name of the resource.
        :param SqlVulnerabilityAssessmentBaselineRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlVulnerabilityAssessmentBaselineRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 latest_scan: Optional[pulumi.Input[bool]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 results: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlVulnerabilityAssessmentBaselineRuleArgs.__new__(SqlVulnerabilityAssessmentBaselineRuleArgs)

            __props__.__dict__["latest_scan"] = latest_scan
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            __props__.__dict__["results"] = results
            __props__.__dict__["rule_id"] = rule_id
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["name"] = None
            __props__.__dict__["properties"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:security:SqlVulnerabilityAssessmentBaselineRule"), pulumi.Alias(type_="azure-native:security/v20200701preview:SqlVulnerabilityAssessmentBaselineRule")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(SqlVulnerabilityAssessmentBaselineRule, __self__).__init__(
            'azure-native:security/v20230201preview:SqlVulnerabilityAssessmentBaselineRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SqlVulnerabilityAssessmentBaselineRule':
        """
        Get an existing SqlVulnerabilityAssessmentBaselineRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SqlVulnerabilityAssessmentBaselineRuleArgs.__new__(SqlVulnerabilityAssessmentBaselineRuleArgs)

        __props__.__dict__["name"] = None
        __props__.__dict__["properties"] = None
        __props__.__dict__["type"] = None
        return SqlVulnerabilityAssessmentBaselineRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output['outputs.RuleResultsPropertiesResponse']:
        """
        Rule results properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

