# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetProfessionalServiceSubscriptionLevelResult',
    'AwaitableGetProfessionalServiceSubscriptionLevelResult',
    'get_professional_service_subscription_level',
    'get_professional_service_subscription_level_output',
]

@pulumi.output_type
class GetProfessionalServiceSubscriptionLevelResult:
    """
    ProfessionalService REST API resource definition.
    """
    def __init__(__self__, id=None, name=None, properties=None, tags=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if properties and not isinstance(properties, dict):
            raise TypeError("Expected argument 'properties' to be a dict")
        pulumi.set(__self__, "properties", properties)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource uri
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.ProfessionalServiceResourceResponseProperties':
        """
        professionalService properties
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        the resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")


class AwaitableGetProfessionalServiceSubscriptionLevelResult(GetProfessionalServiceSubscriptionLevelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProfessionalServiceSubscriptionLevelResult(
            id=self.id,
            name=self.name,
            properties=self.properties,
            tags=self.tags,
            type=self.type)


def get_professional_service_subscription_level(resource_group_name: Optional[str] = None,
                                                resource_name: Optional[str] = None,
                                                subscription_id: Optional[str] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProfessionalServiceSubscriptionLevelResult:
    """
    Gets information about the specified Subscription Level ProfessionalService.


    :param str resource_group_name: The name of the resource group.
    :param str resource_name: The name of the resource.
    :param str subscription_id: The Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
    """
    __args__ = dict()
    __args__['resourceGroupName'] = resource_group_name
    __args__['resourceName'] = resource_name
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:professionalservice/v20230701preview:getProfessionalServiceSubscriptionLevel', __args__, opts=opts, typ=GetProfessionalServiceSubscriptionLevelResult).value

    return AwaitableGetProfessionalServiceSubscriptionLevelResult(
        id=__ret__.id,
        name=__ret__.name,
        properties=__ret__.properties,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_professional_service_subscription_level)
def get_professional_service_subscription_level_output(resource_group_name: Optional[pulumi.Input[str]] = None,
                                                       resource_name: Optional[pulumi.Input[str]] = None,
                                                       subscription_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProfessionalServiceSubscriptionLevelResult]:
    """
    Gets information about the specified Subscription Level ProfessionalService.


    :param str resource_group_name: The name of the resource group.
    :param str resource_name: The name of the resource.
    :param str subscription_id: The Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
    """
    ...
