# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['VirtualMachineArgs', 'VirtualMachine']

@pulumi.input_type
class VirtualMachineArgs:
    def __init__(__self__, *,
                 admin_username: pulumi.Input[str],
                 cloud_services_network_attachment: pulumi.Input['NetworkAttachmentArgs'],
                 cpu_cores: pulumi.Input[float],
                 extended_location: pulumi.Input['ExtendedLocationArgs'],
                 memory_size_gb: pulumi.Input[float],
                 resource_group_name: pulumi.Input[str],
                 storage_profile: pulumi.Input['StorageProfileArgs'],
                 vm_image: pulumi.Input[str],
                 boot_method: Optional[pulumi.Input[Union[str, 'VirtualMachineBootMethod']]] = None,
                 isolate_emulator_thread: Optional[pulumi.Input[Union[str, 'VirtualMachineIsolateEmulatorThread']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 network_attachments: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAttachmentArgs']]]] = None,
                 network_data: Optional[pulumi.Input[str]] = None,
                 placement_hints: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachinePlacementHintArgs']]]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 virtio_interface: Optional[pulumi.Input[Union[str, 'VirtualMachineVirtioInterfaceType']]] = None,
                 virtual_machine_name: Optional[pulumi.Input[str]] = None,
                 vm_device_model: Optional[pulumi.Input[Union[str, 'VirtualMachineDeviceModelType']]] = None,
                 vm_image_repository_credentials: Optional[pulumi.Input['ImageRepositoryCredentialsArgs']] = None):
        """
        The set of arguments for constructing a VirtualMachine resource.
        :param pulumi.Input[str] admin_username: The name of the administrator to which the ssh public keys will be added into the authorized keys.
        :param pulumi.Input[float] cpu_cores: The number of CPU cores in the virtual machine.
        :param pulumi.Input['ExtendedLocationArgs'] extended_location: The extended location of the cluster associated with the resource.
        :param pulumi.Input[float] memory_size_gb: The memory size of the virtual machine in GB.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] vm_image: The virtual machine image that is currently provisioned to the OS disk, using the full url and tag notation used to pull the image.
        :param pulumi.Input[Union[str, 'VirtualMachineBootMethod']] boot_method: Selects the boot method for the virtual machine.
        :param pulumi.Input[Union[str, 'VirtualMachineIsolateEmulatorThread']] isolate_emulator_thread: Field Deprecated, the value will be ignored if provided. The indicator of whether one of the specified CPU cores is isolated to run the emulator thread for this virtual machine.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAttachmentArgs']]] network_attachments: The list of network attachments to the virtual machine.
        :param pulumi.Input[str] network_data: The Base64 encoded cloud-init network data.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachinePlacementHintArgs']]] placement_hints: The scheduling hints for the virtual machine.
        :param pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]] ssh_public_keys: The list of ssh public keys. Each key will be added to the virtual machine using the cloud-init ssh_authorized_keys mechanism for the adminUsername.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[str] user_data: The Base64 encoded cloud-init user data.
        :param pulumi.Input[Union[str, 'VirtualMachineVirtioInterfaceType']] virtio_interface: Field Deprecated, use virtualizationModel instead. The type of the virtio interface.
        :param pulumi.Input[str] virtual_machine_name: The name of the virtual machine.
        :param pulumi.Input[Union[str, 'VirtualMachineDeviceModelType']] vm_device_model: The type of the device model to use.
        """
        pulumi.set(__self__, "admin_username", admin_username)
        pulumi.set(__self__, "cloud_services_network_attachment", cloud_services_network_attachment)
        pulumi.set(__self__, "cpu_cores", cpu_cores)
        pulumi.set(__self__, "extended_location", extended_location)
        pulumi.set(__self__, "memory_size_gb", memory_size_gb)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "storage_profile", storage_profile)
        pulumi.set(__self__, "vm_image", vm_image)
        if boot_method is None:
            boot_method = 'UEFI'
        if boot_method is not None:
            pulumi.set(__self__, "boot_method", boot_method)
        if isolate_emulator_thread is None:
            isolate_emulator_thread = 'True'
        if isolate_emulator_thread is not None:
            pulumi.set(__self__, "isolate_emulator_thread", isolate_emulator_thread)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if network_attachments is not None:
            pulumi.set(__self__, "network_attachments", network_attachments)
        if network_data is not None:
            pulumi.set(__self__, "network_data", network_data)
        if placement_hints is not None:
            pulumi.set(__self__, "placement_hints", placement_hints)
        if ssh_public_keys is not None:
            pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if virtio_interface is None:
            virtio_interface = 'Modern'
        if virtio_interface is not None:
            pulumi.set(__self__, "virtio_interface", virtio_interface)
        if virtual_machine_name is not None:
            pulumi.set(__self__, "virtual_machine_name", virtual_machine_name)
        if vm_device_model is None:
            vm_device_model = 'T2'
        if vm_device_model is not None:
            pulumi.set(__self__, "vm_device_model", vm_device_model)
        if vm_image_repository_credentials is not None:
            pulumi.set(__self__, "vm_image_repository_credentials", vm_image_repository_credentials)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Input[str]:
        """
        The name of the administrator to which the ssh public keys will be added into the authorized keys.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="cloudServicesNetworkAttachment")
    def cloud_services_network_attachment(self) -> pulumi.Input['NetworkAttachmentArgs']:
        return pulumi.get(self, "cloud_services_network_attachment")

    @cloud_services_network_attachment.setter
    def cloud_services_network_attachment(self, value: pulumi.Input['NetworkAttachmentArgs']):
        pulumi.set(self, "cloud_services_network_attachment", value)

    @property
    @pulumi.getter(name="cpuCores")
    def cpu_cores(self) -> pulumi.Input[float]:
        """
        The number of CPU cores in the virtual machine.
        """
        return pulumi.get(self, "cpu_cores")

    @cpu_cores.setter
    def cpu_cores(self, value: pulumi.Input[float]):
        pulumi.set(self, "cpu_cores", value)

    @property
    @pulumi.getter(name="extendedLocation")
    def extended_location(self) -> pulumi.Input['ExtendedLocationArgs']:
        """
        The extended location of the cluster associated with the resource.
        """
        return pulumi.get(self, "extended_location")

    @extended_location.setter
    def extended_location(self, value: pulumi.Input['ExtendedLocationArgs']):
        pulumi.set(self, "extended_location", value)

    @property
    @pulumi.getter(name="memorySizeGB")
    def memory_size_gb(self) -> pulumi.Input[float]:
        """
        The memory size of the virtual machine in GB.
        """
        return pulumi.get(self, "memory_size_gb")

    @memory_size_gb.setter
    def memory_size_gb(self, value: pulumi.Input[float]):
        pulumi.set(self, "memory_size_gb", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> pulumi.Input['StorageProfileArgs']:
        return pulumi.get(self, "storage_profile")

    @storage_profile.setter
    def storage_profile(self, value: pulumi.Input['StorageProfileArgs']):
        pulumi.set(self, "storage_profile", value)

    @property
    @pulumi.getter(name="vmImage")
    def vm_image(self) -> pulumi.Input[str]:
        """
        The virtual machine image that is currently provisioned to the OS disk, using the full url and tag notation used to pull the image.
        """
        return pulumi.get(self, "vm_image")

    @vm_image.setter
    def vm_image(self, value: pulumi.Input[str]):
        pulumi.set(self, "vm_image", value)

    @property
    @pulumi.getter(name="bootMethod")
    def boot_method(self) -> Optional[pulumi.Input[Union[str, 'VirtualMachineBootMethod']]]:
        """
        Selects the boot method for the virtual machine.
        """
        return pulumi.get(self, "boot_method")

    @boot_method.setter
    def boot_method(self, value: Optional[pulumi.Input[Union[str, 'VirtualMachineBootMethod']]]):
        pulumi.set(self, "boot_method", value)

    @property
    @pulumi.getter(name="isolateEmulatorThread")
    def isolate_emulator_thread(self) -> Optional[pulumi.Input[Union[str, 'VirtualMachineIsolateEmulatorThread']]]:
        """
        Field Deprecated, the value will be ignored if provided. The indicator of whether one of the specified CPU cores is isolated to run the emulator thread for this virtual machine.
        """
        return pulumi.get(self, "isolate_emulator_thread")

    @isolate_emulator_thread.setter
    def isolate_emulator_thread(self, value: Optional[pulumi.Input[Union[str, 'VirtualMachineIsolateEmulatorThread']]]):
        pulumi.set(self, "isolate_emulator_thread", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="networkAttachments")
    def network_attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAttachmentArgs']]]]:
        """
        The list of network attachments to the virtual machine.
        """
        return pulumi.get(self, "network_attachments")

    @network_attachments.setter
    def network_attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAttachmentArgs']]]]):
        pulumi.set(self, "network_attachments", value)

    @property
    @pulumi.getter(name="networkData")
    def network_data(self) -> Optional[pulumi.Input[str]]:
        """
        The Base64 encoded cloud-init network data.
        """
        return pulumi.get(self, "network_data")

    @network_data.setter
    def network_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_data", value)

    @property
    @pulumi.getter(name="placementHints")
    def placement_hints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachinePlacementHintArgs']]]]:
        """
        The scheduling hints for the virtual machine.
        """
        return pulumi.get(self, "placement_hints")

    @placement_hints.setter
    def placement_hints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachinePlacementHintArgs']]]]):
        pulumi.set(self, "placement_hints", value)

    @property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]]:
        """
        The list of ssh public keys. Each key will be added to the virtual machine using the cloud-init ssh_authorized_keys mechanism for the adminUsername.
        """
        return pulumi.get(self, "ssh_public_keys")

    @ssh_public_keys.setter
    def ssh_public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]]):
        pulumi.set(self, "ssh_public_keys", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        The Base64 encoded cloud-init user data.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="virtioInterface")
    def virtio_interface(self) -> Optional[pulumi.Input[Union[str, 'VirtualMachineVirtioInterfaceType']]]:
        """
        Field Deprecated, use virtualizationModel instead. The type of the virtio interface.
        """
        return pulumi.get(self, "virtio_interface")

    @virtio_interface.setter
    def virtio_interface(self, value: Optional[pulumi.Input[Union[str, 'VirtualMachineVirtioInterfaceType']]]):
        pulumi.set(self, "virtio_interface", value)

    @property
    @pulumi.getter(name="virtualMachineName")
    def virtual_machine_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the virtual machine.
        """
        return pulumi.get(self, "virtual_machine_name")

    @virtual_machine_name.setter
    def virtual_machine_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_name", value)

    @property
    @pulumi.getter(name="vmDeviceModel")
    def vm_device_model(self) -> Optional[pulumi.Input[Union[str, 'VirtualMachineDeviceModelType']]]:
        """
        The type of the device model to use.
        """
        return pulumi.get(self, "vm_device_model")

    @vm_device_model.setter
    def vm_device_model(self, value: Optional[pulumi.Input[Union[str, 'VirtualMachineDeviceModelType']]]):
        pulumi.set(self, "vm_device_model", value)

    @property
    @pulumi.getter(name="vmImageRepositoryCredentials")
    def vm_image_repository_credentials(self) -> Optional[pulumi.Input['ImageRepositoryCredentialsArgs']]:
        return pulumi.get(self, "vm_image_repository_credentials")

    @vm_image_repository_credentials.setter
    def vm_image_repository_credentials(self, value: Optional[pulumi.Input['ImageRepositoryCredentialsArgs']]):
        pulumi.set(self, "vm_image_repository_credentials", value)


class VirtualMachine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 boot_method: Optional[pulumi.Input[Union[str, 'VirtualMachineBootMethod']]] = None,
                 cloud_services_network_attachment: Optional[pulumi.Input[pulumi.InputType['NetworkAttachmentArgs']]] = None,
                 cpu_cores: Optional[pulumi.Input[float]] = None,
                 extended_location: Optional[pulumi.Input[pulumi.InputType['ExtendedLocationArgs']]] = None,
                 isolate_emulator_thread: Optional[pulumi.Input[Union[str, 'VirtualMachineIsolateEmulatorThread']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 memory_size_gb: Optional[pulumi.Input[float]] = None,
                 network_attachments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAttachmentArgs']]]]] = None,
                 network_data: Optional[pulumi.Input[str]] = None,
                 placement_hints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachinePlacementHintArgs']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SshPublicKeyArgs']]]]] = None,
                 storage_profile: Optional[pulumi.Input[pulumi.InputType['StorageProfileArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 virtio_interface: Optional[pulumi.Input[Union[str, 'VirtualMachineVirtioInterfaceType']]] = None,
                 virtual_machine_name: Optional[pulumi.Input[str]] = None,
                 vm_device_model: Optional[pulumi.Input[Union[str, 'VirtualMachineDeviceModelType']]] = None,
                 vm_image: Optional[pulumi.Input[str]] = None,
                 vm_image_repository_credentials: Optional[pulumi.Input[pulumi.InputType['ImageRepositoryCredentialsArgs']]] = None,
                 __props__=None):
        """
        Create a VirtualMachine resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_username: The name of the administrator to which the ssh public keys will be added into the authorized keys.
        :param pulumi.Input[Union[str, 'VirtualMachineBootMethod']] boot_method: Selects the boot method for the virtual machine.
        :param pulumi.Input[float] cpu_cores: The number of CPU cores in the virtual machine.
        :param pulumi.Input[pulumi.InputType['ExtendedLocationArgs']] extended_location: The extended location of the cluster associated with the resource.
        :param pulumi.Input[Union[str, 'VirtualMachineIsolateEmulatorThread']] isolate_emulator_thread: Field Deprecated, the value will be ignored if provided. The indicator of whether one of the specified CPU cores is isolated to run the emulator thread for this virtual machine.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[float] memory_size_gb: The memory size of the virtual machine in GB.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAttachmentArgs']]]] network_attachments: The list of network attachments to the virtual machine.
        :param pulumi.Input[str] network_data: The Base64 encoded cloud-init network data.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachinePlacementHintArgs']]]] placement_hints: The scheduling hints for the virtual machine.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SshPublicKeyArgs']]]] ssh_public_keys: The list of ssh public keys. Each key will be added to the virtual machine using the cloud-init ssh_authorized_keys mechanism for the adminUsername.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[str] user_data: The Base64 encoded cloud-init user data.
        :param pulumi.Input[Union[str, 'VirtualMachineVirtioInterfaceType']] virtio_interface: Field Deprecated, use virtualizationModel instead. The type of the virtio interface.
        :param pulumi.Input[str] virtual_machine_name: The name of the virtual machine.
        :param pulumi.Input[Union[str, 'VirtualMachineDeviceModelType']] vm_device_model: The type of the device model to use.
        :param pulumi.Input[str] vm_image: The virtual machine image that is currently provisioned to the OS disk, using the full url and tag notation used to pull the image.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualMachineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a VirtualMachine resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param VirtualMachineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualMachineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 boot_method: Optional[pulumi.Input[Union[str, 'VirtualMachineBootMethod']]] = None,
                 cloud_services_network_attachment: Optional[pulumi.Input[pulumi.InputType['NetworkAttachmentArgs']]] = None,
                 cpu_cores: Optional[pulumi.Input[float]] = None,
                 extended_location: Optional[pulumi.Input[pulumi.InputType['ExtendedLocationArgs']]] = None,
                 isolate_emulator_thread: Optional[pulumi.Input[Union[str, 'VirtualMachineIsolateEmulatorThread']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 memory_size_gb: Optional[pulumi.Input[float]] = None,
                 network_attachments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAttachmentArgs']]]]] = None,
                 network_data: Optional[pulumi.Input[str]] = None,
                 placement_hints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachinePlacementHintArgs']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SshPublicKeyArgs']]]]] = None,
                 storage_profile: Optional[pulumi.Input[pulumi.InputType['StorageProfileArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 virtio_interface: Optional[pulumi.Input[Union[str, 'VirtualMachineVirtioInterfaceType']]] = None,
                 virtual_machine_name: Optional[pulumi.Input[str]] = None,
                 vm_device_model: Optional[pulumi.Input[Union[str, 'VirtualMachineDeviceModelType']]] = None,
                 vm_image: Optional[pulumi.Input[str]] = None,
                 vm_image_repository_credentials: Optional[pulumi.Input[pulumi.InputType['ImageRepositoryCredentialsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualMachineArgs.__new__(VirtualMachineArgs)

            if admin_username is None and not opts.urn:
                raise TypeError("Missing required property 'admin_username'")
            __props__.__dict__["admin_username"] = admin_username
            if boot_method is None:
                boot_method = 'UEFI'
            __props__.__dict__["boot_method"] = boot_method
            if cloud_services_network_attachment is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_services_network_attachment'")
            __props__.__dict__["cloud_services_network_attachment"] = cloud_services_network_attachment
            if cpu_cores is None and not opts.urn:
                raise TypeError("Missing required property 'cpu_cores'")
            __props__.__dict__["cpu_cores"] = cpu_cores
            if extended_location is None and not opts.urn:
                raise TypeError("Missing required property 'extended_location'")
            __props__.__dict__["extended_location"] = extended_location
            if isolate_emulator_thread is None:
                isolate_emulator_thread = 'True'
            __props__.__dict__["isolate_emulator_thread"] = isolate_emulator_thread
            __props__.__dict__["location"] = location
            if memory_size_gb is None and not opts.urn:
                raise TypeError("Missing required property 'memory_size_gb'")
            __props__.__dict__["memory_size_gb"] = memory_size_gb
            __props__.__dict__["network_attachments"] = network_attachments
            __props__.__dict__["network_data"] = network_data
            __props__.__dict__["placement_hints"] = placement_hints
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["ssh_public_keys"] = ssh_public_keys
            if storage_profile is None and not opts.urn:
                raise TypeError("Missing required property 'storage_profile'")
            __props__.__dict__["storage_profile"] = storage_profile
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
            if virtio_interface is None:
                virtio_interface = 'Modern'
            __props__.__dict__["virtio_interface"] = virtio_interface
            __props__.__dict__["virtual_machine_name"] = virtual_machine_name
            if vm_device_model is None:
                vm_device_model = 'T2'
            __props__.__dict__["vm_device_model"] = vm_device_model
            if vm_image is None and not opts.urn:
                raise TypeError("Missing required property 'vm_image'")
            __props__.__dict__["vm_image"] = vm_image
            __props__.__dict__["vm_image_repository_credentials"] = vm_image_repository_credentials
            __props__.__dict__["bare_metal_machine_id"] = None
            __props__.__dict__["cluster_id"] = None
            __props__.__dict__["detailed_status"] = None
            __props__.__dict__["detailed_status_message"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["power_state"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["volumes"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:networkcloud:VirtualMachine")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(VirtualMachine, __self__).__init__(
            'azure-native:networkcloud/v20221212preview:VirtualMachine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'VirtualMachine':
        """
        Get an existing VirtualMachine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VirtualMachineArgs.__new__(VirtualMachineArgs)

        __props__.__dict__["admin_username"] = None
        __props__.__dict__["bare_metal_machine_id"] = None
        __props__.__dict__["boot_method"] = None
        __props__.__dict__["cloud_services_network_attachment"] = None
        __props__.__dict__["cluster_id"] = None
        __props__.__dict__["cpu_cores"] = None
        __props__.__dict__["detailed_status"] = None
        __props__.__dict__["detailed_status_message"] = None
        __props__.__dict__["extended_location"] = None
        __props__.__dict__["isolate_emulator_thread"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["memory_size_gb"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["network_attachments"] = None
        __props__.__dict__["network_data"] = None
        __props__.__dict__["placement_hints"] = None
        __props__.__dict__["power_state"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["ssh_public_keys"] = None
        __props__.__dict__["storage_profile"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["user_data"] = None
        __props__.__dict__["virtio_interface"] = None
        __props__.__dict__["vm_device_model"] = None
        __props__.__dict__["vm_image"] = None
        __props__.__dict__["vm_image_repository_credentials"] = None
        __props__.__dict__["volumes"] = None
        return VirtualMachine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Output[str]:
        """
        The name of the administrator to which the ssh public keys will be added into the authorized keys.
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="bareMetalMachineId")
    def bare_metal_machine_id(self) -> pulumi.Output[str]:
        """
        The resource ID of the bare metal machine the virtual machine has landed to.
        """
        return pulumi.get(self, "bare_metal_machine_id")

    @property
    @pulumi.getter(name="bootMethod")
    def boot_method(self) -> pulumi.Output[Optional[str]]:
        """
        Selects the boot method for the virtual machine.
        """
        return pulumi.get(self, "boot_method")

    @property
    @pulumi.getter(name="cloudServicesNetworkAttachment")
    def cloud_services_network_attachment(self) -> pulumi.Output['outputs.NetworkAttachmentResponse']:
        return pulumi.get(self, "cloud_services_network_attachment")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The resource ID of the cluster the virtual machine is created for.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="cpuCores")
    def cpu_cores(self) -> pulumi.Output[float]:
        """
        The number of CPU cores in the virtual machine.
        """
        return pulumi.get(self, "cpu_cores")

    @property
    @pulumi.getter(name="detailedStatus")
    def detailed_status(self) -> pulumi.Output[str]:
        """
        The more detailed status of the virtual machine.
        """
        return pulumi.get(self, "detailed_status")

    @property
    @pulumi.getter(name="detailedStatusMessage")
    def detailed_status_message(self) -> pulumi.Output[str]:
        """
        The descriptive message about the current detailed status.
        """
        return pulumi.get(self, "detailed_status_message")

    @property
    @pulumi.getter(name="extendedLocation")
    def extended_location(self) -> pulumi.Output['outputs.ExtendedLocationResponse']:
        """
        The extended location of the cluster associated with the resource.
        """
        return pulumi.get(self, "extended_location")

    @property
    @pulumi.getter(name="isolateEmulatorThread")
    def isolate_emulator_thread(self) -> pulumi.Output[Optional[str]]:
        """
        Field Deprecated, the value will be ignored if provided. The indicator of whether one of the specified CPU cores is isolated to run the emulator thread for this virtual machine.
        """
        return pulumi.get(self, "isolate_emulator_thread")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="memorySizeGB")
    def memory_size_gb(self) -> pulumi.Output[float]:
        """
        The memory size of the virtual machine in GB.
        """
        return pulumi.get(self, "memory_size_gb")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkAttachments")
    def network_attachments(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkAttachmentResponse']]]:
        """
        The list of network attachments to the virtual machine.
        """
        return pulumi.get(self, "network_attachments")

    @property
    @pulumi.getter(name="networkData")
    def network_data(self) -> pulumi.Output[Optional[str]]:
        """
        The Base64 encoded cloud-init network data.
        """
        return pulumi.get(self, "network_data")

    @property
    @pulumi.getter(name="placementHints")
    def placement_hints(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachinePlacementHintResponse']]]:
        """
        The scheduling hints for the virtual machine.
        """
        return pulumi.get(self, "placement_hints")

    @property
    @pulumi.getter(name="powerState")
    def power_state(self) -> pulumi.Output[str]:
        """
        The power state of the virtual machine.
        """
        return pulumi.get(self, "power_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        The provisioning state of the virtual machine.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> pulumi.Output[Optional[Sequence['outputs.SshPublicKeyResponse']]]:
        """
        The list of ssh public keys. Each key will be added to the virtual machine using the cloud-init ssh_authorized_keys mechanism for the adminUsername.
        """
        return pulumi.get(self, "ssh_public_keys")

    @property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> pulumi.Output['outputs.StorageProfileResponse']:
        return pulumi.get(self, "storage_profile")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        The Base64 encoded cloud-init user data.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter(name="virtioInterface")
    def virtio_interface(self) -> pulumi.Output[Optional[str]]:
        """
        Field Deprecated, use virtualizationModel instead. The type of the virtio interface.
        """
        return pulumi.get(self, "virtio_interface")

    @property
    @pulumi.getter(name="vmDeviceModel")
    def vm_device_model(self) -> pulumi.Output[Optional[str]]:
        """
        The type of the device model to use.
        """
        return pulumi.get(self, "vm_device_model")

    @property
    @pulumi.getter(name="vmImage")
    def vm_image(self) -> pulumi.Output[str]:
        """
        The virtual machine image that is currently provisioned to the OS disk, using the full url and tag notation used to pull the image.
        """
        return pulumi.get(self, "vm_image")

    @property
    @pulumi.getter(name="vmImageRepositoryCredentials")
    def vm_image_repository_credentials(self) -> pulumi.Output[Optional['outputs.ImageRepositoryCredentialsResponse']]:
        return pulumi.get(self, "vm_image_repository_credentials")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Sequence[str]]:
        """
        The resource IDs of volumes that are attached to the virtual machine.
        """
        return pulumi.get(self, "volumes")

