# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetCloudServicesNetworkResult',
    'AwaitableGetCloudServicesNetworkResult',
    'get_cloud_services_network',
    'get_cloud_services_network_output',
]

@pulumi.output_type
class GetCloudServicesNetworkResult:
    """
    Upon creation, the additional services that are provided by the platform will be allocated and
    represented in the status of this resource. All resources associated with this cloud services network will be part
    of the same layer 2 (L2) isolation domain. At least one service network must be created but may be reused across many
    virtual machines and/or Hybrid AKS clusters.
    """
    def __init__(__self__, additional_egress_endpoints=None, cluster_id=None, detailed_status=None, detailed_status_message=None, enable_default_egress_endpoints=None, enabled_egress_endpoints=None, extended_location=None, hybrid_aks_clusters_associated_ids=None, id=None, interface_name=None, location=None, name=None, provisioning_state=None, system_data=None, tags=None, type=None, virtual_machines_associated_ids=None):
        if additional_egress_endpoints and not isinstance(additional_egress_endpoints, list):
            raise TypeError("Expected argument 'additional_egress_endpoints' to be a list")
        pulumi.set(__self__, "additional_egress_endpoints", additional_egress_endpoints)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if detailed_status and not isinstance(detailed_status, str):
            raise TypeError("Expected argument 'detailed_status' to be a str")
        pulumi.set(__self__, "detailed_status", detailed_status)
        if detailed_status_message and not isinstance(detailed_status_message, str):
            raise TypeError("Expected argument 'detailed_status_message' to be a str")
        pulumi.set(__self__, "detailed_status_message", detailed_status_message)
        if enable_default_egress_endpoints and not isinstance(enable_default_egress_endpoints, str):
            raise TypeError("Expected argument 'enable_default_egress_endpoints' to be a str")
        pulumi.set(__self__, "enable_default_egress_endpoints", enable_default_egress_endpoints)
        if enabled_egress_endpoints and not isinstance(enabled_egress_endpoints, list):
            raise TypeError("Expected argument 'enabled_egress_endpoints' to be a list")
        pulumi.set(__self__, "enabled_egress_endpoints", enabled_egress_endpoints)
        if extended_location and not isinstance(extended_location, dict):
            raise TypeError("Expected argument 'extended_location' to be a dict")
        pulumi.set(__self__, "extended_location", extended_location)
        if hybrid_aks_clusters_associated_ids and not isinstance(hybrid_aks_clusters_associated_ids, list):
            raise TypeError("Expected argument 'hybrid_aks_clusters_associated_ids' to be a list")
        pulumi.set(__self__, "hybrid_aks_clusters_associated_ids", hybrid_aks_clusters_associated_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interface_name and not isinstance(interface_name, str):
            raise TypeError("Expected argument 'interface_name' to be a str")
        pulumi.set(__self__, "interface_name", interface_name)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if virtual_machines_associated_ids and not isinstance(virtual_machines_associated_ids, list):
            raise TypeError("Expected argument 'virtual_machines_associated_ids' to be a list")
        pulumi.set(__self__, "virtual_machines_associated_ids", virtual_machines_associated_ids)

    @property
    @pulumi.getter(name="additionalEgressEndpoints")
    def additional_egress_endpoints(self) -> Optional[Sequence['outputs.EgressEndpointResponse']]:
        """
        The list of egress endpoints. This allows for connection from a Hybrid AKS cluster to the specified endpoint.
        """
        return pulumi.get(self, "additional_egress_endpoints")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The resource ID of the Network Cloud cluster this cloud services network is associated with.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="detailedStatus")
    def detailed_status(self) -> str:
        """
        The more detailed status of the cloud services network.
        """
        return pulumi.get(self, "detailed_status")

    @property
    @pulumi.getter(name="detailedStatusMessage")
    def detailed_status_message(self) -> str:
        """
        The descriptive message about the current detailed status.
        """
        return pulumi.get(self, "detailed_status_message")

    @property
    @pulumi.getter(name="enableDefaultEgressEndpoints")
    def enable_default_egress_endpoints(self) -> Optional[str]:
        """
        The indicator of whether the platform default endpoints are allowed for the egress traffic.
        """
        return pulumi.get(self, "enable_default_egress_endpoints")

    @property
    @pulumi.getter(name="enabledEgressEndpoints")
    def enabled_egress_endpoints(self) -> Sequence['outputs.EgressEndpointResponse']:
        """
        The full list of additional and default egress endpoints that are currently enabled.
        """
        return pulumi.get(self, "enabled_egress_endpoints")

    @property
    @pulumi.getter(name="extendedLocation")
    def extended_location(self) -> 'outputs.ExtendedLocationResponse':
        """
        The extended location of the cluster associated with the resource.
        """
        return pulumi.get(self, "extended_location")

    @property
    @pulumi.getter(name="hybridAksClustersAssociatedIds")
    def hybrid_aks_clusters_associated_ids(self) -> Sequence[str]:
        """
        The list of Hybrid AKS cluster resource IDs that are associated with this cloud services network.
        """
        return pulumi.get(self, "hybrid_aks_clusters_associated_ids")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> str:
        """
        The name of the interface that will be present in the virtual machine to represent this network.
        """
        return pulumi.get(self, "interface_name")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the cloud services network.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="virtualMachinesAssociatedIds")
    def virtual_machines_associated_ids(self) -> Sequence[str]:
        """
        The list of virtual machine resource IDs, excluding any Hybrid AKS virtual machines, that are currently using this cloud services network.
        """
        return pulumi.get(self, "virtual_machines_associated_ids")


class AwaitableGetCloudServicesNetworkResult(GetCloudServicesNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudServicesNetworkResult(
            additional_egress_endpoints=self.additional_egress_endpoints,
            cluster_id=self.cluster_id,
            detailed_status=self.detailed_status,
            detailed_status_message=self.detailed_status_message,
            enable_default_egress_endpoints=self.enable_default_egress_endpoints,
            enabled_egress_endpoints=self.enabled_egress_endpoints,
            extended_location=self.extended_location,
            hybrid_aks_clusters_associated_ids=self.hybrid_aks_clusters_associated_ids,
            id=self.id,
            interface_name=self.interface_name,
            location=self.location,
            name=self.name,
            provisioning_state=self.provisioning_state,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type,
            virtual_machines_associated_ids=self.virtual_machines_associated_ids)


def get_cloud_services_network(cloud_services_network_name: Optional[str] = None,
                               resource_group_name: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudServicesNetworkResult:
    """
    Get properties of the provided cloud services network.


    :param str cloud_services_network_name: The name of the cloud services network.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['cloudServicesNetworkName'] = cloud_services_network_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:networkcloud/v20221212preview:getCloudServicesNetwork', __args__, opts=opts, typ=GetCloudServicesNetworkResult).value

    return AwaitableGetCloudServicesNetworkResult(
        additional_egress_endpoints=__ret__.additional_egress_endpoints,
        cluster_id=__ret__.cluster_id,
        detailed_status=__ret__.detailed_status,
        detailed_status_message=__ret__.detailed_status_message,
        enable_default_egress_endpoints=__ret__.enable_default_egress_endpoints,
        enabled_egress_endpoints=__ret__.enabled_egress_endpoints,
        extended_location=__ret__.extended_location,
        hybrid_aks_clusters_associated_ids=__ret__.hybrid_aks_clusters_associated_ids,
        id=__ret__.id,
        interface_name=__ret__.interface_name,
        location=__ret__.location,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type,
        virtual_machines_associated_ids=__ret__.virtual_machines_associated_ids)


@_utilities.lift_output_func(get_cloud_services_network)
def get_cloud_services_network_output(cloud_services_network_name: Optional[pulumi.Input[str]] = None,
                                      resource_group_name: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCloudServicesNetworkResult]:
    """
    Get properties of the provided cloud services network.


    :param str cloud_services_network_name: The name of the cloud services network.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
