# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = ['NetworkRackArgs', 'NetworkRack']

@pulumi.input_type
class NetworkRackArgs:
    def __init__(__self__, *,
                 network_fabric_id: pulumi.Input[str],
                 network_rack_sku: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 annotation: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 network_rack_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a NetworkRack resource.
        :param pulumi.Input[str] network_fabric_id: Network Fabric ARM resource id.
        :param pulumi.Input[str] network_rack_sku: Network Rack SKU name.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] annotation: Switch configuration description.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[str] network_rack_name: Name of the Network Rack
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        pulumi.set(__self__, "network_fabric_id", network_fabric_id)
        pulumi.set(__self__, "network_rack_sku", network_rack_sku)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if network_rack_name is not None:
            pulumi.set(__self__, "network_rack_name", network_rack_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="networkFabricId")
    def network_fabric_id(self) -> pulumi.Input[str]:
        """
        Network Fabric ARM resource id.
        """
        return pulumi.get(self, "network_fabric_id")

    @network_fabric_id.setter
    def network_fabric_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_fabric_id", value)

    @property
    @pulumi.getter(name="networkRackSku")
    def network_rack_sku(self) -> pulumi.Input[str]:
        """
        Network Rack SKU name.
        """
        return pulumi.get(self, "network_rack_sku")

    @network_rack_sku.setter
    def network_rack_sku(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_rack_sku", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def annotation(self) -> Optional[pulumi.Input[str]]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="networkRackName")
    def network_rack_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Network Rack
        """
        return pulumi.get(self, "network_rack_name")

    @network_rack_name.setter
    def network_rack_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_rack_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class NetworkRack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotation: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 network_fabric_id: Optional[pulumi.Input[str]] = None,
                 network_rack_name: Optional[pulumi.Input[str]] = None,
                 network_rack_sku: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The NetworkRack resource definition.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] annotation: Switch configuration description.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[str] network_fabric_id: Network Fabric ARM resource id.
        :param pulumi.Input[str] network_rack_name: Name of the Network Rack
        :param pulumi.Input[str] network_rack_sku: Network Rack SKU name.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkRackArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The NetworkRack resource definition.

        :param str resource_name: The name of the resource.
        :param NetworkRackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkRackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotation: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 network_fabric_id: Optional[pulumi.Input[str]] = None,
                 network_rack_name: Optional[pulumi.Input[str]] = None,
                 network_rack_sku: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkRackArgs.__new__(NetworkRackArgs)

            __props__.__dict__["annotation"] = annotation
            __props__.__dict__["location"] = location
            if network_fabric_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_fabric_id'")
            __props__.__dict__["network_fabric_id"] = network_fabric_id
            __props__.__dict__["network_rack_name"] = network_rack_name
            if network_rack_sku is None and not opts.urn:
                raise TypeError("Missing required property 'network_rack_sku'")
            __props__.__dict__["network_rack_sku"] = network_rack_sku
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["name"] = None
            __props__.__dict__["network_devices"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:managednetworkfabric:NetworkRack")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(NetworkRack, __self__).__init__(
            'azure-native:managednetworkfabric/v20230201preview:NetworkRack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'NetworkRack':
        """
        Get an existing NetworkRack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = NetworkRackArgs.__new__(NetworkRackArgs)

        __props__.__dict__["annotation"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["network_devices"] = None
        __props__.__dict__["network_fabric_id"] = None
        __props__.__dict__["network_rack_sku"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return NetworkRack(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotation(self) -> pulumi.Output[Optional[str]]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkDevices")
    def network_devices(self) -> pulumi.Output[Sequence[str]]:
        """
        List of network device ARM resource ids.
        """
        return pulumi.get(self, "network_devices")

    @property
    @pulumi.getter(name="networkFabricId")
    def network_fabric_id(self) -> pulumi.Output[str]:
        """
        Network Fabric ARM resource id.
        """
        return pulumi.get(self, "network_fabric_id")

    @property
    @pulumi.getter(name="networkRackSku")
    def network_rack_sku(self) -> pulumi.Output[str]:
        """
        Network Rack SKU name.
        """
        return pulumi.get(self, "network_rack_sku")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        Gets the provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

