# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['L3IsolationDomainArgs', 'L3IsolationDomain']

@pulumi.input_type
class L3IsolationDomainArgs:
    def __init__(__self__, *,
                 network_fabric_id: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 aggregate_route_configuration: Optional[pulumi.Input['L3IsolationDomainPatchPropertiesAggregateRouteConfigurationArgs']] = None,
                 annotation: Optional[pulumi.Input[str]] = None,
                 connected_subnet_route_policy: Optional[pulumi.Input['L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 l3_isolation_domain_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 redistribute_connected_subnets: Optional[pulumi.Input[Union[str, 'RedistributeConnectedSubnets']]] = None,
                 redistribute_static_routes: Optional[pulumi.Input[Union[str, 'RedistributeStaticRoutes']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a L3IsolationDomain resource.
        :param pulumi.Input[str] network_fabric_id: Network Fabric ARM resource id.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input['L3IsolationDomainPatchPropertiesAggregateRouteConfigurationArgs'] aggregate_route_configuration: List of Ipv4 and Ipv6 route configurations.
        :param pulumi.Input[str] annotation: Switch configuration description.
        :param pulumi.Input['L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs'] connected_subnet_route_policy: Connected Subnet RoutePolicy
        :param pulumi.Input[str] description: L3 Isolation Domain description.
        :param pulumi.Input[str] l3_isolation_domain_name: Name of the L3 Isolation Domain
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[Union[str, 'RedistributeConnectedSubnets']] redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False".
        :param pulumi.Input[Union[str, 'RedistributeStaticRoutes']] redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False".
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        pulumi.set(__self__, "network_fabric_id", network_fabric_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if aggregate_route_configuration is not None:
            pulumi.set(__self__, "aggregate_route_configuration", aggregate_route_configuration)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if connected_subnet_route_policy is not None:
            pulumi.set(__self__, "connected_subnet_route_policy", connected_subnet_route_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if l3_isolation_domain_name is not None:
            pulumi.set(__self__, "l3_isolation_domain_name", l3_isolation_domain_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if redistribute_connected_subnets is None:
            redistribute_connected_subnets = 'True'
        if redistribute_connected_subnets is not None:
            pulumi.set(__self__, "redistribute_connected_subnets", redistribute_connected_subnets)
        if redistribute_static_routes is None:
            redistribute_static_routes = 'False'
        if redistribute_static_routes is not None:
            pulumi.set(__self__, "redistribute_static_routes", redistribute_static_routes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="networkFabricId")
    def network_fabric_id(self) -> pulumi.Input[str]:
        """
        Network Fabric ARM resource id.
        """
        return pulumi.get(self, "network_fabric_id")

    @network_fabric_id.setter
    def network_fabric_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_fabric_id", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="aggregateRouteConfiguration")
    def aggregate_route_configuration(self) -> Optional[pulumi.Input['L3IsolationDomainPatchPropertiesAggregateRouteConfigurationArgs']]:
        """
        List of Ipv4 and Ipv6 route configurations.
        """
        return pulumi.get(self, "aggregate_route_configuration")

    @aggregate_route_configuration.setter
    def aggregate_route_configuration(self, value: Optional[pulumi.Input['L3IsolationDomainPatchPropertiesAggregateRouteConfigurationArgs']]):
        pulumi.set(self, "aggregate_route_configuration", value)

    @property
    @pulumi.getter
    def annotation(self) -> Optional[pulumi.Input[str]]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation", value)

    @property
    @pulumi.getter(name="connectedSubnetRoutePolicy")
    def connected_subnet_route_policy(self) -> Optional[pulumi.Input['L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs']]:
        """
        Connected Subnet RoutePolicy
        """
        return pulumi.get(self, "connected_subnet_route_policy")

    @connected_subnet_route_policy.setter
    def connected_subnet_route_policy(self, value: Optional[pulumi.Input['L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs']]):
        pulumi.set(self, "connected_subnet_route_policy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        L3 Isolation Domain description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="l3IsolationDomainName")
    def l3_isolation_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the L3 Isolation Domain
        """
        return pulumi.get(self, "l3_isolation_domain_name")

    @l3_isolation_domain_name.setter
    def l3_isolation_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "l3_isolation_domain_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="redistributeConnectedSubnets")
    def redistribute_connected_subnets(self) -> Optional[pulumi.Input[Union[str, 'RedistributeConnectedSubnets']]]:
        """
        Advertise Connected Subnets. Ex: "True" | "False".
        """
        return pulumi.get(self, "redistribute_connected_subnets")

    @redistribute_connected_subnets.setter
    def redistribute_connected_subnets(self, value: Optional[pulumi.Input[Union[str, 'RedistributeConnectedSubnets']]]):
        pulumi.set(self, "redistribute_connected_subnets", value)

    @property
    @pulumi.getter(name="redistributeStaticRoutes")
    def redistribute_static_routes(self) -> Optional[pulumi.Input[Union[str, 'RedistributeStaticRoutes']]]:
        """
        Advertise Static Routes. Ex: "True" | "False".
        """
        return pulumi.get(self, "redistribute_static_routes")

    @redistribute_static_routes.setter
    def redistribute_static_routes(self, value: Optional[pulumi.Input[Union[str, 'RedistributeStaticRoutes']]]):
        pulumi.set(self, "redistribute_static_routes", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class L3IsolationDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregate_route_configuration: Optional[pulumi.Input[pulumi.InputType['L3IsolationDomainPatchPropertiesAggregateRouteConfigurationArgs']]] = None,
                 annotation: Optional[pulumi.Input[str]] = None,
                 connected_subnet_route_policy: Optional[pulumi.Input[pulumi.InputType['L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 l3_isolation_domain_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 network_fabric_id: Optional[pulumi.Input[str]] = None,
                 redistribute_connected_subnets: Optional[pulumi.Input[Union[str, 'RedistributeConnectedSubnets']]] = None,
                 redistribute_static_routes: Optional[pulumi.Input[Union[str, 'RedistributeStaticRoutes']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The L3IsolationDomain resource definition.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['L3IsolationDomainPatchPropertiesAggregateRouteConfigurationArgs']] aggregate_route_configuration: List of Ipv4 and Ipv6 route configurations.
        :param pulumi.Input[str] annotation: Switch configuration description.
        :param pulumi.Input[pulumi.InputType['L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs']] connected_subnet_route_policy: Connected Subnet RoutePolicy
        :param pulumi.Input[str] description: L3 Isolation Domain description.
        :param pulumi.Input[str] l3_isolation_domain_name: Name of the L3 Isolation Domain
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[str] network_fabric_id: Network Fabric ARM resource id.
        :param pulumi.Input[Union[str, 'RedistributeConnectedSubnets']] redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False".
        :param pulumi.Input[Union[str, 'RedistributeStaticRoutes']] redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False".
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: L3IsolationDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The L3IsolationDomain resource definition.

        :param str resource_name: The name of the resource.
        :param L3IsolationDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(L3IsolationDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregate_route_configuration: Optional[pulumi.Input[pulumi.InputType['L3IsolationDomainPatchPropertiesAggregateRouteConfigurationArgs']]] = None,
                 annotation: Optional[pulumi.Input[str]] = None,
                 connected_subnet_route_policy: Optional[pulumi.Input[pulumi.InputType['L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 l3_isolation_domain_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 network_fabric_id: Optional[pulumi.Input[str]] = None,
                 redistribute_connected_subnets: Optional[pulumi.Input[Union[str, 'RedistributeConnectedSubnets']]] = None,
                 redistribute_static_routes: Optional[pulumi.Input[Union[str, 'RedistributeStaticRoutes']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = L3IsolationDomainArgs.__new__(L3IsolationDomainArgs)

            __props__.__dict__["aggregate_route_configuration"] = aggregate_route_configuration
            __props__.__dict__["annotation"] = annotation
            __props__.__dict__["connected_subnet_route_policy"] = connected_subnet_route_policy
            __props__.__dict__["description"] = description
            __props__.__dict__["l3_isolation_domain_name"] = l3_isolation_domain_name
            __props__.__dict__["location"] = location
            if network_fabric_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_fabric_id'")
            __props__.__dict__["network_fabric_id"] = network_fabric_id
            if redistribute_connected_subnets is None:
                redistribute_connected_subnets = 'True'
            __props__.__dict__["redistribute_connected_subnets"] = redistribute_connected_subnets
            if redistribute_static_routes is None:
                redistribute_static_routes = 'False'
            __props__.__dict__["redistribute_static_routes"] = redistribute_static_routes
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["administrative_state"] = None
            __props__.__dict__["disabled_on_resources"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["option_b_disabled_on_resources"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:managednetworkfabric:L3IsolationDomain")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(L3IsolationDomain, __self__).__init__(
            'azure-native:managednetworkfabric/v20230201preview:L3IsolationDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'L3IsolationDomain':
        """
        Get an existing L3IsolationDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = L3IsolationDomainArgs.__new__(L3IsolationDomainArgs)

        __props__.__dict__["administrative_state"] = None
        __props__.__dict__["aggregate_route_configuration"] = None
        __props__.__dict__["annotation"] = None
        __props__.__dict__["connected_subnet_route_policy"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["disabled_on_resources"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["network_fabric_id"] = None
        __props__.__dict__["option_b_disabled_on_resources"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["redistribute_connected_subnets"] = None
        __props__.__dict__["redistribute_static_routes"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return L3IsolationDomain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="administrativeState")
    def administrative_state(self) -> pulumi.Output[str]:
        """
        Administrative state of the IsolationDomain. Example: Enabled | Disabled.
        """
        return pulumi.get(self, "administrative_state")

    @property
    @pulumi.getter(name="aggregateRouteConfiguration")
    def aggregate_route_configuration(self) -> pulumi.Output[Optional['outputs.L3IsolationDomainPatchPropertiesResponseAggregateRouteConfiguration']]:
        """
        List of Ipv4 and Ipv6 route configurations.
        """
        return pulumi.get(self, "aggregate_route_configuration")

    @property
    @pulumi.getter
    def annotation(self) -> pulumi.Output[Optional[str]]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter(name="connectedSubnetRoutePolicy")
    def connected_subnet_route_policy(self) -> pulumi.Output[Optional['outputs.L3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicy']]:
        """
        Connected Subnet RoutePolicy
        """
        return pulumi.get(self, "connected_subnet_route_policy")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        L3 Isolation Domain description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disabledOnResources")
    def disabled_on_resources(self) -> pulumi.Output[Sequence[str]]:
        """
        List of resources the L3 Isolation Domain is disabled on. Can be either entire NetworkFabric or NetworkRack.
        """
        return pulumi.get(self, "disabled_on_resources")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFabricId")
    def network_fabric_id(self) -> pulumi.Output[str]:
        """
        Network Fabric ARM resource id.
        """
        return pulumi.get(self, "network_fabric_id")

    @property
    @pulumi.getter(name="optionBDisabledOnResources")
    def option_b_disabled_on_resources(self) -> pulumi.Output[Sequence[str]]:
        """
        List of resources the OptionB is disabled on. Can be either entire NetworkFabric or NetworkRack.
        """
        return pulumi.get(self, "option_b_disabled_on_resources")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        Gets the provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="redistributeConnectedSubnets")
    def redistribute_connected_subnets(self) -> pulumi.Output[Optional[str]]:
        """
        Advertise Connected Subnets. Ex: "True" | "False".
        """
        return pulumi.get(self, "redistribute_connected_subnets")

    @property
    @pulumi.getter(name="redistributeStaticRoutes")
    def redistribute_static_routes(self) -> pulumi.Output[Optional[str]]:
        """
        Advertise Static Routes. Ex: "True" | "False".
        """
        return pulumi.get(self, "redistribute_static_routes")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

