# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetNetworkToNetworkInterconnectResult',
    'AwaitableGetNetworkToNetworkInterconnectResult',
    'get_network_to_network_interconnect',
    'get_network_to_network_interconnect_output',
]

@pulumi.output_type
class GetNetworkToNetworkInterconnectResult:
    """
    The NetworkToNetworkInterconnect resource definition.
    """
    def __init__(__self__, administrative_state=None, id=None, is_management_type=None, layer2_configuration=None, layer3_configuration=None, name=None, provisioning_state=None, system_data=None, type=None, use_option_b=None):
        if administrative_state and not isinstance(administrative_state, str):
            raise TypeError("Expected argument 'administrative_state' to be a str")
        pulumi.set(__self__, "administrative_state", administrative_state)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_management_type and not isinstance(is_management_type, str):
            raise TypeError("Expected argument 'is_management_type' to be a str")
        pulumi.set(__self__, "is_management_type", is_management_type)
        if layer2_configuration and not isinstance(layer2_configuration, dict):
            raise TypeError("Expected argument 'layer2_configuration' to be a dict")
        pulumi.set(__self__, "layer2_configuration", layer2_configuration)
        if layer3_configuration and not isinstance(layer3_configuration, dict):
            raise TypeError("Expected argument 'layer3_configuration' to be a dict")
        pulumi.set(__self__, "layer3_configuration", layer3_configuration)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if use_option_b and not isinstance(use_option_b, str):
            raise TypeError("Expected argument 'use_option_b' to be a str")
        pulumi.set(__self__, "use_option_b", use_option_b)

    @property
    @pulumi.getter(name="administrativeState")
    def administrative_state(self) -> str:
        """
        Gets the administrativeState of the resource. Example -Enabled/Disabled
        """
        return pulumi.get(self, "administrative_state")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isManagementType")
    def is_management_type(self) -> str:
        """
        Configuration to use NNI for Infrastructure Management. Example: True/False.
        """
        return pulumi.get(self, "is_management_type")

    @property
    @pulumi.getter(name="layer2Configuration")
    def layer2_configuration(self) -> Optional['outputs.NetworkToNetworkInterconnectPropertiesResponseLayer2Configuration']:
        """
        Common properties for Layer2Configuration.
        """
        return pulumi.get(self, "layer2_configuration")

    @property
    @pulumi.getter(name="layer3Configuration")
    def layer3_configuration(self) -> Optional['outputs.Layer3ConfigurationResponse']:
        """
        Common properties for Layer3Configuration.
        """
        return pulumi.get(self, "layer3_configuration")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets the provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="useOptionB")
    def use_option_b(self) -> str:
        """
        Based on this parameter the layer2/layer3 is made as mandatory. Example: True/False
        """
        return pulumi.get(self, "use_option_b")


class AwaitableGetNetworkToNetworkInterconnectResult(GetNetworkToNetworkInterconnectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkToNetworkInterconnectResult(
            administrative_state=self.administrative_state,
            id=self.id,
            is_management_type=self.is_management_type,
            layer2_configuration=self.layer2_configuration,
            layer3_configuration=self.layer3_configuration,
            name=self.name,
            provisioning_state=self.provisioning_state,
            system_data=self.system_data,
            type=self.type,
            use_option_b=self.use_option_b)


def get_network_to_network_interconnect(network_fabric_name: Optional[str] = None,
                                        network_to_network_interconnect_name: Optional[str] = None,
                                        resource_group_name: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkToNetworkInterconnectResult:
    """
    Implements NetworkToNetworkInterconnects GET method.


    :param str network_fabric_name: Name of the NetworkFabric.
    :param str network_to_network_interconnect_name: Name of the NetworkToNetworkInterconnect
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['networkFabricName'] = network_fabric_name
    __args__['networkToNetworkInterconnectName'] = network_to_network_interconnect_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:managednetworkfabric/v20230201preview:getNetworkToNetworkInterconnect', __args__, opts=opts, typ=GetNetworkToNetworkInterconnectResult).value

    return AwaitableGetNetworkToNetworkInterconnectResult(
        administrative_state=__ret__.administrative_state,
        id=__ret__.id,
        is_management_type=__ret__.is_management_type,
        layer2_configuration=__ret__.layer2_configuration,
        layer3_configuration=__ret__.layer3_configuration,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        system_data=__ret__.system_data,
        type=__ret__.type,
        use_option_b=__ret__.use_option_b)


@_utilities.lift_output_func(get_network_to_network_interconnect)
def get_network_to_network_interconnect_output(network_fabric_name: Optional[pulumi.Input[str]] = None,
                                               network_to_network_interconnect_name: Optional[pulumi.Input[str]] = None,
                                               resource_group_name: Optional[pulumi.Input[str]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetworkToNetworkInterconnectResult]:
    """
    Implements NetworkToNetworkInterconnects GET method.


    :param str network_fabric_name: Name of the NetworkFabric.
    :param str network_to_network_interconnect_name: Name of the NetworkToNetworkInterconnect
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
