# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetNetworkFabricControllerResult',
    'AwaitableGetNetworkFabricControllerResult',
    'get_network_fabric_controller',
    'get_network_fabric_controller_output',
]

@pulumi.output_type
class GetNetworkFabricControllerResult:
    """
    The NetworkFabricController resource definition.
    """
    def __init__(__self__, annotation=None, id=None, infrastructure_express_route_connections=None, infrastructure_services=None, ipv4_address_space=None, ipv6_address_space=None, location=None, managed_resource_group_configuration=None, name=None, network_fabric_ids=None, operational_state=None, provisioning_state=None, system_data=None, tags=None, type=None, workload_express_route_connections=None, workload_management_network=None, workload_services=None):
        if annotation and not isinstance(annotation, str):
            raise TypeError("Expected argument 'annotation' to be a str")
        pulumi.set(__self__, "annotation", annotation)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if infrastructure_express_route_connections and not isinstance(infrastructure_express_route_connections, list):
            raise TypeError("Expected argument 'infrastructure_express_route_connections' to be a list")
        pulumi.set(__self__, "infrastructure_express_route_connections", infrastructure_express_route_connections)
        if infrastructure_services and not isinstance(infrastructure_services, dict):
            raise TypeError("Expected argument 'infrastructure_services' to be a dict")
        pulumi.set(__self__, "infrastructure_services", infrastructure_services)
        if ipv4_address_space and not isinstance(ipv4_address_space, str):
            raise TypeError("Expected argument 'ipv4_address_space' to be a str")
        pulumi.set(__self__, "ipv4_address_space", ipv4_address_space)
        if ipv6_address_space and not isinstance(ipv6_address_space, str):
            raise TypeError("Expected argument 'ipv6_address_space' to be a str")
        pulumi.set(__self__, "ipv6_address_space", ipv6_address_space)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if managed_resource_group_configuration and not isinstance(managed_resource_group_configuration, dict):
            raise TypeError("Expected argument 'managed_resource_group_configuration' to be a dict")
        pulumi.set(__self__, "managed_resource_group_configuration", managed_resource_group_configuration)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_fabric_ids and not isinstance(network_fabric_ids, list):
            raise TypeError("Expected argument 'network_fabric_ids' to be a list")
        pulumi.set(__self__, "network_fabric_ids", network_fabric_ids)
        if operational_state and not isinstance(operational_state, str):
            raise TypeError("Expected argument 'operational_state' to be a str")
        pulumi.set(__self__, "operational_state", operational_state)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if workload_express_route_connections and not isinstance(workload_express_route_connections, list):
            raise TypeError("Expected argument 'workload_express_route_connections' to be a list")
        pulumi.set(__self__, "workload_express_route_connections", workload_express_route_connections)
        if workload_management_network and not isinstance(workload_management_network, bool):
            raise TypeError("Expected argument 'workload_management_network' to be a bool")
        pulumi.set(__self__, "workload_management_network", workload_management_network)
        if workload_services and not isinstance(workload_services, dict):
            raise TypeError("Expected argument 'workload_services' to be a dict")
        pulumi.set(__self__, "workload_services", workload_services)

    @property
    @pulumi.getter
    def annotation(self) -> Optional[str]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="infrastructureExpressRouteConnections")
    def infrastructure_express_route_connections(self) -> Optional[Sequence['outputs.ExpressRouteConnectionInformationResponse']]:
        """
        As part of an update, the Infrastructure ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Infrastructure services. (This is a Mandatory attribute)
        """
        return pulumi.get(self, "infrastructure_express_route_connections")

    @property
    @pulumi.getter(name="infrastructureServices")
    def infrastructure_services(self) -> 'outputs.NetworkFabricControllerPropertiesResponseInfrastructureServices':
        """
        InfrastructureServices IP ranges.
        """
        return pulumi.get(self, "infrastructure_services")

    @property
    @pulumi.getter(name="ipv4AddressSpace")
    def ipv4_address_space(self) -> Optional[str]:
        """
        IPv4 Network Fabric Controller Address Space.
        """
        return pulumi.get(self, "ipv4_address_space")

    @property
    @pulumi.getter(name="ipv6AddressSpace")
    def ipv6_address_space(self) -> Optional[str]:
        """
        IPv6 Network Fabric Controller Address Space.
        """
        return pulumi.get(self, "ipv6_address_space")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="managedResourceGroupConfiguration")
    def managed_resource_group_configuration(self) -> Optional['outputs.NetworkFabricControllerPropertiesResponseManagedResourceGroupConfiguration']:
        """
        Managed Resource Group configuration properties.
        """
        return pulumi.get(self, "managed_resource_group_configuration")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFabricIds")
    def network_fabric_ids(self) -> Sequence[str]:
        """
        The NF-ID will be an input parameter used by the NF to link and get associated with the parent NFC Service.
        """
        return pulumi.get(self, "network_fabric_ids")

    @property
    @pulumi.getter(name="operationalState")
    def operational_state(self) -> str:
        """
        The Operational Status would always be NULL. Look only in to the Provisioning state for the latest status.
        """
        return pulumi.get(self, "operational_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provides you the latest status of the NFC service, whether it is Accepted, updating, Succeeded or Failed. During this process, the states keep changing based on the status of NFC provisioning.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="workloadExpressRouteConnections")
    def workload_express_route_connections(self) -> Optional[Sequence['outputs.ExpressRouteConnectionInformationResponse']]:
        """
        As part of an update, the workload ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Workload services. (This is a Mandatory attribute).
        """
        return pulumi.get(self, "workload_express_route_connections")

    @property
    @pulumi.getter(name="workloadManagementNetwork")
    def workload_management_network(self) -> bool:
        """
        A workload management network is required for all the tenant (workload) traffic. This traffic is only dedicated for Tenant workloads which are required to access internet or any other MSFT/Public endpoints.
        """
        return pulumi.get(self, "workload_management_network")

    @property
    @pulumi.getter(name="workloadServices")
    def workload_services(self) -> 'outputs.NetworkFabricControllerPropertiesResponseWorkloadServices':
        """
        WorkloadServices IP ranges.
        """
        return pulumi.get(self, "workload_services")


class AwaitableGetNetworkFabricControllerResult(GetNetworkFabricControllerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkFabricControllerResult(
            annotation=self.annotation,
            id=self.id,
            infrastructure_express_route_connections=self.infrastructure_express_route_connections,
            infrastructure_services=self.infrastructure_services,
            ipv4_address_space=self.ipv4_address_space,
            ipv6_address_space=self.ipv6_address_space,
            location=self.location,
            managed_resource_group_configuration=self.managed_resource_group_configuration,
            name=self.name,
            network_fabric_ids=self.network_fabric_ids,
            operational_state=self.operational_state,
            provisioning_state=self.provisioning_state,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type,
            workload_express_route_connections=self.workload_express_route_connections,
            workload_management_network=self.workload_management_network,
            workload_services=self.workload_services)


def get_network_fabric_controller(network_fabric_controller_name: Optional[str] = None,
                                  resource_group_name: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkFabricControllerResult:
    """
    Shows the provisioning status of Network Fabric Controller.


    :param str network_fabric_controller_name: Name of the Network Fabric Controller
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['networkFabricControllerName'] = network_fabric_controller_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:managednetworkfabric/v20230201preview:getNetworkFabricController', __args__, opts=opts, typ=GetNetworkFabricControllerResult).value

    return AwaitableGetNetworkFabricControllerResult(
        annotation=__ret__.annotation,
        id=__ret__.id,
        infrastructure_express_route_connections=__ret__.infrastructure_express_route_connections,
        infrastructure_services=__ret__.infrastructure_services,
        ipv4_address_space=__ret__.ipv4_address_space,
        ipv6_address_space=__ret__.ipv6_address_space,
        location=__ret__.location,
        managed_resource_group_configuration=__ret__.managed_resource_group_configuration,
        name=__ret__.name,
        network_fabric_ids=__ret__.network_fabric_ids,
        operational_state=__ret__.operational_state,
        provisioning_state=__ret__.provisioning_state,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type,
        workload_express_route_connections=__ret__.workload_express_route_connections,
        workload_management_network=__ret__.workload_management_network,
        workload_services=__ret__.workload_services)


@_utilities.lift_output_func(get_network_fabric_controller)
def get_network_fabric_controller_output(network_fabric_controller_name: Optional[pulumi.Input[str]] = None,
                                         resource_group_name: Optional[pulumi.Input[str]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetworkFabricControllerResult]:
    """
    Shows the provisioning status of Network Fabric Controller.


    :param str network_fabric_controller_name: Name of the Network Fabric Controller
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
