# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetL2IsolationDomainResult',
    'AwaitableGetL2IsolationDomainResult',
    'get_l2_isolation_domain',
    'get_l2_isolation_domain_output',
]

@pulumi.output_type
class GetL2IsolationDomainResult:
    """
    The L2IsolationDomain resource definition.
    """
    def __init__(__self__, administrative_state=None, annotation=None, disabled_on_resources=None, id=None, location=None, mtu=None, name=None, network_fabric_id=None, provisioning_state=None, system_data=None, tags=None, type=None, vlan_id=None):
        if administrative_state and not isinstance(administrative_state, str):
            raise TypeError("Expected argument 'administrative_state' to be a str")
        pulumi.set(__self__, "administrative_state", administrative_state)
        if annotation and not isinstance(annotation, str):
            raise TypeError("Expected argument 'annotation' to be a str")
        pulumi.set(__self__, "annotation", annotation)
        if disabled_on_resources and not isinstance(disabled_on_resources, list):
            raise TypeError("Expected argument 'disabled_on_resources' to be a list")
        pulumi.set(__self__, "disabled_on_resources", disabled_on_resources)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if mtu and not isinstance(mtu, int):
            raise TypeError("Expected argument 'mtu' to be a int")
        pulumi.set(__self__, "mtu", mtu)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_fabric_id and not isinstance(network_fabric_id, str):
            raise TypeError("Expected argument 'network_fabric_id' to be a str")
        pulumi.set(__self__, "network_fabric_id", network_fabric_id)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vlan_id and not isinstance(vlan_id, int):
            raise TypeError("Expected argument 'vlan_id' to be a int")
        pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter(name="administrativeState")
    def administrative_state(self) -> str:
        """
        state. Example: Enabled | Disabled. It indicates administrative state of the isolationDomain, whether it is enabled or disabled. If enabled, the configuration is applied on the devices. If disabled, the configuration is removed from the devices
        """
        return pulumi.get(self, "administrative_state")

    @property
    @pulumi.getter
    def annotation(self) -> Optional[str]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter(name="disabledOnResources")
    def disabled_on_resources(self) -> Sequence[str]:
        """
        List of resources the L2 Isolation Domain is disabled on. Can be either entire NetworkFabric or NetworkRack.
        """
        return pulumi.get(self, "disabled_on_resources")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def mtu(self) -> Optional[int]:
        """
        maximum transmission unit. Default value is 1500.
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFabricId")
    def network_fabric_id(self) -> str:
        """
        Network Fabric ARM resource id.
        """
        return pulumi.get(self, "network_fabric_id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets the provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> int:
        """
        vlanId. Example: 501.
        """
        return pulumi.get(self, "vlan_id")


class AwaitableGetL2IsolationDomainResult(GetL2IsolationDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetL2IsolationDomainResult(
            administrative_state=self.administrative_state,
            annotation=self.annotation,
            disabled_on_resources=self.disabled_on_resources,
            id=self.id,
            location=self.location,
            mtu=self.mtu,
            name=self.name,
            network_fabric_id=self.network_fabric_id,
            provisioning_state=self.provisioning_state,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type,
            vlan_id=self.vlan_id)


def get_l2_isolation_domain(l2_isolation_domain_name: Optional[str] = None,
                            resource_group_name: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetL2IsolationDomainResult:
    """
    Implements L2 Isolation Domain GET method.


    :param str l2_isolation_domain_name: Name of the L2 Isolation Domain
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['l2IsolationDomainName'] = l2_isolation_domain_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:managednetworkfabric/v20230201preview:getL2IsolationDomain', __args__, opts=opts, typ=GetL2IsolationDomainResult).value

    return AwaitableGetL2IsolationDomainResult(
        administrative_state=__ret__.administrative_state,
        annotation=__ret__.annotation,
        disabled_on_resources=__ret__.disabled_on_resources,
        id=__ret__.id,
        location=__ret__.location,
        mtu=__ret__.mtu,
        name=__ret__.name,
        network_fabric_id=__ret__.network_fabric_id,
        provisioning_state=__ret__.provisioning_state,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type,
        vlan_id=__ret__.vlan_id)


@_utilities.lift_output_func(get_l2_isolation_domain)
def get_l2_isolation_domain_output(l2_isolation_domain_name: Optional[pulumi.Input[str]] = None,
                                   resource_group_name: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetL2IsolationDomainResult]:
    """
    Implements L2 Isolation Domain GET method.


    :param str l2_isolation_domain_name: Name of the L2 Isolation Domain
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
