# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetIpCommunityListResult',
    'AwaitableGetIpCommunityListResult',
    'get_ip_community_list',
    'get_ip_community_list_output',
]

@pulumi.output_type
class GetIpCommunityListResult:
    """
    The IpCommunityList resource definition.
    """
    def __init__(__self__, action=None, advertise=None, annotation=None, community_members=None, evpn_es_import_route_targets=None, export=None, gshut=None, id=None, internet=None, local_as=None, location=None, name=None, provisioning_state=None, system_data=None, tags=None, type=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if advertise and not isinstance(advertise, str):
            raise TypeError("Expected argument 'advertise' to be a str")
        pulumi.set(__self__, "advertise", advertise)
        if annotation and not isinstance(annotation, str):
            raise TypeError("Expected argument 'annotation' to be a str")
        pulumi.set(__self__, "annotation", annotation)
        if community_members and not isinstance(community_members, list):
            raise TypeError("Expected argument 'community_members' to be a list")
        pulumi.set(__self__, "community_members", community_members)
        if evpn_es_import_route_targets and not isinstance(evpn_es_import_route_targets, list):
            raise TypeError("Expected argument 'evpn_es_import_route_targets' to be a list")
        pulumi.set(__self__, "evpn_es_import_route_targets", evpn_es_import_route_targets)
        if export and not isinstance(export, str):
            raise TypeError("Expected argument 'export' to be a str")
        pulumi.set(__self__, "export", export)
        if gshut and not isinstance(gshut, str):
            raise TypeError("Expected argument 'gshut' to be a str")
        pulumi.set(__self__, "gshut", gshut)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internet and not isinstance(internet, str):
            raise TypeError("Expected argument 'internet' to be a str")
        pulumi.set(__self__, "internet", internet)
        if local_as and not isinstance(local_as, str):
            raise TypeError("Expected argument 'local_as' to be a str")
        pulumi.set(__self__, "local_as", local_as)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        action. Example: allow | deny.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def advertise(self) -> str:
        """
        noAdvertise. Example: true | false.
        """
        return pulumi.get(self, "advertise")

    @property
    @pulumi.getter
    def annotation(self) -> Optional[str]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter(name="communityMembers")
    def community_members(self) -> Optional[Sequence['outputs.IpCommunityListPropertiesResponseCommunityMembers']]:
        """
        Ip Community List communityMembers.
        """
        return pulumi.get(self, "community_members")

    @property
    @pulumi.getter(name="evpnEsImportRouteTargets")
    def evpn_es_import_route_targets(self) -> Optional[Sequence['outputs.IpCommunityListPropertiesResponseEvpnEsImportRouteTargets']]:
        """
        Ip Community List evpnEsImportRouteTargets.
        """
        return pulumi.get(self, "evpn_es_import_route_targets")

    @property
    @pulumi.getter
    def export(self) -> str:
        """
        noExport. Example: true | false.
        """
        return pulumi.get(self, "export")

    @property
    @pulumi.getter
    def gshut(self) -> Optional[str]:
        """
         Graceful Shutdown (GSHUT). Example: true | false.
        """
        return pulumi.get(self, "gshut")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def internet(self) -> Optional[str]:
        """
        Internet access. Example: true | false.
        """
        return pulumi.get(self, "internet")

    @property
    @pulumi.getter(name="localAS")
    def local_as(self) -> str:
        """
        Local Autonomous System. Example: true | false.
        """
        return pulumi.get(self, "local_as")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets the provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetIpCommunityListResult(GetIpCommunityListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpCommunityListResult(
            action=self.action,
            advertise=self.advertise,
            annotation=self.annotation,
            community_members=self.community_members,
            evpn_es_import_route_targets=self.evpn_es_import_route_targets,
            export=self.export,
            gshut=self.gshut,
            id=self.id,
            internet=self.internet,
            local_as=self.local_as,
            location=self.location,
            name=self.name,
            provisioning_state=self.provisioning_state,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type)


def get_ip_community_list(ip_community_list_name: Optional[str] = None,
                          resource_group_name: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpCommunityListResult:
    """
    Implements Ip Community List GET method.


    :param str ip_community_list_name: Name of the Ip Community List
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['ipCommunityListName'] = ip_community_list_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:managednetworkfabric/v20230201preview:getIpCommunityList', __args__, opts=opts, typ=GetIpCommunityListResult).value

    return AwaitableGetIpCommunityListResult(
        action=__ret__.action,
        advertise=__ret__.advertise,
        annotation=__ret__.annotation,
        community_members=__ret__.community_members,
        evpn_es_import_route_targets=__ret__.evpn_es_import_route_targets,
        export=__ret__.export,
        gshut=__ret__.gshut,
        id=__ret__.id,
        internet=__ret__.internet,
        local_as=__ret__.local_as,
        location=__ret__.location,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_ip_community_list)
def get_ip_community_list_output(ip_community_list_name: Optional[pulumi.Input[str]] = None,
                                 resource_group_name: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIpCommunityListResult]:
    """
    Implements Ip Community List GET method.


    :param str ip_community_list_name: Name of the Ip Community List
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
