# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ExternalNetworkArgs', 'ExternalNetwork']

@pulumi.input_type
class ExternalNetworkArgs:
    def __init__(__self__, *,
                 l3_isolation_domain_name: pulumi.Input[str],
                 peering_option: pulumi.Input[Union[str, 'PeeringOption']],
                 resource_group_name: pulumi.Input[str],
                 annotation: Optional[pulumi.Input[str]] = None,
                 export_route_policy_id: Optional[pulumi.Input[str]] = None,
                 external_network_name: Optional[pulumi.Input[str]] = None,
                 import_route_policy_id: Optional[pulumi.Input[str]] = None,
                 option_a_properties: Optional[pulumi.Input['ExternalNetworkPropertiesOptionAPropertiesArgs']] = None,
                 option_b_properties: Optional[pulumi.Input['OptionBPropertiesArgs']] = None):
        """
        The set of arguments for constructing a ExternalNetwork resource.
        :param pulumi.Input[str] l3_isolation_domain_name: Name of the L3IsolationDomain
        :param pulumi.Input[Union[str, 'PeeringOption']] peering_option: Peering option list.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] annotation: Switch configuration description.
        :param pulumi.Input[str] export_route_policy_id: ARM resource ID of exportRoutePolicy.
        :param pulumi.Input[str] external_network_name: Name of the ExternalNetwork
        :param pulumi.Input[str] import_route_policy_id: ARM resource ID of importRoutePolicy.
        :param pulumi.Input['ExternalNetworkPropertiesOptionAPropertiesArgs'] option_a_properties: option A properties object
        :param pulumi.Input['OptionBPropertiesArgs'] option_b_properties: option B properties object
        """
        pulumi.set(__self__, "l3_isolation_domain_name", l3_isolation_domain_name)
        pulumi.set(__self__, "peering_option", peering_option)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if export_route_policy_id is not None:
            pulumi.set(__self__, "export_route_policy_id", export_route_policy_id)
        if external_network_name is not None:
            pulumi.set(__self__, "external_network_name", external_network_name)
        if import_route_policy_id is not None:
            pulumi.set(__self__, "import_route_policy_id", import_route_policy_id)
        if option_a_properties is not None:
            pulumi.set(__self__, "option_a_properties", option_a_properties)
        if option_b_properties is not None:
            pulumi.set(__self__, "option_b_properties", option_b_properties)

    @property
    @pulumi.getter(name="l3IsolationDomainName")
    def l3_isolation_domain_name(self) -> pulumi.Input[str]:
        """
        Name of the L3IsolationDomain
        """
        return pulumi.get(self, "l3_isolation_domain_name")

    @l3_isolation_domain_name.setter
    def l3_isolation_domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "l3_isolation_domain_name", value)

    @property
    @pulumi.getter(name="peeringOption")
    def peering_option(self) -> pulumi.Input[Union[str, 'PeeringOption']]:
        """
        Peering option list.
        """
        return pulumi.get(self, "peering_option")

    @peering_option.setter
    def peering_option(self, value: pulumi.Input[Union[str, 'PeeringOption']]):
        pulumi.set(self, "peering_option", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def annotation(self) -> Optional[pulumi.Input[str]]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation", value)

    @property
    @pulumi.getter(name="exportRoutePolicyId")
    def export_route_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of exportRoutePolicy.
        """
        return pulumi.get(self, "export_route_policy_id")

    @export_route_policy_id.setter
    def export_route_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "export_route_policy_id", value)

    @property
    @pulumi.getter(name="externalNetworkName")
    def external_network_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the ExternalNetwork
        """
        return pulumi.get(self, "external_network_name")

    @external_network_name.setter
    def external_network_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_network_name", value)

    @property
    @pulumi.getter(name="importRoutePolicyId")
    def import_route_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of importRoutePolicy.
        """
        return pulumi.get(self, "import_route_policy_id")

    @import_route_policy_id.setter
    def import_route_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "import_route_policy_id", value)

    @property
    @pulumi.getter(name="optionAProperties")
    def option_a_properties(self) -> Optional[pulumi.Input['ExternalNetworkPropertiesOptionAPropertiesArgs']]:
        """
        option A properties object
        """
        return pulumi.get(self, "option_a_properties")

    @option_a_properties.setter
    def option_a_properties(self, value: Optional[pulumi.Input['ExternalNetworkPropertiesOptionAPropertiesArgs']]):
        pulumi.set(self, "option_a_properties", value)

    @property
    @pulumi.getter(name="optionBProperties")
    def option_b_properties(self) -> Optional[pulumi.Input['OptionBPropertiesArgs']]:
        """
        option B properties object
        """
        return pulumi.get(self, "option_b_properties")

    @option_b_properties.setter
    def option_b_properties(self, value: Optional[pulumi.Input['OptionBPropertiesArgs']]):
        pulumi.set(self, "option_b_properties", value)


class ExternalNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotation: Optional[pulumi.Input[str]] = None,
                 export_route_policy_id: Optional[pulumi.Input[str]] = None,
                 external_network_name: Optional[pulumi.Input[str]] = None,
                 import_route_policy_id: Optional[pulumi.Input[str]] = None,
                 l3_isolation_domain_name: Optional[pulumi.Input[str]] = None,
                 option_a_properties: Optional[pulumi.Input[pulumi.InputType['ExternalNetworkPropertiesOptionAPropertiesArgs']]] = None,
                 option_b_properties: Optional[pulumi.Input[pulumi.InputType['OptionBPropertiesArgs']]] = None,
                 peering_option: Optional[pulumi.Input[Union[str, 'PeeringOption']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Defines the ExternalNetwork item.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] annotation: Switch configuration description.
        :param pulumi.Input[str] export_route_policy_id: ARM resource ID of exportRoutePolicy.
        :param pulumi.Input[str] external_network_name: Name of the ExternalNetwork
        :param pulumi.Input[str] import_route_policy_id: ARM resource ID of importRoutePolicy.
        :param pulumi.Input[str] l3_isolation_domain_name: Name of the L3IsolationDomain
        :param pulumi.Input[pulumi.InputType['ExternalNetworkPropertiesOptionAPropertiesArgs']] option_a_properties: option A properties object
        :param pulumi.Input[pulumi.InputType['OptionBPropertiesArgs']] option_b_properties: option B properties object
        :param pulumi.Input[Union[str, 'PeeringOption']] peering_option: Peering option list.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Defines the ExternalNetwork item.

        :param str resource_name: The name of the resource.
        :param ExternalNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotation: Optional[pulumi.Input[str]] = None,
                 export_route_policy_id: Optional[pulumi.Input[str]] = None,
                 external_network_name: Optional[pulumi.Input[str]] = None,
                 import_route_policy_id: Optional[pulumi.Input[str]] = None,
                 l3_isolation_domain_name: Optional[pulumi.Input[str]] = None,
                 option_a_properties: Optional[pulumi.Input[pulumi.InputType['ExternalNetworkPropertiesOptionAPropertiesArgs']]] = None,
                 option_b_properties: Optional[pulumi.Input[pulumi.InputType['OptionBPropertiesArgs']]] = None,
                 peering_option: Optional[pulumi.Input[Union[str, 'PeeringOption']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalNetworkArgs.__new__(ExternalNetworkArgs)

            __props__.__dict__["annotation"] = annotation
            __props__.__dict__["export_route_policy_id"] = export_route_policy_id
            __props__.__dict__["external_network_name"] = external_network_name
            __props__.__dict__["import_route_policy_id"] = import_route_policy_id
            if l3_isolation_domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'l3_isolation_domain_name'")
            __props__.__dict__["l3_isolation_domain_name"] = l3_isolation_domain_name
            __props__.__dict__["option_a_properties"] = option_a_properties
            __props__.__dict__["option_b_properties"] = option_b_properties
            if peering_option is None and not opts.urn:
                raise TypeError("Missing required property 'peering_option'")
            __props__.__dict__["peering_option"] = peering_option
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["administrative_state"] = None
            __props__.__dict__["disabled_on_resources"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["network_to_network_interconnect_id"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:managednetworkfabric:ExternalNetwork")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ExternalNetwork, __self__).__init__(
            'azure-native:managednetworkfabric/v20230201preview:ExternalNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ExternalNetwork':
        """
        Get an existing ExternalNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ExternalNetworkArgs.__new__(ExternalNetworkArgs)

        __props__.__dict__["administrative_state"] = None
        __props__.__dict__["annotation"] = None
        __props__.__dict__["disabled_on_resources"] = None
        __props__.__dict__["export_route_policy_id"] = None
        __props__.__dict__["import_route_policy_id"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["network_to_network_interconnect_id"] = None
        __props__.__dict__["option_a_properties"] = None
        __props__.__dict__["option_b_properties"] = None
        __props__.__dict__["peering_option"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["type"] = None
        return ExternalNetwork(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="administrativeState")
    def administrative_state(self) -> pulumi.Output[str]:
        """
        AdministrativeState of the externalNetwork. Example: Enabled | Disabled.
        """
        return pulumi.get(self, "administrative_state")

    @property
    @pulumi.getter
    def annotation(self) -> pulumi.Output[Optional[str]]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter(name="disabledOnResources")
    def disabled_on_resources(self) -> pulumi.Output[Sequence[str]]:
        """
        List of resources the externalNetwork is disabled on. Can be either entire NetworkFabric or NetworkRack.
        """
        return pulumi.get(self, "disabled_on_resources")

    @property
    @pulumi.getter(name="exportRoutePolicyId")
    def export_route_policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        ARM resource ID of exportRoutePolicy.
        """
        return pulumi.get(self, "export_route_policy_id")

    @property
    @pulumi.getter(name="importRoutePolicyId")
    def import_route_policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        ARM resource ID of importRoutePolicy.
        """
        return pulumi.get(self, "import_route_policy_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkToNetworkInterconnectId")
    def network_to_network_interconnect_id(self) -> pulumi.Output[str]:
        """
        Gets the networkToNetworkInterconnectId of the resource.
        """
        return pulumi.get(self, "network_to_network_interconnect_id")

    @property
    @pulumi.getter(name="optionAProperties")
    def option_a_properties(self) -> pulumi.Output[Optional['outputs.ExternalNetworkPropertiesResponseOptionAProperties']]:
        """
        option A properties object
        """
        return pulumi.get(self, "option_a_properties")

    @property
    @pulumi.getter(name="optionBProperties")
    def option_b_properties(self) -> pulumi.Output[Optional['outputs.OptionBPropertiesResponse']]:
        """
        option B properties object
        """
        return pulumi.get(self, "option_b_properties")

    @property
    @pulumi.getter(name="peeringOption")
    def peering_option(self) -> pulumi.Output[str]:
        """
        Peering option list.
        """
        return pulumi.get(self, "peering_option")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        Gets the provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

