# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AccessControlListPropertiesConditionsArgs',
    'ExpressRouteConnectionInformationArgs',
    'ExternalNetworkPropertiesOptionAPropertiesArgs',
    'FabricOptionBPropertiesArgs',
    'InternalNetworkPatchablePropertiesBgpConfigurationArgs',
    'InternalNetworkPatchablePropertiesConnectedIPv4SubnetsArgs',
    'InternalNetworkPatchablePropertiesConnectedIPv6SubnetsArgs',
    'InternalNetworkPatchablePropertiesIpv4NeighborAddressArgs',
    'InternalNetworkPatchablePropertiesIpv4RoutesArgs',
    'InternalNetworkPatchablePropertiesIpv6NeighborAddressArgs',
    'InternalNetworkPatchablePropertiesIpv6RoutesArgs',
    'InternalNetworkPatchablePropertiesStaticRouteConfigurationArgs',
    'IpCommunityListPropertiesCommunityMembersArgs',
    'IpCommunityListPropertiesEvpnEsImportRouteTargetsArgs',
    'L3IsolationDomainPatchPropertiesAggregateRouteConfigurationArgs',
    'L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs',
    'L3IsolationDomainPatchPropertiesIpv4RoutesArgs',
    'L3IsolationDomainPatchPropertiesIpv6RoutesArgs',
    'Layer3ConfigurationArgs',
    'NetworkFabricControllerPropertiesManagedResourceGroupConfigurationArgs',
    'NetworkFabricPropertiesInfrastructureVpnConfigurationArgs',
    'NetworkFabricPropertiesManagementNetworkConfigurationArgs',
    'NetworkFabricPropertiesTerminalServerConfigurationArgs',
    'NetworkFabricPropertiesWorkloadVpnConfigurationArgs',
    'NetworkToNetworkInterconnectPropertiesLayer2ConfigurationArgs',
    'OptionAPropertiesArgs',
    'OptionBPropertiesArgs',
    'RoutePolicyPropertiesActionArgs',
    'RoutePolicyPropertiesConditionsArgs',
    'RoutePolicyPropertiesMatchArgs',
    'RoutePolicyPropertiesSetSetArgs',
    'RoutePolicyPropertiesSetArgs',
]

@pulumi.input_type
class AccessControlListPropertiesConditionsArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[Union[str, 'ConditionActionType']],
                 destination_address: pulumi.Input[str],
                 destination_port: pulumi.Input[str],
                 protocol: pulumi.Input[int],
                 sequence_number: pulumi.Input[int],
                 source_address: pulumi.Input[str],
                 source_port: pulumi.Input[str],
                 annotation: Optional[pulumi.Input[str]] = None):
        """
        Access Control List condition model.
        :param pulumi.Input[Union[str, 'ConditionActionType']] action: action. Example: allow | deny.
        :param pulumi.Input[str] destination_address: destinationAddress. Example: any | 1.1.1.0/24 | 1.1.10.10
        :param pulumi.Input[str] destination_port: destinationPort. Example: any | 1253
        :param pulumi.Input[int] protocol: TCP/IP protocol as defined in the list of IP protocol numbers. Example: 255 (any) | 0 | 1.
        :param pulumi.Input[int] sequence_number: sequenceNumber of the Access Control List.
        :param pulumi.Input[str] source_address: sourceAddress. Example: any | 1.1.1.0/24 | 1.1.10.10
        :param pulumi.Input[str] source_port: sourcePort. Example: any | 1253
        :param pulumi.Input[str] annotation: Switch configuration description.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "destination_address", destination_address)
        pulumi.set(__self__, "destination_port", destination_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "sequence_number", sequence_number)
        pulumi.set(__self__, "source_address", source_address)
        pulumi.set(__self__, "source_port", source_port)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[Union[str, 'ConditionActionType']]:
        """
        action. Example: allow | deny.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[Union[str, 'ConditionActionType']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="destinationAddress")
    def destination_address(self) -> pulumi.Input[str]:
        """
        destinationAddress. Example: any | 1.1.1.0/24 | 1.1.10.10
        """
        return pulumi.get(self, "destination_address")

    @destination_address.setter
    def destination_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_address", value)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> pulumi.Input[str]:
        """
        destinationPort. Example: any | 1253
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[int]:
        """
        TCP/IP protocol as defined in the list of IP protocol numbers. Example: 255 (any) | 0 | 1.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[int]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sequenceNumber")
    def sequence_number(self) -> pulumi.Input[int]:
        """
        sequenceNumber of the Access Control List.
        """
        return pulumi.get(self, "sequence_number")

    @sequence_number.setter
    def sequence_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "sequence_number", value)

    @property
    @pulumi.getter(name="sourceAddress")
    def source_address(self) -> pulumi.Input[str]:
        """
        sourceAddress. Example: any | 1.1.1.0/24 | 1.1.10.10
        """
        return pulumi.get(self, "source_address")

    @source_address.setter
    def source_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_address", value)

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> pulumi.Input[str]:
        """
        sourcePort. Example: any | 1253
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_port", value)

    @property
    @pulumi.getter
    def annotation(self) -> Optional[pulumi.Input[str]]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation", value)


@pulumi.input_type
class ExpressRouteConnectionInformationArgs:
    def __init__(__self__, *,
                 express_route_authorization_key: pulumi.Input[str],
                 express_route_circuit_id: pulumi.Input[str]):
        """
        The ExpressRoute circuit ID and the Auth Key are required for you to successfully deploy NFC service.
        :param pulumi.Input[str] express_route_authorization_key: Authorization key for the circuit, must be of type Microsoft.Network/expressRouteCircuits/authorizations. The Auth Key is a mandatory attribute.
        :param pulumi.Input[str] express_route_circuit_id: The express route circuit Azure resource ID, must be of type Microsoft.Network/expressRouteCircuits/circuitName. The ExpressRoute Circuit is a mandatory attribute.
        """
        pulumi.set(__self__, "express_route_authorization_key", express_route_authorization_key)
        pulumi.set(__self__, "express_route_circuit_id", express_route_circuit_id)

    @property
    @pulumi.getter(name="expressRouteAuthorizationKey")
    def express_route_authorization_key(self) -> pulumi.Input[str]:
        """
        Authorization key for the circuit, must be of type Microsoft.Network/expressRouteCircuits/authorizations. The Auth Key is a mandatory attribute.
        """
        return pulumi.get(self, "express_route_authorization_key")

    @express_route_authorization_key.setter
    def express_route_authorization_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "express_route_authorization_key", value)

    @property
    @pulumi.getter(name="expressRouteCircuitId")
    def express_route_circuit_id(self) -> pulumi.Input[str]:
        """
        The express route circuit Azure resource ID, must be of type Microsoft.Network/expressRouteCircuits/circuitName. The ExpressRoute Circuit is a mandatory attribute.
        """
        return pulumi.get(self, "express_route_circuit_id")

    @express_route_circuit_id.setter
    def express_route_circuit_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "express_route_circuit_id", value)


@pulumi.input_type
class ExternalNetworkPropertiesOptionAPropertiesArgs:
    def __init__(__self__, *,
                 peer_asn: pulumi.Input[int],
                 vlan_id: pulumi.Input[int],
                 mtu: Optional[pulumi.Input[int]] = None,
                 primary_ipv4_prefix: Optional[pulumi.Input[str]] = None,
                 primary_ipv6_prefix: Optional[pulumi.Input[str]] = None,
                 secondary_ipv4_prefix: Optional[pulumi.Input[str]] = None,
                 secondary_ipv6_prefix: Optional[pulumi.Input[str]] = None):
        """
        option A properties object
        :param pulumi.Input[int] peer_asn: Peer ASN number.Example : 28
        :param pulumi.Input[int] vlan_id: Vlan identifier. Example : 501
        :param pulumi.Input[int] mtu: MTU to use for option A peering.
        :param pulumi.Input[str] primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.23.1.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param pulumi.Input[str] primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a1/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param pulumi.Input[str] secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.23.1.2/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param pulumi.Input[str] secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a1/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        pulumi.set(__self__, "peer_asn", peer_asn)
        pulumi.set(__self__, "vlan_id", vlan_id)
        if mtu is None:
            mtu = 1500
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if primary_ipv4_prefix is not None:
            pulumi.set(__self__, "primary_ipv4_prefix", primary_ipv4_prefix)
        if primary_ipv6_prefix is not None:
            pulumi.set(__self__, "primary_ipv6_prefix", primary_ipv6_prefix)
        if secondary_ipv4_prefix is not None:
            pulumi.set(__self__, "secondary_ipv4_prefix", secondary_ipv4_prefix)
        if secondary_ipv6_prefix is not None:
            pulumi.set(__self__, "secondary_ipv6_prefix", secondary_ipv6_prefix)

    @property
    @pulumi.getter(name="peerASN")
    def peer_asn(self) -> pulumi.Input[int]:
        """
        Peer ASN number.Example : 28
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: pulumi.Input[int]):
        pulumi.set(self, "peer_asn", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Input[int]:
        """
        Vlan identifier. Example : 501
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[int]]:
        """
        MTU to use for option A peering.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter(name="primaryIpv4Prefix")
    def primary_ipv4_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.23.1.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "primary_ipv4_prefix")

    @primary_ipv4_prefix.setter
    def primary_ipv4_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_ipv4_prefix", value)

    @property
    @pulumi.getter(name="primaryIpv6Prefix")
    def primary_ipv6_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a1/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "primary_ipv6_prefix")

    @primary_ipv6_prefix.setter
    def primary_ipv6_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_ipv6_prefix", value)

    @property
    @pulumi.getter(name="secondaryIpv4Prefix")
    def secondary_ipv4_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Secondary IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.23.1.2/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "secondary_ipv4_prefix")

    @secondary_ipv4_prefix.setter
    def secondary_ipv4_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_ipv4_prefix", value)

    @property
    @pulumi.getter(name="secondaryIpv6Prefix")
    def secondary_ipv6_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Secondary IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a1/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "secondary_ipv6_prefix")

    @secondary_ipv6_prefix.setter
    def secondary_ipv6_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_ipv6_prefix", value)


@pulumi.input_type
class FabricOptionBPropertiesArgs:
    def __init__(__self__, *,
                 export_route_targets: pulumi.Input[Sequence[pulumi.Input[str]]],
                 import_route_targets: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Option B configuration to be used for management vpn.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] export_route_targets: Route Targets to be applied for outgoing routes from CE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] import_route_targets: Route Targets to be applied for incoming routes into CE.
        """
        pulumi.set(__self__, "export_route_targets", export_route_targets)
        pulumi.set(__self__, "import_route_targets", import_route_targets)

    @property
    @pulumi.getter(name="exportRouteTargets")
    def export_route_targets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Route Targets to be applied for outgoing routes from CE.
        """
        return pulumi.get(self, "export_route_targets")

    @export_route_targets.setter
    def export_route_targets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "export_route_targets", value)

    @property
    @pulumi.getter(name="importRouteTargets")
    def import_route_targets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Route Targets to be applied for incoming routes into CE.
        """
        return pulumi.get(self, "import_route_targets")

    @import_route_targets.setter
    def import_route_targets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "import_route_targets", value)


@pulumi.input_type
class InternalNetworkPatchablePropertiesBgpConfigurationArgs:
    def __init__(__self__, *,
                 peer_asn: pulumi.Input[int],
                 allow_as: Optional[pulumi.Input[int]] = None,
                 allow_as_override: Optional[pulumi.Input[Union[str, 'AllowASOverride']]] = None,
                 annotation: Optional[pulumi.Input[str]] = None,
                 default_route_originate: Optional[pulumi.Input[Union[str, 'BooleanEnumProperty']]] = None,
                 ipv4_listen_range_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv4_neighbor_address: Optional[pulumi.Input[Sequence[pulumi.Input['InternalNetworkPatchablePropertiesIpv4NeighborAddressArgs']]]] = None,
                 ipv6_listen_range_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv6_neighbor_address: Optional[pulumi.Input[Sequence[pulumi.Input['InternalNetworkPatchablePropertiesIpv6NeighborAddressArgs']]]] = None):
        """
        BGP configuration properties
        :param pulumi.Input[int] peer_asn: Peer ASN. Example: 65047.
        :param pulumi.Input[int] allow_as: Allows for routes to be received and processed even if the router detects its own ASN in the AS-Path. 0 is disable, Possible values are 1-10, default is 2.
        :param pulumi.Input[Union[str, 'AllowASOverride']] allow_as_override: Enable Or Disable state.
        :param pulumi.Input[str] annotation: Switch configuration description.
        :param pulumi.Input[Union[str, 'BooleanEnumProperty']] default_route_originate: Originate a defaultRoute. Ex: "True" | "False".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv4_listen_range_prefixes: BGP Ipv4 ListenRange.
        :param pulumi.Input[Sequence[pulumi.Input['InternalNetworkPatchablePropertiesIpv4NeighborAddressArgs']]] ipv4_neighbor_address: List with stringified ipv4NeighborAddresses.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv6_listen_range_prefixes: BGP Ipv6 ListenRange.
        :param pulumi.Input[Sequence[pulumi.Input['InternalNetworkPatchablePropertiesIpv6NeighborAddressArgs']]] ipv6_neighbor_address: List with stringified ipv6NeighborAddress.
        """
        pulumi.set(__self__, "peer_asn", peer_asn)
        if allow_as is None:
            allow_as = 2
        if allow_as is not None:
            pulumi.set(__self__, "allow_as", allow_as)
        if allow_as_override is not None:
            pulumi.set(__self__, "allow_as_override", allow_as_override)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if default_route_originate is not None:
            pulumi.set(__self__, "default_route_originate", default_route_originate)
        if ipv4_listen_range_prefixes is not None:
            pulumi.set(__self__, "ipv4_listen_range_prefixes", ipv4_listen_range_prefixes)
        if ipv4_neighbor_address is not None:
            pulumi.set(__self__, "ipv4_neighbor_address", ipv4_neighbor_address)
        if ipv6_listen_range_prefixes is not None:
            pulumi.set(__self__, "ipv6_listen_range_prefixes", ipv6_listen_range_prefixes)
        if ipv6_neighbor_address is not None:
            pulumi.set(__self__, "ipv6_neighbor_address", ipv6_neighbor_address)

    @property
    @pulumi.getter(name="peerASN")
    def peer_asn(self) -> pulumi.Input[int]:
        """
        Peer ASN. Example: 65047.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: pulumi.Input[int]):
        pulumi.set(self, "peer_asn", value)

    @property
    @pulumi.getter(name="allowAS")
    def allow_as(self) -> Optional[pulumi.Input[int]]:
        """
        Allows for routes to be received and processed even if the router detects its own ASN in the AS-Path. 0 is disable, Possible values are 1-10, default is 2.
        """
        return pulumi.get(self, "allow_as")

    @allow_as.setter
    def allow_as(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allow_as", value)

    @property
    @pulumi.getter(name="allowASOverride")
    def allow_as_override(self) -> Optional[pulumi.Input[Union[str, 'AllowASOverride']]]:
        """
        Enable Or Disable state.
        """
        return pulumi.get(self, "allow_as_override")

    @allow_as_override.setter
    def allow_as_override(self, value: Optional[pulumi.Input[Union[str, 'AllowASOverride']]]):
        pulumi.set(self, "allow_as_override", value)

    @property
    @pulumi.getter
    def annotation(self) -> Optional[pulumi.Input[str]]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation", value)

    @property
    @pulumi.getter(name="defaultRouteOriginate")
    def default_route_originate(self) -> Optional[pulumi.Input[Union[str, 'BooleanEnumProperty']]]:
        """
        Originate a defaultRoute. Ex: "True" | "False".
        """
        return pulumi.get(self, "default_route_originate")

    @default_route_originate.setter
    def default_route_originate(self, value: Optional[pulumi.Input[Union[str, 'BooleanEnumProperty']]]):
        pulumi.set(self, "default_route_originate", value)

    @property
    @pulumi.getter(name="ipv4ListenRangePrefixes")
    def ipv4_listen_range_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        BGP Ipv4 ListenRange.
        """
        return pulumi.get(self, "ipv4_listen_range_prefixes")

    @ipv4_listen_range_prefixes.setter
    def ipv4_listen_range_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipv4_listen_range_prefixes", value)

    @property
    @pulumi.getter(name="ipv4NeighborAddress")
    def ipv4_neighbor_address(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InternalNetworkPatchablePropertiesIpv4NeighborAddressArgs']]]]:
        """
        List with stringified ipv4NeighborAddresses.
        """
        return pulumi.get(self, "ipv4_neighbor_address")

    @ipv4_neighbor_address.setter
    def ipv4_neighbor_address(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InternalNetworkPatchablePropertiesIpv4NeighborAddressArgs']]]]):
        pulumi.set(self, "ipv4_neighbor_address", value)

    @property
    @pulumi.getter(name="ipv6ListenRangePrefixes")
    def ipv6_listen_range_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        BGP Ipv6 ListenRange.
        """
        return pulumi.get(self, "ipv6_listen_range_prefixes")

    @ipv6_listen_range_prefixes.setter
    def ipv6_listen_range_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipv6_listen_range_prefixes", value)

    @property
    @pulumi.getter(name="ipv6NeighborAddress")
    def ipv6_neighbor_address(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InternalNetworkPatchablePropertiesIpv6NeighborAddressArgs']]]]:
        """
        List with stringified ipv6NeighborAddress.
        """
        return pulumi.get(self, "ipv6_neighbor_address")

    @ipv6_neighbor_address.setter
    def ipv6_neighbor_address(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InternalNetworkPatchablePropertiesIpv6NeighborAddressArgs']]]]):
        pulumi.set(self, "ipv6_neighbor_address", value)


@pulumi.input_type
class InternalNetworkPatchablePropertiesConnectedIPv4SubnetsArgs:
    def __init__(__self__, *,
                 annotation: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None):
        """
        connectedIPv4Subnet model.
        :param pulumi.Input[str] annotation: Switch configuration description.
        :param pulumi.Input[str] prefix: Ipv4 Prefix of the connectedIPv4Subnet.
        """
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def annotation(self) -> Optional[pulumi.Input[str]]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Ipv4 Prefix of the connectedIPv4Subnet.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class InternalNetworkPatchablePropertiesConnectedIPv6SubnetsArgs:
    def __init__(__self__, *,
                 annotation: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None):
        """
        connectedIPv6Subnet model.
        :param pulumi.Input[str] annotation: Switch configuration description.
        :param pulumi.Input[str] prefix: Ipv6 Prefix of the connectedIPv6Subnet.
        """
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def annotation(self) -> Optional[pulumi.Input[str]]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Ipv6 Prefix of the connectedIPv6Subnet.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class InternalNetworkPatchablePropertiesIpv4NeighborAddressArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None):
        """
        ipv4NeighborAddress model.
        :param pulumi.Input[str] address: IP Address of the IPv4NeighborAddress.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        IP Address of the IPv4NeighborAddress.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)


@pulumi.input_type
class InternalNetworkPatchablePropertiesIpv4RoutesArgs:
    def __init__(__self__, *,
                 next_hop: pulumi.Input[Sequence[pulumi.Input[str]]],
                 prefix: pulumi.Input[str]):
        """
        staticIpv4Route model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] next_hop: List of next hop IPv4 addresses.
        :param pulumi.Input[str] prefix: IPv4 prefix of the staticIpv4Route.
        """
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of next hop IPv4 addresses.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "next_hop", value)

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[str]:
        """
        IPv4 prefix of the staticIpv4Route.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class InternalNetworkPatchablePropertiesIpv6NeighborAddressArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None):
        """
        ipv6NeighborAddress model.
        :param pulumi.Input[str] address: ip address of the ipv6NeighborAddress.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        ip address of the ipv6NeighborAddress.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)


@pulumi.input_type
class InternalNetworkPatchablePropertiesIpv6RoutesArgs:
    def __init__(__self__, *,
                 next_hop: pulumi.Input[Sequence[pulumi.Input[str]]],
                 prefix: pulumi.Input[str]):
        """
        staticIPv6Route model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] next_hop: List of next hop IPv6 addresses.
        :param pulumi.Input[str] prefix: IPv6 prefix of the staticIPv6Route.
        """
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of next hop IPv6 addresses.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "next_hop", value)

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[str]:
        """
        IPv6 prefix of the staticIPv6Route.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class InternalNetworkPatchablePropertiesStaticRouteConfigurationArgs:
    def __init__(__self__, *,
                 ipv4_routes: Optional[pulumi.Input[Sequence[pulumi.Input['InternalNetworkPatchablePropertiesIpv4RoutesArgs']]]] = None,
                 ipv6_routes: Optional[pulumi.Input[Sequence[pulumi.Input['InternalNetworkPatchablePropertiesIpv6RoutesArgs']]]] = None):
        """
        staticRouteConfiguration model.
        :param pulumi.Input[Sequence[pulumi.Input['InternalNetworkPatchablePropertiesIpv4RoutesArgs']]] ipv4_routes: List with object IPv4Routes.
        :param pulumi.Input[Sequence[pulumi.Input['InternalNetworkPatchablePropertiesIpv6RoutesArgs']]] ipv6_routes: List with object IPv6Routes.
        """
        if ipv4_routes is not None:
            pulumi.set(__self__, "ipv4_routes", ipv4_routes)
        if ipv6_routes is not None:
            pulumi.set(__self__, "ipv6_routes", ipv6_routes)

    @property
    @pulumi.getter(name="ipv4Routes")
    def ipv4_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InternalNetworkPatchablePropertiesIpv4RoutesArgs']]]]:
        """
        List with object IPv4Routes.
        """
        return pulumi.get(self, "ipv4_routes")

    @ipv4_routes.setter
    def ipv4_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InternalNetworkPatchablePropertiesIpv4RoutesArgs']]]]):
        pulumi.set(self, "ipv4_routes", value)

    @property
    @pulumi.getter(name="ipv6Routes")
    def ipv6_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InternalNetworkPatchablePropertiesIpv6RoutesArgs']]]]:
        """
        List with object IPv6Routes.
        """
        return pulumi.get(self, "ipv6_routes")

    @ipv6_routes.setter
    def ipv6_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InternalNetworkPatchablePropertiesIpv6RoutesArgs']]]]):
        pulumi.set(self, "ipv6_routes", value)


@pulumi.input_type
class IpCommunityListPropertiesCommunityMembersArgs:
    def __init__(__self__, *,
                 annotation: pulumi.Input[str],
                 community_member: pulumi.Input[str]):
        """
        Ip Community List communityMembers model.
        :param pulumi.Input[str] annotation: Switch configuration description.
        :param pulumi.Input[str] community_member: communityMember of the Ip Community List. Example: 100:200
        """
        pulumi.set(__self__, "annotation", annotation)
        pulumi.set(__self__, "community_member", community_member)

    @property
    @pulumi.getter
    def annotation(self) -> pulumi.Input[str]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: pulumi.Input[str]):
        pulumi.set(self, "annotation", value)

    @property
    @pulumi.getter(name="communityMember")
    def community_member(self) -> pulumi.Input[str]:
        """
        communityMember of the Ip Community List. Example: 100:200
        """
        return pulumi.get(self, "community_member")

    @community_member.setter
    def community_member(self, value: pulumi.Input[str]):
        pulumi.set(self, "community_member", value)


@pulumi.input_type
class IpCommunityListPropertiesEvpnEsImportRouteTargetsArgs:
    def __init__(__self__, *,
                 evpn_es_import_route_target: pulumi.Input[str],
                 annotation: Optional[pulumi.Input[str]] = None):
        """
        Ip Community List evpnEsImportRouteTarget model.
        :param pulumi.Input[str] evpn_es_import_route_target: evpnEsImportRouteTarget of the Ip Community List. Example: 100:400
        :param pulumi.Input[str] annotation: Switch configuration description.
        """
        pulumi.set(__self__, "evpn_es_import_route_target", evpn_es_import_route_target)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)

    @property
    @pulumi.getter(name="evpnEsImportRouteTarget")
    def evpn_es_import_route_target(self) -> pulumi.Input[str]:
        """
        evpnEsImportRouteTarget of the Ip Community List. Example: 100:400
        """
        return pulumi.get(self, "evpn_es_import_route_target")

    @evpn_es_import_route_target.setter
    def evpn_es_import_route_target(self, value: pulumi.Input[str]):
        pulumi.set(self, "evpn_es_import_route_target", value)

    @property
    @pulumi.getter
    def annotation(self) -> Optional[pulumi.Input[str]]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation", value)


@pulumi.input_type
class L3IsolationDomainPatchPropertiesAggregateRouteConfigurationArgs:
    def __init__(__self__, *,
                 ipv4_routes: Optional[pulumi.Input[Sequence[pulumi.Input['L3IsolationDomainPatchPropertiesIpv4RoutesArgs']]]] = None,
                 ipv6_routes: Optional[pulumi.Input[Sequence[pulumi.Input['L3IsolationDomainPatchPropertiesIpv6RoutesArgs']]]] = None):
        """
        List of Ipv4 and Ipv6 route configurations.
        :param pulumi.Input[Sequence[pulumi.Input['L3IsolationDomainPatchPropertiesIpv4RoutesArgs']]] ipv4_routes: List of Ipv4Route prefixes.
        :param pulumi.Input[Sequence[pulumi.Input['L3IsolationDomainPatchPropertiesIpv6RoutesArgs']]] ipv6_routes: List of Ipv6Routes prefixes.
        """
        if ipv4_routes is not None:
            pulumi.set(__self__, "ipv4_routes", ipv4_routes)
        if ipv6_routes is not None:
            pulumi.set(__self__, "ipv6_routes", ipv6_routes)

    @property
    @pulumi.getter(name="ipv4Routes")
    def ipv4_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['L3IsolationDomainPatchPropertiesIpv4RoutesArgs']]]]:
        """
        List of Ipv4Route prefixes.
        """
        return pulumi.get(self, "ipv4_routes")

    @ipv4_routes.setter
    def ipv4_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['L3IsolationDomainPatchPropertiesIpv4RoutesArgs']]]]):
        pulumi.set(self, "ipv4_routes", value)

    @property
    @pulumi.getter(name="ipv6Routes")
    def ipv6_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['L3IsolationDomainPatchPropertiesIpv6RoutesArgs']]]]:
        """
        List of Ipv6Routes prefixes.
        """
        return pulumi.get(self, "ipv6_routes")

    @ipv6_routes.setter
    def ipv6_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['L3IsolationDomainPatchPropertiesIpv6RoutesArgs']]]]):
        pulumi.set(self, "ipv6_routes", value)


@pulumi.input_type
class L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs:
    def __init__(__self__, *,
                 export_route_policy_id: Optional[pulumi.Input[str]] = None):
        """
        Connected Subnet RoutePolicy
        :param pulumi.Input[str] export_route_policy_id: exportRoutePolicyId value.
        """
        if export_route_policy_id is not None:
            pulumi.set(__self__, "export_route_policy_id", export_route_policy_id)

    @property
    @pulumi.getter(name="exportRoutePolicyId")
    def export_route_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        exportRoutePolicyId value.
        """
        return pulumi.get(self, "export_route_policy_id")

    @export_route_policy_id.setter
    def export_route_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "export_route_policy_id", value)


@pulumi.input_type
class L3IsolationDomainPatchPropertiesIpv4RoutesArgs:
    def __init__(__self__, *,
                 prefix: Optional[pulumi.Input[str]] = None):
        """
        aggregateIpv4Route model.
        :param pulumi.Input[str] prefix: IPv4 Prefix of the aggregate Ipv4Route.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 Prefix of the aggregate Ipv4Route.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class L3IsolationDomainPatchPropertiesIpv6RoutesArgs:
    def __init__(__self__, *,
                 prefix: Optional[pulumi.Input[str]] = None):
        """
        aggregateIpv6Route model.
        :param pulumi.Input[str] prefix: IPv6 Prefix of the aggregate IPv6 Route.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        IPv6 Prefix of the aggregate IPv6 Route.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class Layer3ConfigurationArgs:
    def __init__(__self__, *,
                 export_route_policy_id: Optional[pulumi.Input[str]] = None,
                 import_route_policy_id: Optional[pulumi.Input[str]] = None,
                 peer_asn: Optional[pulumi.Input[int]] = None,
                 primary_ipv4_prefix: Optional[pulumi.Input[str]] = None,
                 primary_ipv6_prefix: Optional[pulumi.Input[str]] = None,
                 secondary_ipv4_prefix: Optional[pulumi.Input[str]] = None,
                 secondary_ipv6_prefix: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None):
        """
        layer3Configuration
        :param pulumi.Input[str] export_route_policy_id: exportRoutePolicyId
        :param pulumi.Input[str] import_route_policy_id: importRoutePolicyId
        :param pulumi.Input[int] peer_asn: ASN of PE devices for CE/PE connectivity.Example : 28
        :param pulumi.Input[str] primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param pulumi.Input[str] primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param pulumi.Input[str] secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param pulumi.Input[str] secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param pulumi.Input[int] vlan_id: VLAN for CE/PE Layer 3 connectivity.Example : 501
        """
        if export_route_policy_id is not None:
            pulumi.set(__self__, "export_route_policy_id", export_route_policy_id)
        if import_route_policy_id is not None:
            pulumi.set(__self__, "import_route_policy_id", import_route_policy_id)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if primary_ipv4_prefix is None:
            primary_ipv4_prefix = '172.31.0.0/31'
        if primary_ipv4_prefix is not None:
            pulumi.set(__self__, "primary_ipv4_prefix", primary_ipv4_prefix)
        if primary_ipv6_prefix is None:
            primary_ipv6_prefix = '3FFE:FFFF:0:CD30::a0/126'
        if primary_ipv6_prefix is not None:
            pulumi.set(__self__, "primary_ipv6_prefix", primary_ipv6_prefix)
        if secondary_ipv4_prefix is None:
            secondary_ipv4_prefix = '172.31.0.20/31'
        if secondary_ipv4_prefix is not None:
            pulumi.set(__self__, "secondary_ipv4_prefix", secondary_ipv4_prefix)
        if secondary_ipv6_prefix is None:
            secondary_ipv6_prefix = '3FFE:FFFF:0:CD30::a4/126'
        if secondary_ipv6_prefix is not None:
            pulumi.set(__self__, "secondary_ipv6_prefix", secondary_ipv6_prefix)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter(name="exportRoutePolicyId")
    def export_route_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        exportRoutePolicyId
        """
        return pulumi.get(self, "export_route_policy_id")

    @export_route_policy_id.setter
    def export_route_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "export_route_policy_id", value)

    @property
    @pulumi.getter(name="importRoutePolicyId")
    def import_route_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        importRoutePolicyId
        """
        return pulumi.get(self, "import_route_policy_id")

    @import_route_policy_id.setter
    def import_route_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "import_route_policy_id", value)

    @property
    @pulumi.getter(name="peerASN")
    def peer_asn(self) -> Optional[pulumi.Input[int]]:
        """
        ASN of PE devices for CE/PE connectivity.Example : 28
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "peer_asn", value)

    @property
    @pulumi.getter(name="primaryIpv4Prefix")
    def primary_ipv4_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "primary_ipv4_prefix")

    @primary_ipv4_prefix.setter
    def primary_ipv4_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_ipv4_prefix", value)

    @property
    @pulumi.getter(name="primaryIpv6Prefix")
    def primary_ipv6_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "primary_ipv6_prefix")

    @primary_ipv6_prefix.setter
    def primary_ipv6_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_ipv6_prefix", value)

    @property
    @pulumi.getter(name="secondaryIpv4Prefix")
    def secondary_ipv4_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Secondary IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "secondary_ipv4_prefix")

    @secondary_ipv4_prefix.setter
    def secondary_ipv4_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_ipv4_prefix", value)

    @property
    @pulumi.getter(name="secondaryIpv6Prefix")
    def secondary_ipv6_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Secondary IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "secondary_ipv6_prefix")

    @secondary_ipv6_prefix.setter
    def secondary_ipv6_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_ipv6_prefix", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[int]]:
        """
        VLAN for CE/PE Layer 3 connectivity.Example : 501
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_id", value)


@pulumi.input_type
class NetworkFabricControllerPropertiesManagedResourceGroupConfigurationArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Managed Resource Group configuration properties.
        :param pulumi.Input[str] location: Managed resource group location.
        :param pulumi.Input[str] name: The NFC service will be hosted in a Managed resource group.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Managed resource group location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The NFC service will be hosted in a Managed resource group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class NetworkFabricPropertiesInfrastructureVpnConfigurationArgs:
    def __init__(__self__, *,
                 option_b_properties: pulumi.Input['FabricOptionBPropertiesArgs'],
                 option_a_properties: Optional[pulumi.Input['OptionAPropertiesArgs']] = None,
                 peering_option: Optional[pulumi.Input[Union[str, 'PeeringOption']]] = None):
        """
        Configuration for infrastructure vpn.
        :param pulumi.Input['FabricOptionBPropertiesArgs'] option_b_properties: option B properties
        :param pulumi.Input['OptionAPropertiesArgs'] option_a_properties: option A properties
        :param pulumi.Input[Union[str, 'PeeringOption']] peering_option: Peering option list.
        """
        pulumi.set(__self__, "option_b_properties", option_b_properties)
        if option_a_properties is not None:
            pulumi.set(__self__, "option_a_properties", option_a_properties)
        if peering_option is not None:
            pulumi.set(__self__, "peering_option", peering_option)

    @property
    @pulumi.getter(name="optionBProperties")
    def option_b_properties(self) -> pulumi.Input['FabricOptionBPropertiesArgs']:
        """
        option B properties
        """
        return pulumi.get(self, "option_b_properties")

    @option_b_properties.setter
    def option_b_properties(self, value: pulumi.Input['FabricOptionBPropertiesArgs']):
        pulumi.set(self, "option_b_properties", value)

    @property
    @pulumi.getter(name="optionAProperties")
    def option_a_properties(self) -> Optional[pulumi.Input['OptionAPropertiesArgs']]:
        """
        option A properties
        """
        return pulumi.get(self, "option_a_properties")

    @option_a_properties.setter
    def option_a_properties(self, value: Optional[pulumi.Input['OptionAPropertiesArgs']]):
        pulumi.set(self, "option_a_properties", value)

    @property
    @pulumi.getter(name="peeringOption")
    def peering_option(self) -> Optional[pulumi.Input[Union[str, 'PeeringOption']]]:
        """
        Peering option list.
        """
        return pulumi.get(self, "peering_option")

    @peering_option.setter
    def peering_option(self, value: Optional[pulumi.Input[Union[str, 'PeeringOption']]]):
        pulumi.set(self, "peering_option", value)


@pulumi.input_type
class NetworkFabricPropertiesManagementNetworkConfigurationArgs:
    def __init__(__self__, *,
                 infrastructure_vpn_configuration: pulumi.Input['NetworkFabricPropertiesInfrastructureVpnConfigurationArgs'],
                 workload_vpn_configuration: pulumi.Input['NetworkFabricPropertiesWorkloadVpnConfigurationArgs']):
        """
        Configuration to be used to setup the management network.
        :param pulumi.Input['NetworkFabricPropertiesInfrastructureVpnConfigurationArgs'] infrastructure_vpn_configuration: Configuration for infrastructure vpn.
        :param pulumi.Input['NetworkFabricPropertiesWorkloadVpnConfigurationArgs'] workload_vpn_configuration: Configuration for workload vpn.
        """
        pulumi.set(__self__, "infrastructure_vpn_configuration", infrastructure_vpn_configuration)
        pulumi.set(__self__, "workload_vpn_configuration", workload_vpn_configuration)

    @property
    @pulumi.getter(name="infrastructureVpnConfiguration")
    def infrastructure_vpn_configuration(self) -> pulumi.Input['NetworkFabricPropertiesInfrastructureVpnConfigurationArgs']:
        """
        Configuration for infrastructure vpn.
        """
        return pulumi.get(self, "infrastructure_vpn_configuration")

    @infrastructure_vpn_configuration.setter
    def infrastructure_vpn_configuration(self, value: pulumi.Input['NetworkFabricPropertiesInfrastructureVpnConfigurationArgs']):
        pulumi.set(self, "infrastructure_vpn_configuration", value)

    @property
    @pulumi.getter(name="workloadVpnConfiguration")
    def workload_vpn_configuration(self) -> pulumi.Input['NetworkFabricPropertiesWorkloadVpnConfigurationArgs']:
        """
        Configuration for workload vpn.
        """
        return pulumi.get(self, "workload_vpn_configuration")

    @workload_vpn_configuration.setter
    def workload_vpn_configuration(self, value: pulumi.Input['NetworkFabricPropertiesWorkloadVpnConfigurationArgs']):
        pulumi.set(self, "workload_vpn_configuration", value)


@pulumi.input_type
class NetworkFabricPropertiesTerminalServerConfigurationArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 primary_ipv4_prefix: pulumi.Input[str],
                 secondary_ipv4_prefix: pulumi.Input[str],
                 username: pulumi.Input[str],
                 primary_ipv6_prefix: Optional[pulumi.Input[str]] = None,
                 secondary_ipv6_prefix: Optional[pulumi.Input[str]] = None,
                 serial_number: Optional[pulumi.Input[str]] = None):
        """
        Network and credentials configuration currently applied to terminal server.
        :param pulumi.Input[str] password: Password for the terminal server connection.
        :param pulumi.Input[str] primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param pulumi.Input[str] secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param pulumi.Input[str] username: Username for the terminal server connection.
        :param pulumi.Input[str] primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param pulumi.Input[str] secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param pulumi.Input[str] serial_number: Serial Number of Terminal server.
        """
        pulumi.set(__self__, "password", password)
        if primary_ipv4_prefix is None:
            primary_ipv4_prefix = '172.31.0.0/31'
        pulumi.set(__self__, "primary_ipv4_prefix", primary_ipv4_prefix)
        if secondary_ipv4_prefix is None:
            secondary_ipv4_prefix = '172.31.0.20/31'
        pulumi.set(__self__, "secondary_ipv4_prefix", secondary_ipv4_prefix)
        pulumi.set(__self__, "username", username)
        if primary_ipv6_prefix is None:
            primary_ipv6_prefix = '3FFE:FFFF:0:CD30::a0/126'
        if primary_ipv6_prefix is not None:
            pulumi.set(__self__, "primary_ipv6_prefix", primary_ipv6_prefix)
        if secondary_ipv6_prefix is None:
            secondary_ipv6_prefix = '3FFE:FFFF:0:CD30::a4/126'
        if secondary_ipv6_prefix is not None:
            pulumi.set(__self__, "secondary_ipv6_prefix", secondary_ipv6_prefix)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Password for the terminal server connection.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="primaryIpv4Prefix")
    def primary_ipv4_prefix(self) -> pulumi.Input[str]:
        """
        IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "primary_ipv4_prefix")

    @primary_ipv4_prefix.setter
    def primary_ipv4_prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_ipv4_prefix", value)

    @property
    @pulumi.getter(name="secondaryIpv4Prefix")
    def secondary_ipv4_prefix(self) -> pulumi.Input[str]:
        """
        Secondary IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "secondary_ipv4_prefix")

    @secondary_ipv4_prefix.setter
    def secondary_ipv4_prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "secondary_ipv4_prefix", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        Username for the terminal server connection.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="primaryIpv6Prefix")
    def primary_ipv6_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "primary_ipv6_prefix")

    @primary_ipv6_prefix.setter
    def primary_ipv6_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_ipv6_prefix", value)

    @property
    @pulumi.getter(name="secondaryIpv6Prefix")
    def secondary_ipv6_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Secondary IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "secondary_ipv6_prefix")

    @secondary_ipv6_prefix.setter
    def secondary_ipv6_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_ipv6_prefix", value)

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[str]]:
        """
        Serial Number of Terminal server.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial_number", value)


@pulumi.input_type
class NetworkFabricPropertiesWorkloadVpnConfigurationArgs:
    def __init__(__self__, *,
                 option_b_properties: pulumi.Input['FabricOptionBPropertiesArgs'],
                 option_a_properties: Optional[pulumi.Input['OptionAPropertiesArgs']] = None,
                 peering_option: Optional[pulumi.Input[Union[str, 'PeeringOption']]] = None):
        """
        Configuration for workload vpn.
        :param pulumi.Input['FabricOptionBPropertiesArgs'] option_b_properties: option B properties object
        :param pulumi.Input['OptionAPropertiesArgs'] option_a_properties: option A properties object
        :param pulumi.Input[Union[str, 'PeeringOption']] peering_option: Peering option list.
        """
        pulumi.set(__self__, "option_b_properties", option_b_properties)
        if option_a_properties is not None:
            pulumi.set(__self__, "option_a_properties", option_a_properties)
        if peering_option is not None:
            pulumi.set(__self__, "peering_option", peering_option)

    @property
    @pulumi.getter(name="optionBProperties")
    def option_b_properties(self) -> pulumi.Input['FabricOptionBPropertiesArgs']:
        """
        option B properties object
        """
        return pulumi.get(self, "option_b_properties")

    @option_b_properties.setter
    def option_b_properties(self, value: pulumi.Input['FabricOptionBPropertiesArgs']):
        pulumi.set(self, "option_b_properties", value)

    @property
    @pulumi.getter(name="optionAProperties")
    def option_a_properties(self) -> Optional[pulumi.Input['OptionAPropertiesArgs']]:
        """
        option A properties object
        """
        return pulumi.get(self, "option_a_properties")

    @option_a_properties.setter
    def option_a_properties(self, value: Optional[pulumi.Input['OptionAPropertiesArgs']]):
        pulumi.set(self, "option_a_properties", value)

    @property
    @pulumi.getter(name="peeringOption")
    def peering_option(self) -> Optional[pulumi.Input[Union[str, 'PeeringOption']]]:
        """
        Peering option list.
        """
        return pulumi.get(self, "peering_option")

    @peering_option.setter
    def peering_option(self, value: Optional[pulumi.Input[Union[str, 'PeeringOption']]]):
        pulumi.set(self, "peering_option", value)


@pulumi.input_type
class NetworkToNetworkInterconnectPropertiesLayer2ConfigurationArgs:
    def __init__(__self__, *,
                 mtu: pulumi.Input[int],
                 port_count: Optional[pulumi.Input[int]] = None):
        """
        Common properties for Layer2Configuration.
        :param pulumi.Input[int] mtu: MTU of the packets between PE & CE.
        :param pulumi.Input[int] port_count: Number of ports connected between PE/CE. Maximum value depends on FabricSKU.
        """
        if mtu is None:
            mtu = 1500
        pulumi.set(__self__, "mtu", mtu)
        if port_count is not None:
            pulumi.set(__self__, "port_count", port_count)

    @property
    @pulumi.getter
    def mtu(self) -> pulumi.Input[int]:
        """
        MTU of the packets between PE & CE.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: pulumi.Input[int]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter(name="portCount")
    def port_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of ports connected between PE/CE. Maximum value depends on FabricSKU.
        """
        return pulumi.get(self, "port_count")

    @port_count.setter
    def port_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_count", value)


@pulumi.input_type
class OptionAPropertiesArgs:
    def __init__(__self__, *,
                 mtu: Optional[pulumi.Input[int]] = None,
                 peer_asn: Optional[pulumi.Input[int]] = None,
                 primary_ipv4_prefix: Optional[pulumi.Input[str]] = None,
                 primary_ipv6_prefix: Optional[pulumi.Input[str]] = None,
                 secondary_ipv4_prefix: Optional[pulumi.Input[str]] = None,
                 secondary_ipv6_prefix: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None):
        """
        Peering optionA properties
        :param pulumi.Input[int] mtu: MTU to use for option A peering.
        :param pulumi.Input[int] peer_asn: Peer ASN number.Example : 28
        :param pulumi.Input[str] primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param pulumi.Input[str] primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param pulumi.Input[str] secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param pulumi.Input[str] secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param pulumi.Input[int] vlan_id: Vlan Id.Example : 501
        """
        if mtu is None:
            mtu = 1500
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if primary_ipv4_prefix is None:
            primary_ipv4_prefix = '172.31.0.0/31'
        if primary_ipv4_prefix is not None:
            pulumi.set(__self__, "primary_ipv4_prefix", primary_ipv4_prefix)
        if primary_ipv6_prefix is None:
            primary_ipv6_prefix = '3FFE:FFFF:0:CD30::a0/126'
        if primary_ipv6_prefix is not None:
            pulumi.set(__self__, "primary_ipv6_prefix", primary_ipv6_prefix)
        if secondary_ipv4_prefix is None:
            secondary_ipv4_prefix = '172.31.0.20/31'
        if secondary_ipv4_prefix is not None:
            pulumi.set(__self__, "secondary_ipv4_prefix", secondary_ipv4_prefix)
        if secondary_ipv6_prefix is None:
            secondary_ipv6_prefix = '3FFE:FFFF:0:CD30::a4/126'
        if secondary_ipv6_prefix is not None:
            pulumi.set(__self__, "secondary_ipv6_prefix", secondary_ipv6_prefix)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[int]]:
        """
        MTU to use for option A peering.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter(name="peerASN")
    def peer_asn(self) -> Optional[pulumi.Input[int]]:
        """
        Peer ASN number.Example : 28
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "peer_asn", value)

    @property
    @pulumi.getter(name="primaryIpv4Prefix")
    def primary_ipv4_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "primary_ipv4_prefix")

    @primary_ipv4_prefix.setter
    def primary_ipv4_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_ipv4_prefix", value)

    @property
    @pulumi.getter(name="primaryIpv6Prefix")
    def primary_ipv6_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "primary_ipv6_prefix")

    @primary_ipv6_prefix.setter
    def primary_ipv6_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_ipv6_prefix", value)

    @property
    @pulumi.getter(name="secondaryIpv4Prefix")
    def secondary_ipv4_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Secondary IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "secondary_ipv4_prefix")

    @secondary_ipv4_prefix.setter
    def secondary_ipv4_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_ipv4_prefix", value)

    @property
    @pulumi.getter(name="secondaryIpv6Prefix")
    def secondary_ipv6_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Secondary IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "secondary_ipv6_prefix")

    @secondary_ipv6_prefix.setter
    def secondary_ipv6_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_ipv6_prefix", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[int]]:
        """
        Vlan Id.Example : 501
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_id", value)


@pulumi.input_type
class OptionBPropertiesArgs:
    def __init__(__self__, *,
                 export_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 import_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Option B configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] export_route_targets: Route Targets to be applied for outgoing routes from CE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] import_route_targets: Route Targets to be applied for incoming routes into CE.
        """
        if export_route_targets is not None:
            pulumi.set(__self__, "export_route_targets", export_route_targets)
        if import_route_targets is not None:
            pulumi.set(__self__, "import_route_targets", import_route_targets)

    @property
    @pulumi.getter(name="exportRouteTargets")
    def export_route_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Route Targets to be applied for outgoing routes from CE.
        """
        return pulumi.get(self, "export_route_targets")

    @export_route_targets.setter
    def export_route_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "export_route_targets", value)

    @property
    @pulumi.getter(name="importRouteTargets")
    def import_route_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Route Targets to be applied for incoming routes into CE.
        """
        return pulumi.get(self, "import_route_targets")

    @import_route_targets.setter
    def import_route_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "import_route_targets", value)


@pulumi.input_type
class RoutePolicyPropertiesActionArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 set: Optional[pulumi.Input['RoutePolicyPropertiesSetArgs']] = None):
        """
        Route policy action properties.
        :param pulumi.Input[str] action: action. Example: accept | deny.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if set is not None:
            pulumi.set(__self__, "set", set)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        action. Example: accept | deny.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def set(self) -> Optional[pulumi.Input['RoutePolicyPropertiesSetArgs']]:
        return pulumi.get(self, "set")

    @set.setter
    def set(self, value: Optional[pulumi.Input['RoutePolicyPropertiesSetArgs']]):
        pulumi.set(self, "set", value)


@pulumi.input_type
class RoutePolicyPropertiesConditionsArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['RoutePolicyPropertiesActionArgs']] = None,
                 annotation: Optional[pulumi.Input[str]] = None,
                 match: Optional[pulumi.Input['RoutePolicyPropertiesMatchArgs']] = None,
                 sequence_number: Optional[pulumi.Input[int]] = None):
        """
        Route Policy condition model.
        :param pulumi.Input['RoutePolicyPropertiesActionArgs'] action: Route policy action properties.
        :param pulumi.Input[str] annotation: Switch configuration description.
        :param pulumi.Input['RoutePolicyPropertiesMatchArgs'] match: Route policy match properties.
        :param pulumi.Input[int] sequence_number: sequenceNumber of the route policy.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if sequence_number is not None:
            pulumi.set(__self__, "sequence_number", sequence_number)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['RoutePolicyPropertiesActionArgs']]:
        """
        Route policy action properties.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['RoutePolicyPropertiesActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def annotation(self) -> Optional[pulumi.Input[str]]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input['RoutePolicyPropertiesMatchArgs']]:
        """
        Route policy match properties.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input['RoutePolicyPropertiesMatchArgs']]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter(name="sequenceNumber")
    def sequence_number(self) -> Optional[pulumi.Input[int]]:
        """
        sequenceNumber of the route policy.
        """
        return pulumi.get(self, "sequence_number")

    @sequence_number.setter
    def sequence_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sequence_number", value)


@pulumi.input_type
class RoutePolicyPropertiesMatchArgs:
    def __init__(__self__, *,
                 access_control_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_community_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_extended_community_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_prefix_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Route policy match properties.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] access_control_list_ids: accessControlListIds. Arm Resource Ids of AccessControlLists.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_community_list_ids: ipCommunityListIds. Arm Resource Ids of IpCommunityLists.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_extended_community_list_ids: ipExtendedCommunityListIds. Arm Resource Ids of IpCommunityLists.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_prefix_list_ids: ipPrefixListIds. Arm Resource Ids of IpPrefixLists.
        """
        if access_control_list_ids is not None:
            pulumi.set(__self__, "access_control_list_ids", access_control_list_ids)
        if ip_community_list_ids is not None:
            pulumi.set(__self__, "ip_community_list_ids", ip_community_list_ids)
        if ip_extended_community_list_ids is not None:
            pulumi.set(__self__, "ip_extended_community_list_ids", ip_extended_community_list_ids)
        if ip_prefix_list_ids is not None:
            pulumi.set(__self__, "ip_prefix_list_ids", ip_prefix_list_ids)

    @property
    @pulumi.getter(name="accessControlListIds")
    def access_control_list_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        accessControlListIds. Arm Resource Ids of AccessControlLists.
        """
        return pulumi.get(self, "access_control_list_ids")

    @access_control_list_ids.setter
    def access_control_list_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "access_control_list_ids", value)

    @property
    @pulumi.getter(name="ipCommunityListIds")
    def ip_community_list_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        ipCommunityListIds. Arm Resource Ids of IpCommunityLists.
        """
        return pulumi.get(self, "ip_community_list_ids")

    @ip_community_list_ids.setter
    def ip_community_list_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_community_list_ids", value)

    @property
    @pulumi.getter(name="ipExtendedCommunityListIds")
    def ip_extended_community_list_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        ipExtendedCommunityListIds. Arm Resource Ids of IpCommunityLists.
        """
        return pulumi.get(self, "ip_extended_community_list_ids")

    @ip_extended_community_list_ids.setter
    def ip_extended_community_list_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_extended_community_list_ids", value)

    @property
    @pulumi.getter(name="ipPrefixListIds")
    def ip_prefix_list_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        ipPrefixListIds. Arm Resource Ids of IpPrefixLists.
        """
        return pulumi.get(self, "ip_prefix_list_ids")

    @ip_prefix_list_ids.setter
    def ip_prefix_list_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_prefix_list_ids", value)


@pulumi.input_type
class RoutePolicyPropertiesSetSetArgs:
    def __init__(__self__, *,
                 ip_community_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_extended_community_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Route policy set manipulations.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_community_list_ids: ipCommunityListIds. Arm Resource Ids of IpCommunityLists.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_extended_community_list_ids: ipExtendedCommunityListIds. Arm Resource Ids of IpCommunityLists.
        """
        if ip_community_list_ids is not None:
            pulumi.set(__self__, "ip_community_list_ids", ip_community_list_ids)
        if ip_extended_community_list_ids is not None:
            pulumi.set(__self__, "ip_extended_community_list_ids", ip_extended_community_list_ids)

    @property
    @pulumi.getter(name="ipCommunityListIds")
    def ip_community_list_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        ipCommunityListIds. Arm Resource Ids of IpCommunityLists.
        """
        return pulumi.get(self, "ip_community_list_ids")

    @ip_community_list_ids.setter
    def ip_community_list_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_community_list_ids", value)

    @property
    @pulumi.getter(name="ipExtendedCommunityListIds")
    def ip_extended_community_list_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        ipExtendedCommunityListIds. Arm Resource Ids of IpCommunityLists.
        """
        return pulumi.get(self, "ip_extended_community_list_ids")

    @ip_extended_community_list_ids.setter
    def ip_extended_community_list_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_extended_community_list_ids", value)


@pulumi.input_type
class RoutePolicyPropertiesSetArgs:
    def __init__(__self__, *,
                 set: Optional[pulumi.Input['RoutePolicyPropertiesSetSetArgs']] = None):
        """
        :param pulumi.Input['RoutePolicyPropertiesSetSetArgs'] set: Route policy set manipulations.
        """
        if set is not None:
            pulumi.set(__self__, "set", set)

    @property
    @pulumi.getter
    def set(self) -> Optional[pulumi.Input['RoutePolicyPropertiesSetSetArgs']]:
        """
        Route policy set manipulations.
        """
        return pulumi.get(self, "set")

    @set.setter
    def set(self, value: Optional[pulumi.Input['RoutePolicyPropertiesSetSetArgs']]):
        pulumi.set(self, "set", value)


