# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccessControlListPropertiesResponseConditions',
    'BfdConfigurationResponse',
    'ExpressRouteConnectionInformationResponse',
    'ExternalNetworkPropertiesResponseOptionAProperties',
    'FabricOptionBPropertiesResponse',
    'InternalNetworkPatchablePropertiesResponseBgpConfiguration',
    'InternalNetworkPatchablePropertiesResponseConnectedIPv4Subnets',
    'InternalNetworkPatchablePropertiesResponseConnectedIPv6Subnets',
    'InternalNetworkPatchablePropertiesResponseIpv4NeighborAddress',
    'InternalNetworkPatchablePropertiesResponseIpv4Routes',
    'InternalNetworkPatchablePropertiesResponseIpv6NeighborAddress',
    'InternalNetworkPatchablePropertiesResponseIpv6Routes',
    'InternalNetworkPatchablePropertiesResponseStaticRouteConfiguration',
    'IpCommunityListPropertiesResponseCommunityMembers',
    'IpCommunityListPropertiesResponseEvpnEsImportRouteTargets',
    'L3IsolationDomainPatchPropertiesResponseAggregateRouteConfiguration',
    'L3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicy',
    'L3IsolationDomainPatchPropertiesResponseIpv4Routes',
    'L3IsolationDomainPatchPropertiesResponseIpv6Routes',
    'Layer3ConfigurationResponse',
    'NetworkFabricControllerPropertiesResponseInfrastructureServices',
    'NetworkFabricControllerPropertiesResponseManagedResourceGroupConfiguration',
    'NetworkFabricControllerPropertiesResponseWorkloadServices',
    'NetworkFabricPropertiesResponseInfrastructureVpnConfiguration',
    'NetworkFabricPropertiesResponseManagementNetworkConfiguration',
    'NetworkFabricPropertiesResponseTerminalServerConfiguration',
    'NetworkFabricPropertiesResponseWorkloadVpnConfiguration',
    'NetworkToNetworkInterconnectPropertiesResponseLayer2Configuration',
    'OptionAPropertiesResponse',
    'OptionAPropertiesResponseBfdConfiguration',
    'OptionBPropertiesResponse',
    'RoutePolicyPropertiesResponseAction',
    'RoutePolicyPropertiesResponseConditions',
    'RoutePolicyPropertiesResponseMatch',
    'RoutePolicyPropertiesResponseSet',
    'RoutePolicyPropertiesResponseSetSet',
    'SystemDataResponse',
]

@pulumi.output_type
class AccessControlListPropertiesResponseConditions(dict):
    """
    Access Control List condition model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationAddress":
            suggest = "destination_address"
        elif key == "destinationPort":
            suggest = "destination_port"
        elif key == "sequenceNumber":
            suggest = "sequence_number"
        elif key == "sourceAddress":
            suggest = "source_address"
        elif key == "sourcePort":
            suggest = "source_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessControlListPropertiesResponseConditions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessControlListPropertiesResponseConditions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessControlListPropertiesResponseConditions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 destination_address: str,
                 destination_port: str,
                 protocol: int,
                 sequence_number: int,
                 source_address: str,
                 source_port: str,
                 annotation: Optional[str] = None):
        """
        Access Control List condition model.
        :param str action: action. Example: allow | deny.
        :param str destination_address: destinationAddress. Example: any | 1.1.1.0/24 | 1.1.10.10
        :param str destination_port: destinationPort. Example: any | 1253
        :param int protocol: TCP/IP protocol as defined in the list of IP protocol numbers. Example: 255 (any) | 0 | 1.
        :param int sequence_number: sequenceNumber of the Access Control List.
        :param str source_address: sourceAddress. Example: any | 1.1.1.0/24 | 1.1.10.10
        :param str source_port: sourcePort. Example: any | 1253
        :param str annotation: Switch configuration description.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "destination_address", destination_address)
        pulumi.set(__self__, "destination_port", destination_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "sequence_number", sequence_number)
        pulumi.set(__self__, "source_address", source_address)
        pulumi.set(__self__, "source_port", source_port)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        action. Example: allow | deny.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="destinationAddress")
    def destination_address(self) -> str:
        """
        destinationAddress. Example: any | 1.1.1.0/24 | 1.1.10.10
        """
        return pulumi.get(self, "destination_address")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> str:
        """
        destinationPort. Example: any | 1253
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter
    def protocol(self) -> int:
        """
        TCP/IP protocol as defined in the list of IP protocol numbers. Example: 255 (any) | 0 | 1.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sequenceNumber")
    def sequence_number(self) -> int:
        """
        sequenceNumber of the Access Control List.
        """
        return pulumi.get(self, "sequence_number")

    @property
    @pulumi.getter(name="sourceAddress")
    def source_address(self) -> str:
        """
        sourceAddress. Example: any | 1.1.1.0/24 | 1.1.10.10
        """
        return pulumi.get(self, "source_address")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> str:
        """
        sourcePort. Example: any | 1253
        """
        return pulumi.get(self, "source_port")

    @property
    @pulumi.getter
    def annotation(self) -> Optional[str]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")


@pulumi.output_type
class BfdConfigurationResponse(dict):
    """
    BFD configuration properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administrativeState":
            suggest = "administrative_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BfdConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BfdConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BfdConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 administrative_state: str,
                 interval: int,
                 multiplier: int):
        """
        BFD configuration properties
        :param str administrative_state: Administrative state of the BfdConfiguration. Example: Enabled | Disabled.
        :param int interval: interval in milliseconds. Example: 300.
        :param int multiplier: Multiplier for the Bfd Configuration. Example: 3.
        """
        pulumi.set(__self__, "administrative_state", administrative_state)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "multiplier", multiplier)

    @property
    @pulumi.getter(name="administrativeState")
    def administrative_state(self) -> str:
        """
        Administrative state of the BfdConfiguration. Example: Enabled | Disabled.
        """
        return pulumi.get(self, "administrative_state")

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        interval in milliseconds. Example: 300.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def multiplier(self) -> int:
        """
        Multiplier for the Bfd Configuration. Example: 3.
        """
        return pulumi.get(self, "multiplier")


@pulumi.output_type
class ExpressRouteConnectionInformationResponse(dict):
    """
    The ExpressRoute circuit ID and the Auth Key are required for you to successfully deploy NFC service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expressRouteAuthorizationKey":
            suggest = "express_route_authorization_key"
        elif key == "expressRouteCircuitId":
            suggest = "express_route_circuit_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteConnectionInformationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteConnectionInformationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteConnectionInformationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 express_route_authorization_key: str,
                 express_route_circuit_id: str):
        """
        The ExpressRoute circuit ID and the Auth Key are required for you to successfully deploy NFC service.
        :param str express_route_authorization_key: Authorization key for the circuit, must be of type Microsoft.Network/expressRouteCircuits/authorizations. The Auth Key is a mandatory attribute.
        :param str express_route_circuit_id: The express route circuit Azure resource ID, must be of type Microsoft.Network/expressRouteCircuits/circuitName. The ExpressRoute Circuit is a mandatory attribute.
        """
        pulumi.set(__self__, "express_route_authorization_key", express_route_authorization_key)
        pulumi.set(__self__, "express_route_circuit_id", express_route_circuit_id)

    @property
    @pulumi.getter(name="expressRouteAuthorizationKey")
    def express_route_authorization_key(self) -> str:
        """
        Authorization key for the circuit, must be of type Microsoft.Network/expressRouteCircuits/authorizations. The Auth Key is a mandatory attribute.
        """
        return pulumi.get(self, "express_route_authorization_key")

    @property
    @pulumi.getter(name="expressRouteCircuitId")
    def express_route_circuit_id(self) -> str:
        """
        The express route circuit Azure resource ID, must be of type Microsoft.Network/expressRouteCircuits/circuitName. The ExpressRoute Circuit is a mandatory attribute.
        """
        return pulumi.get(self, "express_route_circuit_id")


@pulumi.output_type
class ExternalNetworkPropertiesResponseOptionAProperties(dict):
    """
    option A properties object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fabricASN":
            suggest = "fabric_asn"
        elif key == "peerASN":
            suggest = "peer_asn"
        elif key == "vlanId":
            suggest = "vlan_id"
        elif key == "bfdConfiguration":
            suggest = "bfd_configuration"
        elif key == "primaryIpv4Prefix":
            suggest = "primary_ipv4_prefix"
        elif key == "primaryIpv6Prefix":
            suggest = "primary_ipv6_prefix"
        elif key == "secondaryIpv4Prefix":
            suggest = "secondary_ipv4_prefix"
        elif key == "secondaryIpv6Prefix":
            suggest = "secondary_ipv6_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExternalNetworkPropertiesResponseOptionAProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExternalNetworkPropertiesResponseOptionAProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExternalNetworkPropertiesResponseOptionAProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fabric_asn: int,
                 peer_asn: int,
                 vlan_id: int,
                 bfd_configuration: Optional['outputs.BfdConfigurationResponse'] = None,
                 mtu: Optional[int] = None,
                 primary_ipv4_prefix: Optional[str] = None,
                 primary_ipv6_prefix: Optional[str] = None,
                 secondary_ipv4_prefix: Optional[str] = None,
                 secondary_ipv6_prefix: Optional[str] = None):
        """
        option A properties object
        :param int fabric_asn: Fabric ASN number. Example 65001 
        :param int peer_asn: Peer ASN number.Example : 28
        :param int vlan_id: Vlan identifier. Example : 501
        :param 'BfdConfigurationResponse' bfd_configuration: BFD configuration properties
        :param int mtu: MTU to use for option A peering.
        :param str primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.23.1.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param str primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a1/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param str secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.23.1.2/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param str secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a1/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        pulumi.set(__self__, "fabric_asn", fabric_asn)
        pulumi.set(__self__, "peer_asn", peer_asn)
        pulumi.set(__self__, "vlan_id", vlan_id)
        if bfd_configuration is not None:
            pulumi.set(__self__, "bfd_configuration", bfd_configuration)
        if mtu is None:
            mtu = 1500
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if primary_ipv4_prefix is not None:
            pulumi.set(__self__, "primary_ipv4_prefix", primary_ipv4_prefix)
        if primary_ipv6_prefix is not None:
            pulumi.set(__self__, "primary_ipv6_prefix", primary_ipv6_prefix)
        if secondary_ipv4_prefix is not None:
            pulumi.set(__self__, "secondary_ipv4_prefix", secondary_ipv4_prefix)
        if secondary_ipv6_prefix is not None:
            pulumi.set(__self__, "secondary_ipv6_prefix", secondary_ipv6_prefix)

    @property
    @pulumi.getter(name="fabricASN")
    def fabric_asn(self) -> int:
        """
        Fabric ASN number. Example 65001 
        """
        return pulumi.get(self, "fabric_asn")

    @property
    @pulumi.getter(name="peerASN")
    def peer_asn(self) -> int:
        """
        Peer ASN number.Example : 28
        """
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> int:
        """
        Vlan identifier. Example : 501
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="bfdConfiguration")
    def bfd_configuration(self) -> Optional['outputs.BfdConfigurationResponse']:
        """
        BFD configuration properties
        """
        return pulumi.get(self, "bfd_configuration")

    @property
    @pulumi.getter
    def mtu(self) -> Optional[int]:
        """
        MTU to use for option A peering.
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter(name="primaryIpv4Prefix")
    def primary_ipv4_prefix(self) -> Optional[str]:
        """
        IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.23.1.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "primary_ipv4_prefix")

    @property
    @pulumi.getter(name="primaryIpv6Prefix")
    def primary_ipv6_prefix(self) -> Optional[str]:
        """
        IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a1/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "primary_ipv6_prefix")

    @property
    @pulumi.getter(name="secondaryIpv4Prefix")
    def secondary_ipv4_prefix(self) -> Optional[str]:
        """
        Secondary IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.23.1.2/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "secondary_ipv4_prefix")

    @property
    @pulumi.getter(name="secondaryIpv6Prefix")
    def secondary_ipv6_prefix(self) -> Optional[str]:
        """
        Secondary IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a1/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "secondary_ipv6_prefix")


@pulumi.output_type
class FabricOptionBPropertiesResponse(dict):
    """
    Option B configuration to be used for management vpn.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exportRouteTargets":
            suggest = "export_route_targets"
        elif key == "importRouteTargets":
            suggest = "import_route_targets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FabricOptionBPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FabricOptionBPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FabricOptionBPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 export_route_targets: Sequence[str],
                 import_route_targets: Sequence[str]):
        """
        Option B configuration to be used for management vpn.
        :param Sequence[str] export_route_targets: Route Targets to be applied for outgoing routes from CE.
        :param Sequence[str] import_route_targets: Route Targets to be applied for incoming routes into CE.
        """
        pulumi.set(__self__, "export_route_targets", export_route_targets)
        pulumi.set(__self__, "import_route_targets", import_route_targets)

    @property
    @pulumi.getter(name="exportRouteTargets")
    def export_route_targets(self) -> Sequence[str]:
        """
        Route Targets to be applied for outgoing routes from CE.
        """
        return pulumi.get(self, "export_route_targets")

    @property
    @pulumi.getter(name="importRouteTargets")
    def import_route_targets(self) -> Sequence[str]:
        """
        Route Targets to be applied for incoming routes into CE.
        """
        return pulumi.get(self, "import_route_targets")


@pulumi.output_type
class InternalNetworkPatchablePropertiesResponseBgpConfiguration(dict):
    """
    BGP configuration properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fabricASN":
            suggest = "fabric_asn"
        elif key == "peerASN":
            suggest = "peer_asn"
        elif key == "allowAS":
            suggest = "allow_as"
        elif key == "allowASOverride":
            suggest = "allow_as_override"
        elif key == "bfdConfiguration":
            suggest = "bfd_configuration"
        elif key == "defaultRouteOriginate":
            suggest = "default_route_originate"
        elif key == "ipv4ListenRangePrefixes":
            suggest = "ipv4_listen_range_prefixes"
        elif key == "ipv4NeighborAddress":
            suggest = "ipv4_neighbor_address"
        elif key == "ipv6ListenRangePrefixes":
            suggest = "ipv6_listen_range_prefixes"
        elif key == "ipv6NeighborAddress":
            suggest = "ipv6_neighbor_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InternalNetworkPatchablePropertiesResponseBgpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InternalNetworkPatchablePropertiesResponseBgpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InternalNetworkPatchablePropertiesResponseBgpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fabric_asn: int,
                 peer_asn: int,
                 allow_as: Optional[int] = None,
                 allow_as_override: Optional[str] = None,
                 annotation: Optional[str] = None,
                 bfd_configuration: Optional['outputs.BfdConfigurationResponse'] = None,
                 default_route_originate: Optional[str] = None,
                 ipv4_listen_range_prefixes: Optional[Sequence[str]] = None,
                 ipv4_neighbor_address: Optional[Sequence['outputs.InternalNetworkPatchablePropertiesResponseIpv4NeighborAddress']] = None,
                 ipv6_listen_range_prefixes: Optional[Sequence[str]] = None,
                 ipv6_neighbor_address: Optional[Sequence['outputs.InternalNetworkPatchablePropertiesResponseIpv6NeighborAddress']] = None):
        """
        BGP configuration properties
        :param int fabric_asn: ASN of Network Fabric. Example: 65048.
        :param int peer_asn: Peer ASN. Example: 65047.
        :param int allow_as: Allows for routes to be received and processed even if the router detects its own ASN in the AS-Path. 0 is disable, Possible values are 1-10, default is 2.
        :param str allow_as_override: Enable Or Disable state.
        :param str annotation: Switch configuration description.
        :param 'BfdConfigurationResponse' bfd_configuration: BFD configuration properties
        :param str default_route_originate: Originate a defaultRoute. Ex: "True" | "False".
        :param Sequence[str] ipv4_listen_range_prefixes: BGP Ipv4 ListenRange.
        :param Sequence['InternalNetworkPatchablePropertiesResponseIpv4NeighborAddress'] ipv4_neighbor_address: List with stringified ipv4NeighborAddresses.
        :param Sequence[str] ipv6_listen_range_prefixes: BGP Ipv6 ListenRange.
        :param Sequence['InternalNetworkPatchablePropertiesResponseIpv6NeighborAddress'] ipv6_neighbor_address: List with stringified ipv6NeighborAddress.
        """
        pulumi.set(__self__, "fabric_asn", fabric_asn)
        pulumi.set(__self__, "peer_asn", peer_asn)
        if allow_as is None:
            allow_as = 2
        if allow_as is not None:
            pulumi.set(__self__, "allow_as", allow_as)
        if allow_as_override is not None:
            pulumi.set(__self__, "allow_as_override", allow_as_override)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if bfd_configuration is not None:
            pulumi.set(__self__, "bfd_configuration", bfd_configuration)
        if default_route_originate is not None:
            pulumi.set(__self__, "default_route_originate", default_route_originate)
        if ipv4_listen_range_prefixes is not None:
            pulumi.set(__self__, "ipv4_listen_range_prefixes", ipv4_listen_range_prefixes)
        if ipv4_neighbor_address is not None:
            pulumi.set(__self__, "ipv4_neighbor_address", ipv4_neighbor_address)
        if ipv6_listen_range_prefixes is not None:
            pulumi.set(__self__, "ipv6_listen_range_prefixes", ipv6_listen_range_prefixes)
        if ipv6_neighbor_address is not None:
            pulumi.set(__self__, "ipv6_neighbor_address", ipv6_neighbor_address)

    @property
    @pulumi.getter(name="fabricASN")
    def fabric_asn(self) -> int:
        """
        ASN of Network Fabric. Example: 65048.
        """
        return pulumi.get(self, "fabric_asn")

    @property
    @pulumi.getter(name="peerASN")
    def peer_asn(self) -> int:
        """
        Peer ASN. Example: 65047.
        """
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="allowAS")
    def allow_as(self) -> Optional[int]:
        """
        Allows for routes to be received and processed even if the router detects its own ASN in the AS-Path. 0 is disable, Possible values are 1-10, default is 2.
        """
        return pulumi.get(self, "allow_as")

    @property
    @pulumi.getter(name="allowASOverride")
    def allow_as_override(self) -> Optional[str]:
        """
        Enable Or Disable state.
        """
        return pulumi.get(self, "allow_as_override")

    @property
    @pulumi.getter
    def annotation(self) -> Optional[str]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter(name="bfdConfiguration")
    def bfd_configuration(self) -> Optional['outputs.BfdConfigurationResponse']:
        """
        BFD configuration properties
        """
        return pulumi.get(self, "bfd_configuration")

    @property
    @pulumi.getter(name="defaultRouteOriginate")
    def default_route_originate(self) -> Optional[str]:
        """
        Originate a defaultRoute. Ex: "True" | "False".
        """
        return pulumi.get(self, "default_route_originate")

    @property
    @pulumi.getter(name="ipv4ListenRangePrefixes")
    def ipv4_listen_range_prefixes(self) -> Optional[Sequence[str]]:
        """
        BGP Ipv4 ListenRange.
        """
        return pulumi.get(self, "ipv4_listen_range_prefixes")

    @property
    @pulumi.getter(name="ipv4NeighborAddress")
    def ipv4_neighbor_address(self) -> Optional[Sequence['outputs.InternalNetworkPatchablePropertiesResponseIpv4NeighborAddress']]:
        """
        List with stringified ipv4NeighborAddresses.
        """
        return pulumi.get(self, "ipv4_neighbor_address")

    @property
    @pulumi.getter(name="ipv6ListenRangePrefixes")
    def ipv6_listen_range_prefixes(self) -> Optional[Sequence[str]]:
        """
        BGP Ipv6 ListenRange.
        """
        return pulumi.get(self, "ipv6_listen_range_prefixes")

    @property
    @pulumi.getter(name="ipv6NeighborAddress")
    def ipv6_neighbor_address(self) -> Optional[Sequence['outputs.InternalNetworkPatchablePropertiesResponseIpv6NeighborAddress']]:
        """
        List with stringified ipv6NeighborAddress.
        """
        return pulumi.get(self, "ipv6_neighbor_address")


@pulumi.output_type
class InternalNetworkPatchablePropertiesResponseConnectedIPv4Subnets(dict):
    """
    connectedIPv4Subnet model.
    """
    def __init__(__self__, *,
                 annotation: Optional[str] = None,
                 prefix: Optional[str] = None):
        """
        connectedIPv4Subnet model.
        :param str annotation: Switch configuration description.
        :param str prefix: Ipv4 Prefix of the connectedIPv4Subnet.
        """
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def annotation(self) -> Optional[str]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Ipv4 Prefix of the connectedIPv4Subnet.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class InternalNetworkPatchablePropertiesResponseConnectedIPv6Subnets(dict):
    """
    connectedIPv6Subnet model.
    """
    def __init__(__self__, *,
                 annotation: Optional[str] = None,
                 prefix: Optional[str] = None):
        """
        connectedIPv6Subnet model.
        :param str annotation: Switch configuration description.
        :param str prefix: Ipv6 Prefix of the connectedIPv6Subnet.
        """
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def annotation(self) -> Optional[str]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Ipv6 Prefix of the connectedIPv6Subnet.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class InternalNetworkPatchablePropertiesResponseIpv4NeighborAddress(dict):
    """
    ipv4NeighborAddress model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationalState":
            suggest = "operational_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InternalNetworkPatchablePropertiesResponseIpv4NeighborAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InternalNetworkPatchablePropertiesResponseIpv4NeighborAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InternalNetworkPatchablePropertiesResponseIpv4NeighborAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operational_state: str,
                 address: Optional[str] = None):
        """
        ipv4NeighborAddress model.
        :param str operational_state: operationalState of the IPv4NeighborAddress.
        :param str address: IP Address of the IPv4NeighborAddress.
        """
        pulumi.set(__self__, "operational_state", operational_state)
        if address is not None:
            pulumi.set(__self__, "address", address)

    @property
    @pulumi.getter(name="operationalState")
    def operational_state(self) -> str:
        """
        operationalState of the IPv4NeighborAddress.
        """
        return pulumi.get(self, "operational_state")

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        IP Address of the IPv4NeighborAddress.
        """
        return pulumi.get(self, "address")


@pulumi.output_type
class InternalNetworkPatchablePropertiesResponseIpv4Routes(dict):
    """
    staticIpv4Route model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nextHop":
            suggest = "next_hop"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InternalNetworkPatchablePropertiesResponseIpv4Routes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InternalNetworkPatchablePropertiesResponseIpv4Routes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InternalNetworkPatchablePropertiesResponseIpv4Routes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 next_hop: Sequence[str],
                 prefix: str):
        """
        staticIpv4Route model.
        :param Sequence[str] next_hop: List of next hop IPv4 addresses.
        :param str prefix: IPv4 prefix of the staticIpv4Route.
        """
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> Sequence[str]:
        """
        List of next hop IPv4 addresses.
        """
        return pulumi.get(self, "next_hop")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        IPv4 prefix of the staticIpv4Route.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class InternalNetworkPatchablePropertiesResponseIpv6NeighborAddress(dict):
    """
    ipv6NeighborAddress model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationalState":
            suggest = "operational_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InternalNetworkPatchablePropertiesResponseIpv6NeighborAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InternalNetworkPatchablePropertiesResponseIpv6NeighborAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InternalNetworkPatchablePropertiesResponseIpv6NeighborAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operational_state: str,
                 address: Optional[str] = None):
        """
        ipv6NeighborAddress model.
        :param str operational_state: operationalState of the ipv6NeighborAddress.
        :param str address: ip address of the ipv6NeighborAddress.
        """
        pulumi.set(__self__, "operational_state", operational_state)
        if address is not None:
            pulumi.set(__self__, "address", address)

    @property
    @pulumi.getter(name="operationalState")
    def operational_state(self) -> str:
        """
        operationalState of the ipv6NeighborAddress.
        """
        return pulumi.get(self, "operational_state")

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        ip address of the ipv6NeighborAddress.
        """
        return pulumi.get(self, "address")


@pulumi.output_type
class InternalNetworkPatchablePropertiesResponseIpv6Routes(dict):
    """
    staticIPv6Route model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nextHop":
            suggest = "next_hop"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InternalNetworkPatchablePropertiesResponseIpv6Routes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InternalNetworkPatchablePropertiesResponseIpv6Routes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InternalNetworkPatchablePropertiesResponseIpv6Routes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 next_hop: Sequence[str],
                 prefix: str):
        """
        staticIPv6Route model.
        :param Sequence[str] next_hop: List of next hop IPv6 addresses.
        :param str prefix: IPv6 prefix of the staticIPv6Route.
        """
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> Sequence[str]:
        """
        List of next hop IPv6 addresses.
        """
        return pulumi.get(self, "next_hop")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        IPv6 prefix of the staticIPv6Route.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class InternalNetworkPatchablePropertiesResponseStaticRouteConfiguration(dict):
    """
    staticRouteConfiguration model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bfdConfiguration":
            suggest = "bfd_configuration"
        elif key == "ipv4Routes":
            suggest = "ipv4_routes"
        elif key == "ipv6Routes":
            suggest = "ipv6_routes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InternalNetworkPatchablePropertiesResponseStaticRouteConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InternalNetworkPatchablePropertiesResponseStaticRouteConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InternalNetworkPatchablePropertiesResponseStaticRouteConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bfd_configuration: Optional['outputs.BfdConfigurationResponse'] = None,
                 ipv4_routes: Optional[Sequence['outputs.InternalNetworkPatchablePropertiesResponseIpv4Routes']] = None,
                 ipv6_routes: Optional[Sequence['outputs.InternalNetworkPatchablePropertiesResponseIpv6Routes']] = None):
        """
        staticRouteConfiguration model.
        :param 'BfdConfigurationResponse' bfd_configuration: BFD configuration properties
        :param Sequence['InternalNetworkPatchablePropertiesResponseIpv4Routes'] ipv4_routes: List with object IPv4Routes.
        :param Sequence['InternalNetworkPatchablePropertiesResponseIpv6Routes'] ipv6_routes: List with object IPv6Routes.
        """
        if bfd_configuration is not None:
            pulumi.set(__self__, "bfd_configuration", bfd_configuration)
        if ipv4_routes is not None:
            pulumi.set(__self__, "ipv4_routes", ipv4_routes)
        if ipv6_routes is not None:
            pulumi.set(__self__, "ipv6_routes", ipv6_routes)

    @property
    @pulumi.getter(name="bfdConfiguration")
    def bfd_configuration(self) -> Optional['outputs.BfdConfigurationResponse']:
        """
        BFD configuration properties
        """
        return pulumi.get(self, "bfd_configuration")

    @property
    @pulumi.getter(name="ipv4Routes")
    def ipv4_routes(self) -> Optional[Sequence['outputs.InternalNetworkPatchablePropertiesResponseIpv4Routes']]:
        """
        List with object IPv4Routes.
        """
        return pulumi.get(self, "ipv4_routes")

    @property
    @pulumi.getter(name="ipv6Routes")
    def ipv6_routes(self) -> Optional[Sequence['outputs.InternalNetworkPatchablePropertiesResponseIpv6Routes']]:
        """
        List with object IPv6Routes.
        """
        return pulumi.get(self, "ipv6_routes")


@pulumi.output_type
class IpCommunityListPropertiesResponseCommunityMembers(dict):
    """
    Ip Community List communityMembers model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "communityMember":
            suggest = "community_member"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpCommunityListPropertiesResponseCommunityMembers. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpCommunityListPropertiesResponseCommunityMembers.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpCommunityListPropertiesResponseCommunityMembers.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotation: str,
                 community_member: str):
        """
        Ip Community List communityMembers model.
        :param str annotation: Switch configuration description.
        :param str community_member: communityMember of the Ip Community List. Example: 100:200
        """
        pulumi.set(__self__, "annotation", annotation)
        pulumi.set(__self__, "community_member", community_member)

    @property
    @pulumi.getter
    def annotation(self) -> str:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter(name="communityMember")
    def community_member(self) -> str:
        """
        communityMember of the Ip Community List. Example: 100:200
        """
        return pulumi.get(self, "community_member")


@pulumi.output_type
class IpCommunityListPropertiesResponseEvpnEsImportRouteTargets(dict):
    """
    Ip Community List evpnEsImportRouteTarget model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evpnEsImportRouteTarget":
            suggest = "evpn_es_import_route_target"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpCommunityListPropertiesResponseEvpnEsImportRouteTargets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpCommunityListPropertiesResponseEvpnEsImportRouteTargets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpCommunityListPropertiesResponseEvpnEsImportRouteTargets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evpn_es_import_route_target: str,
                 annotation: Optional[str] = None):
        """
        Ip Community List evpnEsImportRouteTarget model.
        :param str evpn_es_import_route_target: evpnEsImportRouteTarget of the Ip Community List. Example: 100:400
        :param str annotation: Switch configuration description.
        """
        pulumi.set(__self__, "evpn_es_import_route_target", evpn_es_import_route_target)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)

    @property
    @pulumi.getter(name="evpnEsImportRouteTarget")
    def evpn_es_import_route_target(self) -> str:
        """
        evpnEsImportRouteTarget of the Ip Community List. Example: 100:400
        """
        return pulumi.get(self, "evpn_es_import_route_target")

    @property
    @pulumi.getter
    def annotation(self) -> Optional[str]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")


@pulumi.output_type
class L3IsolationDomainPatchPropertiesResponseAggregateRouteConfiguration(dict):
    """
    List of Ipv4 and Ipv6 route configurations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv4Routes":
            suggest = "ipv4_routes"
        elif key == "ipv6Routes":
            suggest = "ipv6_routes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in L3IsolationDomainPatchPropertiesResponseAggregateRouteConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        L3IsolationDomainPatchPropertiesResponseAggregateRouteConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        L3IsolationDomainPatchPropertiesResponseAggregateRouteConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv4_routes: Optional[Sequence['outputs.L3IsolationDomainPatchPropertiesResponseIpv4Routes']] = None,
                 ipv6_routes: Optional[Sequence['outputs.L3IsolationDomainPatchPropertiesResponseIpv6Routes']] = None):
        """
        List of Ipv4 and Ipv6 route configurations.
        :param Sequence['L3IsolationDomainPatchPropertiesResponseIpv4Routes'] ipv4_routes: List of Ipv4Route prefixes.
        :param Sequence['L3IsolationDomainPatchPropertiesResponseIpv6Routes'] ipv6_routes: List of Ipv6Routes prefixes.
        """
        if ipv4_routes is not None:
            pulumi.set(__self__, "ipv4_routes", ipv4_routes)
        if ipv6_routes is not None:
            pulumi.set(__self__, "ipv6_routes", ipv6_routes)

    @property
    @pulumi.getter(name="ipv4Routes")
    def ipv4_routes(self) -> Optional[Sequence['outputs.L3IsolationDomainPatchPropertiesResponseIpv4Routes']]:
        """
        List of Ipv4Route prefixes.
        """
        return pulumi.get(self, "ipv4_routes")

    @property
    @pulumi.getter(name="ipv6Routes")
    def ipv6_routes(self) -> Optional[Sequence['outputs.L3IsolationDomainPatchPropertiesResponseIpv6Routes']]:
        """
        List of Ipv6Routes prefixes.
        """
        return pulumi.get(self, "ipv6_routes")


@pulumi.output_type
class L3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicy(dict):
    """
    Connected Subnet RoutePolicy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administrativeState":
            suggest = "administrative_state"
        elif key == "exportRoutePolicyId":
            suggest = "export_route_policy_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in L3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        L3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        L3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 administrative_state: str,
                 export_route_policy_id: Optional[str] = None):
        """
        Connected Subnet RoutePolicy
        :param str administrative_state: Enabled/Disabled connected subnet route policy. Ex: Enabled | Disabled.
        :param str export_route_policy_id: exportRoutePolicyId value.
        """
        pulumi.set(__self__, "administrative_state", administrative_state)
        if export_route_policy_id is not None:
            pulumi.set(__self__, "export_route_policy_id", export_route_policy_id)

    @property
    @pulumi.getter(name="administrativeState")
    def administrative_state(self) -> str:
        """
        Enabled/Disabled connected subnet route policy. Ex: Enabled | Disabled.
        """
        return pulumi.get(self, "administrative_state")

    @property
    @pulumi.getter(name="exportRoutePolicyId")
    def export_route_policy_id(self) -> Optional[str]:
        """
        exportRoutePolicyId value.
        """
        return pulumi.get(self, "export_route_policy_id")


@pulumi.output_type
class L3IsolationDomainPatchPropertiesResponseIpv4Routes(dict):
    """
    aggregateIpv4Route model.
    """
    def __init__(__self__, *,
                 prefix: Optional[str] = None):
        """
        aggregateIpv4Route model.
        :param str prefix: IPv4 Prefix of the aggregate Ipv4Route.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        IPv4 Prefix of the aggregate Ipv4Route.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class L3IsolationDomainPatchPropertiesResponseIpv6Routes(dict):
    """
    aggregateIpv6Route model.
    """
    def __init__(__self__, *,
                 prefix: Optional[str] = None):
        """
        aggregateIpv6Route model.
        :param str prefix: IPv6 Prefix of the aggregate IPv6 Route.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        IPv6 Prefix of the aggregate IPv6 Route.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class Layer3ConfigurationResponse(dict):
    """
    layer3Configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fabricASN":
            suggest = "fabric_asn"
        elif key == "exportRoutePolicyId":
            suggest = "export_route_policy_id"
        elif key == "importRoutePolicyId":
            suggest = "import_route_policy_id"
        elif key == "peerASN":
            suggest = "peer_asn"
        elif key == "primaryIpv4Prefix":
            suggest = "primary_ipv4_prefix"
        elif key == "primaryIpv6Prefix":
            suggest = "primary_ipv6_prefix"
        elif key == "secondaryIpv4Prefix":
            suggest = "secondary_ipv4_prefix"
        elif key == "secondaryIpv6Prefix":
            suggest = "secondary_ipv6_prefix"
        elif key == "vlanId":
            suggest = "vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Layer3ConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Layer3ConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Layer3ConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fabric_asn: int,
                 export_route_policy_id: Optional[str] = None,
                 import_route_policy_id: Optional[str] = None,
                 peer_asn: Optional[int] = None,
                 primary_ipv4_prefix: Optional[str] = None,
                 primary_ipv6_prefix: Optional[str] = None,
                 secondary_ipv4_prefix: Optional[str] = None,
                 secondary_ipv6_prefix: Optional[str] = None,
                 vlan_id: Optional[int] = None):
        """
        layer3Configuration
        :param int fabric_asn: ASN of CE devices for CE/PE connectivity.
        :param str export_route_policy_id: exportRoutePolicyId
        :param str import_route_policy_id: importRoutePolicyId
        :param int peer_asn: ASN of PE devices for CE/PE connectivity.Example : 28
        :param str primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param str primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param str secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param str secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param int vlan_id: VLAN for CE/PE Layer 3 connectivity.Example : 501
        """
        pulumi.set(__self__, "fabric_asn", fabric_asn)
        if export_route_policy_id is not None:
            pulumi.set(__self__, "export_route_policy_id", export_route_policy_id)
        if import_route_policy_id is not None:
            pulumi.set(__self__, "import_route_policy_id", import_route_policy_id)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if primary_ipv4_prefix is None:
            primary_ipv4_prefix = '172.31.0.0/31'
        if primary_ipv4_prefix is not None:
            pulumi.set(__self__, "primary_ipv4_prefix", primary_ipv4_prefix)
        if primary_ipv6_prefix is None:
            primary_ipv6_prefix = '3FFE:FFFF:0:CD30::a0/126'
        if primary_ipv6_prefix is not None:
            pulumi.set(__self__, "primary_ipv6_prefix", primary_ipv6_prefix)
        if secondary_ipv4_prefix is None:
            secondary_ipv4_prefix = '172.31.0.20/31'
        if secondary_ipv4_prefix is not None:
            pulumi.set(__self__, "secondary_ipv4_prefix", secondary_ipv4_prefix)
        if secondary_ipv6_prefix is None:
            secondary_ipv6_prefix = '3FFE:FFFF:0:CD30::a4/126'
        if secondary_ipv6_prefix is not None:
            pulumi.set(__self__, "secondary_ipv6_prefix", secondary_ipv6_prefix)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter(name="fabricASN")
    def fabric_asn(self) -> int:
        """
        ASN of CE devices for CE/PE connectivity.
        """
        return pulumi.get(self, "fabric_asn")

    @property
    @pulumi.getter(name="exportRoutePolicyId")
    def export_route_policy_id(self) -> Optional[str]:
        """
        exportRoutePolicyId
        """
        return pulumi.get(self, "export_route_policy_id")

    @property
    @pulumi.getter(name="importRoutePolicyId")
    def import_route_policy_id(self) -> Optional[str]:
        """
        importRoutePolicyId
        """
        return pulumi.get(self, "import_route_policy_id")

    @property
    @pulumi.getter(name="peerASN")
    def peer_asn(self) -> Optional[int]:
        """
        ASN of PE devices for CE/PE connectivity.Example : 28
        """
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="primaryIpv4Prefix")
    def primary_ipv4_prefix(self) -> Optional[str]:
        """
        IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "primary_ipv4_prefix")

    @property
    @pulumi.getter(name="primaryIpv6Prefix")
    def primary_ipv6_prefix(self) -> Optional[str]:
        """
        IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "primary_ipv6_prefix")

    @property
    @pulumi.getter(name="secondaryIpv4Prefix")
    def secondary_ipv4_prefix(self) -> Optional[str]:
        """
        Secondary IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "secondary_ipv4_prefix")

    @property
    @pulumi.getter(name="secondaryIpv6Prefix")
    def secondary_ipv6_prefix(self) -> Optional[str]:
        """
        Secondary IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "secondary_ipv6_prefix")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[int]:
        """
        VLAN for CE/PE Layer 3 connectivity.Example : 501
        """
        return pulumi.get(self, "vlan_id")


@pulumi.output_type
class NetworkFabricControllerPropertiesResponseInfrastructureServices(dict):
    """
    InfrastructureServices IP ranges.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv4AddressSpaces":
            suggest = "ipv4_address_spaces"
        elif key == "ipv6AddressSpaces":
            suggest = "ipv6_address_spaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFabricControllerPropertiesResponseInfrastructureServices. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFabricControllerPropertiesResponseInfrastructureServices.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFabricControllerPropertiesResponseInfrastructureServices.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv4_address_spaces: Optional[Sequence[str]] = None,
                 ipv6_address_spaces: Optional[Sequence[str]] = None):
        """
        InfrastructureServices IP ranges.
        :param Sequence[str] ipv4_address_spaces: The IPv4 Address space is optional, if the value is not defined at the time of NFC creation, then the default value 10.0.0.0/19 is considered. The IPV4 address subnet is an optional attribute.
        :param Sequence[str] ipv6_address_spaces: The IPv6 is not supported right now.
        """
        if ipv4_address_spaces is not None:
            pulumi.set(__self__, "ipv4_address_spaces", ipv4_address_spaces)
        if ipv6_address_spaces is not None:
            pulumi.set(__self__, "ipv6_address_spaces", ipv6_address_spaces)

    @property
    @pulumi.getter(name="ipv4AddressSpaces")
    def ipv4_address_spaces(self) -> Optional[Sequence[str]]:
        """
        The IPv4 Address space is optional, if the value is not defined at the time of NFC creation, then the default value 10.0.0.0/19 is considered. The IPV4 address subnet is an optional attribute.
        """
        return pulumi.get(self, "ipv4_address_spaces")

    @property
    @pulumi.getter(name="ipv6AddressSpaces")
    def ipv6_address_spaces(self) -> Optional[Sequence[str]]:
        """
        The IPv6 is not supported right now.
        """
        return pulumi.get(self, "ipv6_address_spaces")


@pulumi.output_type
class NetworkFabricControllerPropertiesResponseManagedResourceGroupConfiguration(dict):
    """
    Managed Resource Group configuration properties.
    """
    def __init__(__self__, *,
                 location: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Managed Resource Group configuration properties.
        :param str location: Managed resource group location.
        :param str name: The NFC service will be hosted in a Managed resource group.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Managed resource group location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The NFC service will be hosted in a Managed resource group.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class NetworkFabricControllerPropertiesResponseWorkloadServices(dict):
    """
    WorkloadServices IP ranges.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv4AddressSpaces":
            suggest = "ipv4_address_spaces"
        elif key == "ipv6AddressSpaces":
            suggest = "ipv6_address_spaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFabricControllerPropertiesResponseWorkloadServices. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFabricControllerPropertiesResponseWorkloadServices.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFabricControllerPropertiesResponseWorkloadServices.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv4_address_spaces: Optional[Sequence[str]] = None,
                 ipv6_address_spaces: Optional[Sequence[str]] = None):
        """
        WorkloadServices IP ranges.
        :param Sequence[str] ipv4_address_spaces: The IPv4 Address space is optional, if the value is defined at the time of NFC creation, then the default value 10.0.0.0/19 is considered. The IPV4 address subnet is an optional attribute.
        :param Sequence[str] ipv6_address_spaces: The IPv6 is not supported right now.
        """
        if ipv4_address_spaces is not None:
            pulumi.set(__self__, "ipv4_address_spaces", ipv4_address_spaces)
        if ipv6_address_spaces is not None:
            pulumi.set(__self__, "ipv6_address_spaces", ipv6_address_spaces)

    @property
    @pulumi.getter(name="ipv4AddressSpaces")
    def ipv4_address_spaces(self) -> Optional[Sequence[str]]:
        """
        The IPv4 Address space is optional, if the value is defined at the time of NFC creation, then the default value 10.0.0.0/19 is considered. The IPV4 address subnet is an optional attribute.
        """
        return pulumi.get(self, "ipv4_address_spaces")

    @property
    @pulumi.getter(name="ipv6AddressSpaces")
    def ipv6_address_spaces(self) -> Optional[Sequence[str]]:
        """
        The IPv6 is not supported right now.
        """
        return pulumi.get(self, "ipv6_address_spaces")


@pulumi.output_type
class NetworkFabricPropertiesResponseInfrastructureVpnConfiguration(dict):
    """
    Configuration for infrastructure vpn.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administrativeState":
            suggest = "administrative_state"
        elif key == "networkToNetworkInterconnectId":
            suggest = "network_to_network_interconnect_id"
        elif key == "optionBProperties":
            suggest = "option_b_properties"
        elif key == "optionAProperties":
            suggest = "option_a_properties"
        elif key == "peeringOption":
            suggest = "peering_option"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFabricPropertiesResponseInfrastructureVpnConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFabricPropertiesResponseInfrastructureVpnConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFabricPropertiesResponseInfrastructureVpnConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 administrative_state: str,
                 network_to_network_interconnect_id: str,
                 option_b_properties: 'outputs.FabricOptionBPropertiesResponse',
                 option_a_properties: Optional['outputs.OptionAPropertiesResponse'] = None,
                 peering_option: Optional[str] = None):
        """
        Configuration for infrastructure vpn.
        :param str administrative_state: Indicates configuration state. Example: Enabled | Disabled.
        :param str network_to_network_interconnect_id: Gets the networkToNetworkInterconnectId of the resource.
        :param 'FabricOptionBPropertiesResponse' option_b_properties: option B properties
        :param 'OptionAPropertiesResponse' option_a_properties: option A properties
        :param str peering_option: Peering option list.
        """
        pulumi.set(__self__, "administrative_state", administrative_state)
        pulumi.set(__self__, "network_to_network_interconnect_id", network_to_network_interconnect_id)
        pulumi.set(__self__, "option_b_properties", option_b_properties)
        if option_a_properties is not None:
            pulumi.set(__self__, "option_a_properties", option_a_properties)
        if peering_option is not None:
            pulumi.set(__self__, "peering_option", peering_option)

    @property
    @pulumi.getter(name="administrativeState")
    def administrative_state(self) -> str:
        """
        Indicates configuration state. Example: Enabled | Disabled.
        """
        return pulumi.get(self, "administrative_state")

    @property
    @pulumi.getter(name="networkToNetworkInterconnectId")
    def network_to_network_interconnect_id(self) -> str:
        """
        Gets the networkToNetworkInterconnectId of the resource.
        """
        return pulumi.get(self, "network_to_network_interconnect_id")

    @property
    @pulumi.getter(name="optionBProperties")
    def option_b_properties(self) -> 'outputs.FabricOptionBPropertiesResponse':
        """
        option B properties
        """
        return pulumi.get(self, "option_b_properties")

    @property
    @pulumi.getter(name="optionAProperties")
    def option_a_properties(self) -> Optional['outputs.OptionAPropertiesResponse']:
        """
        option A properties
        """
        return pulumi.get(self, "option_a_properties")

    @property
    @pulumi.getter(name="peeringOption")
    def peering_option(self) -> Optional[str]:
        """
        Peering option list.
        """
        return pulumi.get(self, "peering_option")


@pulumi.output_type
class NetworkFabricPropertiesResponseManagementNetworkConfiguration(dict):
    """
    Configuration to be used to setup the management network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "infrastructureVpnConfiguration":
            suggest = "infrastructure_vpn_configuration"
        elif key == "workloadVpnConfiguration":
            suggest = "workload_vpn_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFabricPropertiesResponseManagementNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFabricPropertiesResponseManagementNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFabricPropertiesResponseManagementNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 infrastructure_vpn_configuration: 'outputs.NetworkFabricPropertiesResponseInfrastructureVpnConfiguration',
                 workload_vpn_configuration: 'outputs.NetworkFabricPropertiesResponseWorkloadVpnConfiguration'):
        """
        Configuration to be used to setup the management network.
        :param 'NetworkFabricPropertiesResponseInfrastructureVpnConfiguration' infrastructure_vpn_configuration: Configuration for infrastructure vpn.
        :param 'NetworkFabricPropertiesResponseWorkloadVpnConfiguration' workload_vpn_configuration: Configuration for workload vpn.
        """
        pulumi.set(__self__, "infrastructure_vpn_configuration", infrastructure_vpn_configuration)
        pulumi.set(__self__, "workload_vpn_configuration", workload_vpn_configuration)

    @property
    @pulumi.getter(name="infrastructureVpnConfiguration")
    def infrastructure_vpn_configuration(self) -> 'outputs.NetworkFabricPropertiesResponseInfrastructureVpnConfiguration':
        """
        Configuration for infrastructure vpn.
        """
        return pulumi.get(self, "infrastructure_vpn_configuration")

    @property
    @pulumi.getter(name="workloadVpnConfiguration")
    def workload_vpn_configuration(self) -> 'outputs.NetworkFabricPropertiesResponseWorkloadVpnConfiguration':
        """
        Configuration for workload vpn.
        """
        return pulumi.get(self, "workload_vpn_configuration")


@pulumi.output_type
class NetworkFabricPropertiesResponseTerminalServerConfiguration(dict):
    """
    Network and credentials configuration currently applied to terminal server.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkDeviceId":
            suggest = "network_device_id"
        elif key == "primaryIpv4Prefix":
            suggest = "primary_ipv4_prefix"
        elif key == "secondaryIpv4Prefix":
            suggest = "secondary_ipv4_prefix"
        elif key == "primaryIpv6Prefix":
            suggest = "primary_ipv6_prefix"
        elif key == "secondaryIpv6Prefix":
            suggest = "secondary_ipv6_prefix"
        elif key == "serialNumber":
            suggest = "serial_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFabricPropertiesResponseTerminalServerConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFabricPropertiesResponseTerminalServerConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFabricPropertiesResponseTerminalServerConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_device_id: str,
                 password: str,
                 primary_ipv4_prefix: str,
                 secondary_ipv4_prefix: str,
                 username: str,
                 primary_ipv6_prefix: Optional[str] = None,
                 secondary_ipv6_prefix: Optional[str] = None,
                 serial_number: Optional[str] = None):
        """
        Network and credentials configuration currently applied to terminal server.
        :param str network_device_id: ARM Resource ID used for the NetworkDevice.
        :param str password: Password for the terminal server connection.
        :param str primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param str secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param str username: Username for the terminal server connection.
        :param str primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param str secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param str serial_number: Serial Number of Terminal server.
        """
        pulumi.set(__self__, "network_device_id", network_device_id)
        pulumi.set(__self__, "password", password)
        if primary_ipv4_prefix is None:
            primary_ipv4_prefix = '172.31.0.0/31'
        pulumi.set(__self__, "primary_ipv4_prefix", primary_ipv4_prefix)
        if secondary_ipv4_prefix is None:
            secondary_ipv4_prefix = '172.31.0.20/31'
        pulumi.set(__self__, "secondary_ipv4_prefix", secondary_ipv4_prefix)
        pulumi.set(__self__, "username", username)
        if primary_ipv6_prefix is None:
            primary_ipv6_prefix = '3FFE:FFFF:0:CD30::a0/126'
        if primary_ipv6_prefix is not None:
            pulumi.set(__self__, "primary_ipv6_prefix", primary_ipv6_prefix)
        if secondary_ipv6_prefix is None:
            secondary_ipv6_prefix = '3FFE:FFFF:0:CD30::a4/126'
        if secondary_ipv6_prefix is not None:
            pulumi.set(__self__, "secondary_ipv6_prefix", secondary_ipv6_prefix)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)

    @property
    @pulumi.getter(name="networkDeviceId")
    def network_device_id(self) -> str:
        """
        ARM Resource ID used for the NetworkDevice.
        """
        return pulumi.get(self, "network_device_id")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Password for the terminal server connection.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="primaryIpv4Prefix")
    def primary_ipv4_prefix(self) -> str:
        """
        IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "primary_ipv4_prefix")

    @property
    @pulumi.getter(name="secondaryIpv4Prefix")
    def secondary_ipv4_prefix(self) -> str:
        """
        Secondary IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "secondary_ipv4_prefix")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for the terminal server connection.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="primaryIpv6Prefix")
    def primary_ipv6_prefix(self) -> Optional[str]:
        """
        IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "primary_ipv6_prefix")

    @property
    @pulumi.getter(name="secondaryIpv6Prefix")
    def secondary_ipv6_prefix(self) -> Optional[str]:
        """
        Secondary IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "secondary_ipv6_prefix")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[str]:
        """
        Serial Number of Terminal server.
        """
        return pulumi.get(self, "serial_number")


@pulumi.output_type
class NetworkFabricPropertiesResponseWorkloadVpnConfiguration(dict):
    """
    Configuration for workload vpn.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administrativeState":
            suggest = "administrative_state"
        elif key == "networkToNetworkInterconnectId":
            suggest = "network_to_network_interconnect_id"
        elif key == "optionBProperties":
            suggest = "option_b_properties"
        elif key == "optionAProperties":
            suggest = "option_a_properties"
        elif key == "peeringOption":
            suggest = "peering_option"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFabricPropertiesResponseWorkloadVpnConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFabricPropertiesResponseWorkloadVpnConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFabricPropertiesResponseWorkloadVpnConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 administrative_state: str,
                 network_to_network_interconnect_id: str,
                 option_b_properties: 'outputs.FabricOptionBPropertiesResponse',
                 option_a_properties: Optional['outputs.OptionAPropertiesResponse'] = None,
                 peering_option: Optional[str] = None):
        """
        Configuration for workload vpn.
        :param str administrative_state: Indicates configuration state. Example: enabled | disabled.
        :param str network_to_network_interconnect_id: Gets the networkToNetworkInterconnectId of the resource.
        :param 'FabricOptionBPropertiesResponse' option_b_properties: option B properties object
        :param 'OptionAPropertiesResponse' option_a_properties: option A properties object
        :param str peering_option: Peering option list.
        """
        pulumi.set(__self__, "administrative_state", administrative_state)
        pulumi.set(__self__, "network_to_network_interconnect_id", network_to_network_interconnect_id)
        pulumi.set(__self__, "option_b_properties", option_b_properties)
        if option_a_properties is not None:
            pulumi.set(__self__, "option_a_properties", option_a_properties)
        if peering_option is not None:
            pulumi.set(__self__, "peering_option", peering_option)

    @property
    @pulumi.getter(name="administrativeState")
    def administrative_state(self) -> str:
        """
        Indicates configuration state. Example: enabled | disabled.
        """
        return pulumi.get(self, "administrative_state")

    @property
    @pulumi.getter(name="networkToNetworkInterconnectId")
    def network_to_network_interconnect_id(self) -> str:
        """
        Gets the networkToNetworkInterconnectId of the resource.
        """
        return pulumi.get(self, "network_to_network_interconnect_id")

    @property
    @pulumi.getter(name="optionBProperties")
    def option_b_properties(self) -> 'outputs.FabricOptionBPropertiesResponse':
        """
        option B properties object
        """
        return pulumi.get(self, "option_b_properties")

    @property
    @pulumi.getter(name="optionAProperties")
    def option_a_properties(self) -> Optional['outputs.OptionAPropertiesResponse']:
        """
        option A properties object
        """
        return pulumi.get(self, "option_a_properties")

    @property
    @pulumi.getter(name="peeringOption")
    def peering_option(self) -> Optional[str]:
        """
        Peering option list.
        """
        return pulumi.get(self, "peering_option")


@pulumi.output_type
class NetworkToNetworkInterconnectPropertiesResponseLayer2Configuration(dict):
    """
    Common properties for Layer2Configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portCount":
            suggest = "port_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkToNetworkInterconnectPropertiesResponseLayer2Configuration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkToNetworkInterconnectPropertiesResponseLayer2Configuration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkToNetworkInterconnectPropertiesResponseLayer2Configuration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interfaces: Sequence[str],
                 mtu: int,
                 port_count: Optional[int] = None):
        """
        Common properties for Layer2Configuration.
        :param Sequence[str] interfaces: List of network device interfaces resource IDs.
        :param int mtu: MTU of the packets between PE & CE.
        :param int port_count: Number of ports connected between PE/CE. Maximum value depends on FabricSKU.
        """
        pulumi.set(__self__, "interfaces", interfaces)
        if mtu is None:
            mtu = 1500
        pulumi.set(__self__, "mtu", mtu)
        if port_count is not None:
            pulumi.set(__self__, "port_count", port_count)

    @property
    @pulumi.getter
    def interfaces(self) -> Sequence[str]:
        """
        List of network device interfaces resource IDs.
        """
        return pulumi.get(self, "interfaces")

    @property
    @pulumi.getter
    def mtu(self) -> int:
        """
        MTU of the packets between PE & CE.
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter(name="portCount")
    def port_count(self) -> Optional[int]:
        """
        Number of ports connected between PE/CE. Maximum value depends on FabricSKU.
        """
        return pulumi.get(self, "port_count")


@pulumi.output_type
class OptionAPropertiesResponse(dict):
    """
    Peering optionA properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bfdConfiguration":
            suggest = "bfd_configuration"
        elif key == "peerASN":
            suggest = "peer_asn"
        elif key == "primaryIpv4Prefix":
            suggest = "primary_ipv4_prefix"
        elif key == "primaryIpv6Prefix":
            suggest = "primary_ipv6_prefix"
        elif key == "secondaryIpv4Prefix":
            suggest = "secondary_ipv4_prefix"
        elif key == "secondaryIpv6Prefix":
            suggest = "secondary_ipv6_prefix"
        elif key == "vlanId":
            suggest = "vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptionAPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptionAPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptionAPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bfd_configuration: Optional['outputs.OptionAPropertiesResponseBfdConfiguration'] = None,
                 mtu: Optional[int] = None,
                 peer_asn: Optional[int] = None,
                 primary_ipv4_prefix: Optional[str] = None,
                 primary_ipv6_prefix: Optional[str] = None,
                 secondary_ipv4_prefix: Optional[str] = None,
                 secondary_ipv6_prefix: Optional[str] = None,
                 vlan_id: Optional[int] = None):
        """
        Peering optionA properties
        :param 'OptionAPropertiesResponseBfdConfiguration' bfd_configuration: BFD Configuration properties.
        :param int mtu: MTU to use for option A peering.
        :param int peer_asn: Peer ASN number.Example : 28
        :param str primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param str primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param str secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param str secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        :param int vlan_id: Vlan Id.Example : 501
        """
        if bfd_configuration is not None:
            pulumi.set(__self__, "bfd_configuration", bfd_configuration)
        if mtu is None:
            mtu = 1500
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if primary_ipv4_prefix is None:
            primary_ipv4_prefix = '172.31.0.0/31'
        if primary_ipv4_prefix is not None:
            pulumi.set(__self__, "primary_ipv4_prefix", primary_ipv4_prefix)
        if primary_ipv6_prefix is None:
            primary_ipv6_prefix = '3FFE:FFFF:0:CD30::a0/126'
        if primary_ipv6_prefix is not None:
            pulumi.set(__self__, "primary_ipv6_prefix", primary_ipv6_prefix)
        if secondary_ipv4_prefix is None:
            secondary_ipv4_prefix = '172.31.0.20/31'
        if secondary_ipv4_prefix is not None:
            pulumi.set(__self__, "secondary_ipv4_prefix", secondary_ipv4_prefix)
        if secondary_ipv6_prefix is None:
            secondary_ipv6_prefix = '3FFE:FFFF:0:CD30::a4/126'
        if secondary_ipv6_prefix is not None:
            pulumi.set(__self__, "secondary_ipv6_prefix", secondary_ipv6_prefix)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter(name="bfdConfiguration")
    def bfd_configuration(self) -> Optional['outputs.OptionAPropertiesResponseBfdConfiguration']:
        """
        BFD Configuration properties.
        """
        return pulumi.get(self, "bfd_configuration")

    @property
    @pulumi.getter
    def mtu(self) -> Optional[int]:
        """
        MTU to use for option A peering.
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter(name="peerASN")
    def peer_asn(self) -> Optional[int]:
        """
        Peer ASN number.Example : 28
        """
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="primaryIpv4Prefix")
    def primary_ipv4_prefix(self) -> Optional[str]:
        """
        IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "primary_ipv4_prefix")

    @property
    @pulumi.getter(name="primaryIpv6Prefix")
    def primary_ipv6_prefix(self) -> Optional[str]:
        """
        IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "primary_ipv6_prefix")

    @property
    @pulumi.getter(name="secondaryIpv4Prefix")
    def secondary_ipv4_prefix(self) -> Optional[str]:
        """
        Secondary IPv4 Address Prefix of CE-PE interconnect links. Default value is 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "secondary_ipv4_prefix")

    @property
    @pulumi.getter(name="secondaryIpv6Prefix")
    def secondary_ipv6_prefix(self) -> Optional[str]:
        """
        Secondary IPv6 Address Prefix of CE-PE interconnect links. Default value is 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
        """
        return pulumi.get(self, "secondary_ipv6_prefix")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[int]:
        """
        Vlan Id.Example : 501
        """
        return pulumi.get(self, "vlan_id")


@pulumi.output_type
class OptionAPropertiesResponseBfdConfiguration(dict):
    """
    BFD Configuration properties.
    """
    def __init__(__self__, *,
                 interval: int,
                 multiplier: int):
        """
        BFD Configuration properties.
        :param int interval: interval in seconds. Example: 300.
        :param int multiplier: multiplier. Example: 3.
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "multiplier", multiplier)

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        interval in seconds. Example: 300.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def multiplier(self) -> int:
        """
        multiplier. Example: 3.
        """
        return pulumi.get(self, "multiplier")


@pulumi.output_type
class OptionBPropertiesResponse(dict):
    """
    Option B configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exportRouteTargets":
            suggest = "export_route_targets"
        elif key == "importRouteTargets":
            suggest = "import_route_targets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptionBPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptionBPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptionBPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 export_route_targets: Optional[Sequence[str]] = None,
                 import_route_targets: Optional[Sequence[str]] = None):
        """
        Option B configuration.
        :param Sequence[str] export_route_targets: Route Targets to be applied for outgoing routes from CE.
        :param Sequence[str] import_route_targets: Route Targets to be applied for incoming routes into CE.
        """
        if export_route_targets is not None:
            pulumi.set(__self__, "export_route_targets", export_route_targets)
        if import_route_targets is not None:
            pulumi.set(__self__, "import_route_targets", import_route_targets)

    @property
    @pulumi.getter(name="exportRouteTargets")
    def export_route_targets(self) -> Optional[Sequence[str]]:
        """
        Route Targets to be applied for outgoing routes from CE.
        """
        return pulumi.get(self, "export_route_targets")

    @property
    @pulumi.getter(name="importRouteTargets")
    def import_route_targets(self) -> Optional[Sequence[str]]:
        """
        Route Targets to be applied for incoming routes into CE.
        """
        return pulumi.get(self, "import_route_targets")


@pulumi.output_type
class RoutePolicyPropertiesResponseAction(dict):
    """
    Route policy action properties.
    """
    def __init__(__self__, *,
                 action: Optional[str] = None,
                 set: Optional['outputs.RoutePolicyPropertiesResponseSet'] = None):
        """
        Route policy action properties.
        :param str action: action. Example: accept | deny.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if set is not None:
            pulumi.set(__self__, "set", set)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        action. Example: accept | deny.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def set(self) -> Optional['outputs.RoutePolicyPropertiesResponseSet']:
        return pulumi.get(self, "set")


@pulumi.output_type
class RoutePolicyPropertiesResponseConditions(dict):
    """
    Route Policy condition model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sequenceNumber":
            suggest = "sequence_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutePolicyPropertiesResponseConditions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutePolicyPropertiesResponseConditions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutePolicyPropertiesResponseConditions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional['outputs.RoutePolicyPropertiesResponseAction'] = None,
                 annotation: Optional[str] = None,
                 match: Optional['outputs.RoutePolicyPropertiesResponseMatch'] = None,
                 sequence_number: Optional[int] = None):
        """
        Route Policy condition model.
        :param 'RoutePolicyPropertiesResponseAction' action: Route policy action properties.
        :param str annotation: Switch configuration description.
        :param 'RoutePolicyPropertiesResponseMatch' match: Route policy match properties.
        :param int sequence_number: sequenceNumber of the route policy.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if sequence_number is not None:
            pulumi.set(__self__, "sequence_number", sequence_number)

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.RoutePolicyPropertiesResponseAction']:
        """
        Route policy action properties.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def annotation(self) -> Optional[str]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter
    def match(self) -> Optional['outputs.RoutePolicyPropertiesResponseMatch']:
        """
        Route policy match properties.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter(name="sequenceNumber")
    def sequence_number(self) -> Optional[int]:
        """
        sequenceNumber of the route policy.
        """
        return pulumi.get(self, "sequence_number")


@pulumi.output_type
class RoutePolicyPropertiesResponseMatch(dict):
    """
    Route policy match properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControlListIds":
            suggest = "access_control_list_ids"
        elif key == "ipCommunityListIds":
            suggest = "ip_community_list_ids"
        elif key == "ipExtendedCommunityListIds":
            suggest = "ip_extended_community_list_ids"
        elif key == "ipPrefixListIds":
            suggest = "ip_prefix_list_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutePolicyPropertiesResponseMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutePolicyPropertiesResponseMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutePolicyPropertiesResponseMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_control_list_ids: Optional[Sequence[str]] = None,
                 ip_community_list_ids: Optional[Sequence[str]] = None,
                 ip_extended_community_list_ids: Optional[Sequence[str]] = None,
                 ip_prefix_list_ids: Optional[Sequence[str]] = None):
        """
        Route policy match properties.
        :param Sequence[str] access_control_list_ids: accessControlListIds. Arm Resource Ids of AccessControlLists.
        :param Sequence[str] ip_community_list_ids: ipCommunityListIds. Arm Resource Ids of IpCommunityLists.
        :param Sequence[str] ip_extended_community_list_ids: ipExtendedCommunityListIds. Arm Resource Ids of IpCommunityLists.
        :param Sequence[str] ip_prefix_list_ids: ipPrefixListIds. Arm Resource Ids of IpPrefixLists.
        """
        if access_control_list_ids is not None:
            pulumi.set(__self__, "access_control_list_ids", access_control_list_ids)
        if ip_community_list_ids is not None:
            pulumi.set(__self__, "ip_community_list_ids", ip_community_list_ids)
        if ip_extended_community_list_ids is not None:
            pulumi.set(__self__, "ip_extended_community_list_ids", ip_extended_community_list_ids)
        if ip_prefix_list_ids is not None:
            pulumi.set(__self__, "ip_prefix_list_ids", ip_prefix_list_ids)

    @property
    @pulumi.getter(name="accessControlListIds")
    def access_control_list_ids(self) -> Optional[Sequence[str]]:
        """
        accessControlListIds. Arm Resource Ids of AccessControlLists.
        """
        return pulumi.get(self, "access_control_list_ids")

    @property
    @pulumi.getter(name="ipCommunityListIds")
    def ip_community_list_ids(self) -> Optional[Sequence[str]]:
        """
        ipCommunityListIds. Arm Resource Ids of IpCommunityLists.
        """
        return pulumi.get(self, "ip_community_list_ids")

    @property
    @pulumi.getter(name="ipExtendedCommunityListIds")
    def ip_extended_community_list_ids(self) -> Optional[Sequence[str]]:
        """
        ipExtendedCommunityListIds. Arm Resource Ids of IpCommunityLists.
        """
        return pulumi.get(self, "ip_extended_community_list_ids")

    @property
    @pulumi.getter(name="ipPrefixListIds")
    def ip_prefix_list_ids(self) -> Optional[Sequence[str]]:
        """
        ipPrefixListIds. Arm Resource Ids of IpPrefixLists.
        """
        return pulumi.get(self, "ip_prefix_list_ids")


@pulumi.output_type
class RoutePolicyPropertiesResponseSet(dict):
    def __init__(__self__, *,
                 set: Optional['outputs.RoutePolicyPropertiesResponseSetSet'] = None):
        """
        :param 'RoutePolicyPropertiesResponseSetSet' set: Route policy set manipulations.
        """
        if set is not None:
            pulumi.set(__self__, "set", set)

    @property
    @pulumi.getter
    def set(self) -> Optional['outputs.RoutePolicyPropertiesResponseSetSet']:
        """
        Route policy set manipulations.
        """
        return pulumi.get(self, "set")


@pulumi.output_type
class RoutePolicyPropertiesResponseSetSet(dict):
    """
    Route policy set manipulations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipCommunityListIds":
            suggest = "ip_community_list_ids"
        elif key == "ipExtendedCommunityListIds":
            suggest = "ip_extended_community_list_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutePolicyPropertiesResponseSetSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutePolicyPropertiesResponseSetSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutePolicyPropertiesResponseSetSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_community_list_ids: Optional[Sequence[str]] = None,
                 ip_extended_community_list_ids: Optional[Sequence[str]] = None):
        """
        Route policy set manipulations.
        :param Sequence[str] ip_community_list_ids: ipCommunityListIds. Arm Resource Ids of IpCommunityLists.
        :param Sequence[str] ip_extended_community_list_ids: ipExtendedCommunityListIds. Arm Resource Ids of IpCommunityLists.
        """
        if ip_community_list_ids is not None:
            pulumi.set(__self__, "ip_community_list_ids", ip_community_list_ids)
        if ip_extended_community_list_ids is not None:
            pulumi.set(__self__, "ip_extended_community_list_ids", ip_extended_community_list_ids)

    @property
    @pulumi.getter(name="ipCommunityListIds")
    def ip_community_list_ids(self) -> Optional[Sequence[str]]:
        """
        ipCommunityListIds. Arm Resource Ids of IpCommunityLists.
        """
        return pulumi.get(self, "ip_community_list_ids")

    @property
    @pulumi.getter(name="ipExtendedCommunityListIds")
    def ip_extended_community_list_ids(self) -> Optional[Sequence[str]]:
        """
        ipExtendedCommunityListIds. Arm Resource Ids of IpCommunityLists.
        """
        return pulumi.get(self, "ip_extended_community_list_ids")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


