# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = ['IpPrefixListArgs', 'IpPrefixList']

@pulumi.input_type
class IpPrefixListArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[Union[str, 'PrefixActionType']],
                 network_address: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 sequence_number: pulumi.Input[int],
                 annotation: Optional[pulumi.Input[str]] = None,
                 ip_prefix_list_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a IpPrefixList resource.
        :param pulumi.Input[Union[str, 'PrefixActionType']] action: action. Example: allow | deny.
        :param pulumi.Input[str] network_address: networkAddress. Example:1.1.1.0/24 | 1.1.10.10.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[int] sequence_number: sequenceNumber of the Ip Prefix List.
        :param pulumi.Input[str] annotation: Switch configuration description.
        :param pulumi.Input[str] ip_prefix_list_name: Name of the Ip Prefix List
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "network_address", network_address)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sequence_number", sequence_number)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if ip_prefix_list_name is not None:
            pulumi.set(__self__, "ip_prefix_list_name", ip_prefix_list_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[Union[str, 'PrefixActionType']]:
        """
        action. Example: allow | deny.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[Union[str, 'PrefixActionType']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> pulumi.Input[str]:
        """
        networkAddress. Example:1.1.1.0/24 | 1.1.10.10.
        """
        return pulumi.get(self, "network_address")

    @network_address.setter
    def network_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_address", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="sequenceNumber")
    def sequence_number(self) -> pulumi.Input[int]:
        """
        sequenceNumber of the Ip Prefix List.
        """
        return pulumi.get(self, "sequence_number")

    @sequence_number.setter
    def sequence_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "sequence_number", value)

    @property
    @pulumi.getter
    def annotation(self) -> Optional[pulumi.Input[str]]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation", value)

    @property
    @pulumi.getter(name="ipPrefixListName")
    def ip_prefix_list_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Ip Prefix List
        """
        return pulumi.get(self, "ip_prefix_list_name")

    @ip_prefix_list_name.setter
    def ip_prefix_list_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_prefix_list_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class IpPrefixList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union[str, 'PrefixActionType']]] = None,
                 annotation: Optional[pulumi.Input[str]] = None,
                 ip_prefix_list_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 network_address: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 sequence_number: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The IpPrefixList resource definition.
        API Version: 2023-02-01-preview.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union[str, 'PrefixActionType']] action: action. Example: allow | deny.
        :param pulumi.Input[str] annotation: Switch configuration description.
        :param pulumi.Input[str] ip_prefix_list_name: Name of the Ip Prefix List
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[str] network_address: networkAddress. Example:1.1.1.0/24 | 1.1.10.10.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[int] sequence_number: sequenceNumber of the Ip Prefix List.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpPrefixListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The IpPrefixList resource definition.
        API Version: 2023-02-01-preview.

        :param str resource_name: The name of the resource.
        :param IpPrefixListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpPrefixListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union[str, 'PrefixActionType']]] = None,
                 annotation: Optional[pulumi.Input[str]] = None,
                 ip_prefix_list_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 network_address: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 sequence_number: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpPrefixListArgs.__new__(IpPrefixListArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["annotation"] = annotation
            __props__.__dict__["ip_prefix_list_name"] = ip_prefix_list_name
            __props__.__dict__["location"] = location
            if network_address is None and not opts.urn:
                raise TypeError("Missing required property 'network_address'")
            __props__.__dict__["network_address"] = network_address
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sequence_number is None and not opts.urn:
                raise TypeError("Missing required property 'sequence_number'")
            __props__.__dict__["sequence_number"] = sequence_number
            __props__.__dict__["tags"] = tags
            __props__.__dict__["name"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:managednetworkfabric/v20230201preview:IpPrefixList")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(IpPrefixList, __self__).__init__(
            'azure-native:managednetworkfabric:IpPrefixList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'IpPrefixList':
        """
        Get an existing IpPrefixList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IpPrefixListArgs.__new__(IpPrefixListArgs)

        __props__.__dict__["action"] = None
        __props__.__dict__["annotation"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["network_address"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["sequence_number"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return IpPrefixList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[str]:
        """
        action. Example: allow | deny.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def annotation(self) -> pulumi.Output[Optional[str]]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> pulumi.Output[str]:
        """
        networkAddress. Example:1.1.1.0/24 | 1.1.10.10.
        """
        return pulumi.get(self, "network_address")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        Gets the provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="sequenceNumber")
    def sequence_number(self) -> pulumi.Output[int]:
        """
        sequenceNumber of the Ip Prefix List.
        """
        return pulumi.get(self, "sequence_number")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

