# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['IpCommunityListArgs', 'IpCommunityList']

@pulumi.input_type
class IpCommunityListArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[Union[str, 'CommunityActionType']],
                 advertise: pulumi.Input[Union[str, 'AdvertiseBoolean']],
                 export: pulumi.Input[Union[str, 'ExportBoolean']],
                 local_as: pulumi.Input[Union[str, 'LocalASBoolean']],
                 resource_group_name: pulumi.Input[str],
                 annotation: Optional[pulumi.Input[str]] = None,
                 community_members: Optional[pulumi.Input[Sequence[pulumi.Input['IpCommunityListPropertiesCommunityMembersArgs']]]] = None,
                 evpn_es_import_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input['IpCommunityListPropertiesEvpnEsImportRouteTargetsArgs']]]] = None,
                 gshut: Optional[pulumi.Input[Union[str, 'GshutBoolean']]] = None,
                 internet: Optional[pulumi.Input[Union[str, 'InternetBoolean']]] = None,
                 ip_community_list_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a IpCommunityList resource.
        :param pulumi.Input[Union[str, 'CommunityActionType']] action: action. Example: allow | deny.
        :param pulumi.Input[Union[str, 'AdvertiseBoolean']] advertise: noAdvertise. Example: true | false.
        :param pulumi.Input[Union[str, 'ExportBoolean']] export: noExport. Example: true | false.
        :param pulumi.Input[Union[str, 'LocalASBoolean']] local_as: Local Autonomous System. Example: true | false.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] annotation: Switch configuration description.
        :param pulumi.Input[Sequence[pulumi.Input['IpCommunityListPropertiesCommunityMembersArgs']]] community_members: Ip Community List communityMembers.
        :param pulumi.Input[Sequence[pulumi.Input['IpCommunityListPropertiesEvpnEsImportRouteTargetsArgs']]] evpn_es_import_route_targets: Ip Community List evpnEsImportRouteTargets.
        :param pulumi.Input[Union[str, 'GshutBoolean']] gshut:  Graceful Shutdown (GSHUT). Example: true | false.
        :param pulumi.Input[Union[str, 'InternetBoolean']] internet: Internet access. Example: true | false.
        :param pulumi.Input[str] ip_community_list_name: Name of the Ip Community List
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "advertise", advertise)
        pulumi.set(__self__, "export", export)
        pulumi.set(__self__, "local_as", local_as)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if community_members is not None:
            pulumi.set(__self__, "community_members", community_members)
        if evpn_es_import_route_targets is not None:
            pulumi.set(__self__, "evpn_es_import_route_targets", evpn_es_import_route_targets)
        if gshut is not None:
            pulumi.set(__self__, "gshut", gshut)
        if internet is not None:
            pulumi.set(__self__, "internet", internet)
        if ip_community_list_name is not None:
            pulumi.set(__self__, "ip_community_list_name", ip_community_list_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[Union[str, 'CommunityActionType']]:
        """
        action. Example: allow | deny.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[Union[str, 'CommunityActionType']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def advertise(self) -> pulumi.Input[Union[str, 'AdvertiseBoolean']]:
        """
        noAdvertise. Example: true | false.
        """
        return pulumi.get(self, "advertise")

    @advertise.setter
    def advertise(self, value: pulumi.Input[Union[str, 'AdvertiseBoolean']]):
        pulumi.set(self, "advertise", value)

    @property
    @pulumi.getter
    def export(self) -> pulumi.Input[Union[str, 'ExportBoolean']]:
        """
        noExport. Example: true | false.
        """
        return pulumi.get(self, "export")

    @export.setter
    def export(self, value: pulumi.Input[Union[str, 'ExportBoolean']]):
        pulumi.set(self, "export", value)

    @property
    @pulumi.getter(name="localAS")
    def local_as(self) -> pulumi.Input[Union[str, 'LocalASBoolean']]:
        """
        Local Autonomous System. Example: true | false.
        """
        return pulumi.get(self, "local_as")

    @local_as.setter
    def local_as(self, value: pulumi.Input[Union[str, 'LocalASBoolean']]):
        pulumi.set(self, "local_as", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def annotation(self) -> Optional[pulumi.Input[str]]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation", value)

    @property
    @pulumi.getter(name="communityMembers")
    def community_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpCommunityListPropertiesCommunityMembersArgs']]]]:
        """
        Ip Community List communityMembers.
        """
        return pulumi.get(self, "community_members")

    @community_members.setter
    def community_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpCommunityListPropertiesCommunityMembersArgs']]]]):
        pulumi.set(self, "community_members", value)

    @property
    @pulumi.getter(name="evpnEsImportRouteTargets")
    def evpn_es_import_route_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpCommunityListPropertiesEvpnEsImportRouteTargetsArgs']]]]:
        """
        Ip Community List evpnEsImportRouteTargets.
        """
        return pulumi.get(self, "evpn_es_import_route_targets")

    @evpn_es_import_route_targets.setter
    def evpn_es_import_route_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpCommunityListPropertiesEvpnEsImportRouteTargetsArgs']]]]):
        pulumi.set(self, "evpn_es_import_route_targets", value)

    @property
    @pulumi.getter
    def gshut(self) -> Optional[pulumi.Input[Union[str, 'GshutBoolean']]]:
        """
         Graceful Shutdown (GSHUT). Example: true | false.
        """
        return pulumi.get(self, "gshut")

    @gshut.setter
    def gshut(self, value: Optional[pulumi.Input[Union[str, 'GshutBoolean']]]):
        pulumi.set(self, "gshut", value)

    @property
    @pulumi.getter
    def internet(self) -> Optional[pulumi.Input[Union[str, 'InternetBoolean']]]:
        """
        Internet access. Example: true | false.
        """
        return pulumi.get(self, "internet")

    @internet.setter
    def internet(self, value: Optional[pulumi.Input[Union[str, 'InternetBoolean']]]):
        pulumi.set(self, "internet", value)

    @property
    @pulumi.getter(name="ipCommunityListName")
    def ip_community_list_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Ip Community List
        """
        return pulumi.get(self, "ip_community_list_name")

    @ip_community_list_name.setter
    def ip_community_list_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_community_list_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class IpCommunityList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union[str, 'CommunityActionType']]] = None,
                 advertise: Optional[pulumi.Input[Union[str, 'AdvertiseBoolean']]] = None,
                 annotation: Optional[pulumi.Input[str]] = None,
                 community_members: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpCommunityListPropertiesCommunityMembersArgs']]]]] = None,
                 evpn_es_import_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpCommunityListPropertiesEvpnEsImportRouteTargetsArgs']]]]] = None,
                 export: Optional[pulumi.Input[Union[str, 'ExportBoolean']]] = None,
                 gshut: Optional[pulumi.Input[Union[str, 'GshutBoolean']]] = None,
                 internet: Optional[pulumi.Input[Union[str, 'InternetBoolean']]] = None,
                 ip_community_list_name: Optional[pulumi.Input[str]] = None,
                 local_as: Optional[pulumi.Input[Union[str, 'LocalASBoolean']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The IpCommunityList resource definition.
        API Version: 2023-02-01-preview.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union[str, 'CommunityActionType']] action: action. Example: allow | deny.
        :param pulumi.Input[Union[str, 'AdvertiseBoolean']] advertise: noAdvertise. Example: true | false.
        :param pulumi.Input[str] annotation: Switch configuration description.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpCommunityListPropertiesCommunityMembersArgs']]]] community_members: Ip Community List communityMembers.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpCommunityListPropertiesEvpnEsImportRouteTargetsArgs']]]] evpn_es_import_route_targets: Ip Community List evpnEsImportRouteTargets.
        :param pulumi.Input[Union[str, 'ExportBoolean']] export: noExport. Example: true | false.
        :param pulumi.Input[Union[str, 'GshutBoolean']] gshut:  Graceful Shutdown (GSHUT). Example: true | false.
        :param pulumi.Input[Union[str, 'InternetBoolean']] internet: Internet access. Example: true | false.
        :param pulumi.Input[str] ip_community_list_name: Name of the Ip Community List
        :param pulumi.Input[Union[str, 'LocalASBoolean']] local_as: Local Autonomous System. Example: true | false.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpCommunityListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The IpCommunityList resource definition.
        API Version: 2023-02-01-preview.

        :param str resource_name: The name of the resource.
        :param IpCommunityListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpCommunityListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union[str, 'CommunityActionType']]] = None,
                 advertise: Optional[pulumi.Input[Union[str, 'AdvertiseBoolean']]] = None,
                 annotation: Optional[pulumi.Input[str]] = None,
                 community_members: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpCommunityListPropertiesCommunityMembersArgs']]]]] = None,
                 evpn_es_import_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpCommunityListPropertiesEvpnEsImportRouteTargetsArgs']]]]] = None,
                 export: Optional[pulumi.Input[Union[str, 'ExportBoolean']]] = None,
                 gshut: Optional[pulumi.Input[Union[str, 'GshutBoolean']]] = None,
                 internet: Optional[pulumi.Input[Union[str, 'InternetBoolean']]] = None,
                 ip_community_list_name: Optional[pulumi.Input[str]] = None,
                 local_as: Optional[pulumi.Input[Union[str, 'LocalASBoolean']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpCommunityListArgs.__new__(IpCommunityListArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if advertise is None and not opts.urn:
                raise TypeError("Missing required property 'advertise'")
            __props__.__dict__["advertise"] = advertise
            __props__.__dict__["annotation"] = annotation
            __props__.__dict__["community_members"] = community_members
            __props__.__dict__["evpn_es_import_route_targets"] = evpn_es_import_route_targets
            if export is None and not opts.urn:
                raise TypeError("Missing required property 'export'")
            __props__.__dict__["export"] = export
            __props__.__dict__["gshut"] = gshut
            __props__.__dict__["internet"] = internet
            __props__.__dict__["ip_community_list_name"] = ip_community_list_name
            if local_as is None and not opts.urn:
                raise TypeError("Missing required property 'local_as'")
            __props__.__dict__["local_as"] = local_as
            __props__.__dict__["location"] = location
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["name"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:managednetworkfabric/v20230201preview:IpCommunityList")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(IpCommunityList, __self__).__init__(
            'azure-native:managednetworkfabric:IpCommunityList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'IpCommunityList':
        """
        Get an existing IpCommunityList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IpCommunityListArgs.__new__(IpCommunityListArgs)

        __props__.__dict__["action"] = None
        __props__.__dict__["advertise"] = None
        __props__.__dict__["annotation"] = None
        __props__.__dict__["community_members"] = None
        __props__.__dict__["evpn_es_import_route_targets"] = None
        __props__.__dict__["export"] = None
        __props__.__dict__["gshut"] = None
        __props__.__dict__["internet"] = None
        __props__.__dict__["local_as"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return IpCommunityList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[str]:
        """
        action. Example: allow | deny.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def advertise(self) -> pulumi.Output[str]:
        """
        noAdvertise. Example: true | false.
        """
        return pulumi.get(self, "advertise")

    @property
    @pulumi.getter
    def annotation(self) -> pulumi.Output[Optional[str]]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter(name="communityMembers")
    def community_members(self) -> pulumi.Output[Optional[Sequence['outputs.IpCommunityListPropertiesResponseCommunityMembers']]]:
        """
        Ip Community List communityMembers.
        """
        return pulumi.get(self, "community_members")

    @property
    @pulumi.getter(name="evpnEsImportRouteTargets")
    def evpn_es_import_route_targets(self) -> pulumi.Output[Optional[Sequence['outputs.IpCommunityListPropertiesResponseEvpnEsImportRouteTargets']]]:
        """
        Ip Community List evpnEsImportRouteTargets.
        """
        return pulumi.get(self, "evpn_es_import_route_targets")

    @property
    @pulumi.getter
    def export(self) -> pulumi.Output[str]:
        """
        noExport. Example: true | false.
        """
        return pulumi.get(self, "export")

    @property
    @pulumi.getter
    def gshut(self) -> pulumi.Output[Optional[str]]:
        """
         Graceful Shutdown (GSHUT). Example: true | false.
        """
        return pulumi.get(self, "gshut")

    @property
    @pulumi.getter
    def internet(self) -> pulumi.Output[Optional[str]]:
        """
        Internet access. Example: true | false.
        """
        return pulumi.get(self, "internet")

    @property
    @pulumi.getter(name="localAS")
    def local_as(self) -> pulumi.Output[str]:
        """
        Local Autonomous System. Example: true | false.
        """
        return pulumi.get(self, "local_as")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        Gets the provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

