# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetNetworkInterfaceStatusResult',
    'AwaitableGetNetworkInterfaceStatusResult',
    'get_network_interface_status',
    'get_network_interface_status_output',
]

@pulumi.output_type
class GetNetworkInterfaceStatusResult:
    """
    Interface running status properties
    """
    def __init__(__self__, administrative_state=None, connected_to=None, operational_status=None, phy_status=None, transceiver_status=None):
        if administrative_state and not isinstance(administrative_state, str):
            raise TypeError("Expected argument 'administrative_state' to be a str")
        pulumi.set(__self__, "administrative_state", administrative_state)
        if connected_to and not isinstance(connected_to, str):
            raise TypeError("Expected argument 'connected_to' to be a str")
        pulumi.set(__self__, "connected_to", connected_to)
        if operational_status and not isinstance(operational_status, str):
            raise TypeError("Expected argument 'operational_status' to be a str")
        pulumi.set(__self__, "operational_status", operational_status)
        if phy_status and not isinstance(phy_status, str):
            raise TypeError("Expected argument 'phy_status' to be a str")
        pulumi.set(__self__, "phy_status", phy_status)
        if transceiver_status and not isinstance(transceiver_status, str):
            raise TypeError("Expected argument 'transceiver_status' to be a str")
        pulumi.set(__self__, "transceiver_status", transceiver_status)

    @property
    @pulumi.getter(name="administrativeState")
    def administrative_state(self) -> str:
        """
        The interface administrative state.
        """
        return pulumi.get(self, "administrative_state")

    @property
    @pulumi.getter(name="connectedTo")
    def connected_to(self) -> Optional[str]:
        """
        Connected to ARM resource or external interface
        """
        return pulumi.get(self, "connected_to")

    @property
    @pulumi.getter(name="operationalStatus")
    def operational_status(self) -> Optional[str]:
        """
        The interface operational status.
        """
        return pulumi.get(self, "operational_status")

    @property
    @pulumi.getter(name="phyStatus")
    def phy_status(self) -> Optional[str]:
        """
        The physical status.
        """
        return pulumi.get(self, "phy_status")

    @property
    @pulumi.getter(name="transceiverStatus")
    def transceiver_status(self) -> Optional[str]:
        """
        The interface transceiver type. Example: up or down
        """
        return pulumi.get(self, "transceiver_status")


class AwaitableGetNetworkInterfaceStatusResult(GetNetworkInterfaceStatusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkInterfaceStatusResult(
            administrative_state=self.administrative_state,
            connected_to=self.connected_to,
            operational_status=self.operational_status,
            phy_status=self.phy_status,
            transceiver_status=self.transceiver_status)


def get_network_interface_status(network_device_name: Optional[str] = None,
                                 network_interface_name: Optional[str] = None,
                                 resource_group_name: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkInterfaceStatusResult:
    """
    Get the running status of the Network Interface.
    API Version: 2023-02-01-preview.


    :param str network_device_name: Name of the NetworkDevice.
    :param str network_interface_name: Name of the NetworkInterface
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['networkDeviceName'] = network_device_name
    __args__['networkInterfaceName'] = network_interface_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:managednetworkfabric:getNetworkInterfaceStatus', __args__, opts=opts, typ=GetNetworkInterfaceStatusResult).value

    return AwaitableGetNetworkInterfaceStatusResult(
        administrative_state=__ret__.administrative_state,
        connected_to=__ret__.connected_to,
        operational_status=__ret__.operational_status,
        phy_status=__ret__.phy_status,
        transceiver_status=__ret__.transceiver_status)


@_utilities.lift_output_func(get_network_interface_status)
def get_network_interface_status_output(network_device_name: Optional[pulumi.Input[str]] = None,
                                        network_interface_name: Optional[pulumi.Input[str]] = None,
                                        resource_group_name: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetworkInterfaceStatusResult]:
    """
    Get the running status of the Network Interface.
    API Version: 2023-02-01-preview.


    :param str network_device_name: Name of the NetworkDevice.
    :param str network_interface_name: Name of the NetworkInterface
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
