# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkDeviceResult',
    'AwaitableGetNetworkDeviceResult',
    'get_network_device',
    'get_network_device_output',
]

@pulumi.output_type
class GetNetworkDeviceResult:
    """
    The NetworkDevice resource definition.
    """
    def __init__(__self__, annotation=None, host_name=None, id=None, location=None, name=None, network_device_role=None, network_device_sku=None, network_rack_id=None, provisioning_state=None, serial_number=None, system_data=None, tags=None, type=None, version=None):
        if annotation and not isinstance(annotation, str):
            raise TypeError("Expected argument 'annotation' to be a str")
        pulumi.set(__self__, "annotation", annotation)
        if host_name and not isinstance(host_name, str):
            raise TypeError("Expected argument 'host_name' to be a str")
        pulumi.set(__self__, "host_name", host_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_device_role and not isinstance(network_device_role, str):
            raise TypeError("Expected argument 'network_device_role' to be a str")
        pulumi.set(__self__, "network_device_role", network_device_role)
        if network_device_sku and not isinstance(network_device_sku, str):
            raise TypeError("Expected argument 'network_device_sku' to be a str")
        pulumi.set(__self__, "network_device_sku", network_device_sku)
        if network_rack_id and not isinstance(network_rack_id, str):
            raise TypeError("Expected argument 'network_rack_id' to be a str")
        pulumi.set(__self__, "network_rack_id", network_rack_id)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if serial_number and not isinstance(serial_number, str):
            raise TypeError("Expected argument 'serial_number' to be a str")
        pulumi.set(__self__, "serial_number", serial_number)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def annotation(self) -> Optional[str]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        The host Name of the device.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkDeviceRole")
    def network_device_role(self) -> str:
        """
        networkDeviceRole is the device role: Example: CE | ToR.
        """
        return pulumi.get(self, "network_device_role")

    @property
    @pulumi.getter(name="networkDeviceSku")
    def network_device_sku(self) -> str:
        """
        Network Device SKU name.
        """
        return pulumi.get(self, "network_device_sku")

    @property
    @pulumi.getter(name="networkRackId")
    def network_rack_id(self) -> str:
        """
        Reference to network rack resource id.
        """
        return pulumi.get(self, "network_rack_id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets the provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> str:
        """
        serialNumber of the format Make;Model;HardwareRevisionId;SerialNumber. Example: Arista;DCS-7280DR3-24;12.05;JPE21116969
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Current version of the device as defined in SKU.
        """
        return pulumi.get(self, "version")


class AwaitableGetNetworkDeviceResult(GetNetworkDeviceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkDeviceResult(
            annotation=self.annotation,
            host_name=self.host_name,
            id=self.id,
            location=self.location,
            name=self.name,
            network_device_role=self.network_device_role,
            network_device_sku=self.network_device_sku,
            network_rack_id=self.network_rack_id,
            provisioning_state=self.provisioning_state,
            serial_number=self.serial_number,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type,
            version=self.version)


def get_network_device(network_device_name: Optional[str] = None,
                       resource_group_name: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkDeviceResult:
    """
    Get the Network Device resource details.
    API Version: 2023-02-01-preview.


    :param str network_device_name: Name of the Network Device
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['networkDeviceName'] = network_device_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:managednetworkfabric:getNetworkDevice', __args__, opts=opts, typ=GetNetworkDeviceResult).value

    return AwaitableGetNetworkDeviceResult(
        annotation=__ret__.annotation,
        host_name=__ret__.host_name,
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        network_device_role=__ret__.network_device_role,
        network_device_sku=__ret__.network_device_sku,
        network_rack_id=__ret__.network_rack_id,
        provisioning_state=__ret__.provisioning_state,
        serial_number=__ret__.serial_number,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type,
        version=__ret__.version)


@_utilities.lift_output_func(get_network_device)
def get_network_device_output(network_device_name: Optional[pulumi.Input[str]] = None,
                              resource_group_name: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetworkDeviceResult]:
    """
    Get the Network Device resource details.
    API Version: 2023-02-01-preview.


    :param str network_device_name: Name of the Network Device
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
