# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetIpPrefixListResult',
    'AwaitableGetIpPrefixListResult',
    'get_ip_prefix_list',
    'get_ip_prefix_list_output',
]

@pulumi.output_type
class GetIpPrefixListResult:
    """
    The IpPrefixList resource definition.
    """
    def __init__(__self__, action=None, annotation=None, id=None, location=None, name=None, network_address=None, provisioning_state=None, sequence_number=None, system_data=None, tags=None, type=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if annotation and not isinstance(annotation, str):
            raise TypeError("Expected argument 'annotation' to be a str")
        pulumi.set(__self__, "annotation", annotation)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_address and not isinstance(network_address, str):
            raise TypeError("Expected argument 'network_address' to be a str")
        pulumi.set(__self__, "network_address", network_address)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if sequence_number and not isinstance(sequence_number, int):
            raise TypeError("Expected argument 'sequence_number' to be a int")
        pulumi.set(__self__, "sequence_number", sequence_number)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        action. Example: allow | deny.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def annotation(self) -> Optional[str]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> str:
        """
        networkAddress. Example:1.1.1.0/24 | 1.1.10.10.
        """
        return pulumi.get(self, "network_address")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets the provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="sequenceNumber")
    def sequence_number(self) -> int:
        """
        sequenceNumber of the Ip Prefix List.
        """
        return pulumi.get(self, "sequence_number")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetIpPrefixListResult(GetIpPrefixListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpPrefixListResult(
            action=self.action,
            annotation=self.annotation,
            id=self.id,
            location=self.location,
            name=self.name,
            network_address=self.network_address,
            provisioning_state=self.provisioning_state,
            sequence_number=self.sequence_number,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type)


def get_ip_prefix_list(ip_prefix_list_name: Optional[str] = None,
                       resource_group_name: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpPrefixListResult:
    """
    Implements Ip Prefix List GET method.
    API Version: 2023-02-01-preview.


    :param str ip_prefix_list_name: Name of the Ip Prefix List
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['ipPrefixListName'] = ip_prefix_list_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:managednetworkfabric:getIpPrefixList', __args__, opts=opts, typ=GetIpPrefixListResult).value

    return AwaitableGetIpPrefixListResult(
        action=__ret__.action,
        annotation=__ret__.annotation,
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        network_address=__ret__.network_address,
        provisioning_state=__ret__.provisioning_state,
        sequence_number=__ret__.sequence_number,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_ip_prefix_list)
def get_ip_prefix_list_output(ip_prefix_list_name: Optional[pulumi.Input[str]] = None,
                              resource_group_name: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIpPrefixListResult]:
    """
    Implements Ip Prefix List GET method.
    API Version: 2023-02-01-preview.


    :param str ip_prefix_list_name: Name of the Ip Prefix List
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
