# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetInternalNetworkResult',
    'AwaitableGetInternalNetworkResult',
    'get_internal_network',
    'get_internal_network_output',
]

@pulumi.output_type
class GetInternalNetworkResult:
    """
    Defines the InternalNetwork item.
    """
    def __init__(__self__, administrative_state=None, annotation=None, bfd_disabled_on_resources=None, bfd_for_static_routes_disabled_on_resources=None, bgp_configuration=None, bgp_disabled_on_resources=None, connected_i_pv4_subnets=None, connected_i_pv6_subnets=None, disabled_on_resources=None, export_route_policy_id=None, id=None, import_route_policy_id=None, mtu=None, name=None, provisioning_state=None, static_route_configuration=None, system_data=None, type=None, vlan_id=None):
        if administrative_state and not isinstance(administrative_state, str):
            raise TypeError("Expected argument 'administrative_state' to be a str")
        pulumi.set(__self__, "administrative_state", administrative_state)
        if annotation and not isinstance(annotation, str):
            raise TypeError("Expected argument 'annotation' to be a str")
        pulumi.set(__self__, "annotation", annotation)
        if bfd_disabled_on_resources and not isinstance(bfd_disabled_on_resources, list):
            raise TypeError("Expected argument 'bfd_disabled_on_resources' to be a list")
        pulumi.set(__self__, "bfd_disabled_on_resources", bfd_disabled_on_resources)
        if bfd_for_static_routes_disabled_on_resources and not isinstance(bfd_for_static_routes_disabled_on_resources, list):
            raise TypeError("Expected argument 'bfd_for_static_routes_disabled_on_resources' to be a list")
        pulumi.set(__self__, "bfd_for_static_routes_disabled_on_resources", bfd_for_static_routes_disabled_on_resources)
        if bgp_configuration and not isinstance(bgp_configuration, dict):
            raise TypeError("Expected argument 'bgp_configuration' to be a dict")
        pulumi.set(__self__, "bgp_configuration", bgp_configuration)
        if bgp_disabled_on_resources and not isinstance(bgp_disabled_on_resources, list):
            raise TypeError("Expected argument 'bgp_disabled_on_resources' to be a list")
        pulumi.set(__self__, "bgp_disabled_on_resources", bgp_disabled_on_resources)
        if connected_i_pv4_subnets and not isinstance(connected_i_pv4_subnets, list):
            raise TypeError("Expected argument 'connected_i_pv4_subnets' to be a list")
        pulumi.set(__self__, "connected_i_pv4_subnets", connected_i_pv4_subnets)
        if connected_i_pv6_subnets and not isinstance(connected_i_pv6_subnets, list):
            raise TypeError("Expected argument 'connected_i_pv6_subnets' to be a list")
        pulumi.set(__self__, "connected_i_pv6_subnets", connected_i_pv6_subnets)
        if disabled_on_resources and not isinstance(disabled_on_resources, list):
            raise TypeError("Expected argument 'disabled_on_resources' to be a list")
        pulumi.set(__self__, "disabled_on_resources", disabled_on_resources)
        if export_route_policy_id and not isinstance(export_route_policy_id, str):
            raise TypeError("Expected argument 'export_route_policy_id' to be a str")
        pulumi.set(__self__, "export_route_policy_id", export_route_policy_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if import_route_policy_id and not isinstance(import_route_policy_id, str):
            raise TypeError("Expected argument 'import_route_policy_id' to be a str")
        pulumi.set(__self__, "import_route_policy_id", import_route_policy_id)
        if mtu and not isinstance(mtu, int):
            raise TypeError("Expected argument 'mtu' to be a int")
        pulumi.set(__self__, "mtu", mtu)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if static_route_configuration and not isinstance(static_route_configuration, dict):
            raise TypeError("Expected argument 'static_route_configuration' to be a dict")
        pulumi.set(__self__, "static_route_configuration", static_route_configuration)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vlan_id and not isinstance(vlan_id, int):
            raise TypeError("Expected argument 'vlan_id' to be a int")
        pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter(name="administrativeState")
    def administrative_state(self) -> str:
        """
        Administrative state of the InternalNetwork. Example: Enabled | Disabled.
        """
        return pulumi.get(self, "administrative_state")

    @property
    @pulumi.getter
    def annotation(self) -> Optional[str]:
        """
        Switch configuration description.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter(name="bfdDisabledOnResources")
    def bfd_disabled_on_resources(self) -> Sequence[str]:
        """
        List of resources the BFD for BGP is disabled on. Can be either entire NetworkFabric or NetworkRack.
        """
        return pulumi.get(self, "bfd_disabled_on_resources")

    @property
    @pulumi.getter(name="bfdForStaticRoutesDisabledOnResources")
    def bfd_for_static_routes_disabled_on_resources(self) -> Sequence[str]:
        """
        List of resources the BFD of StaticRoutes is disabled on. Can be either entire NetworkFabric or NetworkRack.
        """
        return pulumi.get(self, "bfd_for_static_routes_disabled_on_resources")

    @property
    @pulumi.getter(name="bgpConfiguration")
    def bgp_configuration(self) -> Optional['outputs.InternalNetworkPatchablePropertiesResponseBgpConfiguration']:
        """
        BGP configuration properties
        """
        return pulumi.get(self, "bgp_configuration")

    @property
    @pulumi.getter(name="bgpDisabledOnResources")
    def bgp_disabled_on_resources(self) -> Sequence[str]:
        """
        List of resources the BGP is disabled on. Can be either entire NetworkFabric or NetworkRack.
        """
        return pulumi.get(self, "bgp_disabled_on_resources")

    @property
    @pulumi.getter(name="connectedIPv4Subnets")
    def connected_i_pv4_subnets(self) -> Optional[Sequence['outputs.InternalNetworkPatchablePropertiesResponseConnectedIPv4Subnets']]:
        """
        List with object connectedIPv4Subnets.
        """
        return pulumi.get(self, "connected_i_pv4_subnets")

    @property
    @pulumi.getter(name="connectedIPv6Subnets")
    def connected_i_pv6_subnets(self) -> Optional[Sequence['outputs.InternalNetworkPatchablePropertiesResponseConnectedIPv6Subnets']]:
        """
        List with object connectedIPv6Subnets.
        """
        return pulumi.get(self, "connected_i_pv6_subnets")

    @property
    @pulumi.getter(name="disabledOnResources")
    def disabled_on_resources(self) -> Sequence[str]:
        """
        List of resources the InternalNetwork is disabled on. Can be either entire NetworkFabric or NetworkRack.
        """
        return pulumi.get(self, "disabled_on_resources")

    @property
    @pulumi.getter(name="exportRoutePolicyId")
    def export_route_policy_id(self) -> Optional[str]:
        """
        ARM resource ID of importRoutePolicy.
        """
        return pulumi.get(self, "export_route_policy_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="importRoutePolicyId")
    def import_route_policy_id(self) -> Optional[str]:
        """
        ARM resource ID of importRoutePolicy.
        """
        return pulumi.get(self, "import_route_policy_id")

    @property
    @pulumi.getter
    def mtu(self) -> Optional[int]:
        """
        Maximum transmission unit. Default value is 1500.
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets the provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="staticRouteConfiguration")
    def static_route_configuration(self) -> Optional['outputs.InternalNetworkPatchablePropertiesResponseStaticRouteConfiguration']:
        """
        staticRouteConfiguration model.
        """
        return pulumi.get(self, "static_route_configuration")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> int:
        """
        Vlan identifier. Example: 1001.
        """
        return pulumi.get(self, "vlan_id")


class AwaitableGetInternalNetworkResult(GetInternalNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInternalNetworkResult(
            administrative_state=self.administrative_state,
            annotation=self.annotation,
            bfd_disabled_on_resources=self.bfd_disabled_on_resources,
            bfd_for_static_routes_disabled_on_resources=self.bfd_for_static_routes_disabled_on_resources,
            bgp_configuration=self.bgp_configuration,
            bgp_disabled_on_resources=self.bgp_disabled_on_resources,
            connected_i_pv4_subnets=self.connected_i_pv4_subnets,
            connected_i_pv6_subnets=self.connected_i_pv6_subnets,
            disabled_on_resources=self.disabled_on_resources,
            export_route_policy_id=self.export_route_policy_id,
            id=self.id,
            import_route_policy_id=self.import_route_policy_id,
            mtu=self.mtu,
            name=self.name,
            provisioning_state=self.provisioning_state,
            static_route_configuration=self.static_route_configuration,
            system_data=self.system_data,
            type=self.type,
            vlan_id=self.vlan_id)


def get_internal_network(internal_network_name: Optional[str] = None,
                         l3_isolation_domain_name: Optional[str] = None,
                         resource_group_name: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInternalNetworkResult:
    """
    Gets a InternalNetworks.
    API Version: 2023-02-01-preview.


    :param str internal_network_name: Name of the InternalNetwork
    :param str l3_isolation_domain_name: Name of the L3IsolationDomain
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['internalNetworkName'] = internal_network_name
    __args__['l3IsolationDomainName'] = l3_isolation_domain_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:managednetworkfabric:getInternalNetwork', __args__, opts=opts, typ=GetInternalNetworkResult).value

    return AwaitableGetInternalNetworkResult(
        administrative_state=__ret__.administrative_state,
        annotation=__ret__.annotation,
        bfd_disabled_on_resources=__ret__.bfd_disabled_on_resources,
        bfd_for_static_routes_disabled_on_resources=__ret__.bfd_for_static_routes_disabled_on_resources,
        bgp_configuration=__ret__.bgp_configuration,
        bgp_disabled_on_resources=__ret__.bgp_disabled_on_resources,
        connected_i_pv4_subnets=__ret__.connected_i_pv4_subnets,
        connected_i_pv6_subnets=__ret__.connected_i_pv6_subnets,
        disabled_on_resources=__ret__.disabled_on_resources,
        export_route_policy_id=__ret__.export_route_policy_id,
        id=__ret__.id,
        import_route_policy_id=__ret__.import_route_policy_id,
        mtu=__ret__.mtu,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        static_route_configuration=__ret__.static_route_configuration,
        system_data=__ret__.system_data,
        type=__ret__.type,
        vlan_id=__ret__.vlan_id)


@_utilities.lift_output_func(get_internal_network)
def get_internal_network_output(internal_network_name: Optional[pulumi.Input[str]] = None,
                                l3_isolation_domain_name: Optional[pulumi.Input[str]] = None,
                                resource_group_name: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInternalNetworkResult]:
    """
    Gets a InternalNetworks.
    API Version: 2023-02-01-preview.


    :param str internal_network_name: Name of the InternalNetwork
    :param str l3_isolation_domain_name: Name of the L3IsolationDomain
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
