# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetOrganizationApiKeyResult',
    'AwaitableGetOrganizationApiKeyResult',
    'get_organization_api_key',
    'get_organization_api_key_output',
]

@pulumi.output_type
class GetOrganizationApiKeyResult:
    """
    The User Api Key created for the Organization associated with the User Email Id that was passed in the request
    """
    def __init__(__self__, api_key=None):
        if api_key and not isinstance(api_key, str):
            raise TypeError("Expected argument 'api_key' to be a str")
        pulumi.set(__self__, "api_key", api_key)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        The User Api Key Generated based on ReturnApiKey flag. This is applicable for non-Portal clients only.
        """
        return pulumi.get(self, "api_key")


class AwaitableGetOrganizationApiKeyResult(GetOrganizationApiKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationApiKeyResult(
            api_key=self.api_key)


def get_organization_api_key(email_id: Optional[str] = None,
                             resource_group_name: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationApiKeyResult:
    """
    The User Api Key created for the Organization associated with the User Email Id that was passed in the request


    :param str email_id: The User email Id
    :param str resource_group_name: The name of the resource group to which the Elastic resource belongs.
    """
    __args__ = dict()
    __args__['emailId'] = email_id
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:elastic/v20230201preview:getOrganizationApiKey', __args__, opts=opts, typ=GetOrganizationApiKeyResult).value

    return AwaitableGetOrganizationApiKeyResult(
        api_key=__ret__.api_key)


@_utilities.lift_output_func(get_organization_api_key)
def get_organization_api_key_output(email_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    resource_group_name: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOrganizationApiKeyResult]:
    """
    The User Api Key created for the Organization associated with the User Email Id that was passed in the request


    :param str email_id: The User email Id
    :param str resource_group_name: The name of the resource group to which the Elastic resource belongs.
    """
    ...
