# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ArmTemplateParameterPropertiesArgs',
    'ArtifactInstallPropertiesArgs',
    'ArtifactParameterPropertiesArgs',
    'AttachNewDataDiskOptionsArgs',
    'BulkCreationParametersArgs',
    'CustomImagePropertiesCustomArgs',
    'CustomImagePropertiesFromPlanArgs',
    'CustomImagePropertiesFromVmArgs',
    'DataDiskPropertiesArgs',
    'DataDiskStorageTypeInfoArgs',
    'DayDetailsArgs',
    'EnvironmentDeploymentPropertiesArgs',
    'EventArgs',
    'FormulaPropertiesFromVmArgs',
    'GalleryImageReferenceArgs',
    'HourDetailsArgs',
    'IdentityPropertiesArgs',
    'InboundNatRuleArgs',
    'LabAnnouncementPropertiesArgs',
    'LabSupportPropertiesArgs',
    'LabVirtualMachineCreationParameterArgs',
    'LinuxOsInfoArgs',
    'NetworkInterfacePropertiesArgs',
    'NotificationSettingsArgs',
    'PortArgs',
    'ScheduleCreationParameterArgs',
    'SharedPublicIpAddressConfigurationArgs',
    'SubnetOverrideArgs',
    'SubnetSharedPublicIpAddressConfigurationArgs',
    'SubnetArgs',
    'UserIdentityArgs',
    'UserSecretStoreArgs',
    'WeekDetailsArgs',
    'WindowsOsInfoArgs',
]

@pulumi.input_type
class ArmTemplateParameterPropertiesArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Properties of an Azure Resource Manager template parameter.
        :param pulumi.Input[str] name: The name of the template parameter.
        :param pulumi.Input[str] value: The value of the template parameter.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the template parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the template parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ArtifactInstallPropertiesArgs:
    def __init__(__self__, *,
                 artifact_id: Optional[pulumi.Input[str]] = None,
                 artifact_title: Optional[pulumi.Input[str]] = None,
                 deployment_status_message: Optional[pulumi.Input[str]] = None,
                 install_time: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactParameterPropertiesArgs']]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vm_extension_status_message: Optional[pulumi.Input[str]] = None):
        """
        Properties of an artifact.
        :param pulumi.Input[str] artifact_id: The artifact's identifier.
        :param pulumi.Input[str] artifact_title: The artifact's title.
        :param pulumi.Input[str] deployment_status_message: The status message from the deployment.
        :param pulumi.Input[str] install_time: The time that the artifact starts to install on the virtual machine.
        :param pulumi.Input[Sequence[pulumi.Input['ArtifactParameterPropertiesArgs']]] parameters: The parameters of the artifact.
        :param pulumi.Input[str] status: The status of the artifact.
        :param pulumi.Input[str] vm_extension_status_message: The status message from the virtual machine extension.
        """
        if artifact_id is not None:
            pulumi.set(__self__, "artifact_id", artifact_id)
        if artifact_title is not None:
            pulumi.set(__self__, "artifact_title", artifact_title)
        if deployment_status_message is not None:
            pulumi.set(__self__, "deployment_status_message", deployment_status_message)
        if install_time is not None:
            pulumi.set(__self__, "install_time", install_time)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vm_extension_status_message is not None:
            pulumi.set(__self__, "vm_extension_status_message", vm_extension_status_message)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        The artifact's identifier.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_id", value)

    @property
    @pulumi.getter(name="artifactTitle")
    def artifact_title(self) -> Optional[pulumi.Input[str]]:
        """
        The artifact's title.
        """
        return pulumi.get(self, "artifact_title")

    @artifact_title.setter
    def artifact_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_title", value)

    @property
    @pulumi.getter(name="deploymentStatusMessage")
    def deployment_status_message(self) -> Optional[pulumi.Input[str]]:
        """
        The status message from the deployment.
        """
        return pulumi.get(self, "deployment_status_message")

    @deployment_status_message.setter
    def deployment_status_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_status_message", value)

    @property
    @pulumi.getter(name="installTime")
    def install_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the artifact starts to install on the virtual machine.
        """
        return pulumi.get(self, "install_time")

    @install_time.setter
    def install_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "install_time", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactParameterPropertiesArgs']]]]:
        """
        The parameters of the artifact.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactParameterPropertiesArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the artifact.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="vmExtensionStatusMessage")
    def vm_extension_status_message(self) -> Optional[pulumi.Input[str]]:
        """
        The status message from the virtual machine extension.
        """
        return pulumi.get(self, "vm_extension_status_message")

    @vm_extension_status_message.setter
    def vm_extension_status_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_extension_status_message", value)


@pulumi.input_type
class ArtifactParameterPropertiesArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Properties of an artifact parameter.
        :param pulumi.Input[str] name: The name of the artifact parameter.
        :param pulumi.Input[str] value: The value of the artifact parameter.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the artifact parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the artifact parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class AttachNewDataDiskOptionsArgs:
    def __init__(__self__, *,
                 disk_name: Optional[pulumi.Input[str]] = None,
                 disk_size_gi_b: Optional[pulumi.Input[int]] = None,
                 disk_type: Optional[pulumi.Input[Union[str, 'StorageType']]] = None):
        """
        Properties to attach new disk to the Virtual Machine.
        :param pulumi.Input[str] disk_name: The name of the disk to be attached.
        :param pulumi.Input[int] disk_size_gi_b: Size of the disk to be attached in Gibibytes.
        :param pulumi.Input[Union[str, 'StorageType']] disk_type: The storage type for the disk (i.e. Standard, Premium).
        """
        if disk_name is not None:
            pulumi.set(__self__, "disk_name", disk_name)
        if disk_size_gi_b is not None:
            pulumi.set(__self__, "disk_size_gi_b", disk_size_gi_b)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the disk to be attached.
        """
        return pulumi.get(self, "disk_name")

    @disk_name.setter
    def disk_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_name", value)

    @property
    @pulumi.getter(name="diskSizeGiB")
    def disk_size_gi_b(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the disk to be attached in Gibibytes.
        """
        return pulumi.get(self, "disk_size_gi_b")

    @disk_size_gi_b.setter
    def disk_size_gi_b(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gi_b", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[Union[str, 'StorageType']]]:
        """
        The storage type for the disk (i.e. Standard, Premium).
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[Union[str, 'StorageType']]]):
        pulumi.set(self, "disk_type", value)


@pulumi.input_type
class BulkCreationParametersArgs:
    def __init__(__self__, *,
                 instance_count: Optional[pulumi.Input[int]] = None):
        """
        Parameters for creating multiple virtual machines as a single action.
        :param pulumi.Input[int] instance_count: The number of virtual machine instances to create.
        """
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of virtual machine instances to create.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)


@pulumi.input_type
class CustomImagePropertiesCustomArgs:
    def __init__(__self__, *,
                 os_type: pulumi.Input[Union[str, 'CustomImageOsType']],
                 image_name: Optional[pulumi.Input[str]] = None,
                 sys_prep: Optional[pulumi.Input[bool]] = None):
        """
        Properties for creating a custom image from a VHD.
        :param pulumi.Input[Union[str, 'CustomImageOsType']] os_type: The OS type of the custom image (i.e. Windows, Linux)
        :param pulumi.Input[str] image_name: The image name.
        :param pulumi.Input[bool] sys_prep: Indicates whether sysprep has been run on the VHD.
        """
        pulumi.set(__self__, "os_type", os_type)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if sys_prep is not None:
            pulumi.set(__self__, "sys_prep", sys_prep)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Input[Union[str, 'CustomImageOsType']]:
        """
        The OS type of the custom image (i.e. Windows, Linux)
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: pulumi.Input[Union[str, 'CustomImageOsType']]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[str]]:
        """
        The image name.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter(name="sysPrep")
    def sys_prep(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether sysprep has been run on the VHD.
        """
        return pulumi.get(self, "sys_prep")

    @sys_prep.setter
    def sys_prep(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sys_prep", value)


@pulumi.input_type
class CustomImagePropertiesFromPlanArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 offer: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[str]] = None):
        """
        Properties for plan on a custom image.
        :param pulumi.Input[str] id: The id of the plan, equivalent to name of the plan
        :param pulumi.Input[str] offer: The offer for the plan from the marketplace image the custom image is derived from
        :param pulumi.Input[str] publisher: The publisher for the plan from the marketplace image the custom image is derived from
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the plan, equivalent to name of the plan
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def offer(self) -> Optional[pulumi.Input[str]]:
        """
        The offer for the plan from the marketplace image the custom image is derived from
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        The publisher for the plan from the marketplace image the custom image is derived from
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)


@pulumi.input_type
class CustomImagePropertiesFromVmArgs:
    def __init__(__self__, *,
                 linux_os_info: Optional[pulumi.Input['LinuxOsInfoArgs']] = None,
                 source_vm_id: Optional[pulumi.Input[str]] = None,
                 windows_os_info: Optional[pulumi.Input['WindowsOsInfoArgs']] = None):
        """
        Properties for creating a custom image from a virtual machine.
        :param pulumi.Input['LinuxOsInfoArgs'] linux_os_info: The Linux OS information of the VM.
        :param pulumi.Input[str] source_vm_id: The source vm identifier.
        :param pulumi.Input['WindowsOsInfoArgs'] windows_os_info: The Windows OS information of the VM.
        """
        if linux_os_info is not None:
            pulumi.set(__self__, "linux_os_info", linux_os_info)
        if source_vm_id is not None:
            pulumi.set(__self__, "source_vm_id", source_vm_id)
        if windows_os_info is not None:
            pulumi.set(__self__, "windows_os_info", windows_os_info)

    @property
    @pulumi.getter(name="linuxOsInfo")
    def linux_os_info(self) -> Optional[pulumi.Input['LinuxOsInfoArgs']]:
        """
        The Linux OS information of the VM.
        """
        return pulumi.get(self, "linux_os_info")

    @linux_os_info.setter
    def linux_os_info(self, value: Optional[pulumi.Input['LinuxOsInfoArgs']]):
        pulumi.set(self, "linux_os_info", value)

    @property
    @pulumi.getter(name="sourceVmId")
    def source_vm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The source vm identifier.
        """
        return pulumi.get(self, "source_vm_id")

    @source_vm_id.setter
    def source_vm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_vm_id", value)

    @property
    @pulumi.getter(name="windowsOsInfo")
    def windows_os_info(self) -> Optional[pulumi.Input['WindowsOsInfoArgs']]:
        """
        The Windows OS information of the VM.
        """
        return pulumi.get(self, "windows_os_info")

    @windows_os_info.setter
    def windows_os_info(self, value: Optional[pulumi.Input['WindowsOsInfoArgs']]):
        pulumi.set(self, "windows_os_info", value)


@pulumi.input_type
class DataDiskPropertiesArgs:
    def __init__(__self__, *,
                 attach_new_data_disk_options: Optional[pulumi.Input['AttachNewDataDiskOptionsArgs']] = None,
                 existing_lab_disk_id: Optional[pulumi.Input[str]] = None,
                 host_caching: Optional[pulumi.Input[Union[str, 'HostCachingOptions']]] = None):
        """
        Request body for adding a new or existing data disk to a virtual machine.
        :param pulumi.Input['AttachNewDataDiskOptionsArgs'] attach_new_data_disk_options: Specifies options to attach a new disk to the virtual machine.
        :param pulumi.Input[str] existing_lab_disk_id: Specifies the existing lab disk id to attach to virtual machine.
        :param pulumi.Input[Union[str, 'HostCachingOptions']] host_caching: Caching option for a data disk (i.e. None, ReadOnly, ReadWrite).
        """
        if attach_new_data_disk_options is not None:
            pulumi.set(__self__, "attach_new_data_disk_options", attach_new_data_disk_options)
        if existing_lab_disk_id is not None:
            pulumi.set(__self__, "existing_lab_disk_id", existing_lab_disk_id)
        if host_caching is not None:
            pulumi.set(__self__, "host_caching", host_caching)

    @property
    @pulumi.getter(name="attachNewDataDiskOptions")
    def attach_new_data_disk_options(self) -> Optional[pulumi.Input['AttachNewDataDiskOptionsArgs']]:
        """
        Specifies options to attach a new disk to the virtual machine.
        """
        return pulumi.get(self, "attach_new_data_disk_options")

    @attach_new_data_disk_options.setter
    def attach_new_data_disk_options(self, value: Optional[pulumi.Input['AttachNewDataDiskOptionsArgs']]):
        pulumi.set(self, "attach_new_data_disk_options", value)

    @property
    @pulumi.getter(name="existingLabDiskId")
    def existing_lab_disk_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the existing lab disk id to attach to virtual machine.
        """
        return pulumi.get(self, "existing_lab_disk_id")

    @existing_lab_disk_id.setter
    def existing_lab_disk_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "existing_lab_disk_id", value)

    @property
    @pulumi.getter(name="hostCaching")
    def host_caching(self) -> Optional[pulumi.Input[Union[str, 'HostCachingOptions']]]:
        """
        Caching option for a data disk (i.e. None, ReadOnly, ReadWrite).
        """
        return pulumi.get(self, "host_caching")

    @host_caching.setter
    def host_caching(self, value: Optional[pulumi.Input[Union[str, 'HostCachingOptions']]]):
        pulumi.set(self, "host_caching", value)


@pulumi.input_type
class DataDiskStorageTypeInfoArgs:
    def __init__(__self__, *,
                 lun: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input[Union[str, 'StorageType']]] = None):
        """
        Storage information about the data disks present in the custom image
        :param pulumi.Input[str] lun: Disk Lun
        :param pulumi.Input[Union[str, 'StorageType']] storage_type: Disk Storage Type
        """
        if lun is not None:
            pulumi.set(__self__, "lun", lun)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter
    def lun(self) -> Optional[pulumi.Input[str]]:
        """
        Disk Lun
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lun", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[Union[str, 'StorageType']]]:
        """
        Disk Storage Type
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[Union[str, 'StorageType']]]):
        pulumi.set(self, "storage_type", value)


@pulumi.input_type
class DayDetailsArgs:
    def __init__(__self__, *,
                 time: Optional[pulumi.Input[str]] = None):
        """
        Properties of a daily schedule.
        :param pulumi.Input[str] time: The time of day the schedule will occur.
        """
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[str]]:
        """
        The time of day the schedule will occur.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time", value)


@pulumi.input_type
class EnvironmentDeploymentPropertiesArgs:
    def __init__(__self__, *,
                 arm_template_id: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ArmTemplateParameterPropertiesArgs']]]] = None):
        """
        Properties of an environment deployment.
        :param pulumi.Input[str] arm_template_id: The Azure Resource Manager template's identifier.
        :param pulumi.Input[Sequence[pulumi.Input['ArmTemplateParameterPropertiesArgs']]] parameters: The parameters of the Azure Resource Manager template.
        """
        if arm_template_id is not None:
            pulumi.set(__self__, "arm_template_id", arm_template_id)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="armTemplateId")
    def arm_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Resource Manager template's identifier.
        """
        return pulumi.get(self, "arm_template_id")

    @arm_template_id.setter
    def arm_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arm_template_id", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ArmTemplateParameterPropertiesArgs']]]]:
        """
        The parameters of the Azure Resource Manager template.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ArmTemplateParameterPropertiesArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class EventArgs:
    def __init__(__self__, *,
                 event_name: Optional[pulumi.Input[Union[str, 'NotificationChannelEventType']]] = None):
        """
        An event to be notified for.
        :param pulumi.Input[Union[str, 'NotificationChannelEventType']] event_name: The event type for which this notification is enabled (i.e. AutoShutdown, Cost)
        """
        if event_name is not None:
            pulumi.set(__self__, "event_name", event_name)

    @property
    @pulumi.getter(name="eventName")
    def event_name(self) -> Optional[pulumi.Input[Union[str, 'NotificationChannelEventType']]]:
        """
        The event type for which this notification is enabled (i.e. AutoShutdown, Cost)
        """
        return pulumi.get(self, "event_name")

    @event_name.setter
    def event_name(self, value: Optional[pulumi.Input[Union[str, 'NotificationChannelEventType']]]):
        pulumi.set(self, "event_name", value)


@pulumi.input_type
class FormulaPropertiesFromVmArgs:
    def __init__(__self__, *,
                 lab_vm_id: Optional[pulumi.Input[str]] = None):
        """
        Information about a VM from which a formula is to be created.
        :param pulumi.Input[str] lab_vm_id: The identifier of the VM from which a formula is to be created.
        """
        if lab_vm_id is not None:
            pulumi.set(__self__, "lab_vm_id", lab_vm_id)

    @property
    @pulumi.getter(name="labVmId")
    def lab_vm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the VM from which a formula is to be created.
        """
        return pulumi.get(self, "lab_vm_id")

    @lab_vm_id.setter
    def lab_vm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lab_vm_id", value)


@pulumi.input_type
class GalleryImageReferenceArgs:
    def __init__(__self__, *,
                 offer: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The reference information for an Azure Marketplace image.
        :param pulumi.Input[str] offer: The offer of the gallery image.
        :param pulumi.Input[str] os_type: The OS type of the gallery image.
        :param pulumi.Input[str] publisher: The publisher of the gallery image.
        :param pulumi.Input[str] sku: The SKU of the gallery image.
        :param pulumi.Input[str] version: The version of the gallery image.
        """
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def offer(self) -> Optional[pulumi.Input[str]]:
        """
        The offer of the gallery image.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[str]]:
        """
        The OS type of the gallery image.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        The publisher of the gallery image.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU of the gallery image.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the gallery image.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class HourDetailsArgs:
    def __init__(__self__, *,
                 minute: Optional[pulumi.Input[int]] = None):
        """
        Properties of an hourly schedule.
        :param pulumi.Input[int] minute: Minutes of the hour the schedule will run.
        """
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @property
    @pulumi.getter
    def minute(self) -> Optional[pulumi.Input[int]]:
        """
        Minutes of the hour the schedule will run.
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minute", value)


@pulumi.input_type
class IdentityPropertiesArgs:
    def __init__(__self__, *,
                 client_secret_url: Optional[pulumi.Input[str]] = None,
                 principal_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ManagedIdentityType']]] = None):
        """
        Properties of a managed identity
        :param pulumi.Input[str] client_secret_url: The client secret URL of the identity.
        :param pulumi.Input[str] principal_id: The principal id of resource identity.
        :param pulumi.Input[str] tenant_id: The tenant identifier of resource.
        :param pulumi.Input[Union[str, 'ManagedIdentityType']] type: Managed identity.
        """
        if client_secret_url is not None:
            pulumi.set(__self__, "client_secret_url", client_secret_url)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="clientSecretUrl")
    def client_secret_url(self) -> Optional[pulumi.Input[str]]:
        """
        The client secret URL of the identity.
        """
        return pulumi.get(self, "client_secret_url")

    @client_secret_url.setter
    def client_secret_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret_url", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        The principal id of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The tenant identifier of resource.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ManagedIdentityType']]]:
        """
        Managed identity.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ManagedIdentityType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class InboundNatRuleArgs:
    def __init__(__self__, *,
                 backend_port: Optional[pulumi.Input[int]] = None,
                 frontend_port: Optional[pulumi.Input[int]] = None,
                 transport_protocol: Optional[pulumi.Input[Union[str, 'TransportProtocol']]] = None):
        """
        A rule for NAT - exposing a VM's port (backendPort) on the public IP address using a load balancer.
        :param pulumi.Input[int] backend_port: The port to which the external traffic will be redirected.
        :param pulumi.Input[int] frontend_port: The external endpoint port of the inbound connection. Possible values range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically.
        :param pulumi.Input[Union[str, 'TransportProtocol']] transport_protocol: The transport protocol for the endpoint.
        """
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if frontend_port is not None:
            pulumi.set(__self__, "frontend_port", frontend_port)
        if transport_protocol is not None:
            pulumi.set(__self__, "transport_protocol", transport_protocol)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port to which the external traffic will be redirected.
        """
        return pulumi.get(self, "backend_port")

    @backend_port.setter
    def backend_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backend_port", value)

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> Optional[pulumi.Input[int]]:
        """
        The external endpoint port of the inbound connection. Possible values range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically.
        """
        return pulumi.get(self, "frontend_port")

    @frontend_port.setter
    def frontend_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "frontend_port", value)

    @property
    @pulumi.getter(name="transportProtocol")
    def transport_protocol(self) -> Optional[pulumi.Input[Union[str, 'TransportProtocol']]]:
        """
        The transport protocol for the endpoint.
        """
        return pulumi.get(self, "transport_protocol")

    @transport_protocol.setter
    def transport_protocol(self, value: Optional[pulumi.Input[Union[str, 'TransportProtocol']]]):
        pulumi.set(self, "transport_protocol", value)


@pulumi.input_type
class LabAnnouncementPropertiesArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[Union[str, 'EnableStatus']]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 expired: Optional[pulumi.Input[bool]] = None,
                 markdown: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Properties of a lab's announcement banner
        :param pulumi.Input[Union[str, 'EnableStatus']] enabled: Is the lab announcement active/enabled at this time?
        :param pulumi.Input[str] expiration_date: The time at which the announcement expires (null for never)
        :param pulumi.Input[bool] expired: Has this announcement expired?
        :param pulumi.Input[str] markdown: The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
        :param pulumi.Input[str] title: The plain text title for the lab announcement
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if expired is not None:
            pulumi.set(__self__, "expired", expired)
        if markdown is not None:
            pulumi.set(__self__, "markdown", markdown)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[Union[str, 'EnableStatus']]]:
        """
        Is the lab announcement active/enabled at this time?
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[Union[str, 'EnableStatus']]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the announcement expires (null for never)
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter
    def expired(self) -> Optional[pulumi.Input[bool]]:
        """
        Has this announcement expired?
        """
        return pulumi.get(self, "expired")

    @expired.setter
    def expired(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "expired", value)

    @property
    @pulumi.getter
    def markdown(self) -> Optional[pulumi.Input[str]]:
        """
        The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
        """
        return pulumi.get(self, "markdown")

    @markdown.setter
    def markdown(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "markdown", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The plain text title for the lab announcement
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class LabSupportPropertiesArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[Union[str, 'EnableStatus']]] = None,
                 markdown: Optional[pulumi.Input[str]] = None):
        """
        Properties of a lab's support banner
        :param pulumi.Input[Union[str, 'EnableStatus']] enabled: Is the lab support banner active/enabled at this time?
        :param pulumi.Input[str] markdown: The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if markdown is not None:
            pulumi.set(__self__, "markdown", markdown)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[Union[str, 'EnableStatus']]]:
        """
        Is the lab support banner active/enabled at this time?
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[Union[str, 'EnableStatus']]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def markdown(self) -> Optional[pulumi.Input[str]]:
        """
        The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
        """
        return pulumi.get(self, "markdown")

    @markdown.setter
    def markdown(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "markdown", value)


@pulumi.input_type
class LabVirtualMachineCreationParameterArgs:
    def __init__(__self__, *,
                 allow_claim: Optional[pulumi.Input[bool]] = None,
                 artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactInstallPropertiesArgs']]]] = None,
                 bulk_creation_parameters: Optional[pulumi.Input['BulkCreationParametersArgs']] = None,
                 created_date: Optional[pulumi.Input[str]] = None,
                 custom_image_id: Optional[pulumi.Input[str]] = None,
                 data_disk_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskPropertiesArgs']]]] = None,
                 disallow_public_ip_address: Optional[pulumi.Input[bool]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 gallery_image_reference: Optional[pulumi.Input['GalleryImageReferenceArgs']] = None,
                 is_authentication_with_ssh_key: Optional[pulumi.Input[bool]] = None,
                 lab_subnet_name: Optional[pulumi.Input[str]] = None,
                 lab_virtual_network_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interface: Optional[pulumi.Input['NetworkInterfacePropertiesArgs']] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 owner_object_id: Optional[pulumi.Input[str]] = None,
                 owner_user_principal_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 schedule_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleCreationParameterArgs']]]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 ssh_key: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Properties for creating a virtual machine.
        :param pulumi.Input[bool] allow_claim: Indicates whether another user can take ownership of the virtual machine
        :param pulumi.Input[Sequence[pulumi.Input['ArtifactInstallPropertiesArgs']]] artifacts: The artifacts to be installed on the virtual machine.
        :param pulumi.Input['BulkCreationParametersArgs'] bulk_creation_parameters: The number of virtual machine instances to create.
        :param pulumi.Input[str] created_date: The creation date of the virtual machine.
        :param pulumi.Input[str] custom_image_id: The custom image identifier of the virtual machine.
        :param pulumi.Input[Sequence[pulumi.Input['DataDiskPropertiesArgs']]] data_disk_parameters: New or existing data disks to attach to the virtual machine after creation
        :param pulumi.Input[bool] disallow_public_ip_address: Indicates whether the virtual machine is to be created without a public IP address.
        :param pulumi.Input[str] environment_id: The resource ID of the environment that contains this virtual machine, if any.
        :param pulumi.Input[str] expiration_date: The expiration date for VM.
        :param pulumi.Input['GalleryImageReferenceArgs'] gallery_image_reference: The Microsoft Azure Marketplace image reference of the virtual machine.
        :param pulumi.Input[bool] is_authentication_with_ssh_key: Indicates whether this virtual machine uses an SSH key for authentication.
        :param pulumi.Input[str] lab_subnet_name: The lab subnet name of the virtual machine.
        :param pulumi.Input[str] lab_virtual_network_id: The lab virtual network identifier of the virtual machine.
        :param pulumi.Input[str] location: The location of the new virtual machine or environment
        :param pulumi.Input[str] name: The name of the virtual machine or environment
        :param pulumi.Input['NetworkInterfacePropertiesArgs'] network_interface: The network interface properties.
        :param pulumi.Input[str] notes: The notes of the virtual machine.
        :param pulumi.Input[str] owner_object_id: The object identifier of the owner of the virtual machine.
        :param pulumi.Input[str] owner_user_principal_name: The user principal name of the virtual machine owner.
        :param pulumi.Input[str] password: The password of the virtual machine administrator.
        :param pulumi.Input[str] plan_id: The id of the plan associated with the virtual machine image
        :param pulumi.Input[Sequence[pulumi.Input['ScheduleCreationParameterArgs']]] schedule_parameters: Virtual Machine schedules to be created
        :param pulumi.Input[str] size: The size of the virtual machine.
        :param pulumi.Input[str] ssh_key: The SSH key of the virtual machine administrator.
        :param pulumi.Input[str] storage_type: Storage type to use for virtual machine (i.e. Standard, Premium).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The tags of the resource.
        :param pulumi.Input[str] user_name: The user name of the virtual machine.
        """
        if allow_claim is None:
            allow_claim = False
        if allow_claim is not None:
            pulumi.set(__self__, "allow_claim", allow_claim)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if bulk_creation_parameters is not None:
            pulumi.set(__self__, "bulk_creation_parameters", bulk_creation_parameters)
        if created_date is not None:
            pulumi.set(__self__, "created_date", created_date)
        if custom_image_id is not None:
            pulumi.set(__self__, "custom_image_id", custom_image_id)
        if data_disk_parameters is not None:
            pulumi.set(__self__, "data_disk_parameters", data_disk_parameters)
        if disallow_public_ip_address is None:
            disallow_public_ip_address = False
        if disallow_public_ip_address is not None:
            pulumi.set(__self__, "disallow_public_ip_address", disallow_public_ip_address)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if gallery_image_reference is not None:
            pulumi.set(__self__, "gallery_image_reference", gallery_image_reference)
        if is_authentication_with_ssh_key is not None:
            pulumi.set(__self__, "is_authentication_with_ssh_key", is_authentication_with_ssh_key)
        if lab_subnet_name is not None:
            pulumi.set(__self__, "lab_subnet_name", lab_subnet_name)
        if lab_virtual_network_id is not None:
            pulumi.set(__self__, "lab_virtual_network_id", lab_virtual_network_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interface is not None:
            pulumi.set(__self__, "network_interface", network_interface)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if owner_object_id is None:
            owner_object_id = 'dynamicValue'
        if owner_object_id is not None:
            pulumi.set(__self__, "owner_object_id", owner_object_id)
        if owner_user_principal_name is not None:
            pulumi.set(__self__, "owner_user_principal_name", owner_user_principal_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if schedule_parameters is not None:
            pulumi.set(__self__, "schedule_parameters", schedule_parameters)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if storage_type is None:
            storage_type = 'labStorageType'
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="allowClaim")
    def allow_claim(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether another user can take ownership of the virtual machine
        """
        return pulumi.get(self, "allow_claim")

    @allow_claim.setter
    def allow_claim(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_claim", value)

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactInstallPropertiesArgs']]]]:
        """
        The artifacts to be installed on the virtual machine.
        """
        return pulumi.get(self, "artifacts")

    @artifacts.setter
    def artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactInstallPropertiesArgs']]]]):
        pulumi.set(self, "artifacts", value)

    @property
    @pulumi.getter(name="bulkCreationParameters")
    def bulk_creation_parameters(self) -> Optional[pulumi.Input['BulkCreationParametersArgs']]:
        """
        The number of virtual machine instances to create.
        """
        return pulumi.get(self, "bulk_creation_parameters")

    @bulk_creation_parameters.setter
    def bulk_creation_parameters(self, value: Optional[pulumi.Input['BulkCreationParametersArgs']]):
        pulumi.set(self, "bulk_creation_parameters", value)

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> Optional[pulumi.Input[str]]:
        """
        The creation date of the virtual machine.
        """
        return pulumi.get(self, "created_date")

    @created_date.setter
    def created_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_date", value)

    @property
    @pulumi.getter(name="customImageId")
    def custom_image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The custom image identifier of the virtual machine.
        """
        return pulumi.get(self, "custom_image_id")

    @custom_image_id.setter
    def custom_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_image_id", value)

    @property
    @pulumi.getter(name="dataDiskParameters")
    def data_disk_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskPropertiesArgs']]]]:
        """
        New or existing data disks to attach to the virtual machine after creation
        """
        return pulumi.get(self, "data_disk_parameters")

    @data_disk_parameters.setter
    def data_disk_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskPropertiesArgs']]]]):
        pulumi.set(self, "data_disk_parameters", value)

    @property
    @pulumi.getter(name="disallowPublicIpAddress")
    def disallow_public_ip_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the virtual machine is to be created without a public IP address.
        """
        return pulumi.get(self, "disallow_public_ip_address")

    @disallow_public_ip_address.setter
    def disallow_public_ip_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disallow_public_ip_address", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the environment that contains this virtual machine, if any.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        The expiration date for VM.
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="galleryImageReference")
    def gallery_image_reference(self) -> Optional[pulumi.Input['GalleryImageReferenceArgs']]:
        """
        The Microsoft Azure Marketplace image reference of the virtual machine.
        """
        return pulumi.get(self, "gallery_image_reference")

    @gallery_image_reference.setter
    def gallery_image_reference(self, value: Optional[pulumi.Input['GalleryImageReferenceArgs']]):
        pulumi.set(self, "gallery_image_reference", value)

    @property
    @pulumi.getter(name="isAuthenticationWithSshKey")
    def is_authentication_with_ssh_key(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this virtual machine uses an SSH key for authentication.
        """
        return pulumi.get(self, "is_authentication_with_ssh_key")

    @is_authentication_with_ssh_key.setter
    def is_authentication_with_ssh_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_authentication_with_ssh_key", value)

    @property
    @pulumi.getter(name="labSubnetName")
    def lab_subnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        The lab subnet name of the virtual machine.
        """
        return pulumi.get(self, "lab_subnet_name")

    @lab_subnet_name.setter
    def lab_subnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lab_subnet_name", value)

    @property
    @pulumi.getter(name="labVirtualNetworkId")
    def lab_virtual_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The lab virtual network identifier of the virtual machine.
        """
        return pulumi.get(self, "lab_virtual_network_id")

    @lab_virtual_network_id.setter
    def lab_virtual_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lab_virtual_network_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the new virtual machine or environment
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the virtual machine or environment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkInterface")
    def network_interface(self) -> Optional[pulumi.Input['NetworkInterfacePropertiesArgs']]:
        """
        The network interface properties.
        """
        return pulumi.get(self, "network_interface")

    @network_interface.setter
    def network_interface(self, value: Optional[pulumi.Input['NetworkInterfacePropertiesArgs']]):
        pulumi.set(self, "network_interface", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[str]]:
        """
        The notes of the virtual machine.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter(name="ownerObjectId")
    def owner_object_id(self) -> Optional[pulumi.Input[str]]:
        """
        The object identifier of the owner of the virtual machine.
        """
        return pulumi.get(self, "owner_object_id")

    @owner_object_id.setter
    def owner_object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_object_id", value)

    @property
    @pulumi.getter(name="ownerUserPrincipalName")
    def owner_user_principal_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user principal name of the virtual machine owner.
        """
        return pulumi.get(self, "owner_user_principal_name")

    @owner_user_principal_name.setter
    def owner_user_principal_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_user_principal_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the virtual machine administrator.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the plan associated with the virtual machine image
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter(name="scheduleParameters")
    def schedule_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleCreationParameterArgs']]]]:
        """
        Virtual Machine schedules to be created
        """
        return pulumi.get(self, "schedule_parameters")

    @schedule_parameters.setter
    def schedule_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleCreationParameterArgs']]]]):
        pulumi.set(self, "schedule_parameters", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the virtual machine.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[pulumi.Input[str]]:
        """
        The SSH key of the virtual machine administrator.
        """
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_key", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        Storage type to use for virtual machine (i.e. Standard, Premium).
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user name of the virtual machine.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class LinuxOsInfoArgs:
    def __init__(__self__, *,
                 linux_os_state: Optional[pulumi.Input[Union[str, 'LinuxOsState']]] = None):
        """
        Information about a Linux OS.
        :param pulumi.Input[Union[str, 'LinuxOsState']] linux_os_state: The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied).
        """
        if linux_os_state is not None:
            pulumi.set(__self__, "linux_os_state", linux_os_state)

    @property
    @pulumi.getter(name="linuxOsState")
    def linux_os_state(self) -> Optional[pulumi.Input[Union[str, 'LinuxOsState']]]:
        """
        The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied).
        """
        return pulumi.get(self, "linux_os_state")

    @linux_os_state.setter
    def linux_os_state(self, value: Optional[pulumi.Input[Union[str, 'LinuxOsState']]]):
        pulumi.set(self, "linux_os_state", value)


@pulumi.input_type
class NetworkInterfacePropertiesArgs:
    def __init__(__self__, *,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 public_ip_address: Optional[pulumi.Input[str]] = None,
                 public_ip_address_id: Optional[pulumi.Input[str]] = None,
                 rdp_authority: Optional[pulumi.Input[str]] = None,
                 shared_public_ip_address_configuration: Optional[pulumi.Input['SharedPublicIpAddressConfigurationArgs']] = None,
                 ssh_authority: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 virtual_network_id: Optional[pulumi.Input[str]] = None):
        """
        Properties of a network interface.
        :param pulumi.Input[str] dns_name: The DNS name.
        :param pulumi.Input[str] private_ip_address: The private IP address.
        :param pulumi.Input[str] public_ip_address: The public IP address.
        :param pulumi.Input[str] public_ip_address_id: The resource ID of the public IP address.
        :param pulumi.Input[str] rdp_authority: The RdpAuthority property is a server DNS host name or IP address followed by the service port number for RDP (Remote Desktop Protocol).
        :param pulumi.Input['SharedPublicIpAddressConfigurationArgs'] shared_public_ip_address_configuration: The configuration for sharing a public IP address across multiple virtual machines.
        :param pulumi.Input[str] ssh_authority: The SshAuthority property is a server DNS host name or IP address followed by the service port number for SSH.
        :param pulumi.Input[str] subnet_id: The resource ID of the sub net.
        :param pulumi.Input[str] virtual_network_id: The resource ID of the virtual network.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if public_ip_address_id is not None:
            pulumi.set(__self__, "public_ip_address_id", public_ip_address_id)
        if rdp_authority is not None:
            pulumi.set(__self__, "rdp_authority", rdp_authority)
        if shared_public_ip_address_configuration is not None:
            pulumi.set(__self__, "shared_public_ip_address_configuration", shared_public_ip_address_configuration)
        if ssh_authority is not None:
            pulumi.set(__self__, "ssh_authority", ssh_authority)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private IP address.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The public IP address.
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address", value)

    @property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the public IP address.
        """
        return pulumi.get(self, "public_ip_address_id")

    @public_ip_address_id.setter
    def public_ip_address_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address_id", value)

    @property
    @pulumi.getter(name="rdpAuthority")
    def rdp_authority(self) -> Optional[pulumi.Input[str]]:
        """
        The RdpAuthority property is a server DNS host name or IP address followed by the service port number for RDP (Remote Desktop Protocol).
        """
        return pulumi.get(self, "rdp_authority")

    @rdp_authority.setter
    def rdp_authority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rdp_authority", value)

    @property
    @pulumi.getter(name="sharedPublicIpAddressConfiguration")
    def shared_public_ip_address_configuration(self) -> Optional[pulumi.Input['SharedPublicIpAddressConfigurationArgs']]:
        """
        The configuration for sharing a public IP address across multiple virtual machines.
        """
        return pulumi.get(self, "shared_public_ip_address_configuration")

    @shared_public_ip_address_configuration.setter
    def shared_public_ip_address_configuration(self, value: Optional[pulumi.Input['SharedPublicIpAddressConfigurationArgs']]):
        pulumi.set(self, "shared_public_ip_address_configuration", value)

    @property
    @pulumi.getter(name="sshAuthority")
    def ssh_authority(self) -> Optional[pulumi.Input[str]]:
        """
        The SshAuthority property is a server DNS host name or IP address followed by the service port number for SSH.
        """
        return pulumi.get(self, "ssh_authority")

    @ssh_authority.setter
    def ssh_authority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_authority", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the sub net.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the virtual network.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_network_id", value)


@pulumi.input_type
class NotificationSettingsArgs:
    def __init__(__self__, *,
                 email_recipient: Optional[pulumi.Input[str]] = None,
                 notification_locale: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'EnableStatus']]] = None,
                 time_in_minutes: Optional[pulumi.Input[int]] = None,
                 webhook_url: Optional[pulumi.Input[str]] = None):
        """
        Notification settings for a schedule.
        :param pulumi.Input[str] email_recipient: The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
        :param pulumi.Input[str] notification_locale: The locale to use when sending a notification (fallback for unsupported languages is EN).
        :param pulumi.Input[Union[str, 'EnableStatus']] status: If notifications are enabled for this schedule (i.e. Enabled, Disabled).
        :param pulumi.Input[int] time_in_minutes: Time in minutes before event at which notification will be sent.
        :param pulumi.Input[str] webhook_url: The webhook URL to which the notification will be sent.
        """
        if email_recipient is not None:
            pulumi.set(__self__, "email_recipient", email_recipient)
        if notification_locale is not None:
            pulumi.set(__self__, "notification_locale", notification_locale)
        if status is None:
            status = 'Disabled'
        if status is not None:
            pulumi.set(__self__, "status", status)
        if time_in_minutes is not None:
            pulumi.set(__self__, "time_in_minutes", time_in_minutes)
        if webhook_url is not None:
            pulumi.set(__self__, "webhook_url", webhook_url)

    @property
    @pulumi.getter(name="emailRecipient")
    def email_recipient(self) -> Optional[pulumi.Input[str]]:
        """
        The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
        """
        return pulumi.get(self, "email_recipient")

    @email_recipient.setter
    def email_recipient(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_recipient", value)

    @property
    @pulumi.getter(name="notificationLocale")
    def notification_locale(self) -> Optional[pulumi.Input[str]]:
        """
        The locale to use when sending a notification (fallback for unsupported languages is EN).
        """
        return pulumi.get(self, "notification_locale")

    @notification_locale.setter
    def notification_locale(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_locale", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'EnableStatus']]]:
        """
        If notifications are enabled for this schedule (i.e. Enabled, Disabled).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'EnableStatus']]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="timeInMinutes")
    def time_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Time in minutes before event at which notification will be sent.
        """
        return pulumi.get(self, "time_in_minutes")

    @time_in_minutes.setter
    def time_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_in_minutes", value)

    @property
    @pulumi.getter(name="webhookUrl")
    def webhook_url(self) -> Optional[pulumi.Input[str]]:
        """
        The webhook URL to which the notification will be sent.
        """
        return pulumi.get(self, "webhook_url")

    @webhook_url.setter
    def webhook_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webhook_url", value)


@pulumi.input_type
class PortArgs:
    def __init__(__self__, *,
                 backend_port: Optional[pulumi.Input[int]] = None,
                 transport_protocol: Optional[pulumi.Input[Union[str, 'TransportProtocol']]] = None):
        """
        Properties of a network port.
        :param pulumi.Input[int] backend_port: Backend port of the target virtual machine.
        :param pulumi.Input[Union[str, 'TransportProtocol']] transport_protocol: Protocol type of the port.
        """
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if transport_protocol is not None:
            pulumi.set(__self__, "transport_protocol", transport_protocol)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[pulumi.Input[int]]:
        """
        Backend port of the target virtual machine.
        """
        return pulumi.get(self, "backend_port")

    @backend_port.setter
    def backend_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backend_port", value)

    @property
    @pulumi.getter(name="transportProtocol")
    def transport_protocol(self) -> Optional[pulumi.Input[Union[str, 'TransportProtocol']]]:
        """
        Protocol type of the port.
        """
        return pulumi.get(self, "transport_protocol")

    @transport_protocol.setter
    def transport_protocol(self, value: Optional[pulumi.Input[Union[str, 'TransportProtocol']]]):
        pulumi.set(self, "transport_protocol", value)


@pulumi.input_type
class ScheduleCreationParameterArgs:
    def __init__(__self__, *,
                 daily_recurrence: Optional[pulumi.Input['DayDetailsArgs']] = None,
                 hourly_recurrence: Optional[pulumi.Input['HourDetailsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_settings: Optional[pulumi.Input['NotificationSettingsArgs']] = None,
                 status: Optional[pulumi.Input[Union[str, 'EnableStatus']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_resource_id: Optional[pulumi.Input[str]] = None,
                 task_type: Optional[pulumi.Input[str]] = None,
                 time_zone_id: Optional[pulumi.Input[str]] = None,
                 weekly_recurrence: Optional[pulumi.Input['WeekDetailsArgs']] = None):
        """
        Properties for creating a schedule.
        :param pulumi.Input['DayDetailsArgs'] daily_recurrence: If the schedule will occur once each day of the week, specify the daily recurrence.
        :param pulumi.Input['HourDetailsArgs'] hourly_recurrence: If the schedule will occur multiple times a day, specify the hourly recurrence.
        :param pulumi.Input[str] name: The name of the virtual machine or environment
        :param pulumi.Input['NotificationSettingsArgs'] notification_settings: Notification settings.
        :param pulumi.Input[Union[str, 'EnableStatus']] status: The status of the schedule (i.e. Enabled, Disabled)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The tags of the resource.
        :param pulumi.Input[str] target_resource_id: The resource ID to which the schedule belongs
        :param pulumi.Input[str] task_type: The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
        :param pulumi.Input[str] time_zone_id: The time zone ID (e.g. Pacific Standard time).
        :param pulumi.Input['WeekDetailsArgs'] weekly_recurrence: If the schedule will occur only some days of the week, specify the weekly recurrence.
        """
        if daily_recurrence is not None:
            pulumi.set(__self__, "daily_recurrence", daily_recurrence)
        if hourly_recurrence is not None:
            pulumi.set(__self__, "hourly_recurrence", hourly_recurrence)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_settings is not None:
            pulumi.set(__self__, "notification_settings", notification_settings)
        if status is None:
            status = 'Disabled'
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if task_type is not None:
            pulumi.set(__self__, "task_type", task_type)
        if time_zone_id is not None:
            pulumi.set(__self__, "time_zone_id", time_zone_id)
        if weekly_recurrence is not None:
            pulumi.set(__self__, "weekly_recurrence", weekly_recurrence)

    @property
    @pulumi.getter(name="dailyRecurrence")
    def daily_recurrence(self) -> Optional[pulumi.Input['DayDetailsArgs']]:
        """
        If the schedule will occur once each day of the week, specify the daily recurrence.
        """
        return pulumi.get(self, "daily_recurrence")

    @daily_recurrence.setter
    def daily_recurrence(self, value: Optional[pulumi.Input['DayDetailsArgs']]):
        pulumi.set(self, "daily_recurrence", value)

    @property
    @pulumi.getter(name="hourlyRecurrence")
    def hourly_recurrence(self) -> Optional[pulumi.Input['HourDetailsArgs']]:
        """
        If the schedule will occur multiple times a day, specify the hourly recurrence.
        """
        return pulumi.get(self, "hourly_recurrence")

    @hourly_recurrence.setter
    def hourly_recurrence(self, value: Optional[pulumi.Input['HourDetailsArgs']]):
        pulumi.set(self, "hourly_recurrence", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the virtual machine or environment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> Optional[pulumi.Input['NotificationSettingsArgs']]:
        """
        Notification settings.
        """
        return pulumi.get(self, "notification_settings")

    @notification_settings.setter
    def notification_settings(self, value: Optional[pulumi.Input['NotificationSettingsArgs']]):
        pulumi.set(self, "notification_settings", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'EnableStatus']]]:
        """
        The status of the schedule (i.e. Enabled, Disabled)
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'EnableStatus']]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID to which the schedule belongs
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_resource_id", value)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> Optional[pulumi.Input[str]]:
        """
        The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="timeZoneId")
    def time_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone ID (e.g. Pacific Standard time).
        """
        return pulumi.get(self, "time_zone_id")

    @time_zone_id.setter
    def time_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone_id", value)

    @property
    @pulumi.getter(name="weeklyRecurrence")
    def weekly_recurrence(self) -> Optional[pulumi.Input['WeekDetailsArgs']]:
        """
        If the schedule will occur only some days of the week, specify the weekly recurrence.
        """
        return pulumi.get(self, "weekly_recurrence")

    @weekly_recurrence.setter
    def weekly_recurrence(self, value: Optional[pulumi.Input['WeekDetailsArgs']]):
        pulumi.set(self, "weekly_recurrence", value)


@pulumi.input_type
class SharedPublicIpAddressConfigurationArgs:
    def __init__(__self__, *,
                 inbound_nat_rules: Optional[pulumi.Input[Sequence[pulumi.Input['InboundNatRuleArgs']]]] = None):
        """
        Properties of a virtual machine that determine how it is connected to a load balancer.
        :param pulumi.Input[Sequence[pulumi.Input['InboundNatRuleArgs']]] inbound_nat_rules: The incoming NAT rules
        """
        if inbound_nat_rules is not None:
            pulumi.set(__self__, "inbound_nat_rules", inbound_nat_rules)

    @property
    @pulumi.getter(name="inboundNatRules")
    def inbound_nat_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InboundNatRuleArgs']]]]:
        """
        The incoming NAT rules
        """
        return pulumi.get(self, "inbound_nat_rules")

    @inbound_nat_rules.setter
    def inbound_nat_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InboundNatRuleArgs']]]]):
        pulumi.set(self, "inbound_nat_rules", value)


@pulumi.input_type
class SubnetOverrideArgs:
    def __init__(__self__, *,
                 lab_subnet_name: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 shared_public_ip_address_configuration: Optional[pulumi.Input['SubnetSharedPublicIpAddressConfigurationArgs']] = None,
                 use_in_vm_creation_permission: Optional[pulumi.Input[Union[str, 'UsagePermissionType']]] = None,
                 use_public_ip_address_permission: Optional[pulumi.Input[Union[str, 'UsagePermissionType']]] = None,
                 virtual_network_pool_name: Optional[pulumi.Input[str]] = None):
        """
        Property overrides on a subnet of a virtual network.
        :param pulumi.Input[str] lab_subnet_name: The name given to the subnet within the lab.
        :param pulumi.Input[str] resource_id: The resource ID of the subnet.
        :param pulumi.Input['SubnetSharedPublicIpAddressConfigurationArgs'] shared_public_ip_address_configuration: Properties that virtual machines on this subnet will share.
        :param pulumi.Input[Union[str, 'UsagePermissionType']] use_in_vm_creation_permission: Indicates whether this subnet can be used during virtual machine creation (i.e. Allow, Deny).
        :param pulumi.Input[Union[str, 'UsagePermissionType']] use_public_ip_address_permission: Indicates whether public IP addresses can be assigned to virtual machines on this subnet (i.e. Allow, Deny).
        :param pulumi.Input[str] virtual_network_pool_name: The virtual network pool associated with this subnet.
        """
        if lab_subnet_name is not None:
            pulumi.set(__self__, "lab_subnet_name", lab_subnet_name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if shared_public_ip_address_configuration is not None:
            pulumi.set(__self__, "shared_public_ip_address_configuration", shared_public_ip_address_configuration)
        if use_in_vm_creation_permission is not None:
            pulumi.set(__self__, "use_in_vm_creation_permission", use_in_vm_creation_permission)
        if use_public_ip_address_permission is not None:
            pulumi.set(__self__, "use_public_ip_address_permission", use_public_ip_address_permission)
        if virtual_network_pool_name is not None:
            pulumi.set(__self__, "virtual_network_pool_name", virtual_network_pool_name)

    @property
    @pulumi.getter(name="labSubnetName")
    def lab_subnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name given to the subnet within the lab.
        """
        return pulumi.get(self, "lab_subnet_name")

    @lab_subnet_name.setter
    def lab_subnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lab_subnet_name", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the subnet.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="sharedPublicIpAddressConfiguration")
    def shared_public_ip_address_configuration(self) -> Optional[pulumi.Input['SubnetSharedPublicIpAddressConfigurationArgs']]:
        """
        Properties that virtual machines on this subnet will share.
        """
        return pulumi.get(self, "shared_public_ip_address_configuration")

    @shared_public_ip_address_configuration.setter
    def shared_public_ip_address_configuration(self, value: Optional[pulumi.Input['SubnetSharedPublicIpAddressConfigurationArgs']]):
        pulumi.set(self, "shared_public_ip_address_configuration", value)

    @property
    @pulumi.getter(name="useInVmCreationPermission")
    def use_in_vm_creation_permission(self) -> Optional[pulumi.Input[Union[str, 'UsagePermissionType']]]:
        """
        Indicates whether this subnet can be used during virtual machine creation (i.e. Allow, Deny).
        """
        return pulumi.get(self, "use_in_vm_creation_permission")

    @use_in_vm_creation_permission.setter
    def use_in_vm_creation_permission(self, value: Optional[pulumi.Input[Union[str, 'UsagePermissionType']]]):
        pulumi.set(self, "use_in_vm_creation_permission", value)

    @property
    @pulumi.getter(name="usePublicIpAddressPermission")
    def use_public_ip_address_permission(self) -> Optional[pulumi.Input[Union[str, 'UsagePermissionType']]]:
        """
        Indicates whether public IP addresses can be assigned to virtual machines on this subnet (i.e. Allow, Deny).
        """
        return pulumi.get(self, "use_public_ip_address_permission")

    @use_public_ip_address_permission.setter
    def use_public_ip_address_permission(self, value: Optional[pulumi.Input[Union[str, 'UsagePermissionType']]]):
        pulumi.set(self, "use_public_ip_address_permission", value)

    @property
    @pulumi.getter(name="virtualNetworkPoolName")
    def virtual_network_pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual network pool associated with this subnet.
        """
        return pulumi.get(self, "virtual_network_pool_name")

    @virtual_network_pool_name.setter
    def virtual_network_pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_network_pool_name", value)


@pulumi.input_type
class SubnetSharedPublicIpAddressConfigurationArgs:
    def __init__(__self__, *,
                 allowed_ports: Optional[pulumi.Input[Sequence[pulumi.Input['PortArgs']]]] = None):
        """
        Configuration for public IP address sharing.
        :param pulumi.Input[Sequence[pulumi.Input['PortArgs']]] allowed_ports: Backend ports that virtual machines on this subnet are allowed to expose
        """
        if allowed_ports is not None:
            pulumi.set(__self__, "allowed_ports", allowed_ports)

    @property
    @pulumi.getter(name="allowedPorts")
    def allowed_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PortArgs']]]]:
        """
        Backend ports that virtual machines on this subnet are allowed to expose
        """
        return pulumi.get(self, "allowed_ports")

    @allowed_ports.setter
    def allowed_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PortArgs']]]]):
        pulumi.set(self, "allowed_ports", value)


@pulumi.input_type
class SubnetArgs:
    def __init__(__self__, *,
                 allow_public_ip: Optional[pulumi.Input[Union[str, 'UsagePermissionType']]] = None,
                 lab_subnet_name: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Subnet information.
        :param pulumi.Input[Union[str, 'UsagePermissionType']] allow_public_ip: The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)).
        :param pulumi.Input[str] lab_subnet_name: The name of the subnet as seen in the lab.
        :param pulumi.Input[str] resource_id: The resource ID of the subnet.
        """
        if allow_public_ip is not None:
            pulumi.set(__self__, "allow_public_ip", allow_public_ip)
        if lab_subnet_name is not None:
            pulumi.set(__self__, "lab_subnet_name", lab_subnet_name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="allowPublicIp")
    def allow_public_ip(self) -> Optional[pulumi.Input[Union[str, 'UsagePermissionType']]]:
        """
        The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)).
        """
        return pulumi.get(self, "allow_public_ip")

    @allow_public_ip.setter
    def allow_public_ip(self, value: Optional[pulumi.Input[Union[str, 'UsagePermissionType']]]):
        pulumi.set(self, "allow_public_ip", value)

    @property
    @pulumi.getter(name="labSubnetName")
    def lab_subnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the subnet as seen in the lab.
        """
        return pulumi.get(self, "lab_subnet_name")

    @lab_subnet_name.setter
    def lab_subnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lab_subnet_name", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the subnet.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class UserIdentityArgs:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None,
                 principal_id: Optional[pulumi.Input[str]] = None,
                 principal_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Identity attributes of a lab user.
        :param pulumi.Input[str] app_id: Set to the app Id of the client JWT making the request.
        :param pulumi.Input[str] object_id: Set to the object Id of the client JWT making the request. Not all users have object Id. For CSP (reseller) scenarios for example, object Id is not available.
        :param pulumi.Input[str] principal_id: Set to the principal Id of the client JWT making the request. Service principal will not have the principal Id.
        :param pulumi.Input[str] principal_name: Set to the principal name / UPN of the client JWT making the request.
        :param pulumi.Input[str] tenant_id: Set to the tenant ID of the client JWT making the request.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if principal_name is not None:
            pulumi.set(__self__, "principal_name", principal_name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        Set to the app Id of the client JWT making the request.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        Set to the object Id of the client JWT making the request. Not all users have object Id. For CSP (reseller) scenarios for example, object Id is not available.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        Set to the principal Id of the client JWT making the request. Service principal will not have the principal Id.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="principalName")
    def principal_name(self) -> Optional[pulumi.Input[str]]:
        """
        Set to the principal name / UPN of the client JWT making the request.
        """
        return pulumi.get(self, "principal_name")

    @principal_name.setter
    def principal_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Set to the tenant ID of the client JWT making the request.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class UserSecretStoreArgs:
    def __init__(__self__, *,
                 key_vault_id: Optional[pulumi.Input[str]] = None,
                 key_vault_uri: Optional[pulumi.Input[str]] = None):
        """
        Properties of a user's secret store.
        :param pulumi.Input[str] key_vault_id: The ID of the user's Key vault.
        :param pulumi.Input[str] key_vault_uri: The URI of the user's Key vault.
        """
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if key_vault_uri is not None:
            pulumi.set(__self__, "key_vault_uri", key_vault_uri)

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the user's Key vault.
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_id", value)

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the user's Key vault.
        """
        return pulumi.get(self, "key_vault_uri")

    @key_vault_uri.setter
    def key_vault_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_uri", value)


@pulumi.input_type
class WeekDetailsArgs:
    def __init__(__self__, *,
                 time: Optional[pulumi.Input[str]] = None,
                 weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Properties of a weekly schedule.
        :param pulumi.Input[str] time: The time of the day the schedule will occur.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] weekdays: The days of the week for which the schedule is set (e.g. Sunday, Monday, Tuesday, etc.).
        """
        if time is not None:
            pulumi.set(__self__, "time", time)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)

    @property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[str]]:
        """
        The time of the day the schedule will occur.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time", value)

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The days of the week for which the schedule is set (e.g. Sunday, Monday, Tuesday, etc.).
        """
        return pulumi.get(self, "weekdays")

    @weekdays.setter
    def weekdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "weekdays", value)


@pulumi.input_type
class WindowsOsInfoArgs:
    def __init__(__self__, *,
                 windows_os_state: Optional[pulumi.Input[Union[str, 'WindowsOsState']]] = None):
        """
        Information about a Windows OS.
        :param pulumi.Input[Union[str, 'WindowsOsState']] windows_os_state: The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied).
        """
        if windows_os_state is not None:
            pulumi.set(__self__, "windows_os_state", windows_os_state)

    @property
    @pulumi.getter(name="windowsOsState")
    def windows_os_state(self) -> Optional[pulumi.Input[Union[str, 'WindowsOsState']]]:
        """
        The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied).
        """
        return pulumi.get(self, "windows_os_state")

    @windows_os_state.setter
    def windows_os_state(self, value: Optional[pulumi.Input[Union[str, 'WindowsOsState']]]):
        pulumi.set(self, "windows_os_state", value)


