# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DBServerMetadataResponse',
    'MigrationStatusResponse',
    'MigrationSubStateDetailsResponse',
    'ServerSkuResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class DBServerMetadataResponse(dict):
    """
    Database server metadata.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageMB":
            suggest = "storage_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DBServerMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DBServerMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DBServerMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: Optional[str] = None,
                 sku: Optional['outputs.ServerSkuResponse'] = None,
                 storage_mb: Optional[int] = None,
                 version: Optional[str] = None):
        """
        Database server metadata.
        :param 'ServerSkuResponse' sku: Sku information related properties of a server.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if storage_mb is not None:
            pulumi.set(__self__, "storage_mb", storage_mb)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.ServerSkuResponse']:
        """
        Sku information related properties of a server.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="storageMB")
    def storage_mb(self) -> Optional[int]:
        return pulumi.get(self, "storage_mb")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class MigrationStatusResponse(dict):
    """
    Migration status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentSubStateDetails":
            suggest = "current_sub_state_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_sub_state_details: 'outputs.MigrationSubStateDetailsResponse',
                 error: str,
                 state: str):
        """
        Migration status.
        :param 'MigrationSubStateDetailsResponse' current_sub_state_details: Migration sub state details.
        :param str state: Migration state.
        """
        pulumi.set(__self__, "current_sub_state_details", current_sub_state_details)
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="currentSubStateDetails")
    def current_sub_state_details(self) -> 'outputs.MigrationSubStateDetailsResponse':
        """
        Migration sub state details.
        """
        return pulumi.get(self, "current_sub_state_details")

    @property
    @pulumi.getter
    def error(self) -> str:
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Migration state.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MigrationSubStateDetailsResponse(dict):
    """
    Migration sub state details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentSubState":
            suggest = "current_sub_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationSubStateDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationSubStateDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationSubStateDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_sub_state: str):
        """
        Migration sub state details.
        :param str current_sub_state: Migration sub state.
        """
        pulumi.set(__self__, "current_sub_state", current_sub_state)

    @property
    @pulumi.getter(name="currentSubState")
    def current_sub_state(self) -> str:
        """
        Migration sub state.
        """
        return pulumi.get(self, "current_sub_state")


@pulumi.output_type
class ServerSkuResponse(dict):
    """
    Sku information related properties of a server.
    """
    def __init__(__self__, *,
                 name: str,
                 tier: str):
        """
        Sku information related properties of a server.
        :param str name: The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
        :param str tier: The tier of the particular SKU, e.g. Burstable.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The tier of the particular SKU, e.g. Burstable.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


