# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetPredictionModelStatusResult',
    'AwaitableGetPredictionModelStatusResult',
    'get_prediction_model_status',
    'get_prediction_model_status_output',
]

@pulumi.output_type
class GetPredictionModelStatusResult:
    """
    The prediction model status.
    """
    def __init__(__self__, message=None, model_version=None, prediction_guid_id=None, prediction_name=None, signals_used=None, status=None, tenant_id=None, test_set_count=None, training_accuracy=None, training_set_count=None, validation_set_count=None):
        if message and not isinstance(message, str):
            raise TypeError("Expected argument 'message' to be a str")
        pulumi.set(__self__, "message", message)
        if model_version and not isinstance(model_version, str):
            raise TypeError("Expected argument 'model_version' to be a str")
        pulumi.set(__self__, "model_version", model_version)
        if prediction_guid_id and not isinstance(prediction_guid_id, str):
            raise TypeError("Expected argument 'prediction_guid_id' to be a str")
        pulumi.set(__self__, "prediction_guid_id", prediction_guid_id)
        if prediction_name and not isinstance(prediction_name, str):
            raise TypeError("Expected argument 'prediction_name' to be a str")
        pulumi.set(__self__, "prediction_name", prediction_name)
        if signals_used and not isinstance(signals_used, int):
            raise TypeError("Expected argument 'signals_used' to be a int")
        pulumi.set(__self__, "signals_used", signals_used)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if test_set_count and not isinstance(test_set_count, int):
            raise TypeError("Expected argument 'test_set_count' to be a int")
        pulumi.set(__self__, "test_set_count", test_set_count)
        if training_accuracy and not isinstance(training_accuracy, int):
            raise TypeError("Expected argument 'training_accuracy' to be a int")
        pulumi.set(__self__, "training_accuracy", training_accuracy)
        if training_set_count and not isinstance(training_set_count, int):
            raise TypeError("Expected argument 'training_set_count' to be a int")
        pulumi.set(__self__, "training_set_count", training_set_count)
        if validation_set_count and not isinstance(validation_set_count, int):
            raise TypeError("Expected argument 'validation_set_count' to be a int")
        pulumi.set(__self__, "validation_set_count", validation_set_count)

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The model status message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> str:
        """
        Version of the model.
        """
        return pulumi.get(self, "model_version")

    @property
    @pulumi.getter(name="predictionGuidId")
    def prediction_guid_id(self) -> str:
        """
        The prediction GUID ID.
        """
        return pulumi.get(self, "prediction_guid_id")

    @property
    @pulumi.getter(name="predictionName")
    def prediction_name(self) -> str:
        """
        The prediction name.
        """
        return pulumi.get(self, "prediction_name")

    @property
    @pulumi.getter(name="signalsUsed")
    def signals_used(self) -> int:
        """
        The signals used.
        """
        return pulumi.get(self, "signals_used")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Prediction model life cycle.  When prediction is in PendingModelConfirmation status, it is allowed to update the status to PendingFeaturing or Active through API.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The hub name.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="testSetCount")
    def test_set_count(self) -> int:
        """
        Count of the test set.
        """
        return pulumi.get(self, "test_set_count")

    @property
    @pulumi.getter(name="trainingAccuracy")
    def training_accuracy(self) -> int:
        """
        The training accuracy.
        """
        return pulumi.get(self, "training_accuracy")

    @property
    @pulumi.getter(name="trainingSetCount")
    def training_set_count(self) -> int:
        """
        Count of the training set.
        """
        return pulumi.get(self, "training_set_count")

    @property
    @pulumi.getter(name="validationSetCount")
    def validation_set_count(self) -> int:
        """
        Count of the validation set.
        """
        return pulumi.get(self, "validation_set_count")


class AwaitableGetPredictionModelStatusResult(GetPredictionModelStatusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPredictionModelStatusResult(
            message=self.message,
            model_version=self.model_version,
            prediction_guid_id=self.prediction_guid_id,
            prediction_name=self.prediction_name,
            signals_used=self.signals_used,
            status=self.status,
            tenant_id=self.tenant_id,
            test_set_count=self.test_set_count,
            training_accuracy=self.training_accuracy,
            training_set_count=self.training_set_count,
            validation_set_count=self.validation_set_count)


def get_prediction_model_status(hub_name: Optional[str] = None,
                                prediction_name: Optional[str] = None,
                                resource_group_name: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPredictionModelStatusResult:
    """
    Gets model status of the prediction.


    :param str hub_name: The name of the hub.
    :param str prediction_name: The name of the Prediction.
    :param str resource_group_name: The name of the resource group.
    """
    __args__ = dict()
    __args__['hubName'] = hub_name
    __args__['predictionName'] = prediction_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:customerinsights/v20170426:getPredictionModelStatus', __args__, opts=opts, typ=GetPredictionModelStatusResult).value

    return AwaitableGetPredictionModelStatusResult(
        message=__ret__.message,
        model_version=__ret__.model_version,
        prediction_guid_id=__ret__.prediction_guid_id,
        prediction_name=__ret__.prediction_name,
        signals_used=__ret__.signals_used,
        status=__ret__.status,
        tenant_id=__ret__.tenant_id,
        test_set_count=__ret__.test_set_count,
        training_accuracy=__ret__.training_accuracy,
        training_set_count=__ret__.training_set_count,
        validation_set_count=__ret__.validation_set_count)


@_utilities.lift_output_func(get_prediction_model_status)
def get_prediction_model_status_output(hub_name: Optional[pulumi.Input[str]] = None,
                                       prediction_name: Optional[pulumi.Input[str]] = None,
                                       resource_group_name: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPredictionModelStatusResult]:
    """
    Gets model status of the prediction.


    :param str hub_name: The name of the hub.
    :param str prediction_name: The name of the Prediction.
    :param str resource_group_name: The name of the resource group.
    """
    ...
