# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetMarkupRuleResult',
    'AwaitableGetMarkupRuleResult',
    'get_markup_rule',
    'get_markup_rule_output',
]

@pulumi.output_type
class GetMarkupRuleResult:
    """
    Markup rule
    """
    def __init__(__self__, customer_details=None, description=None, e_tag=None, end_date=None, id=None, name=None, percentage=None, start_date=None, type=None):
        if customer_details and not isinstance(customer_details, dict):
            raise TypeError("Expected argument 'customer_details' to be a dict")
        pulumi.set(__self__, "customer_details", customer_details)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if e_tag and not isinstance(e_tag, str):
            raise TypeError("Expected argument 'e_tag' to be a str")
        pulumi.set(__self__, "e_tag", e_tag)
        if end_date and not isinstance(end_date, str):
            raise TypeError("Expected argument 'end_date' to be a str")
        pulumi.set(__self__, "end_date", end_date)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if percentage and not isinstance(percentage, float):
            raise TypeError("Expected argument 'percentage' to be a float")
        pulumi.set(__self__, "percentage", percentage)
        if start_date and not isinstance(start_date, str):
            raise TypeError("Expected argument 'start_date' to be a str")
        pulumi.set(__self__, "start_date", start_date)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="customerDetails")
    def customer_details(self) -> 'outputs.CustomerMetadataResponse':
        """
        Customer information for the markup rule.
        """
        return pulumi.get(self, "customer_details")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the markup rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> Optional[str]:
        """
        eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
        """
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[str]:
        """
        Ending date of the markup rule.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def percentage(self) -> float:
        """
        The markup percentage of the rule.
        """
        return pulumi.get(self, "percentage")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        """
        Starting date of the markup rule.
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")


class AwaitableGetMarkupRuleResult(GetMarkupRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMarkupRuleResult(
            customer_details=self.customer_details,
            description=self.description,
            e_tag=self.e_tag,
            end_date=self.end_date,
            id=self.id,
            name=self.name,
            percentage=self.percentage,
            start_date=self.start_date,
            type=self.type)


def get_markup_rule(billing_account_id: Optional[str] = None,
                    billing_profile_id: Optional[str] = None,
                    name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMarkupRuleResult:
    """
    Get a markup rule by its rule name.


    :param str billing_account_id: BillingAccount ID
    :param str billing_profile_id: BillingProfile ID
    :param str name: Markup rule name.
    """
    __args__ = dict()
    __args__['billingAccountId'] = billing_account_id
    __args__['billingProfileId'] = billing_profile_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:costmanagement/v20221005preview:getMarkupRule', __args__, opts=opts, typ=GetMarkupRuleResult).value

    return AwaitableGetMarkupRuleResult(
        customer_details=__ret__.customer_details,
        description=__ret__.description,
        e_tag=__ret__.e_tag,
        end_date=__ret__.end_date,
        id=__ret__.id,
        name=__ret__.name,
        percentage=__ret__.percentage,
        start_date=__ret__.start_date,
        type=__ret__.type)


@_utilities.lift_output_func(get_markup_rule)
def get_markup_rule_output(billing_account_id: Optional[pulumi.Input[str]] = None,
                           billing_profile_id: Optional[pulumi.Input[str]] = None,
                           name: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMarkupRuleResult]:
    """
    Get a markup rule by its rule name.


    :param str billing_account_id: BillingAccount ID
    :param str billing_profile_id: BillingProfile ID
    :param str name: Markup rule name.
    """
    ...
