# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AGReplicasArgs',
    'ActiveDirectoryConnectorDNSDetailsArgs',
    'ActiveDirectoryConnectorDomainDetailsArgs',
    'ActiveDirectoryConnectorPropertiesArgs',
    'ActiveDirectoryConnectorSpecArgs',
    'ActiveDirectoryConnectorStatusArgs',
    'ActiveDirectoryDomainControllersArgs',
    'ActiveDirectoryDomainControllerArgs',
    'ActiveDirectoryInformationArgs',
    'AvailabilityGroupConfigureArgs',
    'AvailabilityGroupStateArgs',
    'BasicLoginInformationArgs',
    'DataControllerPropertiesArgs',
    'ExtendedLocationArgs',
    'FailoverGroupPropertiesArgs',
    'FailoverGroupSpecArgs',
    'FailoverGroupStatusArgs',
    'K8sResourceRequirementsArgs',
    'K8sSchedulingOptionsArgs',
    'K8sSchedulingArgs',
    'KeytabInformationArgs',
    'LogAnalyticsWorkspaceConfigArgs',
    'OnPremisePropertyArgs',
    'PostgresInstancePropertiesArgs',
    'PostgresInstanceSkuArgs',
    'SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs',
    'SqlAvailabilityGroupMultiDatabaseReplicaResourcePropertiesArgs',
    'SqlAvailabilityGroupPropertiesArgs',
    'SqlAvailabilityGroupReplicaResourcePropertiesArgs',
    'SqlManagedInstanceK8sRawArgs',
    'SqlManagedInstanceK8sSpecArgs',
    'SqlManagedInstancePropertiesArgs',
    'SqlManagedInstanceSkuArgs',
    'SqlServerAvailabilityGroupResourcePropertiesArgs',
    'SqlServerDatabaseResourcePropertiesBackupInformationArgs',
    'SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs',
    'SqlServerDatabaseResourcePropertiesArgs',
    'SqlServerInstancePropertiesArgs',
    'UploadServicePrincipalArgs',
    'UploadWatermarkArgs',
]

@pulumi.input_type
class AGReplicasArgs:
    def __init__(__self__, *,
                 availability_mode: Optional[pulumi.Input[str]] = None,
                 connected_state: Optional[pulumi.Input[str]] = None,
                 health_state: Optional[pulumi.Input[str]] = None,
                 replica_name: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 secondary_role_allow_connections: Optional[pulumi.Input[str]] = None,
                 synchronization_state: Optional[pulumi.Input[str]] = None):
        """
        The information about each failover group replica.
        :param pulumi.Input[str] availability_mode: The availability mode of the replica.
        :param pulumi.Input[str] connected_state: The connected state of the replica.
        :param pulumi.Input[str] health_state: The health state of the replica.
        :param pulumi.Input[str] replica_name: The replica name.
        :param pulumi.Input[str] role: The role of the replica.
        :param pulumi.Input[str] secondary_role_allow_connections: The secondary role allowed connections.
        :param pulumi.Input[str] synchronization_state: The synchronization state of the availability group replicas.
        """
        if availability_mode is not None:
            pulumi.set(__self__, "availability_mode", availability_mode)
        if connected_state is not None:
            pulumi.set(__self__, "connected_state", connected_state)
        if health_state is not None:
            pulumi.set(__self__, "health_state", health_state)
        if replica_name is not None:
            pulumi.set(__self__, "replica_name", replica_name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if secondary_role_allow_connections is not None:
            pulumi.set(__self__, "secondary_role_allow_connections", secondary_role_allow_connections)
        if synchronization_state is not None:
            pulumi.set(__self__, "synchronization_state", synchronization_state)

    @property
    @pulumi.getter(name="availabilityMode")
    def availability_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The availability mode of the replica.
        """
        return pulumi.get(self, "availability_mode")

    @availability_mode.setter
    def availability_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_mode", value)

    @property
    @pulumi.getter(name="connectedState")
    def connected_state(self) -> Optional[pulumi.Input[str]]:
        """
        The connected state of the replica.
        """
        return pulumi.get(self, "connected_state")

    @connected_state.setter
    def connected_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connected_state", value)

    @property
    @pulumi.getter(name="healthState")
    def health_state(self) -> Optional[pulumi.Input[str]]:
        """
        The health state of the replica.
        """
        return pulumi.get(self, "health_state")

    @health_state.setter
    def health_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_state", value)

    @property
    @pulumi.getter(name="replicaName")
    def replica_name(self) -> Optional[pulumi.Input[str]]:
        """
        The replica name.
        """
        return pulumi.get(self, "replica_name")

    @replica_name.setter
    def replica_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_name", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The role of the replica.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="secondaryRoleAllowConnections")
    def secondary_role_allow_connections(self) -> Optional[pulumi.Input[str]]:
        """
        The secondary role allowed connections.
        """
        return pulumi.get(self, "secondary_role_allow_connections")

    @secondary_role_allow_connections.setter
    def secondary_role_allow_connections(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_role_allow_connections", value)

    @property
    @pulumi.getter(name="synchronizationState")
    def synchronization_state(self) -> Optional[pulumi.Input[str]]:
        """
        The synchronization state of the availability group replicas.
        """
        return pulumi.get(self, "synchronization_state")

    @synchronization_state.setter
    def synchronization_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "synchronization_state", value)


@pulumi.input_type
class ActiveDirectoryConnectorDNSDetailsArgs:
    def __init__(__self__, *,
                 nameserver_ip_addresses: pulumi.Input[Sequence[pulumi.Input[str]]],
                 domain_name: Optional[pulumi.Input[str]] = None,
                 prefer_k8s_dns_for_ptr_lookups: Optional[pulumi.Input[bool]] = None,
                 replicas: Optional[pulumi.Input[float]] = None):
        """
        DNS server details
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nameserver_ip_addresses: List of Active Directory DNS server IP addresses.
        :param pulumi.Input[str] domain_name: DNS domain name for which DNS lookups should be forwarded to the Active Directory DNS servers.
        :param pulumi.Input[bool] prefer_k8s_dns_for_ptr_lookups: Flag indicating whether to prefer Kubernetes DNS server response over AD DNS server response for IP address lookups.
        :param pulumi.Input[float] replicas: Replica count for DNS proxy service. Default value is 1.
        """
        pulumi.set(__self__, "nameserver_ip_addresses", nameserver_ip_addresses)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if prefer_k8s_dns_for_ptr_lookups is None:
            prefer_k8s_dns_for_ptr_lookups = True
        if prefer_k8s_dns_for_ptr_lookups is not None:
            pulumi.set(__self__, "prefer_k8s_dns_for_ptr_lookups", prefer_k8s_dns_for_ptr_lookups)
        if replicas is None:
            replicas = 1
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)

    @property
    @pulumi.getter(name="nameserverIPAddresses")
    def nameserver_ip_addresses(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of Active Directory DNS server IP addresses.
        """
        return pulumi.get(self, "nameserver_ip_addresses")

    @nameserver_ip_addresses.setter
    def nameserver_ip_addresses(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "nameserver_ip_addresses", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        DNS domain name for which DNS lookups should be forwarded to the Active Directory DNS servers.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="preferK8sDnsForPtrLookups")
    def prefer_k8s_dns_for_ptr_lookups(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag indicating whether to prefer Kubernetes DNS server response over AD DNS server response for IP address lookups.
        """
        return pulumi.get(self, "prefer_k8s_dns_for_ptr_lookups")

    @prefer_k8s_dns_for_ptr_lookups.setter
    def prefer_k8s_dns_for_ptr_lookups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prefer_k8s_dns_for_ptr_lookups", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[float]]:
        """
        Replica count for DNS proxy service. Default value is 1.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "replicas", value)


@pulumi.input_type
class ActiveDirectoryConnectorDomainDetailsArgs:
    def __init__(__self__, *,
                 realm: pulumi.Input[str],
                 domain_controllers: Optional[pulumi.Input['ActiveDirectoryDomainControllersArgs']] = None,
                 netbios_domain_name: Optional[pulumi.Input[str]] = None,
                 ou_distinguished_name: Optional[pulumi.Input[str]] = None,
                 service_account_provisioning: Optional[pulumi.Input[Union[str, 'AccountProvisioningMode']]] = None):
        """
        Active Directory domain details
        :param pulumi.Input[str] realm: Name (uppercase) of the Active Directory domain that this AD connector will be associated with.
        :param pulumi.Input['ActiveDirectoryDomainControllersArgs'] domain_controllers: null
        :param pulumi.Input[str] netbios_domain_name: NETBIOS name of the Active Directory domain.
        :param pulumi.Input[str] ou_distinguished_name: The distinguished name of the Active Directory Organizational Unit.
        :param pulumi.Input[Union[str, 'AccountProvisioningMode']] service_account_provisioning: The service account provisioning mode for this Active Directory connector.
        """
        pulumi.set(__self__, "realm", realm)
        if domain_controllers is not None:
            pulumi.set(__self__, "domain_controllers", domain_controllers)
        if netbios_domain_name is not None:
            pulumi.set(__self__, "netbios_domain_name", netbios_domain_name)
        if ou_distinguished_name is not None:
            pulumi.set(__self__, "ou_distinguished_name", ou_distinguished_name)
        if service_account_provisioning is None:
            service_account_provisioning = 'manual'
        if service_account_provisioning is not None:
            pulumi.set(__self__, "service_account_provisioning", service_account_provisioning)

    @property
    @pulumi.getter
    def realm(self) -> pulumi.Input[str]:
        """
        Name (uppercase) of the Active Directory domain that this AD connector will be associated with.
        """
        return pulumi.get(self, "realm")

    @realm.setter
    def realm(self, value: pulumi.Input[str]):
        pulumi.set(self, "realm", value)

    @property
    @pulumi.getter(name="domainControllers")
    def domain_controllers(self) -> Optional[pulumi.Input['ActiveDirectoryDomainControllersArgs']]:
        """
        null
        """
        return pulumi.get(self, "domain_controllers")

    @domain_controllers.setter
    def domain_controllers(self, value: Optional[pulumi.Input['ActiveDirectoryDomainControllersArgs']]):
        pulumi.set(self, "domain_controllers", value)

    @property
    @pulumi.getter(name="netbiosDomainName")
    def netbios_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        NETBIOS name of the Active Directory domain.
        """
        return pulumi.get(self, "netbios_domain_name")

    @netbios_domain_name.setter
    def netbios_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netbios_domain_name", value)

    @property
    @pulumi.getter(name="ouDistinguishedName")
    def ou_distinguished_name(self) -> Optional[pulumi.Input[str]]:
        """
        The distinguished name of the Active Directory Organizational Unit.
        """
        return pulumi.get(self, "ou_distinguished_name")

    @ou_distinguished_name.setter
    def ou_distinguished_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ou_distinguished_name", value)

    @property
    @pulumi.getter(name="serviceAccountProvisioning")
    def service_account_provisioning(self) -> Optional[pulumi.Input[Union[str, 'AccountProvisioningMode']]]:
        """
        The service account provisioning mode for this Active Directory connector.
        """
        return pulumi.get(self, "service_account_provisioning")

    @service_account_provisioning.setter
    def service_account_provisioning(self, value: Optional[pulumi.Input[Union[str, 'AccountProvisioningMode']]]):
        pulumi.set(self, "service_account_provisioning", value)


@pulumi.input_type
class ActiveDirectoryConnectorPropertiesArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['ActiveDirectoryConnectorSpecArgs'],
                 domain_service_account_login_information: Optional[pulumi.Input['BasicLoginInformationArgs']] = None,
                 status: Optional[pulumi.Input['ActiveDirectoryConnectorStatusArgs']] = None):
        """
        The properties of an Active Directory connector resource
        :param pulumi.Input['ActiveDirectoryConnectorSpecArgs'] spec: null
        :param pulumi.Input['BasicLoginInformationArgs'] domain_service_account_login_information: Username and password for domain service account authentication.
        :param pulumi.Input['ActiveDirectoryConnectorStatusArgs'] status: null
        """
        pulumi.set(__self__, "spec", spec)
        if domain_service_account_login_information is not None:
            pulumi.set(__self__, "domain_service_account_login_information", domain_service_account_login_information)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['ActiveDirectoryConnectorSpecArgs']:
        """
        null
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['ActiveDirectoryConnectorSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="domainServiceAccountLoginInformation")
    def domain_service_account_login_information(self) -> Optional[pulumi.Input['BasicLoginInformationArgs']]:
        """
        Username and password for domain service account authentication.
        """
        return pulumi.get(self, "domain_service_account_login_information")

    @domain_service_account_login_information.setter
    def domain_service_account_login_information(self, value: Optional[pulumi.Input['BasicLoginInformationArgs']]):
        pulumi.set(self, "domain_service_account_login_information", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['ActiveDirectoryConnectorStatusArgs']]:
        """
        null
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['ActiveDirectoryConnectorStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ActiveDirectoryConnectorSpecArgs:
    def __init__(__self__, *,
                 active_directory: pulumi.Input['ActiveDirectoryConnectorDomainDetailsArgs'],
                 dns: pulumi.Input['ActiveDirectoryConnectorDNSDetailsArgs']):
        """
        The specifications of the AD Kubernetes resource.
        :param pulumi.Input['ActiveDirectoryConnectorDomainDetailsArgs'] active_directory: null
        :param pulumi.Input['ActiveDirectoryConnectorDNSDetailsArgs'] dns: null
        """
        pulumi.set(__self__, "active_directory", active_directory)
        pulumi.set(__self__, "dns", dns)

    @property
    @pulumi.getter(name="activeDirectory")
    def active_directory(self) -> pulumi.Input['ActiveDirectoryConnectorDomainDetailsArgs']:
        """
        null
        """
        return pulumi.get(self, "active_directory")

    @active_directory.setter
    def active_directory(self, value: pulumi.Input['ActiveDirectoryConnectorDomainDetailsArgs']):
        pulumi.set(self, "active_directory", value)

    @property
    @pulumi.getter
    def dns(self) -> pulumi.Input['ActiveDirectoryConnectorDNSDetailsArgs']:
        """
        null
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: pulumi.Input['ActiveDirectoryConnectorDNSDetailsArgs']):
        pulumi.set(self, "dns", value)


@pulumi.input_type
class ActiveDirectoryConnectorStatusArgs:
    def __init__(__self__, *,
                 last_update_time: Optional[pulumi.Input[str]] = None,
                 observed_generation: Optional[pulumi.Input[float]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        The status of the Kubernetes custom resource.
        :param pulumi.Input[str] last_update_time: The time that the custom resource was last updated.
        :param pulumi.Input[float] observed_generation: The version of the replicaSet associated with the AD connector custom resource.
        :param pulumi.Input[str] state: The state of the AD connector custom resource.
        """
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the custom resource was last updated.
        """
        return pulumi.get(self, "last_update_time")

    @last_update_time.setter
    def last_update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_update_time", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[float]]:
        """
        The version of the replicaSet associated with the AD connector custom resource.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "observed_generation", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the AD connector custom resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class ActiveDirectoryDomainControllersArgs:
    def __init__(__self__, *,
                 primary_domain_controller: Optional[pulumi.Input['ActiveDirectoryDomainControllerArgs']] = None,
                 secondary_domain_controllers: Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryDomainControllerArgs']]]] = None):
        """
        Details about the Active Directory domain controllers associated with this AD connector instance
        :param pulumi.Input['ActiveDirectoryDomainControllerArgs'] primary_domain_controller: Information about the Primary Domain Controller (PDC) in the AD domain.
        :param pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryDomainControllerArgs']]] secondary_domain_controllers: null
        """
        if primary_domain_controller is not None:
            pulumi.set(__self__, "primary_domain_controller", primary_domain_controller)
        if secondary_domain_controllers is not None:
            pulumi.set(__self__, "secondary_domain_controllers", secondary_domain_controllers)

    @property
    @pulumi.getter(name="primaryDomainController")
    def primary_domain_controller(self) -> Optional[pulumi.Input['ActiveDirectoryDomainControllerArgs']]:
        """
        Information about the Primary Domain Controller (PDC) in the AD domain.
        """
        return pulumi.get(self, "primary_domain_controller")

    @primary_domain_controller.setter
    def primary_domain_controller(self, value: Optional[pulumi.Input['ActiveDirectoryDomainControllerArgs']]):
        pulumi.set(self, "primary_domain_controller", value)

    @property
    @pulumi.getter(name="secondaryDomainControllers")
    def secondary_domain_controllers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryDomainControllerArgs']]]]:
        """
        null
        """
        return pulumi.get(self, "secondary_domain_controllers")

    @secondary_domain_controllers.setter
    def secondary_domain_controllers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryDomainControllerArgs']]]]):
        pulumi.set(self, "secondary_domain_controllers", value)


@pulumi.input_type
class ActiveDirectoryDomainControllerArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[str]):
        """
        Information about a domain controller in the AD domain.
        :param pulumi.Input[str] hostname: Fully-qualified domain name of a domain controller in the AD domain.
        """
        pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        """
        Fully-qualified domain name of a domain controller in the AD domain.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)


@pulumi.input_type
class ActiveDirectoryInformationArgs:
    def __init__(__self__, *,
                 keytab_information: Optional[pulumi.Input['KeytabInformationArgs']] = None):
        """
        Active Directory information that related to the resource.
        :param pulumi.Input['KeytabInformationArgs'] keytab_information: Keytab information that is used for the Sql Managed Instance when Active Directory authentication is used.
        """
        if keytab_information is not None:
            pulumi.set(__self__, "keytab_information", keytab_information)

    @property
    @pulumi.getter(name="keytabInformation")
    def keytab_information(self) -> Optional[pulumi.Input['KeytabInformationArgs']]:
        """
        Keytab information that is used for the Sql Managed Instance when Active Directory authentication is used.
        """
        return pulumi.get(self, "keytab_information")

    @keytab_information.setter
    def keytab_information(self, value: Optional[pulumi.Input['KeytabInformationArgs']]):
        pulumi.set(self, "keytab_information", value)


@pulumi.input_type
class AvailabilityGroupConfigureArgs:
    def __init__(__self__, *,
                 availability_mode_desc: Optional[pulumi.Input[str]] = None,
                 backup_priority: Optional[pulumi.Input[int]] = None,
                 create_date: Optional[pulumi.Input[str]] = None,
                 endpoint_url: Optional[pulumi.Input[str]] = None,
                 failover_mode_desc: Optional[pulumi.Input[str]] = None,
                 modify_date: Optional[pulumi.Input[str]] = None,
                 primary_role_allow_connections_desc: Optional[pulumi.Input[str]] = None,
                 read_only_routing_url: Optional[pulumi.Input[str]] = None,
                 read_write_routing_url: Optional[pulumi.Input[str]] = None,
                 secondary_role_allow_connections_desc: Optional[pulumi.Input[str]] = None,
                 seeding_mode_desc: Optional[pulumi.Input[str]] = None,
                 session_timeout: Optional[pulumi.Input[int]] = None):
        """
        The specifications of the availability group replica configuration
        :param pulumi.Input[str] availability_mode_desc: Availability Synchronization mode description of availability group replica.
        :param pulumi.Input[int] backup_priority: Represents the user-specified priority for performing backups on this replica relative to the other replicas in the same availability group.
        :param pulumi.Input[str] create_date: Date that the replica was created.
        :param pulumi.Input[str] endpoint_url: Mirroring endpoint URL of availability group replica
        :param pulumi.Input[str] failover_mode_desc: failover mode description of the availability group replica.
        :param pulumi.Input[str] modify_date: Date that the replica was modified.
        :param pulumi.Input[str] primary_role_allow_connections_desc: Allowed the connections for primary role of the availability group replica.
        :param pulumi.Input[str] read_only_routing_url: Connectivity endpoint (URL) of the read only availability replica.
        :param pulumi.Input[str] read_write_routing_url: Connectivity endpoint (URL) of the read write availability replica.
        :param pulumi.Input[str] secondary_role_allow_connections_desc: Allowed the connections for secondary role of availability group replica.
        :param pulumi.Input[str] seeding_mode_desc: Describes seeding mode.
        :param pulumi.Input[int] session_timeout: The time-out period of availability group session replica, in seconds.
        """
        if availability_mode_desc is not None:
            pulumi.set(__self__, "availability_mode_desc", availability_mode_desc)
        if backup_priority is not None:
            pulumi.set(__self__, "backup_priority", backup_priority)
        if create_date is not None:
            pulumi.set(__self__, "create_date", create_date)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)
        if failover_mode_desc is not None:
            pulumi.set(__self__, "failover_mode_desc", failover_mode_desc)
        if modify_date is not None:
            pulumi.set(__self__, "modify_date", modify_date)
        if primary_role_allow_connections_desc is not None:
            pulumi.set(__self__, "primary_role_allow_connections_desc", primary_role_allow_connections_desc)
        if read_only_routing_url is not None:
            pulumi.set(__self__, "read_only_routing_url", read_only_routing_url)
        if read_write_routing_url is not None:
            pulumi.set(__self__, "read_write_routing_url", read_write_routing_url)
        if secondary_role_allow_connections_desc is not None:
            pulumi.set(__self__, "secondary_role_allow_connections_desc", secondary_role_allow_connections_desc)
        if seeding_mode_desc is not None:
            pulumi.set(__self__, "seeding_mode_desc", seeding_mode_desc)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @property
    @pulumi.getter(name="availabilityModeDesc")
    def availability_mode_desc(self) -> Optional[pulumi.Input[str]]:
        """
        Availability Synchronization mode description of availability group replica.
        """
        return pulumi.get(self, "availability_mode_desc")

    @availability_mode_desc.setter
    def availability_mode_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_mode_desc", value)

    @property
    @pulumi.getter(name="backupPriority")
    def backup_priority(self) -> Optional[pulumi.Input[int]]:
        """
        Represents the user-specified priority for performing backups on this replica relative to the other replicas in the same availability group.
        """
        return pulumi.get(self, "backup_priority")

    @backup_priority.setter
    def backup_priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_priority", value)

    @property
    @pulumi.getter(name="createDate")
    def create_date(self) -> Optional[pulumi.Input[str]]:
        """
        Date that the replica was created.
        """
        return pulumi.get(self, "create_date")

    @create_date.setter
    def create_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_date", value)

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[pulumi.Input[str]]:
        """
        Mirroring endpoint URL of availability group replica
        """
        return pulumi.get(self, "endpoint_url")

    @endpoint_url.setter
    def endpoint_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_url", value)

    @property
    @pulumi.getter(name="failoverModeDesc")
    def failover_mode_desc(self) -> Optional[pulumi.Input[str]]:
        """
        failover mode description of the availability group replica.
        """
        return pulumi.get(self, "failover_mode_desc")

    @failover_mode_desc.setter
    def failover_mode_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failover_mode_desc", value)

    @property
    @pulumi.getter(name="modifyDate")
    def modify_date(self) -> Optional[pulumi.Input[str]]:
        """
        Date that the replica was modified.
        """
        return pulumi.get(self, "modify_date")

    @modify_date.setter
    def modify_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modify_date", value)

    @property
    @pulumi.getter(name="primaryRoleAllowConnectionsDesc")
    def primary_role_allow_connections_desc(self) -> Optional[pulumi.Input[str]]:
        """
        Allowed the connections for primary role of the availability group replica.
        """
        return pulumi.get(self, "primary_role_allow_connections_desc")

    @primary_role_allow_connections_desc.setter
    def primary_role_allow_connections_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_role_allow_connections_desc", value)

    @property
    @pulumi.getter(name="readOnlyRoutingUrl")
    def read_only_routing_url(self) -> Optional[pulumi.Input[str]]:
        """
        Connectivity endpoint (URL) of the read only availability replica.
        """
        return pulumi.get(self, "read_only_routing_url")

    @read_only_routing_url.setter
    def read_only_routing_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "read_only_routing_url", value)

    @property
    @pulumi.getter(name="readWriteRoutingUrl")
    def read_write_routing_url(self) -> Optional[pulumi.Input[str]]:
        """
        Connectivity endpoint (URL) of the read write availability replica.
        """
        return pulumi.get(self, "read_write_routing_url")

    @read_write_routing_url.setter
    def read_write_routing_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "read_write_routing_url", value)

    @property
    @pulumi.getter(name="secondaryRoleAllowConnectionsDesc")
    def secondary_role_allow_connections_desc(self) -> Optional[pulumi.Input[str]]:
        """
        Allowed the connections for secondary role of availability group replica.
        """
        return pulumi.get(self, "secondary_role_allow_connections_desc")

    @secondary_role_allow_connections_desc.setter
    def secondary_role_allow_connections_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_role_allow_connections_desc", value)

    @property
    @pulumi.getter(name="seedingModeDesc")
    def seeding_mode_desc(self) -> Optional[pulumi.Input[str]]:
        """
        Describes seeding mode.
        """
        return pulumi.get(self, "seeding_mode_desc")

    @seeding_mode_desc.setter
    def seeding_mode_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "seeding_mode_desc", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time-out period of availability group session replica, in seconds.
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_timeout", value)


@pulumi.input_type
class AvailabilityGroupStateArgs:
    def __init__(__self__, *,
                 availability_group_replica_role: Optional[pulumi.Input[str]] = None,
                 connected_state_desc: Optional[pulumi.Input[str]] = None,
                 last_connect_error_description: Optional[pulumi.Input[str]] = None,
                 last_connect_error_timestamp: Optional[pulumi.Input[str]] = None,
                 operational_state_desc: Optional[pulumi.Input[str]] = None,
                 recovery_health_desc: Optional[pulumi.Input[str]] = None,
                 synchronization_health_desc: Optional[pulumi.Input[str]] = None):
        """
        The specifications of the availability group state
        :param pulumi.Input[str] availability_group_replica_role: Role description of the availability group replica.
        :param pulumi.Input[str] connected_state_desc: Connected state description of the availability group replica.
        :param pulumi.Input[str] last_connect_error_description: Last connect error description of the availability group replica.
        :param pulumi.Input[str] last_connect_error_timestamp: Last connect error time stamp of the availability group replica.
        :param pulumi.Input[str] operational_state_desc: Operation state description of the availability group replica
        :param pulumi.Input[str] recovery_health_desc: Recovery health description of the availability group replica.
        :param pulumi.Input[str] synchronization_health_desc: Synchronization health description of the availability group replica.
        """
        if availability_group_replica_role is not None:
            pulumi.set(__self__, "availability_group_replica_role", availability_group_replica_role)
        if connected_state_desc is not None:
            pulumi.set(__self__, "connected_state_desc", connected_state_desc)
        if last_connect_error_description is not None:
            pulumi.set(__self__, "last_connect_error_description", last_connect_error_description)
        if last_connect_error_timestamp is not None:
            pulumi.set(__self__, "last_connect_error_timestamp", last_connect_error_timestamp)
        if operational_state_desc is not None:
            pulumi.set(__self__, "operational_state_desc", operational_state_desc)
        if recovery_health_desc is not None:
            pulumi.set(__self__, "recovery_health_desc", recovery_health_desc)
        if synchronization_health_desc is not None:
            pulumi.set(__self__, "synchronization_health_desc", synchronization_health_desc)

    @property
    @pulumi.getter(name="availabilityGroupReplicaRole")
    def availability_group_replica_role(self) -> Optional[pulumi.Input[str]]:
        """
        Role description of the availability group replica.
        """
        return pulumi.get(self, "availability_group_replica_role")

    @availability_group_replica_role.setter
    def availability_group_replica_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_group_replica_role", value)

    @property
    @pulumi.getter(name="connectedStateDesc")
    def connected_state_desc(self) -> Optional[pulumi.Input[str]]:
        """
        Connected state description of the availability group replica.
        """
        return pulumi.get(self, "connected_state_desc")

    @connected_state_desc.setter
    def connected_state_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connected_state_desc", value)

    @property
    @pulumi.getter(name="lastConnectErrorDescription")
    def last_connect_error_description(self) -> Optional[pulumi.Input[str]]:
        """
        Last connect error description of the availability group replica.
        """
        return pulumi.get(self, "last_connect_error_description")

    @last_connect_error_description.setter
    def last_connect_error_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_connect_error_description", value)

    @property
    @pulumi.getter(name="lastConnectErrorTimestamp")
    def last_connect_error_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Last connect error time stamp of the availability group replica.
        """
        return pulumi.get(self, "last_connect_error_timestamp")

    @last_connect_error_timestamp.setter
    def last_connect_error_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_connect_error_timestamp", value)

    @property
    @pulumi.getter(name="operationalStateDesc")
    def operational_state_desc(self) -> Optional[pulumi.Input[str]]:
        """
        Operation state description of the availability group replica
        """
        return pulumi.get(self, "operational_state_desc")

    @operational_state_desc.setter
    def operational_state_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operational_state_desc", value)

    @property
    @pulumi.getter(name="recoveryHealthDesc")
    def recovery_health_desc(self) -> Optional[pulumi.Input[str]]:
        """
        Recovery health description of the availability group replica.
        """
        return pulumi.get(self, "recovery_health_desc")

    @recovery_health_desc.setter
    def recovery_health_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recovery_health_desc", value)

    @property
    @pulumi.getter(name="synchronizationHealthDesc")
    def synchronization_health_desc(self) -> Optional[pulumi.Input[str]]:
        """
        Synchronization health description of the availability group replica.
        """
        return pulumi.get(self, "synchronization_health_desc")

    @synchronization_health_desc.setter
    def synchronization_health_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "synchronization_health_desc", value)


@pulumi.input_type
class BasicLoginInformationArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Username and password for basic login authentication.
        :param pulumi.Input[str] password: Login password.
        :param pulumi.Input[str] username: Login username.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Login password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Login username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class DataControllerPropertiesArgs:
    def __init__(__self__, *,
                 basic_login_information: Optional[pulumi.Input['BasicLoginInformationArgs']] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 extension_id: Optional[pulumi.Input[str]] = None,
                 infrastructure: Optional[pulumi.Input['Infrastructure']] = None,
                 k8s_raw: Optional[Any] = None,
                 last_uploaded_date: Optional[pulumi.Input[str]] = None,
                 log_analytics_workspace_config: Optional[pulumi.Input['LogAnalyticsWorkspaceConfigArgs']] = None,
                 logs_dashboard_credential: Optional[pulumi.Input['BasicLoginInformationArgs']] = None,
                 metrics_dashboard_credential: Optional[pulumi.Input['BasicLoginInformationArgs']] = None,
                 on_premise_property: Optional[pulumi.Input['OnPremisePropertyArgs']] = None,
                 upload_service_principal: Optional[pulumi.Input['UploadServicePrincipalArgs']] = None,
                 upload_watermark: Optional[pulumi.Input['UploadWatermarkArgs']] = None):
        """
        The data controller properties.
        :param pulumi.Input['BasicLoginInformationArgs'] basic_login_information: Deprecated. Azure Arc Data Services data controller no longer expose any endpoint. All traffic are exposed through Kubernetes native API.
        :param pulumi.Input[str] cluster_id: If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
        :param pulumi.Input[str] extension_id: If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
        :param pulumi.Input['Infrastructure'] infrastructure: The infrastructure the data controller is running on.
        :param Any k8s_raw: The raw kubernetes information
        :param pulumi.Input[str] last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date time
        :param pulumi.Input['LogAnalyticsWorkspaceConfigArgs'] log_analytics_workspace_config: Log analytics workspace id and primary key
        :param pulumi.Input['BasicLoginInformationArgs'] logs_dashboard_credential: Login credential for logs dashboard on the Kubernetes cluster.
        :param pulumi.Input['BasicLoginInformationArgs'] metrics_dashboard_credential: Login credential for metrics dashboard on the Kubernetes cluster.
        :param pulumi.Input['OnPremisePropertyArgs'] on_premise_property: Properties from the Kubernetes data controller
        :param pulumi.Input['UploadServicePrincipalArgs'] upload_service_principal: Deprecated. Service principal is deprecated in favor of Arc Kubernetes service extension managed identity.
        :param pulumi.Input['UploadWatermarkArgs'] upload_watermark: Properties on upload watermark.  Mostly timestamp for each upload data type
        """
        if basic_login_information is not None:
            pulumi.set(__self__, "basic_login_information", basic_login_information)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if extension_id is not None:
            pulumi.set(__self__, "extension_id", extension_id)
        if infrastructure is None:
            infrastructure = 'other'
        if infrastructure is not None:
            pulumi.set(__self__, "infrastructure", infrastructure)
        if k8s_raw is not None:
            pulumi.set(__self__, "k8s_raw", k8s_raw)
        if last_uploaded_date is not None:
            pulumi.set(__self__, "last_uploaded_date", last_uploaded_date)
        if log_analytics_workspace_config is not None:
            pulumi.set(__self__, "log_analytics_workspace_config", log_analytics_workspace_config)
        if logs_dashboard_credential is not None:
            pulumi.set(__self__, "logs_dashboard_credential", logs_dashboard_credential)
        if metrics_dashboard_credential is not None:
            pulumi.set(__self__, "metrics_dashboard_credential", metrics_dashboard_credential)
        if on_premise_property is not None:
            pulumi.set(__self__, "on_premise_property", on_premise_property)
        if upload_service_principal is not None:
            pulumi.set(__self__, "upload_service_principal", upload_service_principal)
        if upload_watermark is not None:
            pulumi.set(__self__, "upload_watermark", upload_watermark)

    @property
    @pulumi.getter(name="basicLoginInformation")
    def basic_login_information(self) -> Optional[pulumi.Input['BasicLoginInformationArgs']]:
        """
        Deprecated. Azure Arc Data Services data controller no longer expose any endpoint. All traffic are exposed through Kubernetes native API.
        """
        return pulumi.get(self, "basic_login_information")

    @basic_login_information.setter
    def basic_login_information(self, value: Optional[pulumi.Input['BasicLoginInformationArgs']]):
        pulumi.set(self, "basic_login_information", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="extensionId")
    def extension_id(self) -> Optional[pulumi.Input[str]]:
        """
        If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
        """
        return pulumi.get(self, "extension_id")

    @extension_id.setter
    def extension_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extension_id", value)

    @property
    @pulumi.getter
    def infrastructure(self) -> Optional[pulumi.Input['Infrastructure']]:
        """
        The infrastructure the data controller is running on.
        """
        return pulumi.get(self, "infrastructure")

    @infrastructure.setter
    def infrastructure(self, value: Optional[pulumi.Input['Infrastructure']]):
        pulumi.set(self, "infrastructure", value)

    @property
    @pulumi.getter(name="k8sRaw")
    def k8s_raw(self) -> Optional[Any]:
        """
        The raw kubernetes information
        """
        return pulumi.get(self, "k8s_raw")

    @k8s_raw.setter
    def k8s_raw(self, value: Optional[Any]):
        pulumi.set(self, "k8s_raw", value)

    @property
    @pulumi.getter(name="lastUploadedDate")
    def last_uploaded_date(self) -> Optional[pulumi.Input[str]]:
        """
        Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "last_uploaded_date")

    @last_uploaded_date.setter
    def last_uploaded_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_uploaded_date", value)

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceConfig")
    def log_analytics_workspace_config(self) -> Optional[pulumi.Input['LogAnalyticsWorkspaceConfigArgs']]:
        """
        Log analytics workspace id and primary key
        """
        return pulumi.get(self, "log_analytics_workspace_config")

    @log_analytics_workspace_config.setter
    def log_analytics_workspace_config(self, value: Optional[pulumi.Input['LogAnalyticsWorkspaceConfigArgs']]):
        pulumi.set(self, "log_analytics_workspace_config", value)

    @property
    @pulumi.getter(name="logsDashboardCredential")
    def logs_dashboard_credential(self) -> Optional[pulumi.Input['BasicLoginInformationArgs']]:
        """
        Login credential for logs dashboard on the Kubernetes cluster.
        """
        return pulumi.get(self, "logs_dashboard_credential")

    @logs_dashboard_credential.setter
    def logs_dashboard_credential(self, value: Optional[pulumi.Input['BasicLoginInformationArgs']]):
        pulumi.set(self, "logs_dashboard_credential", value)

    @property
    @pulumi.getter(name="metricsDashboardCredential")
    def metrics_dashboard_credential(self) -> Optional[pulumi.Input['BasicLoginInformationArgs']]:
        """
        Login credential for metrics dashboard on the Kubernetes cluster.
        """
        return pulumi.get(self, "metrics_dashboard_credential")

    @metrics_dashboard_credential.setter
    def metrics_dashboard_credential(self, value: Optional[pulumi.Input['BasicLoginInformationArgs']]):
        pulumi.set(self, "metrics_dashboard_credential", value)

    @property
    @pulumi.getter(name="onPremiseProperty")
    def on_premise_property(self) -> Optional[pulumi.Input['OnPremisePropertyArgs']]:
        """
        Properties from the Kubernetes data controller
        """
        return pulumi.get(self, "on_premise_property")

    @on_premise_property.setter
    def on_premise_property(self, value: Optional[pulumi.Input['OnPremisePropertyArgs']]):
        pulumi.set(self, "on_premise_property", value)

    @property
    @pulumi.getter(name="uploadServicePrincipal")
    def upload_service_principal(self) -> Optional[pulumi.Input['UploadServicePrincipalArgs']]:
        """
        Deprecated. Service principal is deprecated in favor of Arc Kubernetes service extension managed identity.
        """
        return pulumi.get(self, "upload_service_principal")

    @upload_service_principal.setter
    def upload_service_principal(self, value: Optional[pulumi.Input['UploadServicePrincipalArgs']]):
        pulumi.set(self, "upload_service_principal", value)

    @property
    @pulumi.getter(name="uploadWatermark")
    def upload_watermark(self) -> Optional[pulumi.Input['UploadWatermarkArgs']]:
        """
        Properties on upload watermark.  Mostly timestamp for each upload data type
        """
        return pulumi.get(self, "upload_watermark")

    @upload_watermark.setter
    def upload_watermark(self, value: Optional[pulumi.Input['UploadWatermarkArgs']]):
        pulumi.set(self, "upload_watermark", value)


@pulumi.input_type
class ExtendedLocationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]] = None):
        """
        The complex type of the extended location.
        :param pulumi.Input[str] name: The name of the extended location.
        :param pulumi.Input[Union[str, 'ExtendedLocationTypes']] type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class FailoverGroupPropertiesArgs:
    def __init__(__self__, *,
                 partner_managed_instance_id: pulumi.Input[str],
                 spec: pulumi.Input['FailoverGroupSpecArgs'],
                 status: Optional[pulumi.Input['FailoverGroupStatusArgs']] = None):
        """
        The properties of a failover group resource.
        :param pulumi.Input[str] partner_managed_instance_id: The resource ID of the partner SQL managed instance.
        :param pulumi.Input['FailoverGroupSpecArgs'] spec: The specifications of the failover group resource.
        :param pulumi.Input['FailoverGroupStatusArgs'] status: The status of the failover group custom resource.
        """
        pulumi.set(__self__, "partner_managed_instance_id", partner_managed_instance_id)
        pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="partnerManagedInstanceId")
    def partner_managed_instance_id(self) -> pulumi.Input[str]:
        """
        The resource ID of the partner SQL managed instance.
        """
        return pulumi.get(self, "partner_managed_instance_id")

    @partner_managed_instance_id.setter
    def partner_managed_instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "partner_managed_instance_id", value)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['FailoverGroupSpecArgs']:
        """
        The specifications of the failover group resource.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['FailoverGroupSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['FailoverGroupStatusArgs']]:
        """
        The status of the failover group custom resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['FailoverGroupStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class FailoverGroupSpecArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[Union[str, 'InstanceFailoverGroupRole']],
                 partner_mi: Optional[pulumi.Input[str]] = None,
                 partner_mirroring_cert: Optional[pulumi.Input[str]] = None,
                 partner_mirroring_url: Optional[pulumi.Input[str]] = None,
                 partner_sync_mode: Optional[pulumi.Input[Union[str, 'FailoverGroupPartnerSyncMode']]] = None,
                 shared_name: Optional[pulumi.Input[str]] = None,
                 source_mi: Optional[pulumi.Input[str]] = None):
        """
        The specifications of the failover group resource.
        :param pulumi.Input[Union[str, 'InstanceFailoverGroupRole']] role: The role of the SQL managed instance in this failover group.
        :param pulumi.Input[str] partner_mi: The name of the partner SQL managed instance.
        :param pulumi.Input[str] partner_mirroring_cert: The mirroring endpoint public certificate for the partner SQL managed instance. Only PEM format is supported.
        :param pulumi.Input[str] partner_mirroring_url: The mirroring endpoint URL of the partner SQL managed instance.
        :param pulumi.Input[Union[str, 'FailoverGroupPartnerSyncMode']] partner_sync_mode: The partner sync mode of the SQL managed instance.
        :param pulumi.Input[str] shared_name: The shared name of the failover group for this SQL managed instance. Both SQL managed instance and its partner have to use the same shared name.
        :param pulumi.Input[str] source_mi: The name of the SQL managed instance with this failover group role.
        """
        if role is None:
            role = 'primary'
        pulumi.set(__self__, "role", role)
        if partner_mi is not None:
            pulumi.set(__self__, "partner_mi", partner_mi)
        if partner_mirroring_cert is not None:
            pulumi.set(__self__, "partner_mirroring_cert", partner_mirroring_cert)
        if partner_mirroring_url is not None:
            pulumi.set(__self__, "partner_mirroring_url", partner_mirroring_url)
        if partner_sync_mode is None:
            partner_sync_mode = 'async'
        if partner_sync_mode is not None:
            pulumi.set(__self__, "partner_sync_mode", partner_sync_mode)
        if shared_name is not None:
            pulumi.set(__self__, "shared_name", shared_name)
        if source_mi is not None:
            pulumi.set(__self__, "source_mi", source_mi)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[Union[str, 'InstanceFailoverGroupRole']]:
        """
        The role of the SQL managed instance in this failover group.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[Union[str, 'InstanceFailoverGroupRole']]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="partnerMI")
    def partner_mi(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the partner SQL managed instance.
        """
        return pulumi.get(self, "partner_mi")

    @partner_mi.setter
    def partner_mi(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partner_mi", value)

    @property
    @pulumi.getter(name="partnerMirroringCert")
    def partner_mirroring_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The mirroring endpoint public certificate for the partner SQL managed instance. Only PEM format is supported.
        """
        return pulumi.get(self, "partner_mirroring_cert")

    @partner_mirroring_cert.setter
    def partner_mirroring_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partner_mirroring_cert", value)

    @property
    @pulumi.getter(name="partnerMirroringURL")
    def partner_mirroring_url(self) -> Optional[pulumi.Input[str]]:
        """
        The mirroring endpoint URL of the partner SQL managed instance.
        """
        return pulumi.get(self, "partner_mirroring_url")

    @partner_mirroring_url.setter
    def partner_mirroring_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partner_mirroring_url", value)

    @property
    @pulumi.getter(name="partnerSyncMode")
    def partner_sync_mode(self) -> Optional[pulumi.Input[Union[str, 'FailoverGroupPartnerSyncMode']]]:
        """
        The partner sync mode of the SQL managed instance.
        """
        return pulumi.get(self, "partner_sync_mode")

    @partner_sync_mode.setter
    def partner_sync_mode(self, value: Optional[pulumi.Input[Union[str, 'FailoverGroupPartnerSyncMode']]]):
        pulumi.set(self, "partner_sync_mode", value)

    @property
    @pulumi.getter(name="sharedName")
    def shared_name(self) -> Optional[pulumi.Input[str]]:
        """
        The shared name of the failover group for this SQL managed instance. Both SQL managed instance and its partner have to use the same shared name.
        """
        return pulumi.get(self, "shared_name")

    @shared_name.setter
    def shared_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_name", value)

    @property
    @pulumi.getter(name="sourceMI")
    def source_mi(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SQL managed instance with this failover group role.
        """
        return pulumi.get(self, "source_mi")

    @source_mi.setter
    def source_mi(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_mi", value)


@pulumi.input_type
class FailoverGroupStatusArgs:
    def __init__(__self__, *,
                 last_update_time: Optional[pulumi.Input[str]] = None,
                 observed_generation: Optional[pulumi.Input[float]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input['AGReplicasArgs']]]] = None,
                 results: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[Union[str, 'InstanceFailoverGroupRole']]] = None,
                 state: Optional[pulumi.Input[Union[str, 'State']]] = None):
        """
        The status of the Kubernetes custom resource.
        :param pulumi.Input[str] last_update_time: The time that the custom resource was last updated.
        :param pulumi.Input[float] observed_generation: The version of the replicaSet associated with the failover group custom resource.
        :param pulumi.Input[Sequence[pulumi.Input['AGReplicasArgs']]] replicas: A list of failover group replicas.
        :param pulumi.Input[str] results: The message in case of a failure in the failover group.
        :param pulumi.Input[Union[str, 'InstanceFailoverGroupRole']] role: The role of the managed instance in the failover group.
        :param pulumi.Input[Union[str, 'State']] state: The state of the failover group custom resource.
        """
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if results is not None:
            pulumi.set(__self__, "results", results)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the custom resource was last updated.
        """
        return pulumi.get(self, "last_update_time")

    @last_update_time.setter
    def last_update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_update_time", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[float]]:
        """
        The version of the replicaSet associated with the failover group custom resource.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "observed_generation", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AGReplicasArgs']]]]:
        """
        A list of failover group replicas.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AGReplicasArgs']]]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter
    def results(self) -> Optional[pulumi.Input[str]]:
        """
        The message in case of a failure in the failover group.
        """
        return pulumi.get(self, "results")

    @results.setter
    def results(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "results", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[Union[str, 'InstanceFailoverGroupRole']]]:
        """
        The role of the managed instance in the failover group.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[Union[str, 'InstanceFailoverGroupRole']]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'State']]]:
        """
        The state of the failover group custom resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'State']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class K8sResourceRequirementsArgs:
    def __init__(__self__, *,
                 limits: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 requests: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The kubernetes resource limits and requests used to restrict or reserve resource usage.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] limits: Limits for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum 'memory' is '128Gi'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] requests: Requests for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum 'memory' is '128Gi'.
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Limits for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum 'memory' is '128Gi'.
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Requests for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum 'memory' is '128Gi'.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "requests", value)


@pulumi.input_type
class K8sSchedulingOptionsArgs:
    def __init__(__self__, *,
                 resources: Optional[pulumi.Input['K8sResourceRequirementsArgs']] = None):
        """
        The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
        :param pulumi.Input['K8sResourceRequirementsArgs'] resources: The kubernetes resource limits and requests used to restrict or reserve resource usage.
        """
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['K8sResourceRequirementsArgs']]:
        """
        The kubernetes resource limits and requests used to restrict or reserve resource usage.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['K8sResourceRequirementsArgs']]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class K8sSchedulingArgs:
    def __init__(__self__, *,
                 default: Optional[pulumi.Input['K8sSchedulingOptionsArgs']] = None):
        """
        The kubernetes scheduling information.
        :param pulumi.Input['K8sSchedulingOptionsArgs'] default: The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
        """
        if default is not None:
            pulumi.set(__self__, "default", default)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input['K8sSchedulingOptionsArgs']]:
        """
        The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input['K8sSchedulingOptionsArgs']]):
        pulumi.set(self, "default", value)


@pulumi.input_type
class KeytabInformationArgs:
    def __init__(__self__, *,
                 keytab: Optional[pulumi.Input[str]] = None):
        """
        Keytab used for authenticate with Active Directory.
        :param pulumi.Input[str] keytab: A base64-encoded keytab.
        """
        if keytab is not None:
            pulumi.set(__self__, "keytab", keytab)

    @property
    @pulumi.getter
    def keytab(self) -> Optional[pulumi.Input[str]]:
        """
        A base64-encoded keytab.
        """
        return pulumi.get(self, "keytab")

    @keytab.setter
    def keytab(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keytab", value)


@pulumi.input_type
class LogAnalyticsWorkspaceConfigArgs:
    def __init__(__self__, *,
                 primary_key: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None):
        """
        Log analytics workspace id and primary key
        :param pulumi.Input[str] primary_key: Primary key of the workspace
        :param pulumi.Input[str] workspace_id: Azure Log Analytics workspace ID
        """
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[str]]:
        """
        Primary key of the workspace
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_key", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Log Analytics workspace ID
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class OnPremisePropertyArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 public_signing_key: pulumi.Input[str],
                 signing_certificate_thumbprint: Optional[pulumi.Input[str]] = None):
        """
        Properties from the Kubernetes data controller
        :param pulumi.Input[str] id: A globally unique ID identifying the associated Kubernetes cluster
        :param pulumi.Input[str] public_signing_key: Certificate that contains the Kubernetes cluster public key used to verify signing
        :param pulumi.Input[str] signing_certificate_thumbprint: Unique thumbprint returned to customer to verify the certificate being uploaded
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "public_signing_key", public_signing_key)
        if signing_certificate_thumbprint is not None:
            pulumi.set(__self__, "signing_certificate_thumbprint", signing_certificate_thumbprint)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        A globally unique ID identifying the associated Kubernetes cluster
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="publicSigningKey")
    def public_signing_key(self) -> pulumi.Input[str]:
        """
        Certificate that contains the Kubernetes cluster public key used to verify signing
        """
        return pulumi.get(self, "public_signing_key")

    @public_signing_key.setter
    def public_signing_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "public_signing_key", value)

    @property
    @pulumi.getter(name="signingCertificateThumbprint")
    def signing_certificate_thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        Unique thumbprint returned to customer to verify the certificate being uploaded
        """
        return pulumi.get(self, "signing_certificate_thumbprint")

    @signing_certificate_thumbprint.setter
    def signing_certificate_thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signing_certificate_thumbprint", value)


@pulumi.input_type
class PostgresInstancePropertiesArgs:
    def __init__(__self__, *,
                 admin: Optional[pulumi.Input[str]] = None,
                 basic_login_information: Optional[pulumi.Input['BasicLoginInformationArgs']] = None,
                 data_controller_id: Optional[pulumi.Input[str]] = None,
                 k8s_raw: Optional[Any] = None,
                 last_uploaded_date: Optional[pulumi.Input[str]] = None):
        """
        Postgres Instance properties.
        :param pulumi.Input[str] admin: The instance admin
        :param pulumi.Input['BasicLoginInformationArgs'] basic_login_information: Username and password for basic authentication.
        :param pulumi.Input[str] data_controller_id: The data controller id
        :param Any k8s_raw: The raw kubernetes information
        :param pulumi.Input[str] last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        if admin is not None:
            pulumi.set(__self__, "admin", admin)
        if basic_login_information is not None:
            pulumi.set(__self__, "basic_login_information", basic_login_information)
        if data_controller_id is not None:
            pulumi.set(__self__, "data_controller_id", data_controller_id)
        if k8s_raw is not None:
            pulumi.set(__self__, "k8s_raw", k8s_raw)
        if last_uploaded_date is not None:
            pulumi.set(__self__, "last_uploaded_date", last_uploaded_date)

    @property
    @pulumi.getter
    def admin(self) -> Optional[pulumi.Input[str]]:
        """
        The instance admin
        """
        return pulumi.get(self, "admin")

    @admin.setter
    def admin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin", value)

    @property
    @pulumi.getter(name="basicLoginInformation")
    def basic_login_information(self) -> Optional[pulumi.Input['BasicLoginInformationArgs']]:
        """
        Username and password for basic authentication.
        """
        return pulumi.get(self, "basic_login_information")

    @basic_login_information.setter
    def basic_login_information(self, value: Optional[pulumi.Input['BasicLoginInformationArgs']]):
        pulumi.set(self, "basic_login_information", value)

    @property
    @pulumi.getter(name="dataControllerId")
    def data_controller_id(self) -> Optional[pulumi.Input[str]]:
        """
        The data controller id
        """
        return pulumi.get(self, "data_controller_id")

    @data_controller_id.setter
    def data_controller_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_controller_id", value)

    @property
    @pulumi.getter(name="k8sRaw")
    def k8s_raw(self) -> Optional[Any]:
        """
        The raw kubernetes information
        """
        return pulumi.get(self, "k8s_raw")

    @k8s_raw.setter
    def k8s_raw(self, value: Optional[Any]):
        pulumi.set(self, "k8s_raw", value)

    @property
    @pulumi.getter(name="lastUploadedDate")
    def last_uploaded_date(self) -> Optional[pulumi.Input[str]]:
        """
        Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "last_uploaded_date")

    @last_uploaded_date.setter
    def last_uploaded_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_uploaded_date", value)


@pulumi.input_type
class PostgresInstanceSkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 capacity: Optional[pulumi.Input[int]] = None,
                 dev: Optional[pulumi.Input[bool]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input['PostgresInstanceSkuTier']] = None):
        """
        The resource model definition representing SKU for Azure Database for PostgresSQL - Azure Arc
        :param pulumi.Input[str] name: The name of the SKU.  It is typically a letter+number code
        :param pulumi.Input[int] capacity: If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        :param pulumi.Input[bool] dev: Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        :param pulumi.Input[str] family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param pulumi.Input[str] size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        :param pulumi.Input['PostgresInstanceSkuTier'] tier: This field is required to be implemented by the Resource Provider if the service has more than one tier.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if dev is None:
            dev = True
        if dev is not None:
            pulumi.set(__self__, "dev", dev)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is None:
            tier = 'Hyperscale'
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the SKU.  It is typically a letter+number code
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def dev(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        """
        return pulumi.get(self, "dev")

    @dev.setter
    def dev(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dev", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input['PostgresInstanceSkuTier']]:
        """
        This field is required to be implemented by the Resource Provider if the service has more than one tier.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input['PostgresInstanceSkuTier']]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs:
    def __init__(__self__, *,
                 database_state_desc: Optional[pulumi.Input[str]] = None,
                 is_commit_participant: Optional[pulumi.Input[bool]] = None,
                 is_local: Optional[pulumi.Input[bool]] = None,
                 is_primary_replica: Optional[pulumi.Input[bool]] = None,
                 is_suspended: Optional[pulumi.Input[bool]] = None,
                 replica_name: Optional[pulumi.Input[str]] = None,
                 suspend_reason_desc: Optional[pulumi.Input[str]] = None,
                 synchronization_health_desc: Optional[pulumi.Input[str]] = None,
                 synchronization_state_desc: Optional[pulumi.Input[str]] = None):
        """
        The properties of Arc Sql availability group database replica resource
        :param pulumi.Input[str] database_state_desc: Description of the database state of the availability replica.
        :param pulumi.Input[bool] is_commit_participant: Whether this replica is transaction committer.
        :param pulumi.Input[bool] is_local: Whether the availability database is local.
        :param pulumi.Input[bool] is_primary_replica: Returns 1 if the replica is primary, or 0 if it is a secondary replica.
        :param pulumi.Input[bool] is_suspended: Whether this data movement is suspended.
        :param pulumi.Input[str] replica_name: the database replica name.
        :param pulumi.Input[str] suspend_reason_desc: Description of the database suspended state reason.
        :param pulumi.Input[str] synchronization_health_desc: Description of the health of database.
        :param pulumi.Input[str] synchronization_state_desc: Description of the data-movement state.
        """
        if database_state_desc is not None:
            pulumi.set(__self__, "database_state_desc", database_state_desc)
        if is_commit_participant is not None:
            pulumi.set(__self__, "is_commit_participant", is_commit_participant)
        if is_local is not None:
            pulumi.set(__self__, "is_local", is_local)
        if is_primary_replica is not None:
            pulumi.set(__self__, "is_primary_replica", is_primary_replica)
        if is_suspended is not None:
            pulumi.set(__self__, "is_suspended", is_suspended)
        if replica_name is not None:
            pulumi.set(__self__, "replica_name", replica_name)
        if suspend_reason_desc is not None:
            pulumi.set(__self__, "suspend_reason_desc", suspend_reason_desc)
        if synchronization_health_desc is not None:
            pulumi.set(__self__, "synchronization_health_desc", synchronization_health_desc)
        if synchronization_state_desc is not None:
            pulumi.set(__self__, "synchronization_state_desc", synchronization_state_desc)

    @property
    @pulumi.getter(name="databaseStateDesc")
    def database_state_desc(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the database state of the availability replica.
        """
        return pulumi.get(self, "database_state_desc")

    @database_state_desc.setter
    def database_state_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_state_desc", value)

    @property
    @pulumi.getter(name="isCommitParticipant")
    def is_commit_participant(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this replica is transaction committer.
        """
        return pulumi.get(self, "is_commit_participant")

    @is_commit_participant.setter
    def is_commit_participant(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_commit_participant", value)

    @property
    @pulumi.getter(name="isLocal")
    def is_local(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the availability database is local.
        """
        return pulumi.get(self, "is_local")

    @is_local.setter
    def is_local(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_local", value)

    @property
    @pulumi.getter(name="isPrimaryReplica")
    def is_primary_replica(self) -> Optional[pulumi.Input[bool]]:
        """
        Returns 1 if the replica is primary, or 0 if it is a secondary replica.
        """
        return pulumi.get(self, "is_primary_replica")

    @is_primary_replica.setter
    def is_primary_replica(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_primary_replica", value)

    @property
    @pulumi.getter(name="isSuspended")
    def is_suspended(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this data movement is suspended.
        """
        return pulumi.get(self, "is_suspended")

    @is_suspended.setter
    def is_suspended(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_suspended", value)

    @property
    @pulumi.getter(name="replicaName")
    def replica_name(self) -> Optional[pulumi.Input[str]]:
        """
        the database replica name.
        """
        return pulumi.get(self, "replica_name")

    @replica_name.setter
    def replica_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_name", value)

    @property
    @pulumi.getter(name="suspendReasonDesc")
    def suspend_reason_desc(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the database suspended state reason.
        """
        return pulumi.get(self, "suspend_reason_desc")

    @suspend_reason_desc.setter
    def suspend_reason_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "suspend_reason_desc", value)

    @property
    @pulumi.getter(name="synchronizationHealthDesc")
    def synchronization_health_desc(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the health of database.
        """
        return pulumi.get(self, "synchronization_health_desc")

    @synchronization_health_desc.setter
    def synchronization_health_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "synchronization_health_desc", value)

    @property
    @pulumi.getter(name="synchronizationStateDesc")
    def synchronization_state_desc(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the data-movement state.
        """
        return pulumi.get(self, "synchronization_state_desc")

    @synchronization_state_desc.setter
    def synchronization_state_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "synchronization_state_desc", value)


@pulumi.input_type
class SqlAvailabilityGroupMultiDatabaseReplicaResourcePropertiesArgs:
    def __init__(__self__, *,
                 group_database_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs']]]] = None):
        """
        The properties of Arc Sql availability group multiple database replica resource
        :param pulumi.Input[str] group_database_id: ID GUID of the database for availability group.
        :param pulumi.Input[Sequence[pulumi.Input['SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs']]] value: Array of  Arc Sql Availability Group Database Replicas.
        """
        if group_database_id is not None:
            pulumi.set(__self__, "group_database_id", group_database_id)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="groupDatabaseId")
    def group_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID GUID of the database for availability group.
        """
        return pulumi.get(self, "group_database_id")

    @group_database_id.setter
    def group_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_database_id", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs']]]]:
        """
        Array of  Arc Sql Availability Group Database Replicas.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs']]]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class SqlAvailabilityGroupPropertiesArgs:
    def __init__(__self__, *,
                 availability_group_id: pulumi.Input[str],
                 availability_group_name: pulumi.Input[str],
                 basic_features: Optional[pulumi.Input[bool]] = None,
                 cluster_type_desc: Optional[pulumi.Input[str]] = None,
                 collection_timestamp: Optional[pulumi.Input[str]] = None,
                 db_failover: Optional[pulumi.Input[bool]] = None,
                 dtc_support: Optional[pulumi.Input[bool]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 is_contained: Optional[pulumi.Input[bool]] = None,
                 is_distributed: Optional[pulumi.Input[bool]] = None,
                 required_synchronized_secondaries_commit: Optional[pulumi.Input[int]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Properties of SqlAvailabilityGroup.
        :param pulumi.Input[str] availability_group_id: Id GUID of the availability group.
        :param pulumi.Input[str] availability_group_name: The name of the availability group.
        :param pulumi.Input[bool] basic_features: SQL Server basic availability group.
        :param pulumi.Input[str] cluster_type_desc: SQL Server availability group cluster type description
        :param pulumi.Input[str] collection_timestamp: Timestamp for when the data was collected from the client machine.
        :param pulumi.Input[bool] db_failover: SQL Server availability group failover for database health conditions.
        :param pulumi.Input[bool] dtc_support: SQL Server availability group DTC support enabled.
        :param pulumi.Input[str] instance_name: The name of the instance name which availability group primary is on.
        :param pulumi.Input[bool] is_contained: SQL Server availability group contained system databases.
        :param pulumi.Input[bool] is_distributed: SQL Server distributed availability group.
        :param pulumi.Input[int] required_synchronized_secondaries_commit: Availability group required the number of synchronized secondary to commit.
        :param pulumi.Input[int] version: SQL Server availability group current version.
        """
        pulumi.set(__self__, "availability_group_id", availability_group_id)
        pulumi.set(__self__, "availability_group_name", availability_group_name)
        if basic_features is not None:
            pulumi.set(__self__, "basic_features", basic_features)
        if cluster_type_desc is not None:
            pulumi.set(__self__, "cluster_type_desc", cluster_type_desc)
        if collection_timestamp is not None:
            pulumi.set(__self__, "collection_timestamp", collection_timestamp)
        if db_failover is not None:
            pulumi.set(__self__, "db_failover", db_failover)
        if dtc_support is not None:
            pulumi.set(__self__, "dtc_support", dtc_support)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if is_contained is not None:
            pulumi.set(__self__, "is_contained", is_contained)
        if is_distributed is not None:
            pulumi.set(__self__, "is_distributed", is_distributed)
        if required_synchronized_secondaries_commit is not None:
            pulumi.set(__self__, "required_synchronized_secondaries_commit", required_synchronized_secondaries_commit)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="availabilityGroupId")
    def availability_group_id(self) -> pulumi.Input[str]:
        """
        Id GUID of the availability group.
        """
        return pulumi.get(self, "availability_group_id")

    @availability_group_id.setter
    def availability_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_group_id", value)

    @property
    @pulumi.getter(name="availabilityGroupName")
    def availability_group_name(self) -> pulumi.Input[str]:
        """
        The name of the availability group.
        """
        return pulumi.get(self, "availability_group_name")

    @availability_group_name.setter
    def availability_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_group_name", value)

    @property
    @pulumi.getter(name="basicFeatures")
    def basic_features(self) -> Optional[pulumi.Input[bool]]:
        """
        SQL Server basic availability group.
        """
        return pulumi.get(self, "basic_features")

    @basic_features.setter
    def basic_features(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "basic_features", value)

    @property
    @pulumi.getter(name="clusterTypeDesc")
    def cluster_type_desc(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server availability group cluster type description
        """
        return pulumi.get(self, "cluster_type_desc")

    @cluster_type_desc.setter
    def cluster_type_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_type_desc", value)

    @property
    @pulumi.getter(name="collectionTimestamp")
    def collection_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp for when the data was collected from the client machine.
        """
        return pulumi.get(self, "collection_timestamp")

    @collection_timestamp.setter
    def collection_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collection_timestamp", value)

    @property
    @pulumi.getter(name="dbFailover")
    def db_failover(self) -> Optional[pulumi.Input[bool]]:
        """
        SQL Server availability group failover for database health conditions.
        """
        return pulumi.get(self, "db_failover")

    @db_failover.setter
    def db_failover(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "db_failover", value)

    @property
    @pulumi.getter(name="dtcSupport")
    def dtc_support(self) -> Optional[pulumi.Input[bool]]:
        """
        SQL Server availability group DTC support enabled.
        """
        return pulumi.get(self, "dtc_support")

    @dtc_support.setter
    def dtc_support(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dtc_support", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the instance name which availability group primary is on.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="isContained")
    def is_contained(self) -> Optional[pulumi.Input[bool]]:
        """
        SQL Server availability group contained system databases.
        """
        return pulumi.get(self, "is_contained")

    @is_contained.setter
    def is_contained(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_contained", value)

    @property
    @pulumi.getter(name="isDistributed")
    def is_distributed(self) -> Optional[pulumi.Input[bool]]:
        """
        SQL Server distributed availability group.
        """
        return pulumi.get(self, "is_distributed")

    @is_distributed.setter
    def is_distributed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_distributed", value)

    @property
    @pulumi.getter(name="requiredSynchronizedSecondariesCommit")
    def required_synchronized_secondaries_commit(self) -> Optional[pulumi.Input[int]]:
        """
        Availability group required the number of synchronized secondary to commit.
        """
        return pulumi.get(self, "required_synchronized_secondaries_commit")

    @required_synchronized_secondaries_commit.setter
    def required_synchronized_secondaries_commit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "required_synchronized_secondaries_commit", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        SQL Server availability group current version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class SqlAvailabilityGroupReplicaResourcePropertiesArgs:
    def __init__(__self__, *,
                 configure: Optional[pulumi.Input['AvailabilityGroupConfigureArgs']] = None,
                 replica_id: Optional[pulumi.Input[str]] = None,
                 replica_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['AvailabilityGroupStateArgs']] = None):
        """
        The properties of Arc Sql availability group replica resource
        :param pulumi.Input['AvailabilityGroupConfigureArgs'] configure: null
        :param pulumi.Input[str] replica_id: ID GUID of the availability group.
        :param pulumi.Input[str] replica_name: the replica name.
        :param pulumi.Input['AvailabilityGroupStateArgs'] state: null
        """
        if configure is not None:
            pulumi.set(__self__, "configure", configure)
        if replica_id is not None:
            pulumi.set(__self__, "replica_id", replica_id)
        if replica_name is not None:
            pulumi.set(__self__, "replica_name", replica_name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def configure(self) -> Optional[pulumi.Input['AvailabilityGroupConfigureArgs']]:
        """
        null
        """
        return pulumi.get(self, "configure")

    @configure.setter
    def configure(self, value: Optional[pulumi.Input['AvailabilityGroupConfigureArgs']]):
        pulumi.set(self, "configure", value)

    @property
    @pulumi.getter(name="replicaId")
    def replica_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID GUID of the availability group.
        """
        return pulumi.get(self, "replica_id")

    @replica_id.setter
    def replica_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_id", value)

    @property
    @pulumi.getter(name="replicaName")
    def replica_name(self) -> Optional[pulumi.Input[str]]:
        """
        the replica name.
        """
        return pulumi.get(self, "replica_name")

    @replica_name.setter
    def replica_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['AvailabilityGroupStateArgs']]:
        """
        null
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['AvailabilityGroupStateArgs']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class SqlManagedInstanceK8sRawArgs:
    def __init__(__self__, *,
                 spec: Optional[pulumi.Input['SqlManagedInstanceK8sSpecArgs']] = None):
        """
        The raw kubernetes information.
        :param pulumi.Input['SqlManagedInstanceK8sSpecArgs'] spec: The kubernetes spec information.
        """
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['SqlManagedInstanceK8sSpecArgs']]:
        """
        The kubernetes spec information.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['SqlManagedInstanceK8sSpecArgs']]):
        pulumi.set(self, "spec", value)


@pulumi.input_type
class SqlManagedInstanceK8sSpecArgs:
    def __init__(__self__, *,
                 replicas: Optional[pulumi.Input[int]] = None,
                 scheduling: Optional[pulumi.Input['K8sSchedulingArgs']] = None):
        """
        The kubernetes spec information.
        :param pulumi.Input[int] replicas: This option specifies the number of SQL Managed Instance replicas that will be deployed in your Kubernetes cluster for high availability purposes. If sku.tier is BusinessCritical, allowed values are '2' or '3' with default of '3'. If sku.tier is GeneralPurpose, replicas must be '1'.
        :param pulumi.Input['K8sSchedulingArgs'] scheduling: The kubernetes scheduling information.
        """
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[int]]:
        """
        This option specifies the number of SQL Managed Instance replicas that will be deployed in your Kubernetes cluster for high availability purposes. If sku.tier is BusinessCritical, allowed values are '2' or '3' with default of '3'. If sku.tier is GeneralPurpose, replicas must be '1'.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['K8sSchedulingArgs']]:
        """
        The kubernetes scheduling information.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['K8sSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)


@pulumi.input_type
class SqlManagedInstancePropertiesArgs:
    def __init__(__self__, *,
                 active_directory_information: Optional[pulumi.Input['ActiveDirectoryInformationArgs']] = None,
                 admin: Optional[pulumi.Input[str]] = None,
                 basic_login_information: Optional[pulumi.Input['BasicLoginInformationArgs']] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 data_controller_id: Optional[pulumi.Input[str]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 extension_id: Optional[pulumi.Input[str]] = None,
                 k8s_raw: Optional[pulumi.Input['SqlManagedInstanceK8sRawArgs']] = None,
                 last_uploaded_date: Optional[pulumi.Input[str]] = None,
                 license_type: Optional[pulumi.Input[Union[str, 'ArcSqlManagedInstanceLicenseType']]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        Properties of sqlManagedInstance.
        :param pulumi.Input['ActiveDirectoryInformationArgs'] active_directory_information: Active Directory information related to this SQL Managed Instance.
        :param pulumi.Input[str] admin: The instance admin user
        :param pulumi.Input['BasicLoginInformationArgs'] basic_login_information: Username and password for basic authentication.
        :param pulumi.Input[str] cluster_id: If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
        :param pulumi.Input[str] data_controller_id: null
        :param pulumi.Input[str] end_time: The instance end time
        :param pulumi.Input[str] extension_id: If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
        :param pulumi.Input['SqlManagedInstanceK8sRawArgs'] k8s_raw: The raw kubernetes information
        :param pulumi.Input[str] last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date time
        :param pulumi.Input[Union[str, 'ArcSqlManagedInstanceLicenseType']] license_type: The license type to apply for this managed instance.
        :param pulumi.Input[str] start_time: The instance start time
        """
        if active_directory_information is not None:
            pulumi.set(__self__, "active_directory_information", active_directory_information)
        if admin is not None:
            pulumi.set(__self__, "admin", admin)
        if basic_login_information is not None:
            pulumi.set(__self__, "basic_login_information", basic_login_information)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if data_controller_id is not None:
            pulumi.set(__self__, "data_controller_id", data_controller_id)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if extension_id is not None:
            pulumi.set(__self__, "extension_id", extension_id)
        if k8s_raw is not None:
            pulumi.set(__self__, "k8s_raw", k8s_raw)
        if last_uploaded_date is not None:
            pulumi.set(__self__, "last_uploaded_date", last_uploaded_date)
        if license_type is None:
            license_type = 'BasePrice'
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="activeDirectoryInformation")
    def active_directory_information(self) -> Optional[pulumi.Input['ActiveDirectoryInformationArgs']]:
        """
        Active Directory information related to this SQL Managed Instance.
        """
        return pulumi.get(self, "active_directory_information")

    @active_directory_information.setter
    def active_directory_information(self, value: Optional[pulumi.Input['ActiveDirectoryInformationArgs']]):
        pulumi.set(self, "active_directory_information", value)

    @property
    @pulumi.getter
    def admin(self) -> Optional[pulumi.Input[str]]:
        """
        The instance admin user
        """
        return pulumi.get(self, "admin")

    @admin.setter
    def admin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin", value)

    @property
    @pulumi.getter(name="basicLoginInformation")
    def basic_login_information(self) -> Optional[pulumi.Input['BasicLoginInformationArgs']]:
        """
        Username and password for basic authentication.
        """
        return pulumi.get(self, "basic_login_information")

    @basic_login_information.setter
    def basic_login_information(self, value: Optional[pulumi.Input['BasicLoginInformationArgs']]):
        pulumi.set(self, "basic_login_information", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="dataControllerId")
    def data_controller_id(self) -> Optional[pulumi.Input[str]]:
        """
        null
        """
        return pulumi.get(self, "data_controller_id")

    @data_controller_id.setter
    def data_controller_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_controller_id", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The instance end time
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="extensionId")
    def extension_id(self) -> Optional[pulumi.Input[str]]:
        """
        If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
        """
        return pulumi.get(self, "extension_id")

    @extension_id.setter
    def extension_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extension_id", value)

    @property
    @pulumi.getter(name="k8sRaw")
    def k8s_raw(self) -> Optional[pulumi.Input['SqlManagedInstanceK8sRawArgs']]:
        """
        The raw kubernetes information
        """
        return pulumi.get(self, "k8s_raw")

    @k8s_raw.setter
    def k8s_raw(self, value: Optional[pulumi.Input['SqlManagedInstanceK8sRawArgs']]):
        pulumi.set(self, "k8s_raw", value)

    @property
    @pulumi.getter(name="lastUploadedDate")
    def last_uploaded_date(self) -> Optional[pulumi.Input[str]]:
        """
        Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "last_uploaded_date")

    @last_uploaded_date.setter
    def last_uploaded_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_uploaded_date", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[Union[str, 'ArcSqlManagedInstanceLicenseType']]]:
        """
        The license type to apply for this managed instance.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[Union[str, 'ArcSqlManagedInstanceLicenseType']]]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The instance start time
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class SqlManagedInstanceSkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input['SqlManagedInstanceSkuName'],
                 capacity: Optional[pulumi.Input[int]] = None,
                 dev: Optional[pulumi.Input[bool]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input['SqlManagedInstanceSkuTier']] = None):
        """
        The resource model definition representing SKU for Azure Managed Instance - Azure Arc
        :param pulumi.Input['SqlManagedInstanceSkuName'] name: The name of the SKU.
        :param pulumi.Input[int] capacity: The SKU capacity
        :param pulumi.Input[bool] dev: Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        :param pulumi.Input[str] family: The SKU family
        :param pulumi.Input[str] size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        :param pulumi.Input['SqlManagedInstanceSkuTier'] tier: The pricing tier for the instance.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if dev is None:
            dev = True
        if dev is not None:
            pulumi.set(__self__, "dev", dev)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is None:
            tier = 'GeneralPurpose'
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input['SqlManagedInstanceSkuName']:
        """
        The name of the SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input['SqlManagedInstanceSkuName']):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The SKU capacity
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def dev(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        """
        return pulumi.get(self, "dev")

    @dev.setter
    def dev(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dev", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU family
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input['SqlManagedInstanceSkuTier']]:
        """
        The pricing tier for the instance.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input['SqlManagedInstanceSkuTier']]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SqlServerAvailabilityGroupResourcePropertiesArgs:
    def __init__(__self__, *,
                 availability_group_id: pulumi.Input[str],
                 availability_group_name: Optional[pulumi.Input[str]] = None,
                 configure: Optional[pulumi.Input['AvailabilityGroupConfigureArgs']] = None,
                 state: Optional[pulumi.Input['AvailabilityGroupStateArgs']] = None):
        """
        The properties of Arc Sql Server availability group resource
        :param pulumi.Input[str] availability_group_id: ID GUID of the availability group.
        :param pulumi.Input[str] availability_group_name: the availability group name.
        :param pulumi.Input['AvailabilityGroupConfigureArgs'] configure: null
        :param pulumi.Input['AvailabilityGroupStateArgs'] state: null
        """
        pulumi.set(__self__, "availability_group_id", availability_group_id)
        if availability_group_name is not None:
            pulumi.set(__self__, "availability_group_name", availability_group_name)
        if configure is not None:
            pulumi.set(__self__, "configure", configure)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="availabilityGroupId")
    def availability_group_id(self) -> pulumi.Input[str]:
        """
        ID GUID of the availability group.
        """
        return pulumi.get(self, "availability_group_id")

    @availability_group_id.setter
    def availability_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_group_id", value)

    @property
    @pulumi.getter(name="availabilityGroupName")
    def availability_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        the availability group name.
        """
        return pulumi.get(self, "availability_group_name")

    @availability_group_name.setter
    def availability_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_group_name", value)

    @property
    @pulumi.getter
    def configure(self) -> Optional[pulumi.Input['AvailabilityGroupConfigureArgs']]:
        """
        null
        """
        return pulumi.get(self, "configure")

    @configure.setter
    def configure(self, value: Optional[pulumi.Input['AvailabilityGroupConfigureArgs']]):
        pulumi.set(self, "configure", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['AvailabilityGroupStateArgs']]:
        """
        null
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['AvailabilityGroupStateArgs']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class SqlServerDatabaseResourcePropertiesBackupInformationArgs:
    def __init__(__self__, *,
                 last_full_backup: Optional[pulumi.Input[str]] = None,
                 last_log_backup: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] last_full_backup: Date time of last full backup.
        :param pulumi.Input[str] last_log_backup: Date time of last log backup.
        """
        if last_full_backup is not None:
            pulumi.set(__self__, "last_full_backup", last_full_backup)
        if last_log_backup is not None:
            pulumi.set(__self__, "last_log_backup", last_log_backup)

    @property
    @pulumi.getter(name="lastFullBackup")
    def last_full_backup(self) -> Optional[pulumi.Input[str]]:
        """
        Date time of last full backup.
        """
        return pulumi.get(self, "last_full_backup")

    @last_full_backup.setter
    def last_full_backup(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_full_backup", value)

    @property
    @pulumi.getter(name="lastLogBackup")
    def last_log_backup(self) -> Optional[pulumi.Input[str]]:
        """
        Date time of last log backup.
        """
        return pulumi.get(self, "last_log_backup")

    @last_log_backup.setter
    def last_log_backup(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_log_backup", value)


@pulumi.input_type
class SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs:
    def __init__(__self__, *,
                 is_auto_close_on: Optional[pulumi.Input[bool]] = None,
                 is_auto_create_stats_on: Optional[pulumi.Input[bool]] = None,
                 is_auto_shrink_on: Optional[pulumi.Input[bool]] = None,
                 is_auto_update_stats_on: Optional[pulumi.Input[bool]] = None,
                 is_encrypted: Optional[pulumi.Input[bool]] = None,
                 is_memory_optimization_enabled: Optional[pulumi.Input[bool]] = None,
                 is_remote_data_archive_enabled: Optional[pulumi.Input[bool]] = None,
                 is_trustworthy_on: Optional[pulumi.Input[bool]] = None):
        """
        List of features that are enabled for the database
        """
        if is_auto_close_on is not None:
            pulumi.set(__self__, "is_auto_close_on", is_auto_close_on)
        if is_auto_create_stats_on is not None:
            pulumi.set(__self__, "is_auto_create_stats_on", is_auto_create_stats_on)
        if is_auto_shrink_on is not None:
            pulumi.set(__self__, "is_auto_shrink_on", is_auto_shrink_on)
        if is_auto_update_stats_on is not None:
            pulumi.set(__self__, "is_auto_update_stats_on", is_auto_update_stats_on)
        if is_encrypted is not None:
            pulumi.set(__self__, "is_encrypted", is_encrypted)
        if is_memory_optimization_enabled is not None:
            pulumi.set(__self__, "is_memory_optimization_enabled", is_memory_optimization_enabled)
        if is_remote_data_archive_enabled is not None:
            pulumi.set(__self__, "is_remote_data_archive_enabled", is_remote_data_archive_enabled)
        if is_trustworthy_on is not None:
            pulumi.set(__self__, "is_trustworthy_on", is_trustworthy_on)

    @property
    @pulumi.getter(name="isAutoCloseOn")
    def is_auto_close_on(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_auto_close_on")

    @is_auto_close_on.setter
    def is_auto_close_on(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_close_on", value)

    @property
    @pulumi.getter(name="isAutoCreateStatsOn")
    def is_auto_create_stats_on(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_auto_create_stats_on")

    @is_auto_create_stats_on.setter
    def is_auto_create_stats_on(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_create_stats_on", value)

    @property
    @pulumi.getter(name="isAutoShrinkOn")
    def is_auto_shrink_on(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_auto_shrink_on")

    @is_auto_shrink_on.setter
    def is_auto_shrink_on(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_shrink_on", value)

    @property
    @pulumi.getter(name="isAutoUpdateStatsOn")
    def is_auto_update_stats_on(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_auto_update_stats_on")

    @is_auto_update_stats_on.setter
    def is_auto_update_stats_on(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_update_stats_on", value)

    @property
    @pulumi.getter(name="isEncrypted")
    def is_encrypted(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_encrypted")

    @is_encrypted.setter
    def is_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_encrypted", value)

    @property
    @pulumi.getter(name="isMemoryOptimizationEnabled")
    def is_memory_optimization_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_memory_optimization_enabled")

    @is_memory_optimization_enabled.setter
    def is_memory_optimization_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_memory_optimization_enabled", value)

    @property
    @pulumi.getter(name="isRemoteDataArchiveEnabled")
    def is_remote_data_archive_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_remote_data_archive_enabled")

    @is_remote_data_archive_enabled.setter
    def is_remote_data_archive_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_remote_data_archive_enabled", value)

    @property
    @pulumi.getter(name="isTrustworthyOn")
    def is_trustworthy_on(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_trustworthy_on")

    @is_trustworthy_on.setter
    def is_trustworthy_on(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_trustworthy_on", value)


@pulumi.input_type
class SqlServerDatabaseResourcePropertiesArgs:
    def __init__(__self__, *,
                 backup_information: Optional[pulumi.Input['SqlServerDatabaseResourcePropertiesBackupInformationArgs']] = None,
                 collation_name: Optional[pulumi.Input[str]] = None,
                 compatibility_level: Optional[pulumi.Input[int]] = None,
                 database_creation_date: Optional[pulumi.Input[str]] = None,
                 database_options: Optional[pulumi.Input['SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs']] = None,
                 is_read_only: Optional[pulumi.Input[bool]] = None,
                 recovery_mode: Optional[pulumi.Input[Union[str, 'RecoveryMode']]] = None,
                 size_mb: Optional[pulumi.Input[float]] = None,
                 space_available_mb: Optional[pulumi.Input[float]] = None,
                 state: Optional[pulumi.Input[Union[str, 'DatabaseState']]] = None):
        """
        The properties of Arc Sql Server database resource
        :param pulumi.Input[str] collation_name: Collation of the database.
        :param pulumi.Input[int] compatibility_level: Compatibility level of the database
        :param pulumi.Input[str] database_creation_date: Creation date of the database.
        :param pulumi.Input['SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs'] database_options: List of features that are enabled for the database
        :param pulumi.Input[bool] is_read_only: Whether the database is read only or not.
        :param pulumi.Input[Union[str, 'RecoveryMode']] recovery_mode: Status of the database.
        :param pulumi.Input[float] size_mb: Size of the database.
        :param pulumi.Input[float] space_available_mb: Space left of the database.
        :param pulumi.Input[Union[str, 'DatabaseState']] state: State of the database.
        """
        if backup_information is not None:
            pulumi.set(__self__, "backup_information", backup_information)
        if collation_name is not None:
            pulumi.set(__self__, "collation_name", collation_name)
        if compatibility_level is not None:
            pulumi.set(__self__, "compatibility_level", compatibility_level)
        if database_creation_date is not None:
            pulumi.set(__self__, "database_creation_date", database_creation_date)
        if database_options is not None:
            pulumi.set(__self__, "database_options", database_options)
        if is_read_only is not None:
            pulumi.set(__self__, "is_read_only", is_read_only)
        if recovery_mode is not None:
            pulumi.set(__self__, "recovery_mode", recovery_mode)
        if size_mb is not None:
            pulumi.set(__self__, "size_mb", size_mb)
        if space_available_mb is not None:
            pulumi.set(__self__, "space_available_mb", space_available_mb)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="backupInformation")
    def backup_information(self) -> Optional[pulumi.Input['SqlServerDatabaseResourcePropertiesBackupInformationArgs']]:
        return pulumi.get(self, "backup_information")

    @backup_information.setter
    def backup_information(self, value: Optional[pulumi.Input['SqlServerDatabaseResourcePropertiesBackupInformationArgs']]):
        pulumi.set(self, "backup_information", value)

    @property
    @pulumi.getter(name="collationName")
    def collation_name(self) -> Optional[pulumi.Input[str]]:
        """
        Collation of the database.
        """
        return pulumi.get(self, "collation_name")

    @collation_name.setter
    def collation_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collation_name", value)

    @property
    @pulumi.getter(name="compatibilityLevel")
    def compatibility_level(self) -> Optional[pulumi.Input[int]]:
        """
        Compatibility level of the database
        """
        return pulumi.get(self, "compatibility_level")

    @compatibility_level.setter
    def compatibility_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compatibility_level", value)

    @property
    @pulumi.getter(name="databaseCreationDate")
    def database_creation_date(self) -> Optional[pulumi.Input[str]]:
        """
        Creation date of the database.
        """
        return pulumi.get(self, "database_creation_date")

    @database_creation_date.setter
    def database_creation_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_creation_date", value)

    @property
    @pulumi.getter(name="databaseOptions")
    def database_options(self) -> Optional[pulumi.Input['SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs']]:
        """
        List of features that are enabled for the database
        """
        return pulumi.get(self, "database_options")

    @database_options.setter
    def database_options(self, value: Optional[pulumi.Input['SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs']]):
        pulumi.set(self, "database_options", value)

    @property
    @pulumi.getter(name="isReadOnly")
    def is_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the database is read only or not.
        """
        return pulumi.get(self, "is_read_only")

    @is_read_only.setter
    def is_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_read_only", value)

    @property
    @pulumi.getter(name="recoveryMode")
    def recovery_mode(self) -> Optional[pulumi.Input[Union[str, 'RecoveryMode']]]:
        """
        Status of the database.
        """
        return pulumi.get(self, "recovery_mode")

    @recovery_mode.setter
    def recovery_mode(self, value: Optional[pulumi.Input[Union[str, 'RecoveryMode']]]):
        pulumi.set(self, "recovery_mode", value)

    @property
    @pulumi.getter(name="sizeMB")
    def size_mb(self) -> Optional[pulumi.Input[float]]:
        """
        Size of the database.
        """
        return pulumi.get(self, "size_mb")

    @size_mb.setter
    def size_mb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "size_mb", value)

    @property
    @pulumi.getter(name="spaceAvailableMB")
    def space_available_mb(self) -> Optional[pulumi.Input[float]]:
        """
        Space left of the database.
        """
        return pulumi.get(self, "space_available_mb")

    @space_available_mb.setter
    def space_available_mb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "space_available_mb", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'DatabaseState']]]:
        """
        State of the database.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'DatabaseState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class SqlServerInstancePropertiesArgs:
    def __init__(__self__, *,
                 container_resource_id: pulumi.Input[str],
                 status: pulumi.Input[Union[str, 'ConnectionStatus']],
                 azure_defender_status: Optional[pulumi.Input[Union[str, 'DefenderStatus']]] = None,
                 azure_defender_status_last_updated: Optional[pulumi.Input[str]] = None,
                 collation: Optional[pulumi.Input[str]] = None,
                 cores: Optional[pulumi.Input[str]] = None,
                 current_version: Optional[pulumi.Input[str]] = None,
                 edition: Optional[pulumi.Input[Union[str, 'EditionType']]] = None,
                 host_type: Optional[pulumi.Input[Union[str, 'HostType']]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 license_type: Optional[pulumi.Input[Union[str, 'ArcSqlServerLicenseType']]] = None,
                 patch_level: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 tcp_dynamic_ports: Optional[pulumi.Input[str]] = None,
                 tcp_static_ports: Optional[pulumi.Input[str]] = None,
                 v_core: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[Union[str, 'SqlVersion']]] = None):
        """
        Properties of SqlServerInstance.
        :param pulumi.Input[str] container_resource_id: ARM Resource id of the container resource (Azure Arc for Servers).
        :param pulumi.Input[Union[str, 'ConnectionStatus']] status: The cloud connectivity status.
        :param pulumi.Input[Union[str, 'DefenderStatus']] azure_defender_status: Status of Azure Defender.
        :param pulumi.Input[str] azure_defender_status_last_updated: Timestamp of last Azure Defender status update.
        :param pulumi.Input[str] collation: SQL Server collation.
        :param pulumi.Input[str] cores: The number of total cores of the Operating System Environment (OSE) hosting the SQL Server instance.
        :param pulumi.Input[str] current_version: SQL Server current version.
        :param pulumi.Input[Union[str, 'EditionType']] edition: SQL Server edition.
        :param pulumi.Input[Union[str, 'HostType']] host_type: Type of host for Azure Arc SQL Server
        :param pulumi.Input[str] instance_name: SQL Server instance name.
        :param pulumi.Input[Union[str, 'ArcSqlServerLicenseType']] license_type: SQL Server license type.
        :param pulumi.Input[str] patch_level: SQL Server update level.
        :param pulumi.Input[str] product_id: SQL Server product ID.
        :param pulumi.Input[str] tcp_dynamic_ports: Dynamic TCP ports used by SQL Server.
        :param pulumi.Input[str] tcp_static_ports: Static TCP ports used by SQL Server.
        :param pulumi.Input[str] v_core: The number of logical processors used by the SQL Server instance.
        :param pulumi.Input[Union[str, 'SqlVersion']] version: SQL Server version.
        """
        pulumi.set(__self__, "container_resource_id", container_resource_id)
        pulumi.set(__self__, "status", status)
        if azure_defender_status is not None:
            pulumi.set(__self__, "azure_defender_status", azure_defender_status)
        if azure_defender_status_last_updated is not None:
            pulumi.set(__self__, "azure_defender_status_last_updated", azure_defender_status_last_updated)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if cores is not None:
            pulumi.set(__self__, "cores", cores)
        if current_version is not None:
            pulumi.set(__self__, "current_version", current_version)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if host_type is not None:
            pulumi.set(__self__, "host_type", host_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if patch_level is not None:
            pulumi.set(__self__, "patch_level", patch_level)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if tcp_dynamic_ports is not None:
            pulumi.set(__self__, "tcp_dynamic_ports", tcp_dynamic_ports)
        if tcp_static_ports is not None:
            pulumi.set(__self__, "tcp_static_ports", tcp_static_ports)
        if v_core is not None:
            pulumi.set(__self__, "v_core", v_core)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="containerResourceId")
    def container_resource_id(self) -> pulumi.Input[str]:
        """
        ARM Resource id of the container resource (Azure Arc for Servers).
        """
        return pulumi.get(self, "container_resource_id")

    @container_resource_id.setter
    def container_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_resource_id", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[Union[str, 'ConnectionStatus']]:
        """
        The cloud connectivity status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[Union[str, 'ConnectionStatus']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="azureDefenderStatus")
    def azure_defender_status(self) -> Optional[pulumi.Input[Union[str, 'DefenderStatus']]]:
        """
        Status of Azure Defender.
        """
        return pulumi.get(self, "azure_defender_status")

    @azure_defender_status.setter
    def azure_defender_status(self, value: Optional[pulumi.Input[Union[str, 'DefenderStatus']]]):
        pulumi.set(self, "azure_defender_status", value)

    @property
    @pulumi.getter(name="azureDefenderStatusLastUpdated")
    def azure_defender_status_last_updated(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of last Azure Defender status update.
        """
        return pulumi.get(self, "azure_defender_status_last_updated")

    @azure_defender_status_last_updated.setter
    def azure_defender_status_last_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_defender_status_last_updated", value)

    @property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server collation.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collation", value)

    @property
    @pulumi.getter
    def cores(self) -> Optional[pulumi.Input[str]]:
        """
        The number of total cores of the Operating System Environment (OSE) hosting the SQL Server instance.
        """
        return pulumi.get(self, "cores")

    @cores.setter
    def cores(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cores", value)

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server current version.
        """
        return pulumi.get(self, "current_version")

    @current_version.setter
    def current_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_version", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[Union[str, 'EditionType']]]:
        """
        SQL Server edition.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[Union[str, 'EditionType']]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="hostType")
    def host_type(self) -> Optional[pulumi.Input[Union[str, 'HostType']]]:
        """
        Type of host for Azure Arc SQL Server
        """
        return pulumi.get(self, "host_type")

    @host_type.setter
    def host_type(self, value: Optional[pulumi.Input[Union[str, 'HostType']]]):
        pulumi.set(self, "host_type", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server instance name.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[Union[str, 'ArcSqlServerLicenseType']]]:
        """
        SQL Server license type.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[Union[str, 'ArcSqlServerLicenseType']]]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="patchLevel")
    def patch_level(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server update level.
        """
        return pulumi.get(self, "patch_level")

    @patch_level.setter
    def patch_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "patch_level", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server product ID.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="tcpDynamicPorts")
    def tcp_dynamic_ports(self) -> Optional[pulumi.Input[str]]:
        """
        Dynamic TCP ports used by SQL Server.
        """
        return pulumi.get(self, "tcp_dynamic_ports")

    @tcp_dynamic_ports.setter
    def tcp_dynamic_ports(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tcp_dynamic_ports", value)

    @property
    @pulumi.getter(name="tcpStaticPorts")
    def tcp_static_ports(self) -> Optional[pulumi.Input[str]]:
        """
        Static TCP ports used by SQL Server.
        """
        return pulumi.get(self, "tcp_static_ports")

    @tcp_static_ports.setter
    def tcp_static_ports(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tcp_static_ports", value)

    @property
    @pulumi.getter(name="vCore")
    def v_core(self) -> Optional[pulumi.Input[str]]:
        """
        The number of logical processors used by the SQL Server instance.
        """
        return pulumi.get(self, "v_core")

    @v_core.setter
    def v_core(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "v_core", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[Union[str, 'SqlVersion']]]:
        """
        SQL Server version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[Union[str, 'SqlVersion']]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class UploadServicePrincipalArgs:
    def __init__(__self__, *,
                 authority: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Service principal for uploading billing, metrics and logs.
        :param pulumi.Input[str] authority: Authority for the service principal. Example: https://login.microsoftonline.com/
        :param pulumi.Input[str] client_id: Client ID of the service principal for uploading data.
        :param pulumi.Input[str] client_secret: Secret of the service principal
        :param pulumi.Input[str] tenant_id: Tenant ID of the service principal.
        """
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def authority(self) -> Optional[pulumi.Input[str]]:
        """
        Authority for the service principal. Example: https://login.microsoftonline.com/
        """
        return pulumi.get(self, "authority")

    @authority.setter
    def authority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authority", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Client ID of the service principal for uploading data.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Secret of the service principal
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenant ID of the service principal.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class UploadWatermarkArgs:
    def __init__(__self__, *,
                 logs: Optional[pulumi.Input[str]] = None,
                 metrics: Optional[pulumi.Input[str]] = None,
                 usages: Optional[pulumi.Input[str]] = None):
        """
        Properties on upload watermark.  Mostly timestamp for each upload data type
        :param pulumi.Input[str] logs: Last uploaded date for logs from kubernetes cluster. Defaults to current date time
        :param pulumi.Input[str] metrics: Last uploaded date for metrics from kubernetes cluster. Defaults to current date time
        :param pulumi.Input[str] usages: Last uploaded date for usages from kubernetes cluster. Defaults to current date time
        """
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if usages is not None:
            pulumi.set(__self__, "usages", usages)

    @property
    @pulumi.getter
    def logs(self) -> Optional[pulumi.Input[str]]:
        """
        Last uploaded date for logs from kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logs", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[str]]:
        """
        Last uploaded date for metrics from kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter
    def usages(self) -> Optional[pulumi.Input[str]]:
        """
        Last uploaded date for usages from kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "usages")

    @usages.setter
    def usages(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "usages", value)


