# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AGReplicasResponse',
    'ActiveDirectoryConnectorDNSDetailsResponse',
    'ActiveDirectoryConnectorDomainDetailsResponse',
    'ActiveDirectoryConnectorPropertiesResponse',
    'ActiveDirectoryConnectorSpecResponse',
    'ActiveDirectoryConnectorStatusResponse',
    'ActiveDirectoryDomainControllerResponse',
    'ActiveDirectoryDomainControllersResponse',
    'BasicLoginInformationResponse',
    'DataControllerPropertiesResponse',
    'ExtendedLocationResponse',
    'FailoverGroupPropertiesResponse',
    'FailoverGroupSpecResponse',
    'FailoverGroupStatusResponse',
    'K8sResourceRequirementsResponse',
    'K8sSchedulingOptionsResponse',
    'K8sSchedulingResponse',
    'LogAnalyticsWorkspaceConfigResponse',
    'OnPremisePropertyResponse',
    'PostgresInstancePropertiesResponse',
    'PostgresInstanceSkuResponse',
    'SqlManagedInstanceK8sRawResponse',
    'SqlManagedInstanceK8sSpecResponse',
    'SqlManagedInstancePropertiesResponse',
    'SqlManagedInstanceSkuResponse',
    'SqlServerDatabaseResourcePropertiesResponse',
    'SqlServerDatabaseResourcePropertiesResponseBackupInformation',
    'SqlServerDatabaseResourcePropertiesResponseDatabaseOptions',
    'SqlServerInstancePropertiesResponse',
    'SystemDataResponse',
    'UploadServicePrincipalResponse',
    'UploadWatermarkResponse',
]

@pulumi.output_type
class AGReplicasResponse(dict):
    """
    The information about each failover group replica.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityMode":
            suggest = "availability_mode"
        elif key == "connectedState":
            suggest = "connected_state"
        elif key == "healthState":
            suggest = "health_state"
        elif key == "replicaName":
            suggest = "replica_name"
        elif key == "secondaryRoleAllowConnections":
            suggest = "secondary_role_allow_connections"
        elif key == "synchronizationState":
            suggest = "synchronization_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AGReplicasResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AGReplicasResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AGReplicasResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_mode: Optional[str] = None,
                 connected_state: Optional[str] = None,
                 health_state: Optional[str] = None,
                 replica_name: Optional[str] = None,
                 role: Optional[str] = None,
                 secondary_role_allow_connections: Optional[str] = None,
                 synchronization_state: Optional[str] = None):
        """
        The information about each failover group replica.
        :param str availability_mode: The availability mode of the replica.
        :param str connected_state: The connected state of the replica.
        :param str health_state: The health state of the replica.
        :param str replica_name: The replica name.
        :param str role: The role of the replica.
        :param str secondary_role_allow_connections: The secondary role allowed connections.
        :param str synchronization_state: The synchronization state of the availability group replicas.
        """
        if availability_mode is not None:
            pulumi.set(__self__, "availability_mode", availability_mode)
        if connected_state is not None:
            pulumi.set(__self__, "connected_state", connected_state)
        if health_state is not None:
            pulumi.set(__self__, "health_state", health_state)
        if replica_name is not None:
            pulumi.set(__self__, "replica_name", replica_name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if secondary_role_allow_connections is not None:
            pulumi.set(__self__, "secondary_role_allow_connections", secondary_role_allow_connections)
        if synchronization_state is not None:
            pulumi.set(__self__, "synchronization_state", synchronization_state)

    @property
    @pulumi.getter(name="availabilityMode")
    def availability_mode(self) -> Optional[str]:
        """
        The availability mode of the replica.
        """
        return pulumi.get(self, "availability_mode")

    @property
    @pulumi.getter(name="connectedState")
    def connected_state(self) -> Optional[str]:
        """
        The connected state of the replica.
        """
        return pulumi.get(self, "connected_state")

    @property
    @pulumi.getter(name="healthState")
    def health_state(self) -> Optional[str]:
        """
        The health state of the replica.
        """
        return pulumi.get(self, "health_state")

    @property
    @pulumi.getter(name="replicaName")
    def replica_name(self) -> Optional[str]:
        """
        The replica name.
        """
        return pulumi.get(self, "replica_name")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        The role of the replica.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="secondaryRoleAllowConnections")
    def secondary_role_allow_connections(self) -> Optional[str]:
        """
        The secondary role allowed connections.
        """
        return pulumi.get(self, "secondary_role_allow_connections")

    @property
    @pulumi.getter(name="synchronizationState")
    def synchronization_state(self) -> Optional[str]:
        """
        The synchronization state of the availability group replicas.
        """
        return pulumi.get(self, "synchronization_state")


@pulumi.output_type
class ActiveDirectoryConnectorDNSDetailsResponse(dict):
    """
    DNS server details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nameserverIPAddresses":
            suggest = "nameserver_ip_addresses"
        elif key == "domainName":
            suggest = "domain_name"
        elif key == "preferK8sDnsForPtrLookups":
            suggest = "prefer_k8s_dns_for_ptr_lookups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActiveDirectoryConnectorDNSDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActiveDirectoryConnectorDNSDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActiveDirectoryConnectorDNSDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 nameserver_ip_addresses: Sequence[str],
                 domain_name: Optional[str] = None,
                 prefer_k8s_dns_for_ptr_lookups: Optional[bool] = None,
                 replicas: Optional[float] = None):
        """
        DNS server details
        :param Sequence[str] nameserver_ip_addresses: List of Active Directory DNS server IP addresses.
        :param str domain_name: DNS domain name for which DNS lookups should be forwarded to the Active Directory DNS servers.
        :param bool prefer_k8s_dns_for_ptr_lookups: Flag indicating whether to prefer Kubernetes DNS server response over AD DNS server response for IP address lookups.
        :param float replicas: Replica count for DNS proxy service. Default value is 1.
        """
        pulumi.set(__self__, "nameserver_ip_addresses", nameserver_ip_addresses)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if prefer_k8s_dns_for_ptr_lookups is None:
            prefer_k8s_dns_for_ptr_lookups = True
        if prefer_k8s_dns_for_ptr_lookups is not None:
            pulumi.set(__self__, "prefer_k8s_dns_for_ptr_lookups", prefer_k8s_dns_for_ptr_lookups)
        if replicas is None:
            replicas = 1
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)

    @property
    @pulumi.getter(name="nameserverIPAddresses")
    def nameserver_ip_addresses(self) -> Sequence[str]:
        """
        List of Active Directory DNS server IP addresses.
        """
        return pulumi.get(self, "nameserver_ip_addresses")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        DNS domain name for which DNS lookups should be forwarded to the Active Directory DNS servers.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="preferK8sDnsForPtrLookups")
    def prefer_k8s_dns_for_ptr_lookups(self) -> Optional[bool]:
        """
        Flag indicating whether to prefer Kubernetes DNS server response over AD DNS server response for IP address lookups.
        """
        return pulumi.get(self, "prefer_k8s_dns_for_ptr_lookups")

    @property
    @pulumi.getter
    def replicas(self) -> Optional[float]:
        """
        Replica count for DNS proxy service. Default value is 1.
        """
        return pulumi.get(self, "replicas")


@pulumi.output_type
class ActiveDirectoryConnectorDomainDetailsResponse(dict):
    """
    Active Directory domain details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainControllers":
            suggest = "domain_controllers"
        elif key == "netbiosDomainName":
            suggest = "netbios_domain_name"
        elif key == "ouDistinguishedName":
            suggest = "ou_distinguished_name"
        elif key == "serviceAccountProvisioning":
            suggest = "service_account_provisioning"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActiveDirectoryConnectorDomainDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActiveDirectoryConnectorDomainDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActiveDirectoryConnectorDomainDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 realm: str,
                 domain_controllers: Optional['outputs.ActiveDirectoryDomainControllersResponse'] = None,
                 netbios_domain_name: Optional[str] = None,
                 ou_distinguished_name: Optional[str] = None,
                 service_account_provisioning: Optional[str] = None):
        """
        Active Directory domain details
        :param str realm: Name (uppercase) of the Active Directory domain that this AD connector will be associated with.
        :param 'ActiveDirectoryDomainControllersResponse' domain_controllers: null
        :param str netbios_domain_name: NETBIOS name of the Active Directory domain.
        :param str ou_distinguished_name: The distinguished name of the Active Directory Organizational Unit.
        :param str service_account_provisioning: The service account provisioning mode for this Active Directory connector.
        """
        pulumi.set(__self__, "realm", realm)
        if domain_controllers is not None:
            pulumi.set(__self__, "domain_controllers", domain_controllers)
        if netbios_domain_name is not None:
            pulumi.set(__self__, "netbios_domain_name", netbios_domain_name)
        if ou_distinguished_name is not None:
            pulumi.set(__self__, "ou_distinguished_name", ou_distinguished_name)
        if service_account_provisioning is None:
            service_account_provisioning = 'manual'
        if service_account_provisioning is not None:
            pulumi.set(__self__, "service_account_provisioning", service_account_provisioning)

    @property
    @pulumi.getter
    def realm(self) -> str:
        """
        Name (uppercase) of the Active Directory domain that this AD connector will be associated with.
        """
        return pulumi.get(self, "realm")

    @property
    @pulumi.getter(name="domainControllers")
    def domain_controllers(self) -> Optional['outputs.ActiveDirectoryDomainControllersResponse']:
        """
        null
        """
        return pulumi.get(self, "domain_controllers")

    @property
    @pulumi.getter(name="netbiosDomainName")
    def netbios_domain_name(self) -> Optional[str]:
        """
        NETBIOS name of the Active Directory domain.
        """
        return pulumi.get(self, "netbios_domain_name")

    @property
    @pulumi.getter(name="ouDistinguishedName")
    def ou_distinguished_name(self) -> Optional[str]:
        """
        The distinguished name of the Active Directory Organizational Unit.
        """
        return pulumi.get(self, "ou_distinguished_name")

    @property
    @pulumi.getter(name="serviceAccountProvisioning")
    def service_account_provisioning(self) -> Optional[str]:
        """
        The service account provisioning mode for this Active Directory connector.
        """
        return pulumi.get(self, "service_account_provisioning")


@pulumi.output_type
class ActiveDirectoryConnectorPropertiesResponse(dict):
    """
    The properties of an Active Directory connector resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "domainServiceAccountLoginInformation":
            suggest = "domain_service_account_login_information"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActiveDirectoryConnectorPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActiveDirectoryConnectorPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActiveDirectoryConnectorPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 spec: 'outputs.ActiveDirectoryConnectorSpecResponse',
                 domain_service_account_login_information: Optional['outputs.BasicLoginInformationResponse'] = None,
                 status: Optional['outputs.ActiveDirectoryConnectorStatusResponse'] = None):
        """
        The properties of an Active Directory connector resource
        :param str provisioning_state: The provisioning state of the Active Directory connector resource.
        :param 'ActiveDirectoryConnectorSpecResponse' spec: null
        :param 'BasicLoginInformationResponse' domain_service_account_login_information: Username and password for domain service account authentication.
        :param 'ActiveDirectoryConnectorStatusResponse' status: null
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "spec", spec)
        if domain_service_account_login_information is not None:
            pulumi.set(__self__, "domain_service_account_login_information", domain_service_account_login_information)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the Active Directory connector resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ActiveDirectoryConnectorSpecResponse':
        """
        null
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="domainServiceAccountLoginInformation")
    def domain_service_account_login_information(self) -> Optional['outputs.BasicLoginInformationResponse']:
        """
        Username and password for domain service account authentication.
        """
        return pulumi.get(self, "domain_service_account_login_information")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.ActiveDirectoryConnectorStatusResponse']:
        """
        null
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ActiveDirectoryConnectorSpecResponse(dict):
    """
    The specifications of the AD Kubernetes resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectory":
            suggest = "active_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActiveDirectoryConnectorSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActiveDirectoryConnectorSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActiveDirectoryConnectorSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_directory: 'outputs.ActiveDirectoryConnectorDomainDetailsResponse',
                 dns: 'outputs.ActiveDirectoryConnectorDNSDetailsResponse'):
        """
        The specifications of the AD Kubernetes resource.
        :param 'ActiveDirectoryConnectorDomainDetailsResponse' active_directory: null
        :param 'ActiveDirectoryConnectorDNSDetailsResponse' dns: null
        """
        pulumi.set(__self__, "active_directory", active_directory)
        pulumi.set(__self__, "dns", dns)

    @property
    @pulumi.getter(name="activeDirectory")
    def active_directory(self) -> 'outputs.ActiveDirectoryConnectorDomainDetailsResponse':
        """
        null
        """
        return pulumi.get(self, "active_directory")

    @property
    @pulumi.getter
    def dns(self) -> 'outputs.ActiveDirectoryConnectorDNSDetailsResponse':
        """
        null
        """
        return pulumi.get(self, "dns")


@pulumi.output_type
class ActiveDirectoryConnectorStatusResponse(dict):
    """
    The status of the Kubernetes custom resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdateTime":
            suggest = "last_update_time"
        elif key == "observedGeneration":
            suggest = "observed_generation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActiveDirectoryConnectorStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActiveDirectoryConnectorStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActiveDirectoryConnectorStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_update_time: Optional[str] = None,
                 observed_generation: Optional[float] = None,
                 state: Optional[str] = None):
        """
        The status of the Kubernetes custom resource.
        :param str last_update_time: The time that the custom resource was last updated.
        :param float observed_generation: The version of the replicaSet associated with the AD connector custom resource.
        :param str state: The state of the AD connector custom resource.
        """
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[str]:
        """
        The time that the custom resource was last updated.
        """
        return pulumi.get(self, "last_update_time")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[float]:
        """
        The version of the replicaSet associated with the AD connector custom resource.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The state of the AD connector custom resource.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ActiveDirectoryDomainControllerResponse(dict):
    """
    Information about a domain controller in the AD domain.
    """
    def __init__(__self__, *,
                 hostname: str):
        """
        Information about a domain controller in the AD domain.
        :param str hostname: Fully-qualified domain name of a domain controller in the AD domain.
        """
        pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Fully-qualified domain name of a domain controller in the AD domain.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class ActiveDirectoryDomainControllersResponse(dict):
    """
    Details about the Active Directory domain controllers associated with this AD connector instance
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryDomainController":
            suggest = "primary_domain_controller"
        elif key == "secondaryDomainControllers":
            suggest = "secondary_domain_controllers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActiveDirectoryDomainControllersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActiveDirectoryDomainControllersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActiveDirectoryDomainControllersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_domain_controller: Optional['outputs.ActiveDirectoryDomainControllerResponse'] = None,
                 secondary_domain_controllers: Optional[Sequence['outputs.ActiveDirectoryDomainControllerResponse']] = None):
        """
        Details about the Active Directory domain controllers associated with this AD connector instance
        :param 'ActiveDirectoryDomainControllerResponse' primary_domain_controller: Information about the Primary Domain Controller (PDC) in the AD domain.
        :param Sequence['ActiveDirectoryDomainControllerResponse'] secondary_domain_controllers: null
        """
        if primary_domain_controller is not None:
            pulumi.set(__self__, "primary_domain_controller", primary_domain_controller)
        if secondary_domain_controllers is not None:
            pulumi.set(__self__, "secondary_domain_controllers", secondary_domain_controllers)

    @property
    @pulumi.getter(name="primaryDomainController")
    def primary_domain_controller(self) -> Optional['outputs.ActiveDirectoryDomainControllerResponse']:
        """
        Information about the Primary Domain Controller (PDC) in the AD domain.
        """
        return pulumi.get(self, "primary_domain_controller")

    @property
    @pulumi.getter(name="secondaryDomainControllers")
    def secondary_domain_controllers(self) -> Optional[Sequence['outputs.ActiveDirectoryDomainControllerResponse']]:
        """
        null
        """
        return pulumi.get(self, "secondary_domain_controllers")


@pulumi.output_type
class BasicLoginInformationResponse(dict):
    """
    Username and password for basic login authentication.
    """
    def __init__(__self__, *,
                 username: Optional[str] = None):
        """
        Username and password for basic login authentication.
        :param str username: Login username.
        """
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Login username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class DataControllerPropertiesResponse(dict):
    """
    The data controller properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "basicLoginInformation":
            suggest = "basic_login_information"
        elif key == "clusterId":
            suggest = "cluster_id"
        elif key == "extensionId":
            suggest = "extension_id"
        elif key == "k8sRaw":
            suggest = "k8s_raw"
        elif key == "lastUploadedDate":
            suggest = "last_uploaded_date"
        elif key == "logAnalyticsWorkspaceConfig":
            suggest = "log_analytics_workspace_config"
        elif key == "logsDashboardCredential":
            suggest = "logs_dashboard_credential"
        elif key == "metricsDashboardCredential":
            suggest = "metrics_dashboard_credential"
        elif key == "onPremiseProperty":
            suggest = "on_premise_property"
        elif key == "uploadServicePrincipal":
            suggest = "upload_service_principal"
        elif key == "uploadWatermark":
            suggest = "upload_watermark"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataControllerPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataControllerPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataControllerPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 basic_login_information: Optional['outputs.BasicLoginInformationResponse'] = None,
                 cluster_id: Optional[str] = None,
                 extension_id: Optional[str] = None,
                 infrastructure: Optional[str] = None,
                 k8s_raw: Optional[Any] = None,
                 last_uploaded_date: Optional[str] = None,
                 log_analytics_workspace_config: Optional['outputs.LogAnalyticsWorkspaceConfigResponse'] = None,
                 logs_dashboard_credential: Optional['outputs.BasicLoginInformationResponse'] = None,
                 metrics_dashboard_credential: Optional['outputs.BasicLoginInformationResponse'] = None,
                 on_premise_property: Optional['outputs.OnPremisePropertyResponse'] = None,
                 upload_service_principal: Optional['outputs.UploadServicePrincipalResponse'] = None,
                 upload_watermark: Optional['outputs.UploadWatermarkResponse'] = None):
        """
        The data controller properties.
        :param str provisioning_state: The provisioning state of the Arc Data Controller resource.
        :param 'BasicLoginInformationResponse' basic_login_information: Deprecated. Azure Arc Data Services data controller no longer expose any endpoint. All traffic are exposed through Kubernetes native API.
        :param str cluster_id: If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
        :param str extension_id: If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
        :param str infrastructure: The infrastructure the data controller is running on.
        :param Any k8s_raw: The raw kubernetes information
        :param str last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date time
        :param 'LogAnalyticsWorkspaceConfigResponse' log_analytics_workspace_config: Log analytics workspace id and primary key
        :param 'BasicLoginInformationResponse' logs_dashboard_credential: Login credential for logs dashboard on the Kubernetes cluster.
        :param 'BasicLoginInformationResponse' metrics_dashboard_credential: Login credential for metrics dashboard on the Kubernetes cluster.
        :param 'OnPremisePropertyResponse' on_premise_property: Properties from the Kubernetes data controller
        :param 'UploadServicePrincipalResponse' upload_service_principal: Deprecated. Service principal is deprecated in favor of Arc Kubernetes service extension managed identity.
        :param 'UploadWatermarkResponse' upload_watermark: Properties on upload watermark.  Mostly timestamp for each upload data type
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if basic_login_information is not None:
            pulumi.set(__self__, "basic_login_information", basic_login_information)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if extension_id is not None:
            pulumi.set(__self__, "extension_id", extension_id)
        if infrastructure is None:
            infrastructure = 'other'
        if infrastructure is not None:
            pulumi.set(__self__, "infrastructure", infrastructure)
        if k8s_raw is not None:
            pulumi.set(__self__, "k8s_raw", k8s_raw)
        if last_uploaded_date is not None:
            pulumi.set(__self__, "last_uploaded_date", last_uploaded_date)
        if log_analytics_workspace_config is not None:
            pulumi.set(__self__, "log_analytics_workspace_config", log_analytics_workspace_config)
        if logs_dashboard_credential is not None:
            pulumi.set(__self__, "logs_dashboard_credential", logs_dashboard_credential)
        if metrics_dashboard_credential is not None:
            pulumi.set(__self__, "metrics_dashboard_credential", metrics_dashboard_credential)
        if on_premise_property is not None:
            pulumi.set(__self__, "on_premise_property", on_premise_property)
        if upload_service_principal is not None:
            pulumi.set(__self__, "upload_service_principal", upload_service_principal)
        if upload_watermark is not None:
            pulumi.set(__self__, "upload_watermark", upload_watermark)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the Arc Data Controller resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="basicLoginInformation")
    def basic_login_information(self) -> Optional['outputs.BasicLoginInformationResponse']:
        """
        Deprecated. Azure Arc Data Services data controller no longer expose any endpoint. All traffic are exposed through Kubernetes native API.
        """
        return pulumi.get(self, "basic_login_information")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[str]:
        """
        If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="extensionId")
    def extension_id(self) -> Optional[str]:
        """
        If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
        """
        return pulumi.get(self, "extension_id")

    @property
    @pulumi.getter
    def infrastructure(self) -> Optional[str]:
        """
        The infrastructure the data controller is running on.
        """
        return pulumi.get(self, "infrastructure")

    @property
    @pulumi.getter(name="k8sRaw")
    def k8s_raw(self) -> Optional[Any]:
        """
        The raw kubernetes information
        """
        return pulumi.get(self, "k8s_raw")

    @property
    @pulumi.getter(name="lastUploadedDate")
    def last_uploaded_date(self) -> Optional[str]:
        """
        Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "last_uploaded_date")

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceConfig")
    def log_analytics_workspace_config(self) -> Optional['outputs.LogAnalyticsWorkspaceConfigResponse']:
        """
        Log analytics workspace id and primary key
        """
        return pulumi.get(self, "log_analytics_workspace_config")

    @property
    @pulumi.getter(name="logsDashboardCredential")
    def logs_dashboard_credential(self) -> Optional['outputs.BasicLoginInformationResponse']:
        """
        Login credential for logs dashboard on the Kubernetes cluster.
        """
        return pulumi.get(self, "logs_dashboard_credential")

    @property
    @pulumi.getter(name="metricsDashboardCredential")
    def metrics_dashboard_credential(self) -> Optional['outputs.BasicLoginInformationResponse']:
        """
        Login credential for metrics dashboard on the Kubernetes cluster.
        """
        return pulumi.get(self, "metrics_dashboard_credential")

    @property
    @pulumi.getter(name="onPremiseProperty")
    def on_premise_property(self) -> Optional['outputs.OnPremisePropertyResponse']:
        """
        Properties from the Kubernetes data controller
        """
        return pulumi.get(self, "on_premise_property")

    @property
    @pulumi.getter(name="uploadServicePrincipal")
    def upload_service_principal(self) -> Optional['outputs.UploadServicePrincipalResponse']:
        """
        Deprecated. Service principal is deprecated in favor of Arc Kubernetes service extension managed identity.
        """
        return pulumi.get(self, "upload_service_principal")

    @property
    @pulumi.getter(name="uploadWatermark")
    def upload_watermark(self) -> Optional['outputs.UploadWatermarkResponse']:
        """
        Properties on upload watermark.  Mostly timestamp for each upload data type
        """
        return pulumi.get(self, "upload_watermark")


@pulumi.output_type
class ExtendedLocationResponse(dict):
    """
    The complex type of the extended location.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The complex type of the extended location.
        :param str name: The name of the extended location.
        :param str type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FailoverGroupPropertiesResponse(dict):
    """
    The properties of a failover group resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partnerManagedInstanceId":
            suggest = "partner_managed_instance_id"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FailoverGroupPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FailoverGroupPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FailoverGroupPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partner_managed_instance_id: str,
                 provisioning_state: str,
                 spec: 'outputs.FailoverGroupSpecResponse',
                 status: Optional['outputs.FailoverGroupStatusResponse'] = None):
        """
        The properties of a failover group resource.
        :param str partner_managed_instance_id: The resource ID of the partner SQL managed instance.
        :param str provisioning_state: The provisioning state of the failover group resource.
        :param 'FailoverGroupSpecResponse' spec: The specifications of the failover group resource.
        :param 'FailoverGroupStatusResponse' status: The status of the failover group custom resource.
        """
        pulumi.set(__self__, "partner_managed_instance_id", partner_managed_instance_id)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="partnerManagedInstanceId")
    def partner_managed_instance_id(self) -> str:
        """
        The resource ID of the partner SQL managed instance.
        """
        return pulumi.get(self, "partner_managed_instance_id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the failover group resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.FailoverGroupSpecResponse':
        """
        The specifications of the failover group resource.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.FailoverGroupStatusResponse']:
        """
        The status of the failover group custom resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class FailoverGroupSpecResponse(dict):
    """
    The specifications of the failover group resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partnerMI":
            suggest = "partner_mi"
        elif key == "partnerMirroringCert":
            suggest = "partner_mirroring_cert"
        elif key == "partnerMirroringURL":
            suggest = "partner_mirroring_url"
        elif key == "partnerSyncMode":
            suggest = "partner_sync_mode"
        elif key == "sharedName":
            suggest = "shared_name"
        elif key == "sourceMI":
            suggest = "source_mi"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FailoverGroupSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FailoverGroupSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FailoverGroupSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role: str,
                 partner_mi: Optional[str] = None,
                 partner_mirroring_cert: Optional[str] = None,
                 partner_mirroring_url: Optional[str] = None,
                 partner_sync_mode: Optional[str] = None,
                 shared_name: Optional[str] = None,
                 source_mi: Optional[str] = None):
        """
        The specifications of the failover group resource.
        :param str role: The role of the SQL managed instance in this failover group.
        :param str partner_mi: The name of the partner SQL managed instance.
        :param str partner_mirroring_cert: The mirroring endpoint public certificate for the partner SQL managed instance. Only PEM format is supported.
        :param str partner_mirroring_url: The mirroring endpoint URL of the partner SQL managed instance.
        :param str partner_sync_mode: The partner sync mode of the SQL managed instance.
        :param str shared_name: The shared name of the failover group for this SQL managed instance. Both SQL managed instance and its partner have to use the same shared name.
        :param str source_mi: The name of the SQL managed instance with this failover group role.
        """
        if role is None:
            role = 'primary'
        pulumi.set(__self__, "role", role)
        if partner_mi is not None:
            pulumi.set(__self__, "partner_mi", partner_mi)
        if partner_mirroring_cert is not None:
            pulumi.set(__self__, "partner_mirroring_cert", partner_mirroring_cert)
        if partner_mirroring_url is not None:
            pulumi.set(__self__, "partner_mirroring_url", partner_mirroring_url)
        if partner_sync_mode is None:
            partner_sync_mode = 'async'
        if partner_sync_mode is not None:
            pulumi.set(__self__, "partner_sync_mode", partner_sync_mode)
        if shared_name is not None:
            pulumi.set(__self__, "shared_name", shared_name)
        if source_mi is not None:
            pulumi.set(__self__, "source_mi", source_mi)

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role of the SQL managed instance in this failover group.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="partnerMI")
    def partner_mi(self) -> Optional[str]:
        """
        The name of the partner SQL managed instance.
        """
        return pulumi.get(self, "partner_mi")

    @property
    @pulumi.getter(name="partnerMirroringCert")
    def partner_mirroring_cert(self) -> Optional[str]:
        """
        The mirroring endpoint public certificate for the partner SQL managed instance. Only PEM format is supported.
        """
        return pulumi.get(self, "partner_mirroring_cert")

    @property
    @pulumi.getter(name="partnerMirroringURL")
    def partner_mirroring_url(self) -> Optional[str]:
        """
        The mirroring endpoint URL of the partner SQL managed instance.
        """
        return pulumi.get(self, "partner_mirroring_url")

    @property
    @pulumi.getter(name="partnerSyncMode")
    def partner_sync_mode(self) -> Optional[str]:
        """
        The partner sync mode of the SQL managed instance.
        """
        return pulumi.get(self, "partner_sync_mode")

    @property
    @pulumi.getter(name="sharedName")
    def shared_name(self) -> Optional[str]:
        """
        The shared name of the failover group for this SQL managed instance. Both SQL managed instance and its partner have to use the same shared name.
        """
        return pulumi.get(self, "shared_name")

    @property
    @pulumi.getter(name="sourceMI")
    def source_mi(self) -> Optional[str]:
        """
        The name of the SQL managed instance with this failover group role.
        """
        return pulumi.get(self, "source_mi")


@pulumi.output_type
class FailoverGroupStatusResponse(dict):
    """
    The status of the Kubernetes custom resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdateTime":
            suggest = "last_update_time"
        elif key == "observedGeneration":
            suggest = "observed_generation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FailoverGroupStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FailoverGroupStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FailoverGroupStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_update_time: Optional[str] = None,
                 observed_generation: Optional[float] = None,
                 replicas: Optional[Sequence['outputs.AGReplicasResponse']] = None,
                 results: Optional[str] = None,
                 role: Optional[str] = None,
                 state: Optional[str] = None):
        """
        The status of the Kubernetes custom resource.
        :param str last_update_time: The time that the custom resource was last updated.
        :param float observed_generation: The version of the replicaSet associated with the failover group custom resource.
        :param Sequence['AGReplicasResponse'] replicas: A list of failover group replicas.
        :param str results: The message in case of a failure in the failover group.
        :param str role: The role of the managed instance in the failover group.
        :param str state: The state of the failover group custom resource.
        """
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if results is not None:
            pulumi.set(__self__, "results", results)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[str]:
        """
        The time that the custom resource was last updated.
        """
        return pulumi.get(self, "last_update_time")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[float]:
        """
        The version of the replicaSet associated with the failover group custom resource.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter
    def replicas(self) -> Optional[Sequence['outputs.AGReplicasResponse']]:
        """
        A list of failover group replicas.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter
    def results(self) -> Optional[str]:
        """
        The message in case of a failure in the failover group.
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        The role of the managed instance in the failover group.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The state of the failover group custom resource.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class K8sResourceRequirementsResponse(dict):
    """
    The kubernetes resource limits and requests used to restrict or reserve resource usage.
    """
    def __init__(__self__, *,
                 limits: Optional[Mapping[str, str]] = None,
                 requests: Optional[Mapping[str, str]] = None):
        """
        The kubernetes resource limits and requests used to restrict or reserve resource usage.
        :param Mapping[str, str] limits: Limits for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum 'memory' is '128Gi'.
        :param Mapping[str, str] requests: Requests for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum 'memory' is '128Gi'.
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Optional[Mapping[str, str]]:
        """
        Limits for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum 'memory' is '128Gi'.
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Mapping[str, str]]:
        """
        Requests for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum 'memory' is '128Gi'.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class K8sSchedulingOptionsResponse(dict):
    """
    The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
    """
    def __init__(__self__, *,
                 resources: Optional['outputs.K8sResourceRequirementsResponse'] = None):
        """
        The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
        :param 'K8sResourceRequirementsResponse' resources: The kubernetes resource limits and requests used to restrict or reserve resource usage.
        """
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.K8sResourceRequirementsResponse']:
        """
        The kubernetes resource limits and requests used to restrict or reserve resource usage.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class K8sSchedulingResponse(dict):
    """
    The kubernetes scheduling information.
    """
    def __init__(__self__, *,
                 default: Optional['outputs.K8sSchedulingOptionsResponse'] = None):
        """
        The kubernetes scheduling information.
        :param 'K8sSchedulingOptionsResponse' default: The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
        """
        if default is not None:
            pulumi.set(__self__, "default", default)

    @property
    @pulumi.getter
    def default(self) -> Optional['outputs.K8sSchedulingOptionsResponse']:
        """
        The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
        """
        return pulumi.get(self, "default")


@pulumi.output_type
class LogAnalyticsWorkspaceConfigResponse(dict):
    """
    Log analytics workspace id and primary key
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workspaceId":
            suggest = "workspace_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogAnalyticsWorkspaceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogAnalyticsWorkspaceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogAnalyticsWorkspaceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 workspace_id: Optional[str] = None):
        """
        Log analytics workspace id and primary key
        :param str workspace_id: Azure Log Analytics workspace ID
        """
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[str]:
        """
        Azure Log Analytics workspace ID
        """
        return pulumi.get(self, "workspace_id")


@pulumi.output_type
class OnPremisePropertyResponse(dict):
    """
    Properties from the Kubernetes data controller
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicSigningKey":
            suggest = "public_signing_key"
        elif key == "signingCertificateThumbprint":
            suggest = "signing_certificate_thumbprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OnPremisePropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OnPremisePropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OnPremisePropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 public_signing_key: str,
                 signing_certificate_thumbprint: Optional[str] = None):
        """
        Properties from the Kubernetes data controller
        :param str id: A globally unique ID identifying the associated Kubernetes cluster
        :param str public_signing_key: Certificate that contains the Kubernetes cluster public key used to verify signing
        :param str signing_certificate_thumbprint: Unique thumbprint returned to customer to verify the certificate being uploaded
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "public_signing_key", public_signing_key)
        if signing_certificate_thumbprint is not None:
            pulumi.set(__self__, "signing_certificate_thumbprint", signing_certificate_thumbprint)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A globally unique ID identifying the associated Kubernetes cluster
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="publicSigningKey")
    def public_signing_key(self) -> str:
        """
        Certificate that contains the Kubernetes cluster public key used to verify signing
        """
        return pulumi.get(self, "public_signing_key")

    @property
    @pulumi.getter(name="signingCertificateThumbprint")
    def signing_certificate_thumbprint(self) -> Optional[str]:
        """
        Unique thumbprint returned to customer to verify the certificate being uploaded
        """
        return pulumi.get(self, "signing_certificate_thumbprint")


@pulumi.output_type
class PostgresInstancePropertiesResponse(dict):
    """
    Postgres Instance properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "basicLoginInformation":
            suggest = "basic_login_information"
        elif key == "dataControllerId":
            suggest = "data_controller_id"
        elif key == "k8sRaw":
            suggest = "k8s_raw"
        elif key == "lastUploadedDate":
            suggest = "last_uploaded_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostgresInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostgresInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostgresInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 admin: Optional[str] = None,
                 basic_login_information: Optional['outputs.BasicLoginInformationResponse'] = None,
                 data_controller_id: Optional[str] = None,
                 k8s_raw: Optional[Any] = None,
                 last_uploaded_date: Optional[str] = None):
        """
        Postgres Instance properties.
        :param str provisioning_state: The provisioning state of the Azure Arc-enabled PostgreSQL instance.
        :param str admin: The instance admin
        :param 'BasicLoginInformationResponse' basic_login_information: Username and password for basic authentication.
        :param str data_controller_id: The data controller id
        :param Any k8s_raw: The raw kubernetes information
        :param str last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if admin is not None:
            pulumi.set(__self__, "admin", admin)
        if basic_login_information is not None:
            pulumi.set(__self__, "basic_login_information", basic_login_information)
        if data_controller_id is not None:
            pulumi.set(__self__, "data_controller_id", data_controller_id)
        if k8s_raw is not None:
            pulumi.set(__self__, "k8s_raw", k8s_raw)
        if last_uploaded_date is not None:
            pulumi.set(__self__, "last_uploaded_date", last_uploaded_date)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the Azure Arc-enabled PostgreSQL instance.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def admin(self) -> Optional[str]:
        """
        The instance admin
        """
        return pulumi.get(self, "admin")

    @property
    @pulumi.getter(name="basicLoginInformation")
    def basic_login_information(self) -> Optional['outputs.BasicLoginInformationResponse']:
        """
        Username and password for basic authentication.
        """
        return pulumi.get(self, "basic_login_information")

    @property
    @pulumi.getter(name="dataControllerId")
    def data_controller_id(self) -> Optional[str]:
        """
        The data controller id
        """
        return pulumi.get(self, "data_controller_id")

    @property
    @pulumi.getter(name="k8sRaw")
    def k8s_raw(self) -> Optional[Any]:
        """
        The raw kubernetes information
        """
        return pulumi.get(self, "k8s_raw")

    @property
    @pulumi.getter(name="lastUploadedDate")
    def last_uploaded_date(self) -> Optional[str]:
        """
        Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "last_uploaded_date")


@pulumi.output_type
class PostgresInstanceSkuResponse(dict):
    """
    The resource model definition representing SKU for Azure Database for PostgresSQL - Azure Arc
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 dev: Optional[bool] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        The resource model definition representing SKU for Azure Database for PostgresSQL - Azure Arc
        :param str name: The name of the SKU.  It is typically a letter+number code
        :param int capacity: If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        :param bool dev: Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        :param str family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param str size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        :param str tier: This field is required to be implemented by the Resource Provider if the service has more than one tier.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if dev is None:
            dev = True
        if dev is not None:
            pulumi.set(__self__, "dev", dev)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is None:
            tier = 'Hyperscale'
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU.  It is typically a letter+number code
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def dev(self) -> Optional[bool]:
        """
        Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        """
        return pulumi.get(self, "dev")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        This field is required to be implemented by the Resource Provider if the service has more than one tier.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SqlManagedInstanceK8sRawResponse(dict):
    """
    The raw kubernetes information.
    """
    def __init__(__self__, *,
                 spec: Optional['outputs.SqlManagedInstanceK8sSpecResponse'] = None):
        """
        The raw kubernetes information.
        :param 'SqlManagedInstanceK8sSpecResponse' spec: The kubernetes spec information.
        """
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.SqlManagedInstanceK8sSpecResponse']:
        """
        The kubernetes spec information.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class SqlManagedInstanceK8sSpecResponse(dict):
    """
    The kubernetes spec information.
    """
    def __init__(__self__, *,
                 replicas: Optional[int] = None,
                 scheduling: Optional['outputs.K8sSchedulingResponse'] = None):
        """
        The kubernetes spec information.
        :param int replicas: This option specifies the number of SQL Managed Instance replicas that will be deployed in your Kubernetes cluster for high availability purposes. If sku.tier is BusinessCritical, allowed values are '2' or '3' with default of '3'. If sku.tier is GeneralPurpose, replicas must be '1'.
        :param 'K8sSchedulingResponse' scheduling: The kubernetes scheduling information.
        """
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[int]:
        """
        This option specifies the number of SQL Managed Instance replicas that will be deployed in your Kubernetes cluster for high availability purposes. If sku.tier is BusinessCritical, allowed values are '2' or '3' with default of '3'. If sku.tier is GeneralPurpose, replicas must be '1'.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter
    def scheduling(self) -> Optional['outputs.K8sSchedulingResponse']:
        """
        The kubernetes scheduling information.
        """
        return pulumi.get(self, "scheduling")


@pulumi.output_type
class SqlManagedInstancePropertiesResponse(dict):
    """
    Properties of sqlManagedInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "basicLoginInformation":
            suggest = "basic_login_information"
        elif key == "clusterId":
            suggest = "cluster_id"
        elif key == "dataControllerId":
            suggest = "data_controller_id"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "extensionId":
            suggest = "extension_id"
        elif key == "k8sRaw":
            suggest = "k8s_raw"
        elif key == "lastUploadedDate":
            suggest = "last_uploaded_date"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlManagedInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlManagedInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlManagedInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 admin: Optional[str] = None,
                 basic_login_information: Optional['outputs.BasicLoginInformationResponse'] = None,
                 cluster_id: Optional[str] = None,
                 data_controller_id: Optional[str] = None,
                 end_time: Optional[str] = None,
                 extension_id: Optional[str] = None,
                 k8s_raw: Optional['outputs.SqlManagedInstanceK8sRawResponse'] = None,
                 last_uploaded_date: Optional[str] = None,
                 license_type: Optional[str] = None,
                 start_time: Optional[str] = None):
        """
        Properties of sqlManagedInstance.
        :param str provisioning_state: The provisioning state of the Arc-enabled SQL Managed Instance resource.
        :param str admin: The instance admin user
        :param 'BasicLoginInformationResponse' basic_login_information: Username and password for basic authentication.
        :param str cluster_id: If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
        :param str data_controller_id: null
        :param str end_time: The instance end time
        :param str extension_id: If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
        :param 'SqlManagedInstanceK8sRawResponse' k8s_raw: The raw kubernetes information
        :param str last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date time
        :param str license_type: The license type to apply for this managed instance.
        :param str start_time: The instance start time
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if admin is not None:
            pulumi.set(__self__, "admin", admin)
        if basic_login_information is not None:
            pulumi.set(__self__, "basic_login_information", basic_login_information)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if data_controller_id is not None:
            pulumi.set(__self__, "data_controller_id", data_controller_id)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if extension_id is not None:
            pulumi.set(__self__, "extension_id", extension_id)
        if k8s_raw is not None:
            pulumi.set(__self__, "k8s_raw", k8s_raw)
        if last_uploaded_date is not None:
            pulumi.set(__self__, "last_uploaded_date", last_uploaded_date)
        if license_type is None:
            license_type = 'BasePrice'
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the Arc-enabled SQL Managed Instance resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def admin(self) -> Optional[str]:
        """
        The instance admin user
        """
        return pulumi.get(self, "admin")

    @property
    @pulumi.getter(name="basicLoginInformation")
    def basic_login_information(self) -> Optional['outputs.BasicLoginInformationResponse']:
        """
        Username and password for basic authentication.
        """
        return pulumi.get(self, "basic_login_information")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[str]:
        """
        If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="dataControllerId")
    def data_controller_id(self) -> Optional[str]:
        """
        null
        """
        return pulumi.get(self, "data_controller_id")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        The instance end time
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="extensionId")
    def extension_id(self) -> Optional[str]:
        """
        If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
        """
        return pulumi.get(self, "extension_id")

    @property
    @pulumi.getter(name="k8sRaw")
    def k8s_raw(self) -> Optional['outputs.SqlManagedInstanceK8sRawResponse']:
        """
        The raw kubernetes information
        """
        return pulumi.get(self, "k8s_raw")

    @property
    @pulumi.getter(name="lastUploadedDate")
    def last_uploaded_date(self) -> Optional[str]:
        """
        Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "last_uploaded_date")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        The license type to apply for this managed instance.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        The instance start time
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class SqlManagedInstanceSkuResponse(dict):
    """
    The resource model definition representing SKU for Azure Managed Instance - Azure Arc
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 dev: Optional[bool] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        The resource model definition representing SKU for Azure Managed Instance - Azure Arc
        :param str name: The name of the SKU.
        :param int capacity: The SKU capacity
        :param bool dev: Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        :param str family: The SKU family
        :param str size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        :param str tier: The pricing tier for the instance.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if dev is None:
            dev = True
        if dev is not None:
            pulumi.set(__self__, "dev", dev)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is None:
            tier = 'GeneralPurpose'
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        The SKU capacity
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def dev(self) -> Optional[bool]:
        """
        Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        """
        return pulumi.get(self, "dev")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        The SKU family
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The pricing tier for the instance.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SqlServerDatabaseResourcePropertiesResponse(dict):
    """
    The properties of Arc Sql Server database resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "backupInformation":
            suggest = "backup_information"
        elif key == "collationName":
            suggest = "collation_name"
        elif key == "compatibilityLevel":
            suggest = "compatibility_level"
        elif key == "databaseCreationDate":
            suggest = "database_creation_date"
        elif key == "databaseOptions":
            suggest = "database_options"
        elif key == "isReadOnly":
            suggest = "is_read_only"
        elif key == "recoveryMode":
            suggest = "recovery_mode"
        elif key == "sizeMB":
            suggest = "size_mb"
        elif key == "spaceAvailableMB":
            suggest = "space_available_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlServerDatabaseResourcePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlServerDatabaseResourcePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlServerDatabaseResourcePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 backup_information: Optional['outputs.SqlServerDatabaseResourcePropertiesResponseBackupInformation'] = None,
                 collation_name: Optional[str] = None,
                 compatibility_level: Optional[int] = None,
                 database_creation_date: Optional[str] = None,
                 database_options: Optional['outputs.SqlServerDatabaseResourcePropertiesResponseDatabaseOptions'] = None,
                 is_read_only: Optional[bool] = None,
                 recovery_mode: Optional[str] = None,
                 size_mb: Optional[float] = None,
                 space_available_mb: Optional[float] = None,
                 state: Optional[str] = None):
        """
        The properties of Arc Sql Server database resource
        :param str provisioning_state: The provisioning state of the Arc-enabled SQL Server database resource.
        :param str collation_name: Collation of the database.
        :param int compatibility_level: Compatibility level of the database
        :param str database_creation_date: Creation date of the database.
        :param 'SqlServerDatabaseResourcePropertiesResponseDatabaseOptions' database_options: List of features that are enabled for the database
        :param bool is_read_only: Whether the database is read only or not.
        :param str recovery_mode: Status of the database.
        :param float size_mb: Size of the database.
        :param float space_available_mb: Space left of the database.
        :param str state: State of the database.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if backup_information is not None:
            pulumi.set(__self__, "backup_information", backup_information)
        if collation_name is not None:
            pulumi.set(__self__, "collation_name", collation_name)
        if compatibility_level is not None:
            pulumi.set(__self__, "compatibility_level", compatibility_level)
        if database_creation_date is not None:
            pulumi.set(__self__, "database_creation_date", database_creation_date)
        if database_options is not None:
            pulumi.set(__self__, "database_options", database_options)
        if is_read_only is not None:
            pulumi.set(__self__, "is_read_only", is_read_only)
        if recovery_mode is not None:
            pulumi.set(__self__, "recovery_mode", recovery_mode)
        if size_mb is not None:
            pulumi.set(__self__, "size_mb", size_mb)
        if space_available_mb is not None:
            pulumi.set(__self__, "space_available_mb", space_available_mb)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the Arc-enabled SQL Server database resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="backupInformation")
    def backup_information(self) -> Optional['outputs.SqlServerDatabaseResourcePropertiesResponseBackupInformation']:
        return pulumi.get(self, "backup_information")

    @property
    @pulumi.getter(name="collationName")
    def collation_name(self) -> Optional[str]:
        """
        Collation of the database.
        """
        return pulumi.get(self, "collation_name")

    @property
    @pulumi.getter(name="compatibilityLevel")
    def compatibility_level(self) -> Optional[int]:
        """
        Compatibility level of the database
        """
        return pulumi.get(self, "compatibility_level")

    @property
    @pulumi.getter(name="databaseCreationDate")
    def database_creation_date(self) -> Optional[str]:
        """
        Creation date of the database.
        """
        return pulumi.get(self, "database_creation_date")

    @property
    @pulumi.getter(name="databaseOptions")
    def database_options(self) -> Optional['outputs.SqlServerDatabaseResourcePropertiesResponseDatabaseOptions']:
        """
        List of features that are enabled for the database
        """
        return pulumi.get(self, "database_options")

    @property
    @pulumi.getter(name="isReadOnly")
    def is_read_only(self) -> Optional[bool]:
        """
        Whether the database is read only or not.
        """
        return pulumi.get(self, "is_read_only")

    @property
    @pulumi.getter(name="recoveryMode")
    def recovery_mode(self) -> Optional[str]:
        """
        Status of the database.
        """
        return pulumi.get(self, "recovery_mode")

    @property
    @pulumi.getter(name="sizeMB")
    def size_mb(self) -> Optional[float]:
        """
        Size of the database.
        """
        return pulumi.get(self, "size_mb")

    @property
    @pulumi.getter(name="spaceAvailableMB")
    def space_available_mb(self) -> Optional[float]:
        """
        Space left of the database.
        """
        return pulumi.get(self, "space_available_mb")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        State of the database.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class SqlServerDatabaseResourcePropertiesResponseBackupInformation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastFullBackup":
            suggest = "last_full_backup"
        elif key == "lastLogBackup":
            suggest = "last_log_backup"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlServerDatabaseResourcePropertiesResponseBackupInformation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlServerDatabaseResourcePropertiesResponseBackupInformation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlServerDatabaseResourcePropertiesResponseBackupInformation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_full_backup: Optional[str] = None,
                 last_log_backup: Optional[str] = None):
        """
        :param str last_full_backup: Date time of last full backup.
        :param str last_log_backup: Date time of last log backup.
        """
        if last_full_backup is not None:
            pulumi.set(__self__, "last_full_backup", last_full_backup)
        if last_log_backup is not None:
            pulumi.set(__self__, "last_log_backup", last_log_backup)

    @property
    @pulumi.getter(name="lastFullBackup")
    def last_full_backup(self) -> Optional[str]:
        """
        Date time of last full backup.
        """
        return pulumi.get(self, "last_full_backup")

    @property
    @pulumi.getter(name="lastLogBackup")
    def last_log_backup(self) -> Optional[str]:
        """
        Date time of last log backup.
        """
        return pulumi.get(self, "last_log_backup")


@pulumi.output_type
class SqlServerDatabaseResourcePropertiesResponseDatabaseOptions(dict):
    """
    List of features that are enabled for the database
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isAutoCloseOn":
            suggest = "is_auto_close_on"
        elif key == "isAutoCreateStatsOn":
            suggest = "is_auto_create_stats_on"
        elif key == "isAutoShrinkOn":
            suggest = "is_auto_shrink_on"
        elif key == "isAutoUpdateStatsOn":
            suggest = "is_auto_update_stats_on"
        elif key == "isEncrypted":
            suggest = "is_encrypted"
        elif key == "isMemoryOptimizationEnabled":
            suggest = "is_memory_optimization_enabled"
        elif key == "isRemoteDataArchiveEnabled":
            suggest = "is_remote_data_archive_enabled"
        elif key == "isTrustworthyOn":
            suggest = "is_trustworthy_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlServerDatabaseResourcePropertiesResponseDatabaseOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlServerDatabaseResourcePropertiesResponseDatabaseOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlServerDatabaseResourcePropertiesResponseDatabaseOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_auto_close_on: Optional[bool] = None,
                 is_auto_create_stats_on: Optional[bool] = None,
                 is_auto_shrink_on: Optional[bool] = None,
                 is_auto_update_stats_on: Optional[bool] = None,
                 is_encrypted: Optional[bool] = None,
                 is_memory_optimization_enabled: Optional[bool] = None,
                 is_remote_data_archive_enabled: Optional[bool] = None,
                 is_trustworthy_on: Optional[bool] = None):
        """
        List of features that are enabled for the database
        """
        if is_auto_close_on is not None:
            pulumi.set(__self__, "is_auto_close_on", is_auto_close_on)
        if is_auto_create_stats_on is not None:
            pulumi.set(__self__, "is_auto_create_stats_on", is_auto_create_stats_on)
        if is_auto_shrink_on is not None:
            pulumi.set(__self__, "is_auto_shrink_on", is_auto_shrink_on)
        if is_auto_update_stats_on is not None:
            pulumi.set(__self__, "is_auto_update_stats_on", is_auto_update_stats_on)
        if is_encrypted is not None:
            pulumi.set(__self__, "is_encrypted", is_encrypted)
        if is_memory_optimization_enabled is not None:
            pulumi.set(__self__, "is_memory_optimization_enabled", is_memory_optimization_enabled)
        if is_remote_data_archive_enabled is not None:
            pulumi.set(__self__, "is_remote_data_archive_enabled", is_remote_data_archive_enabled)
        if is_trustworthy_on is not None:
            pulumi.set(__self__, "is_trustworthy_on", is_trustworthy_on)

    @property
    @pulumi.getter(name="isAutoCloseOn")
    def is_auto_close_on(self) -> Optional[bool]:
        return pulumi.get(self, "is_auto_close_on")

    @property
    @pulumi.getter(name="isAutoCreateStatsOn")
    def is_auto_create_stats_on(self) -> Optional[bool]:
        return pulumi.get(self, "is_auto_create_stats_on")

    @property
    @pulumi.getter(name="isAutoShrinkOn")
    def is_auto_shrink_on(self) -> Optional[bool]:
        return pulumi.get(self, "is_auto_shrink_on")

    @property
    @pulumi.getter(name="isAutoUpdateStatsOn")
    def is_auto_update_stats_on(self) -> Optional[bool]:
        return pulumi.get(self, "is_auto_update_stats_on")

    @property
    @pulumi.getter(name="isEncrypted")
    def is_encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "is_encrypted")

    @property
    @pulumi.getter(name="isMemoryOptimizationEnabled")
    def is_memory_optimization_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "is_memory_optimization_enabled")

    @property
    @pulumi.getter(name="isRemoteDataArchiveEnabled")
    def is_remote_data_archive_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "is_remote_data_archive_enabled")

    @property
    @pulumi.getter(name="isTrustworthyOn")
    def is_trustworthy_on(self) -> Optional[bool]:
        return pulumi.get(self, "is_trustworthy_on")


@pulumi.output_type
class SqlServerInstancePropertiesResponse(dict):
    """
    Properties of SqlServerInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerResourceId":
            suggest = "container_resource_id"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "azureDefenderStatus":
            suggest = "azure_defender_status"
        elif key == "azureDefenderStatusLastUpdated":
            suggest = "azure_defender_status_last_updated"
        elif key == "currentVersion":
            suggest = "current_version"
        elif key == "hostType":
            suggest = "host_type"
        elif key == "instanceName":
            suggest = "instance_name"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "patchLevel":
            suggest = "patch_level"
        elif key == "productId":
            suggest = "product_id"
        elif key == "tcpDynamicPorts":
            suggest = "tcp_dynamic_ports"
        elif key == "tcpStaticPorts":
            suggest = "tcp_static_ports"
        elif key == "vCore":
            suggest = "v_core"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlServerInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlServerInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlServerInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_resource_id: str,
                 create_time: str,
                 provisioning_state: str,
                 status: str,
                 azure_defender_status: Optional[str] = None,
                 azure_defender_status_last_updated: Optional[str] = None,
                 collation: Optional[str] = None,
                 cores: Optional[str] = None,
                 current_version: Optional[str] = None,
                 edition: Optional[str] = None,
                 host_type: Optional[str] = None,
                 instance_name: Optional[str] = None,
                 license_type: Optional[str] = None,
                 patch_level: Optional[str] = None,
                 product_id: Optional[str] = None,
                 tcp_dynamic_ports: Optional[str] = None,
                 tcp_static_ports: Optional[str] = None,
                 v_core: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Properties of SqlServerInstance.
        :param str container_resource_id: ARM Resource id of the container resource (Azure Arc for Servers).
        :param str create_time: The time when the resource was created.
        :param str provisioning_state: The provisioning state of the Arc-enabled SQL Server resource.
        :param str status: The cloud connectivity status.
        :param str azure_defender_status: Status of Azure Defender.
        :param str azure_defender_status_last_updated: Timestamp of last Azure Defender status update.
        :param str collation: SQL Server collation.
        :param str cores: The number of total cores of the Operating System Environment (OSE) hosting the SQL Server instance.
        :param str current_version: SQL Server current version.
        :param str edition: SQL Server edition.
        :param str host_type: Type of host for Azure Arc SQL Server
        :param str instance_name: SQL Server instance name.
        :param str license_type: SQL Server license type.
        :param str patch_level: SQL Server update level.
        :param str product_id: SQL Server product ID.
        :param str tcp_dynamic_ports: Dynamic TCP ports used by SQL Server.
        :param str tcp_static_ports: Static TCP ports used by SQL Server.
        :param str v_core: The number of logical processors used by the SQL Server instance.
        :param str version: SQL Server version.
        """
        pulumi.set(__self__, "container_resource_id", container_resource_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "status", status)
        if azure_defender_status is not None:
            pulumi.set(__self__, "azure_defender_status", azure_defender_status)
        if azure_defender_status_last_updated is not None:
            pulumi.set(__self__, "azure_defender_status_last_updated", azure_defender_status_last_updated)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if cores is not None:
            pulumi.set(__self__, "cores", cores)
        if current_version is not None:
            pulumi.set(__self__, "current_version", current_version)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if host_type is not None:
            pulumi.set(__self__, "host_type", host_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if patch_level is not None:
            pulumi.set(__self__, "patch_level", patch_level)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if tcp_dynamic_ports is not None:
            pulumi.set(__self__, "tcp_dynamic_ports", tcp_dynamic_ports)
        if tcp_static_ports is not None:
            pulumi.set(__self__, "tcp_static_ports", tcp_static_ports)
        if v_core is not None:
            pulumi.set(__self__, "v_core", v_core)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="containerResourceId")
    def container_resource_id(self) -> str:
        """
        ARM Resource id of the container resource (Azure Arc for Servers).
        """
        return pulumi.get(self, "container_resource_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the Arc-enabled SQL Server resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The cloud connectivity status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="azureDefenderStatus")
    def azure_defender_status(self) -> Optional[str]:
        """
        Status of Azure Defender.
        """
        return pulumi.get(self, "azure_defender_status")

    @property
    @pulumi.getter(name="azureDefenderStatusLastUpdated")
    def azure_defender_status_last_updated(self) -> Optional[str]:
        """
        Timestamp of last Azure Defender status update.
        """
        return pulumi.get(self, "azure_defender_status_last_updated")

    @property
    @pulumi.getter
    def collation(self) -> Optional[str]:
        """
        SQL Server collation.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter
    def cores(self) -> Optional[str]:
        """
        The number of total cores of the Operating System Environment (OSE) hosting the SQL Server instance.
        """
        return pulumi.get(self, "cores")

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional[str]:
        """
        SQL Server current version.
        """
        return pulumi.get(self, "current_version")

    @property
    @pulumi.getter
    def edition(self) -> Optional[str]:
        """
        SQL Server edition.
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="hostType")
    def host_type(self) -> Optional[str]:
        """
        Type of host for Azure Arc SQL Server
        """
        return pulumi.get(self, "host_type")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[str]:
        """
        SQL Server instance name.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        SQL Server license type.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="patchLevel")
    def patch_level(self) -> Optional[str]:
        """
        SQL Server update level.
        """
        return pulumi.get(self, "patch_level")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[str]:
        """
        SQL Server product ID.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="tcpDynamicPorts")
    def tcp_dynamic_ports(self) -> Optional[str]:
        """
        Dynamic TCP ports used by SQL Server.
        """
        return pulumi.get(self, "tcp_dynamic_ports")

    @property
    @pulumi.getter(name="tcpStaticPorts")
    def tcp_static_ports(self) -> Optional[str]:
        """
        Static TCP ports used by SQL Server.
        """
        return pulumi.get(self, "tcp_static_ports")

    @property
    @pulumi.getter(name="vCore")
    def v_core(self) -> Optional[str]:
        """
        The number of logical processors used by the SQL Server instance.
        """
        return pulumi.get(self, "v_core")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        SQL Server version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class UploadServicePrincipalResponse(dict):
    """
    Service principal for uploading billing, metrics and logs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UploadServicePrincipalResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UploadServicePrincipalResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UploadServicePrincipalResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authority: Optional[str] = None,
                 client_id: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Service principal for uploading billing, metrics and logs.
        :param str authority: Authority for the service principal. Example: https://login.microsoftonline.com/
        :param str client_id: Client ID of the service principal for uploading data.
        :param str tenant_id: Tenant ID of the service principal.
        """
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def authority(self) -> Optional[str]:
        """
        Authority for the service principal. Example: https://login.microsoftonline.com/
        """
        return pulumi.get(self, "authority")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Client ID of the service principal for uploading data.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Tenant ID of the service principal.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class UploadWatermarkResponse(dict):
    """
    Properties on upload watermark.  Mostly timestamp for each upload data type
    """
    def __init__(__self__, *,
                 logs: Optional[str] = None,
                 metrics: Optional[str] = None,
                 usages: Optional[str] = None):
        """
        Properties on upload watermark.  Mostly timestamp for each upload data type
        :param str logs: Last uploaded date for logs from kubernetes cluster. Defaults to current date time
        :param str metrics: Last uploaded date for metrics from kubernetes cluster. Defaults to current date time
        :param str usages: Last uploaded date for usages from kubernetes cluster. Defaults to current date time
        """
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if usages is not None:
            pulumi.set(__self__, "usages", usages)

    @property
    @pulumi.getter
    def logs(self) -> Optional[str]:
        """
        Last uploaded date for logs from kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "logs")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[str]:
        """
        Last uploaded date for metrics from kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def usages(self) -> Optional[str]:
        """
        Last uploaded date for usages from kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "usages")


