# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['FailoverGroupArgs', 'FailoverGroup']

@pulumi.input_type
class FailoverGroupArgs:
    def __init__(__self__, *,
                 properties: pulumi.Input['FailoverGroupPropertiesArgs'],
                 resource_group_name: pulumi.Input[str],
                 sql_managed_instance_name: pulumi.Input[str],
                 failover_group_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FailoverGroup resource.
        :param pulumi.Input['FailoverGroupPropertiesArgs'] properties: null
        :param pulumi.Input[str] resource_group_name: The name of the Azure resource group
        :param pulumi.Input[str] sql_managed_instance_name: Name of SQL Managed Instance
        :param pulumi.Input[str] failover_group_name: The name of the Failover Group
        """
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sql_managed_instance_name", sql_managed_instance_name)
        if failover_group_name is not None:
            pulumi.set(__self__, "failover_group_name", failover_group_name)

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Input['FailoverGroupPropertiesArgs']:
        """
        null
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: pulumi.Input['FailoverGroupPropertiesArgs']):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the Azure resource group
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="sqlManagedInstanceName")
    def sql_managed_instance_name(self) -> pulumi.Input[str]:
        """
        Name of SQL Managed Instance
        """
        return pulumi.get(self, "sql_managed_instance_name")

    @sql_managed_instance_name.setter
    def sql_managed_instance_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "sql_managed_instance_name", value)

    @property
    @pulumi.getter(name="failoverGroupName")
    def failover_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Failover Group
        """
        return pulumi.get(self, "failover_group_name")

    @failover_group_name.setter
    def failover_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failover_group_name", value)


class FailoverGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 failover_group_name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['FailoverGroupPropertiesArgs']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 sql_managed_instance_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A failover group resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] failover_group_name: The name of the Failover Group
        :param pulumi.Input[pulumi.InputType['FailoverGroupPropertiesArgs']] properties: null
        :param pulumi.Input[str] resource_group_name: The name of the Azure resource group
        :param pulumi.Input[str] sql_managed_instance_name: Name of SQL Managed Instance
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FailoverGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A failover group resource.

        :param str resource_name: The name of the resource.
        :param FailoverGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FailoverGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 failover_group_name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['FailoverGroupPropertiesArgs']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 sql_managed_instance_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FailoverGroupArgs.__new__(FailoverGroupArgs)

            __props__.__dict__["failover_group_name"] = failover_group_name
            if properties is None and not opts.urn:
                raise TypeError("Missing required property 'properties'")
            __props__.__dict__["properties"] = properties
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sql_managed_instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'sql_managed_instance_name'")
            __props__.__dict__["sql_managed_instance_name"] = sql_managed_instance_name
            __props__.__dict__["name"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:azurearcdata/v20230315preview:FailoverGroup")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(FailoverGroup, __self__).__init__(
            'azure-native:azurearcdata/v20230115preview:FailoverGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'FailoverGroup':
        """
        Get an existing FailoverGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FailoverGroupArgs.__new__(FailoverGroupArgs)

        __props__.__dict__["name"] = None
        __props__.__dict__["properties"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["type"] = None
        return FailoverGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output['outputs.FailoverGroupPropertiesResponse']:
        """
        null
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

