# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetManagedDatabaseVulnerabilityAssessmentRuleBaselineResult',
    'AwaitableGetManagedDatabaseVulnerabilityAssessmentRuleBaselineResult',
    'get_managed_database_vulnerability_assessment_rule_baseline',
    'get_managed_database_vulnerability_assessment_rule_baseline_output',
]

@pulumi.output_type
class GetManagedDatabaseVulnerabilityAssessmentRuleBaselineResult:
    """
    A database vulnerability assessment rule baseline.
    """
    def __init__(__self__, baseline_results=None, id=None, name=None, type=None):
        if baseline_results and not isinstance(baseline_results, list):
            raise TypeError("Expected argument 'baseline_results' to be a list")
        pulumi.set(__self__, "baseline_results", baseline_results)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="baselineResults")
    def baseline_results(self) -> Sequence['outputs.DatabaseVulnerabilityAssessmentRuleBaselineItemResponse']:
        """
        The rule baseline result
        """
        return pulumi.get(self, "baseline_results")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")


class AwaitableGetManagedDatabaseVulnerabilityAssessmentRuleBaselineResult(GetManagedDatabaseVulnerabilityAssessmentRuleBaselineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseVulnerabilityAssessmentRuleBaselineResult(
            baseline_results=self.baseline_results,
            id=self.id,
            name=self.name,
            type=self.type)


def get_managed_database_vulnerability_assessment_rule_baseline(baseline_name: Optional[str] = None,
                                                                database_name: Optional[str] = None,
                                                                managed_instance_name: Optional[str] = None,
                                                                resource_group_name: Optional[str] = None,
                                                                rule_id: Optional[str] = None,
                                                                vulnerability_assessment_name: Optional[str] = None,
                                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseVulnerabilityAssessmentRuleBaselineResult:
    """
    Gets a database's vulnerability assessment rule baseline.


    :param str baseline_name: The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule).
    :param str database_name: The name of the database for which the vulnerability assessment rule baseline is defined.
    :param str managed_instance_name: The name of the managed instance.
    :param str resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    :param str rule_id: The vulnerability assessment rule ID.
    :param str vulnerability_assessment_name: The name of the vulnerability assessment.
    """
    __args__ = dict()
    __args__['baselineName'] = baseline_name
    __args__['databaseName'] = database_name
    __args__['managedInstanceName'] = managed_instance_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['ruleId'] = rule_id
    __args__['vulnerabilityAssessmentName'] = vulnerability_assessment_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:sql/v20210801preview:getManagedDatabaseVulnerabilityAssessmentRuleBaseline', __args__, opts=opts, typ=GetManagedDatabaseVulnerabilityAssessmentRuleBaselineResult).value

    return AwaitableGetManagedDatabaseVulnerabilityAssessmentRuleBaselineResult(
        baseline_results=__ret__.baseline_results,
        id=__ret__.id,
        name=__ret__.name,
        type=__ret__.type)


@_utilities.lift_output_func(get_managed_database_vulnerability_assessment_rule_baseline)
def get_managed_database_vulnerability_assessment_rule_baseline_output(baseline_name: Optional[pulumi.Input[str]] = None,
                                                                       database_name: Optional[pulumi.Input[str]] = None,
                                                                       managed_instance_name: Optional[pulumi.Input[str]] = None,
                                                                       resource_group_name: Optional[pulumi.Input[str]] = None,
                                                                       rule_id: Optional[pulumi.Input[str]] = None,
                                                                       vulnerability_assessment_name: Optional[pulumi.Input[str]] = None,
                                                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseVulnerabilityAssessmentRuleBaselineResult]:
    """
    Gets a database's vulnerability assessment rule baseline.


    :param str baseline_name: The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule).
    :param str database_name: The name of the database for which the vulnerability assessment rule baseline is defined.
    :param str managed_instance_name: The name of the managed instance.
    :param str resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    :param str rule_id: The vulnerability assessment rule ID.
    :param str vulnerability_assessment_name: The name of the vulnerability assessment.
    """
    ...
