# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'ListApplianceKeysResult',
    'AwaitableListApplianceKeysResult',
    'list_appliance_keys',
    'list_appliance_keys_output',
]

@pulumi.output_type
class ListApplianceKeysResult:
    """
    The List Cluster Keys Results appliance.
    """
    def __init__(__self__, artifact_profiles=None, kubeconfigs=None, ssh_keys=None):
        if artifact_profiles and not isinstance(artifact_profiles, dict):
            raise TypeError("Expected argument 'artifact_profiles' to be a dict")
        pulumi.set(__self__, "artifact_profiles", artifact_profiles)
        if kubeconfigs and not isinstance(kubeconfigs, list):
            raise TypeError("Expected argument 'kubeconfigs' to be a list")
        pulumi.set(__self__, "kubeconfigs", kubeconfigs)
        if ssh_keys and not isinstance(ssh_keys, dict):
            raise TypeError("Expected argument 'ssh_keys' to be a dict")
        pulumi.set(__self__, "ssh_keys", ssh_keys)

    @property
    @pulumi.getter(name="artifactProfiles")
    def artifact_profiles(self) -> Mapping[str, 'outputs.ArtifactProfileResponse']:
        """
        Map of artifacts that contains a list of ArtifactProfile used to upload artifacts such as logs.
        """
        return pulumi.get(self, "artifact_profiles")

    @property
    @pulumi.getter
    def kubeconfigs(self) -> Sequence['outputs.ApplianceCredentialKubeconfigResponse']:
        """
        The list of appliance kubeconfigs.
        """
        return pulumi.get(self, "kubeconfigs")

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Mapping[str, 'outputs.SSHKeyResponse']:
        """
        Map of Customer User Public, Private SSH Keys and Certificate when available.
        """
        return pulumi.get(self, "ssh_keys")


class AwaitableListApplianceKeysResult(ListApplianceKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ListApplianceKeysResult(
            artifact_profiles=self.artifact_profiles,
            kubeconfigs=self.kubeconfigs,
            ssh_keys=self.ssh_keys)


def list_appliance_keys(resource_group_name: Optional[str] = None,
                        resource_name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableListApplianceKeysResult:
    """
    Returns the cluster customer credentials for the dedicated appliance.


    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str resource_name: Appliances name.
    """
    __args__ = dict()
    __args__['resourceGroupName'] = resource_group_name
    __args__['resourceName'] = resource_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:resourceconnector/v20221027:listApplianceKeys', __args__, opts=opts, typ=ListApplianceKeysResult).value

    return AwaitableListApplianceKeysResult(
        artifact_profiles=__ret__.artifact_profiles,
        kubeconfigs=__ret__.kubeconfigs,
        ssh_keys=__ret__.ssh_keys)


@_utilities.lift_output_func(list_appliance_keys)
def list_appliance_keys_output(resource_group_name: Optional[pulumi.Input[str]] = None,
                               resource_name: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ListApplianceKeysResult]:
    """
    Returns the cluster customer credentials for the dedicated appliance.


    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str resource_name: Appliances name.
    """
    ...
