# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SettingArgs', 'Setting']

@pulumi.input_type
class SettingArgs:
    def __init__(__self__, *,
                 scope: pulumi.Input[str],
                 cache: Optional[pulumi.Input[Sequence[pulumi.Input['SettingsPropertiesCacheArgs']]]] = None,
                 setting_name: Optional[pulumi.Input[str]] = None,
                 start_on: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Setting resource.
        :param pulumi.Input[str] scope: Sets the default scope the current user will see when they sign into Azure Cost Management in the Azure portal.
        :param pulumi.Input[Sequence[pulumi.Input['SettingsPropertiesCacheArgs']]] cache: Array of scopes with additional details used by Cost Management in the Azure portal.
        :param pulumi.Input[str] setting_name: Name of the setting. Allowed values: myscope
        :param pulumi.Input[str] start_on: Indicates what scope Cost Management in the Azure portal should default to. Allowed values: LastUsed.
        """
        pulumi.set(__self__, "scope", scope)
        if cache is not None:
            pulumi.set(__self__, "cache", cache)
        if setting_name is not None:
            pulumi.set(__self__, "setting_name", setting_name)
        if start_on is not None:
            pulumi.set(__self__, "start_on", start_on)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input[str]:
        """
        Sets the default scope the current user will see when they sign into Azure Cost Management in the Azure portal.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[str]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def cache(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SettingsPropertiesCacheArgs']]]]:
        """
        Array of scopes with additional details used by Cost Management in the Azure portal.
        """
        return pulumi.get(self, "cache")

    @cache.setter
    def cache(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SettingsPropertiesCacheArgs']]]]):
        pulumi.set(self, "cache", value)

    @property
    @pulumi.getter(name="settingName")
    def setting_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the setting. Allowed values: myscope
        """
        return pulumi.get(self, "setting_name")

    @setting_name.setter
    def setting_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "setting_name", value)

    @property
    @pulumi.getter(name="startOn")
    def start_on(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates what scope Cost Management in the Azure portal should default to. Allowed values: LastUsed.
        """
        return pulumi.get(self, "start_on")

    @start_on.setter
    def start_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_on", value)


class Setting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SettingsPropertiesCacheArgs']]]]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 setting_name: Optional[pulumi.Input[str]] = None,
                 start_on: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        State of the myscope setting.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SettingsPropertiesCacheArgs']]]] cache: Array of scopes with additional details used by Cost Management in the Azure portal.
        :param pulumi.Input[str] scope: Sets the default scope the current user will see when they sign into Azure Cost Management in the Azure portal.
        :param pulumi.Input[str] setting_name: Name of the setting. Allowed values: myscope
        :param pulumi.Input[str] start_on: Indicates what scope Cost Management in the Azure portal should default to. Allowed values: LastUsed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        State of the myscope setting.

        :param str resource_name: The name of the resource.
        :param SettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SettingsPropertiesCacheArgs']]]]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 setting_name: Optional[pulumi.Input[str]] = None,
                 start_on: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SettingArgs.__new__(SettingArgs)

            __props__.__dict__["cache"] = cache
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
            __props__.__dict__["setting_name"] = setting_name
            __props__.__dict__["start_on"] = start_on
            __props__.__dict__["kind"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:costmanagement:Setting")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Setting, __self__).__init__(
            'azure-native:costmanagement/v20191101:Setting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Setting':
        """
        Get an existing Setting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SettingArgs.__new__(SettingArgs)

        __props__.__dict__["cache"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["scope"] = None
        __props__.__dict__["start_on"] = None
        __props__.__dict__["type"] = None
        return Setting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cache(self) -> pulumi.Output[Optional[Sequence['outputs.SettingsPropertiesResponseCache']]]:
        """
        Array of scopes with additional details used by Cost Management in the Azure portal.
        """
        return pulumi.get(self, "cache")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        Resource kind.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[str]:
        """
        Sets the default scope the current user will see when they sign into Azure Cost Management in the Azure portal.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="startOn")
    def start_on(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates what scope Cost Management in the Azure portal should default to. Allowed values: LastUsed.
        """
        return pulumi.get(self, "start_on")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

