# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetNetworkSecurityPerimeterResult',
    'AwaitableGetNetworkSecurityPerimeterResult',
    'get_network_security_perimeter',
    'get_network_security_perimeter_output',
]

@pulumi.output_type
class GetNetworkSecurityPerimeterResult:
    """
    The Network Security Perimeter resource
    """
    def __init__(__self__, id=None, location=None, name=None, perimeter_guid=None, provisioning_state=None, tags=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if perimeter_guid and not isinstance(perimeter_guid, str):
            raise TypeError("Expected argument 'perimeter_guid' to be a str")
        pulumi.set(__self__, "perimeter_guid", perimeter_guid)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="perimeterGuid")
    def perimeter_guid(self) -> str:
        """
        perimeter guid of the network security perimeter.
        """
        return pulumi.get(self, "perimeter_guid")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the scope assignment resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")


class AwaitableGetNetworkSecurityPerimeterResult(GetNetworkSecurityPerimeterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkSecurityPerimeterResult(
            id=self.id,
            location=self.location,
            name=self.name,
            perimeter_guid=self.perimeter_guid,
            provisioning_state=self.provisioning_state,
            tags=self.tags,
            type=self.type)


def get_network_security_perimeter(network_security_perimeter_name: Optional[str] = None,
                                   resource_group_name: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkSecurityPerimeterResult:
    """
    Gets the specified network security perimeter by the name.
    API Version: 2021-02-01-preview.


    :param str network_security_perimeter_name: The name of the network security perimeter.
    :param str resource_group_name: The name of the resource group.
    """
    __args__ = dict()
    __args__['networkSecurityPerimeterName'] = network_security_perimeter_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:network:getNetworkSecurityPerimeter', __args__, opts=opts, typ=GetNetworkSecurityPerimeterResult).value

    return AwaitableGetNetworkSecurityPerimeterResult(
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        perimeter_guid=__ret__.perimeter_guid,
        provisioning_state=__ret__.provisioning_state,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_network_security_perimeter)
def get_network_security_perimeter_output(network_security_perimeter_name: Optional[pulumi.Input[str]] = None,
                                          resource_group_name: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetworkSecurityPerimeterResult]:
    """
    Gets the specified network security perimeter by the name.
    API Version: 2021-02-01-preview.


    :param str network_security_perimeter_name: The name of the network security perimeter.
    :param str resource_group_name: The name of the resource group.
    """
    ...
