# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'BoolEqualsAdvancedFilterResponse',
    'EventHubEventSubscriptionDestinationResponse',
    'EventSubscriptionFilterResponse',
    'HybridConnectionEventSubscriptionDestinationResponse',
    'JsonFieldResponse',
    'JsonFieldWithDefaultResponse',
    'JsonInputSchemaMappingResponse',
    'NumberGreaterThanAdvancedFilterResponse',
    'NumberGreaterThanOrEqualsAdvancedFilterResponse',
    'NumberInAdvancedFilterResponse',
    'NumberLessThanAdvancedFilterResponse',
    'NumberLessThanOrEqualsAdvancedFilterResponse',
    'NumberNotInAdvancedFilterResponse',
    'RetryPolicyResponse',
    'StorageBlobDeadLetterDestinationResponse',
    'StorageQueueEventSubscriptionDestinationResponse',
    'StringBeginsWithAdvancedFilterResponse',
    'StringContainsAdvancedFilterResponse',
    'StringEndsWithAdvancedFilterResponse',
    'StringInAdvancedFilterResponse',
    'StringNotInAdvancedFilterResponse',
    'WebHookEventSubscriptionDestinationResponse',
]

@pulumi.output_type
class BoolEqualsAdvancedFilterResponse(dict):
    """
    BoolEquals Filter
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BoolEqualsAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BoolEqualsAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BoolEqualsAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 value: Optional[bool] = None):
        """
        BoolEquals Filter
        :param str operator_type: Represents the filter operator
               Expected value is 'BoolEquals'.
        :param str key: The filter key. Represents an event property with up to two levels of nesting.
        :param bool value: The filter value
        """
        pulumi.set(__self__, "operator_type", 'BoolEquals')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        Represents the filter operator
        Expected value is 'BoolEquals'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The filter key. Represents an event property with up to two levels of nesting.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[bool]:
        """
        The filter value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EventHubEventSubscriptionDestinationResponse(dict):
    """
    Information about the event hub destination for an event subscription
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubEventSubscriptionDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubEventSubscriptionDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubEventSubscriptionDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: str,
                 resource_id: Optional[str] = None):
        """
        Information about the event hub destination for an event subscription
        :param str endpoint_type: Type of the endpoint for the event subscription destination
               Expected value is 'EventHub'.
        :param str resource_id: The Azure Resource Id that represents the endpoint of an Event Hub destination of an event subscription.
        """
        pulumi.set(__self__, "endpoint_type", 'EventHub')
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of the endpoint for the event subscription destination
        Expected value is 'EventHub'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The Azure Resource Id that represents the endpoint of an Event Hub destination of an event subscription.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class EventSubscriptionFilterResponse(dict):
    """
    Filter for the Event Subscription
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advancedFilters":
            suggest = "advanced_filters"
        elif key == "includedEventTypes":
            suggest = "included_event_types"
        elif key == "isSubjectCaseSensitive":
            suggest = "is_subject_case_sensitive"
        elif key == "subjectBeginsWith":
            suggest = "subject_begins_with"
        elif key == "subjectEndsWith":
            suggest = "subject_ends_with"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advanced_filters: Optional[Sequence[Any]] = None,
                 included_event_types: Optional[Sequence[str]] = None,
                 is_subject_case_sensitive: Optional[bool] = None,
                 subject_begins_with: Optional[str] = None,
                 subject_ends_with: Optional[str] = None):
        """
        Filter for the Event Subscription
        :param Sequence[Union['BoolEqualsAdvancedFilterResponse', 'NumberGreaterThanAdvancedFilterResponse', 'NumberGreaterThanOrEqualsAdvancedFilterResponse', 'NumberInAdvancedFilterResponse', 'NumberLessThanAdvancedFilterResponse', 'NumberLessThanOrEqualsAdvancedFilterResponse', 'NumberNotInAdvancedFilterResponse', 'StringBeginsWithAdvancedFilterResponse', 'StringContainsAdvancedFilterResponse', 'StringEndsWithAdvancedFilterResponse', 'StringInAdvancedFilterResponse', 'StringNotInAdvancedFilterResponse']] advanced_filters: A list of advanced filters.
        :param Sequence[str] included_event_types: A list of applicable event types that need to be part of the event subscription. 
               If it is desired to subscribe to all event types, the string "all" needs to be specified as an element in this list.
        :param bool is_subject_case_sensitive: Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the filter 
               should be compared in a case sensitive manner.
        :param str subject_begins_with: An optional string to filter events for an event subscription based on a resource path prefix.
               The format of this depends on the publisher of the events. 
               Wildcard characters are not supported in this path.
        :param str subject_ends_with: An optional string to filter events for an event subscription based on a resource path suffix.
               Wildcard characters are not supported in this path.
        """
        if advanced_filters is not None:
            pulumi.set(__self__, "advanced_filters", advanced_filters)
        if included_event_types is not None:
            pulumi.set(__self__, "included_event_types", included_event_types)
        if is_subject_case_sensitive is None:
            is_subject_case_sensitive = False
        if is_subject_case_sensitive is not None:
            pulumi.set(__self__, "is_subject_case_sensitive", is_subject_case_sensitive)
        if subject_begins_with is not None:
            pulumi.set(__self__, "subject_begins_with", subject_begins_with)
        if subject_ends_with is not None:
            pulumi.set(__self__, "subject_ends_with", subject_ends_with)

    @property
    @pulumi.getter(name="advancedFilters")
    def advanced_filters(self) -> Optional[Sequence[Any]]:
        """
        A list of advanced filters.
        """
        return pulumi.get(self, "advanced_filters")

    @property
    @pulumi.getter(name="includedEventTypes")
    def included_event_types(self) -> Optional[Sequence[str]]:
        """
        A list of applicable event types that need to be part of the event subscription. 
        If it is desired to subscribe to all event types, the string "all" needs to be specified as an element in this list.
        """
        return pulumi.get(self, "included_event_types")

    @property
    @pulumi.getter(name="isSubjectCaseSensitive")
    def is_subject_case_sensitive(self) -> Optional[bool]:
        """
        Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the filter 
        should be compared in a case sensitive manner.
        """
        return pulumi.get(self, "is_subject_case_sensitive")

    @property
    @pulumi.getter(name="subjectBeginsWith")
    def subject_begins_with(self) -> Optional[str]:
        """
        An optional string to filter events for an event subscription based on a resource path prefix.
        The format of this depends on the publisher of the events. 
        Wildcard characters are not supported in this path.
        """
        return pulumi.get(self, "subject_begins_with")

    @property
    @pulumi.getter(name="subjectEndsWith")
    def subject_ends_with(self) -> Optional[str]:
        """
        An optional string to filter events for an event subscription based on a resource path suffix.
        Wildcard characters are not supported in this path.
        """
        return pulumi.get(self, "subject_ends_with")


@pulumi.output_type
class HybridConnectionEventSubscriptionDestinationResponse(dict):
    """
    Information about the HybridConnection destination for an event subscription.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HybridConnectionEventSubscriptionDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HybridConnectionEventSubscriptionDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HybridConnectionEventSubscriptionDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: str,
                 resource_id: Optional[str] = None):
        """
        Information about the HybridConnection destination for an event subscription.
        :param str endpoint_type: Type of the endpoint for the event subscription destination
               Expected value is 'HybridConnection'.
        :param str resource_id: The Azure Resource ID of an hybrid connection that is the destination of an event subscription.
        """
        pulumi.set(__self__, "endpoint_type", 'HybridConnection')
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of the endpoint for the event subscription destination
        Expected value is 'HybridConnection'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The Azure Resource ID of an hybrid connection that is the destination of an event subscription.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class JsonFieldResponse(dict):
    """
    This is used to express the source of an input schema mapping for a single target field in the Event Grid Event schema. This is currently used in the mappings for the 'id','topic' and 'eventTime' properties. This represents a field in the input event schema.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceField":
            suggest = "source_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JsonFieldResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JsonFieldResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JsonFieldResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_field: Optional[str] = None):
        """
        This is used to express the source of an input schema mapping for a single target field in the Event Grid Event schema. This is currently used in the mappings for the 'id','topic' and 'eventTime' properties. This represents a field in the input event schema.
        :param str source_field: Name of a field in the input event schema that's to be used as the source of a mapping.
        """
        if source_field is not None:
            pulumi.set(__self__, "source_field", source_field)

    @property
    @pulumi.getter(name="sourceField")
    def source_field(self) -> Optional[str]:
        """
        Name of a field in the input event schema that's to be used as the source of a mapping.
        """
        return pulumi.get(self, "source_field")


@pulumi.output_type
class JsonFieldWithDefaultResponse(dict):
    """
    This is used to express the source of an input schema mapping for a single target field in the Event Grid Event schema. This is currently used in the mappings for the 'subject','eventType' and 'dataVersion' properties. This represents a field in the input event schema along with a default value to be used, and at least one of these two properties should be provided.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "sourceField":
            suggest = "source_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JsonFieldWithDefaultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JsonFieldWithDefaultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JsonFieldWithDefaultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: Optional[str] = None,
                 source_field: Optional[str] = None):
        """
        This is used to express the source of an input schema mapping for a single target field in the Event Grid Event schema. This is currently used in the mappings for the 'subject','eventType' and 'dataVersion' properties. This represents a field in the input event schema along with a default value to be used, and at least one of these two properties should be provided.
        :param str default_value: The default value to be used for mapping when a SourceField is not provided or if there's no property with the specified name in the published JSON event payload.
        :param str source_field: Name of a field in the input event schema that's to be used as the source of a mapping.
        """
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if source_field is not None:
            pulumi.set(__self__, "source_field", source_field)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[str]:
        """
        The default value to be used for mapping when a SourceField is not provided or if there's no property with the specified name in the published JSON event payload.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="sourceField")
    def source_field(self) -> Optional[str]:
        """
        Name of a field in the input event schema that's to be used as the source of a mapping.
        """
        return pulumi.get(self, "source_field")


@pulumi.output_type
class JsonInputSchemaMappingResponse(dict):
    """
    This enables publishing to Event Grid using a custom input schema. This can be used to map properties from a custom input JSON schema to the Event Grid event schema.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVersion":
            suggest = "data_version"
        elif key == "eventTime":
            suggest = "event_time"
        elif key == "eventType":
            suggest = "event_type"
        elif key == "inputSchemaMappingType":
            suggest = "input_schema_mapping_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JsonInputSchemaMappingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JsonInputSchemaMappingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JsonInputSchemaMappingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_version: Optional['outputs.JsonFieldWithDefaultResponse'] = None,
                 event_time: Optional['outputs.JsonFieldResponse'] = None,
                 event_type: Optional['outputs.JsonFieldWithDefaultResponse'] = None,
                 id: Optional['outputs.JsonFieldResponse'] = None,
                 input_schema_mapping_type: Optional[str] = None,
                 subject: Optional['outputs.JsonFieldWithDefaultResponse'] = None,
                 topic: Optional['outputs.JsonFieldResponse'] = None):
        """
        This enables publishing to Event Grid using a custom input schema. This can be used to map properties from a custom input JSON schema to the Event Grid event schema.
        :param 'JsonFieldWithDefaultResponse' data_version: The mapping information for the DataVersion property of the Event Grid Event.
        :param 'JsonFieldResponse' event_time: The mapping information for the EventTime property of the Event Grid Event.
        :param 'JsonFieldWithDefaultResponse' event_type: The mapping information for the EventType property of the Event Grid Event.
        :param 'JsonFieldResponse' id: The mapping information for the Id property of the Event Grid Event.
        :param str input_schema_mapping_type: Type of the custom mapping
               Expected value is 'Json'.
        :param 'JsonFieldWithDefaultResponse' subject: The mapping information for the Subject property of the Event Grid Event.
        :param 'JsonFieldResponse' topic: The mapping information for the Topic property of the Event Grid Event.
        """
        if data_version is not None:
            pulumi.set(__self__, "data_version", data_version)
        if event_time is not None:
            pulumi.set(__self__, "event_time", event_time)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if input_schema_mapping_type is not None:
            pulumi.set(__self__, "input_schema_mapping_type", 'Json')
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="dataVersion")
    def data_version(self) -> Optional['outputs.JsonFieldWithDefaultResponse']:
        """
        The mapping information for the DataVersion property of the Event Grid Event.
        """
        return pulumi.get(self, "data_version")

    @property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> Optional['outputs.JsonFieldResponse']:
        """
        The mapping information for the EventTime property of the Event Grid Event.
        """
        return pulumi.get(self, "event_time")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional['outputs.JsonFieldWithDefaultResponse']:
        """
        The mapping information for the EventType property of the Event Grid Event.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter
    def id(self) -> Optional['outputs.JsonFieldResponse']:
        """
        The mapping information for the Id property of the Event Grid Event.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inputSchemaMappingType")
    def input_schema_mapping_type(self) -> Optional[str]:
        """
        Type of the custom mapping
        Expected value is 'Json'.
        """
        return pulumi.get(self, "input_schema_mapping_type")

    @property
    @pulumi.getter
    def subject(self) -> Optional['outputs.JsonFieldWithDefaultResponse']:
        """
        The mapping information for the Subject property of the Event Grid Event.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def topic(self) -> Optional['outputs.JsonFieldResponse']:
        """
        The mapping information for the Topic property of the Event Grid Event.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class NumberGreaterThanAdvancedFilterResponse(dict):
    """
    NumberGreaterThan Filter
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NumberGreaterThanAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NumberGreaterThanAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NumberGreaterThanAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 value: Optional[float] = None):
        """
        NumberGreaterThan Filter
        :param str operator_type: Represents the filter operator
               Expected value is 'NumberGreaterThan'.
        :param str key: The filter key. Represents an event property with up to two levels of nesting.
        :param float value: The filter value
        """
        pulumi.set(__self__, "operator_type", 'NumberGreaterThan')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        Represents the filter operator
        Expected value is 'NumberGreaterThan'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The filter key. Represents an event property with up to two levels of nesting.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[float]:
        """
        The filter value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NumberGreaterThanOrEqualsAdvancedFilterResponse(dict):
    """
    NumberGreaterThanOrEquals Filter
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NumberGreaterThanOrEqualsAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NumberGreaterThanOrEqualsAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NumberGreaterThanOrEqualsAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 value: Optional[float] = None):
        """
        NumberGreaterThanOrEquals Filter
        :param str operator_type: Represents the filter operator
               Expected value is 'NumberGreaterThanOrEquals'.
        :param str key: The filter key. Represents an event property with up to two levels of nesting.
        :param float value: The filter value
        """
        pulumi.set(__self__, "operator_type", 'NumberGreaterThanOrEquals')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        Represents the filter operator
        Expected value is 'NumberGreaterThanOrEquals'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The filter key. Represents an event property with up to two levels of nesting.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[float]:
        """
        The filter value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NumberInAdvancedFilterResponse(dict):
    """
    NumberIn filter
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NumberInAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NumberInAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NumberInAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[float]] = None):
        """
        NumberIn filter
        :param str operator_type: Represents the filter operator
               Expected value is 'NumberIn'.
        :param str key: The filter key. Represents an event property with up to two levels of nesting.
        :param Sequence[float] values: The set of filter values
        """
        pulumi.set(__self__, "operator_type", 'NumberIn')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        Represents the filter operator
        Expected value is 'NumberIn'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The filter key. Represents an event property with up to two levels of nesting.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[float]]:
        """
        The set of filter values
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class NumberLessThanAdvancedFilterResponse(dict):
    """
    NumberLessThan Filter
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NumberLessThanAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NumberLessThanAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NumberLessThanAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 value: Optional[float] = None):
        """
        NumberLessThan Filter
        :param str operator_type: Represents the filter operator
               Expected value is 'NumberLessThan'.
        :param str key: The filter key. Represents an event property with up to two levels of nesting.
        :param float value: The filter value
        """
        pulumi.set(__self__, "operator_type", 'NumberLessThan')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        Represents the filter operator
        Expected value is 'NumberLessThan'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The filter key. Represents an event property with up to two levels of nesting.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[float]:
        """
        The filter value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NumberLessThanOrEqualsAdvancedFilterResponse(dict):
    """
    NumberLessThanOrEquals Filter
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NumberLessThanOrEqualsAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NumberLessThanOrEqualsAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NumberLessThanOrEqualsAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 value: Optional[float] = None):
        """
        NumberLessThanOrEquals Filter
        :param str operator_type: Represents the filter operator
               Expected value is 'NumberLessThanOrEquals'.
        :param str key: The filter key. Represents an event property with up to two levels of nesting.
        :param float value: The filter value
        """
        pulumi.set(__self__, "operator_type", 'NumberLessThanOrEquals')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        Represents the filter operator
        Expected value is 'NumberLessThanOrEquals'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The filter key. Represents an event property with up to two levels of nesting.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[float]:
        """
        The filter value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NumberNotInAdvancedFilterResponse(dict):
    """
    NumberNotIn Filter
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NumberNotInAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NumberNotInAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NumberNotInAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[float]] = None):
        """
        NumberNotIn Filter
        :param str operator_type: Represents the filter operator
               Expected value is 'NumberNotIn'.
        :param str key: The filter key. Represents an event property with up to two levels of nesting.
        :param Sequence[float] values: The set of filter values
        """
        pulumi.set(__self__, "operator_type", 'NumberNotIn')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        Represents the filter operator
        Expected value is 'NumberNotIn'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The filter key. Represents an event property with up to two levels of nesting.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[float]]:
        """
        The set of filter values
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class RetryPolicyResponse(dict):
    """
    Information about the retry policy for an event subscription
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventTimeToLiveInMinutes":
            suggest = "event_time_to_live_in_minutes"
        elif key == "maxDeliveryAttempts":
            suggest = "max_delivery_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetryPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetryPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetryPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_time_to_live_in_minutes: Optional[int] = None,
                 max_delivery_attempts: Optional[int] = None):
        """
        Information about the retry policy for an event subscription
        :param int event_time_to_live_in_minutes: Time To Live (in minutes) for events.
        :param int max_delivery_attempts: Maximum number of delivery retry attempts for events.
        """
        if event_time_to_live_in_minutes is not None:
            pulumi.set(__self__, "event_time_to_live_in_minutes", event_time_to_live_in_minutes)
        if max_delivery_attempts is not None:
            pulumi.set(__self__, "max_delivery_attempts", max_delivery_attempts)

    @property
    @pulumi.getter(name="eventTimeToLiveInMinutes")
    def event_time_to_live_in_minutes(self) -> Optional[int]:
        """
        Time To Live (in minutes) for events.
        """
        return pulumi.get(self, "event_time_to_live_in_minutes")

    @property
    @pulumi.getter(name="maxDeliveryAttempts")
    def max_delivery_attempts(self) -> Optional[int]:
        """
        Maximum number of delivery retry attempts for events.
        """
        return pulumi.get(self, "max_delivery_attempts")


@pulumi.output_type
class StorageBlobDeadLetterDestinationResponse(dict):
    """
    Information about the storage blob based dead letter destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "blobContainerName":
            suggest = "blob_container_name"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageBlobDeadLetterDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageBlobDeadLetterDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageBlobDeadLetterDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: str,
                 blob_container_name: Optional[str] = None,
                 resource_id: Optional[str] = None):
        """
        Information about the storage blob based dead letter destination.
        :param str endpoint_type: Type of the endpoint for the dead letter destination
               Expected value is 'StorageBlob'.
        :param str blob_container_name: The name of the Storage blob container that is the destination of the deadletter events
        :param str resource_id: The Azure Resource ID of the storage account that is the destination of the deadletter events
        """
        pulumi.set(__self__, "endpoint_type", 'StorageBlob')
        if blob_container_name is not None:
            pulumi.set(__self__, "blob_container_name", blob_container_name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of the endpoint for the dead letter destination
        Expected value is 'StorageBlob'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="blobContainerName")
    def blob_container_name(self) -> Optional[str]:
        """
        The name of the Storage blob container that is the destination of the deadletter events
        """
        return pulumi.get(self, "blob_container_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The Azure Resource ID of the storage account that is the destination of the deadletter events
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class StorageQueueEventSubscriptionDestinationResponse(dict):
    """
    Information about the storage queue destination for an event subscription.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "queueName":
            suggest = "queue_name"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageQueueEventSubscriptionDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageQueueEventSubscriptionDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageQueueEventSubscriptionDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: str,
                 queue_name: Optional[str] = None,
                 resource_id: Optional[str] = None):
        """
        Information about the storage queue destination for an event subscription.
        :param str endpoint_type: Type of the endpoint for the event subscription destination
               Expected value is 'StorageQueue'.
        :param str queue_name: The name of the Storage queue under a storage account that is the destination of an event subscription.
        :param str resource_id: The Azure Resource ID of the storage account that contains the queue that is the destination of an event subscription.
        """
        pulumi.set(__self__, "endpoint_type", 'StorageQueue')
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of the endpoint for the event subscription destination
        Expected value is 'StorageQueue'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[str]:
        """
        The name of the Storage queue under a storage account that is the destination of an event subscription.
        """
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The Azure Resource ID of the storage account that contains the queue that is the destination of an event subscription.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class StringBeginsWithAdvancedFilterResponse(dict):
    """
    StringBeginsWith Filter
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StringBeginsWithAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StringBeginsWithAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StringBeginsWithAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        StringBeginsWith Filter
        :param str operator_type: Represents the filter operator
               Expected value is 'StringBeginsWith'.
        :param str key: The filter key. Represents an event property with up to two levels of nesting.
        :param Sequence[str] values: The set of filter values
        """
        pulumi.set(__self__, "operator_type", 'StringBeginsWith')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        Represents the filter operator
        Expected value is 'StringBeginsWith'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The filter key. Represents an event property with up to two levels of nesting.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        The set of filter values
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class StringContainsAdvancedFilterResponse(dict):
    """
    StringContains Filter
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StringContainsAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StringContainsAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StringContainsAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        StringContains Filter
        :param str operator_type: Represents the filter operator
               Expected value is 'StringContains'.
        :param str key: The filter key. Represents an event property with up to two levels of nesting.
        :param Sequence[str] values: The set of filter values
        """
        pulumi.set(__self__, "operator_type", 'StringContains')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        Represents the filter operator
        Expected value is 'StringContains'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The filter key. Represents an event property with up to two levels of nesting.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        The set of filter values
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class StringEndsWithAdvancedFilterResponse(dict):
    """
    StringEndsWith Filter
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StringEndsWithAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StringEndsWithAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StringEndsWithAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        StringEndsWith Filter
        :param str operator_type: Represents the filter operator
               Expected value is 'StringEndsWith'.
        :param str key: The filter key. Represents an event property with up to two levels of nesting.
        :param Sequence[str] values: The set of filter values
        """
        pulumi.set(__self__, "operator_type", 'StringEndsWith')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        Represents the filter operator
        Expected value is 'StringEndsWith'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The filter key. Represents an event property with up to two levels of nesting.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        The set of filter values
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class StringInAdvancedFilterResponse(dict):
    """
    StringIn Filter
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StringInAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StringInAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StringInAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        StringIn Filter
        :param str operator_type: Represents the filter operator
               Expected value is 'StringIn'.
        :param str key: The filter key. Represents an event property with up to two levels of nesting.
        :param Sequence[str] values: The set of filter values
        """
        pulumi.set(__self__, "operator_type", 'StringIn')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        Represents the filter operator
        Expected value is 'StringIn'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The filter key. Represents an event property with up to two levels of nesting.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        The set of filter values
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class StringNotInAdvancedFilterResponse(dict):
    """
    StringNotIn Filter
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StringNotInAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StringNotInAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StringNotInAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        StringNotIn Filter
        :param str operator_type: Represents the filter operator
               Expected value is 'StringNotIn'.
        :param str key: The filter key. Represents an event property with up to two levels of nesting.
        :param Sequence[str] values: The set of filter values
        """
        pulumi.set(__self__, "operator_type", 'StringNotIn')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        Represents the filter operator
        Expected value is 'StringNotIn'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The filter key. Represents an event property with up to two levels of nesting.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        The set of filter values
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class WebHookEventSubscriptionDestinationResponse(dict):
    """
    Information about the webhook destination for an event subscription
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointBaseUrl":
            suggest = "endpoint_base_url"
        elif key == "endpointType":
            suggest = "endpoint_type"
        elif key == "endpointUrl":
            suggest = "endpoint_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebHookEventSubscriptionDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebHookEventSubscriptionDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebHookEventSubscriptionDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_base_url: str,
                 endpoint_type: str,
                 endpoint_url: Optional[str] = None):
        """
        Information about the webhook destination for an event subscription
        :param str endpoint_base_url: The base URL that represents the endpoint of the destination of an event subscription.
        :param str endpoint_type: Type of the endpoint for the event subscription destination
               Expected value is 'WebHook'.
        :param str endpoint_url: The URL that represents the endpoint of the destination of an event subscription.
        """
        pulumi.set(__self__, "endpoint_base_url", endpoint_base_url)
        pulumi.set(__self__, "endpoint_type", 'WebHook')
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)

    @property
    @pulumi.getter(name="endpointBaseUrl")
    def endpoint_base_url(self) -> str:
        """
        The base URL that represents the endpoint of the destination of an event subscription.
        """
        return pulumi.get(self, "endpoint_base_url")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of the endpoint for the event subscription destination
        Expected value is 'WebHook'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[str]:
        """
        The URL that represents the endpoint of the destination of an event subscription.
        """
        return pulumi.get(self, "endpoint_url")


