# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AzureActiveDirectoryAppArgs',
    'BlobShareArgs',
    'ConnectToMongoDbTaskPropertiesArgs',
    'ConnectToSourceMySqlTaskInputArgs',
    'ConnectToSourceMySqlTaskPropertiesArgs',
    'ConnectToSourceOracleSyncTaskInputArgs',
    'ConnectToSourceOracleSyncTaskPropertiesArgs',
    'ConnectToSourcePostgreSqlSyncTaskInputArgs',
    'ConnectToSourcePostgreSqlSyncTaskPropertiesArgs',
    'ConnectToSourceSqlServerSyncTaskPropertiesArgs',
    'ConnectToSourceSqlServerTaskInputArgs',
    'ConnectToSourceSqlServerTaskPropertiesArgs',
    'ConnectToTargetAzureDbForMySqlTaskInputArgs',
    'ConnectToTargetAzureDbForMySqlTaskPropertiesArgs',
    'ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs',
    'ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesArgs',
    'ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs',
    'ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs',
    'ConnectToTargetSqlDbTaskInputArgs',
    'ConnectToTargetSqlDbTaskPropertiesArgs',
    'ConnectToTargetSqlMISyncTaskInputArgs',
    'ConnectToTargetSqlMISyncTaskPropertiesArgs',
    'ConnectToTargetSqlMITaskInputArgs',
    'ConnectToTargetSqlMITaskPropertiesArgs',
    'ConnectToTargetSqlSqlDbSyncTaskInputArgs',
    'ConnectToTargetSqlSqlDbSyncTaskPropertiesArgs',
    'DatabaseInfoArgs',
    'DatabaseMigrationPropertiesSqlDbArgs',
    'FileShareArgs',
    'GetTdeCertificatesSqlTaskInputArgs',
    'GetTdeCertificatesSqlTaskPropertiesArgs',
    'GetUserTablesMySqlTaskInputArgs',
    'GetUserTablesMySqlTaskPropertiesArgs',
    'GetUserTablesOracleTaskInputArgs',
    'GetUserTablesOracleTaskPropertiesArgs',
    'GetUserTablesPostgreSqlTaskInputArgs',
    'GetUserTablesPostgreSqlTaskPropertiesArgs',
    'GetUserTablesSqlSyncTaskInputArgs',
    'GetUserTablesSqlSyncTaskPropertiesArgs',
    'GetUserTablesSqlTaskInputArgs',
    'GetUserTablesSqlTaskPropertiesArgs',
    'MiSqlConnectionInfoArgs',
    'MigrateMongoDbTaskPropertiesArgs',
    'MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgs',
    'MigrateMySqlAzureDbForMySqlOfflineTaskInputArgs',
    'MigrateMySqlAzureDbForMySqlOfflineTaskPropertiesArgs',
    'MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs',
    'MigrateMySqlAzureDbForMySqlSyncTaskInputArgs',
    'MigrateMySqlAzureDbForMySqlSyncTaskPropertiesArgs',
    'MigrateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs',
    'MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs',
    'MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs',
    'MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs',
    'MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs',
    'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs',
    'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskPropertiesArgs',
    'MigrateSqlServerSqlDbDatabaseInputArgs',
    'MigrateSqlServerSqlDbSyncDatabaseInputArgs',
    'MigrateSqlServerSqlDbSyncTaskInputArgs',
    'MigrateSqlServerSqlDbSyncTaskPropertiesArgs',
    'MigrateSqlServerSqlDbTaskInputArgs',
    'MigrateSqlServerSqlDbTaskPropertiesArgs',
    'MigrateSqlServerSqlMIDatabaseInputArgs',
    'MigrateSqlServerSqlMISyncTaskInputArgs',
    'MigrateSqlServerSqlMISyncTaskPropertiesArgs',
    'MigrateSqlServerSqlMITaskInputArgs',
    'MigrateSqlServerSqlMITaskPropertiesArgs',
    'MigrateSsisTaskInputArgs',
    'MigrateSsisTaskPropertiesArgs',
    'MigrationValidationOptionsArgs',
    'MongoDbCollectionSettingsArgs',
    'MongoDbConnectionInfoArgs',
    'MongoDbDatabaseSettingsArgs',
    'MongoDbMigrationSettingsArgs',
    'MongoDbShardKeyFieldArgs',
    'MongoDbShardKeySettingArgs',
    'MongoDbThrottlingSettingsArgs',
    'MySqlConnectionInfoArgs',
    'OracleConnectionInfoArgs',
    'PostgreSqlConnectionInfoArgs',
    'ProjectFilePropertiesArgs',
    'SelectedCertificateInputArgs',
    'ServiceSkuArgs',
    'SqlConnectionInformationArgs',
    'SqlConnectionInfoArgs',
    'SsisMigrationInfoArgs',
    'ValidateMigrationInputSqlServerSqlDbSyncTaskPropertiesArgs',
    'ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs',
    'ValidateMigrationInputSqlServerSqlMISyncTaskPropertiesArgs',
    'ValidateMigrationInputSqlServerSqlMITaskInputArgs',
    'ValidateMigrationInputSqlServerSqlMITaskPropertiesArgs',
    'ValidateMongoDbTaskPropertiesArgs',
    'ValidateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs',
    'ValidateSyncMigrationInputSqlServerTaskInputArgs',
]

@pulumi.input_type
class AzureActiveDirectoryAppArgs:
    def __init__(__self__, *,
                 app_key: Optional[pulumi.Input[str]] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 ignore_azure_permissions: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Azure Active Directory Application
        :param pulumi.Input[str] app_key: Key used to authenticate to the Azure Active Directory Application
        :param pulumi.Input[str] application_id: Application ID of the Azure Active Directory Application
        :param pulumi.Input[bool] ignore_azure_permissions: Ignore checking azure permissions on the AAD app
        :param pulumi.Input[str] tenant_id: Tenant id of the customer
        """
        if app_key is not None:
            pulumi.set(__self__, "app_key", app_key)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if ignore_azure_permissions is not None:
            pulumi.set(__self__, "ignore_azure_permissions", ignore_azure_permissions)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> Optional[pulumi.Input[str]]:
        """
        Key used to authenticate to the Azure Active Directory Application
        """
        return pulumi.get(self, "app_key")

    @app_key.setter
    def app_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_key", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        Application ID of the Azure Active Directory Application
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="ignoreAzurePermissions")
    def ignore_azure_permissions(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignore checking azure permissions on the AAD app
        """
        return pulumi.get(self, "ignore_azure_permissions")

    @ignore_azure_permissions.setter
    def ignore_azure_permissions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_azure_permissions", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenant id of the customer
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class BlobShareArgs:
    def __init__(__self__, *,
                 sas_uri: Optional[pulumi.Input[str]] = None):
        """
        Blob container storage information.
        :param pulumi.Input[str] sas_uri: SAS URI of Azure Storage Account Container.
        """
        if sas_uri is not None:
            pulumi.set(__self__, "sas_uri", sas_uri)

    @property
    @pulumi.getter(name="sasUri")
    def sas_uri(self) -> Optional[pulumi.Input[str]]:
        """
        SAS URI of Azure Storage Account Container.
        """
        return pulumi.get(self, "sas_uri")

    @sas_uri.setter
    def sas_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_uri", value)


@pulumi.input_type
class ConnectToMongoDbTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['MongoDbConnectionInfoArgs']] = None):
        """
        Properties for the task that validates the connection to and provides information about a MongoDB server
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Connect.MongoDb'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['MongoDbConnectionInfoArgs'] input: Describes a connection to a MongoDB data source
        """
        pulumi.set(__self__, "task_type", 'Connect.MongoDb')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Connect.MongoDb'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MongoDbConnectionInfoArgs']]:
        """
        Describes a connection to a MongoDB data source
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MongoDbConnectionInfoArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToSourceMySqlTaskInputArgs:
    def __init__(__self__, *,
                 source_connection_info: pulumi.Input['MySqlConnectionInfoArgs'],
                 check_permissions_group: Optional[pulumi.Input[Union[str, 'ServerLevelPermissionsGroup']]] = None,
                 is_offline_migration: Optional[pulumi.Input[bool]] = None,
                 target_platform: Optional[pulumi.Input[Union[str, 'MySqlTargetPlatformType']]] = None):
        """
        Input for the task that validates MySQL database connection
        :param pulumi.Input['MySqlConnectionInfoArgs'] source_connection_info: Information for connecting to MySQL source
        :param pulumi.Input[Union[str, 'ServerLevelPermissionsGroup']] check_permissions_group: Permission group for validations
        :param pulumi.Input[bool] is_offline_migration: Flag for whether or not the migration is offline
        :param pulumi.Input[Union[str, 'MySqlTargetPlatformType']] target_platform: Target Platform for the migration
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        if check_permissions_group is not None:
            pulumi.set(__self__, "check_permissions_group", check_permissions_group)
        if is_offline_migration is None:
            is_offline_migration = False
        if is_offline_migration is not None:
            pulumi.set(__self__, "is_offline_migration", is_offline_migration)
        if target_platform is not None:
            pulumi.set(__self__, "target_platform", target_platform)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['MySqlConnectionInfoArgs']:
        """
        Information for connecting to MySQL source
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['MySqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="checkPermissionsGroup")
    def check_permissions_group(self) -> Optional[pulumi.Input[Union[str, 'ServerLevelPermissionsGroup']]]:
        """
        Permission group for validations
        """
        return pulumi.get(self, "check_permissions_group")

    @check_permissions_group.setter
    def check_permissions_group(self, value: Optional[pulumi.Input[Union[str, 'ServerLevelPermissionsGroup']]]):
        pulumi.set(self, "check_permissions_group", value)

    @property
    @pulumi.getter(name="isOfflineMigration")
    def is_offline_migration(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag for whether or not the migration is offline
        """
        return pulumi.get(self, "is_offline_migration")

    @is_offline_migration.setter
    def is_offline_migration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_offline_migration", value)

    @property
    @pulumi.getter(name="targetPlatform")
    def target_platform(self) -> Optional[pulumi.Input[Union[str, 'MySqlTargetPlatformType']]]:
        """
        Target Platform for the migration
        """
        return pulumi.get(self, "target_platform")

    @target_platform.setter
    def target_platform(self, value: Optional[pulumi.Input[Union[str, 'MySqlTargetPlatformType']]]):
        pulumi.set(self, "target_platform", value)


@pulumi.input_type
class ConnectToSourceMySqlTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['ConnectToSourceMySqlTaskInputArgs']] = None):
        """
        Properties for the task that validates MySQL database connection
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToSource.MySql'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['ConnectToSourceMySqlTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToSource.MySql')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToSource.MySql'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToSourceMySqlTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToSourceMySqlTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToSourceOracleSyncTaskInputArgs:
    def __init__(__self__, *,
                 source_connection_info: pulumi.Input['OracleConnectionInfoArgs']):
        """
        Input for the task that validates Oracle database connection
        :param pulumi.Input['OracleConnectionInfoArgs'] source_connection_info: Information for connecting to Oracle source
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['OracleConnectionInfoArgs']:
        """
        Information for connecting to Oracle source
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['OracleConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)


@pulumi.input_type
class ConnectToSourceOracleSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['ConnectToSourceOracleSyncTaskInputArgs']] = None):
        """
        Properties for the task that validates Oracle database connection
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToSource.Oracle.Sync'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['ConnectToSourceOracleSyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToSource.Oracle.Sync')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToSource.Oracle.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToSourceOracleSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToSourceOracleSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToSourcePostgreSqlSyncTaskInputArgs:
    def __init__(__self__, *,
                 source_connection_info: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        """
        Input for the task that validates connection to PostgreSQL and source server requirements
        :param pulumi.Input['PostgreSqlConnectionInfoArgs'] source_connection_info: Connection information for source PostgreSQL server
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['PostgreSqlConnectionInfoArgs']:
        """
        Connection information for source PostgreSQL server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)


@pulumi.input_type
class ConnectToSourcePostgreSqlSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['ConnectToSourcePostgreSqlSyncTaskInputArgs']] = None):
        """
        Properties for the task that validates connection to PostgreSQL server and source server requirements for online migration
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToSource.PostgreSql.Sync'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['ConnectToSourcePostgreSqlSyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToSource.PostgreSql.Sync')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToSource.PostgreSql.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToSourcePostgreSqlSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToSourcePostgreSqlSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToSourceSqlServerSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['ConnectToSourceSqlServerTaskInputArgs']] = None):
        """
        Properties for the task that validates connection to SQL Server and source server requirements for online migration
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToSource.SqlServer.Sync'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['ConnectToSourceSqlServerTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToSource.SqlServer.Sync')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToSource.SqlServer.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToSourceSqlServerTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToSourceSqlServerTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToSourceSqlServerTaskInputArgs:
    def __init__(__self__, *,
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 check_permissions_group: Optional[pulumi.Input[Union[str, 'ServerLevelPermissionsGroup']]] = None,
                 collect_agent_jobs: Optional[pulumi.Input[bool]] = None,
                 collect_databases: Optional[pulumi.Input[bool]] = None,
                 collect_logins: Optional[pulumi.Input[bool]] = None,
                 collect_tde_certificate_info: Optional[pulumi.Input[bool]] = None,
                 encrypted_key_for_secure_fields: Optional[pulumi.Input[str]] = None,
                 validate_ssis_catalog_only: Optional[pulumi.Input[bool]] = None):
        """
        Input for the task that validates connection to SQL Server and also validates source server requirements
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Connection information for Source SQL Server
        :param pulumi.Input[Union[str, 'ServerLevelPermissionsGroup']] check_permissions_group: Permission group for validations
        :param pulumi.Input[bool] collect_agent_jobs: Flag for whether to collect agent jobs from source server.
        :param pulumi.Input[bool] collect_databases: Flag for whether to collect databases from source server.
        :param pulumi.Input[bool] collect_logins: Flag for whether to collect logins from source server.
        :param pulumi.Input[bool] collect_tde_certificate_info: Flag for whether to collect TDE Certificate names from source server.
        :param pulumi.Input[str] encrypted_key_for_secure_fields: encrypted key for secure fields
        :param pulumi.Input[bool] validate_ssis_catalog_only: Flag for whether to validate SSIS catalog is reachable on the source server.
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        if check_permissions_group is not None:
            pulumi.set(__self__, "check_permissions_group", check_permissions_group)
        if collect_agent_jobs is None:
            collect_agent_jobs = False
        if collect_agent_jobs is not None:
            pulumi.set(__self__, "collect_agent_jobs", collect_agent_jobs)
        if collect_databases is None:
            collect_databases = True
        if collect_databases is not None:
            pulumi.set(__self__, "collect_databases", collect_databases)
        if collect_logins is None:
            collect_logins = False
        if collect_logins is not None:
            pulumi.set(__self__, "collect_logins", collect_logins)
        if collect_tde_certificate_info is None:
            collect_tde_certificate_info = False
        if collect_tde_certificate_info is not None:
            pulumi.set(__self__, "collect_tde_certificate_info", collect_tde_certificate_info)
        if encrypted_key_for_secure_fields is not None:
            pulumi.set(__self__, "encrypted_key_for_secure_fields", encrypted_key_for_secure_fields)
        if validate_ssis_catalog_only is None:
            validate_ssis_catalog_only = False
        if validate_ssis_catalog_only is not None:
            pulumi.set(__self__, "validate_ssis_catalog_only", validate_ssis_catalog_only)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for Source SQL Server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="checkPermissionsGroup")
    def check_permissions_group(self) -> Optional[pulumi.Input[Union[str, 'ServerLevelPermissionsGroup']]]:
        """
        Permission group for validations
        """
        return pulumi.get(self, "check_permissions_group")

    @check_permissions_group.setter
    def check_permissions_group(self, value: Optional[pulumi.Input[Union[str, 'ServerLevelPermissionsGroup']]]):
        pulumi.set(self, "check_permissions_group", value)

    @property
    @pulumi.getter(name="collectAgentJobs")
    def collect_agent_jobs(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag for whether to collect agent jobs from source server.
        """
        return pulumi.get(self, "collect_agent_jobs")

    @collect_agent_jobs.setter
    def collect_agent_jobs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "collect_agent_jobs", value)

    @property
    @pulumi.getter(name="collectDatabases")
    def collect_databases(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag for whether to collect databases from source server.
        """
        return pulumi.get(self, "collect_databases")

    @collect_databases.setter
    def collect_databases(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "collect_databases", value)

    @property
    @pulumi.getter(name="collectLogins")
    def collect_logins(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag for whether to collect logins from source server.
        """
        return pulumi.get(self, "collect_logins")

    @collect_logins.setter
    def collect_logins(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "collect_logins", value)

    @property
    @pulumi.getter(name="collectTdeCertificateInfo")
    def collect_tde_certificate_info(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag for whether to collect TDE Certificate names from source server.
        """
        return pulumi.get(self, "collect_tde_certificate_info")

    @collect_tde_certificate_info.setter
    def collect_tde_certificate_info(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "collect_tde_certificate_info", value)

    @property
    @pulumi.getter(name="encryptedKeyForSecureFields")
    def encrypted_key_for_secure_fields(self) -> Optional[pulumi.Input[str]]:
        """
        encrypted key for secure fields
        """
        return pulumi.get(self, "encrypted_key_for_secure_fields")

    @encrypted_key_for_secure_fields.setter
    def encrypted_key_for_secure_fields(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encrypted_key_for_secure_fields", value)

    @property
    @pulumi.getter(name="validateSsisCatalogOnly")
    def validate_ssis_catalog_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag for whether to validate SSIS catalog is reachable on the source server.
        """
        return pulumi.get(self, "validate_ssis_catalog_only")

    @validate_ssis_catalog_only.setter
    def validate_ssis_catalog_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate_ssis_catalog_only", value)


@pulumi.input_type
class ConnectToSourceSqlServerTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['ConnectToSourceSqlServerTaskInputArgs']] = None,
                 task_id: Optional[pulumi.Input[str]] = None):
        """
        Properties for the task that validates connection to SQL Server and also validates source server requirements
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToSource.SqlServer'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['ConnectToSourceSqlServerTaskInputArgs'] input: Task input
        :param pulumi.Input[str] task_id: Task id 
        """
        pulumi.set(__self__, "task_type", 'ConnectToSource.SqlServer')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if task_id is not None:
            pulumi.set(__self__, "task_id", task_id)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToSource.SqlServer'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToSourceSqlServerTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToSourceSqlServerTaskInputArgs']]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter(name="taskId")
    def task_id(self) -> Optional[pulumi.Input[str]]:
        """
        Task id 
        """
        return pulumi.get(self, "task_id")

    @task_id.setter
    def task_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_id", value)


@pulumi.input_type
class ConnectToTargetAzureDbForMySqlTaskInputArgs:
    def __init__(__self__, *,
                 source_connection_info: pulumi.Input['MySqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['MySqlConnectionInfoArgs'],
                 is_offline_migration: Optional[pulumi.Input[bool]] = None):
        """
        Input for the task that validates connection to Azure Database for MySQL and target server requirements
        :param pulumi.Input['MySqlConnectionInfoArgs'] source_connection_info: Connection information for source MySQL server
        :param pulumi.Input['MySqlConnectionInfoArgs'] target_connection_info: Connection information for target Azure Database for MySQL server
        :param pulumi.Input[bool] is_offline_migration: Flag for whether or not the migration is offline
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if is_offline_migration is None:
            is_offline_migration = False
        if is_offline_migration is not None:
            pulumi.set(__self__, "is_offline_migration", is_offline_migration)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['MySqlConnectionInfoArgs']:
        """
        Connection information for source MySQL server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['MySqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['MySqlConnectionInfoArgs']:
        """
        Connection information for target Azure Database for MySQL server
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['MySqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="isOfflineMigration")
    def is_offline_migration(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag for whether or not the migration is offline
        """
        return pulumi.get(self, "is_offline_migration")

    @is_offline_migration.setter
    def is_offline_migration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_offline_migration", value)


@pulumi.input_type
class ConnectToTargetAzureDbForMySqlTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['ConnectToTargetAzureDbForMySqlTaskInputArgs']] = None):
        """
        Properties for the task that validates connection to Azure Database for MySQL and target server requirements
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToTarget.AzureDbForMySql'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['ConnectToTargetAzureDbForMySqlTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToTarget.AzureDbForMySql')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToTarget.AzureDbForMySql'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToTargetAzureDbForMySqlTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToTargetAzureDbForMySqlTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs:
    def __init__(__self__, *,
                 source_connection_info: pulumi.Input['PostgreSqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        """
        Input for the task that validates connection to Azure Database for PostgreSQL and target server requirements
        :param pulumi.Input['PostgreSqlConnectionInfoArgs'] source_connection_info: Connection information for source PostgreSQL server
        :param pulumi.Input['PostgreSqlConnectionInfoArgs'] target_connection_info: Connection information for target Azure Database for PostgreSQL server
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['PostgreSqlConnectionInfoArgs']:
        """
        Connection information for source PostgreSQL server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['PostgreSqlConnectionInfoArgs']:
        """
        Connection information for target Azure Database for PostgreSQL server
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs']] = None):
        """
        Properties for the task that validates connection to Azure Database For PostgreSQL server and target server requirements for online migration
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToTarget.AzureDbForPostgreSql.Sync'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToTarget.AzureDbForPostgreSql.Sync')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToTarget.AzureDbForPostgreSql.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs:
    def __init__(__self__, *,
                 target_connection_info: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        """
        Input for the task that validates connection to Azure Database for PostgreSQL and target server requirements for Oracle source.
        :param pulumi.Input['PostgreSqlConnectionInfoArgs'] target_connection_info: Connection information for target Azure Database for PostgreSQL server
        """
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['PostgreSqlConnectionInfoArgs']:
        """
        Connection information for target Azure Database for PostgreSQL server
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs']] = None):
        """
        Properties for the task that validates connection to Azure Database For PostgreSQL server and target server requirements for online migration for Oracle source.
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToTargetSqlDbTaskInputArgs:
    def __init__(__self__, *,
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 query_object_counts: Optional[pulumi.Input[bool]] = None):
        """
        Input for the task that validates connection to SQL DB and target server requirements
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Connection information for target SQL DB
        :param pulumi.Input[bool] query_object_counts: Boolean flag indicating whether to query object counts for each database on the target server
        """
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if query_object_counts is not None:
            pulumi.set(__self__, "query_object_counts", query_object_counts)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for target SQL DB
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="queryObjectCounts")
    def query_object_counts(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean flag indicating whether to query object counts for each database on the target server
        """
        return pulumi.get(self, "query_object_counts")

    @query_object_counts.setter
    def query_object_counts(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "query_object_counts", value)


@pulumi.input_type
class ConnectToTargetSqlDbTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 created_on: Optional[pulumi.Input[str]] = None,
                 input: Optional[pulumi.Input['ConnectToTargetSqlDbTaskInputArgs']] = None):
        """
        Properties for the task that validates connection to SQL DB and target server requirements
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToTarget.SqlDb'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input[str] created_on: DateTime in UTC when the task was created
        :param pulumi.Input['ConnectToTargetSqlDbTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToTarget.SqlDb')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToTarget.SqlDb'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[str]]:
        """
        DateTime in UTC when the task was created
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToTargetSqlDbTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToTargetSqlDbTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToTargetSqlMISyncTaskInputArgs:
    def __init__(__self__, *,
                 azure_app: pulumi.Input['AzureActiveDirectoryAppArgs'],
                 target_connection_info: pulumi.Input['MiSqlConnectionInfoArgs']):
        """
        Input for the task that validates connection to Azure SQL Database Managed Instance online scenario.
        :param pulumi.Input['AzureActiveDirectoryAppArgs'] azure_app: Azure Active Directory Application the DMS (classic) instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        :param pulumi.Input['MiSqlConnectionInfoArgs'] target_connection_info: Connection information for Azure SQL Database Managed Instance
        """
        pulumi.set(__self__, "azure_app", azure_app)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="azureApp")
    def azure_app(self) -> pulumi.Input['AzureActiveDirectoryAppArgs']:
        """
        Azure Active Directory Application the DMS (classic) instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        """
        return pulumi.get(self, "azure_app")

    @azure_app.setter
    def azure_app(self, value: pulumi.Input['AzureActiveDirectoryAppArgs']):
        pulumi.set(self, "azure_app", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['MiSqlConnectionInfoArgs']:
        """
        Connection information for Azure SQL Database Managed Instance
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['MiSqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class ConnectToTargetSqlMISyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['ConnectToTargetSqlMISyncTaskInputArgs']] = None):
        """
        Properties for the task that validates connection to Azure SQL Database Managed Instance
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToTarget.AzureSqlDbMI.Sync.LRS'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['ConnectToTargetSqlMISyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToTarget.AzureSqlDbMI.Sync.LRS')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToTarget.AzureSqlDbMI.Sync.LRS'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToTargetSqlMISyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToTargetSqlMISyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToTargetSqlMITaskInputArgs:
    def __init__(__self__, *,
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 collect_agent_jobs: Optional[pulumi.Input[bool]] = None,
                 collect_logins: Optional[pulumi.Input[bool]] = None,
                 validate_ssis_catalog_only: Optional[pulumi.Input[bool]] = None):
        """
        Input for the task that validates connection to Azure SQL Database Managed Instance.
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Connection information for target SQL Server
        :param pulumi.Input[bool] collect_agent_jobs: Flag for whether to collect agent jobs from target SQL MI server.
        :param pulumi.Input[bool] collect_logins: Flag for whether to collect logins from target SQL MI server.
        :param pulumi.Input[bool] validate_ssis_catalog_only: Flag for whether to validate SSIS catalog is reachable on the target SQL MI server.
        """
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if collect_agent_jobs is None:
            collect_agent_jobs = True
        if collect_agent_jobs is not None:
            pulumi.set(__self__, "collect_agent_jobs", collect_agent_jobs)
        if collect_logins is None:
            collect_logins = True
        if collect_logins is not None:
            pulumi.set(__self__, "collect_logins", collect_logins)
        if validate_ssis_catalog_only is None:
            validate_ssis_catalog_only = False
        if validate_ssis_catalog_only is not None:
            pulumi.set(__self__, "validate_ssis_catalog_only", validate_ssis_catalog_only)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for target SQL Server
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="collectAgentJobs")
    def collect_agent_jobs(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag for whether to collect agent jobs from target SQL MI server.
        """
        return pulumi.get(self, "collect_agent_jobs")

    @collect_agent_jobs.setter
    def collect_agent_jobs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "collect_agent_jobs", value)

    @property
    @pulumi.getter(name="collectLogins")
    def collect_logins(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag for whether to collect logins from target SQL MI server.
        """
        return pulumi.get(self, "collect_logins")

    @collect_logins.setter
    def collect_logins(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "collect_logins", value)

    @property
    @pulumi.getter(name="validateSsisCatalogOnly")
    def validate_ssis_catalog_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag for whether to validate SSIS catalog is reachable on the target SQL MI server.
        """
        return pulumi.get(self, "validate_ssis_catalog_only")

    @validate_ssis_catalog_only.setter
    def validate_ssis_catalog_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate_ssis_catalog_only", value)


@pulumi.input_type
class ConnectToTargetSqlMITaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['ConnectToTargetSqlMITaskInputArgs']] = None):
        """
        Properties for the task that validates connection to Azure SQL Database Managed Instance
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToTarget.AzureSqlDbMI'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['ConnectToTargetSqlMITaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToTarget.AzureSqlDbMI')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToTarget.AzureSqlDbMI'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToTargetSqlMITaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToTargetSqlMITaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ConnectToTargetSqlSqlDbSyncTaskInputArgs:
    def __init__(__self__, *,
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs']):
        """
        Input for the task that validates connection to Azure SQL DB and target server requirements
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Connection information for source SQL Server
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Connection information for target SQL DB
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for source SQL Server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for target SQL DB
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class ConnectToTargetSqlSqlDbSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['ConnectToTargetSqlSqlDbSyncTaskInputArgs']] = None):
        """
        Properties for the task that validates connection to SQL DB and target server requirements for online migration
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ConnectToTarget.SqlDb.Sync'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['ConnectToTargetSqlSqlDbSyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ConnectToTarget.SqlDb.Sync')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ConnectToTarget.SqlDb.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ConnectToTargetSqlSqlDbSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ConnectToTargetSqlSqlDbSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class DatabaseInfoArgs:
    def __init__(__self__, *,
                 source_database_name: pulumi.Input[str]):
        """
        Project Database Details
        :param pulumi.Input[str] source_database_name: Name of the database
        """
        pulumi.set(__self__, "source_database_name", source_database_name)

    @property
    @pulumi.getter(name="sourceDatabaseName")
    def source_database_name(self) -> pulumi.Input[str]:
        """
        Name of the database
        """
        return pulumi.get(self, "source_database_name")

    @source_database_name.setter
    def source_database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_database_name", value)


@pulumi.input_type
class DatabaseMigrationPropertiesSqlDbArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 migration_operation_id: Optional[pulumi.Input[str]] = None,
                 migration_service: Optional[pulumi.Input[str]] = None,
                 provisioning_error: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 source_database_name: Optional[pulumi.Input[str]] = None,
                 source_sql_connection: Optional[pulumi.Input['SqlConnectionInformationArgs']] = None,
                 table_list: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_database_collation: Optional[pulumi.Input[str]] = None,
                 target_sql_connection: Optional[pulumi.Input['SqlConnectionInformationArgs']] = None):
        """
        Database Migration Resource properties for SQL database.
        :param pulumi.Input[str] kind: 
               Expected value is 'SqlDb'.
        :param pulumi.Input[str] migration_operation_id: ID tracking current migration operation.
        :param pulumi.Input[str] migration_service: Resource Id of the Migration Service.
        :param pulumi.Input[str] provisioning_error: Error message for migration provisioning failure, if any.
        :param pulumi.Input[str] scope: Resource Id of the target resource (SQL VM or SQL Managed Instance).
        :param pulumi.Input[str] source_database_name: Name of the source database.
        :param pulumi.Input['SqlConnectionInformationArgs'] source_sql_connection: Source SQL Server connection details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] table_list: List of tables to copy.
        :param pulumi.Input[str] target_database_collation: Database collation to be used for the target database.
        :param pulumi.Input['SqlConnectionInformationArgs'] target_sql_connection: Target SQL DB connection details.
        """
        pulumi.set(__self__, "kind", 'SqlDb')
        if migration_operation_id is not None:
            pulumi.set(__self__, "migration_operation_id", migration_operation_id)
        if migration_service is not None:
            pulumi.set(__self__, "migration_service", migration_service)
        if provisioning_error is not None:
            pulumi.set(__self__, "provisioning_error", provisioning_error)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if source_database_name is not None:
            pulumi.set(__self__, "source_database_name", source_database_name)
        if source_sql_connection is not None:
            pulumi.set(__self__, "source_sql_connection", source_sql_connection)
        if table_list is not None:
            pulumi.set(__self__, "table_list", table_list)
        if target_database_collation is not None:
            pulumi.set(__self__, "target_database_collation", target_database_collation)
        if target_sql_connection is not None:
            pulumi.set(__self__, "target_sql_connection", target_sql_connection)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """

        Expected value is 'SqlDb'.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="migrationOperationId")
    def migration_operation_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID tracking current migration operation.
        """
        return pulumi.get(self, "migration_operation_id")

    @migration_operation_id.setter
    def migration_operation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migration_operation_id", value)

    @property
    @pulumi.getter(name="migrationService")
    def migration_service(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id of the Migration Service.
        """
        return pulumi.get(self, "migration_service")

    @migration_service.setter
    def migration_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migration_service", value)

    @property
    @pulumi.getter(name="provisioningError")
    def provisioning_error(self) -> Optional[pulumi.Input[str]]:
        """
        Error message for migration provisioning failure, if any.
        """
        return pulumi.get(self, "provisioning_error")

    @provisioning_error.setter
    def provisioning_error(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_error", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id of the target resource (SQL VM or SQL Managed Instance).
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="sourceDatabaseName")
    def source_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the source database.
        """
        return pulumi.get(self, "source_database_name")

    @source_database_name.setter
    def source_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_database_name", value)

    @property
    @pulumi.getter(name="sourceSqlConnection")
    def source_sql_connection(self) -> Optional[pulumi.Input['SqlConnectionInformationArgs']]:
        """
        Source SQL Server connection details.
        """
        return pulumi.get(self, "source_sql_connection")

    @source_sql_connection.setter
    def source_sql_connection(self, value: Optional[pulumi.Input['SqlConnectionInformationArgs']]):
        pulumi.set(self, "source_sql_connection", value)

    @property
    @pulumi.getter(name="tableList")
    def table_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of tables to copy.
        """
        return pulumi.get(self, "table_list")

    @table_list.setter
    def table_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "table_list", value)

    @property
    @pulumi.getter(name="targetDatabaseCollation")
    def target_database_collation(self) -> Optional[pulumi.Input[str]]:
        """
        Database collation to be used for the target database.
        """
        return pulumi.get(self, "target_database_collation")

    @target_database_collation.setter
    def target_database_collation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_database_collation", value)

    @property
    @pulumi.getter(name="targetSqlConnection")
    def target_sql_connection(self) -> Optional[pulumi.Input['SqlConnectionInformationArgs']]:
        """
        Target SQL DB connection details.
        """
        return pulumi.get(self, "target_sql_connection")

    @target_sql_connection.setter
    def target_sql_connection(self, value: Optional[pulumi.Input['SqlConnectionInformationArgs']]):
        pulumi.set(self, "target_sql_connection", value)


@pulumi.input_type
class FileShareArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        File share information with Path, Username, and Password.
        :param pulumi.Input[str] path: The folder path for this share.
        :param pulumi.Input[str] password: Password credential used to connect to the share location.
        :param pulumi.Input[str] user_name: User name credential to connect to the share location
        """
        pulumi.set(__self__, "path", path)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The folder path for this share.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password credential used to connect to the share location.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        User name credential to connect to the share location
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class GetTdeCertificatesSqlTaskInputArgs:
    def __init__(__self__, *,
                 backup_file_share: pulumi.Input['FileShareArgs'],
                 connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 selected_certificates: pulumi.Input[Sequence[pulumi.Input['SelectedCertificateInputArgs']]]):
        """
        Input for the task that gets TDE certificates in Base64 encoded format.
        :param pulumi.Input['FileShareArgs'] backup_file_share: Backup file share information for file share to be used for temporarily storing files.
        :param pulumi.Input['SqlConnectionInfoArgs'] connection_info: Connection information for SQL Server
        :param pulumi.Input[Sequence[pulumi.Input['SelectedCertificateInputArgs']]] selected_certificates: List containing certificate names and corresponding password to use for encrypting the exported certificate.
        """
        pulumi.set(__self__, "backup_file_share", backup_file_share)
        pulumi.set(__self__, "connection_info", connection_info)
        pulumi.set(__self__, "selected_certificates", selected_certificates)

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> pulumi.Input['FileShareArgs']:
        """
        Backup file share information for file share to be used for temporarily storing files.
        """
        return pulumi.get(self, "backup_file_share")

    @backup_file_share.setter
    def backup_file_share(self, value: pulumi.Input['FileShareArgs']):
        pulumi.set(self, "backup_file_share", value)

    @property
    @pulumi.getter(name="connectionInfo")
    def connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for SQL Server
        """
        return pulumi.get(self, "connection_info")

    @connection_info.setter
    def connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "connection_info", value)

    @property
    @pulumi.getter(name="selectedCertificates")
    def selected_certificates(self) -> pulumi.Input[Sequence[pulumi.Input['SelectedCertificateInputArgs']]]:
        """
        List containing certificate names and corresponding password to use for encrypting the exported certificate.
        """
        return pulumi.get(self, "selected_certificates")

    @selected_certificates.setter
    def selected_certificates(self, value: pulumi.Input[Sequence[pulumi.Input['SelectedCertificateInputArgs']]]):
        pulumi.set(self, "selected_certificates", value)


@pulumi.input_type
class GetTdeCertificatesSqlTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['GetTdeCertificatesSqlTaskInputArgs']] = None):
        """
        Properties for the task that gets TDE certificates in Base64 encoded format.
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'GetTDECertificates.Sql'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['GetTdeCertificatesSqlTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'GetTDECertificates.Sql')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'GetTDECertificates.Sql'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['GetTdeCertificatesSqlTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['GetTdeCertificatesSqlTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class GetUserTablesMySqlTaskInputArgs:
    def __init__(__self__, *,
                 connection_info: pulumi.Input['MySqlConnectionInfoArgs'],
                 selected_databases: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Input for the task that collects user tables for the given list of databases
        :param pulumi.Input['MySqlConnectionInfoArgs'] connection_info: Connection information for SQL Server
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_databases: List of database names to collect tables for
        """
        pulumi.set(__self__, "connection_info", connection_info)
        pulumi.set(__self__, "selected_databases", selected_databases)

    @property
    @pulumi.getter(name="connectionInfo")
    def connection_info(self) -> pulumi.Input['MySqlConnectionInfoArgs']:
        """
        Connection information for SQL Server
        """
        return pulumi.get(self, "connection_info")

    @connection_info.setter
    def connection_info(self, value: pulumi.Input['MySqlConnectionInfoArgs']):
        pulumi.set(self, "connection_info", value)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of database names to collect tables for
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "selected_databases", value)


@pulumi.input_type
class GetUserTablesMySqlTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['GetUserTablesMySqlTaskInputArgs']] = None):
        """
        Properties for the task that collects user tables for the given list of databases
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'GetUserTablesMySql'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['GetUserTablesMySqlTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'GetUserTablesMySql')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'GetUserTablesMySql'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['GetUserTablesMySqlTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['GetUserTablesMySqlTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class GetUserTablesOracleTaskInputArgs:
    def __init__(__self__, *,
                 connection_info: pulumi.Input['OracleConnectionInfoArgs'],
                 selected_schemas: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Input for the task that gets the list of tables contained within a provided list of Oracle schemas.
        :param pulumi.Input['OracleConnectionInfoArgs'] connection_info: Information for connecting to Oracle source
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_schemas: List of Oracle schemas for which to collect tables
        """
        pulumi.set(__self__, "connection_info", connection_info)
        pulumi.set(__self__, "selected_schemas", selected_schemas)

    @property
    @pulumi.getter(name="connectionInfo")
    def connection_info(self) -> pulumi.Input['OracleConnectionInfoArgs']:
        """
        Information for connecting to Oracle source
        """
        return pulumi.get(self, "connection_info")

    @connection_info.setter
    def connection_info(self, value: pulumi.Input['OracleConnectionInfoArgs']):
        pulumi.set(self, "connection_info", value)

    @property
    @pulumi.getter(name="selectedSchemas")
    def selected_schemas(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of Oracle schemas for which to collect tables
        """
        return pulumi.get(self, "selected_schemas")

    @selected_schemas.setter
    def selected_schemas(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "selected_schemas", value)


@pulumi.input_type
class GetUserTablesOracleTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['GetUserTablesOracleTaskInputArgs']] = None):
        """
        Properties for the task that collects user tables for the given list of Oracle schemas
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'GetUserTablesOracle'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['GetUserTablesOracleTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'GetUserTablesOracle')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'GetUserTablesOracle'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['GetUserTablesOracleTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['GetUserTablesOracleTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class GetUserTablesPostgreSqlTaskInputArgs:
    def __init__(__self__, *,
                 connection_info: pulumi.Input['PostgreSqlConnectionInfoArgs'],
                 selected_databases: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Input for the task that gets the list of tables for a provided list of PostgreSQL databases.
        :param pulumi.Input['PostgreSqlConnectionInfoArgs'] connection_info: Information for connecting to PostgreSQL source
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_databases: List of PostgreSQL databases for which to collect tables
        """
        pulumi.set(__self__, "connection_info", connection_info)
        pulumi.set(__self__, "selected_databases", selected_databases)

    @property
    @pulumi.getter(name="connectionInfo")
    def connection_info(self) -> pulumi.Input['PostgreSqlConnectionInfoArgs']:
        """
        Information for connecting to PostgreSQL source
        """
        return pulumi.get(self, "connection_info")

    @connection_info.setter
    def connection_info(self, value: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        pulumi.set(self, "connection_info", value)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of PostgreSQL databases for which to collect tables
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "selected_databases", value)


@pulumi.input_type
class GetUserTablesPostgreSqlTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['GetUserTablesPostgreSqlTaskInputArgs']] = None):
        """
        Properties for the task that collects user tables for the given list of databases
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'GetUserTablesPostgreSql'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['GetUserTablesPostgreSqlTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'GetUserTablesPostgreSql')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'GetUserTablesPostgreSql'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['GetUserTablesPostgreSqlTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['GetUserTablesPostgreSqlTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class GetUserTablesSqlSyncTaskInputArgs:
    def __init__(__self__, *,
                 selected_source_databases: pulumi.Input[Sequence[pulumi.Input[str]]],
                 selected_target_databases: pulumi.Input[Sequence[pulumi.Input[str]]],
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs']):
        """
        Input for the task that collects user tables for the given list of databases
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_source_databases: List of source database names to collect tables for
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_target_databases: List of target database names to collect tables for
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Connection information for SQL Server
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Connection information for SQL DB
        """
        pulumi.set(__self__, "selected_source_databases", selected_source_databases)
        pulumi.set(__self__, "selected_target_databases", selected_target_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="selectedSourceDatabases")
    def selected_source_databases(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of source database names to collect tables for
        """
        return pulumi.get(self, "selected_source_databases")

    @selected_source_databases.setter
    def selected_source_databases(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "selected_source_databases", value)

    @property
    @pulumi.getter(name="selectedTargetDatabases")
    def selected_target_databases(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of target database names to collect tables for
        """
        return pulumi.get(self, "selected_target_databases")

    @selected_target_databases.setter
    def selected_target_databases(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "selected_target_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for SQL Server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for SQL DB
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class GetUserTablesSqlSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['GetUserTablesSqlSyncTaskInputArgs']] = None):
        """
        Properties for the task that collects user tables for the given list of databases
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'GetUserTables.AzureSqlDb.Sync'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['GetUserTablesSqlSyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'GetUserTables.AzureSqlDb.Sync')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'GetUserTables.AzureSqlDb.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['GetUserTablesSqlSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['GetUserTablesSqlSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class GetUserTablesSqlTaskInputArgs:
    def __init__(__self__, *,
                 connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 selected_databases: pulumi.Input[Sequence[pulumi.Input[str]]],
                 encrypted_key_for_secure_fields: Optional[pulumi.Input[str]] = None):
        """
        Input for the task that collects user tables for the given list of databases
        :param pulumi.Input['SqlConnectionInfoArgs'] connection_info: Connection information for SQL Server
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_databases: List of database names to collect tables for
        :param pulumi.Input[str] encrypted_key_for_secure_fields: encrypted key for secure fields
        """
        pulumi.set(__self__, "connection_info", connection_info)
        pulumi.set(__self__, "selected_databases", selected_databases)
        if encrypted_key_for_secure_fields is not None:
            pulumi.set(__self__, "encrypted_key_for_secure_fields", encrypted_key_for_secure_fields)

    @property
    @pulumi.getter(name="connectionInfo")
    def connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for SQL Server
        """
        return pulumi.get(self, "connection_info")

    @connection_info.setter
    def connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "connection_info", value)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of database names to collect tables for
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="encryptedKeyForSecureFields")
    def encrypted_key_for_secure_fields(self) -> Optional[pulumi.Input[str]]:
        """
        encrypted key for secure fields
        """
        return pulumi.get(self, "encrypted_key_for_secure_fields")

    @encrypted_key_for_secure_fields.setter
    def encrypted_key_for_secure_fields(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encrypted_key_for_secure_fields", value)


@pulumi.input_type
class GetUserTablesSqlTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['GetUserTablesSqlTaskInputArgs']] = None,
                 task_id: Optional[pulumi.Input[str]] = None):
        """
        Properties for the task that collects user tables for the given list of databases
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'GetUserTables.Sql'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['GetUserTablesSqlTaskInputArgs'] input: Task input
        :param pulumi.Input[str] task_id: Task id 
        """
        pulumi.set(__self__, "task_type", 'GetUserTables.Sql')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if task_id is not None:
            pulumi.set(__self__, "task_id", task_id)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'GetUserTables.Sql'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['GetUserTablesSqlTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['GetUserTablesSqlTaskInputArgs']]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter(name="taskId")
    def task_id(self) -> Optional[pulumi.Input[str]]:
        """
        Task id 
        """
        return pulumi.get(self, "task_id")

    @task_id.setter
    def task_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_id", value)


@pulumi.input_type
class MiSqlConnectionInfoArgs:
    def __init__(__self__, *,
                 managed_instance_resource_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Properties required to create a connection to Azure SQL database Managed instance
        :param pulumi.Input[str] managed_instance_resource_id: Resource id for Azure SQL database Managed instance
        :param pulumi.Input[str] type: Type of connection info
               Expected value is 'MiSqlConnectionInfo'.
        :param pulumi.Input[str] password: Password credential.
        :param pulumi.Input[str] user_name: User name
        """
        pulumi.set(__self__, "managed_instance_resource_id", managed_instance_resource_id)
        pulumi.set(__self__, "type", 'MiSqlConnectionInfo')
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="managedInstanceResourceId")
    def managed_instance_resource_id(self) -> pulumi.Input[str]:
        """
        Resource id for Azure SQL database Managed instance
        """
        return pulumi.get(self, "managed_instance_resource_id")

    @managed_instance_resource_id.setter
    def managed_instance_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "managed_instance_resource_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of connection info
        Expected value is 'MiSqlConnectionInfo'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password credential.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        User name
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class MigrateMongoDbTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['MongoDbMigrationSettingsArgs']] = None):
        """
        Properties for the task that migrates data between MongoDB data sources
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Migrate.MongoDb'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['MongoDbMigrationSettingsArgs'] input: Describes how a MongoDB data migration should be performed
        """
        pulumi.set(__self__, "task_type", 'Migrate.MongoDb')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Migrate.MongoDb'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MongoDbMigrationSettingsArgs']]:
        """
        Describes how a MongoDB data migration should be performed
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MongoDbMigrationSettingsArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 table_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_database_name: Optional[pulumi.Input[str]] = None):
        """
        Database specific information for offline MySQL to Azure Database for MySQL migration task inputs
        :param pulumi.Input[str] name: Name of the database
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] table_map: Mapping of source to target tables
        :param pulumi.Input[str] target_database_name: Name of target database. Note: Target database will be truncated before starting migration.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if table_map is not None:
            pulumi.set(__self__, "table_map", table_map)
        if target_database_name is not None:
            pulumi.set(__self__, "target_database_name", target_database_name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tableMap")
    def table_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of source to target tables
        """
        return pulumi.get(self, "table_map")

    @table_map.setter
    def table_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "table_map", value)

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of target database. Note: Target database will be truncated before starting migration.
        """
        return pulumi.get(self, "target_database_name")

    @target_database_name.setter
    def target_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_database_name", value)


@pulumi.input_type
class MigrateMySqlAzureDbForMySqlOfflineTaskInputArgs:
    def __init__(__self__, *,
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['MySqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['MySqlConnectionInfoArgs'],
                 encrypted_key_for_secure_fields: Optional[pulumi.Input[str]] = None,
                 make_source_server_read_only: Optional[pulumi.Input[bool]] = None,
                 optional_agent_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 started_on: Optional[pulumi.Input[str]] = None):
        """
        Input for the task that migrates MySQL databases to Azure Database for MySQL for offline migrations
        :param pulumi.Input[Sequence[pulumi.Input['MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['MySqlConnectionInfoArgs'] source_connection_info: Connection information for source MySQL
        :param pulumi.Input['MySqlConnectionInfoArgs'] target_connection_info: Connection information for target Azure Database for MySQL
        :param pulumi.Input[str] encrypted_key_for_secure_fields: encrypted key for secure fields
        :param pulumi.Input[bool] make_source_server_read_only: Setting to set the source server read only
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] optional_agent_settings: Optional parameters for fine tuning the data transfer rate during migration
        :param pulumi.Input[str] started_on: Parameter to specify when the migration started
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if encrypted_key_for_secure_fields is not None:
            pulumi.set(__self__, "encrypted_key_for_secure_fields", encrypted_key_for_secure_fields)
        if make_source_server_read_only is None:
            make_source_server_read_only = False
        if make_source_server_read_only is not None:
            pulumi.set(__self__, "make_source_server_read_only", make_source_server_read_only)
        if optional_agent_settings is not None:
            pulumi.set(__self__, "optional_agent_settings", optional_agent_settings)
        if started_on is not None:
            pulumi.set(__self__, "started_on", started_on)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['MySqlConnectionInfoArgs']:
        """
        Connection information for source MySQL
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['MySqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['MySqlConnectionInfoArgs']:
        """
        Connection information for target Azure Database for MySQL
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['MySqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="encryptedKeyForSecureFields")
    def encrypted_key_for_secure_fields(self) -> Optional[pulumi.Input[str]]:
        """
        encrypted key for secure fields
        """
        return pulumi.get(self, "encrypted_key_for_secure_fields")

    @encrypted_key_for_secure_fields.setter
    def encrypted_key_for_secure_fields(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encrypted_key_for_secure_fields", value)

    @property
    @pulumi.getter(name="makeSourceServerReadOnly")
    def make_source_server_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Setting to set the source server read only
        """
        return pulumi.get(self, "make_source_server_read_only")

    @make_source_server_read_only.setter
    def make_source_server_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "make_source_server_read_only", value)

    @property
    @pulumi.getter(name="optionalAgentSettings")
    def optional_agent_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional parameters for fine tuning the data transfer rate during migration
        """
        return pulumi.get(self, "optional_agent_settings")

    @optional_agent_settings.setter
    def optional_agent_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "optional_agent_settings", value)

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter to specify when the migration started
        """
        return pulumi.get(self, "started_on")

    @started_on.setter
    def started_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "started_on", value)


@pulumi.input_type
class MigrateMySqlAzureDbForMySqlOfflineTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['MigrateMySqlAzureDbForMySqlOfflineTaskInputArgs']] = None,
                 is_cloneable: Optional[pulumi.Input[bool]] = None,
                 task_id: Optional[pulumi.Input[str]] = None):
        """
        Properties for the task that migrates MySQL databases to Azure Database for MySQL for offline migrations
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Migrate.MySql.AzureDbForMySql'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['MigrateMySqlAzureDbForMySqlOfflineTaskInputArgs'] input: Task input
        :param pulumi.Input[bool] is_cloneable: whether the task can be cloned or not
        :param pulumi.Input[str] task_id: Task id 
        """
        pulumi.set(__self__, "task_type", 'Migrate.MySql.AzureDbForMySql')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if is_cloneable is not None:
            pulumi.set(__self__, "is_cloneable", is_cloneable)
        if task_id is not None:
            pulumi.set(__self__, "task_id", task_id)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Migrate.MySql.AzureDbForMySql'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MigrateMySqlAzureDbForMySqlOfflineTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MigrateMySqlAzureDbForMySqlOfflineTaskInputArgs']]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter(name="isCloneable")
    def is_cloneable(self) -> Optional[pulumi.Input[bool]]:
        """
        whether the task can be cloned or not
        """
        return pulumi.get(self, "is_cloneable")

    @is_cloneable.setter
    def is_cloneable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cloneable", value)

    @property
    @pulumi.getter(name="taskId")
    def task_id(self) -> Optional[pulumi.Input[str]]:
        """
        Task id 
        """
        return pulumi.get(self, "task_id")

    @task_id.setter
    def task_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_id", value)


@pulumi.input_type
class MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs:
    def __init__(__self__, *,
                 migration_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 table_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_database_name: Optional[pulumi.Input[str]] = None,
                 target_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Database specific information for MySQL to Azure Database for MySQL migration task inputs
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] migration_setting: Migration settings which tune the migration behavior
        :param pulumi.Input[str] name: Name of the database
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] source_setting: Source settings to tune source endpoint migration behavior
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] table_map: Mapping of source to target tables
        :param pulumi.Input[str] target_database_name: Name of target database. Note: Target database will be truncated before starting migration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] target_setting: Target settings to tune target endpoint migration behavior
        """
        if migration_setting is not None:
            pulumi.set(__self__, "migration_setting", migration_setting)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_setting is not None:
            pulumi.set(__self__, "source_setting", source_setting)
        if table_map is not None:
            pulumi.set(__self__, "table_map", table_map)
        if target_database_name is not None:
            pulumi.set(__self__, "target_database_name", target_database_name)
        if target_setting is not None:
            pulumi.set(__self__, "target_setting", target_setting)

    @property
    @pulumi.getter(name="migrationSetting")
    def migration_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Migration settings which tune the migration behavior
        """
        return pulumi.get(self, "migration_setting")

    @migration_setting.setter
    def migration_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "migration_setting", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceSetting")
    def source_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Source settings to tune source endpoint migration behavior
        """
        return pulumi.get(self, "source_setting")

    @source_setting.setter
    def source_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "source_setting", value)

    @property
    @pulumi.getter(name="tableMap")
    def table_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of source to target tables
        """
        return pulumi.get(self, "table_map")

    @table_map.setter
    def table_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "table_map", value)

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of target database. Note: Target database will be truncated before starting migration.
        """
        return pulumi.get(self, "target_database_name")

    @target_database_name.setter
    def target_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_database_name", value)

    @property
    @pulumi.getter(name="targetSetting")
    def target_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Target settings to tune target endpoint migration behavior
        """
        return pulumi.get(self, "target_setting")

    @target_setting.setter
    def target_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "target_setting", value)


@pulumi.input_type
class MigrateMySqlAzureDbForMySqlSyncTaskInputArgs:
    def __init__(__self__, *,
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['MySqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['MySqlConnectionInfoArgs']):
        """
        Input for the task that migrates MySQL databases to Azure Database for MySQL for online migrations
        :param pulumi.Input[Sequence[pulumi.Input['MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['MySqlConnectionInfoArgs'] source_connection_info: Connection information for source MySQL
        :param pulumi.Input['MySqlConnectionInfoArgs'] target_connection_info: Connection information for target Azure Database for MySQL
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['MySqlConnectionInfoArgs']:
        """
        Connection information for source MySQL
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['MySqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['MySqlConnectionInfoArgs']:
        """
        Connection information for target Azure Database for MySQL
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['MySqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class MigrateMySqlAzureDbForMySqlSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['MigrateMySqlAzureDbForMySqlSyncTaskInputArgs']] = None):
        """
        Properties for the task that migrates MySQL databases to Azure Database for MySQL for online migrations
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Migrate.MySql.AzureDbForMySql.Sync'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['MigrateMySqlAzureDbForMySqlSyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'Migrate.MySql.AzureDbForMySql.Sync')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Migrate.MySql.AzureDbForMySql.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MigrateMySqlAzureDbForMySqlSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MigrateMySqlAzureDbForMySqlSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class MigrateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs']] = None):
        """
        Properties for the task that migrates Oracle to Azure Database for PostgreSQL for online migrations
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Migrate.Oracle.AzureDbForPostgreSql.Sync'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'Migrate.Oracle.AzureDbForPostgreSql.Sync')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Migrate.Oracle.AzureDbForPostgreSql.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs:
    def __init__(__self__, *,
                 case_manipulation: Optional[pulumi.Input[str]] = None,
                 migration_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 source_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 table_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_database_name: Optional[pulumi.Input[str]] = None,
                 target_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Database specific information for Oracle to Azure Database for PostgreSQL migration task inputs
        :param pulumi.Input[str] case_manipulation: How to handle object name casing: either Preserve or ToLower
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] migration_setting: Migration settings which tune the migration behavior
        :param pulumi.Input[str] name: Name of the migration pipeline
        :param pulumi.Input[str] schema_name: Name of the source schema
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] source_setting: Source settings to tune source endpoint migration behavior
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] table_map: Mapping of source to target tables
        :param pulumi.Input[str] target_database_name: Name of target database. Note: Target database will be truncated before starting migration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] target_setting: Target settings to tune target endpoint migration behavior
        """
        if case_manipulation is not None:
            pulumi.set(__self__, "case_manipulation", case_manipulation)
        if migration_setting is not None:
            pulumi.set(__self__, "migration_setting", migration_setting)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if source_setting is not None:
            pulumi.set(__self__, "source_setting", source_setting)
        if table_map is not None:
            pulumi.set(__self__, "table_map", table_map)
        if target_database_name is not None:
            pulumi.set(__self__, "target_database_name", target_database_name)
        if target_setting is not None:
            pulumi.set(__self__, "target_setting", target_setting)

    @property
    @pulumi.getter(name="caseManipulation")
    def case_manipulation(self) -> Optional[pulumi.Input[str]]:
        """
        How to handle object name casing: either Preserve or ToLower
        """
        return pulumi.get(self, "case_manipulation")

    @case_manipulation.setter
    def case_manipulation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "case_manipulation", value)

    @property
    @pulumi.getter(name="migrationSetting")
    def migration_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Migration settings which tune the migration behavior
        """
        return pulumi.get(self, "migration_setting")

    @migration_setting.setter
    def migration_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "migration_setting", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the migration pipeline
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the source schema
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter(name="sourceSetting")
    def source_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Source settings to tune source endpoint migration behavior
        """
        return pulumi.get(self, "source_setting")

    @source_setting.setter
    def source_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "source_setting", value)

    @property
    @pulumi.getter(name="tableMap")
    def table_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of source to target tables
        """
        return pulumi.get(self, "table_map")

    @table_map.setter
    def table_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "table_map", value)

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of target database. Note: Target database will be truncated before starting migration.
        """
        return pulumi.get(self, "target_database_name")

    @target_database_name.setter
    def target_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_database_name", value)

    @property
    @pulumi.getter(name="targetSetting")
    def target_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Target settings to tune target endpoint migration behavior
        """
        return pulumi.get(self, "target_setting")

    @target_setting.setter
    def target_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "target_setting", value)


@pulumi.input_type
class MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs:
    def __init__(__self__, *,
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['OracleConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        """
        Input for the task that migrates Oracle databases to Azure Database for PostgreSQL for online migrations
        :param pulumi.Input[Sequence[pulumi.Input['MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['OracleConnectionInfoArgs'] source_connection_info: Connection information for source Oracle
        :param pulumi.Input['PostgreSqlConnectionInfoArgs'] target_connection_info: Connection information for target Azure Database for PostgreSQL
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['OracleConnectionInfoArgs']:
        """
        Connection information for source Oracle
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['OracleConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['PostgreSqlConnectionInfoArgs']:
        """
        Connection information for target Azure Database for PostgreSQL
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs:
    def __init__(__self__, *,
                 migration_setting: Optional[Any] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 selected_tables: Optional[pulumi.Input[Sequence[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs']]]] = None,
                 source_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_database_name: Optional[pulumi.Input[str]] = None,
                 target_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Database specific information for PostgreSQL to Azure Database for PostgreSQL migration task inputs
        :param Any migration_setting: Migration settings which tune the migration behavior
        :param pulumi.Input[str] name: Name of the database
        :param pulumi.Input[Sequence[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs']]] selected_tables: Tables selected for migration
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] source_setting: Source settings to tune source endpoint migration behavior
        :param pulumi.Input[str] target_database_name: Name of target database. Note: Target database will be truncated before starting migration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] target_setting: Target settings to tune target endpoint migration behavior
        """
        if migration_setting is not None:
            pulumi.set(__self__, "migration_setting", migration_setting)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if selected_tables is not None:
            pulumi.set(__self__, "selected_tables", selected_tables)
        if source_setting is not None:
            pulumi.set(__self__, "source_setting", source_setting)
        if target_database_name is not None:
            pulumi.set(__self__, "target_database_name", target_database_name)
        if target_setting is not None:
            pulumi.set(__self__, "target_setting", target_setting)

    @property
    @pulumi.getter(name="migrationSetting")
    def migration_setting(self) -> Optional[Any]:
        """
        Migration settings which tune the migration behavior
        """
        return pulumi.get(self, "migration_setting")

    @migration_setting.setter
    def migration_setting(self, value: Optional[Any]):
        pulumi.set(self, "migration_setting", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="selectedTables")
    def selected_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs']]]]:
        """
        Tables selected for migration
        """
        return pulumi.get(self, "selected_tables")

    @selected_tables.setter
    def selected_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs']]]]):
        pulumi.set(self, "selected_tables", value)

    @property
    @pulumi.getter(name="sourceSetting")
    def source_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Source settings to tune source endpoint migration behavior
        """
        return pulumi.get(self, "source_setting")

    @source_setting.setter
    def source_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "source_setting", value)

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of target database. Note: Target database will be truncated before starting migration.
        """
        return pulumi.get(self, "target_database_name")

    @target_database_name.setter
    def target_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_database_name", value)

    @property
    @pulumi.getter(name="targetSetting")
    def target_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Target settings to tune target endpoint migration behavior
        """
        return pulumi.get(self, "target_setting")

    @target_setting.setter
    def target_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "target_setting", value)


@pulumi.input_type
class MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Selected tables for the migration
        :param pulumi.Input[str] name: Name of the table to migrate
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the table to migrate
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs:
    def __init__(__self__, *,
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['PostgreSqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['PostgreSqlConnectionInfoArgs'],
                 encrypted_key_for_secure_fields: Optional[pulumi.Input[str]] = None):
        """
        Input for the task that migrates PostgreSQL databases to Azure Database for PostgreSQL for online migrations
        :param pulumi.Input[Sequence[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['PostgreSqlConnectionInfoArgs'] source_connection_info: Connection information for source PostgreSQL
        :param pulumi.Input['PostgreSqlConnectionInfoArgs'] target_connection_info: Connection information for target Azure Database for PostgreSQL
        :param pulumi.Input[str] encrypted_key_for_secure_fields: encrypted key for secure fields
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if encrypted_key_for_secure_fields is not None:
            pulumi.set(__self__, "encrypted_key_for_secure_fields", encrypted_key_for_secure_fields)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['PostgreSqlConnectionInfoArgs']:
        """
        Connection information for source PostgreSQL
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['PostgreSqlConnectionInfoArgs']:
        """
        Connection information for target Azure Database for PostgreSQL
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['PostgreSqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="encryptedKeyForSecureFields")
    def encrypted_key_for_secure_fields(self) -> Optional[pulumi.Input[str]]:
        """
        encrypted key for secure fields
        """
        return pulumi.get(self, "encrypted_key_for_secure_fields")

    @encrypted_key_for_secure_fields.setter
    def encrypted_key_for_secure_fields(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encrypted_key_for_secure_fields", value)


@pulumi.input_type
class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 created_on: Optional[pulumi.Input[str]] = None,
                 input: Optional[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs']] = None,
                 is_cloneable: Optional[pulumi.Input[bool]] = None,
                 task_id: Optional[pulumi.Input[str]] = None):
        """
        Properties for the task that migrates PostgreSQL databases to Azure Database for PostgreSQL for online migrations
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input[str] created_on: DateTime in UTC when the task was created
        :param pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs'] input: Task input
        :param pulumi.Input[bool] is_cloneable: whether the task can be cloned or not
        :param pulumi.Input[str] task_id: task id
        """
        pulumi.set(__self__, "task_type", 'Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if is_cloneable is not None:
            pulumi.set(__self__, "is_cloneable", is_cloneable)
        if task_id is not None:
            pulumi.set(__self__, "task_id", task_id)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[str]]:
        """
        DateTime in UTC when the task was created
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter(name="isCloneable")
    def is_cloneable(self) -> Optional[pulumi.Input[bool]]:
        """
        whether the task can be cloned or not
        """
        return pulumi.get(self, "is_cloneable")

    @is_cloneable.setter
    def is_cloneable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cloneable", value)

    @property
    @pulumi.getter(name="taskId")
    def task_id(self) -> Optional[pulumi.Input[str]]:
        """
        task id
        """
        return pulumi.get(self, "task_id")

    @task_id.setter
    def task_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_id", value)


@pulumi.input_type
class MigrateSqlServerSqlDbDatabaseInputArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 make_source_db_read_only: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schema_setting: Optional[Any] = None,
                 table_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_database_name: Optional[pulumi.Input[str]] = None):
        """
        Database specific information for SQL to Azure SQL DB migration task inputs
        :param pulumi.Input[str] id: id of the database
        :param pulumi.Input[bool] make_source_db_read_only: Whether to set database read only before migration
        :param pulumi.Input[str] name: Name of the database
        :param Any schema_setting: Settings selected for DB schema migration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] table_map: Mapping of source to target tables
        :param pulumi.Input[str] target_database_name: Name of target database. Note: Target database will be truncated before starting migration.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if make_source_db_read_only is not None:
            pulumi.set(__self__, "make_source_db_read_only", make_source_db_read_only)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schema_setting is not None:
            pulumi.set(__self__, "schema_setting", schema_setting)
        if table_map is not None:
            pulumi.set(__self__, "table_map", table_map)
        if target_database_name is not None:
            pulumi.set(__self__, "target_database_name", target_database_name)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        id of the database
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="makeSourceDbReadOnly")
    def make_source_db_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to set database read only before migration
        """
        return pulumi.get(self, "make_source_db_read_only")

    @make_source_db_read_only.setter
    def make_source_db_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "make_source_db_read_only", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="schemaSetting")
    def schema_setting(self) -> Optional[Any]:
        """
        Settings selected for DB schema migration.
        """
        return pulumi.get(self, "schema_setting")

    @schema_setting.setter
    def schema_setting(self, value: Optional[Any]):
        pulumi.set(self, "schema_setting", value)

    @property
    @pulumi.getter(name="tableMap")
    def table_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of source to target tables
        """
        return pulumi.get(self, "table_map")

    @table_map.setter
    def table_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "table_map", value)

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of target database. Note: Target database will be truncated before starting migration.
        """
        return pulumi.get(self, "target_database_name")

    @target_database_name.setter
    def target_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_database_name", value)


@pulumi.input_type
class MigrateSqlServerSqlDbSyncDatabaseInputArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 migration_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 source_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 table_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_database_name: Optional[pulumi.Input[str]] = None,
                 target_setting: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Database specific information for SQL to Azure SQL DB sync migration task inputs
        :param pulumi.Input[str] id: Unique identifier for database
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] migration_setting: Migration settings which tune the migration behavior
        :param pulumi.Input[str] name: Name of database
        :param pulumi.Input[str] schema_name: Schema name to be migrated
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] source_setting: Source settings to tune source endpoint migration behavior
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] table_map: Mapping of source to target tables
        :param pulumi.Input[str] target_database_name: Target database name
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] target_setting: Target settings to tune target endpoint migration behavior
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if migration_setting is not None:
            pulumi.set(__self__, "migration_setting", migration_setting)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if source_setting is not None:
            pulumi.set(__self__, "source_setting", source_setting)
        if table_map is not None:
            pulumi.set(__self__, "table_map", table_map)
        if target_database_name is not None:
            pulumi.set(__self__, "target_database_name", target_database_name)
        if target_setting is not None:
            pulumi.set(__self__, "target_setting", target_setting)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for database
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="migrationSetting")
    def migration_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Migration settings which tune the migration behavior
        """
        return pulumi.get(self, "migration_setting")

    @migration_setting.setter
    def migration_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "migration_setting", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        Schema name to be migrated
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter(name="sourceSetting")
    def source_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Source settings to tune source endpoint migration behavior
        """
        return pulumi.get(self, "source_setting")

    @source_setting.setter
    def source_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "source_setting", value)

    @property
    @pulumi.getter(name="tableMap")
    def table_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of source to target tables
        """
        return pulumi.get(self, "table_map")

    @table_map.setter
    def table_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "table_map", value)

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Target database name
        """
        return pulumi.get(self, "target_database_name")

    @target_database_name.setter
    def target_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_database_name", value)

    @property
    @pulumi.getter(name="targetSetting")
    def target_setting(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Target settings to tune target endpoint migration behavior
        """
        return pulumi.get(self, "target_setting")

    @target_setting.setter
    def target_setting(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "target_setting", value)


@pulumi.input_type
class MigrateSqlServerSqlDbSyncTaskInputArgs:
    def __init__(__self__, *,
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbSyncDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 validation_options: Optional[pulumi.Input['MigrationValidationOptionsArgs']] = None):
        """
        Input for the task that migrates on-prem SQL Server databases to Azure SQL Database for online migrations
        :param pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbSyncDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Information for connecting to source
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Information for connecting to target
        :param pulumi.Input['MigrationValidationOptionsArgs'] validation_options: Validation options
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if validation_options is not None:
            pulumi.set(__self__, "validation_options", validation_options)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbSyncDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbSyncDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to source
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="validationOptions")
    def validation_options(self) -> Optional[pulumi.Input['MigrationValidationOptionsArgs']]:
        """
        Validation options
        """
        return pulumi.get(self, "validation_options")

    @validation_options.setter
    def validation_options(self, value: Optional[pulumi.Input['MigrationValidationOptionsArgs']]):
        pulumi.set(self, "validation_options", value)


@pulumi.input_type
class MigrateSqlServerSqlDbSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['MigrateSqlServerSqlDbSyncTaskInputArgs']] = None):
        """
        Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database for online migrations
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Migrate.SqlServer.AzureSqlDb.Sync'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['MigrateSqlServerSqlDbSyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'Migrate.SqlServer.AzureSqlDb.Sync')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Migrate.SqlServer.AzureSqlDb.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MigrateSqlServerSqlDbSyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MigrateSqlServerSqlDbSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class MigrateSqlServerSqlDbTaskInputArgs:
    def __init__(__self__, *,
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 encrypted_key_for_secure_fields: Optional[pulumi.Input[str]] = None,
                 started_on: Optional[pulumi.Input[str]] = None,
                 validation_options: Optional[pulumi.Input['MigrationValidationOptionsArgs']] = None):
        """
        Input for the task that migrates on-prem SQL Server databases to Azure SQL Database
        :param pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Information for connecting to source
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Information for connecting to target
        :param pulumi.Input[str] encrypted_key_for_secure_fields: encrypted key for secure fields
        :param pulumi.Input[str] started_on: Date and time relative to UTC when the migration was started on
        :param pulumi.Input['MigrationValidationOptionsArgs'] validation_options: Options for enabling various post migration validations. Available options, 
                1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data. 
                2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if encrypted_key_for_secure_fields is not None:
            pulumi.set(__self__, "encrypted_key_for_secure_fields", encrypted_key_for_secure_fields)
        if started_on is not None:
            pulumi.set(__self__, "started_on", started_on)
        if validation_options is not None:
            pulumi.set(__self__, "validation_options", validation_options)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to source
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="encryptedKeyForSecureFields")
    def encrypted_key_for_secure_fields(self) -> Optional[pulumi.Input[str]]:
        """
        encrypted key for secure fields
        """
        return pulumi.get(self, "encrypted_key_for_secure_fields")

    @encrypted_key_for_secure_fields.setter
    def encrypted_key_for_secure_fields(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encrypted_key_for_secure_fields", value)

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time relative to UTC when the migration was started on
        """
        return pulumi.get(self, "started_on")

    @started_on.setter
    def started_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "started_on", value)

    @property
    @pulumi.getter(name="validationOptions")
    def validation_options(self) -> Optional[pulumi.Input['MigrationValidationOptionsArgs']]:
        """
        Options for enabling various post migration validations. Available options, 
         1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data. 
         2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
        """
        return pulumi.get(self, "validation_options")

    @validation_options.setter
    def validation_options(self, value: Optional[pulumi.Input['MigrationValidationOptionsArgs']]):
        pulumi.set(self, "validation_options", value)


@pulumi.input_type
class MigrateSqlServerSqlDbTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 created_on: Optional[pulumi.Input[str]] = None,
                 input: Optional[pulumi.Input['MigrateSqlServerSqlDbTaskInputArgs']] = None,
                 is_cloneable: Optional[pulumi.Input[bool]] = None,
                 task_id: Optional[pulumi.Input[str]] = None):
        """
        Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Migrate.SqlServer.SqlDb'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input[str] created_on: DateTime in UTC when the task was created
        :param pulumi.Input['MigrateSqlServerSqlDbTaskInputArgs'] input: Task input
        :param pulumi.Input[bool] is_cloneable: whether the task can be cloned or not
        :param pulumi.Input[str] task_id: task id
        """
        pulumi.set(__self__, "task_type", 'Migrate.SqlServer.SqlDb')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if is_cloneable is not None:
            pulumi.set(__self__, "is_cloneable", is_cloneable)
        if task_id is not None:
            pulumi.set(__self__, "task_id", task_id)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Migrate.SqlServer.SqlDb'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[str]]:
        """
        DateTime in UTC when the task was created
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MigrateSqlServerSqlDbTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MigrateSqlServerSqlDbTaskInputArgs']]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter(name="isCloneable")
    def is_cloneable(self) -> Optional[pulumi.Input[bool]]:
        """
        whether the task can be cloned or not
        """
        return pulumi.get(self, "is_cloneable")

    @is_cloneable.setter
    def is_cloneable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cloneable", value)

    @property
    @pulumi.getter(name="taskId")
    def task_id(self) -> Optional[pulumi.Input[str]]:
        """
        task id
        """
        return pulumi.get(self, "task_id")

    @task_id.setter
    def task_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_id", value)


@pulumi.input_type
class MigrateSqlServerSqlMIDatabaseInputArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 restore_database_name: pulumi.Input[str],
                 backup_file_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_file_share: Optional[pulumi.Input['FileShareArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Database specific information for SQL to Azure SQL DB Managed Instance migration task inputs
        :param pulumi.Input[str] name: Name of the database
        :param pulumi.Input[str] restore_database_name: Name of the database at destination
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_file_paths: The list of backup files to be used in case of existing backups.
        :param pulumi.Input['FileShareArgs'] backup_file_share: Backup file share information for backing up this database.
        :param pulumi.Input[str] id: id of the database
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "restore_database_name", restore_database_name)
        if backup_file_paths is not None:
            pulumi.set(__self__, "backup_file_paths", backup_file_paths)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="restoreDatabaseName")
    def restore_database_name(self) -> pulumi.Input[str]:
        """
        Name of the database at destination
        """
        return pulumi.get(self, "restore_database_name")

    @restore_database_name.setter
    def restore_database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "restore_database_name", value)

    @property
    @pulumi.getter(name="backupFilePaths")
    def backup_file_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of backup files to be used in case of existing backups.
        """
        return pulumi.get(self, "backup_file_paths")

    @backup_file_paths.setter
    def backup_file_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "backup_file_paths", value)

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional[pulumi.Input['FileShareArgs']]:
        """
        Backup file share information for backing up this database.
        """
        return pulumi.get(self, "backup_file_share")

    @backup_file_share.setter
    def backup_file_share(self, value: Optional[pulumi.Input['FileShareArgs']]):
        pulumi.set(self, "backup_file_share", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        id of the database
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class MigrateSqlServerSqlMISyncTaskInputArgs:
    def __init__(__self__, *,
                 azure_app: pulumi.Input['AzureActiveDirectoryAppArgs'],
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 storage_resource_id: pulumi.Input[str],
                 target_connection_info: pulumi.Input['MiSqlConnectionInfoArgs'],
                 backup_file_share: Optional[pulumi.Input['FileShareArgs']] = None,
                 number_of_parallel_database_migrations: Optional[pulumi.Input[float]] = None):
        """
        Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance online scenario.
        :param pulumi.Input['AzureActiveDirectoryAppArgs'] azure_app: Azure Active Directory Application the DMS (classic) instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        :param pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Connection information for source SQL Server
        :param pulumi.Input[str] storage_resource_id: Fully qualified resourceId of storage
        :param pulumi.Input['MiSqlConnectionInfoArgs'] target_connection_info: Connection information for Azure SQL Database Managed Instance
        :param pulumi.Input['FileShareArgs'] backup_file_share: Backup file share information for all selected databases.
        :param pulumi.Input[float] number_of_parallel_database_migrations: Number of database migrations to start in parallel
        """
        pulumi.set(__self__, "azure_app", azure_app)
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "storage_resource_id", storage_resource_id)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)
        if number_of_parallel_database_migrations is not None:
            pulumi.set(__self__, "number_of_parallel_database_migrations", number_of_parallel_database_migrations)

    @property
    @pulumi.getter(name="azureApp")
    def azure_app(self) -> pulumi.Input['AzureActiveDirectoryAppArgs']:
        """
        Azure Active Directory Application the DMS (classic) instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        """
        return pulumi.get(self, "azure_app")

    @azure_app.setter
    def azure_app(self, value: pulumi.Input['AzureActiveDirectoryAppArgs']):
        pulumi.set(self, "azure_app", value)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for source SQL Server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="storageResourceId")
    def storage_resource_id(self) -> pulumi.Input[str]:
        """
        Fully qualified resourceId of storage
        """
        return pulumi.get(self, "storage_resource_id")

    @storage_resource_id.setter
    def storage_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_resource_id", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['MiSqlConnectionInfoArgs']:
        """
        Connection information for Azure SQL Database Managed Instance
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['MiSqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional[pulumi.Input['FileShareArgs']]:
        """
        Backup file share information for all selected databases.
        """
        return pulumi.get(self, "backup_file_share")

    @backup_file_share.setter
    def backup_file_share(self, value: Optional[pulumi.Input['FileShareArgs']]):
        pulumi.set(self, "backup_file_share", value)

    @property
    @pulumi.getter(name="numberOfParallelDatabaseMigrations")
    def number_of_parallel_database_migrations(self) -> Optional[pulumi.Input[float]]:
        """
        Number of database migrations to start in parallel
        """
        return pulumi.get(self, "number_of_parallel_database_migrations")

    @number_of_parallel_database_migrations.setter
    def number_of_parallel_database_migrations(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "number_of_parallel_database_migrations", value)


@pulumi.input_type
class MigrateSqlServerSqlMISyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 created_on: Optional[pulumi.Input[str]] = None,
                 input: Optional[pulumi.Input['MigrateSqlServerSqlMISyncTaskInputArgs']] = None):
        """
        Properties for task that migrates SQL Server databases to Azure SQL Database Managed Instance sync scenario
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Migrate.SqlServer.AzureSqlDbMI.Sync.LRS'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input[str] created_on: DateTime in UTC when the task was created
        :param pulumi.Input['MigrateSqlServerSqlMISyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'Migrate.SqlServer.AzureSqlDbMI.Sync.LRS')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Migrate.SqlServer.AzureSqlDbMI.Sync.LRS'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[str]]:
        """
        DateTime in UTC when the task was created
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MigrateSqlServerSqlMISyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MigrateSqlServerSqlMISyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class MigrateSqlServerSqlMITaskInputArgs:
    def __init__(__self__, *,
                 backup_blob_share: pulumi.Input['BlobShareArgs'],
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 aad_domain_name: Optional[pulumi.Input[str]] = None,
                 backup_file_share: Optional[pulumi.Input['FileShareArgs']] = None,
                 backup_mode: Optional[pulumi.Input[Union[str, 'BackupMode']]] = None,
                 encrypted_key_for_secure_fields: Optional[pulumi.Input[str]] = None,
                 selected_agent_jobs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 selected_logins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 started_on: Optional[pulumi.Input[str]] = None):
        """
        Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance.
        :param pulumi.Input['BlobShareArgs'] backup_blob_share: SAS URI of Azure Storage Account Container to be used for storing backup files.
        :param pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Information for connecting to source
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Information for connecting to target
        :param pulumi.Input[str] aad_domain_name: Azure Active Directory domain name in the format of 'contoso.com' for federated Azure AD or 'contoso.onmicrosoft.com' for managed domain, required if and only if Windows logins are selected
        :param pulumi.Input['FileShareArgs'] backup_file_share: Backup file share information for all selected databases.
        :param pulumi.Input[Union[str, 'BackupMode']] backup_mode: Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths are required to be provided in selectedDatabases.
        :param pulumi.Input[str] encrypted_key_for_secure_fields: encrypted key for secure fields
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_agent_jobs: Agent Jobs to migrate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_logins: Logins to migrate.
        :param pulumi.Input[str] started_on: Date and time relative to UTC when the migration was started on
        """
        pulumi.set(__self__, "backup_blob_share", backup_blob_share)
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if aad_domain_name is not None:
            pulumi.set(__self__, "aad_domain_name", aad_domain_name)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)
        if backup_mode is not None:
            pulumi.set(__self__, "backup_mode", backup_mode)
        if encrypted_key_for_secure_fields is not None:
            pulumi.set(__self__, "encrypted_key_for_secure_fields", encrypted_key_for_secure_fields)
        if selected_agent_jobs is not None:
            pulumi.set(__self__, "selected_agent_jobs", selected_agent_jobs)
        if selected_logins is not None:
            pulumi.set(__self__, "selected_logins", selected_logins)
        if started_on is not None:
            pulumi.set(__self__, "started_on", started_on)

    @property
    @pulumi.getter(name="backupBlobShare")
    def backup_blob_share(self) -> pulumi.Input['BlobShareArgs']:
        """
        SAS URI of Azure Storage Account Container to be used for storing backup files.
        """
        return pulumi.get(self, "backup_blob_share")

    @backup_blob_share.setter
    def backup_blob_share(self, value: pulumi.Input['BlobShareArgs']):
        pulumi.set(self, "backup_blob_share", value)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to source
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="aadDomainName")
    def aad_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Active Directory domain name in the format of 'contoso.com' for federated Azure AD or 'contoso.onmicrosoft.com' for managed domain, required if and only if Windows logins are selected
        """
        return pulumi.get(self, "aad_domain_name")

    @aad_domain_name.setter
    def aad_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aad_domain_name", value)

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional[pulumi.Input['FileShareArgs']]:
        """
        Backup file share information for all selected databases.
        """
        return pulumi.get(self, "backup_file_share")

    @backup_file_share.setter
    def backup_file_share(self, value: Optional[pulumi.Input['FileShareArgs']]):
        pulumi.set(self, "backup_file_share", value)

    @property
    @pulumi.getter(name="backupMode")
    def backup_mode(self) -> Optional[pulumi.Input[Union[str, 'BackupMode']]]:
        """
        Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths are required to be provided in selectedDatabases.
        """
        return pulumi.get(self, "backup_mode")

    @backup_mode.setter
    def backup_mode(self, value: Optional[pulumi.Input[Union[str, 'BackupMode']]]):
        pulumi.set(self, "backup_mode", value)

    @property
    @pulumi.getter(name="encryptedKeyForSecureFields")
    def encrypted_key_for_secure_fields(self) -> Optional[pulumi.Input[str]]:
        """
        encrypted key for secure fields
        """
        return pulumi.get(self, "encrypted_key_for_secure_fields")

    @encrypted_key_for_secure_fields.setter
    def encrypted_key_for_secure_fields(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encrypted_key_for_secure_fields", value)

    @property
    @pulumi.getter(name="selectedAgentJobs")
    def selected_agent_jobs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Agent Jobs to migrate.
        """
        return pulumi.get(self, "selected_agent_jobs")

    @selected_agent_jobs.setter
    def selected_agent_jobs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "selected_agent_jobs", value)

    @property
    @pulumi.getter(name="selectedLogins")
    def selected_logins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Logins to migrate.
        """
        return pulumi.get(self, "selected_logins")

    @selected_logins.setter
    def selected_logins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "selected_logins", value)

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time relative to UTC when the migration was started on
        """
        return pulumi.get(self, "started_on")

    @started_on.setter
    def started_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "started_on", value)


@pulumi.input_type
class MigrateSqlServerSqlMITaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 created_on: Optional[pulumi.Input[str]] = None,
                 input: Optional[pulumi.Input['MigrateSqlServerSqlMITaskInputArgs']] = None,
                 is_cloneable: Optional[pulumi.Input[bool]] = None,
                 parent_task_id: Optional[pulumi.Input[str]] = None,
                 task_id: Optional[pulumi.Input[str]] = None):
        """
        Properties for task that migrates SQL Server databases to Azure SQL Database Managed Instance
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Migrate.SqlServer.AzureSqlDbMI'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input[str] created_on: DateTime in UTC when the task was created
        :param pulumi.Input['MigrateSqlServerSqlMITaskInputArgs'] input: Task input
        :param pulumi.Input[bool] is_cloneable: whether the task can be cloned or not
        :param pulumi.Input[str] parent_task_id: parent task id
        :param pulumi.Input[str] task_id: task id
        """
        pulumi.set(__self__, "task_type", 'Migrate.SqlServer.AzureSqlDbMI')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if is_cloneable is not None:
            pulumi.set(__self__, "is_cloneable", is_cloneable)
        if parent_task_id is not None:
            pulumi.set(__self__, "parent_task_id", parent_task_id)
        if task_id is not None:
            pulumi.set(__self__, "task_id", task_id)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Migrate.SqlServer.AzureSqlDbMI'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[str]]:
        """
        DateTime in UTC when the task was created
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MigrateSqlServerSqlMITaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MigrateSqlServerSqlMITaskInputArgs']]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter(name="isCloneable")
    def is_cloneable(self) -> Optional[pulumi.Input[bool]]:
        """
        whether the task can be cloned or not
        """
        return pulumi.get(self, "is_cloneable")

    @is_cloneable.setter
    def is_cloneable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cloneable", value)

    @property
    @pulumi.getter(name="parentTaskId")
    def parent_task_id(self) -> Optional[pulumi.Input[str]]:
        """
        parent task id
        """
        return pulumi.get(self, "parent_task_id")

    @parent_task_id.setter
    def parent_task_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_task_id", value)

    @property
    @pulumi.getter(name="taskId")
    def task_id(self) -> Optional[pulumi.Input[str]]:
        """
        task id
        """
        return pulumi.get(self, "task_id")

    @task_id.setter
    def task_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_id", value)


@pulumi.input_type
class MigrateSsisTaskInputArgs:
    def __init__(__self__, *,
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 ssis_migration_info: pulumi.Input['SsisMigrationInfoArgs'],
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs']):
        """
        Input for task that migrates SSIS packages from SQL Server to Azure SQL Database Managed Instance.
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Information for connecting to source
        :param pulumi.Input['SsisMigrationInfoArgs'] ssis_migration_info: SSIS package migration information.
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Information for connecting to target
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "ssis_migration_info", ssis_migration_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to source
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="ssisMigrationInfo")
    def ssis_migration_info(self) -> pulumi.Input['SsisMigrationInfoArgs']:
        """
        SSIS package migration information.
        """
        return pulumi.get(self, "ssis_migration_info")

    @ssis_migration_info.setter
    def ssis_migration_info(self, value: pulumi.Input['SsisMigrationInfoArgs']):
        pulumi.set(self, "ssis_migration_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


@pulumi.input_type
class MigrateSsisTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['MigrateSsisTaskInputArgs']] = None):
        """
        Properties for task that migrates SSIS packages from SQL Server databases to Azure SQL Database Managed Instance.
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Migrate.Ssis'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['MigrateSsisTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'Migrate.Ssis')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Migrate.Ssis'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MigrateSsisTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MigrateSsisTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class MigrationValidationOptionsArgs:
    def __init__(__self__, *,
                 enable_data_integrity_validation: Optional[pulumi.Input[bool]] = None,
                 enable_query_analysis_validation: Optional[pulumi.Input[bool]] = None,
                 enable_schema_validation: Optional[pulumi.Input[bool]] = None):
        """
        Types of validations to run after the migration
        :param pulumi.Input[bool] enable_data_integrity_validation: Allows to perform a checksum based data integrity validation between source and target for the selected database / tables .
        :param pulumi.Input[bool] enable_query_analysis_validation: Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries.
        :param pulumi.Input[bool] enable_schema_validation: Allows to compare the schema information between source and target.
        """
        if enable_data_integrity_validation is not None:
            pulumi.set(__self__, "enable_data_integrity_validation", enable_data_integrity_validation)
        if enable_query_analysis_validation is not None:
            pulumi.set(__self__, "enable_query_analysis_validation", enable_query_analysis_validation)
        if enable_schema_validation is not None:
            pulumi.set(__self__, "enable_schema_validation", enable_schema_validation)

    @property
    @pulumi.getter(name="enableDataIntegrityValidation")
    def enable_data_integrity_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows to perform a checksum based data integrity validation between source and target for the selected database / tables .
        """
        return pulumi.get(self, "enable_data_integrity_validation")

    @enable_data_integrity_validation.setter
    def enable_data_integrity_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_data_integrity_validation", value)

    @property
    @pulumi.getter(name="enableQueryAnalysisValidation")
    def enable_query_analysis_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries.
        """
        return pulumi.get(self, "enable_query_analysis_validation")

    @enable_query_analysis_validation.setter
    def enable_query_analysis_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_query_analysis_validation", value)

    @property
    @pulumi.getter(name="enableSchemaValidation")
    def enable_schema_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows to compare the schema information between source and target.
        """
        return pulumi.get(self, "enable_schema_validation")

    @enable_schema_validation.setter
    def enable_schema_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_schema_validation", value)


@pulumi.input_type
class MongoDbCollectionSettingsArgs:
    def __init__(__self__, *,
                 can_delete: Optional[pulumi.Input[bool]] = None,
                 shard_key: Optional[pulumi.Input['MongoDbShardKeySettingArgs']] = None,
                 target_rus: Optional[pulumi.Input[int]] = None):
        """
        Describes how an individual MongoDB collection should be migrated
        :param pulumi.Input[bool] can_delete: Whether the migrator is allowed to drop the target collection in the course of performing a migration. The default is true.
        :param pulumi.Input['MongoDbShardKeySettingArgs'] shard_key: Describes a MongoDB shard key
        :param pulumi.Input[int] target_rus: The RUs that should be configured on a CosmosDB target, or null to use the default. This has no effect on non-CosmosDB targets.
        """
        if can_delete is not None:
            pulumi.set(__self__, "can_delete", can_delete)
        if shard_key is not None:
            pulumi.set(__self__, "shard_key", shard_key)
        if target_rus is not None:
            pulumi.set(__self__, "target_rus", target_rus)

    @property
    @pulumi.getter(name="canDelete")
    def can_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the migrator is allowed to drop the target collection in the course of performing a migration. The default is true.
        """
        return pulumi.get(self, "can_delete")

    @can_delete.setter
    def can_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_delete", value)

    @property
    @pulumi.getter(name="shardKey")
    def shard_key(self) -> Optional[pulumi.Input['MongoDbShardKeySettingArgs']]:
        """
        Describes a MongoDB shard key
        """
        return pulumi.get(self, "shard_key")

    @shard_key.setter
    def shard_key(self, value: Optional[pulumi.Input['MongoDbShardKeySettingArgs']]):
        pulumi.set(self, "shard_key", value)

    @property
    @pulumi.getter(name="targetRUs")
    def target_rus(self) -> Optional[pulumi.Input[int]]:
        """
        The RUs that should be configured on a CosmosDB target, or null to use the default. This has no effect on non-CosmosDB targets.
        """
        return pulumi.get(self, "target_rus")

    @target_rus.setter
    def target_rus(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_rus", value)


@pulumi.input_type
class MongoDbConnectionInfoArgs:
    def __init__(__self__, *,
                 connection_string: pulumi.Input[str],
                 type: pulumi.Input[str],
                 additional_settings: Optional[pulumi.Input[str]] = None,
                 authentication: Optional[pulumi.Input[Union[str, 'AuthenticationType']]] = None,
                 data_source: Optional[pulumi.Input[str]] = None,
                 encrypt_connection: Optional[pulumi.Input[bool]] = None,
                 enforce_ssl: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 server_brand_version: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 server_version: Optional[pulumi.Input[str]] = None,
                 trust_server_certificate: Optional[pulumi.Input[bool]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Describes a connection to a MongoDB data source
        :param pulumi.Input[str] connection_string: A MongoDB connection string or blob container URL. The user name and password can be specified here or in the userName and password properties
        :param pulumi.Input[str] type: Type of connection info
               Expected value is 'MongoDbConnectionInfo'.
        :param pulumi.Input[str] additional_settings: Additional connection settings
        :param pulumi.Input[Union[str, 'AuthenticationType']] authentication: Authentication type to use for connection
        :param pulumi.Input[str] data_source: Data source 
        :param pulumi.Input[bool] encrypt_connection: Whether to encrypt the connection
        :param pulumi.Input[str] password: Password credential.
        :param pulumi.Input[int] port: port for server
        :param pulumi.Input[str] server_brand_version: server brand version
        :param pulumi.Input[str] server_name: name of the server
        :param pulumi.Input[str] server_version: server version
        :param pulumi.Input[bool] trust_server_certificate: Whether to trust the server certificate
        :param pulumi.Input[str] user_name: User name
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'MongoDbConnectionInfo')
        if additional_settings is not None:
            pulumi.set(__self__, "additional_settings", additional_settings)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if encrypt_connection is not None:
            pulumi.set(__self__, "encrypt_connection", encrypt_connection)
        if enforce_ssl is not None:
            pulumi.set(__self__, "enforce_ssl", enforce_ssl)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if server_brand_version is not None:
            pulumi.set(__self__, "server_brand_version", server_brand_version)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if server_version is not None:
            pulumi.set(__self__, "server_version", server_version)
        if trust_server_certificate is None:
            trust_server_certificate = False
        if trust_server_certificate is not None:
            pulumi.set(__self__, "trust_server_certificate", trust_server_certificate)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Input[str]:
        """
        A MongoDB connection string or blob container URL. The user name and password can be specified here or in the userName and password properties
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of connection info
        Expected value is 'MongoDbConnectionInfo'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="additionalSettings")
    def additional_settings(self) -> Optional[pulumi.Input[str]]:
        """
        Additional connection settings
        """
        return pulumi.get(self, "additional_settings")

    @additional_settings.setter
    def additional_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_settings", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationType']]]:
        """
        Authentication type to use for connection
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationType']]]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input[str]]:
        """
        Data source 
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter(name="encryptConnection")
    def encrypt_connection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to encrypt the connection
        """
        return pulumi.get(self, "encrypt_connection")

    @encrypt_connection.setter
    def encrypt_connection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_connection", value)

    @property
    @pulumi.getter(name="enforceSSL")
    def enforce_ssl(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enforce_ssl")

    @enforce_ssl.setter
    def enforce_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce_ssl", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password credential.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        port for server
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serverBrandVersion")
    def server_brand_version(self) -> Optional[pulumi.Input[str]]:
        """
        server brand version
        """
        return pulumi.get(self, "server_brand_version")

    @server_brand_version.setter
    def server_brand_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_brand_version", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the server
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Optional[pulumi.Input[str]]:
        """
        server version
        """
        return pulumi.get(self, "server_version")

    @server_version.setter
    def server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_version", value)

    @property
    @pulumi.getter(name="trustServerCertificate")
    def trust_server_certificate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to trust the server certificate
        """
        return pulumi.get(self, "trust_server_certificate")

    @trust_server_certificate.setter
    def trust_server_certificate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "trust_server_certificate", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        User name
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class MongoDbDatabaseSettingsArgs:
    def __init__(__self__, *,
                 collections: pulumi.Input[Mapping[str, pulumi.Input['MongoDbCollectionSettingsArgs']]],
                 target_rus: Optional[pulumi.Input[int]] = None):
        """
        Describes how an individual MongoDB database should be migrated
        :param pulumi.Input[Mapping[str, pulumi.Input['MongoDbCollectionSettingsArgs']]] collections: The collections on the source database to migrate to the target. The keys are the unqualified names of the collections.
        :param pulumi.Input[int] target_rus: The RUs that should be configured on a CosmosDB target, or null to use the default, or 0 if throughput should not be provisioned for the database. This has no effect on non-CosmosDB targets.
        """
        pulumi.set(__self__, "collections", collections)
        if target_rus is not None:
            pulumi.set(__self__, "target_rus", target_rus)

    @property
    @pulumi.getter
    def collections(self) -> pulumi.Input[Mapping[str, pulumi.Input['MongoDbCollectionSettingsArgs']]]:
        """
        The collections on the source database to migrate to the target. The keys are the unqualified names of the collections.
        """
        return pulumi.get(self, "collections")

    @collections.setter
    def collections(self, value: pulumi.Input[Mapping[str, pulumi.Input['MongoDbCollectionSettingsArgs']]]):
        pulumi.set(self, "collections", value)

    @property
    @pulumi.getter(name="targetRUs")
    def target_rus(self) -> Optional[pulumi.Input[int]]:
        """
        The RUs that should be configured on a CosmosDB target, or null to use the default, or 0 if throughput should not be provisioned for the database. This has no effect on non-CosmosDB targets.
        """
        return pulumi.get(self, "target_rus")

    @target_rus.setter
    def target_rus(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_rus", value)


@pulumi.input_type
class MongoDbMigrationSettingsArgs:
    def __init__(__self__, *,
                 databases: pulumi.Input[Mapping[str, pulumi.Input['MongoDbDatabaseSettingsArgs']]],
                 source: pulumi.Input['MongoDbConnectionInfoArgs'],
                 target: pulumi.Input['MongoDbConnectionInfoArgs'],
                 boost_rus: Optional[pulumi.Input[int]] = None,
                 replication: Optional[pulumi.Input[Union[str, 'MongoDbReplication']]] = None,
                 throttling: Optional[pulumi.Input['MongoDbThrottlingSettingsArgs']] = None):
        """
        Describes how a MongoDB data migration should be performed
        :param pulumi.Input[Mapping[str, pulumi.Input['MongoDbDatabaseSettingsArgs']]] databases: The databases on the source cluster to migrate to the target. The keys are the names of the databases.
        :param pulumi.Input['MongoDbConnectionInfoArgs'] source: Settings used to connect to the source cluster
        :param pulumi.Input['MongoDbConnectionInfoArgs'] target: Settings used to connect to the target cluster
        :param pulumi.Input[int] boost_rus: The RU limit on a CosmosDB target that collections will be temporarily increased to (if lower) during the initial copy of a migration, from 10,000 to 1,000,000, or 0 to use the default boost (which is generally the maximum), or null to not boost the RUs. This setting has no effect on non-CosmosDB targets.
        :param pulumi.Input[Union[str, 'MongoDbReplication']] replication: Describes how changes will be replicated from the source to the target. The default is OneTime.
        :param pulumi.Input['MongoDbThrottlingSettingsArgs'] throttling: Settings used to limit the resource usage of the migration
        """
        pulumi.set(__self__, "databases", databases)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "target", target)
        if boost_rus is not None:
            pulumi.set(__self__, "boost_rus", boost_rus)
        if replication is not None:
            pulumi.set(__self__, "replication", replication)
        if throttling is not None:
            pulumi.set(__self__, "throttling", throttling)

    @property
    @pulumi.getter
    def databases(self) -> pulumi.Input[Mapping[str, pulumi.Input['MongoDbDatabaseSettingsArgs']]]:
        """
        The databases on the source cluster to migrate to the target. The keys are the names of the databases.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: pulumi.Input[Mapping[str, pulumi.Input['MongoDbDatabaseSettingsArgs']]]):
        pulumi.set(self, "databases", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['MongoDbConnectionInfoArgs']:
        """
        Settings used to connect to the source cluster
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['MongoDbConnectionInfoArgs']):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input['MongoDbConnectionInfoArgs']:
        """
        Settings used to connect to the target cluster
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input['MongoDbConnectionInfoArgs']):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="boostRUs")
    def boost_rus(self) -> Optional[pulumi.Input[int]]:
        """
        The RU limit on a CosmosDB target that collections will be temporarily increased to (if lower) during the initial copy of a migration, from 10,000 to 1,000,000, or 0 to use the default boost (which is generally the maximum), or null to not boost the RUs. This setting has no effect on non-CosmosDB targets.
        """
        return pulumi.get(self, "boost_rus")

    @boost_rus.setter
    def boost_rus(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "boost_rus", value)

    @property
    @pulumi.getter
    def replication(self) -> Optional[pulumi.Input[Union[str, 'MongoDbReplication']]]:
        """
        Describes how changes will be replicated from the source to the target. The default is OneTime.
        """
        return pulumi.get(self, "replication")

    @replication.setter
    def replication(self, value: Optional[pulumi.Input[Union[str, 'MongoDbReplication']]]):
        pulumi.set(self, "replication", value)

    @property
    @pulumi.getter
    def throttling(self) -> Optional[pulumi.Input['MongoDbThrottlingSettingsArgs']]:
        """
        Settings used to limit the resource usage of the migration
        """
        return pulumi.get(self, "throttling")

    @throttling.setter
    def throttling(self, value: Optional[pulumi.Input['MongoDbThrottlingSettingsArgs']]):
        pulumi.set(self, "throttling", value)


@pulumi.input_type
class MongoDbShardKeyFieldArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 order: pulumi.Input[Union[str, 'MongoDbShardKeyOrder']]):
        """
        Describes a field reference within a MongoDB shard key
        :param pulumi.Input[str] name: The name of the field
        :param pulumi.Input[Union[str, 'MongoDbShardKeyOrder']] order: The field ordering
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the field
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def order(self) -> pulumi.Input[Union[str, 'MongoDbShardKeyOrder']]:
        """
        The field ordering
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[Union[str, 'MongoDbShardKeyOrder']]):
        pulumi.set(self, "order", value)


@pulumi.input_type
class MongoDbShardKeySettingArgs:
    def __init__(__self__, *,
                 fields: pulumi.Input[Sequence[pulumi.Input['MongoDbShardKeyFieldArgs']]],
                 is_unique: Optional[pulumi.Input[bool]] = None):
        """
        Describes a MongoDB shard key
        :param pulumi.Input[Sequence[pulumi.Input['MongoDbShardKeyFieldArgs']]] fields: The fields within the shard key
        :param pulumi.Input[bool] is_unique: Whether the shard key is unique
        """
        pulumi.set(__self__, "fields", fields)
        if is_unique is not None:
            pulumi.set(__self__, "is_unique", is_unique)

    @property
    @pulumi.getter
    def fields(self) -> pulumi.Input[Sequence[pulumi.Input['MongoDbShardKeyFieldArgs']]]:
        """
        The fields within the shard key
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: pulumi.Input[Sequence[pulumi.Input['MongoDbShardKeyFieldArgs']]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter(name="isUnique")
    def is_unique(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the shard key is unique
        """
        return pulumi.get(self, "is_unique")

    @is_unique.setter
    def is_unique(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_unique", value)


@pulumi.input_type
class MongoDbThrottlingSettingsArgs:
    def __init__(__self__, *,
                 max_parallelism: Optional[pulumi.Input[int]] = None,
                 min_free_cpu: Optional[pulumi.Input[int]] = None,
                 min_free_memory_mb: Optional[pulumi.Input[int]] = None):
        """
        Specifies resource limits for the migration
        :param pulumi.Input[int] max_parallelism: The maximum number of work items (e.g. collection copies) that will be processed in parallel
        :param pulumi.Input[int] min_free_cpu: The percentage of CPU time that the migrator will try to avoid using, from 0 to 100
        :param pulumi.Input[int] min_free_memory_mb: The number of megabytes of RAM that the migrator will try to avoid using
        """
        if max_parallelism is not None:
            pulumi.set(__self__, "max_parallelism", max_parallelism)
        if min_free_cpu is not None:
            pulumi.set(__self__, "min_free_cpu", min_free_cpu)
        if min_free_memory_mb is not None:
            pulumi.set(__self__, "min_free_memory_mb", min_free_memory_mb)

    @property
    @pulumi.getter(name="maxParallelism")
    def max_parallelism(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of work items (e.g. collection copies) that will be processed in parallel
        """
        return pulumi.get(self, "max_parallelism")

    @max_parallelism.setter
    def max_parallelism(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_parallelism", value)

    @property
    @pulumi.getter(name="minFreeCpu")
    def min_free_cpu(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage of CPU time that the migrator will try to avoid using, from 0 to 100
        """
        return pulumi.get(self, "min_free_cpu")

    @min_free_cpu.setter
    def min_free_cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_free_cpu", value)

    @property
    @pulumi.getter(name="minFreeMemoryMb")
    def min_free_memory_mb(self) -> Optional[pulumi.Input[int]]:
        """
        The number of megabytes of RAM that the migrator will try to avoid using
        """
        return pulumi.get(self, "min_free_memory_mb")

    @min_free_memory_mb.setter
    def min_free_memory_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_free_memory_mb", value)


@pulumi.input_type
class MySqlConnectionInfoArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 server_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 additional_settings: Optional[pulumi.Input[str]] = None,
                 authentication: Optional[pulumi.Input[Union[str, 'AuthenticationType']]] = None,
                 data_source: Optional[pulumi.Input[str]] = None,
                 encrypt_connection: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Information for connecting to MySQL server
        :param pulumi.Input[int] port: Port for Server
        :param pulumi.Input[str] server_name: Name of the server
        :param pulumi.Input[str] type: Type of connection info
               Expected value is 'MySqlConnectionInfo'.
        :param pulumi.Input[str] additional_settings: Additional connection settings
        :param pulumi.Input[Union[str, 'AuthenticationType']] authentication: Authentication type to use for connection
        :param pulumi.Input[str] data_source: Data source 
        :param pulumi.Input[bool] encrypt_connection: Whether to encrypt the connection
        :param pulumi.Input[str] password: Password credential.
        :param pulumi.Input[str] user_name: User name
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "type", 'MySqlConnectionInfo')
        if additional_settings is not None:
            pulumi.set(__self__, "additional_settings", additional_settings)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if encrypt_connection is None:
            encrypt_connection = True
        if encrypt_connection is not None:
            pulumi.set(__self__, "encrypt_connection", encrypt_connection)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Port for Server
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        Name of the server
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of connection info
        Expected value is 'MySqlConnectionInfo'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="additionalSettings")
    def additional_settings(self) -> Optional[pulumi.Input[str]]:
        """
        Additional connection settings
        """
        return pulumi.get(self, "additional_settings")

    @additional_settings.setter
    def additional_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_settings", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationType']]]:
        """
        Authentication type to use for connection
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationType']]]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input[str]]:
        """
        Data source 
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter(name="encryptConnection")
    def encrypt_connection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to encrypt the connection
        """
        return pulumi.get(self, "encrypt_connection")

    @encrypt_connection.setter
    def encrypt_connection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_connection", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password credential.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        User name
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class OracleConnectionInfoArgs:
    def __init__(__self__, *,
                 data_source: pulumi.Input[str],
                 type: pulumi.Input[str],
                 authentication: Optional[pulumi.Input[Union[str, 'AuthenticationType']]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 server_version: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Information for connecting to Oracle server
        :param pulumi.Input[str] data_source: EZConnect or TNSName connection string.
        :param pulumi.Input[str] type: Type of connection info
               Expected value is 'OracleConnectionInfo'.
        :param pulumi.Input[Union[str, 'AuthenticationType']] authentication: Authentication type to use for connection
        :param pulumi.Input[str] password: Password credential.
        :param pulumi.Input[int] port: port for server
        :param pulumi.Input[str] server_name: name of the server
        :param pulumi.Input[str] server_version: server version
        :param pulumi.Input[str] user_name: User name
        """
        pulumi.set(__self__, "data_source", data_source)
        pulumi.set(__self__, "type", 'OracleConnectionInfo')
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if server_version is not None:
            pulumi.set(__self__, "server_version", server_version)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Input[str]:
        """
        EZConnect or TNSName connection string.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of connection info
        Expected value is 'OracleConnectionInfo'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationType']]]:
        """
        Authentication type to use for connection
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationType']]]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password credential.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        port for server
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the server
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Optional[pulumi.Input[str]]:
        """
        server version
        """
        return pulumi.get(self, "server_version")

    @server_version.setter
    def server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_version", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        User name
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class PostgreSqlConnectionInfoArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 server_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 additional_settings: Optional[pulumi.Input[str]] = None,
                 authentication: Optional[pulumi.Input[Union[str, 'AuthenticationType']]] = None,
                 data_source: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 encrypt_connection: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 server_brand_version: Optional[pulumi.Input[str]] = None,
                 server_version: Optional[pulumi.Input[str]] = None,
                 trust_server_certificate: Optional[pulumi.Input[bool]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Information for connecting to PostgreSQL server
        :param pulumi.Input[int] port: Port for Server
        :param pulumi.Input[str] server_name: Name of the server
        :param pulumi.Input[str] type: Type of connection info
               Expected value is 'PostgreSqlConnectionInfo'.
        :param pulumi.Input[str] additional_settings: Additional connection settings
        :param pulumi.Input[Union[str, 'AuthenticationType']] authentication: Authentication type to use for connection
        :param pulumi.Input[str] data_source: Data source 
        :param pulumi.Input[str] database_name: Name of the database
        :param pulumi.Input[bool] encrypt_connection: Whether to encrypt the connection
        :param pulumi.Input[str] password: Password credential.
        :param pulumi.Input[str] server_brand_version: server brand version
        :param pulumi.Input[str] server_version: server version
        :param pulumi.Input[bool] trust_server_certificate: Whether to trust the server certificate
        :param pulumi.Input[str] user_name: User name
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "type", 'PostgreSqlConnectionInfo')
        if additional_settings is not None:
            pulumi.set(__self__, "additional_settings", additional_settings)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if encrypt_connection is None:
            encrypt_connection = True
        if encrypt_connection is not None:
            pulumi.set(__self__, "encrypt_connection", encrypt_connection)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server_brand_version is not None:
            pulumi.set(__self__, "server_brand_version", server_brand_version)
        if server_version is not None:
            pulumi.set(__self__, "server_version", server_version)
        if trust_server_certificate is None:
            trust_server_certificate = False
        if trust_server_certificate is not None:
            pulumi.set(__self__, "trust_server_certificate", trust_server_certificate)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Port for Server
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        Name of the server
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of connection info
        Expected value is 'PostgreSqlConnectionInfo'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="additionalSettings")
    def additional_settings(self) -> Optional[pulumi.Input[str]]:
        """
        Additional connection settings
        """
        return pulumi.get(self, "additional_settings")

    @additional_settings.setter
    def additional_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_settings", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationType']]]:
        """
        Authentication type to use for connection
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationType']]]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input[str]]:
        """
        Data source 
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the database
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="encryptConnection")
    def encrypt_connection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to encrypt the connection
        """
        return pulumi.get(self, "encrypt_connection")

    @encrypt_connection.setter
    def encrypt_connection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_connection", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password credential.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="serverBrandVersion")
    def server_brand_version(self) -> Optional[pulumi.Input[str]]:
        """
        server brand version
        """
        return pulumi.get(self, "server_brand_version")

    @server_brand_version.setter
    def server_brand_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_brand_version", value)

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Optional[pulumi.Input[str]]:
        """
        server version
        """
        return pulumi.get(self, "server_version")

    @server_version.setter
    def server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_version", value)

    @property
    @pulumi.getter(name="trustServerCertificate")
    def trust_server_certificate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to trust the server certificate
        """
        return pulumi.get(self, "trust_server_certificate")

    @trust_server_certificate.setter
    def trust_server_certificate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "trust_server_certificate", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        User name
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class ProjectFilePropertiesArgs:
    def __init__(__self__, *,
                 extension: Optional[pulumi.Input[str]] = None,
                 file_path: Optional[pulumi.Input[str]] = None,
                 media_type: Optional[pulumi.Input[str]] = None):
        """
        Base class for file properties.
        :param pulumi.Input[str] extension: Optional File extension. If submitted it should not have a leading period and must match the extension from filePath.
        :param pulumi.Input[str] file_path: Relative path of this file resource. This property can be set when creating or updating the file resource.
        :param pulumi.Input[str] media_type: File content type. This property can be modified to reflect the file content type.
        """
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if media_type is not None:
            pulumi.set(__self__, "media_type", media_type)

    @property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input[str]]:
        """
        Optional File extension. If submitted it should not have a leading period and must match the extension from filePath.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extension", value)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[pulumi.Input[str]]:
        """
        Relative path of this file resource. This property can be set when creating or updating the file resource.
        """
        return pulumi.get(self, "file_path")

    @file_path.setter
    def file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_path", value)

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> Optional[pulumi.Input[str]]:
        """
        File content type. This property can be modified to reflect the file content type.
        """
        return pulumi.get(self, "media_type")

    @media_type.setter
    def media_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "media_type", value)


@pulumi.input_type
class SelectedCertificateInputArgs:
    def __init__(__self__, *,
                 certificate_name: pulumi.Input[str],
                 password: pulumi.Input[str]):
        """
        Info for certificate to be exported for TDE enabled databases.
        :param pulumi.Input[str] certificate_name: Name of certificate to be exported.
        :param pulumi.Input[str] password: Password to use for encrypting the exported certificate.
        """
        pulumi.set(__self__, "certificate_name", certificate_name)
        pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Input[str]:
        """
        Name of certificate to be exported.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Password to use for encrypting the exported certificate.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class ServiceSkuArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[int]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        An Azure SKU instance
        :param pulumi.Input[int] capacity: The capacity of the SKU, if it supports scaling
        :param pulumi.Input[str] family: The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual machines
        :param pulumi.Input[str] name: The unique name of the SKU, such as 'P3'
        :param pulumi.Input[str] size: The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines
        :param pulumi.Input[str] tier: The tier of the SKU, such as 'Basic', 'General Purpose', or 'Business Critical'
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The capacity of the SKU, if it supports scaling
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual machines
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name of the SKU, such as 'P3'
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        The tier of the SKU, such as 'Basic', 'General Purpose', or 'Business Critical'
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SqlConnectionInformationArgs:
    def __init__(__self__, *,
                 authentication: Optional[pulumi.Input[str]] = None,
                 data_source: Optional[pulumi.Input[str]] = None,
                 encrypt_connection: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 trust_server_certificate: Optional[pulumi.Input[bool]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Source SQL Connection
        :param pulumi.Input[str] authentication: Authentication type.
        :param pulumi.Input[str] data_source: Data source.
        :param pulumi.Input[bool] encrypt_connection: Whether to encrypt connection or not.
        :param pulumi.Input[str] password: Password to connect to source SQL.
        :param pulumi.Input[bool] trust_server_certificate: Whether to trust server certificate or not.
        :param pulumi.Input[str] user_name: User name to connect to source SQL.
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if encrypt_connection is not None:
            pulumi.set(__self__, "encrypt_connection", encrypt_connection)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if trust_server_certificate is not None:
            pulumi.set(__self__, "trust_server_certificate", trust_server_certificate)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input[str]]:
        """
        Authentication type.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input[str]]:
        """
        Data source.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter(name="encryptConnection")
    def encrypt_connection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to encrypt connection or not.
        """
        return pulumi.get(self, "encrypt_connection")

    @encrypt_connection.setter
    def encrypt_connection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_connection", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password to connect to source SQL.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="trustServerCertificate")
    def trust_server_certificate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to trust server certificate or not.
        """
        return pulumi.get(self, "trust_server_certificate")

    @trust_server_certificate.setter
    def trust_server_certificate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "trust_server_certificate", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        User name to connect to source SQL.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class SqlConnectionInfoArgs:
    def __init__(__self__, *,
                 data_source: pulumi.Input[str],
                 type: pulumi.Input[str],
                 additional_settings: Optional[pulumi.Input[str]] = None,
                 authentication: Optional[pulumi.Input[Union[str, 'AuthenticationType']]] = None,
                 encrypt_connection: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[Union[str, 'SqlSourcePlatform']]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 server_brand_version: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 server_version: Optional[pulumi.Input[str]] = None,
                 trust_server_certificate: Optional[pulumi.Input[bool]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Information for connecting to SQL database server
        :param pulumi.Input[str] data_source: Data source in the format Protocol:MachineName\\SQLServerInstanceName,PortNumber
        :param pulumi.Input[str] type: Type of connection info
               Expected value is 'SqlConnectionInfo'.
        :param pulumi.Input[str] additional_settings: Additional connection settings
        :param pulumi.Input[Union[str, 'AuthenticationType']] authentication: Authentication type to use for connection
        :param pulumi.Input[bool] encrypt_connection: Whether to encrypt the connection
        :param pulumi.Input[str] password: Password credential.
        :param pulumi.Input[Union[str, 'SqlSourcePlatform']] platform: Server platform type for connection
        :param pulumi.Input[int] port: Port for Server
        :param pulumi.Input[str] resource_id: Represents the ID of an HTTP resource represented by an Azure resource provider.
        :param pulumi.Input[str] server_brand_version: server brand version
        :param pulumi.Input[str] server_name: name of the server
        :param pulumi.Input[str] server_version: server version
        :param pulumi.Input[bool] trust_server_certificate: Whether to trust the server certificate
        :param pulumi.Input[str] user_name: User name
        """
        pulumi.set(__self__, "data_source", data_source)
        pulumi.set(__self__, "type", 'SqlConnectionInfo')
        if additional_settings is not None:
            pulumi.set(__self__, "additional_settings", additional_settings)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if encrypt_connection is None:
            encrypt_connection = True
        if encrypt_connection is not None:
            pulumi.set(__self__, "encrypt_connection", encrypt_connection)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if server_brand_version is not None:
            pulumi.set(__self__, "server_brand_version", server_brand_version)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if server_version is not None:
            pulumi.set(__self__, "server_version", server_version)
        if trust_server_certificate is None:
            trust_server_certificate = False
        if trust_server_certificate is not None:
            pulumi.set(__self__, "trust_server_certificate", trust_server_certificate)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Input[str]:
        """
        Data source in the format Protocol:MachineName\\SQLServerInstanceName,PortNumber
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of connection info
        Expected value is 'SqlConnectionInfo'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="additionalSettings")
    def additional_settings(self) -> Optional[pulumi.Input[str]]:
        """
        Additional connection settings
        """
        return pulumi.get(self, "additional_settings")

    @additional_settings.setter
    def additional_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_settings", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationType']]]:
        """
        Authentication type to use for connection
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationType']]]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="encryptConnection")
    def encrypt_connection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to encrypt the connection
        """
        return pulumi.get(self, "encrypt_connection")

    @encrypt_connection.setter
    def encrypt_connection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_connection", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password credential.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[Union[str, 'SqlSourcePlatform']]]:
        """
        Server platform type for connection
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[Union[str, 'SqlSourcePlatform']]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port for Server
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Represents the ID of an HTTP resource represented by an Azure resource provider.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="serverBrandVersion")
    def server_brand_version(self) -> Optional[pulumi.Input[str]]:
        """
        server brand version
        """
        return pulumi.get(self, "server_brand_version")

    @server_brand_version.setter
    def server_brand_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_brand_version", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the server
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Optional[pulumi.Input[str]]:
        """
        server version
        """
        return pulumi.get(self, "server_version")

    @server_version.setter
    def server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_version", value)

    @property
    @pulumi.getter(name="trustServerCertificate")
    def trust_server_certificate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to trust the server certificate
        """
        return pulumi.get(self, "trust_server_certificate")

    @trust_server_certificate.setter
    def trust_server_certificate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "trust_server_certificate", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        User name
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class SsisMigrationInfoArgs:
    def __init__(__self__, *,
                 environment_overwrite_option: Optional[pulumi.Input[Union[str, 'SsisMigrationOverwriteOption']]] = None,
                 project_overwrite_option: Optional[pulumi.Input[Union[str, 'SsisMigrationOverwriteOption']]] = None,
                 ssis_store_type: Optional[pulumi.Input[Union[str, 'SsisStoreType']]] = None):
        """
        SSIS migration info with SSIS store type, overwrite policy.
        :param pulumi.Input[Union[str, 'SsisMigrationOverwriteOption']] environment_overwrite_option: The overwrite option for the SSIS environment migration
        :param pulumi.Input[Union[str, 'SsisMigrationOverwriteOption']] project_overwrite_option: The overwrite option for the SSIS project migration
        :param pulumi.Input[Union[str, 'SsisStoreType']] ssis_store_type: The SSIS store type of source, only SSIS catalog is supported now in DMS (classic)
        """
        if environment_overwrite_option is not None:
            pulumi.set(__self__, "environment_overwrite_option", environment_overwrite_option)
        if project_overwrite_option is not None:
            pulumi.set(__self__, "project_overwrite_option", project_overwrite_option)
        if ssis_store_type is not None:
            pulumi.set(__self__, "ssis_store_type", ssis_store_type)

    @property
    @pulumi.getter(name="environmentOverwriteOption")
    def environment_overwrite_option(self) -> Optional[pulumi.Input[Union[str, 'SsisMigrationOverwriteOption']]]:
        """
        The overwrite option for the SSIS environment migration
        """
        return pulumi.get(self, "environment_overwrite_option")

    @environment_overwrite_option.setter
    def environment_overwrite_option(self, value: Optional[pulumi.Input[Union[str, 'SsisMigrationOverwriteOption']]]):
        pulumi.set(self, "environment_overwrite_option", value)

    @property
    @pulumi.getter(name="projectOverwriteOption")
    def project_overwrite_option(self) -> Optional[pulumi.Input[Union[str, 'SsisMigrationOverwriteOption']]]:
        """
        The overwrite option for the SSIS project migration
        """
        return pulumi.get(self, "project_overwrite_option")

    @project_overwrite_option.setter
    def project_overwrite_option(self, value: Optional[pulumi.Input[Union[str, 'SsisMigrationOverwriteOption']]]):
        pulumi.set(self, "project_overwrite_option", value)

    @property
    @pulumi.getter(name="ssisStoreType")
    def ssis_store_type(self) -> Optional[pulumi.Input[Union[str, 'SsisStoreType']]]:
        """
        The SSIS store type of source, only SSIS catalog is supported now in DMS (classic)
        """
        return pulumi.get(self, "ssis_store_type")

    @ssis_store_type.setter
    def ssis_store_type(self, value: Optional[pulumi.Input[Union[str, 'SsisStoreType']]]):
        pulumi.set(self, "ssis_store_type", value)


@pulumi.input_type
class ValidateMigrationInputSqlServerSqlDbSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['ValidateSyncMigrationInputSqlServerTaskInputArgs']] = None):
        """
        Properties for task that validates migration input for SQL to Azure SQL DB sync migrations
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ValidateMigrationInput.SqlServer.SqlDb.Sync'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['ValidateSyncMigrationInputSqlServerTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ValidateMigrationInput.SqlServer.SqlDb.Sync')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ValidateMigrationInput.SqlServer.SqlDb.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ValidateSyncMigrationInputSqlServerTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ValidateSyncMigrationInputSqlServerTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs:
    def __init__(__self__, *,
                 azure_app: pulumi.Input['AzureActiveDirectoryAppArgs'],
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 storage_resource_id: pulumi.Input[str],
                 target_connection_info: pulumi.Input['MiSqlConnectionInfoArgs'],
                 backup_file_share: Optional[pulumi.Input['FileShareArgs']] = None):
        """
        Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance online scenario.
        :param pulumi.Input['AzureActiveDirectoryAppArgs'] azure_app: Azure Active Directory Application the DMS (classic) instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        :param pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Connection information for source SQL Server
        :param pulumi.Input[str] storage_resource_id: Fully qualified resourceId of storage
        :param pulumi.Input['MiSqlConnectionInfoArgs'] target_connection_info: Connection information for Azure SQL Database Managed Instance
        :param pulumi.Input['FileShareArgs'] backup_file_share: Backup file share information for all selected databases.
        """
        pulumi.set(__self__, "azure_app", azure_app)
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "storage_resource_id", storage_resource_id)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)

    @property
    @pulumi.getter(name="azureApp")
    def azure_app(self) -> pulumi.Input['AzureActiveDirectoryAppArgs']:
        """
        Azure Active Directory Application the DMS (classic) instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        """
        return pulumi.get(self, "azure_app")

    @azure_app.setter
    def azure_app(self, value: pulumi.Input['AzureActiveDirectoryAppArgs']):
        pulumi.set(self, "azure_app", value)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Connection information for source SQL Server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="storageResourceId")
    def storage_resource_id(self) -> pulumi.Input[str]:
        """
        Fully qualified resourceId of storage
        """
        return pulumi.get(self, "storage_resource_id")

    @storage_resource_id.setter
    def storage_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_resource_id", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['MiSqlConnectionInfoArgs']:
        """
        Connection information for Azure SQL Database Managed Instance
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['MiSqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional[pulumi.Input['FileShareArgs']]:
        """
        Backup file share information for all selected databases.
        """
        return pulumi.get(self, "backup_file_share")

    @backup_file_share.setter
    def backup_file_share(self, value: Optional[pulumi.Input['FileShareArgs']]):
        pulumi.set(self, "backup_file_share", value)


@pulumi.input_type
class ValidateMigrationInputSqlServerSqlMISyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs']] = None):
        """
        Properties for task that validates migration input for SQL to Azure SQL Database Managed Instance sync scenario
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ValidateMigrationInputSqlServerSqlMITaskInputArgs:
    def __init__(__self__, *,
                 backup_blob_share: pulumi.Input['BlobShareArgs'],
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 backup_file_share: Optional[pulumi.Input['FileShareArgs']] = None,
                 backup_mode: Optional[pulumi.Input[Union[str, 'BackupMode']]] = None,
                 selected_logins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input for task that validates migration input for SQL to Azure SQL Managed Instance
        :param pulumi.Input['BlobShareArgs'] backup_blob_share: SAS URI of Azure Storage Account Container to be used for storing backup files.
        :param pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Information for connecting to source
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Information for connecting to target
        :param pulumi.Input['FileShareArgs'] backup_file_share: Backup file share information for all selected databases.
        :param pulumi.Input[Union[str, 'BackupMode']] backup_mode: Backup Mode to specify whether to use existing backup or create new backup.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_logins: Logins to migrate
        """
        pulumi.set(__self__, "backup_blob_share", backup_blob_share)
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)
        if backup_mode is not None:
            pulumi.set(__self__, "backup_mode", backup_mode)
        if selected_logins is not None:
            pulumi.set(__self__, "selected_logins", selected_logins)

    @property
    @pulumi.getter(name="backupBlobShare")
    def backup_blob_share(self) -> pulumi.Input['BlobShareArgs']:
        """
        SAS URI of Azure Storage Account Container to be used for storing backup files.
        """
        return pulumi.get(self, "backup_blob_share")

    @backup_blob_share.setter
    def backup_blob_share(self, value: pulumi.Input['BlobShareArgs']):
        pulumi.set(self, "backup_blob_share", value)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlMIDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to source
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional[pulumi.Input['FileShareArgs']]:
        """
        Backup file share information for all selected databases.
        """
        return pulumi.get(self, "backup_file_share")

    @backup_file_share.setter
    def backup_file_share(self, value: Optional[pulumi.Input['FileShareArgs']]):
        pulumi.set(self, "backup_file_share", value)

    @property
    @pulumi.getter(name="backupMode")
    def backup_mode(self) -> Optional[pulumi.Input[Union[str, 'BackupMode']]]:
        """
        Backup Mode to specify whether to use existing backup or create new backup.
        """
        return pulumi.get(self, "backup_mode")

    @backup_mode.setter
    def backup_mode(self, value: Optional[pulumi.Input[Union[str, 'BackupMode']]]):
        pulumi.set(self, "backup_mode", value)

    @property
    @pulumi.getter(name="selectedLogins")
    def selected_logins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Logins to migrate
        """
        return pulumi.get(self, "selected_logins")

    @selected_logins.setter
    def selected_logins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "selected_logins", value)


@pulumi.input_type
class ValidateMigrationInputSqlServerSqlMITaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['ValidateMigrationInputSqlServerSqlMITaskInputArgs']] = None):
        """
        Properties for task that validates migration input for SQL to Azure SQL Database Managed Instance
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'ValidateMigrationInput.SqlServer.AzureSqlDbMI'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['ValidateMigrationInputSqlServerSqlMITaskInputArgs'] input: Task input
        """
        pulumi.set(__self__, "task_type", 'ValidateMigrationInput.SqlServer.AzureSqlDbMI')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'ValidateMigrationInput.SqlServer.AzureSqlDbMI'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ValidateMigrationInputSqlServerSqlMITaskInputArgs']]:
        """
        Task input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ValidateMigrationInputSqlServerSqlMITaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ValidateMongoDbTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['MongoDbMigrationSettingsArgs']] = None):
        """
        Properties for the task that validates a migration between MongoDB data sources
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Validate.MongoDb'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['MongoDbMigrationSettingsArgs'] input: Describes how a MongoDB data migration should be performed
        """
        pulumi.set(__self__, "task_type", 'Validate.MongoDb')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Validate.MongoDb'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MongoDbMigrationSettingsArgs']]:
        """
        Describes how a MongoDB data migration should be performed
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MongoDbMigrationSettingsArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ValidateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 client_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs']] = None):
        """
        Properties for the task that validates a migration for Oracle to Azure Database for PostgreSQL for online migrations
        :param pulumi.Input[str] task_type: Task type.
               Expected value is 'Validate.Oracle.AzureDbPostgreSql.Sync'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_data: Key value pairs of client data to attach meta data information to task
        :param pulumi.Input['MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs'] input: Input for the task that migrates Oracle databases to Azure Database for PostgreSQL for online migrations
        """
        pulumi.set(__self__, "task_type", 'Validate.Oracle.AzureDbPostgreSql.Sync')
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        Task type.
        Expected value is 'Validate.Oracle.AzureDbPostgreSql.Sync'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs of client data to attach meta data information to task
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs']]:
        """
        Input for the task that migrates Oracle databases to Azure Database for PostgreSQL for online migrations
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs']]):
        pulumi.set(self, "input", value)


@pulumi.input_type
class ValidateSyncMigrationInputSqlServerTaskInputArgs:
    def __init__(__self__, *,
                 selected_databases: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbSyncDatabaseInputArgs']]],
                 source_connection_info: pulumi.Input['SqlConnectionInfoArgs'],
                 target_connection_info: pulumi.Input['SqlConnectionInfoArgs']):
        """
        Input for task that validates migration input for SQL sync migrations
        :param pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbSyncDatabaseInputArgs']]] selected_databases: Databases to migrate
        :param pulumi.Input['SqlConnectionInfoArgs'] source_connection_info: Information for connecting to source SQL server
        :param pulumi.Input['SqlConnectionInfoArgs'] target_connection_info: Information for connecting to target
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbSyncDatabaseInputArgs']]]:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @selected_databases.setter
    def selected_databases(self, value: pulumi.Input[Sequence[pulumi.Input['MigrateSqlServerSqlDbSyncDatabaseInputArgs']]]):
        pulumi.set(self, "selected_databases", value)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to source SQL server
        """
        return pulumi.get(self, "source_connection_info")

    @source_connection_info.setter
    def source_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "source_connection_info", value)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> pulumi.Input['SqlConnectionInfoArgs']:
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @target_connection_info.setter
    def target_connection_info(self, value: pulumi.Input['SqlConnectionInfoArgs']):
        pulumi.set(self, "target_connection_info", value)


