# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AdvancedScheduleMonthlyOccurrenceResponse',
    'AdvancedScheduleResponse',
    'AzureQueryPropertiesResponse',
    'ConnectionTypeAssociationPropertyResponse',
    'ContentHashResponse',
    'ContentLinkResponse',
    'ContentSourceResponse',
    'DscConfigurationAssociationPropertyResponse',
    'DscConfigurationParameterResponse',
    'EncryptionPropertiesResponse',
    'EncryptionPropertiesResponseIdentity',
    'ErrorResponseResponse',
    'FieldDefinitionResponse',
    'HybridRunbookWorkerLegacyResponse',
    'IdentityResponse',
    'IdentityResponseUserAssignedIdentities',
    'KeyResponse',
    'KeyVaultPropertiesResponse',
    'LinuxPropertiesResponse',
    'ModuleErrorInfoResponse',
    'NonAzureQueryPropertiesResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointPropertyResponse',
    'PrivateLinkServiceConnectionStatePropertyResponse',
    'RunAsCredentialAssociationPropertyResponse',
    'RunbookAssociationPropertyResponse',
    'RunbookDraftResponse',
    'RunbookParameterResponse',
    'SUCSchedulePropertiesResponse',
    'ScheduleAssociationPropertyResponse',
    'SkuResponse',
    'SoftwareUpdateConfigurationTasksResponse',
    'SystemDataResponse',
    'TagSettingsPropertiesResponse',
    'TargetPropertiesResponse',
    'TaskPropertiesResponse',
    'UpdateConfigurationResponse',
    'WindowsPropertiesResponse',
]

@pulumi.output_type
class AdvancedScheduleMonthlyOccurrenceResponse(dict):
    """
    The properties of the create advanced schedule monthly occurrence.
    """
    def __init__(__self__, *,
                 day: Optional[str] = None,
                 occurrence: Optional[int] = None):
        """
        The properties of the create advanced schedule monthly occurrence.
        :param str day: Day of the occurrence. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
        :param int occurrence: Occurrence of the week within the month. Must be between 1 and 5
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if occurrence is not None:
            pulumi.set(__self__, "occurrence", occurrence)

    @property
    @pulumi.getter
    def day(self) -> Optional[str]:
        """
        Day of the occurrence. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def occurrence(self) -> Optional[int]:
        """
        Occurrence of the week within the month. Must be between 1 and 5
        """
        return pulumi.get(self, "occurrence")


@pulumi.output_type
class AdvancedScheduleResponse(dict):
    """
    The properties of the create Advanced Schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monthDays":
            suggest = "month_days"
        elif key == "monthlyOccurrences":
            suggest = "monthly_occurrences"
        elif key == "weekDays":
            suggest = "week_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AdvancedScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AdvancedScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AdvancedScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 month_days: Optional[Sequence[int]] = None,
                 monthly_occurrences: Optional[Sequence['outputs.AdvancedScheduleMonthlyOccurrenceResponse']] = None,
                 week_days: Optional[Sequence[str]] = None):
        """
        The properties of the create Advanced Schedule.
        :param Sequence[int] month_days: Days of the month that the job should execute on. Must be between 1 and 31.
        :param Sequence['AdvancedScheduleMonthlyOccurrenceResponse'] monthly_occurrences: Occurrences of days within a month.
        :param Sequence[str] week_days: Days of the week that the job should execute on.
        """
        if month_days is not None:
            pulumi.set(__self__, "month_days", month_days)
        if monthly_occurrences is not None:
            pulumi.set(__self__, "monthly_occurrences", monthly_occurrences)
        if week_days is not None:
            pulumi.set(__self__, "week_days", week_days)

    @property
    @pulumi.getter(name="monthDays")
    def month_days(self) -> Optional[Sequence[int]]:
        """
        Days of the month that the job should execute on. Must be between 1 and 31.
        """
        return pulumi.get(self, "month_days")

    @property
    @pulumi.getter(name="monthlyOccurrences")
    def monthly_occurrences(self) -> Optional[Sequence['outputs.AdvancedScheduleMonthlyOccurrenceResponse']]:
        """
        Occurrences of days within a month.
        """
        return pulumi.get(self, "monthly_occurrences")

    @property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> Optional[Sequence[str]]:
        """
        Days of the week that the job should execute on.
        """
        return pulumi.get(self, "week_days")


@pulumi.output_type
class AzureQueryPropertiesResponse(dict):
    """
    Azure query for the update configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagSettings":
            suggest = "tag_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureQueryPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureQueryPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureQueryPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 locations: Optional[Sequence[str]] = None,
                 scope: Optional[Sequence[str]] = None,
                 tag_settings: Optional['outputs.TagSettingsPropertiesResponse'] = None):
        """
        Azure query for the update configuration.
        :param Sequence[str] locations: List of locations to scope the query to.
        :param Sequence[str] scope: List of Subscription or Resource Group ARM Ids.
        :param 'TagSettingsPropertiesResponse' tag_settings: Tag settings for the VM.
        """
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if tag_settings is not None:
            pulumi.set(__self__, "tag_settings", tag_settings)

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[str]]:
        """
        List of locations to scope the query to.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def scope(self) -> Optional[Sequence[str]]:
        """
        List of Subscription or Resource Group ARM Ids.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="tagSettings")
    def tag_settings(self) -> Optional['outputs.TagSettingsPropertiesResponse']:
        """
        Tag settings for the VM.
        """
        return pulumi.get(self, "tag_settings")


@pulumi.output_type
class ConnectionTypeAssociationPropertyResponse(dict):
    """
    The connection type property associated with the entity.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        The connection type property associated with the entity.
        :param str name: Gets or sets the name of the connection type.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the name of the connection type.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ContentHashResponse(dict):
    """
    Definition of the runbook property type.
    """
    def __init__(__self__, *,
                 algorithm: str,
                 value: str):
        """
        Definition of the runbook property type.
        :param str algorithm: Gets or sets the content hash algorithm used to hash the content.
        :param str value: Gets or sets expected hash value of the content.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        Gets or sets the content hash algorithm used to hash the content.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Gets or sets expected hash value of the content.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContentLinkResponse(dict):
    """
    Definition of the content link.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentHash":
            suggest = "content_hash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentLinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentLinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentLinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_hash: Optional['outputs.ContentHashResponse'] = None,
                 uri: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Definition of the content link.
        :param 'ContentHashResponse' content_hash: Gets or sets the hash.
        :param str uri: Gets or sets the uri of the runbook content.
        :param str version: Gets or sets the version of the content.
        """
        if content_hash is not None:
            pulumi.set(__self__, "content_hash", content_hash)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="contentHash")
    def content_hash(self) -> Optional['outputs.ContentHashResponse']:
        """
        Gets or sets the hash.
        """
        return pulumi.get(self, "content_hash")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Gets or sets the uri of the runbook content.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Gets or sets the version of the content.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ContentSourceResponse(dict):
    """
    Definition of the content source.
    """
    def __init__(__self__, *,
                 hash: Optional['outputs.ContentHashResponse'] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Definition of the content source.
        :param 'ContentHashResponse' hash: Gets or sets the hash.
        :param str type: Gets or sets the content source type.
        :param str value: Gets or sets the value of the content. This is based on the content source type.
        :param str version: Gets or sets the version of the content.
        """
        if hash is not None:
            pulumi.set(__self__, "hash", hash)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def hash(self) -> Optional['outputs.ContentHashResponse']:
        """
        Gets or sets the hash.
        """
        return pulumi.get(self, "hash")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Gets or sets the content source type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Gets or sets the value of the content. This is based on the content source type.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Gets or sets the version of the content.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class DscConfigurationAssociationPropertyResponse(dict):
    """
    The Dsc configuration property associated with the entity.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        The Dsc configuration property associated with the entity.
        :param str name: Gets or sets the name of the Dsc configuration.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the name of the Dsc configuration.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DscConfigurationParameterResponse(dict):
    """
    Definition of the configuration parameter type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "isMandatory":
            suggest = "is_mandatory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DscConfigurationParameterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DscConfigurationParameterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DscConfigurationParameterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: Optional[str] = None,
                 is_mandatory: Optional[bool] = None,
                 position: Optional[int] = None,
                 type: Optional[str] = None):
        """
        Definition of the configuration parameter type.
        :param str default_value: Gets or sets the default value of parameter.
        :param bool is_mandatory: Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
        :param int position: Get or sets the position of the parameter.
        :param str type: Gets or sets the type of the parameter.
        """
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if is_mandatory is not None:
            pulumi.set(__self__, "is_mandatory", is_mandatory)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[str]:
        """
        Gets or sets the default value of parameter.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="isMandatory")
    def is_mandatory(self) -> Optional[bool]:
        """
        Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
        """
        return pulumi.get(self, "is_mandatory")

    @property
    @pulumi.getter
    def position(self) -> Optional[int]:
        """
        Get or sets the position of the parameter.
        """
        return pulumi.get(self, "position")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Gets or sets the type of the parameter.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EncryptionPropertiesResponse(dict):
    """
    The encryption settings for automation account
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keySource":
            suggest = "key_source"
        elif key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity: Optional['outputs.EncryptionPropertiesResponseIdentity'] = None,
                 key_source: Optional[str] = None,
                 key_vault_properties: Optional['outputs.KeyVaultPropertiesResponse'] = None):
        """
        The encryption settings for automation account
        :param 'EncryptionPropertiesResponseIdentity' identity: User identity used for CMK.
        :param str key_source: Encryption Key Source
        :param 'KeyVaultPropertiesResponse' key_vault_properties: Key vault properties.
        """
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_source is not None:
            pulumi.set(__self__, "key_source", key_source)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.EncryptionPropertiesResponseIdentity']:
        """
        User identity used for CMK.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="keySource")
    def key_source(self) -> Optional[str]:
        """
        Encryption Key Source
        """
        return pulumi.get(self, "key_source")

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional['outputs.KeyVaultPropertiesResponse']:
        """
        Key vault properties.
        """
        return pulumi.get(self, "key_vault_properties")


@pulumi.output_type
class EncryptionPropertiesResponseIdentity(dict):
    """
    User identity used for CMK.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionPropertiesResponseIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionPropertiesResponseIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionPropertiesResponseIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_assigned_identity: Optional[Any] = None):
        """
        User identity used for CMK.
        :param Any user_assigned_identity: The user identity used for CMK. It will be an ARM resource id in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[Any]:
        """
        The user identity used for CMK. It will be an ARM resource id in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class ErrorResponseResponse(dict):
    """
    Error response of an operation failure
    """
    def __init__(__self__, *,
                 code: Optional[str] = None,
                 message: Optional[str] = None):
        """
        Error response of an operation failure
        :param str code: Error code
        :param str message: Error message indicating why the operation failed.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        Error code
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Error message indicating why the operation failed.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class FieldDefinitionResponse(dict):
    """
    Definition of the connection fields.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEncrypted":
            suggest = "is_encrypted"
        elif key == "isOptional":
            suggest = "is_optional"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FieldDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FieldDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FieldDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 is_encrypted: Optional[bool] = None,
                 is_optional: Optional[bool] = None):
        """
        Definition of the connection fields.
        :param str type: Gets or sets the type of the connection field definition.
        :param bool is_encrypted: Gets or sets the isEncrypted flag of the connection field definition.
        :param bool is_optional: Gets or sets the isOptional flag of the connection field definition.
        """
        pulumi.set(__self__, "type", type)
        if is_encrypted is not None:
            pulumi.set(__self__, "is_encrypted", is_encrypted)
        if is_optional is not None:
            pulumi.set(__self__, "is_optional", is_optional)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Gets or sets the type of the connection field definition.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="isEncrypted")
    def is_encrypted(self) -> Optional[bool]:
        """
        Gets or sets the isEncrypted flag of the connection field definition.
        """
        return pulumi.get(self, "is_encrypted")

    @property
    @pulumi.getter(name="isOptional")
    def is_optional(self) -> Optional[bool]:
        """
        Gets or sets the isOptional flag of the connection field definition.
        """
        return pulumi.get(self, "is_optional")


@pulumi.output_type
class HybridRunbookWorkerLegacyResponse(dict):
    """
    Definition of hybrid runbook worker Legacy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastSeenDateTime":
            suggest = "last_seen_date_time"
        elif key == "registrationTime":
            suggest = "registration_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HybridRunbookWorkerLegacyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HybridRunbookWorkerLegacyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HybridRunbookWorkerLegacyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip: Optional[str] = None,
                 last_seen_date_time: Optional[str] = None,
                 name: Optional[str] = None,
                 registration_time: Optional[str] = None):
        """
        Definition of hybrid runbook worker Legacy.
        :param str ip: Gets or sets the assigned machine IP address.
        :param str last_seen_date_time: Last Heartbeat from the Worker
        :param str name: Gets or sets the worker machine name.
        :param str registration_time: Gets or sets the registration time of the worker machine.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if last_seen_date_time is not None:
            pulumi.set(__self__, "last_seen_date_time", last_seen_date_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if registration_time is not None:
            pulumi.set(__self__, "registration_time", registration_time)

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        Gets or sets the assigned machine IP address.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="lastSeenDateTime")
    def last_seen_date_time(self) -> Optional[str]:
        """
        Last Heartbeat from the Worker
        """
        return pulumi.get(self, "last_seen_date_time")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the worker machine name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="registrationTime")
    def registration_time(self) -> Optional[str]:
        """
        Gets or sets the registration time of the worker machine.
        """
        return pulumi.get(self, "registration_time")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.IdentityResponseUserAssignedIdentities']] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        :param Mapping[str, 'IdentityResponseUserAssignedIdentities'] user_assigned_identities: The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.IdentityResponseUserAssignedIdentities']]:
        """
        The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class IdentityResponseUserAssignedIdentities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponseUserAssignedIdentities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponseUserAssignedIdentities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponseUserAssignedIdentities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        :param str client_id: The client id of user assigned identity.
        :param str principal_id: The principal id of user assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class KeyResponse(dict):
    """
    Automation key which is used to register a DSC Node
    """
    def __init__(__self__, *,
                 key_name: str,
                 permissions: str,
                 value: str):
        """
        Automation key which is used to register a DSC Node
        :param str key_name: Automation key name.
        :param str permissions: Automation key permissions.
        :param str value: Value of the Automation Key used for registration.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        Automation key name.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def permissions(self) -> str:
        """
        Automation key permissions.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the Automation Key used for registration.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class KeyVaultPropertiesResponse(dict):
    """
    Settings concerning key vault encryption for a configuration store.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyName":
            suggest = "key_name"
        elif key == "keyVersion":
            suggest = "key_version"
        elif key == "keyvaultUri":
            suggest = "keyvault_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_name: Optional[str] = None,
                 key_version: Optional[str] = None,
                 keyvault_uri: Optional[str] = None):
        """
        Settings concerning key vault encryption for a configuration store.
        :param str key_name: The name of key used to encrypt data.
        :param str key_version: The key version of the key used to encrypt data.
        :param str keyvault_uri: The URI of the key vault key used to encrypt data.
        """
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)
        if keyvault_uri is not None:
            pulumi.set(__self__, "keyvault_uri", keyvault_uri)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[str]:
        """
        The name of key used to encrypt data.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[str]:
        """
        The key version of the key used to encrypt data.
        """
        return pulumi.get(self, "key_version")

    @property
    @pulumi.getter(name="keyvaultUri")
    def keyvault_uri(self) -> Optional[str]:
        """
        The URI of the key vault key used to encrypt data.
        """
        return pulumi.get(self, "keyvault_uri")


@pulumi.output_type
class LinuxPropertiesResponse(dict):
    """
    Linux specific update configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedPackageNameMasks":
            suggest = "excluded_package_name_masks"
        elif key == "includedPackageClassifications":
            suggest = "included_package_classifications"
        elif key == "includedPackageNameMasks":
            suggest = "included_package_name_masks"
        elif key == "rebootSetting":
            suggest = "reboot_setting"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excluded_package_name_masks: Optional[Sequence[str]] = None,
                 included_package_classifications: Optional[str] = None,
                 included_package_name_masks: Optional[Sequence[str]] = None,
                 reboot_setting: Optional[str] = None):
        """
        Linux specific update configuration.
        :param Sequence[str] excluded_package_name_masks: packages excluded from the software update configuration.
        :param str included_package_classifications: Update classifications included in the software update configuration.
        :param Sequence[str] included_package_name_masks: packages included from the software update configuration.
        :param str reboot_setting: Reboot setting for the software update configuration.
        """
        if excluded_package_name_masks is not None:
            pulumi.set(__self__, "excluded_package_name_masks", excluded_package_name_masks)
        if included_package_classifications is not None:
            pulumi.set(__self__, "included_package_classifications", included_package_classifications)
        if included_package_name_masks is not None:
            pulumi.set(__self__, "included_package_name_masks", included_package_name_masks)
        if reboot_setting is not None:
            pulumi.set(__self__, "reboot_setting", reboot_setting)

    @property
    @pulumi.getter(name="excludedPackageNameMasks")
    def excluded_package_name_masks(self) -> Optional[Sequence[str]]:
        """
        packages excluded from the software update configuration.
        """
        return pulumi.get(self, "excluded_package_name_masks")

    @property
    @pulumi.getter(name="includedPackageClassifications")
    def included_package_classifications(self) -> Optional[str]:
        """
        Update classifications included in the software update configuration.
        """
        return pulumi.get(self, "included_package_classifications")

    @property
    @pulumi.getter(name="includedPackageNameMasks")
    def included_package_name_masks(self) -> Optional[Sequence[str]]:
        """
        packages included from the software update configuration.
        """
        return pulumi.get(self, "included_package_name_masks")

    @property
    @pulumi.getter(name="rebootSetting")
    def reboot_setting(self) -> Optional[str]:
        """
        Reboot setting for the software update configuration.
        """
        return pulumi.get(self, "reboot_setting")


@pulumi.output_type
class ModuleErrorInfoResponse(dict):
    """
    Definition of the module error info type.
    """
    def __init__(__self__, *,
                 code: Optional[str] = None,
                 message: Optional[str] = None):
        """
        Definition of the module error info type.
        :param str code: Gets or sets the error code.
        :param str message: Gets or sets the error message.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        Gets or sets the error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Gets or sets the error message.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class NonAzureQueryPropertiesResponse(dict):
    """
    Non Azure query for the update configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionAlias":
            suggest = "function_alias"
        elif key == "workspaceId":
            suggest = "workspace_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NonAzureQueryPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NonAzureQueryPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NonAzureQueryPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_alias: Optional[str] = None,
                 workspace_id: Optional[str] = None):
        """
        Non Azure query for the update configuration.
        :param str function_alias: Log Analytics Saved Search name.
        :param str workspace_id: Workspace Id for Log Analytics in which the saved Search is resided.
        """
        if function_alias is not None:
            pulumi.set(__self__, "function_alias", function_alias)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="functionAlias")
    def function_alias(self) -> Optional[str]:
        """
        Log Analytics Saved Search name.
        """
        return pulumi.get(self, "function_alias")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[str]:
        """
        Workspace Id for Log Analytics in which the saved Search is resided.
        """
        return pulumi.get(self, "workspace_id")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    A private endpoint connection
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupIds":
            suggest = "group_ids"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 type: str,
                 group_ids: Optional[Sequence[str]] = None,
                 private_endpoint: Optional['outputs.PrivateEndpointPropertyResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStatePropertyResponse'] = None):
        """
        A private endpoint connection
        :param str id: Fully qualified resource Id for the resource
        :param str name: The name of the resource
        :param str type: The type of the resource.
        :param Sequence[str] group_ids: Gets the groupIds.
        :param 'PrivateEndpointPropertyResponse' private_endpoint: Private endpoint which the connection belongs to.
        :param 'PrivateLinkServiceConnectionStatePropertyResponse' private_link_service_connection_state: Connection State of the Private Endpoint Connection.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource Id for the resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[Sequence[str]]:
        """
        Gets the groupIds.
        """
        return pulumi.get(self, "group_ids")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointPropertyResponse']:
        """
        Private endpoint which the connection belongs to.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStatePropertyResponse']:
        """
        Connection State of the Private Endpoint Connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class PrivateEndpointPropertyResponse(dict):
    """
    Private endpoint which the connection belongs to.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Private endpoint which the connection belongs to.
        :param str id: Resource id of the private endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource id of the private endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStatePropertyResponse(dict):
    """
    Connection State of the Private Endpoint Connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStatePropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStatePropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStatePropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: str,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        Connection State of the Private Endpoint Connection.
        :param str actions_required: Any action that is required beyond basic workflow (approve/ reject/ disconnect)
        :param str description: The private link service connection description.
        :param str status: The private link service connection status.
        """
        pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> str:
        """
        Any action that is required beyond basic workflow (approve/ reject/ disconnect)
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The private link service connection description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class RunAsCredentialAssociationPropertyResponse(dict):
    """
    Definition of RunAs credential to use for hybrid worker.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Definition of RunAs credential to use for hybrid worker.
        :param str name: Gets or sets the name of the credential.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the name of the credential.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class RunbookAssociationPropertyResponse(dict):
    """
    The runbook property associated with the entity.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        The runbook property associated with the entity.
        :param str name: Gets or sets the name of the runbook.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the name of the runbook.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class RunbookDraftResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTime":
            suggest = "creation_time"
        elif key == "draftContentLink":
            suggest = "draft_content_link"
        elif key == "inEdit":
            suggest = "in_edit"
        elif key == "lastModifiedTime":
            suggest = "last_modified_time"
        elif key == "outputTypes":
            suggest = "output_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RunbookDraftResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RunbookDraftResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RunbookDraftResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_time: Optional[str] = None,
                 draft_content_link: Optional['outputs.ContentLinkResponse'] = None,
                 in_edit: Optional[bool] = None,
                 last_modified_time: Optional[str] = None,
                 output_types: Optional[Sequence[str]] = None,
                 parameters: Optional[Mapping[str, 'outputs.RunbookParameterResponse']] = None):
        """
        :param str creation_time: Gets or sets the creation time of the runbook draft.
        :param 'ContentLinkResponse' draft_content_link: Gets or sets the draft runbook content link.
        :param bool in_edit: Gets or sets whether runbook is in edit mode.
        :param str last_modified_time: Gets or sets the last modified time of the runbook draft.
        :param Sequence[str] output_types: Gets or sets the runbook output types.
        :param Mapping[str, 'RunbookParameterResponse'] parameters: Gets or sets the runbook draft parameters.
        """
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if draft_content_link is not None:
            pulumi.set(__self__, "draft_content_link", draft_content_link)
        if in_edit is not None:
            pulumi.set(__self__, "in_edit", in_edit)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if output_types is not None:
            pulumi.set(__self__, "output_types", output_types)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[str]:
        """
        Gets or sets the creation time of the runbook draft.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="draftContentLink")
    def draft_content_link(self) -> Optional['outputs.ContentLinkResponse']:
        """
        Gets or sets the draft runbook content link.
        """
        return pulumi.get(self, "draft_content_link")

    @property
    @pulumi.getter(name="inEdit")
    def in_edit(self) -> Optional[bool]:
        """
        Gets or sets whether runbook is in edit mode.
        """
        return pulumi.get(self, "in_edit")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[str]:
        """
        Gets or sets the last modified time of the runbook draft.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="outputTypes")
    def output_types(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the runbook output types.
        """
        return pulumi.get(self, "output_types")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.RunbookParameterResponse']]:
        """
        Gets or sets the runbook draft parameters.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class RunbookParameterResponse(dict):
    """
    Definition of the runbook parameter type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "isMandatory":
            suggest = "is_mandatory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RunbookParameterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RunbookParameterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RunbookParameterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: Optional[str] = None,
                 is_mandatory: Optional[bool] = None,
                 position: Optional[int] = None,
                 type: Optional[str] = None):
        """
        Definition of the runbook parameter type.
        :param str default_value: Gets or sets the default value of parameter.
        :param bool is_mandatory: Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
        :param int position: Get or sets the position of the parameter.
        :param str type: Gets or sets the type of the parameter.
        """
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if is_mandatory is not None:
            pulumi.set(__self__, "is_mandatory", is_mandatory)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[str]:
        """
        Gets or sets the default value of parameter.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="isMandatory")
    def is_mandatory(self) -> Optional[bool]:
        """
        Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
        """
        return pulumi.get(self, "is_mandatory")

    @property
    @pulumi.getter
    def position(self) -> Optional[int]:
        """
        Get or sets the position of the parameter.
        """
        return pulumi.get(self, "position")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Gets or sets the type of the parameter.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SUCSchedulePropertiesResponse(dict):
    """
    Definition of schedule parameters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTimeOffsetMinutes":
            suggest = "start_time_offset_minutes"
        elif key == "advancedSchedule":
            suggest = "advanced_schedule"
        elif key == "creationTime":
            suggest = "creation_time"
        elif key == "expiryTime":
            suggest = "expiry_time"
        elif key == "expiryTimeOffsetMinutes":
            suggest = "expiry_time_offset_minutes"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "lastModifiedTime":
            suggest = "last_modified_time"
        elif key == "nextRun":
            suggest = "next_run"
        elif key == "nextRunOffsetMinutes":
            suggest = "next_run_offset_minutes"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SUCSchedulePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SUCSchedulePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SUCSchedulePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time_offset_minutes: float,
                 advanced_schedule: Optional['outputs.AdvancedScheduleResponse'] = None,
                 creation_time: Optional[str] = None,
                 description: Optional[str] = None,
                 expiry_time: Optional[str] = None,
                 expiry_time_offset_minutes: Optional[float] = None,
                 frequency: Optional[str] = None,
                 interval: Optional[float] = None,
                 is_enabled: Optional[bool] = None,
                 last_modified_time: Optional[str] = None,
                 next_run: Optional[str] = None,
                 next_run_offset_minutes: Optional[float] = None,
                 start_time: Optional[str] = None,
                 time_zone: Optional[str] = None):
        """
        Definition of schedule parameters.
        :param float start_time_offset_minutes: Gets the start time's offset in minutes.
        :param 'AdvancedScheduleResponse' advanced_schedule: Gets or sets the advanced schedule.
        :param str creation_time: Gets or sets the creation time.
        :param str description: Gets or sets the description.
        :param str expiry_time: Gets or sets the end time of the schedule.
        :param float expiry_time_offset_minutes: Gets or sets the expiry time's offset in minutes.
        :param str frequency: Gets or sets the frequency of the schedule.
        :param float interval: Gets or sets the interval of the schedule.
        :param bool is_enabled: Gets or sets a value indicating whether this schedule is enabled.
        :param str last_modified_time: Gets or sets the last modified time.
        :param str next_run: Gets or sets the next run time of the schedule.
        :param float next_run_offset_minutes: Gets or sets the next run time's offset in minutes.
        :param str start_time: Gets or sets the start time of the schedule.
        :param str time_zone: Gets or sets the time zone of the schedule.
        """
        pulumi.set(__self__, "start_time_offset_minutes", start_time_offset_minutes)
        if advanced_schedule is not None:
            pulumi.set(__self__, "advanced_schedule", advanced_schedule)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expiry_time is not None:
            pulumi.set(__self__, "expiry_time", expiry_time)
        if expiry_time_offset_minutes is not None:
            pulumi.set(__self__, "expiry_time_offset_minutes", expiry_time_offset_minutes)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if is_enabled is None:
            is_enabled = False
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if next_run is not None:
            pulumi.set(__self__, "next_run", next_run)
        if next_run_offset_minutes is not None:
            pulumi.set(__self__, "next_run_offset_minutes", next_run_offset_minutes)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="startTimeOffsetMinutes")
    def start_time_offset_minutes(self) -> float:
        """
        Gets the start time's offset in minutes.
        """
        return pulumi.get(self, "start_time_offset_minutes")

    @property
    @pulumi.getter(name="advancedSchedule")
    def advanced_schedule(self) -> Optional['outputs.AdvancedScheduleResponse']:
        """
        Gets or sets the advanced schedule.
        """
        return pulumi.get(self, "advanced_schedule")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[str]:
        """
        Gets or sets the creation time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Gets or sets the description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> Optional[str]:
        """
        Gets or sets the end time of the schedule.
        """
        return pulumi.get(self, "expiry_time")

    @property
    @pulumi.getter(name="expiryTimeOffsetMinutes")
    def expiry_time_offset_minutes(self) -> Optional[float]:
        """
        Gets or sets the expiry time's offset in minutes.
        """
        return pulumi.get(self, "expiry_time_offset_minutes")

    @property
    @pulumi.getter
    def frequency(self) -> Optional[str]:
        """
        Gets or sets the frequency of the schedule.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def interval(self) -> Optional[float]:
        """
        Gets or sets the interval of the schedule.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Gets or sets a value indicating whether this schedule is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[str]:
        """
        Gets or sets the last modified time.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="nextRun")
    def next_run(self) -> Optional[str]:
        """
        Gets or sets the next run time of the schedule.
        """
        return pulumi.get(self, "next_run")

    @property
    @pulumi.getter(name="nextRunOffsetMinutes")
    def next_run_offset_minutes(self) -> Optional[float]:
        """
        Gets or sets the next run time's offset in minutes.
        """
        return pulumi.get(self, "next_run_offset_minutes")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Gets or sets the start time of the schedule.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        Gets or sets the time zone of the schedule.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class ScheduleAssociationPropertyResponse(dict):
    """
    The schedule property associated with the entity.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        The schedule property associated with the entity.
        :param str name: Gets or sets the name of the Schedule.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the name of the Schedule.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SkuResponse(dict):
    """
    The account SKU.
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None):
        """
        The account SKU.
        :param str name: Gets or sets the SKU name of the account.
        :param int capacity: Gets or sets the SKU capacity.
        :param str family: Gets or sets the SKU family.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Gets or sets the SKU name of the account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Gets or sets the SKU capacity.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        Gets or sets the SKU family.
        """
        return pulumi.get(self, "family")


@pulumi.output_type
class SoftwareUpdateConfigurationTasksResponse(dict):
    """
    Task properties of the software update configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postTask":
            suggest = "post_task"
        elif key == "preTask":
            suggest = "pre_task"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareUpdateConfigurationTasksResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareUpdateConfigurationTasksResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareUpdateConfigurationTasksResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 post_task: Optional['outputs.TaskPropertiesResponse'] = None,
                 pre_task: Optional['outputs.TaskPropertiesResponse'] = None):
        """
        Task properties of the software update configuration.
        :param 'TaskPropertiesResponse' post_task: Post task properties.
        :param 'TaskPropertiesResponse' pre_task: Pre task properties.
        """
        if post_task is not None:
            pulumi.set(__self__, "post_task", post_task)
        if pre_task is not None:
            pulumi.set(__self__, "pre_task", pre_task)

    @property
    @pulumi.getter(name="postTask")
    def post_task(self) -> Optional['outputs.TaskPropertiesResponse']:
        """
        Post task properties.
        """
        return pulumi.get(self, "post_task")

    @property
    @pulumi.getter(name="preTask")
    def pre_task(self) -> Optional['outputs.TaskPropertiesResponse']:
        """
        Pre task properties.
        """
        return pulumi.get(self, "pre_task")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TagSettingsPropertiesResponse(dict):
    """
    Tag filter information for the VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterOperator":
            suggest = "filter_operator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TagSettingsPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TagSettingsPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TagSettingsPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter_operator: Optional[str] = None,
                 tags: Optional[Mapping[str, Sequence[str]]] = None):
        """
        Tag filter information for the VM.
        :param str filter_operator: Filter VMs by Any or All specified tags.
        :param Mapping[str, Sequence[str]] tags: Dictionary of tags with its list of values.
        """
        if filter_operator is not None:
            pulumi.set(__self__, "filter_operator", filter_operator)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="filterOperator")
    def filter_operator(self) -> Optional[str]:
        """
        Filter VMs by Any or All specified tags.
        """
        return pulumi.get(self, "filter_operator")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Sequence[str]]]:
        """
        Dictionary of tags with its list of values.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class TargetPropertiesResponse(dict):
    """
    Group specific to the update configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureQueries":
            suggest = "azure_queries"
        elif key == "nonAzureQueries":
            suggest = "non_azure_queries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_queries: Optional[Sequence['outputs.AzureQueryPropertiesResponse']] = None,
                 non_azure_queries: Optional[Sequence['outputs.NonAzureQueryPropertiesResponse']] = None):
        """
        Group specific to the update configuration.
        :param Sequence['AzureQueryPropertiesResponse'] azure_queries: List of Azure queries in the software update configuration.
        :param Sequence['NonAzureQueryPropertiesResponse'] non_azure_queries: List of non Azure queries in the software update configuration.
        """
        if azure_queries is not None:
            pulumi.set(__self__, "azure_queries", azure_queries)
        if non_azure_queries is not None:
            pulumi.set(__self__, "non_azure_queries", non_azure_queries)

    @property
    @pulumi.getter(name="azureQueries")
    def azure_queries(self) -> Optional[Sequence['outputs.AzureQueryPropertiesResponse']]:
        """
        List of Azure queries in the software update configuration.
        """
        return pulumi.get(self, "azure_queries")

    @property
    @pulumi.getter(name="nonAzureQueries")
    def non_azure_queries(self) -> Optional[Sequence['outputs.NonAzureQueryPropertiesResponse']]:
        """
        List of non Azure queries in the software update configuration.
        """
        return pulumi.get(self, "non_azure_queries")


@pulumi.output_type
class TaskPropertiesResponse(dict):
    """
    Task properties of the software update configuration.
    """
    def __init__(__self__, *,
                 parameters: Optional[Mapping[str, str]] = None,
                 source: Optional[str] = None):
        """
        Task properties of the software update configuration.
        :param Mapping[str, str] parameters: Gets or sets the parameters of the task.
        :param str source: Gets or sets the name of the runbook.
        """
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        """
        Gets or sets the parameters of the task.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        Gets or sets the name of the runbook.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class UpdateConfigurationResponse(dict):
    """
    Update specific properties of the software update configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatingSystem":
            suggest = "operating_system"
        elif key == "azureVirtualMachines":
            suggest = "azure_virtual_machines"
        elif key == "nonAzureComputerNames":
            suggest = "non_azure_computer_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpdateConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpdateConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpdateConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operating_system: str,
                 azure_virtual_machines: Optional[Sequence[str]] = None,
                 duration: Optional[str] = None,
                 linux: Optional['outputs.LinuxPropertiesResponse'] = None,
                 non_azure_computer_names: Optional[Sequence[str]] = None,
                 targets: Optional['outputs.TargetPropertiesResponse'] = None,
                 windows: Optional['outputs.WindowsPropertiesResponse'] = None):
        """
        Update specific properties of the software update configuration.
        :param str operating_system: operating system of target machines
        :param Sequence[str] azure_virtual_machines: List of azure resource Ids for azure virtual machines targeted by the software update configuration.
        :param str duration: Maximum time allowed for the software update configuration run. Duration needs to be specified using the format PT[n]H[n]M[n]S as per ISO8601
        :param 'LinuxPropertiesResponse' linux: Linux specific update configuration.
        :param Sequence[str] non_azure_computer_names: List of names of non-azure machines targeted by the software update configuration.
        :param 'TargetPropertiesResponse' targets: Group targets for the software update configuration.
        :param 'WindowsPropertiesResponse' windows: Windows specific update configuration.
        """
        pulumi.set(__self__, "operating_system", operating_system)
        if azure_virtual_machines is not None:
            pulumi.set(__self__, "azure_virtual_machines", azure_virtual_machines)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if linux is not None:
            pulumi.set(__self__, "linux", linux)
        if non_azure_computer_names is not None:
            pulumi.set(__self__, "non_azure_computer_names", non_azure_computer_names)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if windows is not None:
            pulumi.set(__self__, "windows", windows)

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> str:
        """
        operating system of target machines
        """
        return pulumi.get(self, "operating_system")

    @property
    @pulumi.getter(name="azureVirtualMachines")
    def azure_virtual_machines(self) -> Optional[Sequence[str]]:
        """
        List of azure resource Ids for azure virtual machines targeted by the software update configuration.
        """
        return pulumi.get(self, "azure_virtual_machines")

    @property
    @pulumi.getter
    def duration(self) -> Optional[str]:
        """
        Maximum time allowed for the software update configuration run. Duration needs to be specified using the format PT[n]H[n]M[n]S as per ISO8601
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def linux(self) -> Optional['outputs.LinuxPropertiesResponse']:
        """
        Linux specific update configuration.
        """
        return pulumi.get(self, "linux")

    @property
    @pulumi.getter(name="nonAzureComputerNames")
    def non_azure_computer_names(self) -> Optional[Sequence[str]]:
        """
        List of names of non-azure machines targeted by the software update configuration.
        """
        return pulumi.get(self, "non_azure_computer_names")

    @property
    @pulumi.getter
    def targets(self) -> Optional['outputs.TargetPropertiesResponse']:
        """
        Group targets for the software update configuration.
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter
    def windows(self) -> Optional['outputs.WindowsPropertiesResponse']:
        """
        Windows specific update configuration.
        """
        return pulumi.get(self, "windows")


@pulumi.output_type
class WindowsPropertiesResponse(dict):
    """
    Windows specific update configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedKbNumbers":
            suggest = "excluded_kb_numbers"
        elif key == "includedKbNumbers":
            suggest = "included_kb_numbers"
        elif key == "includedUpdateClassifications":
            suggest = "included_update_classifications"
        elif key == "rebootSetting":
            suggest = "reboot_setting"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excluded_kb_numbers: Optional[Sequence[str]] = None,
                 included_kb_numbers: Optional[Sequence[str]] = None,
                 included_update_classifications: Optional[str] = None,
                 reboot_setting: Optional[str] = None):
        """
        Windows specific update configuration.
        :param Sequence[str] excluded_kb_numbers: KB numbers excluded from the software update configuration.
        :param Sequence[str] included_kb_numbers: KB numbers included from the software update configuration.
        :param str included_update_classifications: Update classification included in the software update configuration. A comma separated string with required values
        :param str reboot_setting: Reboot setting for the software update configuration.
        """
        if excluded_kb_numbers is not None:
            pulumi.set(__self__, "excluded_kb_numbers", excluded_kb_numbers)
        if included_kb_numbers is not None:
            pulumi.set(__self__, "included_kb_numbers", included_kb_numbers)
        if included_update_classifications is not None:
            pulumi.set(__self__, "included_update_classifications", included_update_classifications)
        if reboot_setting is not None:
            pulumi.set(__self__, "reboot_setting", reboot_setting)

    @property
    @pulumi.getter(name="excludedKbNumbers")
    def excluded_kb_numbers(self) -> Optional[Sequence[str]]:
        """
        KB numbers excluded from the software update configuration.
        """
        return pulumi.get(self, "excluded_kb_numbers")

    @property
    @pulumi.getter(name="includedKbNumbers")
    def included_kb_numbers(self) -> Optional[Sequence[str]]:
        """
        KB numbers included from the software update configuration.
        """
        return pulumi.get(self, "included_kb_numbers")

    @property
    @pulumi.getter(name="includedUpdateClassifications")
    def included_update_classifications(self) -> Optional[str]:
        """
        Update classification included in the software update configuration. A comma separated string with required values
        """
        return pulumi.get(self, "included_update_classifications")

    @property
    @pulumi.getter(name="rebootSetting")
    def reboot_setting(self) -> Optional[str]:
        """
        Reboot setting for the software update configuration.
        """
        return pulumi.get(self, "reboot_setting")


