# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AzureBlobDefinitionArgs',
    'BucketDefinitionArgs',
    'ExtensionAksAssignedIdentityArgs',
    'ExtensionStatusArgs',
    'GitRepositoryDefinitionArgs',
    'HelmOperatorPropertiesArgs',
    'IdentityArgs',
    'KustomizationDefinitionArgs',
    'ManagedIdentityDefinitionArgs',
    'PlanArgs',
    'RepositoryRefDefinitionArgs',
    'ScopeClusterArgs',
    'ScopeNamespaceArgs',
    'ScopeArgs',
    'ServicePrincipalDefinitionArgs',
]

@pulumi.input_type
class AzureBlobDefinitionArgs:
    def __init__(__self__, *,
                 account_key: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 local_auth_ref: Optional[pulumi.Input[str]] = None,
                 managed_identity: Optional[pulumi.Input['ManagedIdentityDefinitionArgs']] = None,
                 sas_token: Optional[pulumi.Input[str]] = None,
                 service_principal: Optional[pulumi.Input['ServicePrincipalDefinitionArgs']] = None,
                 sync_interval_in_seconds: Optional[pulumi.Input[float]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[float]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Parameters to reconcile to the AzureBlob source kind type.
        :param pulumi.Input[str] account_key: The account key (shared key) to access the storage account
        :param pulumi.Input[str] container_name: The Azure Blob container name to sync from the url endpoint for the flux configuration.
        :param pulumi.Input[str] local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
        :param pulumi.Input['ManagedIdentityDefinitionArgs'] managed_identity: Parameters to authenticate using a Managed Identity.
        :param pulumi.Input[str] sas_token: The Shared Access token to access the storage container
        :param pulumi.Input['ServicePrincipalDefinitionArgs'] service_principal: Parameters to authenticate using Service Principal.
        :param pulumi.Input[float] sync_interval_in_seconds: The interval at which to re-reconcile the cluster Azure Blob source with the remote.
        :param pulumi.Input[float] timeout_in_seconds: The maximum time to attempt to reconcile the cluster Azure Blob source with the remote.
        :param pulumi.Input[str] url: The URL to sync for the flux configuration Azure Blob storage account.
        """
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if local_auth_ref is not None:
            pulumi.set(__self__, "local_auth_ref", local_auth_ref)
        if managed_identity is not None:
            pulumi.set(__self__, "managed_identity", managed_identity)
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)
        if service_principal is not None:
            pulumi.set(__self__, "service_principal", service_principal)
        if sync_interval_in_seconds is None:
            sync_interval_in_seconds = 600
        if sync_interval_in_seconds is not None:
            pulumi.set(__self__, "sync_interval_in_seconds", sync_interval_in_seconds)
        if timeout_in_seconds is None:
            timeout_in_seconds = 600
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[pulumi.Input[str]]:
        """
        The account key (shared key) to access the storage account
        """
        return pulumi.get(self, "account_key")

    @account_key.setter
    def account_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Blob container name to sync from the url endpoint for the flux configuration.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="localAuthRef")
    def local_auth_ref(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
        """
        return pulumi.get(self, "local_auth_ref")

    @local_auth_ref.setter
    def local_auth_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_auth_ref", value)

    @property
    @pulumi.getter(name="managedIdentity")
    def managed_identity(self) -> Optional[pulumi.Input['ManagedIdentityDefinitionArgs']]:
        """
        Parameters to authenticate using a Managed Identity.
        """
        return pulumi.get(self, "managed_identity")

    @managed_identity.setter
    def managed_identity(self, value: Optional[pulumi.Input['ManagedIdentityDefinitionArgs']]):
        pulumi.set(self, "managed_identity", value)

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional[pulumi.Input[str]]:
        """
        The Shared Access token to access the storage container
        """
        return pulumi.get(self, "sas_token")

    @sas_token.setter
    def sas_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_token", value)

    @property
    @pulumi.getter(name="servicePrincipal")
    def service_principal(self) -> Optional[pulumi.Input['ServicePrincipalDefinitionArgs']]:
        """
        Parameters to authenticate using Service Principal.
        """
        return pulumi.get(self, "service_principal")

    @service_principal.setter
    def service_principal(self, value: Optional[pulumi.Input['ServicePrincipalDefinitionArgs']]):
        pulumi.set(self, "service_principal", value)

    @property
    @pulumi.getter(name="syncIntervalInSeconds")
    def sync_interval_in_seconds(self) -> Optional[pulumi.Input[float]]:
        """
        The interval at which to re-reconcile the cluster Azure Blob source with the remote.
        """
        return pulumi.get(self, "sync_interval_in_seconds")

    @sync_interval_in_seconds.setter
    def sync_interval_in_seconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "sync_interval_in_seconds", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum time to attempt to reconcile the cluster Azure Blob source with the remote.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL to sync for the flux configuration Azure Blob storage account.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class BucketDefinitionArgs:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[str]] = None,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 insecure: Optional[pulumi.Input[bool]] = None,
                 local_auth_ref: Optional[pulumi.Input[str]] = None,
                 sync_interval_in_seconds: Optional[pulumi.Input[float]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[float]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Parameters to reconcile to the Bucket source kind type.
        :param pulumi.Input[str] access_key: Plaintext access key used to securely access the S3 bucket
        :param pulumi.Input[str] bucket_name: The bucket name to sync from the url endpoint for the flux configuration.
        :param pulumi.Input[bool] insecure: Specify whether to use insecure communication when puling data from the S3 bucket.
        :param pulumi.Input[str] local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
        :param pulumi.Input[float] sync_interval_in_seconds: The interval at which to re-reconcile the cluster bucket source with the remote.
        :param pulumi.Input[float] timeout_in_seconds: The maximum time to attempt to reconcile the cluster bucket source with the remote.
        :param pulumi.Input[str] url: The URL to sync for the flux configuration S3 bucket.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if insecure is None:
            insecure = True
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if local_auth_ref is not None:
            pulumi.set(__self__, "local_auth_ref", local_auth_ref)
        if sync_interval_in_seconds is None:
            sync_interval_in_seconds = 600
        if sync_interval_in_seconds is not None:
            pulumi.set(__self__, "sync_interval_in_seconds", sync_interval_in_seconds)
        if timeout_in_seconds is None:
            timeout_in_seconds = 600
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[str]]:
        """
        Plaintext access key used to securely access the S3 bucket
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        The bucket name to sync from the url endpoint for the flux configuration.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def insecure(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether to use insecure communication when puling data from the S3 bucket.
        """
        return pulumi.get(self, "insecure")

    @insecure.setter
    def insecure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insecure", value)

    @property
    @pulumi.getter(name="localAuthRef")
    def local_auth_ref(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
        """
        return pulumi.get(self, "local_auth_ref")

    @local_auth_ref.setter
    def local_auth_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_auth_ref", value)

    @property
    @pulumi.getter(name="syncIntervalInSeconds")
    def sync_interval_in_seconds(self) -> Optional[pulumi.Input[float]]:
        """
        The interval at which to re-reconcile the cluster bucket source with the remote.
        """
        return pulumi.get(self, "sync_interval_in_seconds")

    @sync_interval_in_seconds.setter
    def sync_interval_in_seconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "sync_interval_in_seconds", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum time to attempt to reconcile the cluster bucket source with the remote.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL to sync for the flux configuration S3 bucket.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class ExtensionAksAssignedIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['AKSIdentityType']] = None):
        """
        Identity of the Extension resource in an AKS cluster
        :param pulumi.Input['AKSIdentityType'] type: The identity type.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['AKSIdentityType']]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['AKSIdentityType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ExtensionStatusArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[str]] = None,
                 display_status: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input[Union[str, 'LevelType']]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 time: Optional[pulumi.Input[str]] = None):
        """
        Status from the extension.
        :param pulumi.Input[str] code: Status code provided by the Extension
        :param pulumi.Input[str] display_status: Short description of status of the extension.
        :param pulumi.Input[Union[str, 'LevelType']] level: Level of the status.
        :param pulumi.Input[str] message: Detailed message of the status from the Extension.
        :param pulumi.Input[str] time: DateLiteral (per ISO8601) noting the time of installation status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if display_status is not None:
            pulumi.set(__self__, "display_status", display_status)
        if level is None:
            level = 'Information'
        if level is not None:
            pulumi.set(__self__, "level", level)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        """
        Status code provided by the Extension
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="displayStatus")
    def display_status(self) -> Optional[pulumi.Input[str]]:
        """
        Short description of status of the extension.
        """
        return pulumi.get(self, "display_status")

    @display_status.setter
    def display_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_status", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[Union[str, 'LevelType']]]:
        """
        Level of the status.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[Union[str, 'LevelType']]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Detailed message of the status from the Extension.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[str]]:
        """
        DateLiteral (per ISO8601) noting the time of installation status.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time", value)


@pulumi.input_type
class GitRepositoryDefinitionArgs:
    def __init__(__self__, *,
                 https_ca_cert: Optional[pulumi.Input[str]] = None,
                 https_user: Optional[pulumi.Input[str]] = None,
                 local_auth_ref: Optional[pulumi.Input[str]] = None,
                 repository_ref: Optional[pulumi.Input['RepositoryRefDefinitionArgs']] = None,
                 ssh_known_hosts: Optional[pulumi.Input[str]] = None,
                 sync_interval_in_seconds: Optional[pulumi.Input[float]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[float]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Parameters to reconcile to the GitRepository source kind type.
        :param pulumi.Input[str] https_ca_cert: Base64-encoded HTTPS certificate authority contents used to access git private git repositories over HTTPS
        :param pulumi.Input[str] https_user: Plaintext HTTPS username used to access private git repositories over HTTPS
        :param pulumi.Input[str] local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
        :param pulumi.Input['RepositoryRefDefinitionArgs'] repository_ref: The source reference for the GitRepository object.
        :param pulumi.Input[str] ssh_known_hosts: Base64-encoded known_hosts value containing public SSH keys required to access private git repositories over SSH
        :param pulumi.Input[float] sync_interval_in_seconds: The interval at which to re-reconcile the cluster git repository source with the remote.
        :param pulumi.Input[float] timeout_in_seconds: The maximum time to attempt to reconcile the cluster git repository source with the remote.
        :param pulumi.Input[str] url: The URL to sync for the flux configuration git repository.
        """
        if https_ca_cert is not None:
            pulumi.set(__self__, "https_ca_cert", https_ca_cert)
        if https_user is not None:
            pulumi.set(__self__, "https_user", https_user)
        if local_auth_ref is not None:
            pulumi.set(__self__, "local_auth_ref", local_auth_ref)
        if repository_ref is not None:
            pulumi.set(__self__, "repository_ref", repository_ref)
        if ssh_known_hosts is not None:
            pulumi.set(__self__, "ssh_known_hosts", ssh_known_hosts)
        if sync_interval_in_seconds is None:
            sync_interval_in_seconds = 600
        if sync_interval_in_seconds is not None:
            pulumi.set(__self__, "sync_interval_in_seconds", sync_interval_in_seconds)
        if timeout_in_seconds is None:
            timeout_in_seconds = 600
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="httpsCACert")
    def https_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        Base64-encoded HTTPS certificate authority contents used to access git private git repositories over HTTPS
        """
        return pulumi.get(self, "https_ca_cert")

    @https_ca_cert.setter
    def https_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "https_ca_cert", value)

    @property
    @pulumi.getter(name="httpsUser")
    def https_user(self) -> Optional[pulumi.Input[str]]:
        """
        Plaintext HTTPS username used to access private git repositories over HTTPS
        """
        return pulumi.get(self, "https_user")

    @https_user.setter
    def https_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "https_user", value)

    @property
    @pulumi.getter(name="localAuthRef")
    def local_auth_ref(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
        """
        return pulumi.get(self, "local_auth_ref")

    @local_auth_ref.setter
    def local_auth_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_auth_ref", value)

    @property
    @pulumi.getter(name="repositoryRef")
    def repository_ref(self) -> Optional[pulumi.Input['RepositoryRefDefinitionArgs']]:
        """
        The source reference for the GitRepository object.
        """
        return pulumi.get(self, "repository_ref")

    @repository_ref.setter
    def repository_ref(self, value: Optional[pulumi.Input['RepositoryRefDefinitionArgs']]):
        pulumi.set(self, "repository_ref", value)

    @property
    @pulumi.getter(name="sshKnownHosts")
    def ssh_known_hosts(self) -> Optional[pulumi.Input[str]]:
        """
        Base64-encoded known_hosts value containing public SSH keys required to access private git repositories over SSH
        """
        return pulumi.get(self, "ssh_known_hosts")

    @ssh_known_hosts.setter
    def ssh_known_hosts(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_known_hosts", value)

    @property
    @pulumi.getter(name="syncIntervalInSeconds")
    def sync_interval_in_seconds(self) -> Optional[pulumi.Input[float]]:
        """
        The interval at which to re-reconcile the cluster git repository source with the remote.
        """
        return pulumi.get(self, "sync_interval_in_seconds")

    @sync_interval_in_seconds.setter
    def sync_interval_in_seconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "sync_interval_in_seconds", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum time to attempt to reconcile the cluster git repository source with the remote.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL to sync for the flux configuration git repository.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class HelmOperatorPropertiesArgs:
    def __init__(__self__, *,
                 chart_values: Optional[pulumi.Input[str]] = None,
                 chart_version: Optional[pulumi.Input[str]] = None):
        """
        Properties for Helm operator.
        :param pulumi.Input[str] chart_values: Values override for the operator Helm chart.
        :param pulumi.Input[str] chart_version: Version of the operator Helm chart.
        """
        if chart_values is not None:
            pulumi.set(__self__, "chart_values", chart_values)
        if chart_version is not None:
            pulumi.set(__self__, "chart_version", chart_version)

    @property
    @pulumi.getter(name="chartValues")
    def chart_values(self) -> Optional[pulumi.Input[str]]:
        """
        Values override for the operator Helm chart.
        """
        return pulumi.get(self, "chart_values")

    @chart_values.setter
    def chart_values(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chart_values", value)

    @property
    @pulumi.getter(name="chartVersion")
    def chart_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the operator Helm chart.
        """
        return pulumi.get(self, "chart_version")

    @chart_version.setter
    def chart_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chart_version", value)


@pulumi.input_type
class IdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None):
        """
        Identity for the resource.
        :param pulumi.Input['ResourceIdentityType'] type: The identity type.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class KustomizationDefinitionArgs:
    def __init__(__self__, *,
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 prune: Optional[pulumi.Input[bool]] = None,
                 retry_interval_in_seconds: Optional[pulumi.Input[float]] = None,
                 sync_interval_in_seconds: Optional[pulumi.Input[float]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[float]] = None):
        """
        The Kustomization defining how to reconcile the artifact pulled by the source type on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] depends_on: Specifies other Kustomizations that this Kustomization depends on. This Kustomization will not reconcile until all dependencies have completed their reconciliation.
        :param pulumi.Input[bool] force: Enable/disable re-creating Kubernetes resources on the cluster when patching fails due to an immutable field change.
        :param pulumi.Input[str] path: The path in the source reference to reconcile on the cluster.
        :param pulumi.Input[bool] prune: Enable/disable garbage collections of Kubernetes objects created by this Kustomization.
        :param pulumi.Input[float] retry_interval_in_seconds: The interval at which to re-reconcile the Kustomization on the cluster in the event of failure on reconciliation.
        :param pulumi.Input[float] sync_interval_in_seconds: The interval at which to re-reconcile the Kustomization on the cluster.
        :param pulumi.Input[float] timeout_in_seconds: The maximum time to attempt to reconcile the Kustomization on the cluster.
        """
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if force is None:
            force = False
        if force is not None:
            pulumi.set(__self__, "force", force)
        if path is None:
            path = ''
        if path is not None:
            pulumi.set(__self__, "path", path)
        if prune is None:
            prune = False
        if prune is not None:
            pulumi.set(__self__, "prune", prune)
        if retry_interval_in_seconds is not None:
            pulumi.set(__self__, "retry_interval_in_seconds", retry_interval_in_seconds)
        if sync_interval_in_seconds is None:
            sync_interval_in_seconds = 600
        if sync_interval_in_seconds is not None:
            pulumi.set(__self__, "sync_interval_in_seconds", sync_interval_in_seconds)
        if timeout_in_seconds is None:
            timeout_in_seconds = 600
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies other Kustomizations that this Kustomization depends on. This Kustomization will not reconcile until all dependencies have completed their reconciliation.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable/disable re-creating Kubernetes resources on the cluster when patching fails due to an immutable field change.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path in the source reference to reconcile on the cluster.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def prune(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable/disable garbage collections of Kubernetes objects created by this Kustomization.
        """
        return pulumi.get(self, "prune")

    @prune.setter
    def prune(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prune", value)

    @property
    @pulumi.getter(name="retryIntervalInSeconds")
    def retry_interval_in_seconds(self) -> Optional[pulumi.Input[float]]:
        """
        The interval at which to re-reconcile the Kustomization on the cluster in the event of failure on reconciliation.
        """
        return pulumi.get(self, "retry_interval_in_seconds")

    @retry_interval_in_seconds.setter
    def retry_interval_in_seconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "retry_interval_in_seconds", value)

    @property
    @pulumi.getter(name="syncIntervalInSeconds")
    def sync_interval_in_seconds(self) -> Optional[pulumi.Input[float]]:
        """
        The interval at which to re-reconcile the Kustomization on the cluster.
        """
        return pulumi.get(self, "sync_interval_in_seconds")

    @sync_interval_in_seconds.setter
    def sync_interval_in_seconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "sync_interval_in_seconds", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum time to attempt to reconcile the Kustomization on the cluster.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "timeout_in_seconds", value)


@pulumi.input_type
class ManagedIdentityDefinitionArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None):
        """
        Parameters to authenticate using a Managed Identity.
        :param pulumi.Input[str] client_id: The client Id for authenticating a Managed Identity.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client Id for authenticating a Managed Identity.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)


@pulumi.input_type
class PlanArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 product: pulumi.Input[str],
                 publisher: pulumi.Input[str],
                 promotion_code: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Plan for the resource.
        :param pulumi.Input[str] name: A user defined name of the 3rd Party Artifact that is being procured.
        :param pulumi.Input[str] product: The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding. 
        :param pulumi.Input[str] publisher: The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
        :param pulumi.Input[str] promotion_code: A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
        :param pulumi.Input[str] version: The version of the desired product/artifact.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)
        if promotion_code is not None:
            pulumi.set(__self__, "promotion_code", promotion_code)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A user defined name of the 3rd Party Artifact that is being procured.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def product(self) -> pulumi.Input[str]:
        """
        The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding. 
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: pulumi.Input[str]):
        pulumi.set(self, "product", value)

    @property
    @pulumi.getter
    def publisher(self) -> pulumi.Input[str]:
        """
        The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: pulumi.Input[str]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter(name="promotionCode")
    def promotion_code(self) -> Optional[pulumi.Input[str]]:
        """
        A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
        """
        return pulumi.get(self, "promotion_code")

    @promotion_code.setter
    def promotion_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "promotion_code", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the desired product/artifact.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class RepositoryRefDefinitionArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 commit: Optional[pulumi.Input[str]] = None,
                 semver: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input[str]] = None):
        """
        The source reference for the GitRepository object.
        :param pulumi.Input[str] branch: The git repository branch name to checkout.
        :param pulumi.Input[str] commit: The commit SHA to checkout. This value must be combined with the branch name to be valid. This takes precedence over semver.
        :param pulumi.Input[str] semver: The semver range used to match against git repository tags. This takes precedence over tag.
        :param pulumi.Input[str] tag: The git repository tag name to checkout. This takes precedence over branch.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if commit is not None:
            pulumi.set(__self__, "commit", commit)
        if semver is not None:
            pulumi.set(__self__, "semver", semver)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The git repository branch name to checkout.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter
    def commit(self) -> Optional[pulumi.Input[str]]:
        """
        The commit SHA to checkout. This value must be combined with the branch name to be valid. This takes precedence over semver.
        """
        return pulumi.get(self, "commit")

    @commit.setter
    def commit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit", value)

    @property
    @pulumi.getter
    def semver(self) -> Optional[pulumi.Input[str]]:
        """
        The semver range used to match against git repository tags. This takes precedence over tag.
        """
        return pulumi.get(self, "semver")

    @semver.setter
    def semver(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "semver", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        The git repository tag name to checkout. This takes precedence over branch.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)


@pulumi.input_type
class ScopeClusterArgs:
    def __init__(__self__, *,
                 release_namespace: Optional[pulumi.Input[str]] = None):
        """
        Specifies that the scope of the extension is Cluster
        :param pulumi.Input[str] release_namespace: Namespace where the extension Release must be placed, for a Cluster scoped extension.  If this namespace does not exist, it will be created
        """
        if release_namespace is not None:
            pulumi.set(__self__, "release_namespace", release_namespace)

    @property
    @pulumi.getter(name="releaseNamespace")
    def release_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace where the extension Release must be placed, for a Cluster scoped extension.  If this namespace does not exist, it will be created
        """
        return pulumi.get(self, "release_namespace")

    @release_namespace.setter
    def release_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release_namespace", value)


@pulumi.input_type
class ScopeNamespaceArgs:
    def __init__(__self__, *,
                 target_namespace: Optional[pulumi.Input[str]] = None):
        """
        Specifies that the scope of the extension is Namespace
        :param pulumi.Input[str] target_namespace: Namespace where the extension will be created for an Namespace scoped extension.  If this namespace does not exist, it will be created
        """
        if target_namespace is not None:
            pulumi.set(__self__, "target_namespace", target_namespace)

    @property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace where the extension will be created for an Namespace scoped extension.  If this namespace does not exist, it will be created
        """
        return pulumi.get(self, "target_namespace")

    @target_namespace.setter
    def target_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_namespace", value)


@pulumi.input_type
class ScopeArgs:
    def __init__(__self__, *,
                 cluster: Optional[pulumi.Input['ScopeClusterArgs']] = None,
                 namespace: Optional[pulumi.Input['ScopeNamespaceArgs']] = None):
        """
        Scope of the extension. It can be either Cluster or Namespace; but not both.
        :param pulumi.Input['ScopeClusterArgs'] cluster: Specifies that the scope of the extension is Cluster
        :param pulumi.Input['ScopeNamespaceArgs'] namespace: Specifies that the scope of the extension is Namespace
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input['ScopeClusterArgs']]:
        """
        Specifies that the scope of the extension is Cluster
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input['ScopeClusterArgs']]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input['ScopeNamespaceArgs']]:
        """
        Specifies that the scope of the extension is Namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input['ScopeNamespaceArgs']]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class ServicePrincipalDefinitionArgs:
    def __init__(__self__, *,
                 client_certificate: Optional[pulumi.Input[str]] = None,
                 client_certificate_password: Optional[pulumi.Input[str]] = None,
                 client_certificate_send_chain: Optional[pulumi.Input[bool]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Parameters to authenticate using Service Principal.
        :param pulumi.Input[str] client_certificate: Base64-encoded certificate used to authenticate a Service Principal 
        :param pulumi.Input[str] client_certificate_password: The password for the certificate used to authenticate a Service Principal 
        :param pulumi.Input[bool] client_certificate_send_chain: Specifies whether to include x5c header in client claims when acquiring a token to enable subject name / issuer based authentication for the Client Certificate
        :param pulumi.Input[str] client_id: The client Id for authenticating a Service Principal.
        :param pulumi.Input[str] client_secret: The client secret for authenticating a Service Principal
        :param pulumi.Input[str] tenant_id: The tenant Id for authenticating a Service Principal
        """
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_certificate_password is not None:
            pulumi.set(__self__, "client_certificate_password", client_certificate_password)
        if client_certificate_send_chain is None:
            client_certificate_send_chain = False
        if client_certificate_send_chain is not None:
            pulumi.set(__self__, "client_certificate_send_chain", client_certificate_send_chain)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Base64-encoded certificate used to authenticate a Service Principal 
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientCertificatePassword")
    def client_certificate_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the certificate used to authenticate a Service Principal 
        """
        return pulumi.get(self, "client_certificate_password")

    @client_certificate_password.setter
    def client_certificate_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate_password", value)

    @property
    @pulumi.getter(name="clientCertificateSendChain")
    def client_certificate_send_chain(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to include x5c header in client claims when acquiring a token to enable subject name / issuer based authentication for the Client Certificate
        """
        return pulumi.get(self, "client_certificate_send_chain")

    @client_certificate_send_chain.setter
    def client_certificate_send_chain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "client_certificate_send_chain", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client Id for authenticating a Service Principal.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The client secret for authenticating a Service Principal
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The tenant Id for authenticating a Service Principal
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


