# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ActivityDependencyArgs',
    'ActivityPolicyArgs',
    'AmazonMWSLinkedServiceArgs',
    'AmazonMWSObjectDatasetArgs',
    'AmazonMWSSourceArgs',
    'AmazonRedshiftLinkedServiceArgs',
    'AmazonRedshiftSourceArgs',
    'AmazonS3DatasetArgs',
    'AmazonS3LinkedServiceArgs',
    'AvroFormatArgs',
    'AzureBatchLinkedServiceArgs',
    'AzureBlobDatasetArgs',
    'AzureDataLakeAnalyticsLinkedServiceArgs',
    'AzureDataLakeStoreDatasetArgs',
    'AzureDataLakeStoreLinkedServiceArgs',
    'AzureDataLakeStoreSinkArgs',
    'AzureDataLakeStoreSourceArgs',
    'AzureDatabricksLinkedServiceArgs',
    'AzureKeyVaultLinkedServiceArgs',
    'AzureKeyVaultSecretReferenceArgs',
    'AzureMLBatchExecutionActivityArgs',
    'AzureMLLinkedServiceArgs',
    'AzureMLUpdateResourceActivityArgs',
    'AzureMLWebServiceFileArgs',
    'AzureMySqlLinkedServiceArgs',
    'AzureMySqlSourceArgs',
    'AzureMySqlTableDatasetArgs',
    'AzurePostgreSqlLinkedServiceArgs',
    'AzurePostgreSqlSourceArgs',
    'AzurePostgreSqlTableDatasetArgs',
    'AzureQueueSinkArgs',
    'AzureSearchIndexDatasetArgs',
    'AzureSearchIndexSinkArgs',
    'AzureSearchLinkedServiceArgs',
    'AzureSqlDWLinkedServiceArgs',
    'AzureSqlDWTableDatasetArgs',
    'AzureSqlDatabaseLinkedServiceArgs',
    'AzureSqlTableDatasetArgs',
    'AzureStorageLinkedServiceArgs',
    'AzureTableDatasetArgs',
    'AzureTableSinkArgs',
    'AzureTableSourceArgs',
    'BlobEventsTriggerArgs',
    'BlobSinkArgs',
    'BlobSourceArgs',
    'BlobTriggerArgs',
    'CassandraLinkedServiceArgs',
    'CassandraSourceArgs',
    'CassandraTableDatasetArgs',
    'ConcurLinkedServiceArgs',
    'ConcurObjectDatasetArgs',
    'ConcurSourceArgs',
    'ControlActivityArgs',
    'CopyActivityArgs',
    'CosmosDbLinkedServiceArgs',
    'CouchbaseLinkedServiceArgs',
    'CouchbaseSourceArgs',
    'CouchbaseTableDatasetArgs',
    'CustomActivityReferenceObjectArgs',
    'CustomActivityArgs',
    'CustomDataSourceLinkedServiceArgs',
    'CustomDatasetArgs',
    'DataLakeAnalyticsUSQLActivityArgs',
    'DatabricksNotebookActivityArgs',
    'DatasetBZip2CompressionArgs',
    'DatasetDeflateCompressionArgs',
    'DatasetGZipCompressionArgs',
    'DatasetReferenceArgs',
    'DatasetZipDeflateCompressionArgs',
    'Db2LinkedServiceArgs',
    'DistcpSettingsArgs',
    'DocumentDbCollectionDatasetArgs',
    'DocumentDbCollectionSinkArgs',
    'DocumentDbCollectionSourceArgs',
    'DrillLinkedServiceArgs',
    'DrillSourceArgs',
    'DrillTableDatasetArgs',
    'DynamicsEntityDatasetArgs',
    'DynamicsLinkedServiceArgs',
    'DynamicsSinkArgs',
    'DynamicsSourceArgs',
    'EloquaLinkedServiceArgs',
    'EloquaObjectDatasetArgs',
    'EloquaSourceArgs',
    'EntityReferenceArgs',
    'ExecutePipelineActivityArgs',
    'ExecuteSSISPackageActivityArgs',
    'ExecutionActivityArgs',
    'ExpressionArgs',
    'FactoryIdentityArgs',
    'FactoryVSTSConfigurationArgs',
    'FileServerLinkedServiceArgs',
    'FileShareDatasetArgs',
    'FileSystemSinkArgs',
    'FileSystemSourceArgs',
    'FilterActivityArgs',
    'ForEachActivityArgs',
    'FtpServerLinkedServiceArgs',
    'GetMetadataActivityArgs',
    'GoogleBigQueryLinkedServiceArgs',
    'GoogleBigQueryObjectDatasetArgs',
    'GoogleBigQuerySourceArgs',
    'GreenplumLinkedServiceArgs',
    'GreenplumSourceArgs',
    'GreenplumTableDatasetArgs',
    'HBaseLinkedServiceArgs',
    'HBaseObjectDatasetArgs',
    'HBaseSourceArgs',
    'HDInsightHiveActivityArgs',
    'HDInsightLinkedServiceArgs',
    'HDInsightMapReduceActivityArgs',
    'HDInsightOnDemandLinkedServiceArgs',
    'HDInsightPigActivityArgs',
    'HDInsightSparkActivityArgs',
    'HDInsightStreamingActivityArgs',
    'HdfsLinkedServiceArgs',
    'HdfsSourceArgs',
    'HiveLinkedServiceArgs',
    'HiveObjectDatasetArgs',
    'HiveSourceArgs',
    'HttpDatasetArgs',
    'HttpLinkedServiceArgs',
    'HttpSourceArgs',
    'HubspotLinkedServiceArgs',
    'HubspotObjectDatasetArgs',
    'HubspotSourceArgs',
    'IfConditionActivityArgs',
    'ImpalaLinkedServiceArgs',
    'ImpalaObjectDatasetArgs',
    'ImpalaSourceArgs',
    'IntegrationRuntimeComputePropertiesArgs',
    'IntegrationRuntimeCustomSetupScriptPropertiesArgs',
    'IntegrationRuntimeDataProxyPropertiesArgs',
    'IntegrationRuntimeReferenceArgs',
    'IntegrationRuntimeSsisCatalogInfoArgs',
    'IntegrationRuntimeSsisPropertiesArgs',
    'IntegrationRuntimeVNetPropertiesArgs',
    'JiraLinkedServiceArgs',
    'JiraObjectDatasetArgs',
    'JiraSourceArgs',
    'JsonFormatArgs',
    'LinkedIntegrationRuntimeKeyArgs',
    'LinkedIntegrationRuntimeRbacArgs',
    'LinkedServiceReferenceArgs',
    'LookupActivityArgs',
    'MagentoLinkedServiceArgs',
    'MagentoObjectDatasetArgs',
    'MagentoSourceArgs',
    'ManagedIntegrationRuntimeArgs',
    'MariaDBLinkedServiceArgs',
    'MariaDBSourceArgs',
    'MariaDBTableDatasetArgs',
    'MarketoLinkedServiceArgs',
    'MarketoObjectDatasetArgs',
    'MarketoSourceArgs',
    'MongoDbCollectionDatasetArgs',
    'MongoDbLinkedServiceArgs',
    'MongoDbSourceArgs',
    'MultiplePipelineTriggerArgs',
    'MySqlLinkedServiceArgs',
    'NetezzaLinkedServiceArgs',
    'NetezzaSourceArgs',
    'NetezzaTableDatasetArgs',
    'ODataLinkedServiceArgs',
    'ODataResourceDatasetArgs',
    'OdbcLinkedServiceArgs',
    'OdbcSinkArgs',
    'OracleLinkedServiceArgs',
    'OracleSinkArgs',
    'OracleSourceArgs',
    'OracleTableDatasetArgs',
    'OrcFormatArgs',
    'ParameterSpecificationArgs',
    'ParquetFormatArgs',
    'PaypalLinkedServiceArgs',
    'PaypalObjectDatasetArgs',
    'PaypalSourceArgs',
    'PhoenixLinkedServiceArgs',
    'PhoenixObjectDatasetArgs',
    'PhoenixSourceArgs',
    'PipelineReferenceArgs',
    'PolybaseSettingsArgs',
    'PostgreSqlLinkedServiceArgs',
    'PrestoLinkedServiceArgs',
    'PrestoObjectDatasetArgs',
    'PrestoSourceArgs',
    'QuickBooksLinkedServiceArgs',
    'QuickBooksObjectDatasetArgs',
    'QuickBooksSourceArgs',
    'RecurrenceScheduleOccurrenceArgs',
    'RecurrenceScheduleArgs',
    'RedirectIncompatibleRowSettingsArgs',
    'RedshiftUnloadSettingsArgs',
    'RelationalSourceArgs',
    'RelationalTableDatasetArgs',
    'ResponsysLinkedServiceArgs',
    'ResponsysObjectDatasetArgs',
    'ResponsysSourceArgs',
    'RetryPolicyArgs',
    'SSISAccessCredentialArgs',
    'SSISExecutionCredentialArgs',
    'SSISExecutionParameterArgs',
    'SSISLogLocationArgs',
    'SSISPackageLocationArgs',
    'SSISPropertyOverrideArgs',
    'SalesforceLinkedServiceArgs',
    'SalesforceMarketingCloudLinkedServiceArgs',
    'SalesforceMarketingCloudObjectDatasetArgs',
    'SalesforceMarketingCloudSourceArgs',
    'SalesforceObjectDatasetArgs',
    'SalesforceSinkArgs',
    'SalesforceSourceArgs',
    'SapBWLinkedServiceArgs',
    'SapCloudForCustomerLinkedServiceArgs',
    'SapCloudForCustomerResourceDatasetArgs',
    'SapCloudForCustomerSinkArgs',
    'SapCloudForCustomerSourceArgs',
    'SapEccLinkedServiceArgs',
    'SapEccResourceDatasetArgs',
    'SapEccSourceArgs',
    'SapHanaLinkedServiceArgs',
    'ScheduleTriggerRecurrenceArgs',
    'ScheduleTriggerArgs',
    'SecureStringArgs',
    'SelfHostedIntegrationRuntimeArgs',
    'ServiceNowLinkedServiceArgs',
    'ServiceNowObjectDatasetArgs',
    'ServiceNowSourceArgs',
    'SftpServerLinkedServiceArgs',
    'ShopifyLinkedServiceArgs',
    'ShopifyObjectDatasetArgs',
    'ShopifySourceArgs',
    'SparkLinkedServiceArgs',
    'SparkObjectDatasetArgs',
    'SparkSourceArgs',
    'SqlDWSinkArgs',
    'SqlDWSourceArgs',
    'SqlServerLinkedServiceArgs',
    'SqlServerStoredProcedureActivityArgs',
    'SqlServerTableDatasetArgs',
    'SqlSinkArgs',
    'SqlSourceArgs',
    'SquareLinkedServiceArgs',
    'SquareObjectDatasetArgs',
    'SquareSourceArgs',
    'StagingSettingsArgs',
    'StoredProcedureParameterArgs',
    'SybaseLinkedServiceArgs',
    'TeradataLinkedServiceArgs',
    'TextFormatArgs',
    'TriggerPipelineReferenceArgs',
    'TumblingWindowTriggerArgs',
    'UntilActivityArgs',
    'VerticaLinkedServiceArgs',
    'VerticaSourceArgs',
    'VerticaTableDatasetArgs',
    'WaitActivityArgs',
    'WebActivityAuthenticationArgs',
    'WebActivityArgs',
    'WebAnonymousAuthenticationArgs',
    'WebBasicAuthenticationArgs',
    'WebClientCertificateAuthenticationArgs',
    'WebLinkedServiceArgs',
    'WebSourceArgs',
    'WebTableDatasetArgs',
    'XeroLinkedServiceArgs',
    'XeroObjectDatasetArgs',
    'XeroSourceArgs',
    'ZohoLinkedServiceArgs',
    'ZohoObjectDatasetArgs',
    'ZohoSourceArgs',
]

@pulumi.input_type
class ActivityDependencyArgs:
    def __init__(__self__, *,
                 activity: pulumi.Input[str],
                 dependency_conditions: pulumi.Input[Sequence[pulumi.Input[Union[str, 'DependencyCondition']]]]):
        """
        Activity dependency information.
        :param pulumi.Input[str] activity: Activity name.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'DependencyCondition']]]] dependency_conditions: Match-Condition for the dependency.
        """
        pulumi.set(__self__, "activity", activity)
        pulumi.set(__self__, "dependency_conditions", dependency_conditions)

    @property
    @pulumi.getter
    def activity(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "activity")

    @activity.setter
    def activity(self, value: pulumi.Input[str]):
        pulumi.set(self, "activity", value)

    @property
    @pulumi.getter(name="dependencyConditions")
    def dependency_conditions(self) -> pulumi.Input[Sequence[pulumi.Input[Union[str, 'DependencyCondition']]]]:
        """
        Match-Condition for the dependency.
        """
        return pulumi.get(self, "dependency_conditions")

    @dependency_conditions.setter
    def dependency_conditions(self, value: pulumi.Input[Sequence[pulumi.Input[Union[str, 'DependencyCondition']]]]):
        pulumi.set(self, "dependency_conditions", value)


@pulumi.input_type
class ActivityPolicyArgs:
    def __init__(__self__, *,
                 retry: Optional[Any] = None,
                 retry_interval_in_seconds: Optional[pulumi.Input[int]] = None,
                 secure_output: Optional[pulumi.Input[bool]] = None,
                 timeout: Optional[Any] = None):
        """
        Execution policy for an activity.
        :param Any retry: Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
        :param pulumi.Input[int] retry_interval_in_seconds: Interval between each retry attempt (in seconds). The default is 30 sec.
        :param pulumi.Input[bool] secure_output: When set to true, Output from activity is considered as secure and will not be logged to monitoring.
        :param Any timeout: Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if retry_interval_in_seconds is not None:
            pulumi.set(__self__, "retry_interval_in_seconds", retry_interval_in_seconds)
        if secure_output is not None:
            pulumi.set(__self__, "secure_output", secure_output)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def retry(self) -> Optional[Any]:
        """
        Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "retry")

    @retry.setter
    def retry(self, value: Optional[Any]):
        pulumi.set(self, "retry", value)

    @property
    @pulumi.getter(name="retryIntervalInSeconds")
    def retry_interval_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Interval between each retry attempt (in seconds). The default is 30 sec.
        """
        return pulumi.get(self, "retry_interval_in_seconds")

    @retry_interval_in_seconds.setter
    def retry_interval_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retry_interval_in_seconds", value)

    @property
    @pulumi.getter(name="secureOutput")
    def secure_output(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true, Output from activity is considered as secure and will not be logged to monitoring.
        """
        return pulumi.get(self, "secure_output")

    @secure_output.setter
    def secure_output(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "secure_output", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[Any]:
        """
        Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[Any]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class AmazonMWSLinkedServiceArgs:
    def __init__(__self__, *,
                 access_key_id: Any,
                 endpoint: Any,
                 marketplace_id: Any,
                 seller_id: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 mws_auth_token: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 secret_key: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Amazon Marketplace Web Service linked service.
        :param Any access_key_id: The access key id used to access data.
        :param Any endpoint: The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com)
        :param Any marketplace_id: The Amazon Marketplace ID you want to retrieve data from. To retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e. A2EUQ1WTGCTBG2)
        :param Any seller_id: The Amazon seller ID.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'AmazonMWS'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] mws_auth_token: The Amazon MWS authentication token.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] secret_key: The secret key used to access data.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "marketplace_id", marketplace_id)
        pulumi.set(__self__, "seller_id", seller_id)
        pulumi.set(__self__, "type", 'AmazonMWS')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if mws_auth_token is not None:
            pulumi.set(__self__, "mws_auth_token", mws_auth_token)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Any:
        """
        The access key id used to access data.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Any):
        pulumi.set(self, "access_key_id", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Any:
        """
        The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com)
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Any):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="marketplaceID")
    def marketplace_id(self) -> Any:
        """
        The Amazon Marketplace ID you want to retrieve data from. To retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e. A2EUQ1WTGCTBG2)
        """
        return pulumi.get(self, "marketplace_id")

    @marketplace_id.setter
    def marketplace_id(self, value: Any):
        pulumi.set(self, "marketplace_id", value)

    @property
    @pulumi.getter(name="sellerID")
    def seller_id(self) -> Any:
        """
        The Amazon seller ID.
        """
        return pulumi.get(self, "seller_id")

    @seller_id.setter
    def seller_id(self, value: Any):
        pulumi.set(self, "seller_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'AmazonMWS'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter(name="mwsAuthToken")
    def mws_auth_token(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The Amazon MWS authentication token.
        """
        return pulumi.get(self, "mws_auth_token")

    @mws_auth_token.setter
    def mws_auth_token(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "mws_auth_token", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The secret key used to access data.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @use_encrypted_endpoints.setter
    def use_encrypted_endpoints(self, value: Optional[Any]):
        pulumi.set(self, "use_encrypted_endpoints", value)

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_host_verification")

    @use_host_verification.setter
    def use_host_verification(self, value: Optional[Any]):
        pulumi.set(self, "use_host_verification", value)

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_peer_verification")

    @use_peer_verification.setter
    def use_peer_verification(self, value: Optional[Any]):
        pulumi.set(self, "use_peer_verification", value)


@pulumi.input_type
class AmazonMWSObjectDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Amazon Marketplace Web Service dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'AmazonMWSObject'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'AmazonMWSObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'AmazonMWSObject'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class AmazonMWSSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Amazon Marketplace Web Service source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'AmazonMWSSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AmazonMWSSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'AmazonMWSSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class AmazonRedshiftLinkedServiceArgs:
    def __init__(__self__, *,
                 database: Any,
                 server: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 port: Optional[Any] = None,
                 username: Optional[Any] = None):
        """
        Linked service for Amazon Redshift.
        :param Any database: The database name of the Amazon Redshift source. Type: string (or Expression with resultType string).
        :param Any server: The name of the Amazon Redshift server. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'AmazonRedshift'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: The password of the Amazon Redshift source.
        :param Any port: The TCP port number that the Amazon Redshift server uses to listen for client connections. The default value is 5439. Type: integer (or Expression with resultType integer).
        :param Any username: The username of the Amazon Redshift source. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "type", 'AmazonRedshift')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def database(self) -> Any:
        """
        The database name of the Amazon Redshift source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Any):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def server(self) -> Any:
        """
        The name of the Amazon Redshift server. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Any):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'AmazonRedshift'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The password of the Amazon Redshift source.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port number that the Amazon Redshift server uses to listen for client connections. The default value is 5439. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[Any]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        The username of the Amazon Redshift source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[Any]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class AmazonRedshiftSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 redshift_unload_settings: Optional[pulumi.Input['RedshiftUnloadSettingsArgs']] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity source for Amazon Redshift Source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'AmazonRedshiftSource'.
        :param Any query: Database query. Type: string (or Expression with resultType string).
        :param pulumi.Input['RedshiftUnloadSettingsArgs'] redshift_unload_settings: The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AmazonRedshiftSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if redshift_unload_settings is not None:
            pulumi.set(__self__, "redshift_unload_settings", redshift_unload_settings)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'AmazonRedshiftSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        Database query. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="redshiftUnloadSettings")
    def redshift_unload_settings(self) -> Optional[pulumi.Input['RedshiftUnloadSettingsArgs']]:
        """
        The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
        """
        return pulumi.get(self, "redshift_unload_settings")

    @redshift_unload_settings.setter
    def redshift_unload_settings(self, value: Optional[pulumi.Input['RedshiftUnloadSettingsArgs']]):
        pulumi.set(self, "redshift_unload_settings", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class AmazonS3DatasetArgs:
    def __init__(__self__, *,
                 bucket_name: Any,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 compression: Optional[pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']]] = None,
                 key: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 prefix: Optional[Any] = None,
                 structure: Optional[Any] = None,
                 version: Optional[Any] = None):
        """
        A single Amazon Simple Storage Service (S3) object or a set of S3 objects.
        :param Any bucket_name: The name of the Amazon S3 bucket. Type: string (or Expression with resultType string).
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'AmazonS3Object'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']] compression: The data compression method used for the Amazon S3 object.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']] format: The format of files.
        :param Any key: The key of the Amazon S3 object. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any prefix: The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        :param Any version: The version for the S3 object. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'AmazonS3Object')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Any:
        """
        The name of the Amazon S3 bucket. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Any):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'AmazonS3Object'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']]]:
        """
        The data compression method used for the Amazon S3 object.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']]]:
        """
        The format of files.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[Any]:
        """
        The key of the Amazon S3 object. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[Any]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[Any]:
        """
        The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[Any]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[Any]:
        """
        The version for the S3 object. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[Any]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class AmazonS3LinkedServiceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 access_key_id: Optional[Any] = None,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 secret_access_key: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None):
        """
        Linked service for Amazon S3.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'AmazonS3'.
        :param Any access_key_id: The access key identifier of the Amazon S3 Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] secret_access_key: The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
        """
        pulumi.set(__self__, "type", 'AmazonS3')
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'AmazonS3'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[Any]:
        """
        The access key identifier of the Amazon S3 Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[Any]):
        pulumi.set(self, "access_key_id", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "secret_access_key", value)


@pulumi.input_type
class AvroFormatArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 deserializer: Optional[Any] = None,
                 serializer: Optional[Any] = None):
        """
        The data stored in Avro format.
        :param pulumi.Input[str] type: Type of dataset storage format.
               Expected value is 'AvroFormat'.
        :param Any deserializer: Deserializer. Type: string (or Expression with resultType string).
        :param Any serializer: Serializer. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "type", 'AvroFormat')
        if deserializer is not None:
            pulumi.set(__self__, "deserializer", deserializer)
        if serializer is not None:
            pulumi.set(__self__, "serializer", serializer)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset storage format.
        Expected value is 'AvroFormat'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def deserializer(self) -> Optional[Any]:
        """
        Deserializer. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "deserializer")

    @deserializer.setter
    def deserializer(self, value: Optional[Any]):
        pulumi.set(self, "deserializer", value)

    @property
    @pulumi.getter
    def serializer(self) -> Optional[Any]:
        """
        Serializer. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "serializer")

    @serializer.setter
    def serializer(self, value: Optional[Any]):
        pulumi.set(self, "serializer", value)


@pulumi.input_type
class AzureBatchLinkedServiceArgs:
    def __init__(__self__, *,
                 account_name: Any,
                 batch_uri: Any,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 pool_name: Any,
                 type: pulumi.Input[str],
                 access_key: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None):
        """
        Azure Batch linked service.
        :param Any account_name: The Azure Batch account name. Type: string (or Expression with resultType string).
        :param Any batch_uri: The Azure Batch URI. Type: string (or Expression with resultType string).
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: The Azure Storage linked service reference.
        :param Any pool_name: The Azure Batch pool name. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'AzureBatch'.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] access_key: The Azure Batch account access key.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "batch_uri", batch_uri)
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "pool_name", pool_name)
        pulumi.set(__self__, "type", 'AzureBatch')
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Any:
        """
        The Azure Batch account name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Any):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="batchUri")
    def batch_uri(self) -> Any:
        """
        The Azure Batch URI. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "batch_uri")

    @batch_uri.setter
    def batch_uri(self, value: Any):
        pulumi.set(self, "batch_uri", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        The Azure Storage linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> Any:
        """
        The Azure Batch pool name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "pool_name")

    @pool_name.setter
    def pool_name(self, value: Any):
        pulumi.set(self, "pool_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'AzureBatch'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The Azure Batch account access key.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class AzureBlobDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 compression: Optional[pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 file_name: Optional[Any] = None,
                 folder_path: Optional[Any] = None,
                 format: Optional[pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None,
                 table_root_location: Optional[Any] = None):
        """
        The Azure Blob storage.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'AzureBlob'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']] compression: The data compression method used for the blob storage.
        :param pulumi.Input[str] description: Dataset description.
        :param Any file_name: The name of the Azure Blob. Type: string (or Expression with resultType string).
        :param Any folder_path: The path of the Azure Blob storage. Type: string (or Expression with resultType string).
        :param pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']] format: The format of the Azure Blob storage.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        :param Any table_root_location: The root of blob path. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'AzureBlob')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if folder_path is not None:
            pulumi.set(__self__, "folder_path", folder_path)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)
        if table_root_location is not None:
            pulumi.set(__self__, "table_root_location", table_root_location)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'AzureBlob'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']]]:
        """
        The data compression method used for the blob storage.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[Any]:
        """
        The name of the Azure Blob. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: Optional[Any]):
        pulumi.set(self, "file_name", value)

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> Optional[Any]:
        """
        The path of the Azure Blob storage. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "folder_path")

    @folder_path.setter
    def folder_path(self, value: Optional[Any]):
        pulumi.set(self, "folder_path", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']]]:
        """
        The format of the Azure Blob storage.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)

    @property
    @pulumi.getter(name="tableRootLocation")
    def table_root_location(self) -> Optional[Any]:
        """
        The root of blob path. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "table_root_location")

    @table_root_location.setter
    def table_root_location(self, value: Optional[Any]):
        pulumi.set(self, "table_root_location", value)


@pulumi.input_type
class AzureDataLakeAnalyticsLinkedServiceArgs:
    def __init__(__self__, *,
                 account_name: Any,
                 tenant: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 data_lake_analytics_uri: Optional[Any] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 resource_group_name: Optional[Any] = None,
                 service_principal_id: Optional[Any] = None,
                 service_principal_key: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 subscription_id: Optional[Any] = None):
        """
        Azure Data Lake Analytics linked service.
        :param Any account_name: The Azure Data Lake Analytics account name. Type: string (or Expression with resultType string).
        :param Any tenant: The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'AzureDataLakeAnalytics'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param Any data_lake_analytics_uri: Azure Data Lake Analytics URI Type: string (or Expression with resultType string).
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param Any resource_group_name: Data Lake Analytics account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
        :param Any service_principal_id: The ID of the application used to authenticate against the Azure Data Lake Analytics account. Type: string (or Expression with resultType string).
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] service_principal_key: The Key of the application used to authenticate against the Azure Data Lake Analytics account.
        :param Any subscription_id: Data Lake Analytics account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "tenant", tenant)
        pulumi.set(__self__, "type", 'AzureDataLakeAnalytics')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if data_lake_analytics_uri is not None:
            pulumi.set(__self__, "data_lake_analytics_uri", data_lake_analytics_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Any:
        """
        The Azure Data Lake Analytics account name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Any):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter
    def tenant(self) -> Any:
        """
        The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Any):
        pulumi.set(self, "tenant", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'AzureDataLakeAnalytics'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter(name="dataLakeAnalyticsUri")
    def data_lake_analytics_uri(self) -> Optional[Any]:
        """
        Azure Data Lake Analytics URI Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "data_lake_analytics_uri")

    @data_lake_analytics_uri.setter
    def data_lake_analytics_uri(self, value: Optional[Any]):
        pulumi.set(self, "data_lake_analytics_uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[Any]:
        """
        Data Lake Analytics account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[Any]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[Any]:
        """
        The ID of the application used to authenticate against the Azure Data Lake Analytics account. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[Any]):
        pulumi.set(self, "service_principal_id", value)

    @property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The Key of the application used to authenticate against the Azure Data Lake Analytics account.
        """
        return pulumi.get(self, "service_principal_key")

    @service_principal_key.setter
    def service_principal_key(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "service_principal_key", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[Any]:
        """
        Data Lake Analytics account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[Any]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class AzureDataLakeStoreDatasetArgs:
    def __init__(__self__, *,
                 folder_path: Any,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 compression: Optional[pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 file_name: Optional[Any] = None,
                 format: Optional[pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Azure Data Lake Store dataset.
        :param Any folder_path: Path to the folder in the Azure Data Lake Store. Type: string (or Expression with resultType string).
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'AzureDataLakeStoreFile'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']] compression: The data compression method used for the item(s) in the Azure Data Lake Store.
        :param pulumi.Input[str] description: Dataset description.
        :param Any file_name: The name of the file in the Azure Data Lake Store. Type: string (or Expression with resultType string).
        :param pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']] format: The format of the Data Lake Store.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "folder_path", folder_path)
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'AzureDataLakeStoreFile')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> Any:
        """
        Path to the folder in the Azure Data Lake Store. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "folder_path")

    @folder_path.setter
    def folder_path(self, value: Any):
        pulumi.set(self, "folder_path", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'AzureDataLakeStoreFile'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']]]:
        """
        The data compression method used for the item(s) in the Azure Data Lake Store.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[Any]:
        """
        The name of the file in the Azure Data Lake Store. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: Optional[Any]):
        pulumi.set(self, "file_name", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']]]:
        """
        The format of the Data Lake Store.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class AzureDataLakeStoreLinkedServiceArgs:
    def __init__(__self__, *,
                 data_lake_store_uri: Any,
                 type: pulumi.Input[str],
                 account_name: Optional[Any] = None,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 resource_group_name: Optional[Any] = None,
                 service_principal_id: Optional[Any] = None,
                 service_principal_key: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 subscription_id: Optional[Any] = None,
                 tenant: Optional[Any] = None):
        """
        Azure Data Lake Store linked service.
        :param Any data_lake_store_uri: Data Lake Store service URI. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'AzureDataLakeStore'.
        :param Any account_name: Data Lake Store account name. Type: string (or Expression with resultType string).
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param Any resource_group_name: Data Lake Store account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
        :param Any service_principal_id: The ID of the application used to authenticate against the Azure Data Lake Store account. Type: string (or Expression with resultType string).
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] service_principal_key: The Key of the application used to authenticate against the Azure Data Lake Store account.
        :param Any subscription_id: Data Lake Store account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
        :param Any tenant: The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "data_lake_store_uri", data_lake_store_uri)
        pulumi.set(__self__, "type", 'AzureDataLakeStore')
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)

    @property
    @pulumi.getter(name="dataLakeStoreUri")
    def data_lake_store_uri(self) -> Any:
        """
        Data Lake Store service URI. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "data_lake_store_uri")

    @data_lake_store_uri.setter
    def data_lake_store_uri(self, value: Any):
        pulumi.set(self, "data_lake_store_uri", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'AzureDataLakeStore'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[Any]:
        """
        Data Lake Store account name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[Any]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[Any]:
        """
        Data Lake Store account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[Any]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[Any]:
        """
        The ID of the application used to authenticate against the Azure Data Lake Store account. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[Any]):
        pulumi.set(self, "service_principal_id", value)

    @property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The Key of the application used to authenticate against the Azure Data Lake Store account.
        """
        return pulumi.get(self, "service_principal_key")

    @service_principal_key.setter
    def service_principal_key(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "service_principal_key", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[Any]:
        """
        Data Lake Store account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[Any]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter
    def tenant(self) -> Optional[Any]:
        """
        The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[Any]):
        pulumi.set(self, "tenant", value)


@pulumi.input_type
class AzureDataLakeStoreSinkArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 copy_behavior: Optional[Any] = None,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity Azure Data Lake Store sink.
        :param pulumi.Input[str] type: Copy sink type.
               Expected value is 'AzureDataLakeStoreSink'.
        :param Any copy_behavior: The type of copy behavior for copy sink.
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AzureDataLakeStoreSink')
        if copy_behavior is not None:
            pulumi.set(__self__, "copy_behavior", copy_behavior)
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy sink type.
        Expected value is 'AzureDataLakeStoreSink'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="copyBehavior")
    def copy_behavior(self) -> Optional[Any]:
        """
        The type of copy behavior for copy sink.
        """
        return pulumi.get(self, "copy_behavior")

    @copy_behavior.setter
    def copy_behavior(self, value: Optional[Any]):
        pulumi.set(self, "copy_behavior", value)

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @sink_retry_count.setter
    def sink_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_count", value)

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @sink_retry_wait.setter
    def sink_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_wait", value)

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @write_batch_size.setter
    def write_batch_size(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_size", value)

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")

    @write_batch_timeout.setter
    def write_batch_timeout(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_timeout", value)


@pulumi.input_type
class AzureDataLakeStoreSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 recursive: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Azure Data Lake source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'AzureDataLakeStoreSource'.
        :param Any recursive: If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AzureDataLakeStoreSource')
        if recursive is not None:
            pulumi.set(__self__, "recursive", recursive)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'AzureDataLakeStoreSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def recursive(self) -> Optional[Any]:
        """
        If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "recursive")

    @recursive.setter
    def recursive(self, value: Optional[Any]):
        pulumi.set(self, "recursive", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class AzureDatabricksLinkedServiceArgs:
    def __init__(__self__, *,
                 access_token: pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']],
                 domain: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 existing_cluster_id: Optional[Any] = None,
                 new_cluster_node_type: Optional[Any] = None,
                 new_cluster_num_of_worker: Optional[Any] = None,
                 new_cluster_spark_conf: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 new_cluster_version: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None):
        """
        Azure Databricks linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] access_token: Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression with resultType string).
        :param Any domain: <REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'AzureDatabricks'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Any existing_cluster_id: The id of an existing cluster that will be used for all runs of this job. Type: string (or Expression with resultType string).
        :param Any new_cluster_node_type: The node types of new cluster. Type: string (or Expression with resultType string).
        :param Any new_cluster_num_of_worker: Number of worker nodes that new cluster should have. A string formatted Int32, like '1' means numOfWorker is 1 or '1:10' means auto-scale from 1 as min and 10 as max. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, Any]] new_cluster_spark_conf: a set of optional, user-specified Spark configuration key-value pairs.
        :param Any new_cluster_version: The Spark version of new cluster. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "access_token", access_token)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "type", 'AzureDatabricks')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if existing_cluster_id is not None:
            pulumi.set(__self__, "existing_cluster_id", existing_cluster_id)
        if new_cluster_node_type is not None:
            pulumi.set(__self__, "new_cluster_node_type", new_cluster_node_type)
        if new_cluster_num_of_worker is not None:
            pulumi.set(__self__, "new_cluster_num_of_worker", new_cluster_num_of_worker)
        if new_cluster_spark_conf is not None:
            pulumi.set(__self__, "new_cluster_spark_conf", new_cluster_spark_conf)
        if new_cluster_version is not None:
            pulumi.set(__self__, "new_cluster_version", new_cluster_version)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]:
        """
        Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter
    def domain(self) -> Any:
        """
        <REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Any):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'AzureDatabricks'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter(name="existingClusterId")
    def existing_cluster_id(self) -> Optional[Any]:
        """
        The id of an existing cluster that will be used for all runs of this job. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "existing_cluster_id")

    @existing_cluster_id.setter
    def existing_cluster_id(self, value: Optional[Any]):
        pulumi.set(self, "existing_cluster_id", value)

    @property
    @pulumi.getter(name="newClusterNodeType")
    def new_cluster_node_type(self) -> Optional[Any]:
        """
        The node types of new cluster. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "new_cluster_node_type")

    @new_cluster_node_type.setter
    def new_cluster_node_type(self, value: Optional[Any]):
        pulumi.set(self, "new_cluster_node_type", value)

    @property
    @pulumi.getter(name="newClusterNumOfWorker")
    def new_cluster_num_of_worker(self) -> Optional[Any]:
        """
        Number of worker nodes that new cluster should have. A string formatted Int32, like '1' means numOfWorker is 1 or '1:10' means auto-scale from 1 as min and 10 as max. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "new_cluster_num_of_worker")

    @new_cluster_num_of_worker.setter
    def new_cluster_num_of_worker(self, value: Optional[Any]):
        pulumi.set(self, "new_cluster_num_of_worker", value)

    @property
    @pulumi.getter(name="newClusterSparkConf")
    def new_cluster_spark_conf(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        a set of optional, user-specified Spark configuration key-value pairs.
        """
        return pulumi.get(self, "new_cluster_spark_conf")

    @new_cluster_spark_conf.setter
    def new_cluster_spark_conf(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "new_cluster_spark_conf", value)

    @property
    @pulumi.getter(name="newClusterVersion")
    def new_cluster_version(self) -> Optional[Any]:
        """
        The Spark version of new cluster. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "new_cluster_version")

    @new_cluster_version.setter
    def new_cluster_version(self, value: Optional[Any]):
        pulumi.set(self, "new_cluster_version", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class AzureKeyVaultLinkedServiceArgs:
    def __init__(__self__, *,
                 base_url: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None):
        """
        Azure Key Vault linked service.
        :param Any base_url: The base URL of the Azure Key Vault. e.g. https://myakv.vault.azure.net Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'AzureKeyVault'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "type", 'AzureKeyVault')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Any:
        """
        The base URL of the Azure Key Vault. e.g. https://myakv.vault.azure.net Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Any):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'AzureKeyVault'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class AzureKeyVaultSecretReferenceArgs:
    def __init__(__self__, *,
                 secret_name: Any,
                 store: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 secret_version: Optional[Any] = None):
        """
        Azure Key Vault secret reference.
        :param Any secret_name: The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string).
        :param pulumi.Input['LinkedServiceReferenceArgs'] store: The Azure Key Vault linked service reference.
        :param pulumi.Input[str] type: Type of the secret.
               Expected value is 'AzureKeyVaultSecret'.
        :param Any secret_version: The version of the secret in Azure Key Vault. The default value is the latest version of the secret. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "store", store)
        pulumi.set(__self__, "type", 'AzureKeyVaultSecret')
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Any:
        """
        The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Any):
        pulumi.set(self, "secret_name", value)

    @property
    @pulumi.getter
    def store(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        The Azure Key Vault linked service reference.
        """
        return pulumi.get(self, "store")

    @store.setter
    def store(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "store", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the secret.
        Expected value is 'AzureKeyVaultSecret'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[Any]:
        """
        The version of the secret in Azure Key Vault. The default value is the latest version of the secret. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "secret_version")

    @secret_version.setter
    def secret_version(self, value: Optional[Any]):
        pulumi.set(self, "secret_version", value)


@pulumi.input_type
class AzureMLBatchExecutionActivityArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 global_parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 policy: Optional[pulumi.Input['ActivityPolicyArgs']] = None,
                 web_service_inputs: Optional[pulumi.Input[Mapping[str, pulumi.Input['AzureMLWebServiceFileArgs']]]] = None,
                 web_service_outputs: Optional[pulumi.Input[Mapping[str, pulumi.Input['AzureMLWebServiceFileArgs']]]] = None):
        """
        Azure ML Batch Execution activity.
        :param pulumi.Input[str] name: Activity name.
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'AzureMLBatchExecution'.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param pulumi.Input[Mapping[str, Any]] global_parameters: Key,Value pairs to be passed to the Azure ML Batch Execution Service endpoint. Keys must match the names of web service parameters defined in the published Azure ML web service. Values will be passed in the GlobalParameters property of the Azure ML batch execution request.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input['ActivityPolicyArgs'] policy: Activity policy.
        :param pulumi.Input[Mapping[str, pulumi.Input['AzureMLWebServiceFileArgs']]] web_service_inputs: Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Inputs to AzureMLWebServiceFile objects specifying the input Blob locations.. This information will be passed in the WebServiceInputs property of the Azure ML batch execution request.
        :param pulumi.Input[Mapping[str, pulumi.Input['AzureMLWebServiceFileArgs']]] web_service_outputs: Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Outputs to AzureMLWebServiceFile objects specifying the output Blob locations. This information will be passed in the WebServiceOutputs property of the Azure ML batch execution request.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'AzureMLBatchExecution')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if global_parameters is not None:
            pulumi.set(__self__, "global_parameters", global_parameters)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if web_service_inputs is not None:
            pulumi.set(__self__, "web_service_inputs", web_service_inputs)
        if web_service_outputs is not None:
            pulumi.set(__self__, "web_service_outputs", web_service_outputs)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'AzureMLBatchExecution'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="globalParameters")
    def global_parameters(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Key,Value pairs to be passed to the Azure ML Batch Execution Service endpoint. Keys must match the names of web service parameters defined in the published Azure ML web service. Values will be passed in the GlobalParameters property of the Azure ML batch execution request.
        """
        return pulumi.get(self, "global_parameters")

    @global_parameters.setter
    def global_parameters(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "global_parameters", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ActivityPolicyArgs']]:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ActivityPolicyArgs']]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="webServiceInputs")
    def web_service_inputs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['AzureMLWebServiceFileArgs']]]]:
        """
        Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Inputs to AzureMLWebServiceFile objects specifying the input Blob locations.. This information will be passed in the WebServiceInputs property of the Azure ML batch execution request.
        """
        return pulumi.get(self, "web_service_inputs")

    @web_service_inputs.setter
    def web_service_inputs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['AzureMLWebServiceFileArgs']]]]):
        pulumi.set(self, "web_service_inputs", value)

    @property
    @pulumi.getter(name="webServiceOutputs")
    def web_service_outputs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['AzureMLWebServiceFileArgs']]]]:
        """
        Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Outputs to AzureMLWebServiceFile objects specifying the output Blob locations. This information will be passed in the WebServiceOutputs property of the Azure ML batch execution request.
        """
        return pulumi.get(self, "web_service_outputs")

    @web_service_outputs.setter
    def web_service_outputs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['AzureMLWebServiceFileArgs']]]]):
        pulumi.set(self, "web_service_outputs", value)


@pulumi.input_type
class AzureMLLinkedServiceArgs:
    def __init__(__self__, *,
                 api_key: pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']],
                 ml_endpoint: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 service_principal_id: Optional[Any] = None,
                 service_principal_key: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 tenant: Optional[Any] = None,
                 update_resource_endpoint: Optional[Any] = None):
        """
        Azure ML Web Service linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] api_key: The API key for accessing the Azure ML model endpoint.
        :param Any ml_endpoint: The Batch Execution REST URL for an Azure ML Web Service endpoint. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'AzureML'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param Any service_principal_id: The ID of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML web service. Type: string (or Expression with resultType string).
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] service_principal_key: The key of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML web service.
        :param Any tenant: The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        :param Any update_resource_endpoint: The Update Resource REST URL for an Azure ML Web Service endpoint. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "ml_endpoint", ml_endpoint)
        pulumi.set(__self__, "type", 'AzureML')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)
        if update_resource_endpoint is not None:
            pulumi.set(__self__, "update_resource_endpoint", update_resource_endpoint)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]:
        """
        The API key for accessing the Azure ML model endpoint.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="mlEndpoint")
    def ml_endpoint(self) -> Any:
        """
        The Batch Execution REST URL for an Azure ML Web Service endpoint. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "ml_endpoint")

    @ml_endpoint.setter
    def ml_endpoint(self, value: Any):
        pulumi.set(self, "ml_endpoint", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'AzureML'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[Any]:
        """
        The ID of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML web service. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[Any]):
        pulumi.set(self, "service_principal_id", value)

    @property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The key of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML web service.
        """
        return pulumi.get(self, "service_principal_key")

    @service_principal_key.setter
    def service_principal_key(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "service_principal_key", value)

    @property
    @pulumi.getter
    def tenant(self) -> Optional[Any]:
        """
        The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[Any]):
        pulumi.set(self, "tenant", value)

    @property
    @pulumi.getter(name="updateResourceEndpoint")
    def update_resource_endpoint(self) -> Optional[Any]:
        """
        The Update Resource REST URL for an Azure ML Web Service endpoint. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "update_resource_endpoint")

    @update_resource_endpoint.setter
    def update_resource_endpoint(self, value: Optional[Any]):
        pulumi.set(self, "update_resource_endpoint", value)


@pulumi.input_type
class AzureMLUpdateResourceActivityArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 trained_model_file_path: Any,
                 trained_model_linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 trained_model_name: Any,
                 type: pulumi.Input[str],
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 policy: Optional[pulumi.Input['ActivityPolicyArgs']] = None):
        """
        Azure ML Update Resource management activity.
        :param pulumi.Input[str] name: Activity name.
        :param Any trained_model_file_path: The relative file path in trainedModelLinkedService to represent the .ilearner file that will be uploaded by the update operation.  Type: string (or Expression with resultType string).
        :param pulumi.Input['LinkedServiceReferenceArgs'] trained_model_linked_service_name: Name of Azure Storage linked service holding the .ilearner file that will be uploaded by the update operation.
        :param Any trained_model_name: Name of the Trained Model module in the Web Service experiment to be updated. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'AzureMLUpdateResource'.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input['ActivityPolicyArgs'] policy: Activity policy.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "trained_model_file_path", trained_model_file_path)
        pulumi.set(__self__, "trained_model_linked_service_name", trained_model_linked_service_name)
        pulumi.set(__self__, "trained_model_name", trained_model_name)
        pulumi.set(__self__, "type", 'AzureMLUpdateResource')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="trainedModelFilePath")
    def trained_model_file_path(self) -> Any:
        """
        The relative file path in trainedModelLinkedService to represent the .ilearner file that will be uploaded by the update operation.  Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "trained_model_file_path")

    @trained_model_file_path.setter
    def trained_model_file_path(self, value: Any):
        pulumi.set(self, "trained_model_file_path", value)

    @property
    @pulumi.getter(name="trainedModelLinkedServiceName")
    def trained_model_linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Name of Azure Storage linked service holding the .ilearner file that will be uploaded by the update operation.
        """
        return pulumi.get(self, "trained_model_linked_service_name")

    @trained_model_linked_service_name.setter
    def trained_model_linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "trained_model_linked_service_name", value)

    @property
    @pulumi.getter(name="trainedModelName")
    def trained_model_name(self) -> Any:
        """
        Name of the Trained Model module in the Web Service experiment to be updated. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "trained_model_name")

    @trained_model_name.setter
    def trained_model_name(self, value: Any):
        pulumi.set(self, "trained_model_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'AzureMLUpdateResource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ActivityPolicyArgs']]:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ActivityPolicyArgs']]):
        pulumi.set(self, "policy", value)


@pulumi.input_type
class AzureMLWebServiceFileArgs:
    def __init__(__self__, *,
                 file_path: Any,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs']):
        """
        Azure ML WebService Input/Output file
        :param Any file_path: The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type: string (or Expression with resultType string).
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located.
        """
        pulumi.set(__self__, "file_path", file_path)
        pulumi.set(__self__, "linked_service_name", linked_service_name)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Any:
        """
        The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "file_path")

    @file_path.setter
    def file_path(self, value: Any):
        pulumi.set(self, "file_path", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)


@pulumi.input_type
class AzureMySqlLinkedServiceArgs:
    def __init__(__self__, *,
                 connection_string: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None):
        """
        Azure MySQL database linked service.
        :param Any connection_string: The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'AzureMySql'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'AzureMySql')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Any:
        """
        The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Any):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'AzureMySql'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class AzureMySqlSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Azure MySQL source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'AzureMySqlSource'.
        :param Any query: Database query. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AzureMySqlSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'AzureMySqlSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        Database query. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class AzureMySqlTableDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None,
                 table_name: Optional[Any] = None):
        """
        The Azure MySQL database dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'AzureMySqlTable'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        :param Any table_name: The Azure MySQL database table name. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'AzureMySqlTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'AzureMySqlTable'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[Any]:
        """
        The Azure MySQL database table name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[Any]):
        pulumi.set(self, "table_name", value)


@pulumi.input_type
class AzurePostgreSqlLinkedServiceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 connection_string: Optional[Any] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None):
        """
        Azure PostgreSQL linked service.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'AzurePostgreSql'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param Any connection_string: An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "type", 'AzurePostgreSql')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'AzurePostgreSql'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[Any]:
        """
        An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[Any]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class AzurePostgreSqlSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Azure PostgreSQL source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'AzurePostgreSqlSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AzurePostgreSqlSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'AzurePostgreSqlSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class AzurePostgreSqlTableDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Azure PostgreSQL dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'AzurePostgreSqlTable'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'AzurePostgreSqlTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'AzurePostgreSqlTable'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class AzureQueueSinkArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity Azure Queue sink.
        :param pulumi.Input[str] type: Copy sink type.
               Expected value is 'AzureQueueSink'.
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AzureQueueSink')
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy sink type.
        Expected value is 'AzureQueueSink'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @sink_retry_count.setter
    def sink_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_count", value)

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @sink_retry_wait.setter
    def sink_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_wait", value)

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @write_batch_size.setter
    def write_batch_size(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_size", value)

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")

    @write_batch_timeout.setter
    def write_batch_timeout(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_timeout", value)


@pulumi.input_type
class AzureSearchIndexDatasetArgs:
    def __init__(__self__, *,
                 index_name: Any,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        The Azure Search Index.
        :param Any index_name: The name of the Azure Search Index. Type: string (or Expression with resultType string).
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'AzureSearchIndex'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "index_name", index_name)
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'AzureSearchIndex')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> Any:
        """
        The name of the Azure Search Index. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "index_name")

    @index_name.setter
    def index_name(self, value: Any):
        pulumi.set(self, "index_name", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'AzureSearchIndex'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class AzureSearchIndexSinkArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None,
                 write_behavior: Optional[pulumi.Input[Union[str, 'AzureSearchIndexWriteBehaviorType']]] = None):
        """
        A copy activity Azure Search Index sink.
        :param pulumi.Input[str] type: Copy sink type.
               Expected value is 'AzureSearchIndexSink'.
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param pulumi.Input[Union[str, 'AzureSearchIndexWriteBehaviorType']] write_behavior: Specify the write behavior when upserting documents into Azure Search Index.
        """
        pulumi.set(__self__, "type", 'AzureSearchIndexSink')
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)
        if write_behavior is not None:
            pulumi.set(__self__, "write_behavior", write_behavior)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy sink type.
        Expected value is 'AzureSearchIndexSink'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @sink_retry_count.setter
    def sink_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_count", value)

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @sink_retry_wait.setter
    def sink_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_wait", value)

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @write_batch_size.setter
    def write_batch_size(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_size", value)

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")

    @write_batch_timeout.setter
    def write_batch_timeout(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_timeout", value)

    @property
    @pulumi.getter(name="writeBehavior")
    def write_behavior(self) -> Optional[pulumi.Input[Union[str, 'AzureSearchIndexWriteBehaviorType']]]:
        """
        Specify the write behavior when upserting documents into Azure Search Index.
        """
        return pulumi.get(self, "write_behavior")

    @write_behavior.setter
    def write_behavior(self, value: Optional[pulumi.Input[Union[str, 'AzureSearchIndexWriteBehaviorType']]]):
        pulumi.set(self, "write_behavior", value)


@pulumi.input_type
class AzureSearchLinkedServiceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 url: Any,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 key: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None):
        """
        Linked service for Windows Azure Search Service.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'AzureSearch'.
        :param Any url: URL for Azure Search service. Type: string (or Expression with resultType string).
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] key: Admin Key for Azure Search service
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "type", 'AzureSearch')
        pulumi.set(__self__, "url", url)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'AzureSearch'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def url(self) -> Any:
        """
        URL for Azure Search service. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Any):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        Admin Key for Azure Search service
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class AzureSqlDWLinkedServiceArgs:
    def __init__(__self__, *,
                 connection_string: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 service_principal_id: Optional[Any] = None,
                 service_principal_key: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 tenant: Optional[Any] = None):
        """
        Azure SQL Data Warehouse linked service.
        :param Any connection_string: The connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'AzureSqlDW'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param Any service_principal_id: The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] service_principal_key: The key of the service principal used to authenticate against Azure SQL Data Warehouse.
        :param Any tenant: The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'AzureSqlDW')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Any:
        """
        The connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Any):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'AzureSqlDW'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[Any]:
        """
        The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[Any]):
        pulumi.set(self, "service_principal_id", value)

    @property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The key of the service principal used to authenticate against Azure SQL Data Warehouse.
        """
        return pulumi.get(self, "service_principal_key")

    @service_principal_key.setter
    def service_principal_key(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "service_principal_key", value)

    @property
    @pulumi.getter
    def tenant(self) -> Optional[Any]:
        """
        The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[Any]):
        pulumi.set(self, "tenant", value)


@pulumi.input_type
class AzureSqlDWTableDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 table_name: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        The Azure SQL Data Warehouse dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param Any table_name: The table name of the Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'AzureSqlDWTable'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "type", 'AzureSqlDWTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Any:
        """
        The table name of the Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Any):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'AzureSqlDWTable'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class AzureSqlDatabaseLinkedServiceArgs:
    def __init__(__self__, *,
                 connection_string: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 service_principal_id: Optional[Any] = None,
                 service_principal_key: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 tenant: Optional[Any] = None):
        """
        Microsoft Azure SQL Database linked service.
        :param Any connection_string: The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'AzureSqlDatabase'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param Any service_principal_id: The ID of the service principal used to authenticate against Azure SQL Database. Type: string (or Expression with resultType string).
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] service_principal_key: The key of the service principal used to authenticate against Azure SQL Database.
        :param Any tenant: The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'AzureSqlDatabase')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Any:
        """
        The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Any):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'AzureSqlDatabase'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[Any]:
        """
        The ID of the service principal used to authenticate against Azure SQL Database. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[Any]):
        pulumi.set(self, "service_principal_id", value)

    @property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The key of the service principal used to authenticate against Azure SQL Database.
        """
        return pulumi.get(self, "service_principal_key")

    @service_principal_key.setter
    def service_principal_key(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "service_principal_key", value)

    @property
    @pulumi.getter
    def tenant(self) -> Optional[Any]:
        """
        The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[Any]):
        pulumi.set(self, "tenant", value)


@pulumi.input_type
class AzureSqlTableDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 table_name: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        The Azure SQL Server database dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param Any table_name: The table name of the Azure SQL database. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'AzureSqlTable'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "type", 'AzureSqlTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Any:
        """
        The table name of the Azure SQL database. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Any):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'AzureSqlTable'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class AzureStorageLinkedServiceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 connection_string: Optional[Any] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 sas_uri: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None):
        """
        The storage account linked service.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'AzureStorage'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param Any connection_string: The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] sas_uri: SAS URI of the Azure Storage resource. It is mutually exclusive with connectionString property.
        """
        pulumi.set(__self__, "type", 'AzureStorage')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if sas_uri is not None:
            pulumi.set(__self__, "sas_uri", sas_uri)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'AzureStorage'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[Any]:
        """
        The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[Any]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="sasUri")
    def sas_uri(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        SAS URI of the Azure Storage resource. It is mutually exclusive with connectionString property.
        """
        return pulumi.get(self, "sas_uri")

    @sas_uri.setter
    def sas_uri(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "sas_uri", value)


@pulumi.input_type
class AzureTableDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 table_name: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        The Azure Table storage dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param Any table_name: The table name of the Azure Table storage. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'AzureTable'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "type", 'AzureTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Any:
        """
        The table name of the Azure Table storage. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Any):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'AzureTable'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class AzureTableSinkArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 azure_table_default_partition_key_value: Optional[Any] = None,
                 azure_table_insert_type: Optional[Any] = None,
                 azure_table_partition_key_name: Optional[Any] = None,
                 azure_table_row_key_name: Optional[Any] = None,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity Azure Table sink.
        :param pulumi.Input[str] type: Copy sink type.
               Expected value is 'AzureTableSink'.
        :param Any azure_table_default_partition_key_value: Azure Table default partition key value. Type: string (or Expression with resultType string).
        :param Any azure_table_insert_type: Azure Table insert type. Type: string (or Expression with resultType string).
        :param Any azure_table_partition_key_name: Azure Table partition key name. Type: string (or Expression with resultType string).
        :param Any azure_table_row_key_name: Azure Table row key name. Type: string (or Expression with resultType string).
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AzureTableSink')
        if azure_table_default_partition_key_value is not None:
            pulumi.set(__self__, "azure_table_default_partition_key_value", azure_table_default_partition_key_value)
        if azure_table_insert_type is not None:
            pulumi.set(__self__, "azure_table_insert_type", azure_table_insert_type)
        if azure_table_partition_key_name is not None:
            pulumi.set(__self__, "azure_table_partition_key_name", azure_table_partition_key_name)
        if azure_table_row_key_name is not None:
            pulumi.set(__self__, "azure_table_row_key_name", azure_table_row_key_name)
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy sink type.
        Expected value is 'AzureTableSink'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="azureTableDefaultPartitionKeyValue")
    def azure_table_default_partition_key_value(self) -> Optional[Any]:
        """
        Azure Table default partition key value. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "azure_table_default_partition_key_value")

    @azure_table_default_partition_key_value.setter
    def azure_table_default_partition_key_value(self, value: Optional[Any]):
        pulumi.set(self, "azure_table_default_partition_key_value", value)

    @property
    @pulumi.getter(name="azureTableInsertType")
    def azure_table_insert_type(self) -> Optional[Any]:
        """
        Azure Table insert type. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "azure_table_insert_type")

    @azure_table_insert_type.setter
    def azure_table_insert_type(self, value: Optional[Any]):
        pulumi.set(self, "azure_table_insert_type", value)

    @property
    @pulumi.getter(name="azureTablePartitionKeyName")
    def azure_table_partition_key_name(self) -> Optional[Any]:
        """
        Azure Table partition key name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "azure_table_partition_key_name")

    @azure_table_partition_key_name.setter
    def azure_table_partition_key_name(self, value: Optional[Any]):
        pulumi.set(self, "azure_table_partition_key_name", value)

    @property
    @pulumi.getter(name="azureTableRowKeyName")
    def azure_table_row_key_name(self) -> Optional[Any]:
        """
        Azure Table row key name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "azure_table_row_key_name")

    @azure_table_row_key_name.setter
    def azure_table_row_key_name(self, value: Optional[Any]):
        pulumi.set(self, "azure_table_row_key_name", value)

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @sink_retry_count.setter
    def sink_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_count", value)

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @sink_retry_wait.setter
    def sink_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_wait", value)

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @write_batch_size.setter
    def write_batch_size(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_size", value)

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")

    @write_batch_timeout.setter
    def write_batch_timeout(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_timeout", value)


@pulumi.input_type
class AzureTableSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 azure_table_source_ignore_table_not_found: Optional[Any] = None,
                 azure_table_source_query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Azure Table source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'AzureTableSource'.
        :param Any azure_table_source_ignore_table_not_found: Azure Table source ignore table not found. Type: boolean (or Expression with resultType boolean).
        :param Any azure_table_source_query: Azure Table source query. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'AzureTableSource')
        if azure_table_source_ignore_table_not_found is not None:
            pulumi.set(__self__, "azure_table_source_ignore_table_not_found", azure_table_source_ignore_table_not_found)
        if azure_table_source_query is not None:
            pulumi.set(__self__, "azure_table_source_query", azure_table_source_query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'AzureTableSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="azureTableSourceIgnoreTableNotFound")
    def azure_table_source_ignore_table_not_found(self) -> Optional[Any]:
        """
        Azure Table source ignore table not found. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "azure_table_source_ignore_table_not_found")

    @azure_table_source_ignore_table_not_found.setter
    def azure_table_source_ignore_table_not_found(self, value: Optional[Any]):
        pulumi.set(self, "azure_table_source_ignore_table_not_found", value)

    @property
    @pulumi.getter(name="azureTableSourceQuery")
    def azure_table_source_query(self) -> Optional[Any]:
        """
        Azure Table source query. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "azure_table_source_query")

    @azure_table_source_query.setter
    def azure_table_source_query(self, value: Optional[Any]):
        pulumi.set(self, "azure_table_source_query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class BlobEventsTriggerArgs:
    def __init__(__self__, *,
                 events: pulumi.Input[Sequence[pulumi.Input[Union[str, 'BlobEventTypes']]]],
                 scope: pulumi.Input[str],
                 type: pulumi.Input[str],
                 blob_path_begins_with: Optional[pulumi.Input[str]] = None,
                 blob_path_ends_with: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ignore_empty_blobs: Optional[pulumi.Input[bool]] = None,
                 pipelines: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerPipelineReferenceArgs']]]] = None):
        """
        Trigger that runs every time a Blob event occurs.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'BlobEventTypes']]]] events: The type of events that cause this trigger to fire.
        :param pulumi.Input[str] scope: The ARM resource ID of the Storage Account.
        :param pulumi.Input[str] type: Trigger type.
               Expected value is 'BlobEventsTrigger'.
        :param pulumi.Input[str] blob_path_begins_with: The blob path must begin with the pattern provided for trigger to fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the december folder under the records container. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
        :param pulumi.Input[str] blob_path_ends_with: The blob path must end with the pattern provided for trigger to fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
        :param pulumi.Input[str] description: Trigger description.
        :param pulumi.Input[bool] ignore_empty_blobs: If set to true, blobs with zero bytes will be ignored.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerPipelineReferenceArgs']]] pipelines: Pipelines that need to be started.
        """
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "type", 'BlobEventsTrigger')
        if blob_path_begins_with is not None:
            pulumi.set(__self__, "blob_path_begins_with", blob_path_begins_with)
        if blob_path_ends_with is not None:
            pulumi.set(__self__, "blob_path_ends_with", blob_path_ends_with)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ignore_empty_blobs is not None:
            pulumi.set(__self__, "ignore_empty_blobs", ignore_empty_blobs)
        if pipelines is not None:
            pulumi.set(__self__, "pipelines", pipelines)

    @property
    @pulumi.getter
    def events(self) -> pulumi.Input[Sequence[pulumi.Input[Union[str, 'BlobEventTypes']]]]:
        """
        The type of events that cause this trigger to fire.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: pulumi.Input[Sequence[pulumi.Input[Union[str, 'BlobEventTypes']]]]):
        pulumi.set(self, "events", value)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input[str]:
        """
        The ARM resource ID of the Storage Account.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[str]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Trigger type.
        Expected value is 'BlobEventsTrigger'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="blobPathBeginsWith")
    def blob_path_begins_with(self) -> Optional[pulumi.Input[str]]:
        """
        The blob path must begin with the pattern provided for trigger to fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the december folder under the records container. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
        """
        return pulumi.get(self, "blob_path_begins_with")

    @blob_path_begins_with.setter
    def blob_path_begins_with(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "blob_path_begins_with", value)

    @property
    @pulumi.getter(name="blobPathEndsWith")
    def blob_path_ends_with(self) -> Optional[pulumi.Input[str]]:
        """
        The blob path must end with the pattern provided for trigger to fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
        """
        return pulumi.get(self, "blob_path_ends_with")

    @blob_path_ends_with.setter
    def blob_path_ends_with(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "blob_path_ends_with", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Trigger description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ignoreEmptyBlobs")
    def ignore_empty_blobs(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, blobs with zero bytes will be ignored.
        """
        return pulumi.get(self, "ignore_empty_blobs")

    @ignore_empty_blobs.setter
    def ignore_empty_blobs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_empty_blobs", value)

    @property
    @pulumi.getter
    def pipelines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerPipelineReferenceArgs']]]]:
        """
        Pipelines that need to be started.
        """
        return pulumi.get(self, "pipelines")

    @pipelines.setter
    def pipelines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerPipelineReferenceArgs']]]]):
        pulumi.set(self, "pipelines", value)


@pulumi.input_type
class BlobSinkArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 blob_writer_add_header: Optional[Any] = None,
                 blob_writer_date_time_format: Optional[Any] = None,
                 blob_writer_overwrite_files: Optional[Any] = None,
                 copy_behavior: Optional[Any] = None,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity Azure Blob sink.
        :param pulumi.Input[str] type: Copy sink type.
               Expected value is 'BlobSink'.
        :param Any blob_writer_add_header: Blob writer add header. Type: boolean (or Expression with resultType boolean).
        :param Any blob_writer_date_time_format: Blob writer date time format. Type: string (or Expression with resultType string).
        :param Any blob_writer_overwrite_files: Blob writer overwrite files. Type: boolean (or Expression with resultType boolean).
        :param Any copy_behavior: The type of copy behavior for copy sink.
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'BlobSink')
        if blob_writer_add_header is not None:
            pulumi.set(__self__, "blob_writer_add_header", blob_writer_add_header)
        if blob_writer_date_time_format is not None:
            pulumi.set(__self__, "blob_writer_date_time_format", blob_writer_date_time_format)
        if blob_writer_overwrite_files is not None:
            pulumi.set(__self__, "blob_writer_overwrite_files", blob_writer_overwrite_files)
        if copy_behavior is not None:
            pulumi.set(__self__, "copy_behavior", copy_behavior)
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy sink type.
        Expected value is 'BlobSink'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="blobWriterAddHeader")
    def blob_writer_add_header(self) -> Optional[Any]:
        """
        Blob writer add header. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "blob_writer_add_header")

    @blob_writer_add_header.setter
    def blob_writer_add_header(self, value: Optional[Any]):
        pulumi.set(self, "blob_writer_add_header", value)

    @property
    @pulumi.getter(name="blobWriterDateTimeFormat")
    def blob_writer_date_time_format(self) -> Optional[Any]:
        """
        Blob writer date time format. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "blob_writer_date_time_format")

    @blob_writer_date_time_format.setter
    def blob_writer_date_time_format(self, value: Optional[Any]):
        pulumi.set(self, "blob_writer_date_time_format", value)

    @property
    @pulumi.getter(name="blobWriterOverwriteFiles")
    def blob_writer_overwrite_files(self) -> Optional[Any]:
        """
        Blob writer overwrite files. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "blob_writer_overwrite_files")

    @blob_writer_overwrite_files.setter
    def blob_writer_overwrite_files(self, value: Optional[Any]):
        pulumi.set(self, "blob_writer_overwrite_files", value)

    @property
    @pulumi.getter(name="copyBehavior")
    def copy_behavior(self) -> Optional[Any]:
        """
        The type of copy behavior for copy sink.
        """
        return pulumi.get(self, "copy_behavior")

    @copy_behavior.setter
    def copy_behavior(self, value: Optional[Any]):
        pulumi.set(self, "copy_behavior", value)

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @sink_retry_count.setter
    def sink_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_count", value)

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @sink_retry_wait.setter
    def sink_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_wait", value)

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @write_batch_size.setter
    def write_batch_size(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_size", value)

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")

    @write_batch_timeout.setter
    def write_batch_timeout(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_timeout", value)


@pulumi.input_type
class BlobSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 recursive: Optional[Any] = None,
                 skip_header_line_count: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None,
                 treat_empty_as_null: Optional[Any] = None):
        """
        A copy activity Azure Blob source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'BlobSource'.
        :param Any recursive: If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
        :param Any skip_header_line_count: Number of header lines to skip from each blob. Type: integer (or Expression with resultType integer).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any treat_empty_as_null: Treat empty as null. Type: boolean (or Expression with resultType boolean).
        """
        pulumi.set(__self__, "type", 'BlobSource')
        if recursive is not None:
            pulumi.set(__self__, "recursive", recursive)
        if skip_header_line_count is not None:
            pulumi.set(__self__, "skip_header_line_count", skip_header_line_count)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)
        if treat_empty_as_null is not None:
            pulumi.set(__self__, "treat_empty_as_null", treat_empty_as_null)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'BlobSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def recursive(self) -> Optional[Any]:
        """
        If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "recursive")

    @recursive.setter
    def recursive(self, value: Optional[Any]):
        pulumi.set(self, "recursive", value)

    @property
    @pulumi.getter(name="skipHeaderLineCount")
    def skip_header_line_count(self) -> Optional[Any]:
        """
        Number of header lines to skip from each blob. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "skip_header_line_count")

    @skip_header_line_count.setter
    def skip_header_line_count(self, value: Optional[Any]):
        pulumi.set(self, "skip_header_line_count", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)

    @property
    @pulumi.getter(name="treatEmptyAsNull")
    def treat_empty_as_null(self) -> Optional[Any]:
        """
        Treat empty as null. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "treat_empty_as_null")

    @treat_empty_as_null.setter
    def treat_empty_as_null(self, value: Optional[Any]):
        pulumi.set(self, "treat_empty_as_null", value)


@pulumi.input_type
class BlobTriggerArgs:
    def __init__(__self__, *,
                 folder_path: pulumi.Input[str],
                 linked_service: pulumi.Input['LinkedServiceReferenceArgs'],
                 max_concurrency: pulumi.Input[int],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 pipelines: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerPipelineReferenceArgs']]]] = None):
        """
        Trigger that runs every time the selected Blob container changes.
        :param pulumi.Input[str] folder_path: The path of the container/folder that will trigger the pipeline.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service: The Azure Storage linked service reference.
        :param pulumi.Input[int] max_concurrency: The max number of parallel files to handle when it is triggered.
        :param pulumi.Input[str] type: Trigger type.
               Expected value is 'BlobTrigger'.
        :param pulumi.Input[str] description: Trigger description.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerPipelineReferenceArgs']]] pipelines: Pipelines that need to be started.
        """
        pulumi.set(__self__, "folder_path", folder_path)
        pulumi.set(__self__, "linked_service", linked_service)
        pulumi.set(__self__, "max_concurrency", max_concurrency)
        pulumi.set(__self__, "type", 'BlobTrigger')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if pipelines is not None:
            pulumi.set(__self__, "pipelines", pipelines)

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> pulumi.Input[str]:
        """
        The path of the container/folder that will trigger the pipeline.
        """
        return pulumi.get(self, "folder_path")

    @folder_path.setter
    def folder_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "folder_path", value)

    @property
    @pulumi.getter(name="linkedService")
    def linked_service(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        The Azure Storage linked service reference.
        """
        return pulumi.get(self, "linked_service")

    @linked_service.setter
    def linked_service(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service", value)

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> pulumi.Input[int]:
        """
        The max number of parallel files to handle when it is triggered.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_concurrency", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Trigger type.
        Expected value is 'BlobTrigger'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Trigger description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def pipelines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerPipelineReferenceArgs']]]]:
        """
        Pipelines that need to be started.
        """
        return pulumi.get(self, "pipelines")

    @pipelines.setter
    def pipelines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerPipelineReferenceArgs']]]]):
        pulumi.set(self, "pipelines", value)


@pulumi.input_type
class CassandraLinkedServiceArgs:
    def __init__(__self__, *,
                 host: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 authentication_type: Optional[Any] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 port: Optional[Any] = None,
                 username: Optional[Any] = None):
        """
        Linked service for Cassandra data source.
        :param Any host: Host name for connection. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Cassandra'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param Any authentication_type: AuthenticationType to be used for connection. Type: string (or Expression with resultType string).
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: Password for authentication.
        :param Any port: The port for the connection. Type: integer (or Expression with resultType integer).
        :param Any username: Username for authentication. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'Cassandra')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        Host name for connection. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Any):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Cassandra'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[Any]:
        """
        AuthenticationType to be used for connection. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[Any]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        Password for authentication.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The port for the connection. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[Any]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        Username for authentication. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[Any]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class CassandraSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 consistency_level: Optional[pulumi.Input[Union[str, 'CassandraSourceReadConsistencyLevels']]] = None,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity source for a Cassandra database.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'CassandraSource'.
        :param pulumi.Input[Union[str, 'CassandraSourceReadConsistencyLevels']] consistency_level: The consistency level specifies how many Cassandra servers must respond to a read request before returning data to the client application. Cassandra checks the specified number of Cassandra servers for data to satisfy the read request. Must be one of cassandraSourceReadConsistencyLevels. The default value is 'ONE'. It is case-insensitive.
        :param Any query: Database query. Should be a SQL-92 query expression or Cassandra Query Language (CQL) command. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'CassandraSource')
        if consistency_level is not None:
            pulumi.set(__self__, "consistency_level", consistency_level)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'CassandraSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="consistencyLevel")
    def consistency_level(self) -> Optional[pulumi.Input[Union[str, 'CassandraSourceReadConsistencyLevels']]]:
        """
        The consistency level specifies how many Cassandra servers must respond to a read request before returning data to the client application. Cassandra checks the specified number of Cassandra servers for data to satisfy the read request. Must be one of cassandraSourceReadConsistencyLevels. The default value is 'ONE'. It is case-insensitive.
        """
        return pulumi.get(self, "consistency_level")

    @consistency_level.setter
    def consistency_level(self, value: Optional[pulumi.Input[Union[str, 'CassandraSourceReadConsistencyLevels']]]):
        pulumi.set(self, "consistency_level", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        Database query. Should be a SQL-92 query expression or Cassandra Query Language (CQL) command. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class CassandraTableDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 keyspace: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None,
                 table_name: Optional[Any] = None):
        """
        The Cassandra database dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'CassandraTable'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param Any keyspace: The keyspace of the Cassandra database. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        :param Any table_name: The table name of the Cassandra database. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'CassandraTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if keyspace is not None:
            pulumi.set(__self__, "keyspace", keyspace)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'CassandraTable'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def keyspace(self) -> Optional[Any]:
        """
        The keyspace of the Cassandra database. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "keyspace")

    @keyspace.setter
    def keyspace(self, value: Optional[Any]):
        pulumi.set(self, "keyspace", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[Any]:
        """
        The table name of the Cassandra database. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[Any]):
        pulumi.set(self, "table_name", value)


@pulumi.input_type
class ConcurLinkedServiceArgs:
    def __init__(__self__, *,
                 client_id: Any,
                 type: pulumi.Input[str],
                 username: Any,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Concur Service linked service.
        :param Any client_id: Application client_id supplied by Concur App Management.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Concur'.
        :param Any username: The user name that you use to access Concur Service.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: The password corresponding to the user name that you provided in the username field.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "type", 'Concur')
        pulumi.set(__self__, "username", username)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Any:
        """
        Application client_id supplied by Concur App Management.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Any):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Concur'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def username(self) -> Any:
        """
        The user name that you use to access Concur Service.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Any):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The password corresponding to the user name that you provided in the username field.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @use_encrypted_endpoints.setter
    def use_encrypted_endpoints(self, value: Optional[Any]):
        pulumi.set(self, "use_encrypted_endpoints", value)

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_host_verification")

    @use_host_verification.setter
    def use_host_verification(self, value: Optional[Any]):
        pulumi.set(self, "use_host_verification", value)

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_peer_verification")

    @use_peer_verification.setter
    def use_peer_verification(self, value: Optional[Any]):
        pulumi.set(self, "use_peer_verification", value)


@pulumi.input_type
class ConcurObjectDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Concur Service dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'ConcurObject'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'ConcurObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'ConcurObject'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class ConcurSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Concur Service source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'ConcurSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'ConcurSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'ConcurSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class ControlActivityArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        Base class for all control activities like IfCondition, ForEach , Until.
        :param pulumi.Input[str] name: Activity name.
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'Container'.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'Container')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'Container'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class CopyActivityArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 sink: pulumi.Input[Union['AzureDataLakeStoreSinkArgs', 'AzureQueueSinkArgs', 'AzureSearchIndexSinkArgs', 'AzureTableSinkArgs', 'BlobSinkArgs', 'DocumentDbCollectionSinkArgs', 'DynamicsSinkArgs', 'FileSystemSinkArgs', 'OdbcSinkArgs', 'OracleSinkArgs', 'SalesforceSinkArgs', 'SapCloudForCustomerSinkArgs', 'SqlDWSinkArgs', 'SqlSinkArgs']],
                 source: pulumi.Input[Union['AmazonMWSSourceArgs', 'AmazonRedshiftSourceArgs', 'AzureDataLakeStoreSourceArgs', 'AzureMySqlSourceArgs', 'AzurePostgreSqlSourceArgs', 'AzureTableSourceArgs', 'BlobSourceArgs', 'CassandraSourceArgs', 'ConcurSourceArgs', 'CouchbaseSourceArgs', 'DocumentDbCollectionSourceArgs', 'DrillSourceArgs', 'DynamicsSourceArgs', 'EloquaSourceArgs', 'FileSystemSourceArgs', 'GoogleBigQuerySourceArgs', 'GreenplumSourceArgs', 'HBaseSourceArgs', 'HdfsSourceArgs', 'HiveSourceArgs', 'HttpSourceArgs', 'HubspotSourceArgs', 'ImpalaSourceArgs', 'JiraSourceArgs', 'MagentoSourceArgs', 'MariaDBSourceArgs', 'MarketoSourceArgs', 'MongoDbSourceArgs', 'NetezzaSourceArgs', 'OracleSourceArgs', 'PaypalSourceArgs', 'PhoenixSourceArgs', 'PrestoSourceArgs', 'QuickBooksSourceArgs', 'RelationalSourceArgs', 'ResponsysSourceArgs', 'SalesforceMarketingCloudSourceArgs', 'SalesforceSourceArgs', 'SapCloudForCustomerSourceArgs', 'SapEccSourceArgs', 'ServiceNowSourceArgs', 'ShopifySourceArgs', 'SparkSourceArgs', 'SqlDWSourceArgs', 'SqlSourceArgs', 'SquareSourceArgs', 'VerticaSourceArgs', 'WebSourceArgs', 'XeroSourceArgs', 'ZohoSourceArgs']],
                 type: pulumi.Input[str],
                 cloud_data_movement_units: Optional[Any] = None,
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_skip_incompatible_row: Optional[Any] = None,
                 enable_staging: Optional[Any] = None,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetReferenceArgs']]]] = None,
                 linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetReferenceArgs']]]] = None,
                 parallel_copies: Optional[Any] = None,
                 policy: Optional[pulumi.Input['ActivityPolicyArgs']] = None,
                 redirect_incompatible_row_settings: Optional[pulumi.Input['RedirectIncompatibleRowSettingsArgs']] = None,
                 staging_settings: Optional[pulumi.Input['StagingSettingsArgs']] = None,
                 translator: Optional[Any] = None):
        """
        Copy activity.
        :param pulumi.Input[str] name: Activity name.
        :param pulumi.Input[Union['AzureDataLakeStoreSinkArgs', 'AzureQueueSinkArgs', 'AzureSearchIndexSinkArgs', 'AzureTableSinkArgs', 'BlobSinkArgs', 'DocumentDbCollectionSinkArgs', 'DynamicsSinkArgs', 'FileSystemSinkArgs', 'OdbcSinkArgs', 'OracleSinkArgs', 'SalesforceSinkArgs', 'SapCloudForCustomerSinkArgs', 'SqlDWSinkArgs', 'SqlSinkArgs']] sink: Copy activity sink.
        :param pulumi.Input[Union['AmazonMWSSourceArgs', 'AmazonRedshiftSourceArgs', 'AzureDataLakeStoreSourceArgs', 'AzureMySqlSourceArgs', 'AzurePostgreSqlSourceArgs', 'AzureTableSourceArgs', 'BlobSourceArgs', 'CassandraSourceArgs', 'ConcurSourceArgs', 'CouchbaseSourceArgs', 'DocumentDbCollectionSourceArgs', 'DrillSourceArgs', 'DynamicsSourceArgs', 'EloquaSourceArgs', 'FileSystemSourceArgs', 'GoogleBigQuerySourceArgs', 'GreenplumSourceArgs', 'HBaseSourceArgs', 'HdfsSourceArgs', 'HiveSourceArgs', 'HttpSourceArgs', 'HubspotSourceArgs', 'ImpalaSourceArgs', 'JiraSourceArgs', 'MagentoSourceArgs', 'MariaDBSourceArgs', 'MarketoSourceArgs', 'MongoDbSourceArgs', 'NetezzaSourceArgs', 'OracleSourceArgs', 'PaypalSourceArgs', 'PhoenixSourceArgs', 'PrestoSourceArgs', 'QuickBooksSourceArgs', 'RelationalSourceArgs', 'ResponsysSourceArgs', 'SalesforceMarketingCloudSourceArgs', 'SalesforceSourceArgs', 'SapCloudForCustomerSourceArgs', 'SapEccSourceArgs', 'ServiceNowSourceArgs', 'ShopifySourceArgs', 'SparkSourceArgs', 'SqlDWSourceArgs', 'SqlSourceArgs', 'SquareSourceArgs', 'VerticaSourceArgs', 'WebSourceArgs', 'XeroSourceArgs', 'ZohoSourceArgs']] source: Copy activity source.
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'Copy'.
        :param Any cloud_data_movement_units: Maximum number of cloud data movement units that can be used to perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param Any enable_skip_incompatible_row: Whether to skip incompatible row. Default value is false. Type: boolean (or Expression with resultType boolean).
        :param Any enable_staging: Specifies whether to copy data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean).
        :param pulumi.Input[Sequence[pulumi.Input['DatasetReferenceArgs']]] inputs: List of inputs for the activity.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[Sequence[pulumi.Input['DatasetReferenceArgs']]] outputs: List of outputs for the activity.
        :param Any parallel_copies: Maximum number of concurrent sessions opened on the source or sink to avoid overloading the data store. Type: integer (or Expression with resultType integer), minimum: 0.
        :param pulumi.Input['ActivityPolicyArgs'] policy: Activity policy.
        :param pulumi.Input['RedirectIncompatibleRowSettingsArgs'] redirect_incompatible_row_settings: Redirect incompatible row settings when EnableSkipIncompatibleRow is true.
        :param pulumi.Input['StagingSettingsArgs'] staging_settings: Specifies interim staging settings when EnableStaging is true.
        :param Any translator: Copy activity translator. If not specified, tabular translator is used.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sink", sink)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "type", 'Copy')
        if cloud_data_movement_units is not None:
            pulumi.set(__self__, "cloud_data_movement_units", cloud_data_movement_units)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_skip_incompatible_row is not None:
            pulumi.set(__self__, "enable_skip_incompatible_row", enable_skip_incompatible_row)
        if enable_staging is not None:
            pulumi.set(__self__, "enable_staging", enable_staging)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if parallel_copies is not None:
            pulumi.set(__self__, "parallel_copies", parallel_copies)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if redirect_incompatible_row_settings is not None:
            pulumi.set(__self__, "redirect_incompatible_row_settings", redirect_incompatible_row_settings)
        if staging_settings is not None:
            pulumi.set(__self__, "staging_settings", staging_settings)
        if translator is not None:
            pulumi.set(__self__, "translator", translator)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def sink(self) -> pulumi.Input[Union['AzureDataLakeStoreSinkArgs', 'AzureQueueSinkArgs', 'AzureSearchIndexSinkArgs', 'AzureTableSinkArgs', 'BlobSinkArgs', 'DocumentDbCollectionSinkArgs', 'DynamicsSinkArgs', 'FileSystemSinkArgs', 'OdbcSinkArgs', 'OracleSinkArgs', 'SalesforceSinkArgs', 'SapCloudForCustomerSinkArgs', 'SqlDWSinkArgs', 'SqlSinkArgs']]:
        """
        Copy activity sink.
        """
        return pulumi.get(self, "sink")

    @sink.setter
    def sink(self, value: pulumi.Input[Union['AzureDataLakeStoreSinkArgs', 'AzureQueueSinkArgs', 'AzureSearchIndexSinkArgs', 'AzureTableSinkArgs', 'BlobSinkArgs', 'DocumentDbCollectionSinkArgs', 'DynamicsSinkArgs', 'FileSystemSinkArgs', 'OdbcSinkArgs', 'OracleSinkArgs', 'SalesforceSinkArgs', 'SapCloudForCustomerSinkArgs', 'SqlDWSinkArgs', 'SqlSinkArgs']]):
        pulumi.set(self, "sink", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[Union['AmazonMWSSourceArgs', 'AmazonRedshiftSourceArgs', 'AzureDataLakeStoreSourceArgs', 'AzureMySqlSourceArgs', 'AzurePostgreSqlSourceArgs', 'AzureTableSourceArgs', 'BlobSourceArgs', 'CassandraSourceArgs', 'ConcurSourceArgs', 'CouchbaseSourceArgs', 'DocumentDbCollectionSourceArgs', 'DrillSourceArgs', 'DynamicsSourceArgs', 'EloquaSourceArgs', 'FileSystemSourceArgs', 'GoogleBigQuerySourceArgs', 'GreenplumSourceArgs', 'HBaseSourceArgs', 'HdfsSourceArgs', 'HiveSourceArgs', 'HttpSourceArgs', 'HubspotSourceArgs', 'ImpalaSourceArgs', 'JiraSourceArgs', 'MagentoSourceArgs', 'MariaDBSourceArgs', 'MarketoSourceArgs', 'MongoDbSourceArgs', 'NetezzaSourceArgs', 'OracleSourceArgs', 'PaypalSourceArgs', 'PhoenixSourceArgs', 'PrestoSourceArgs', 'QuickBooksSourceArgs', 'RelationalSourceArgs', 'ResponsysSourceArgs', 'SalesforceMarketingCloudSourceArgs', 'SalesforceSourceArgs', 'SapCloudForCustomerSourceArgs', 'SapEccSourceArgs', 'ServiceNowSourceArgs', 'ShopifySourceArgs', 'SparkSourceArgs', 'SqlDWSourceArgs', 'SqlSourceArgs', 'SquareSourceArgs', 'VerticaSourceArgs', 'WebSourceArgs', 'XeroSourceArgs', 'ZohoSourceArgs']]:
        """
        Copy activity source.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[Union['AmazonMWSSourceArgs', 'AmazonRedshiftSourceArgs', 'AzureDataLakeStoreSourceArgs', 'AzureMySqlSourceArgs', 'AzurePostgreSqlSourceArgs', 'AzureTableSourceArgs', 'BlobSourceArgs', 'CassandraSourceArgs', 'ConcurSourceArgs', 'CouchbaseSourceArgs', 'DocumentDbCollectionSourceArgs', 'DrillSourceArgs', 'DynamicsSourceArgs', 'EloquaSourceArgs', 'FileSystemSourceArgs', 'GoogleBigQuerySourceArgs', 'GreenplumSourceArgs', 'HBaseSourceArgs', 'HdfsSourceArgs', 'HiveSourceArgs', 'HttpSourceArgs', 'HubspotSourceArgs', 'ImpalaSourceArgs', 'JiraSourceArgs', 'MagentoSourceArgs', 'MariaDBSourceArgs', 'MarketoSourceArgs', 'MongoDbSourceArgs', 'NetezzaSourceArgs', 'OracleSourceArgs', 'PaypalSourceArgs', 'PhoenixSourceArgs', 'PrestoSourceArgs', 'QuickBooksSourceArgs', 'RelationalSourceArgs', 'ResponsysSourceArgs', 'SalesforceMarketingCloudSourceArgs', 'SalesforceSourceArgs', 'SapCloudForCustomerSourceArgs', 'SapEccSourceArgs', 'ServiceNowSourceArgs', 'ShopifySourceArgs', 'SparkSourceArgs', 'SqlDWSourceArgs', 'SqlSourceArgs', 'SquareSourceArgs', 'VerticaSourceArgs', 'WebSourceArgs', 'XeroSourceArgs', 'ZohoSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'Copy'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="cloudDataMovementUnits")
    def cloud_data_movement_units(self) -> Optional[Any]:
        """
        Maximum number of cloud data movement units that can be used to perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "cloud_data_movement_units")

    @cloud_data_movement_units.setter
    def cloud_data_movement_units(self, value: Optional[Any]):
        pulumi.set(self, "cloud_data_movement_units", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableSkipIncompatibleRow")
    def enable_skip_incompatible_row(self) -> Optional[Any]:
        """
        Whether to skip incompatible row. Default value is false. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "enable_skip_incompatible_row")

    @enable_skip_incompatible_row.setter
    def enable_skip_incompatible_row(self, value: Optional[Any]):
        pulumi.set(self, "enable_skip_incompatible_row", value)

    @property
    @pulumi.getter(name="enableStaging")
    def enable_staging(self) -> Optional[Any]:
        """
        Specifies whether to copy data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "enable_staging")

    @enable_staging.setter
    def enable_staging(self, value: Optional[Any]):
        pulumi.set(self, "enable_staging", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetReferenceArgs']]]]:
        """
        List of inputs for the activity.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetReferenceArgs']]]]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetReferenceArgs']]]]:
        """
        List of outputs for the activity.
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetReferenceArgs']]]]):
        pulumi.set(self, "outputs", value)

    @property
    @pulumi.getter(name="parallelCopies")
    def parallel_copies(self) -> Optional[Any]:
        """
        Maximum number of concurrent sessions opened on the source or sink to avoid overloading the data store. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "parallel_copies")

    @parallel_copies.setter
    def parallel_copies(self, value: Optional[Any]):
        pulumi.set(self, "parallel_copies", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ActivityPolicyArgs']]:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ActivityPolicyArgs']]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="redirectIncompatibleRowSettings")
    def redirect_incompatible_row_settings(self) -> Optional[pulumi.Input['RedirectIncompatibleRowSettingsArgs']]:
        """
        Redirect incompatible row settings when EnableSkipIncompatibleRow is true.
        """
        return pulumi.get(self, "redirect_incompatible_row_settings")

    @redirect_incompatible_row_settings.setter
    def redirect_incompatible_row_settings(self, value: Optional[pulumi.Input['RedirectIncompatibleRowSettingsArgs']]):
        pulumi.set(self, "redirect_incompatible_row_settings", value)

    @property
    @pulumi.getter(name="stagingSettings")
    def staging_settings(self) -> Optional[pulumi.Input['StagingSettingsArgs']]:
        """
        Specifies interim staging settings when EnableStaging is true.
        """
        return pulumi.get(self, "staging_settings")

    @staging_settings.setter
    def staging_settings(self, value: Optional[pulumi.Input['StagingSettingsArgs']]):
        pulumi.set(self, "staging_settings", value)

    @property
    @pulumi.getter
    def translator(self) -> Optional[Any]:
        """
        Copy activity translator. If not specified, tabular translator is used.
        """
        return pulumi.get(self, "translator")

    @translator.setter
    def translator(self, value: Optional[Any]):
        pulumi.set(self, "translator", value)


@pulumi.input_type
class CosmosDbLinkedServiceArgs:
    def __init__(__self__, *,
                 connection_string: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None):
        """
        Microsoft Azure Cosmos Database (CosmosDB) linked service.
        :param Any connection_string: The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'CosmosDb'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'CosmosDb')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Any:
        """
        The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Any):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'CosmosDb'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class CouchbaseLinkedServiceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 connection_string: Optional[Any] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None):
        """
        Couchbase server linked service.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Couchbase'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param Any connection_string: An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "type", 'Couchbase')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Couchbase'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[Any]:
        """
        An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[Any]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class CouchbaseSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Couchbase server source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'CouchbaseSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'CouchbaseSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'CouchbaseSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class CouchbaseTableDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Couchbase server dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'CouchbaseTable'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'CouchbaseTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'CouchbaseTable'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class CustomActivityReferenceObjectArgs:
    def __init__(__self__, *,
                 datasets: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetReferenceArgs']]]] = None,
                 linked_services: Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]] = None):
        """
        Reference objects for custom activity
        :param pulumi.Input[Sequence[pulumi.Input['DatasetReferenceArgs']]] datasets: Dataset references.
        :param pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]] linked_services: Linked service references.
        """
        if datasets is not None:
            pulumi.set(__self__, "datasets", datasets)
        if linked_services is not None:
            pulumi.set(__self__, "linked_services", linked_services)

    @property
    @pulumi.getter
    def datasets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetReferenceArgs']]]]:
        """
        Dataset references.
        """
        return pulumi.get(self, "datasets")

    @datasets.setter
    def datasets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetReferenceArgs']]]]):
        pulumi.set(self, "datasets", value)

    @property
    @pulumi.getter(name="linkedServices")
    def linked_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]]:
        """
        Linked service references.
        """
        return pulumi.get(self, "linked_services")

    @linked_services.setter
    def linked_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]]):
        pulumi.set(self, "linked_services", value)


@pulumi.input_type
class CustomActivityArgs:
    def __init__(__self__, *,
                 command: Any,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 extended_properties: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 folder_path: Optional[Any] = None,
                 linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 policy: Optional[pulumi.Input['ActivityPolicyArgs']] = None,
                 reference_objects: Optional[pulumi.Input['CustomActivityReferenceObjectArgs']] = None,
                 resource_linked_service: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None):
        """
        Custom activity type.
        :param Any command: Command for custom activity Type: string (or Expression with resultType string).
        :param pulumi.Input[str] name: Activity name.
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'Custom'.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param pulumi.Input[Mapping[str, Any]] extended_properties: User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity has the full responsibility to consume and interpret the content defined.
        :param Any folder_path: Folder path for resource files Type: string (or Expression with resultType string).
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input['ActivityPolicyArgs'] policy: Activity policy.
        :param pulumi.Input['CustomActivityReferenceObjectArgs'] reference_objects: Reference objects
        :param pulumi.Input['LinkedServiceReferenceArgs'] resource_linked_service: Resource linked service reference.
        """
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'Custom')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if extended_properties is not None:
            pulumi.set(__self__, "extended_properties", extended_properties)
        if folder_path is not None:
            pulumi.set(__self__, "folder_path", folder_path)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if reference_objects is not None:
            pulumi.set(__self__, "reference_objects", reference_objects)
        if resource_linked_service is not None:
            pulumi.set(__self__, "resource_linked_service", resource_linked_service)

    @property
    @pulumi.getter
    def command(self) -> Any:
        """
        Command for custom activity Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Any):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'Custom'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="extendedProperties")
    def extended_properties(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity has the full responsibility to consume and interpret the content defined.
        """
        return pulumi.get(self, "extended_properties")

    @extended_properties.setter
    def extended_properties(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "extended_properties", value)

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> Optional[Any]:
        """
        Folder path for resource files Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "folder_path")

    @folder_path.setter
    def folder_path(self, value: Optional[Any]):
        pulumi.set(self, "folder_path", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ActivityPolicyArgs']]:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ActivityPolicyArgs']]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="referenceObjects")
    def reference_objects(self) -> Optional[pulumi.Input['CustomActivityReferenceObjectArgs']]:
        """
        Reference objects
        """
        return pulumi.get(self, "reference_objects")

    @reference_objects.setter
    def reference_objects(self, value: Optional[pulumi.Input['CustomActivityReferenceObjectArgs']]):
        pulumi.set(self, "reference_objects", value)

    @property
    @pulumi.getter(name="resourceLinkedService")
    def resource_linked_service(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Resource linked service reference.
        """
        return pulumi.get(self, "resource_linked_service")

    @resource_linked_service.setter
    def resource_linked_service(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "resource_linked_service", value)


@pulumi.input_type
class CustomDataSourceLinkedServiceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None):
        """
        Custom linked service.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'CustomDataSource'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "type", 'CustomDataSource')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'CustomDataSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class CustomDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        The custom dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'CustomDataset'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'CustomDataset')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'CustomDataset'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class DataLakeAnalyticsUSQLActivityArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 script_linked_service: pulumi.Input['LinkedServiceReferenceArgs'],
                 script_path: Any,
                 type: pulumi.Input[str],
                 compilation_mode: Optional[Any] = None,
                 degree_of_parallelism: Optional[Any] = None,
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 policy: Optional[pulumi.Input['ActivityPolicyArgs']] = None,
                 priority: Optional[Any] = None,
                 runtime_version: Optional[Any] = None):
        """
        Data Lake Analytics U-SQL activity.
        :param pulumi.Input[str] name: Activity name.
        :param pulumi.Input['LinkedServiceReferenceArgs'] script_linked_service: Script linked service reference.
        :param Any script_path: Case-sensitive path to folder that contains the U-SQL script. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'DataLakeAnalyticsU-SQL'.
        :param Any compilation_mode: Compilation mode of U-SQL. Must be one of these values : Semantic, Full and SingleBox. Type: string (or Expression with resultType string).
        :param Any degree_of_parallelism: The maximum number of nodes simultaneously used to run the job. Default value is 1. Type: integer (or Expression with resultType integer), minimum: 1.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[Mapping[str, Any]] parameters: Parameters for U-SQL job request.
        :param pulumi.Input['ActivityPolicyArgs'] policy: Activity policy.
        :param Any priority: Determines which jobs out of all that are queued should be selected to run first. The lower the number, the higher the priority. Default value is 1000. Type: integer (or Expression with resultType integer), minimum: 1.
        :param Any runtime_version: Runtime version of the U-SQL engine to use. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "script_linked_service", script_linked_service)
        pulumi.set(__self__, "script_path", script_path)
        pulumi.set(__self__, "type", 'DataLakeAnalyticsU-SQL')
        if compilation_mode is not None:
            pulumi.set(__self__, "compilation_mode", compilation_mode)
        if degree_of_parallelism is not None:
            pulumi.set(__self__, "degree_of_parallelism", degree_of_parallelism)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="scriptLinkedService")
    def script_linked_service(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Script linked service reference.
        """
        return pulumi.get(self, "script_linked_service")

    @script_linked_service.setter
    def script_linked_service(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "script_linked_service", value)

    @property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Any:
        """
        Case-sensitive path to folder that contains the U-SQL script. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "script_path")

    @script_path.setter
    def script_path(self, value: Any):
        pulumi.set(self, "script_path", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'DataLakeAnalyticsU-SQL'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="compilationMode")
    def compilation_mode(self) -> Optional[Any]:
        """
        Compilation mode of U-SQL. Must be one of these values : Semantic, Full and SingleBox. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "compilation_mode")

    @compilation_mode.setter
    def compilation_mode(self, value: Optional[Any]):
        pulumi.set(self, "compilation_mode", value)

    @property
    @pulumi.getter(name="degreeOfParallelism")
    def degree_of_parallelism(self) -> Optional[Any]:
        """
        The maximum number of nodes simultaneously used to run the job. Default value is 1. Type: integer (or Expression with resultType integer), minimum: 1.
        """
        return pulumi.get(self, "degree_of_parallelism")

    @degree_of_parallelism.setter
    def degree_of_parallelism(self, value: Optional[Any]):
        pulumi.set(self, "degree_of_parallelism", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Parameters for U-SQL job request.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ActivityPolicyArgs']]:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ActivityPolicyArgs']]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[Any]:
        """
        Determines which jobs out of all that are queued should be selected to run first. The lower the number, the higher the priority. Default value is 1000. Type: integer (or Expression with resultType integer), minimum: 1.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[Any]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[Any]:
        """
        Runtime version of the U-SQL engine to use. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[Any]):
        pulumi.set(self, "runtime_version", value)


@pulumi.input_type
class DatabricksNotebookActivityArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 notebook_path: Any,
                 type: pulumi.Input[str],
                 base_parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 policy: Optional[pulumi.Input['ActivityPolicyArgs']] = None):
        """
        DatabricksNotebook activity.
        :param pulumi.Input[str] name: Activity name.
        :param Any notebook_path: The absolute path of the notebook to be run in the Databricks Workspace. This path must begin with a slash. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'DatabricksNotebook'.
        :param pulumi.Input[Mapping[str, Any]] base_parameters: Base parameters to be used for each run of this job.If the notebook takes a parameter that is not specified, the default value from the notebook will be used.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input['ActivityPolicyArgs'] policy: Activity policy.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "notebook_path", notebook_path)
        pulumi.set(__self__, "type", 'DatabricksNotebook')
        if base_parameters is not None:
            pulumi.set(__self__, "base_parameters", base_parameters)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notebookPath")
    def notebook_path(self) -> Any:
        """
        The absolute path of the notebook to be run in the Databricks Workspace. This path must begin with a slash. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "notebook_path")

    @notebook_path.setter
    def notebook_path(self, value: Any):
        pulumi.set(self, "notebook_path", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'DatabricksNotebook'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="baseParameters")
    def base_parameters(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Base parameters to be used for each run of this job.If the notebook takes a parameter that is not specified, the default value from the notebook will be used.
        """
        return pulumi.get(self, "base_parameters")

    @base_parameters.setter
    def base_parameters(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "base_parameters", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ActivityPolicyArgs']]:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ActivityPolicyArgs']]):
        pulumi.set(self, "policy", value)


@pulumi.input_type
class DatasetBZip2CompressionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str]):
        """
        The BZip2 compression method used on a dataset.
        :param pulumi.Input[str] type: Type of dataset compression.
               Expected value is 'BZip2'.
        """
        pulumi.set(__self__, "type", 'BZip2')

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset compression.
        Expected value is 'BZip2'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DatasetDeflateCompressionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 level: Optional[pulumi.Input[Union[str, 'DatasetCompressionLevel']]] = None):
        """
        The Deflate compression method used on a dataset.
        :param pulumi.Input[str] type: Type of dataset compression.
               Expected value is 'Deflate'.
        :param pulumi.Input[Union[str, 'DatasetCompressionLevel']] level: The Deflate compression level.
        """
        pulumi.set(__self__, "type", 'Deflate')
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset compression.
        Expected value is 'Deflate'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[Union[str, 'DatasetCompressionLevel']]]:
        """
        The Deflate compression level.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[Union[str, 'DatasetCompressionLevel']]]):
        pulumi.set(self, "level", value)


@pulumi.input_type
class DatasetGZipCompressionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 level: Optional[pulumi.Input[Union[str, 'DatasetCompressionLevel']]] = None):
        """
        The GZip compression method used on a dataset.
        :param pulumi.Input[str] type: Type of dataset compression.
               Expected value is 'GZip'.
        :param pulumi.Input[Union[str, 'DatasetCompressionLevel']] level: The GZip compression level.
        """
        pulumi.set(__self__, "type", 'GZip')
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset compression.
        Expected value is 'GZip'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[Union[str, 'DatasetCompressionLevel']]]:
        """
        The GZip compression level.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[Union[str, 'DatasetCompressionLevel']]]):
        pulumi.set(self, "level", value)


@pulumi.input_type
class DatasetReferenceArgs:
    def __init__(__self__, *,
                 reference_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Dataset reference type.
        :param pulumi.Input[str] reference_name: Reference dataset name.
        :param pulumi.Input[str] type: Dataset reference type.
        :param pulumi.Input[Mapping[str, Any]] parameters: Arguments for dataset.
        """
        pulumi.set(__self__, "reference_name", reference_name)
        pulumi.set(__self__, "type", type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="referenceName")
    def reference_name(self) -> pulumi.Input[str]:
        """
        Reference dataset name.
        """
        return pulumi.get(self, "reference_name")

    @reference_name.setter
    def reference_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "reference_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Dataset reference type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Arguments for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DatasetZipDeflateCompressionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 level: Optional[pulumi.Input[Union[str, 'DatasetCompressionLevel']]] = None):
        """
        The ZipDeflate compression method used on a dataset.
        :param pulumi.Input[str] type: Type of dataset compression.
               Expected value is 'ZipDeflate'.
        :param pulumi.Input[Union[str, 'DatasetCompressionLevel']] level: The ZipDeflate compression level.
        """
        pulumi.set(__self__, "type", 'ZipDeflate')
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset compression.
        Expected value is 'ZipDeflate'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[Union[str, 'DatasetCompressionLevel']]]:
        """
        The ZipDeflate compression level.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[Union[str, 'DatasetCompressionLevel']]]):
        pulumi.set(self, "level", value)


@pulumi.input_type
class Db2LinkedServiceArgs:
    def __init__(__self__, *,
                 database: Any,
                 server: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 authentication_type: Optional[pulumi.Input[Union[str, 'Db2AuthenticationType']]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 username: Optional[Any] = None):
        """
        Linked service for DB2 data source.
        :param Any database: Database name for connection. Type: string (or Expression with resultType string).
        :param Any server: Server name for connection. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Db2'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[Union[str, 'Db2AuthenticationType']] authentication_type: AuthenticationType to be used for connection.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: Password for authentication.
        :param Any username: Username for authentication. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "type", 'Db2')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def database(self) -> Any:
        """
        Database name for connection. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Any):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def server(self) -> Any:
        """
        Server name for connection. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Any):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Db2'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[Union[str, 'Db2AuthenticationType']]]:
        """
        AuthenticationType to be used for connection.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[Union[str, 'Db2AuthenticationType']]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        Password for authentication.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        Username for authentication. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[Any]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class DistcpSettingsArgs:
    def __init__(__self__, *,
                 resource_manager_endpoint: Any,
                 temp_script_path: Any,
                 distcp_options: Optional[Any] = None):
        """
        Distcp settings.
        :param Any resource_manager_endpoint: Specifies the Yarn ResourceManager endpoint. Type: string (or Expression with resultType string).
        :param Any temp_script_path: Specifies an existing folder path which will be used to store temp Distcp command script. The script file is generated by ADF and will be removed after Copy job finished. Type: string (or Expression with resultType string).
        :param Any distcp_options: Specifies the Distcp options. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "resource_manager_endpoint", resource_manager_endpoint)
        pulumi.set(__self__, "temp_script_path", temp_script_path)
        if distcp_options is not None:
            pulumi.set(__self__, "distcp_options", distcp_options)

    @property
    @pulumi.getter(name="resourceManagerEndpoint")
    def resource_manager_endpoint(self) -> Any:
        """
        Specifies the Yarn ResourceManager endpoint. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "resource_manager_endpoint")

    @resource_manager_endpoint.setter
    def resource_manager_endpoint(self, value: Any):
        pulumi.set(self, "resource_manager_endpoint", value)

    @property
    @pulumi.getter(name="tempScriptPath")
    def temp_script_path(self) -> Any:
        """
        Specifies an existing folder path which will be used to store temp Distcp command script. The script file is generated by ADF and will be removed after Copy job finished. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "temp_script_path")

    @temp_script_path.setter
    def temp_script_path(self, value: Any):
        pulumi.set(self, "temp_script_path", value)

    @property
    @pulumi.getter(name="distcpOptions")
    def distcp_options(self) -> Optional[Any]:
        """
        Specifies the Distcp options. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "distcp_options")

    @distcp_options.setter
    def distcp_options(self, value: Optional[Any]):
        pulumi.set(self, "distcp_options", value)


@pulumi.input_type
class DocumentDbCollectionDatasetArgs:
    def __init__(__self__, *,
                 collection_name: Any,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Microsoft Azure Document Database Collection dataset.
        :param Any collection_name: Document Database collection name. Type: string (or Expression with resultType string).
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'DocumentDbCollection'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "collection_name", collection_name)
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'DocumentDbCollection')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="collectionName")
    def collection_name(self) -> Any:
        """
        Document Database collection name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "collection_name")

    @collection_name.setter
    def collection_name(self, value: Any):
        pulumi.set(self, "collection_name", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'DocumentDbCollection'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class DocumentDbCollectionSinkArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 nesting_separator: Optional[Any] = None,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity Document Database Collection sink.
        :param pulumi.Input[str] type: Copy sink type.
               Expected value is 'DocumentDbCollectionSink'.
        :param Any nesting_separator: Nested properties separator. Default is . (dot). Type: string (or Expression with resultType string).
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'DocumentDbCollectionSink')
        if nesting_separator is not None:
            pulumi.set(__self__, "nesting_separator", nesting_separator)
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy sink type.
        Expected value is 'DocumentDbCollectionSink'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="nestingSeparator")
    def nesting_separator(self) -> Optional[Any]:
        """
        Nested properties separator. Default is . (dot). Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "nesting_separator")

    @nesting_separator.setter
    def nesting_separator(self, value: Optional[Any]):
        pulumi.set(self, "nesting_separator", value)

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @sink_retry_count.setter
    def sink_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_count", value)

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @sink_retry_wait.setter
    def sink_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_wait", value)

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @write_batch_size.setter
    def write_batch_size(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_size", value)

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")

    @write_batch_timeout.setter
    def write_batch_timeout(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_timeout", value)


@pulumi.input_type
class DocumentDbCollectionSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 nesting_separator: Optional[Any] = None,
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Document Database Collection source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'DocumentDbCollectionSource'.
        :param Any nesting_separator: Nested properties separator. Type: string (or Expression with resultType string).
        :param Any query: Documents query. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'DocumentDbCollectionSource')
        if nesting_separator is not None:
            pulumi.set(__self__, "nesting_separator", nesting_separator)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'DocumentDbCollectionSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="nestingSeparator")
    def nesting_separator(self) -> Optional[Any]:
        """
        Nested properties separator. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "nesting_separator")

    @nesting_separator.setter
    def nesting_separator(self, value: Optional[Any]):
        pulumi.set(self, "nesting_separator", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        Documents query. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class DrillLinkedServiceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 connection_string: Optional[Any] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None):
        """
        Drill server linked service.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Drill'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param Any connection_string: An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "type", 'Drill')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Drill'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[Any]:
        """
        An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[Any]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DrillSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Drill server source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'DrillSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'DrillSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'DrillSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class DrillTableDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Drill server dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'DrillTable'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'DrillTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'DrillTable'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class DynamicsEntityDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entity_name: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        The Dynamics entity dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'DynamicsEntity'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param Any entity_name: The logical name of the entity. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'DynamicsEntity')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entity_name is not None:
            pulumi.set(__self__, "entity_name", entity_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'DynamicsEntity'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="entityName")
    def entity_name(self) -> Optional[Any]:
        """
        The logical name of the entity. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "entity_name")

    @entity_name.setter
    def entity_name(self, value: Optional[Any]):
        pulumi.set(self, "entity_name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class DynamicsLinkedServiceArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[Union[str, 'DynamicsAuthenticationType']],
                 deployment_type: pulumi.Input[Union[str, 'DynamicsDeploymentType']],
                 type: pulumi.Input[str],
                 username: Any,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 host_name: Optional[Any] = None,
                 organization_name: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 port: Optional[Any] = None,
                 service_uri: Optional[Any] = None):
        """
        Dynamics linked service.
        :param pulumi.Input[Union[str, 'DynamicsAuthenticationType']] authentication_type: The authentication type to connect to Dynamics server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario. Type: string (or Expression with resultType string).
        :param pulumi.Input[Union[str, 'DynamicsDeploymentType']] deployment_type: The deployment type of the Dynamics instance. 'Online' for Dynamics Online and 'OnPremisesWithIfd' for Dynamics on-premises with Ifd. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Dynamics'.
        :param Any username: User name to access the Dynamics instance. Type: string (or Expression with resultType string).
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Any host_name: The host name of the on-premises Dynamics server. The property is required for on-prem and not allowed for online. Type: string (or Expression with resultType string).
        :param Any organization_name: The organization name of the Dynamics instance. The property is required for on-prem and required for online when there are more than one Dynamics instances associated with the user. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: Password to access the Dynamics instance.
        :param Any port: The port of on-premises Dynamics server. The property is required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any service_uri: The URL to the Microsoft Dynamics server. The property is required for on-line and not allowed for on-prem. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "deployment_type", deployment_type)
        pulumi.set(__self__, "type", 'Dynamics')
        pulumi.set(__self__, "username", username)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[Union[str, 'DynamicsAuthenticationType']]:
        """
        The authentication type to connect to Dynamics server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[Union[str, 'DynamicsAuthenticationType']]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Input[Union[str, 'DynamicsDeploymentType']]:
        """
        The deployment type of the Dynamics instance. 'Online' for Dynamics Online and 'OnPremisesWithIfd' for Dynamics on-premises with Ifd. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: pulumi.Input[Union[str, 'DynamicsDeploymentType']]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Dynamics'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def username(self) -> Any:
        """
        User name to access the Dynamics instance. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Any):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[Any]:
        """
        The host name of the on-premises Dynamics server. The property is required for on-prem and not allowed for online. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[Any]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[Any]:
        """
        The organization name of the Dynamics instance. The property is required for on-prem and required for online when there are more than one Dynamics instances associated with the user. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "organization_name")

    @organization_name.setter
    def organization_name(self, value: Optional[Any]):
        pulumi.set(self, "organization_name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        Password to access the Dynamics instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The port of on-premises Dynamics server. The property is required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[Any]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[Any]:
        """
        The URL to the Microsoft Dynamics server. The property is required for on-line and not allowed for on-prem. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: Optional[Any]):
        pulumi.set(self, "service_uri", value)


@pulumi.input_type
class DynamicsSinkArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 write_behavior: pulumi.Input[Union[str, 'DynamicsSinkWriteBehavior']],
                 ignore_null_values: Optional[Any] = None,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity Dynamics sink.
        :param pulumi.Input[str] type: Copy sink type.
               Expected value is 'DynamicsSink'.
        :param pulumi.Input[Union[str, 'DynamicsSinkWriteBehavior']] write_behavior: The write behavior for the operation.
        :param Any ignore_null_values: The flag indicating whether ignore null values from input dataset (except key fields) during write operation. Default is false. Type: boolean (or Expression with resultType boolean).
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'DynamicsSink')
        pulumi.set(__self__, "write_behavior", write_behavior)
        if ignore_null_values is not None:
            pulumi.set(__self__, "ignore_null_values", ignore_null_values)
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy sink type.
        Expected value is 'DynamicsSink'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="writeBehavior")
    def write_behavior(self) -> pulumi.Input[Union[str, 'DynamicsSinkWriteBehavior']]:
        """
        The write behavior for the operation.
        """
        return pulumi.get(self, "write_behavior")

    @write_behavior.setter
    def write_behavior(self, value: pulumi.Input[Union[str, 'DynamicsSinkWriteBehavior']]):
        pulumi.set(self, "write_behavior", value)

    @property
    @pulumi.getter(name="ignoreNullValues")
    def ignore_null_values(self) -> Optional[Any]:
        """
        The flag indicating whether ignore null values from input dataset (except key fields) during write operation. Default is false. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "ignore_null_values")

    @ignore_null_values.setter
    def ignore_null_values(self, value: Optional[Any]):
        pulumi.set(self, "ignore_null_values", value)

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @sink_retry_count.setter
    def sink_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_count", value)

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @sink_retry_wait.setter
    def sink_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_wait", value)

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @write_batch_size.setter
    def write_batch_size(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_size", value)

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")

    @write_batch_timeout.setter
    def write_batch_timeout(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_timeout", value)


@pulumi.input_type
class DynamicsSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Dynamics source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'DynamicsSource'.
        :param Any query: FetchXML is a proprietary query language that is used in Microsoft Dynamics (online & on-premises). Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'DynamicsSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'DynamicsSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        FetchXML is a proprietary query language that is used in Microsoft Dynamics (online & on-premises). Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class EloquaLinkedServiceArgs:
    def __init__(__self__, *,
                 endpoint: Any,
                 type: pulumi.Input[str],
                 username: Any,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Eloqua server linked service.
        :param Any endpoint: The endpoint of the Eloqua server. (i.e. eloqua.example.com)
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Eloqua'.
        :param Any username: The site name and user name of your Eloqua account in the form: sitename/username. (i.e. Eloqua/Alice)
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: The password corresponding to the user name.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "type", 'Eloqua')
        pulumi.set(__self__, "username", username)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter
    def endpoint(self) -> Any:
        """
        The endpoint of the Eloqua server. (i.e. eloqua.example.com)
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Any):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Eloqua'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def username(self) -> Any:
        """
        The site name and user name of your Eloqua account in the form: sitename/username. (i.e. Eloqua/Alice)
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Any):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The password corresponding to the user name.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @use_encrypted_endpoints.setter
    def use_encrypted_endpoints(self, value: Optional[Any]):
        pulumi.set(self, "use_encrypted_endpoints", value)

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_host_verification")

    @use_host_verification.setter
    def use_host_verification(self, value: Optional[Any]):
        pulumi.set(self, "use_host_verification", value)

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_peer_verification")

    @use_peer_verification.setter
    def use_peer_verification(self, value: Optional[Any]):
        pulumi.set(self, "use_peer_verification", value)


@pulumi.input_type
class EloquaObjectDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Eloqua server dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'EloquaObject'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'EloquaObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'EloquaObject'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class EloquaSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Eloqua server source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'EloquaSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'EloquaSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'EloquaSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class EntityReferenceArgs:
    def __init__(__self__, *,
                 reference_name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'IntegrationRuntimeEntityReferenceType']]] = None):
        """
        The entity reference.
        :param pulumi.Input[str] reference_name: The name of this referenced entity.
        :param pulumi.Input[Union[str, 'IntegrationRuntimeEntityReferenceType']] type: The type of this referenced entity.
        """
        if reference_name is not None:
            pulumi.set(__self__, "reference_name", reference_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="referenceName")
    def reference_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this referenced entity.
        """
        return pulumi.get(self, "reference_name")

    @reference_name.setter
    def reference_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reference_name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'IntegrationRuntimeEntityReferenceType']]]:
        """
        The type of this referenced entity.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'IntegrationRuntimeEntityReferenceType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ExecutePipelineActivityArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 pipeline: pulumi.Input['PipelineReferenceArgs'],
                 type: pulumi.Input[str],
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 wait_on_completion: Optional[pulumi.Input[bool]] = None):
        """
        Execute pipeline activity.
        :param pulumi.Input[str] name: Activity name.
        :param pulumi.Input['PipelineReferenceArgs'] pipeline: Pipeline reference.
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'ExecutePipeline'.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param pulumi.Input[Mapping[str, Any]] parameters: Pipeline parameters.
        :param pulumi.Input[bool] wait_on_completion: Defines whether activity execution will wait for the dependent pipeline execution to finish. Default is false.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pipeline", pipeline)
        pulumi.set(__self__, "type", 'ExecutePipeline')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if wait_on_completion is not None:
            pulumi.set(__self__, "wait_on_completion", wait_on_completion)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def pipeline(self) -> pulumi.Input['PipelineReferenceArgs']:
        """
        Pipeline reference.
        """
        return pulumi.get(self, "pipeline")

    @pipeline.setter
    def pipeline(self, value: pulumi.Input['PipelineReferenceArgs']):
        pulumi.set(self, "pipeline", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'ExecutePipeline'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Pipeline parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="waitOnCompletion")
    def wait_on_completion(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether activity execution will wait for the dependent pipeline execution to finish. Default is false.
        """
        return pulumi.get(self, "wait_on_completion")

    @wait_on_completion.setter
    def wait_on_completion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_on_completion", value)


@pulumi.input_type
class ExecuteSSISPackageActivityArgs:
    def __init__(__self__, *,
                 connect_via: pulumi.Input['IntegrationRuntimeReferenceArgs'],
                 name: pulumi.Input[str],
                 package_location: pulumi.Input['SSISPackageLocationArgs'],
                 type: pulumi.Input[str],
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_path: Optional[Any] = None,
                 execution_credential: Optional[pulumi.Input['SSISExecutionCredentialArgs']] = None,
                 linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 log_location: Optional[pulumi.Input['SSISLogLocationArgs']] = None,
                 logging_level: Optional[Any] = None,
                 package_connection_managers: Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, pulumi.Input['SSISExecutionParameterArgs']]]]]] = None,
                 package_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['SSISExecutionParameterArgs']]]] = None,
                 policy: Optional[pulumi.Input['ActivityPolicyArgs']] = None,
                 project_connection_managers: Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, pulumi.Input['SSISExecutionParameterArgs']]]]]] = None,
                 project_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['SSISExecutionParameterArgs']]]] = None,
                 property_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input['SSISPropertyOverrideArgs']]]] = None,
                 runtime: Optional[Any] = None):
        """
        Execute SSIS package activity.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] name: Activity name.
        :param pulumi.Input['SSISPackageLocationArgs'] package_location: SSIS package location.
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'ExecuteSSISPackage'.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param Any environment_path: The environment path to execute the SSIS package. Type: string (or Expression with resultType string).
        :param pulumi.Input['SSISExecutionCredentialArgs'] execution_credential: The package execution credential.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input['SSISLogLocationArgs'] log_location: SSIS package execution log location.
        :param Any logging_level: The logging level of SSIS package execution. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, pulumi.Input['SSISExecutionParameterArgs']]]]] package_connection_managers: The package level connection managers to execute the SSIS package.
        :param pulumi.Input[Mapping[str, pulumi.Input['SSISExecutionParameterArgs']]] package_parameters: The package level parameters to execute the SSIS package.
        :param pulumi.Input['ActivityPolicyArgs'] policy: Activity policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, pulumi.Input['SSISExecutionParameterArgs']]]]] project_connection_managers: The project level connection managers to execute the SSIS package.
        :param pulumi.Input[Mapping[str, pulumi.Input['SSISExecutionParameterArgs']]] project_parameters: The project level parameters to execute the SSIS package.
        :param pulumi.Input[Mapping[str, pulumi.Input['SSISPropertyOverrideArgs']]] property_overrides: The property overrides to execute the SSIS package.
        :param Any runtime: Specifies the runtime to execute SSIS package. The value should be "x86" or "x64". Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "connect_via", connect_via)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "package_location", package_location)
        pulumi.set(__self__, "type", 'ExecuteSSISPackage')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_path is not None:
            pulumi.set(__self__, "environment_path", environment_path)
        if execution_credential is not None:
            pulumi.set(__self__, "execution_credential", execution_credential)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if log_location is not None:
            pulumi.set(__self__, "log_location", log_location)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if package_connection_managers is not None:
            pulumi.set(__self__, "package_connection_managers", package_connection_managers)
        if package_parameters is not None:
            pulumi.set(__self__, "package_parameters", package_parameters)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if project_connection_managers is not None:
            pulumi.set(__self__, "project_connection_managers", project_connection_managers)
        if project_parameters is not None:
            pulumi.set(__self__, "project_parameters", project_parameters)
        if property_overrides is not None:
            pulumi.set(__self__, "property_overrides", property_overrides)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> pulumi.Input['IntegrationRuntimeReferenceArgs']:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: pulumi.Input['IntegrationRuntimeReferenceArgs']):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="packageLocation")
    def package_location(self) -> pulumi.Input['SSISPackageLocationArgs']:
        """
        SSIS package location.
        """
        return pulumi.get(self, "package_location")

    @package_location.setter
    def package_location(self, value: pulumi.Input['SSISPackageLocationArgs']):
        pulumi.set(self, "package_location", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'ExecuteSSISPackage'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentPath")
    def environment_path(self) -> Optional[Any]:
        """
        The environment path to execute the SSIS package. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "environment_path")

    @environment_path.setter
    def environment_path(self, value: Optional[Any]):
        pulumi.set(self, "environment_path", value)

    @property
    @pulumi.getter(name="executionCredential")
    def execution_credential(self) -> Optional[pulumi.Input['SSISExecutionCredentialArgs']]:
        """
        The package execution credential.
        """
        return pulumi.get(self, "execution_credential")

    @execution_credential.setter
    def execution_credential(self, value: Optional[pulumi.Input['SSISExecutionCredentialArgs']]):
        pulumi.set(self, "execution_credential", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter(name="logLocation")
    def log_location(self) -> Optional[pulumi.Input['SSISLogLocationArgs']]:
        """
        SSIS package execution log location.
        """
        return pulumi.get(self, "log_location")

    @log_location.setter
    def log_location(self, value: Optional[pulumi.Input['SSISLogLocationArgs']]):
        pulumi.set(self, "log_location", value)

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[Any]:
        """
        The logging level of SSIS package execution. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "logging_level")

    @logging_level.setter
    def logging_level(self, value: Optional[Any]):
        pulumi.set(self, "logging_level", value)

    @property
    @pulumi.getter(name="packageConnectionManagers")
    def package_connection_managers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, pulumi.Input['SSISExecutionParameterArgs']]]]]]:
        """
        The package level connection managers to execute the SSIS package.
        """
        return pulumi.get(self, "package_connection_managers")

    @package_connection_managers.setter
    def package_connection_managers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, pulumi.Input['SSISExecutionParameterArgs']]]]]]):
        pulumi.set(self, "package_connection_managers", value)

    @property
    @pulumi.getter(name="packageParameters")
    def package_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['SSISExecutionParameterArgs']]]]:
        """
        The package level parameters to execute the SSIS package.
        """
        return pulumi.get(self, "package_parameters")

    @package_parameters.setter
    def package_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['SSISExecutionParameterArgs']]]]):
        pulumi.set(self, "package_parameters", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ActivityPolicyArgs']]:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ActivityPolicyArgs']]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="projectConnectionManagers")
    def project_connection_managers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, pulumi.Input['SSISExecutionParameterArgs']]]]]]:
        """
        The project level connection managers to execute the SSIS package.
        """
        return pulumi.get(self, "project_connection_managers")

    @project_connection_managers.setter
    def project_connection_managers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, pulumi.Input['SSISExecutionParameterArgs']]]]]]):
        pulumi.set(self, "project_connection_managers", value)

    @property
    @pulumi.getter(name="projectParameters")
    def project_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['SSISExecutionParameterArgs']]]]:
        """
        The project level parameters to execute the SSIS package.
        """
        return pulumi.get(self, "project_parameters")

    @project_parameters.setter
    def project_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['SSISExecutionParameterArgs']]]]):
        pulumi.set(self, "project_parameters", value)

    @property
    @pulumi.getter(name="propertyOverrides")
    def property_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['SSISPropertyOverrideArgs']]]]:
        """
        The property overrides to execute the SSIS package.
        """
        return pulumi.get(self, "property_overrides")

    @property_overrides.setter
    def property_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['SSISPropertyOverrideArgs']]]]):
        pulumi.set(self, "property_overrides", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[Any]:
        """
        Specifies the runtime to execute SSIS package. The value should be "x86" or "x64". Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[Any]):
        pulumi.set(self, "runtime", value)


@pulumi.input_type
class ExecutionActivityArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 policy: Optional[pulumi.Input['ActivityPolicyArgs']] = None):
        """
        Base class for all execution activities.
        :param pulumi.Input[str] name: Activity name.
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'Execution'.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input['ActivityPolicyArgs'] policy: Activity policy.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'Execution')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'Execution'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ActivityPolicyArgs']]:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ActivityPolicyArgs']]):
        pulumi.set(self, "policy", value)


@pulumi.input_type
class ExpressionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Azure Data Factory expression definition.
        :param pulumi.Input[str] type: Expression type.
        :param pulumi.Input[str] value: Expression value.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Expression type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Expression value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class FactoryIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['FactoryIdentityType']):
        """
        Identity properties of the factory resource.
        :param pulumi.Input['FactoryIdentityType'] type: The identity type. Currently the only supported type is 'SystemAssigned'.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['FactoryIdentityType']:
        """
        The identity type. Currently the only supported type is 'SystemAssigned'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['FactoryIdentityType']):
        pulumi.set(self, "type", value)


@pulumi.input_type
class FactoryVSTSConfigurationArgs:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[str]] = None,
                 collaboration_branch: Optional[pulumi.Input[str]] = None,
                 last_commit_id: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 repository_name: Optional[pulumi.Input[str]] = None,
                 root_folder: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Factory's VSTS repo information.
        :param pulumi.Input[str] account_name: VSTS account name.
        :param pulumi.Input[str] collaboration_branch: VSTS collaboration branch.
        :param pulumi.Input[str] last_commit_id: VSTS last commit id.
        :param pulumi.Input[str] project_name: VSTS project name.
        :param pulumi.Input[str] repository_name: VSTS repository name.
        :param pulumi.Input[str] root_folder: VSTS root folder.
        :param pulumi.Input[str] tenant_id: VSTS tenant id.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if collaboration_branch is not None:
            pulumi.set(__self__, "collaboration_branch", collaboration_branch)
        if last_commit_id is not None:
            pulumi.set(__self__, "last_commit_id", last_commit_id)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)
        if root_folder is not None:
            pulumi.set(__self__, "root_folder", root_folder)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        VSTS account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="collaborationBranch")
    def collaboration_branch(self) -> Optional[pulumi.Input[str]]:
        """
        VSTS collaboration branch.
        """
        return pulumi.get(self, "collaboration_branch")

    @collaboration_branch.setter
    def collaboration_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collaboration_branch", value)

    @property
    @pulumi.getter(name="lastCommitId")
    def last_commit_id(self) -> Optional[pulumi.Input[str]]:
        """
        VSTS last commit id.
        """
        return pulumi.get(self, "last_commit_id")

    @last_commit_id.setter
    def last_commit_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_commit_id", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        VSTS project name.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[pulumi.Input[str]]:
        """
        VSTS repository name.
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_name", value)

    @property
    @pulumi.getter(name="rootFolder")
    def root_folder(self) -> Optional[pulumi.Input[str]]:
        """
        VSTS root folder.
        """
        return pulumi.get(self, "root_folder")

    @root_folder.setter
    def root_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_folder", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        VSTS tenant id.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class FileServerLinkedServiceArgs:
    def __init__(__self__, *,
                 host: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 user_id: Optional[Any] = None):
        """
        File system linked service.
        :param Any host: Host name of the server. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'FileServer'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: Password to logon the server.
        :param Any user_id: User ID to logon the server. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'FileServer')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        Host name of the server. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Any):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'FileServer'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        Password to logon the server.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[Any]:
        """
        User ID to logon the server. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[Any]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class FileShareDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 compression: Optional[pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 file_filter: Optional[Any] = None,
                 file_name: Optional[Any] = None,
                 folder_path: Optional[Any] = None,
                 format: Optional[pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        An on-premises file system dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'FileShare'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']] compression: The data compression method used for the file system.
        :param pulumi.Input[str] description: Dataset description.
        :param Any file_filter: Specify a filter to be used to select a subset of files in the folderPath rather than all files. Type: string (or Expression with resultType string).
        :param Any file_name: The name of the on-premises file system. Type: string (or Expression with resultType string).
        :param Any folder_path: The path of the on-premises file system. Type: string (or Expression with resultType string).
        :param pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']] format: The format of the files.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'FileShare')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_filter is not None:
            pulumi.set(__self__, "file_filter", file_filter)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if folder_path is not None:
            pulumi.set(__self__, "folder_path", folder_path)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'FileShare'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']]]:
        """
        The data compression method used for the file system.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fileFilter")
    def file_filter(self) -> Optional[Any]:
        """
        Specify a filter to be used to select a subset of files in the folderPath rather than all files. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "file_filter")

    @file_filter.setter
    def file_filter(self, value: Optional[Any]):
        pulumi.set(self, "file_filter", value)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[Any]:
        """
        The name of the on-premises file system. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: Optional[Any]):
        pulumi.set(self, "file_name", value)

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> Optional[Any]:
        """
        The path of the on-premises file system. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "folder_path")

    @folder_path.setter
    def folder_path(self, value: Optional[Any]):
        pulumi.set(self, "folder_path", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']]]:
        """
        The format of the files.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class FileSystemSinkArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 copy_behavior: Optional[Any] = None,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity file system sink.
        :param pulumi.Input[str] type: Copy sink type.
               Expected value is 'FileSystemSink'.
        :param Any copy_behavior: The type of copy behavior for copy sink.
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'FileSystemSink')
        if copy_behavior is not None:
            pulumi.set(__self__, "copy_behavior", copy_behavior)
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy sink type.
        Expected value is 'FileSystemSink'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="copyBehavior")
    def copy_behavior(self) -> Optional[Any]:
        """
        The type of copy behavior for copy sink.
        """
        return pulumi.get(self, "copy_behavior")

    @copy_behavior.setter
    def copy_behavior(self, value: Optional[Any]):
        pulumi.set(self, "copy_behavior", value)

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @sink_retry_count.setter
    def sink_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_count", value)

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @sink_retry_wait.setter
    def sink_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_wait", value)

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @write_batch_size.setter
    def write_batch_size(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_size", value)

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")

    @write_batch_timeout.setter
    def write_batch_timeout(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_timeout", value)


@pulumi.input_type
class FileSystemSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 recursive: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity file system source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'FileSystemSource'.
        :param Any recursive: If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'FileSystemSource')
        if recursive is not None:
            pulumi.set(__self__, "recursive", recursive)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'FileSystemSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def recursive(self) -> Optional[Any]:
        """
        If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "recursive")

    @recursive.setter
    def recursive(self, value: Optional[Any]):
        pulumi.set(self, "recursive", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class FilterActivityArgs:
    def __init__(__self__, *,
                 condition: pulumi.Input['ExpressionArgs'],
                 items: pulumi.Input['ExpressionArgs'],
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        Filter and return results from input array based on the conditions.
        :param pulumi.Input['ExpressionArgs'] condition: Condition to be used for filtering the input.
        :param pulumi.Input['ExpressionArgs'] items: Input array on which filter should be applied.
        :param pulumi.Input[str] name: Activity name.
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'Filter'.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'Filter')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input['ExpressionArgs']:
        """
        Condition to be used for filtering the input.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input['ExpressionArgs']):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input['ExpressionArgs']:
        """
        Input array on which filter should be applied.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input['ExpressionArgs']):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'Filter'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ForEachActivityArgs:
    def __init__(__self__, *,
                 activities: pulumi.Input[Sequence[pulumi.Input[Union['AzureMLBatchExecutionActivityArgs', 'AzureMLUpdateResourceActivityArgs', 'ControlActivityArgs', 'CopyActivityArgs', 'CustomActivityArgs', 'DataLakeAnalyticsUSQLActivityArgs', 'DatabricksNotebookActivityArgs', 'ExecutePipelineActivityArgs', 'ExecuteSSISPackageActivityArgs', 'ExecutionActivityArgs', 'FilterActivityArgs', 'ForEachActivityArgs', 'GetMetadataActivityArgs', 'HDInsightHiveActivityArgs', 'HDInsightMapReduceActivityArgs', 'HDInsightPigActivityArgs', 'HDInsightSparkActivityArgs', 'HDInsightStreamingActivityArgs', 'IfConditionActivityArgs', 'LookupActivityArgs', 'SqlServerStoredProcedureActivityArgs', 'UntilActivityArgs', 'WaitActivityArgs', 'WebActivityArgs']]]],
                 items: pulumi.Input['ExpressionArgs'],
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 batch_count: Optional[pulumi.Input[int]] = None,
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_sequential: Optional[pulumi.Input[bool]] = None):
        """
        This activity is used for iterating over a collection and execute given activities.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureMLBatchExecutionActivityArgs', 'AzureMLUpdateResourceActivityArgs', 'ControlActivityArgs', 'CopyActivityArgs', 'CustomActivityArgs', 'DataLakeAnalyticsUSQLActivityArgs', 'DatabricksNotebookActivityArgs', 'ExecutePipelineActivityArgs', 'ExecuteSSISPackageActivityArgs', 'ExecutionActivityArgs', 'FilterActivityArgs', 'ForEachActivityArgs', 'GetMetadataActivityArgs', 'HDInsightHiveActivityArgs', 'HDInsightMapReduceActivityArgs', 'HDInsightPigActivityArgs', 'HDInsightSparkActivityArgs', 'HDInsightStreamingActivityArgs', 'IfConditionActivityArgs', 'LookupActivityArgs', 'SqlServerStoredProcedureActivityArgs', 'UntilActivityArgs', 'WaitActivityArgs', 'WebActivityArgs']]]] activities: List of activities to execute .
        :param pulumi.Input['ExpressionArgs'] items: Collection to iterate.
        :param pulumi.Input[str] name: Activity name.
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'ForEach'.
        :param pulumi.Input[int] batch_count: Batch count to be used for controlling the number of parallel execution (when isSequential is set to false).
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param pulumi.Input[bool] is_sequential: Should the loop be executed in sequence or in parallel (max 50)
        """
        pulumi.set(__self__, "activities", activities)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'ForEach')
        if batch_count is not None:
            pulumi.set(__self__, "batch_count", batch_count)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_sequential is not None:
            pulumi.set(__self__, "is_sequential", is_sequential)

    @property
    @pulumi.getter
    def activities(self) -> pulumi.Input[Sequence[pulumi.Input[Union['AzureMLBatchExecutionActivityArgs', 'AzureMLUpdateResourceActivityArgs', 'ControlActivityArgs', 'CopyActivityArgs', 'CustomActivityArgs', 'DataLakeAnalyticsUSQLActivityArgs', 'DatabricksNotebookActivityArgs', 'ExecutePipelineActivityArgs', 'ExecuteSSISPackageActivityArgs', 'ExecutionActivityArgs', 'FilterActivityArgs', 'ForEachActivityArgs', 'GetMetadataActivityArgs', 'HDInsightHiveActivityArgs', 'HDInsightMapReduceActivityArgs', 'HDInsightPigActivityArgs', 'HDInsightSparkActivityArgs', 'HDInsightStreamingActivityArgs', 'IfConditionActivityArgs', 'LookupActivityArgs', 'SqlServerStoredProcedureActivityArgs', 'UntilActivityArgs', 'WaitActivityArgs', 'WebActivityArgs']]]]:
        """
        List of activities to execute .
        """
        return pulumi.get(self, "activities")

    @activities.setter
    def activities(self, value: pulumi.Input[Sequence[pulumi.Input[Union['AzureMLBatchExecutionActivityArgs', 'AzureMLUpdateResourceActivityArgs', 'ControlActivityArgs', 'CopyActivityArgs', 'CustomActivityArgs', 'DataLakeAnalyticsUSQLActivityArgs', 'DatabricksNotebookActivityArgs', 'ExecutePipelineActivityArgs', 'ExecuteSSISPackageActivityArgs', 'ExecutionActivityArgs', 'FilterActivityArgs', 'ForEachActivityArgs', 'GetMetadataActivityArgs', 'HDInsightHiveActivityArgs', 'HDInsightMapReduceActivityArgs', 'HDInsightPigActivityArgs', 'HDInsightSparkActivityArgs', 'HDInsightStreamingActivityArgs', 'IfConditionActivityArgs', 'LookupActivityArgs', 'SqlServerStoredProcedureActivityArgs', 'UntilActivityArgs', 'WaitActivityArgs', 'WebActivityArgs']]]]):
        pulumi.set(self, "activities", value)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input['ExpressionArgs']:
        """
        Collection to iterate.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input['ExpressionArgs']):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'ForEach'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="batchCount")
    def batch_count(self) -> Optional[pulumi.Input[int]]:
        """
        Batch count to be used for controlling the number of parallel execution (when isSequential is set to false).
        """
        return pulumi.get(self, "batch_count")

    @batch_count.setter
    def batch_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_count", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isSequential")
    def is_sequential(self) -> Optional[pulumi.Input[bool]]:
        """
        Should the loop be executed in sequence or in parallel (max 50)
        """
        return pulumi.get(self, "is_sequential")

    @is_sequential.setter
    def is_sequential(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_sequential", value)


@pulumi.input_type
class FtpServerLinkedServiceArgs:
    def __init__(__self__, *,
                 host: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 authentication_type: Optional[pulumi.Input[Union[str, 'FtpAuthenticationType']]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_server_certificate_validation: Optional[Any] = None,
                 enable_ssl: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 port: Optional[Any] = None,
                 user_name: Optional[Any] = None):
        """
        A FTP server Linked Service.
        :param Any host: Host name of the FTP server. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'FtpServer'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[Union[str, 'FtpAuthenticationType']] authentication_type: The authentication type to be used to connect to the FTP server.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any enable_server_certificate_validation: If true, validate the FTP server SSL certificate when connect over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType boolean).
        :param Any enable_ssl: If true, connect to the FTP server over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType boolean).
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: Password to logon the FTP server.
        :param Any port: The TCP port number that the FTP server uses to listen for client connections. Default value is 21. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any user_name: Username to logon the FTP server. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'FtpServer')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_server_certificate_validation is not None:
            pulumi.set(__self__, "enable_server_certificate_validation", enable_server_certificate_validation)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        Host name of the FTP server. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Any):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'FtpServer'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[Union[str, 'FtpAuthenticationType']]]:
        """
        The authentication type to be used to connect to the FTP server.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[Union[str, 'FtpAuthenticationType']]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableServerCertificateValidation")
    def enable_server_certificate_validation(self) -> Optional[Any]:
        """
        If true, validate the FTP server SSL certificate when connect over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "enable_server_certificate_validation")

    @enable_server_certificate_validation.setter
    def enable_server_certificate_validation(self, value: Optional[Any]):
        pulumi.set(self, "enable_server_certificate_validation", value)

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[Any]:
        """
        If true, connect to the FTP server over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "enable_ssl")

    @enable_ssl.setter
    def enable_ssl(self, value: Optional[Any]):
        pulumi.set(self, "enable_ssl", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        Password to logon the FTP server.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port number that the FTP server uses to listen for client connections. Default value is 21. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[Any]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[Any]:
        """
        Username to logon the FTP server. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[Any]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class GetMetadataActivityArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input['DatasetReferenceArgs'],
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 field_list: Optional[pulumi.Input[Sequence[Any]]] = None,
                 linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 policy: Optional[pulumi.Input['ActivityPolicyArgs']] = None):
        """
        Activity to get metadata of dataset
        :param pulumi.Input['DatasetReferenceArgs'] dataset: GetMetadata activity dataset reference.
        :param pulumi.Input[str] name: Activity name.
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'GetMetadata'.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param pulumi.Input[Sequence[Any]] field_list: Fields of metadata to get from dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input['ActivityPolicyArgs'] policy: Activity policy.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'GetMetadata')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if field_list is not None:
            pulumi.set(__self__, "field_list", field_list)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Input['DatasetReferenceArgs']:
        """
        GetMetadata activity dataset reference.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input['DatasetReferenceArgs']):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'GetMetadata'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fieldList")
    def field_list(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        Fields of metadata to get from dataset.
        """
        return pulumi.get(self, "field_list")

    @field_list.setter
    def field_list(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "field_list", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ActivityPolicyArgs']]:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ActivityPolicyArgs']]):
        pulumi.set(self, "policy", value)


@pulumi.input_type
class GoogleBigQueryLinkedServiceArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[Union[str, 'GoogleBigQueryAuthenticationType']],
                 project: Any,
                 type: pulumi.Input[str],
                 additional_projects: Optional[Any] = None,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 client_id: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 client_secret: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 key_file_path: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 refresh_token: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 request_google_drive_scope: Optional[Any] = None,
                 trusted_cert_path: Optional[Any] = None,
                 use_system_trust_store: Optional[Any] = None):
        """
        Google BigQuery service linked service.
        :param pulumi.Input[Union[str, 'GoogleBigQueryAuthenticationType']] authentication_type: The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
        :param Any project: The default BigQuery project to query against.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'GoogleBigQuery'.
        :param Any additional_projects: A comma-separated list of public BigQuery projects to access.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] client_id: The client id of the google application used to acquire the refresh token.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] client_secret: The client secret of the google application used to acquire the refresh token.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any email: The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Any key_file_path: The full path to the .p12 key file that is used to authenticate the service account email address and can only be used on self-hosted IR.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] refresh_token: The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
        :param Any request_google_drive_scope: Whether to request access to Google Drive. Allowing Google Drive access enables support for federated tables that combine BigQuery data with data from Google Drive. The default value is false.
        :param Any trusted_cert_path: The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        :param Any use_system_trust_store: Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "type", 'GoogleBigQuery')
        if additional_projects is not None:
            pulumi.set(__self__, "additional_projects", additional_projects)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if key_file_path is not None:
            pulumi.set(__self__, "key_file_path", key_file_path)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if request_google_drive_scope is not None:
            pulumi.set(__self__, "request_google_drive_scope", request_google_drive_scope)
        if trusted_cert_path is not None:
            pulumi.set(__self__, "trusted_cert_path", trusted_cert_path)
        if use_system_trust_store is not None:
            pulumi.set(__self__, "use_system_trust_store", use_system_trust_store)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[Union[str, 'GoogleBigQueryAuthenticationType']]:
        """
        The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[Union[str, 'GoogleBigQueryAuthenticationType']]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter
    def project(self) -> Any:
        """
        The default BigQuery project to query against.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Any):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'GoogleBigQuery'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="additionalProjects")
    def additional_projects(self) -> Optional[Any]:
        """
        A comma-separated list of public BigQuery projects to access.
        """
        return pulumi.get(self, "additional_projects")

    @additional_projects.setter
    def additional_projects(self, value: Optional[Any]):
        pulumi.set(self, "additional_projects", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The client id of the google application used to acquire the refresh token.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The client secret of the google application used to acquire the refresh token.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[Any]:
        """
        The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[Any]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter(name="keyFilePath")
    def key_file_path(self) -> Optional[Any]:
        """
        The full path to the .p12 key file that is used to authenticate the service account email address and can only be used on self-hosted IR.
        """
        return pulumi.get(self, "key_file_path")

    @key_file_path.setter
    def key_file_path(self, value: Optional[Any]):
        pulumi.set(self, "key_file_path", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "refresh_token", value)

    @property
    @pulumi.getter(name="requestGoogleDriveScope")
    def request_google_drive_scope(self) -> Optional[Any]:
        """
        Whether to request access to Google Drive. Allowing Google Drive access enables support for federated tables that combine BigQuery data with data from Google Drive. The default value is false.
        """
        return pulumi.get(self, "request_google_drive_scope")

    @request_google_drive_scope.setter
    def request_google_drive_scope(self, value: Optional[Any]):
        pulumi.set(self, "request_google_drive_scope", value)

    @property
    @pulumi.getter(name="trustedCertPath")
    def trusted_cert_path(self) -> Optional[Any]:
        """
        The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        """
        return pulumi.get(self, "trusted_cert_path")

    @trusted_cert_path.setter
    def trusted_cert_path(self, value: Optional[Any]):
        pulumi.set(self, "trusted_cert_path", value)

    @property
    @pulumi.getter(name="useSystemTrustStore")
    def use_system_trust_store(self) -> Optional[Any]:
        """
        Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        """
        return pulumi.get(self, "use_system_trust_store")

    @use_system_trust_store.setter
    def use_system_trust_store(self, value: Optional[Any]):
        pulumi.set(self, "use_system_trust_store", value)


@pulumi.input_type
class GoogleBigQueryObjectDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Google BigQuery service dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'GoogleBigQueryObject'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'GoogleBigQueryObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'GoogleBigQueryObject'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class GoogleBigQuerySourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Google BigQuery service source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'GoogleBigQuerySource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'GoogleBigQuerySource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'GoogleBigQuerySource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class GreenplumLinkedServiceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 connection_string: Optional[Any] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None):
        """
        Greenplum Database linked service.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Greenplum'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param Any connection_string: An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "type", 'Greenplum')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Greenplum'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[Any]:
        """
        An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[Any]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class GreenplumSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Greenplum Database source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'GreenplumSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'GreenplumSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'GreenplumSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class GreenplumTableDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Greenplum Database dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'GreenplumTable'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'GreenplumTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'GreenplumTable'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class HBaseLinkedServiceArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[Union[str, 'HBaseAuthenticationType']],
                 host: Any,
                 type: pulumi.Input[str],
                 allow_host_name_cn_mismatch: Optional[Any] = None,
                 allow_self_signed_server_cert: Optional[Any] = None,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_ssl: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 http_path: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 port: Optional[Any] = None,
                 trusted_cert_path: Optional[Any] = None,
                 username: Optional[Any] = None):
        """
        HBase server linked service.
        :param pulumi.Input[Union[str, 'HBaseAuthenticationType']] authentication_type: The authentication mechanism to use to connect to the HBase server.
        :param Any host: The IP address or host name of the HBase server. (i.e. 192.168.222.160)
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'HBase'.
        :param Any allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        :param Any allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from the server. The default value is false.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Any http_path: The partial URL corresponding to the HBase server. (i.e. /gateway/sandbox/hbase/version)
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: The password corresponding to the user name.
        :param Any port: The TCP port that the HBase instance uses to listen for client connections. The default value is 9090.
        :param Any trusted_cert_path: The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        :param Any username: The user name used to connect to the HBase instance.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'HBase')
        if allow_host_name_cn_mismatch is not None:
            pulumi.set(__self__, "allow_host_name_cn_mismatch", allow_host_name_cn_mismatch)
        if allow_self_signed_server_cert is not None:
            pulumi.set(__self__, "allow_self_signed_server_cert", allow_self_signed_server_cert)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if http_path is not None:
            pulumi.set(__self__, "http_path", http_path)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if trusted_cert_path is not None:
            pulumi.set(__self__, "trusted_cert_path", trusted_cert_path)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[Union[str, 'HBaseAuthenticationType']]:
        """
        The authentication mechanism to use to connect to the HBase server.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[Union[str, 'HBaseAuthenticationType']]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        The IP address or host name of the HBase server. (i.e. 192.168.222.160)
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Any):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'HBase'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="allowHostNameCNMismatch")
    def allow_host_name_cn_mismatch(self) -> Optional[Any]:
        """
        Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        """
        return pulumi.get(self, "allow_host_name_cn_mismatch")

    @allow_host_name_cn_mismatch.setter
    def allow_host_name_cn_mismatch(self, value: Optional[Any]):
        pulumi.set(self, "allow_host_name_cn_mismatch", value)

    @property
    @pulumi.getter(name="allowSelfSignedServerCert")
    def allow_self_signed_server_cert(self) -> Optional[Any]:
        """
        Specifies whether to allow self-signed certificates from the server. The default value is false.
        """
        return pulumi.get(self, "allow_self_signed_server_cert")

    @allow_self_signed_server_cert.setter
    def allow_self_signed_server_cert(self, value: Optional[Any]):
        pulumi.set(self, "allow_self_signed_server_cert", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[Any]:
        """
        Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        """
        return pulumi.get(self, "enable_ssl")

    @enable_ssl.setter
    def enable_ssl(self, value: Optional[Any]):
        pulumi.set(self, "enable_ssl", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter(name="httpPath")
    def http_path(self) -> Optional[Any]:
        """
        The partial URL corresponding to the HBase server. (i.e. /gateway/sandbox/hbase/version)
        """
        return pulumi.get(self, "http_path")

    @http_path.setter
    def http_path(self, value: Optional[Any]):
        pulumi.set(self, "http_path", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The password corresponding to the user name.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port that the HBase instance uses to listen for client connections. The default value is 9090.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[Any]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="trustedCertPath")
    def trusted_cert_path(self) -> Optional[Any]:
        """
        The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        """
        return pulumi.get(self, "trusted_cert_path")

    @trusted_cert_path.setter
    def trusted_cert_path(self, value: Optional[Any]):
        pulumi.set(self, "trusted_cert_path", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        The user name used to connect to the HBase instance.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[Any]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class HBaseObjectDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        HBase server dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'HBaseObject'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'HBaseObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'HBaseObject'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class HBaseSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity HBase server source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'HBaseSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'HBaseSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'HBaseSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class HDInsightHiveActivityArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 arguments: Optional[pulumi.Input[Sequence[Any]]] = None,
                 defines: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 get_debug_info: Optional[pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']]] = None,
                 linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 policy: Optional[pulumi.Input['ActivityPolicyArgs']] = None,
                 script_linked_service: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 script_path: Optional[Any] = None,
                 storage_linked_services: Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]] = None):
        """
        HDInsight Hive activity type.
        :param pulumi.Input[str] name: Activity name.
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'HDInsightHive'.
        :param pulumi.Input[Sequence[Any]] arguments: User specified arguments to HDInsightActivity.
        :param pulumi.Input[Mapping[str, Any]] defines: Allows user to specify defines for Hive job request.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']] get_debug_info: Debug info option.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input['ActivityPolicyArgs'] policy: Activity policy.
        :param pulumi.Input['LinkedServiceReferenceArgs'] script_linked_service: Script linked service reference.
        :param Any script_path: Script path. Type: string (or Expression with resultType string).
        :param pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]] storage_linked_services: Storage linked service references.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'HDInsightHive')
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if defines is not None:
            pulumi.set(__self__, "defines", defines)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if get_debug_info is not None:
            pulumi.set(__self__, "get_debug_info", get_debug_info)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if script_linked_service is not None:
            pulumi.set(__self__, "script_linked_service", script_linked_service)
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)
        if storage_linked_services is not None:
            pulumi.set(__self__, "storage_linked_services", storage_linked_services)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'HDInsightHive'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        User specified arguments to HDInsightActivity.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter
    def defines(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Allows user to specify defines for Hive job request.
        """
        return pulumi.get(self, "defines")

    @defines.setter
    def defines(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defines", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="getDebugInfo")
    def get_debug_info(self) -> Optional[pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']]]:
        """
        Debug info option.
        """
        return pulumi.get(self, "get_debug_info")

    @get_debug_info.setter
    def get_debug_info(self, value: Optional[pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']]]):
        pulumi.set(self, "get_debug_info", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ActivityPolicyArgs']]:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ActivityPolicyArgs']]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="scriptLinkedService")
    def script_linked_service(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Script linked service reference.
        """
        return pulumi.get(self, "script_linked_service")

    @script_linked_service.setter
    def script_linked_service(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "script_linked_service", value)

    @property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[Any]:
        """
        Script path. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "script_path")

    @script_path.setter
    def script_path(self, value: Optional[Any]):
        pulumi.set(self, "script_path", value)

    @property
    @pulumi.getter(name="storageLinkedServices")
    def storage_linked_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]]:
        """
        Storage linked service references.
        """
        return pulumi.get(self, "storage_linked_services")

    @storage_linked_services.setter
    def storage_linked_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]]):
        pulumi.set(self, "storage_linked_services", value)


@pulumi.input_type
class HDInsightLinkedServiceArgs:
    def __init__(__self__, *,
                 cluster_uri: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 hcatalog_linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 user_name: Optional[Any] = None):
        """
        HDInsight linked service.
        :param Any cluster_uri: HDInsight cluster URI. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'HDInsight'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input['LinkedServiceReferenceArgs'] hcatalog_linked_service_name: A reference to the Azure SQL linked service that points to the HCatalog database.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: The Azure Storage linked service reference.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: HDInsight cluster password.
        :param Any user_name: HDInsight cluster user name. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "cluster_uri", cluster_uri)
        pulumi.set(__self__, "type", 'HDInsight')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if hcatalog_linked_service_name is not None:
            pulumi.set(__self__, "hcatalog_linked_service_name", hcatalog_linked_service_name)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="clusterUri")
    def cluster_uri(self) -> Any:
        """
        HDInsight cluster URI. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "cluster_uri")

    @cluster_uri.setter
    def cluster_uri(self, value: Any):
        pulumi.set(self, "cluster_uri", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'HDInsight'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter(name="hcatalogLinkedServiceName")
    def hcatalog_linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        A reference to the Azure SQL linked service that points to the HCatalog database.
        """
        return pulumi.get(self, "hcatalog_linked_service_name")

    @hcatalog_linked_service_name.setter
    def hcatalog_linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "hcatalog_linked_service_name", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        The Azure Storage linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        HDInsight cluster password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[Any]:
        """
        HDInsight cluster user name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[Any]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class HDInsightMapReduceActivityArgs:
    def __init__(__self__, *,
                 class_name: Any,
                 jar_file_path: Any,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 arguments: Optional[pulumi.Input[Sequence[Any]]] = None,
                 defines: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 get_debug_info: Optional[pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']]] = None,
                 jar_libs: Optional[pulumi.Input[Sequence[Any]]] = None,
                 jar_linked_service: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 policy: Optional[pulumi.Input['ActivityPolicyArgs']] = None,
                 storage_linked_services: Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]] = None):
        """
        HDInsight MapReduce activity type.
        :param Any class_name: Class name. Type: string (or Expression with resultType string).
        :param Any jar_file_path: Jar path. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] name: Activity name.
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'HDInsightMapReduce'.
        :param pulumi.Input[Sequence[Any]] arguments: User specified arguments to HDInsightActivity.
        :param pulumi.Input[Mapping[str, Any]] defines: Allows user to specify defines for the MapReduce job request.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']] get_debug_info: Debug info option.
        :param pulumi.Input[Sequence[Any]] jar_libs: Jar libs.
        :param pulumi.Input['LinkedServiceReferenceArgs'] jar_linked_service: Jar linked service reference.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input['ActivityPolicyArgs'] policy: Activity policy.
        :param pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]] storage_linked_services: Storage linked service references.
        """
        pulumi.set(__self__, "class_name", class_name)
        pulumi.set(__self__, "jar_file_path", jar_file_path)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'HDInsightMapReduce')
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if defines is not None:
            pulumi.set(__self__, "defines", defines)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if get_debug_info is not None:
            pulumi.set(__self__, "get_debug_info", get_debug_info)
        if jar_libs is not None:
            pulumi.set(__self__, "jar_libs", jar_libs)
        if jar_linked_service is not None:
            pulumi.set(__self__, "jar_linked_service", jar_linked_service)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if storage_linked_services is not None:
            pulumi.set(__self__, "storage_linked_services", storage_linked_services)

    @property
    @pulumi.getter(name="className")
    def class_name(self) -> Any:
        """
        Class name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "class_name")

    @class_name.setter
    def class_name(self, value: Any):
        pulumi.set(self, "class_name", value)

    @property
    @pulumi.getter(name="jarFilePath")
    def jar_file_path(self) -> Any:
        """
        Jar path. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "jar_file_path")

    @jar_file_path.setter
    def jar_file_path(self, value: Any):
        pulumi.set(self, "jar_file_path", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'HDInsightMapReduce'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        User specified arguments to HDInsightActivity.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter
    def defines(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Allows user to specify defines for the MapReduce job request.
        """
        return pulumi.get(self, "defines")

    @defines.setter
    def defines(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defines", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="getDebugInfo")
    def get_debug_info(self) -> Optional[pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']]]:
        """
        Debug info option.
        """
        return pulumi.get(self, "get_debug_info")

    @get_debug_info.setter
    def get_debug_info(self, value: Optional[pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']]]):
        pulumi.set(self, "get_debug_info", value)

    @property
    @pulumi.getter(name="jarLibs")
    def jar_libs(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        Jar libs.
        """
        return pulumi.get(self, "jar_libs")

    @jar_libs.setter
    def jar_libs(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "jar_libs", value)

    @property
    @pulumi.getter(name="jarLinkedService")
    def jar_linked_service(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Jar linked service reference.
        """
        return pulumi.get(self, "jar_linked_service")

    @jar_linked_service.setter
    def jar_linked_service(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "jar_linked_service", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ActivityPolicyArgs']]:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ActivityPolicyArgs']]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="storageLinkedServices")
    def storage_linked_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]]:
        """
        Storage linked service references.
        """
        return pulumi.get(self, "storage_linked_services")

    @storage_linked_services.setter
    def storage_linked_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]]):
        pulumi.set(self, "storage_linked_services", value)


@pulumi.input_type
class HDInsightOnDemandLinkedServiceArgs:
    def __init__(__self__, *,
                 cluster_resource_group: Any,
                 cluster_size: Any,
                 host_subscription_id: Any,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 tenant: Any,
                 time_to_live: Any,
                 type: pulumi.Input[str],
                 version: Any,
                 additional_linked_service_names: Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 cluster_name_prefix: Optional[Any] = None,
                 cluster_password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 cluster_ssh_password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 cluster_ssh_user_name: Optional[Any] = None,
                 cluster_type: Optional[Any] = None,
                 cluster_user_name: Optional[Any] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 core_configuration: Optional[Any] = None,
                 data_node_size: Optional[Any] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 h_base_configuration: Optional[Any] = None,
                 hcatalog_linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 hdfs_configuration: Optional[Any] = None,
                 head_node_size: Optional[Any] = None,
                 hive_configuration: Optional[Any] = None,
                 map_reduce_configuration: Optional[Any] = None,
                 oozie_configuration: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 service_principal_id: Optional[Any] = None,
                 service_principal_key: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 spark_version: Optional[Any] = None,
                 storm_configuration: Optional[Any] = None,
                 yarn_configuration: Optional[Any] = None,
                 zookeeper_node_size: Optional[Any] = None):
        """
        HDInsight ondemand linked service.
        :param Any cluster_resource_group: The resource group where the cluster belongs. Type: string (or Expression with resultType string).
        :param Any cluster_size: Number of worker/data nodes in the cluster. Suggestion value: 4. Type: string (or Expression with resultType string).
        :param Any host_subscription_id: The customer’s subscription to host the cluster. Type: string (or Expression with resultType string).
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Azure Storage linked service to be used by the on-demand cluster for storing and processing data.
        :param Any tenant: The Tenant id/name to which the service principal belongs. Type: string (or Expression with resultType string).
        :param Any time_to_live: The allowed idle time for the on-demand HDInsight cluster. Specifies how long the on-demand HDInsight cluster stays alive after completion of an activity run if there are no other active jobs in the cluster. The minimum value is 5 mins. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'HDInsightOnDemand'.
        :param Any version: Version of the HDInsight cluster.  Type: string (or Expression with resultType string).
        :param pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]] additional_linked_service_names: Specifies additional storage accounts for the HDInsight linked service so that the Data Factory service can register them on your behalf.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param Any cluster_name_prefix: The prefix of cluster name, postfix will be distinct with timestamp. Type: string (or Expression with resultType string).
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] cluster_password: The password to access the cluster.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] cluster_ssh_password: The password to SSH remotely connect cluster’s node (for Linux).
        :param Any cluster_ssh_user_name: The username to SSH remotely connect to cluster’s node (for Linux). Type: string (or Expression with resultType string).
        :param Any cluster_type: The cluster type. Type: string (or Expression with resultType string).
        :param Any cluster_user_name: The username to access the cluster. Type: string (or Expression with resultType string).
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param Any core_configuration: Specifies the core configuration parameters (as in core-site.xml) for the HDInsight cluster to be created.
        :param Any data_node_size: Specifies the size of the data node for the HDInsight cluster.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Any h_base_configuration: Specifies the HBase configuration parameters (hbase-site.xml) for the HDInsight cluster.
        :param pulumi.Input['LinkedServiceReferenceArgs'] hcatalog_linked_service_name: The name of Azure SQL linked service that point to the HCatalog database. The on-demand HDInsight cluster is created by using the Azure SQL database as the metastore.
        :param Any hdfs_configuration: Specifies the HDFS configuration parameters (hdfs-site.xml) for the HDInsight cluster.
        :param Any head_node_size: Specifies the size of the head node for the HDInsight cluster.
        :param Any hive_configuration: Specifies the hive configuration parameters (hive-site.xml) for the HDInsight cluster.
        :param Any map_reduce_configuration: Specifies the MapReduce configuration parameters (mapred-site.xml) for the HDInsight cluster.
        :param Any oozie_configuration: Specifies the Oozie configuration parameters (oozie-site.xml) for the HDInsight cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param Any service_principal_id: The service principal id for the hostSubscriptionId. Type: string (or Expression with resultType string).
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] service_principal_key: The key for the service principal id.
        :param Any spark_version: The version of spark if the cluster type is 'spark'. Type: string (or Expression with resultType string).
        :param Any storm_configuration: Specifies the Storm configuration parameters (storm-site.xml) for the HDInsight cluster.
        :param Any yarn_configuration: Specifies the Yarn configuration parameters (yarn-site.xml) for the HDInsight cluster.
        :param Any zookeeper_node_size: Specifies the size of the Zoo Keeper node for the HDInsight cluster.
        """
        pulumi.set(__self__, "cluster_resource_group", cluster_resource_group)
        pulumi.set(__self__, "cluster_size", cluster_size)
        pulumi.set(__self__, "host_subscription_id", host_subscription_id)
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "tenant", tenant)
        pulumi.set(__self__, "time_to_live", time_to_live)
        pulumi.set(__self__, "type", 'HDInsightOnDemand')
        pulumi.set(__self__, "version", version)
        if additional_linked_service_names is not None:
            pulumi.set(__self__, "additional_linked_service_names", additional_linked_service_names)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cluster_name_prefix is not None:
            pulumi.set(__self__, "cluster_name_prefix", cluster_name_prefix)
        if cluster_password is not None:
            pulumi.set(__self__, "cluster_password", cluster_password)
        if cluster_ssh_password is not None:
            pulumi.set(__self__, "cluster_ssh_password", cluster_ssh_password)
        if cluster_ssh_user_name is not None:
            pulumi.set(__self__, "cluster_ssh_user_name", cluster_ssh_user_name)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if cluster_user_name is not None:
            pulumi.set(__self__, "cluster_user_name", cluster_user_name)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if core_configuration is not None:
            pulumi.set(__self__, "core_configuration", core_configuration)
        if data_node_size is not None:
            pulumi.set(__self__, "data_node_size", data_node_size)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if h_base_configuration is not None:
            pulumi.set(__self__, "h_base_configuration", h_base_configuration)
        if hcatalog_linked_service_name is not None:
            pulumi.set(__self__, "hcatalog_linked_service_name", hcatalog_linked_service_name)
        if hdfs_configuration is not None:
            pulumi.set(__self__, "hdfs_configuration", hdfs_configuration)
        if head_node_size is not None:
            pulumi.set(__self__, "head_node_size", head_node_size)
        if hive_configuration is not None:
            pulumi.set(__self__, "hive_configuration", hive_configuration)
        if map_reduce_configuration is not None:
            pulumi.set(__self__, "map_reduce_configuration", map_reduce_configuration)
        if oozie_configuration is not None:
            pulumi.set(__self__, "oozie_configuration", oozie_configuration)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if spark_version is not None:
            pulumi.set(__self__, "spark_version", spark_version)
        if storm_configuration is not None:
            pulumi.set(__self__, "storm_configuration", storm_configuration)
        if yarn_configuration is not None:
            pulumi.set(__self__, "yarn_configuration", yarn_configuration)
        if zookeeper_node_size is not None:
            pulumi.set(__self__, "zookeeper_node_size", zookeeper_node_size)

    @property
    @pulumi.getter(name="clusterResourceGroup")
    def cluster_resource_group(self) -> Any:
        """
        The resource group where the cluster belongs. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "cluster_resource_group")

    @cluster_resource_group.setter
    def cluster_resource_group(self, value: Any):
        pulumi.set(self, "cluster_resource_group", value)

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Any:
        """
        Number of worker/data nodes in the cluster. Suggestion value: 4. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: Any):
        pulumi.set(self, "cluster_size", value)

    @property
    @pulumi.getter(name="hostSubscriptionId")
    def host_subscription_id(self) -> Any:
        """
        The customer’s subscription to host the cluster. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "host_subscription_id")

    @host_subscription_id.setter
    def host_subscription_id(self, value: Any):
        pulumi.set(self, "host_subscription_id", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Azure Storage linked service to be used by the on-demand cluster for storing and processing data.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def tenant(self) -> Any:
        """
        The Tenant id/name to which the service principal belongs. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Any):
        pulumi.set(self, "tenant", value)

    @property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> Any:
        """
        The allowed idle time for the on-demand HDInsight cluster. Specifies how long the on-demand HDInsight cluster stays alive after completion of an activity run if there are no other active jobs in the cluster. The minimum value is 5 mins. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "time_to_live")

    @time_to_live.setter
    def time_to_live(self, value: Any):
        pulumi.set(self, "time_to_live", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'HDInsightOnDemand'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> Any:
        """
        Version of the HDInsight cluster.  Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Any):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="additionalLinkedServiceNames")
    def additional_linked_service_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]]:
        """
        Specifies additional storage accounts for the HDInsight linked service so that the Data Factory service can register them on your behalf.
        """
        return pulumi.get(self, "additional_linked_service_names")

    @additional_linked_service_names.setter
    def additional_linked_service_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]]):
        pulumi.set(self, "additional_linked_service_names", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="clusterNamePrefix")
    def cluster_name_prefix(self) -> Optional[Any]:
        """
        The prefix of cluster name, postfix will be distinct with timestamp. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "cluster_name_prefix")

    @cluster_name_prefix.setter
    def cluster_name_prefix(self, value: Optional[Any]):
        pulumi.set(self, "cluster_name_prefix", value)

    @property
    @pulumi.getter(name="clusterPassword")
    def cluster_password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The password to access the cluster.
        """
        return pulumi.get(self, "cluster_password")

    @cluster_password.setter
    def cluster_password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "cluster_password", value)

    @property
    @pulumi.getter(name="clusterSshPassword")
    def cluster_ssh_password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The password to SSH remotely connect cluster’s node (for Linux).
        """
        return pulumi.get(self, "cluster_ssh_password")

    @cluster_ssh_password.setter
    def cluster_ssh_password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "cluster_ssh_password", value)

    @property
    @pulumi.getter(name="clusterSshUserName")
    def cluster_ssh_user_name(self) -> Optional[Any]:
        """
        The username to SSH remotely connect to cluster’s node (for Linux). Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "cluster_ssh_user_name")

    @cluster_ssh_user_name.setter
    def cluster_ssh_user_name(self, value: Optional[Any]):
        pulumi.set(self, "cluster_ssh_user_name", value)

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[Any]:
        """
        The cluster type. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[Any]):
        pulumi.set(self, "cluster_type", value)

    @property
    @pulumi.getter(name="clusterUserName")
    def cluster_user_name(self) -> Optional[Any]:
        """
        The username to access the cluster. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "cluster_user_name")

    @cluster_user_name.setter
    def cluster_user_name(self, value: Optional[Any]):
        pulumi.set(self, "cluster_user_name", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter(name="coreConfiguration")
    def core_configuration(self) -> Optional[Any]:
        """
        Specifies the core configuration parameters (as in core-site.xml) for the HDInsight cluster to be created.
        """
        return pulumi.get(self, "core_configuration")

    @core_configuration.setter
    def core_configuration(self, value: Optional[Any]):
        pulumi.set(self, "core_configuration", value)

    @property
    @pulumi.getter(name="dataNodeSize")
    def data_node_size(self) -> Optional[Any]:
        """
        Specifies the size of the data node for the HDInsight cluster.
        """
        return pulumi.get(self, "data_node_size")

    @data_node_size.setter
    def data_node_size(self, value: Optional[Any]):
        pulumi.set(self, "data_node_size", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter(name="hBaseConfiguration")
    def h_base_configuration(self) -> Optional[Any]:
        """
        Specifies the HBase configuration parameters (hbase-site.xml) for the HDInsight cluster.
        """
        return pulumi.get(self, "h_base_configuration")

    @h_base_configuration.setter
    def h_base_configuration(self, value: Optional[Any]):
        pulumi.set(self, "h_base_configuration", value)

    @property
    @pulumi.getter(name="hcatalogLinkedServiceName")
    def hcatalog_linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        The name of Azure SQL linked service that point to the HCatalog database. The on-demand HDInsight cluster is created by using the Azure SQL database as the metastore.
        """
        return pulumi.get(self, "hcatalog_linked_service_name")

    @hcatalog_linked_service_name.setter
    def hcatalog_linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "hcatalog_linked_service_name", value)

    @property
    @pulumi.getter(name="hdfsConfiguration")
    def hdfs_configuration(self) -> Optional[Any]:
        """
        Specifies the HDFS configuration parameters (hdfs-site.xml) for the HDInsight cluster.
        """
        return pulumi.get(self, "hdfs_configuration")

    @hdfs_configuration.setter
    def hdfs_configuration(self, value: Optional[Any]):
        pulumi.set(self, "hdfs_configuration", value)

    @property
    @pulumi.getter(name="headNodeSize")
    def head_node_size(self) -> Optional[Any]:
        """
        Specifies the size of the head node for the HDInsight cluster.
        """
        return pulumi.get(self, "head_node_size")

    @head_node_size.setter
    def head_node_size(self, value: Optional[Any]):
        pulumi.set(self, "head_node_size", value)

    @property
    @pulumi.getter(name="hiveConfiguration")
    def hive_configuration(self) -> Optional[Any]:
        """
        Specifies the hive configuration parameters (hive-site.xml) for the HDInsight cluster.
        """
        return pulumi.get(self, "hive_configuration")

    @hive_configuration.setter
    def hive_configuration(self, value: Optional[Any]):
        pulumi.set(self, "hive_configuration", value)

    @property
    @pulumi.getter(name="mapReduceConfiguration")
    def map_reduce_configuration(self) -> Optional[Any]:
        """
        Specifies the MapReduce configuration parameters (mapred-site.xml) for the HDInsight cluster.
        """
        return pulumi.get(self, "map_reduce_configuration")

    @map_reduce_configuration.setter
    def map_reduce_configuration(self, value: Optional[Any]):
        pulumi.set(self, "map_reduce_configuration", value)

    @property
    @pulumi.getter(name="oozieConfiguration")
    def oozie_configuration(self) -> Optional[Any]:
        """
        Specifies the Oozie configuration parameters (oozie-site.xml) for the HDInsight cluster.
        """
        return pulumi.get(self, "oozie_configuration")

    @oozie_configuration.setter
    def oozie_configuration(self, value: Optional[Any]):
        pulumi.set(self, "oozie_configuration", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[Any]:
        """
        The service principal id for the hostSubscriptionId. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[Any]):
        pulumi.set(self, "service_principal_id", value)

    @property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The key for the service principal id.
        """
        return pulumi.get(self, "service_principal_key")

    @service_principal_key.setter
    def service_principal_key(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "service_principal_key", value)

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> Optional[Any]:
        """
        The version of spark if the cluster type is 'spark'. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "spark_version")

    @spark_version.setter
    def spark_version(self, value: Optional[Any]):
        pulumi.set(self, "spark_version", value)

    @property
    @pulumi.getter(name="stormConfiguration")
    def storm_configuration(self) -> Optional[Any]:
        """
        Specifies the Storm configuration parameters (storm-site.xml) for the HDInsight cluster.
        """
        return pulumi.get(self, "storm_configuration")

    @storm_configuration.setter
    def storm_configuration(self, value: Optional[Any]):
        pulumi.set(self, "storm_configuration", value)

    @property
    @pulumi.getter(name="yarnConfiguration")
    def yarn_configuration(self) -> Optional[Any]:
        """
        Specifies the Yarn configuration parameters (yarn-site.xml) for the HDInsight cluster.
        """
        return pulumi.get(self, "yarn_configuration")

    @yarn_configuration.setter
    def yarn_configuration(self, value: Optional[Any]):
        pulumi.set(self, "yarn_configuration", value)

    @property
    @pulumi.getter(name="zookeeperNodeSize")
    def zookeeper_node_size(self) -> Optional[Any]:
        """
        Specifies the size of the Zoo Keeper node for the HDInsight cluster.
        """
        return pulumi.get(self, "zookeeper_node_size")

    @zookeeper_node_size.setter
    def zookeeper_node_size(self, value: Optional[Any]):
        pulumi.set(self, "zookeeper_node_size", value)


@pulumi.input_type
class HDInsightPigActivityArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 arguments: Optional[pulumi.Input[Sequence[Any]]] = None,
                 defines: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 get_debug_info: Optional[pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']]] = None,
                 linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 policy: Optional[pulumi.Input['ActivityPolicyArgs']] = None,
                 script_linked_service: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 script_path: Optional[Any] = None,
                 storage_linked_services: Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]] = None):
        """
        HDInsight Pig activity type.
        :param pulumi.Input[str] name: Activity name.
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'HDInsightPig'.
        :param pulumi.Input[Sequence[Any]] arguments: User specified arguments to HDInsightActivity.
        :param pulumi.Input[Mapping[str, Any]] defines: Allows user to specify defines for Pig job request.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']] get_debug_info: Debug info option.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input['ActivityPolicyArgs'] policy: Activity policy.
        :param pulumi.Input['LinkedServiceReferenceArgs'] script_linked_service: Script linked service reference.
        :param Any script_path: Script path. Type: string (or Expression with resultType string).
        :param pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]] storage_linked_services: Storage linked service references.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'HDInsightPig')
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if defines is not None:
            pulumi.set(__self__, "defines", defines)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if get_debug_info is not None:
            pulumi.set(__self__, "get_debug_info", get_debug_info)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if script_linked_service is not None:
            pulumi.set(__self__, "script_linked_service", script_linked_service)
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)
        if storage_linked_services is not None:
            pulumi.set(__self__, "storage_linked_services", storage_linked_services)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'HDInsightPig'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        User specified arguments to HDInsightActivity.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter
    def defines(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Allows user to specify defines for Pig job request.
        """
        return pulumi.get(self, "defines")

    @defines.setter
    def defines(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defines", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="getDebugInfo")
    def get_debug_info(self) -> Optional[pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']]]:
        """
        Debug info option.
        """
        return pulumi.get(self, "get_debug_info")

    @get_debug_info.setter
    def get_debug_info(self, value: Optional[pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']]]):
        pulumi.set(self, "get_debug_info", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ActivityPolicyArgs']]:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ActivityPolicyArgs']]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="scriptLinkedService")
    def script_linked_service(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Script linked service reference.
        """
        return pulumi.get(self, "script_linked_service")

    @script_linked_service.setter
    def script_linked_service(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "script_linked_service", value)

    @property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[Any]:
        """
        Script path. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "script_path")

    @script_path.setter
    def script_path(self, value: Optional[Any]):
        pulumi.set(self, "script_path", value)

    @property
    @pulumi.getter(name="storageLinkedServices")
    def storage_linked_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]]:
        """
        Storage linked service references.
        """
        return pulumi.get(self, "storage_linked_services")

    @storage_linked_services.setter
    def storage_linked_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]]):
        pulumi.set(self, "storage_linked_services", value)


@pulumi.input_type
class HDInsightSparkActivityArgs:
    def __init__(__self__, *,
                 entry_file_path: Any,
                 name: pulumi.Input[str],
                 root_path: Any,
                 type: pulumi.Input[str],
                 arguments: Optional[pulumi.Input[Sequence[Any]]] = None,
                 class_name: Optional[pulumi.Input[str]] = None,
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 get_debug_info: Optional[pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']]] = None,
                 linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 policy: Optional[pulumi.Input['ActivityPolicyArgs']] = None,
                 proxy_user: Optional[Any] = None,
                 spark_config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 spark_job_linked_service: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None):
        """
        HDInsight Spark activity.
        :param Any entry_file_path: The relative path to the root folder of the code/package to be executed. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] name: Activity name.
        :param Any root_path: The root path in 'sparkJobLinkedService' for all the job’s files. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'HDInsightSpark'.
        :param pulumi.Input[Sequence[Any]] arguments: The user-specified arguments to HDInsightSparkActivity.
        :param pulumi.Input[str] class_name: The application's Java/Spark main class.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']] get_debug_info: Debug info option.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input['ActivityPolicyArgs'] policy: Activity policy.
        :param Any proxy_user: The user to impersonate that will execute the job. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, Any]] spark_config: Spark configuration property.
        :param pulumi.Input['LinkedServiceReferenceArgs'] spark_job_linked_service: The storage linked service for uploading the entry file and dependencies, and for receiving logs.
        """
        pulumi.set(__self__, "entry_file_path", entry_file_path)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "root_path", root_path)
        pulumi.set(__self__, "type", 'HDInsightSpark')
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if class_name is not None:
            pulumi.set(__self__, "class_name", class_name)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if get_debug_info is not None:
            pulumi.set(__self__, "get_debug_info", get_debug_info)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if proxy_user is not None:
            pulumi.set(__self__, "proxy_user", proxy_user)
        if spark_config is not None:
            pulumi.set(__self__, "spark_config", spark_config)
        if spark_job_linked_service is not None:
            pulumi.set(__self__, "spark_job_linked_service", spark_job_linked_service)

    @property
    @pulumi.getter(name="entryFilePath")
    def entry_file_path(self) -> Any:
        """
        The relative path to the root folder of the code/package to be executed. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "entry_file_path")

    @entry_file_path.setter
    def entry_file_path(self, value: Any):
        pulumi.set(self, "entry_file_path", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rootPath")
    def root_path(self) -> Any:
        """
        The root path in 'sparkJobLinkedService' for all the job’s files. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "root_path")

    @root_path.setter
    def root_path(self, value: Any):
        pulumi.set(self, "root_path", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'HDInsightSpark'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        The user-specified arguments to HDInsightSparkActivity.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter(name="className")
    def class_name(self) -> Optional[pulumi.Input[str]]:
        """
        The application's Java/Spark main class.
        """
        return pulumi.get(self, "class_name")

    @class_name.setter
    def class_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "class_name", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="getDebugInfo")
    def get_debug_info(self) -> Optional[pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']]]:
        """
        Debug info option.
        """
        return pulumi.get(self, "get_debug_info")

    @get_debug_info.setter
    def get_debug_info(self, value: Optional[pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']]]):
        pulumi.set(self, "get_debug_info", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ActivityPolicyArgs']]:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ActivityPolicyArgs']]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="proxyUser")
    def proxy_user(self) -> Optional[Any]:
        """
        The user to impersonate that will execute the job. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "proxy_user")

    @proxy_user.setter
    def proxy_user(self, value: Optional[Any]):
        pulumi.set(self, "proxy_user", value)

    @property
    @pulumi.getter(name="sparkConfig")
    def spark_config(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Spark configuration property.
        """
        return pulumi.get(self, "spark_config")

    @spark_config.setter
    def spark_config(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "spark_config", value)

    @property
    @pulumi.getter(name="sparkJobLinkedService")
    def spark_job_linked_service(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        The storage linked service for uploading the entry file and dependencies, and for receiving logs.
        """
        return pulumi.get(self, "spark_job_linked_service")

    @spark_job_linked_service.setter
    def spark_job_linked_service(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "spark_job_linked_service", value)


@pulumi.input_type
class HDInsightStreamingActivityArgs:
    def __init__(__self__, *,
                 file_paths: pulumi.Input[Sequence[Any]],
                 input: Any,
                 mapper: Any,
                 name: pulumi.Input[str],
                 output: Any,
                 reducer: Any,
                 type: pulumi.Input[str],
                 arguments: Optional[pulumi.Input[Sequence[Any]]] = None,
                 combiner: Optional[Any] = None,
                 command_environment: Optional[pulumi.Input[Sequence[Any]]] = None,
                 defines: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 file_linked_service: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 get_debug_info: Optional[pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']]] = None,
                 linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 policy: Optional[pulumi.Input['ActivityPolicyArgs']] = None,
                 storage_linked_services: Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]] = None):
        """
        HDInsight streaming activity type.
        :param pulumi.Input[Sequence[Any]] file_paths: Paths to streaming job files. Can be directories.
        :param Any input: Input blob path. Type: string (or Expression with resultType string).
        :param Any mapper: Mapper executable name. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] name: Activity name.
        :param Any output: Output blob path. Type: string (or Expression with resultType string).
        :param Any reducer: Reducer executable name. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'HDInsightStreaming'.
        :param pulumi.Input[Sequence[Any]] arguments: User specified arguments to HDInsightActivity.
        :param Any combiner: Combiner executable name. Type: string (or Expression with resultType string).
        :param pulumi.Input[Sequence[Any]] command_environment: Command line environment values.
        :param pulumi.Input[Mapping[str, Any]] defines: Allows user to specify defines for streaming job request.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param pulumi.Input['LinkedServiceReferenceArgs'] file_linked_service: Linked service reference where the files are located.
        :param pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']] get_debug_info: Debug info option.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input['ActivityPolicyArgs'] policy: Activity policy.
        :param pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]] storage_linked_services: Storage linked service references.
        """
        pulumi.set(__self__, "file_paths", file_paths)
        pulumi.set(__self__, "input", input)
        pulumi.set(__self__, "mapper", mapper)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "reducer", reducer)
        pulumi.set(__self__, "type", 'HDInsightStreaming')
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if combiner is not None:
            pulumi.set(__self__, "combiner", combiner)
        if command_environment is not None:
            pulumi.set(__self__, "command_environment", command_environment)
        if defines is not None:
            pulumi.set(__self__, "defines", defines)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_linked_service is not None:
            pulumi.set(__self__, "file_linked_service", file_linked_service)
        if get_debug_info is not None:
            pulumi.set(__self__, "get_debug_info", get_debug_info)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if storage_linked_services is not None:
            pulumi.set(__self__, "storage_linked_services", storage_linked_services)

    @property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> pulumi.Input[Sequence[Any]]:
        """
        Paths to streaming job files. Can be directories.
        """
        return pulumi.get(self, "file_paths")

    @file_paths.setter
    def file_paths(self, value: pulumi.Input[Sequence[Any]]):
        pulumi.set(self, "file_paths", value)

    @property
    @pulumi.getter
    def input(self) -> Any:
        """
        Input blob path. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Any):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter
    def mapper(self) -> Any:
        """
        Mapper executable name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "mapper")

    @mapper.setter
    def mapper(self, value: Any):
        pulumi.set(self, "mapper", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def output(self) -> Any:
        """
        Output blob path. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "output")

    @output.setter
    def output(self, value: Any):
        pulumi.set(self, "output", value)

    @property
    @pulumi.getter
    def reducer(self) -> Any:
        """
        Reducer executable name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "reducer")

    @reducer.setter
    def reducer(self, value: Any):
        pulumi.set(self, "reducer", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'HDInsightStreaming'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        User specified arguments to HDInsightActivity.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter
    def combiner(self) -> Optional[Any]:
        """
        Combiner executable name. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "combiner")

    @combiner.setter
    def combiner(self, value: Optional[Any]):
        pulumi.set(self, "combiner", value)

    @property
    @pulumi.getter(name="commandEnvironment")
    def command_environment(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        Command line environment values.
        """
        return pulumi.get(self, "command_environment")

    @command_environment.setter
    def command_environment(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "command_environment", value)

    @property
    @pulumi.getter
    def defines(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Allows user to specify defines for streaming job request.
        """
        return pulumi.get(self, "defines")

    @defines.setter
    def defines(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defines", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fileLinkedService")
    def file_linked_service(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Linked service reference where the files are located.
        """
        return pulumi.get(self, "file_linked_service")

    @file_linked_service.setter
    def file_linked_service(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "file_linked_service", value)

    @property
    @pulumi.getter(name="getDebugInfo")
    def get_debug_info(self) -> Optional[pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']]]:
        """
        Debug info option.
        """
        return pulumi.get(self, "get_debug_info")

    @get_debug_info.setter
    def get_debug_info(self, value: Optional[pulumi.Input[Union[str, 'HDInsightActivityDebugInfoOption']]]):
        pulumi.set(self, "get_debug_info", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ActivityPolicyArgs']]:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ActivityPolicyArgs']]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="storageLinkedServices")
    def storage_linked_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]]:
        """
        Storage linked service references.
        """
        return pulumi.get(self, "storage_linked_services")

    @storage_linked_services.setter
    def storage_linked_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceReferenceArgs']]]]):
        pulumi.set(self, "storage_linked_services", value)


@pulumi.input_type
class HdfsLinkedServiceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 url: Any,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 authentication_type: Optional[Any] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 user_name: Optional[Any] = None):
        """
        Hadoop Distributed File System (HDFS) linked service.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Hdfs'.
        :param Any url: The URL of the HDFS service endpoint, e.g. http://myhostname:50070/webhdfs/v1 . Type: string (or Expression with resultType string).
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param Any authentication_type: Type of authentication used to connect to the HDFS. Possible values are: Anonymous and Windows. Type: string (or Expression with resultType string).
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: Password for Windows authentication.
        :param Any user_name: User name for Windows authentication. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "type", 'Hdfs')
        pulumi.set(__self__, "url", url)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Hdfs'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def url(self) -> Any:
        """
        The URL of the HDFS service endpoint, e.g. http://myhostname:50070/webhdfs/v1 . Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Any):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[Any]:
        """
        Type of authentication used to connect to the HDFS. Possible values are: Anonymous and Windows. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[Any]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        Password for Windows authentication.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[Any]:
        """
        User name for Windows authentication. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[Any]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class HdfsSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 distcp_settings: Optional[pulumi.Input['DistcpSettingsArgs']] = None,
                 recursive: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity HDFS source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'HdfsSource'.
        :param pulumi.Input['DistcpSettingsArgs'] distcp_settings: Specifies Distcp-related settings.
        :param Any recursive: If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'HdfsSource')
        if distcp_settings is not None:
            pulumi.set(__self__, "distcp_settings", distcp_settings)
        if recursive is not None:
            pulumi.set(__self__, "recursive", recursive)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'HdfsSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="distcpSettings")
    def distcp_settings(self) -> Optional[pulumi.Input['DistcpSettingsArgs']]:
        """
        Specifies Distcp-related settings.
        """
        return pulumi.get(self, "distcp_settings")

    @distcp_settings.setter
    def distcp_settings(self, value: Optional[pulumi.Input['DistcpSettingsArgs']]):
        pulumi.set(self, "distcp_settings", value)

    @property
    @pulumi.getter
    def recursive(self) -> Optional[Any]:
        """
        If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "recursive")

    @recursive.setter
    def recursive(self, value: Optional[Any]):
        pulumi.set(self, "recursive", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class HiveLinkedServiceArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[Union[str, 'HiveAuthenticationType']],
                 host: Any,
                 type: pulumi.Input[str],
                 allow_host_name_cn_mismatch: Optional[Any] = None,
                 allow_self_signed_server_cert: Optional[Any] = None,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_ssl: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 http_path: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 port: Optional[Any] = None,
                 server_type: Optional[pulumi.Input[Union[str, 'HiveServerType']]] = None,
                 service_discovery_mode: Optional[Any] = None,
                 thrift_transport_protocol: Optional[pulumi.Input[Union[str, 'HiveThriftTransportProtocol']]] = None,
                 trusted_cert_path: Optional[Any] = None,
                 use_native_query: Optional[Any] = None,
                 use_system_trust_store: Optional[Any] = None,
                 username: Optional[Any] = None,
                 zoo_keeper_name_space: Optional[Any] = None):
        """
        Hive Server linked service.
        :param pulumi.Input[Union[str, 'HiveAuthenticationType']] authentication_type: The authentication method used to access the Hive server.
        :param Any host: IP address or host name of the Hive server, separated by ';' for multiple hosts (only when serviceDiscoveryMode is enable).
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Hive'.
        :param Any allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        :param Any allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from the server. The default value is false.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Any http_path: The partial URL corresponding to the Hive server.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: The password corresponding to the user name that you provided in the Username field
        :param Any port: The TCP port that the Hive server uses to listen for client connections.
        :param pulumi.Input[Union[str, 'HiveServerType']] server_type: The type of Hive server.
        :param Any service_discovery_mode: true to indicate using the ZooKeeper service, false not.
        :param pulumi.Input[Union[str, 'HiveThriftTransportProtocol']] thrift_transport_protocol: The transport protocol to use in the Thrift layer.
        :param Any trusted_cert_path: The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        :param Any use_native_query: Specifies whether the driver uses native HiveQL queries,or converts them into an equivalent form in HiveQL.
        :param Any use_system_trust_store: Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        :param Any username: The user name that you use to access Hive Server.
        :param Any zoo_keeper_name_space: The namespace on ZooKeeper under which Hive Server 2 nodes are added.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'Hive')
        if allow_host_name_cn_mismatch is not None:
            pulumi.set(__self__, "allow_host_name_cn_mismatch", allow_host_name_cn_mismatch)
        if allow_self_signed_server_cert is not None:
            pulumi.set(__self__, "allow_self_signed_server_cert", allow_self_signed_server_cert)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if http_path is not None:
            pulumi.set(__self__, "http_path", http_path)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if server_type is not None:
            pulumi.set(__self__, "server_type", server_type)
        if service_discovery_mode is not None:
            pulumi.set(__self__, "service_discovery_mode", service_discovery_mode)
        if thrift_transport_protocol is not None:
            pulumi.set(__self__, "thrift_transport_protocol", thrift_transport_protocol)
        if trusted_cert_path is not None:
            pulumi.set(__self__, "trusted_cert_path", trusted_cert_path)
        if use_native_query is not None:
            pulumi.set(__self__, "use_native_query", use_native_query)
        if use_system_trust_store is not None:
            pulumi.set(__self__, "use_system_trust_store", use_system_trust_store)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if zoo_keeper_name_space is not None:
            pulumi.set(__self__, "zoo_keeper_name_space", zoo_keeper_name_space)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[Union[str, 'HiveAuthenticationType']]:
        """
        The authentication method used to access the Hive server.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[Union[str, 'HiveAuthenticationType']]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        IP address or host name of the Hive server, separated by ';' for multiple hosts (only when serviceDiscoveryMode is enable).
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Any):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Hive'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="allowHostNameCNMismatch")
    def allow_host_name_cn_mismatch(self) -> Optional[Any]:
        """
        Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        """
        return pulumi.get(self, "allow_host_name_cn_mismatch")

    @allow_host_name_cn_mismatch.setter
    def allow_host_name_cn_mismatch(self, value: Optional[Any]):
        pulumi.set(self, "allow_host_name_cn_mismatch", value)

    @property
    @pulumi.getter(name="allowSelfSignedServerCert")
    def allow_self_signed_server_cert(self) -> Optional[Any]:
        """
        Specifies whether to allow self-signed certificates from the server. The default value is false.
        """
        return pulumi.get(self, "allow_self_signed_server_cert")

    @allow_self_signed_server_cert.setter
    def allow_self_signed_server_cert(self, value: Optional[Any]):
        pulumi.set(self, "allow_self_signed_server_cert", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[Any]:
        """
        Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        """
        return pulumi.get(self, "enable_ssl")

    @enable_ssl.setter
    def enable_ssl(self, value: Optional[Any]):
        pulumi.set(self, "enable_ssl", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter(name="httpPath")
    def http_path(self) -> Optional[Any]:
        """
        The partial URL corresponding to the Hive server.
        """
        return pulumi.get(self, "http_path")

    @http_path.setter
    def http_path(self, value: Optional[Any]):
        pulumi.set(self, "http_path", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The password corresponding to the user name that you provided in the Username field
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port that the Hive server uses to listen for client connections.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[Any]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> Optional[pulumi.Input[Union[str, 'HiveServerType']]]:
        """
        The type of Hive server.
        """
        return pulumi.get(self, "server_type")

    @server_type.setter
    def server_type(self, value: Optional[pulumi.Input[Union[str, 'HiveServerType']]]):
        pulumi.set(self, "server_type", value)

    @property
    @pulumi.getter(name="serviceDiscoveryMode")
    def service_discovery_mode(self) -> Optional[Any]:
        """
        true to indicate using the ZooKeeper service, false not.
        """
        return pulumi.get(self, "service_discovery_mode")

    @service_discovery_mode.setter
    def service_discovery_mode(self, value: Optional[Any]):
        pulumi.set(self, "service_discovery_mode", value)

    @property
    @pulumi.getter(name="thriftTransportProtocol")
    def thrift_transport_protocol(self) -> Optional[pulumi.Input[Union[str, 'HiveThriftTransportProtocol']]]:
        """
        The transport protocol to use in the Thrift layer.
        """
        return pulumi.get(self, "thrift_transport_protocol")

    @thrift_transport_protocol.setter
    def thrift_transport_protocol(self, value: Optional[pulumi.Input[Union[str, 'HiveThriftTransportProtocol']]]):
        pulumi.set(self, "thrift_transport_protocol", value)

    @property
    @pulumi.getter(name="trustedCertPath")
    def trusted_cert_path(self) -> Optional[Any]:
        """
        The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        """
        return pulumi.get(self, "trusted_cert_path")

    @trusted_cert_path.setter
    def trusted_cert_path(self, value: Optional[Any]):
        pulumi.set(self, "trusted_cert_path", value)

    @property
    @pulumi.getter(name="useNativeQuery")
    def use_native_query(self) -> Optional[Any]:
        """
        Specifies whether the driver uses native HiveQL queries,or converts them into an equivalent form in HiveQL.
        """
        return pulumi.get(self, "use_native_query")

    @use_native_query.setter
    def use_native_query(self, value: Optional[Any]):
        pulumi.set(self, "use_native_query", value)

    @property
    @pulumi.getter(name="useSystemTrustStore")
    def use_system_trust_store(self) -> Optional[Any]:
        """
        Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        """
        return pulumi.get(self, "use_system_trust_store")

    @use_system_trust_store.setter
    def use_system_trust_store(self, value: Optional[Any]):
        pulumi.set(self, "use_system_trust_store", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        The user name that you use to access Hive Server.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[Any]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="zooKeeperNameSpace")
    def zoo_keeper_name_space(self) -> Optional[Any]:
        """
        The namespace on ZooKeeper under which Hive Server 2 nodes are added.
        """
        return pulumi.get(self, "zoo_keeper_name_space")

    @zoo_keeper_name_space.setter
    def zoo_keeper_name_space(self, value: Optional[Any]):
        pulumi.set(self, "zoo_keeper_name_space", value)


@pulumi.input_type
class HiveObjectDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Hive Server dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'HiveObject'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'HiveObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'HiveObject'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class HiveSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Hive Server source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'HiveSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'HiveSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'HiveSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class HttpDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 additional_headers: Optional[Any] = None,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 compression: Optional[pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 relative_url: Optional[Any] = None,
                 request_body: Optional[Any] = None,
                 request_method: Optional[Any] = None,
                 structure: Optional[Any] = None):
        """
        A file in an HTTP web server.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'HttpFile'.
        :param Any additional_headers: The headers for the HTTP Request. e.g. request-header-name-1:request-header-value-1
               ...
               request-header-name-n:request-header-value-n Type: string (or Expression with resultType string).
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']] compression: The data compression method used on files.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']] format: The format of files.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any relative_url: The relative URL based on the URL in the HttpLinkedService refers to an HTTP file Type: string (or Expression with resultType string).
        :param Any request_body: The body for the HTTP request. Type: string (or Expression with resultType string).
        :param Any request_method: The HTTP method for the HTTP request. Type: string (or Expression with resultType string).
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'HttpFile')
        if additional_headers is not None:
            pulumi.set(__self__, "additional_headers", additional_headers)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if relative_url is not None:
            pulumi.set(__self__, "relative_url", relative_url)
        if request_body is not None:
            pulumi.set(__self__, "request_body", request_body)
        if request_method is not None:
            pulumi.set(__self__, "request_method", request_method)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'HttpFile'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="additionalHeaders")
    def additional_headers(self) -> Optional[Any]:
        """
        The headers for the HTTP Request. e.g. request-header-name-1:request-header-value-1
        ...
        request-header-name-n:request-header-value-n Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "additional_headers")

    @additional_headers.setter
    def additional_headers(self, value: Optional[Any]):
        pulumi.set(self, "additional_headers", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']]]:
        """
        The data compression method used on files.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[Union['DatasetBZip2CompressionArgs', 'DatasetDeflateCompressionArgs', 'DatasetGZipCompressionArgs', 'DatasetZipDeflateCompressionArgs']]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']]]:
        """
        The format of files.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[Union['AvroFormatArgs', 'JsonFormatArgs', 'OrcFormatArgs', 'ParquetFormatArgs', 'TextFormatArgs']]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="relativeUrl")
    def relative_url(self) -> Optional[Any]:
        """
        The relative URL based on the URL in the HttpLinkedService refers to an HTTP file Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "relative_url")

    @relative_url.setter
    def relative_url(self, value: Optional[Any]):
        pulumi.set(self, "relative_url", value)

    @property
    @pulumi.getter(name="requestBody")
    def request_body(self) -> Optional[Any]:
        """
        The body for the HTTP request. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "request_body")

    @request_body.setter
    def request_body(self, value: Optional[Any]):
        pulumi.set(self, "request_body", value)

    @property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> Optional[Any]:
        """
        The HTTP method for the HTTP request. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "request_method")

    @request_method.setter
    def request_method(self, value: Optional[Any]):
        pulumi.set(self, "request_method", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class HttpLinkedServiceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 url: Any,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 authentication_type: Optional[pulumi.Input[Union[str, 'HttpAuthenticationType']]] = None,
                 cert_thumbprint: Optional[Any] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 embedded_cert_data: Optional[Any] = None,
                 enable_server_certificate_validation: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 user_name: Optional[Any] = None):
        """
        Linked service for an HTTP source.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'HttpServer'.
        :param Any url: The base URL of the HTTP endpoint, e.g. https://www.microsoft.com. Type: string (or Expression with resultType string).
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[Union[str, 'HttpAuthenticationType']] authentication_type: The authentication type to be used to connect to the HTTP server.
        :param Any cert_thumbprint: Thumbprint of certificate for ClientCertificate authentication. Only valid for on-premises copy. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any embedded_cert_data: Base64 encoded certificate data for ClientCertificate authentication. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
        :param Any enable_server_certificate_validation: If true, validate the HTTPS server SSL certificate. Default value is true. Type: boolean (or Expression with resultType boolean).
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: Password for Basic, Digest, Windows, or ClientCertificate with EmbeddedCertData authentication.
        :param Any user_name: User name for Basic, Digest, or Windows authentication. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "type", 'HttpServer')
        pulumi.set(__self__, "url", url)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if cert_thumbprint is not None:
            pulumi.set(__self__, "cert_thumbprint", cert_thumbprint)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if embedded_cert_data is not None:
            pulumi.set(__self__, "embedded_cert_data", embedded_cert_data)
        if enable_server_certificate_validation is not None:
            pulumi.set(__self__, "enable_server_certificate_validation", enable_server_certificate_validation)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'HttpServer'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def url(self) -> Any:
        """
        The base URL of the HTTP endpoint, e.g. https://www.microsoft.com. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Any):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[Union[str, 'HttpAuthenticationType']]]:
        """
        The authentication type to be used to connect to the HTTP server.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[Union[str, 'HttpAuthenticationType']]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="certThumbprint")
    def cert_thumbprint(self) -> Optional[Any]:
        """
        Thumbprint of certificate for ClientCertificate authentication. Only valid for on-premises copy. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "cert_thumbprint")

    @cert_thumbprint.setter
    def cert_thumbprint(self, value: Optional[Any]):
        pulumi.set(self, "cert_thumbprint", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="embeddedCertData")
    def embedded_cert_data(self) -> Optional[Any]:
        """
        Base64 encoded certificate data for ClientCertificate authentication. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "embedded_cert_data")

    @embedded_cert_data.setter
    def embedded_cert_data(self, value: Optional[Any]):
        pulumi.set(self, "embedded_cert_data", value)

    @property
    @pulumi.getter(name="enableServerCertificateValidation")
    def enable_server_certificate_validation(self) -> Optional[Any]:
        """
        If true, validate the HTTPS server SSL certificate. Default value is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "enable_server_certificate_validation")

    @enable_server_certificate_validation.setter
    def enable_server_certificate_validation(self, value: Optional[Any]):
        pulumi.set(self, "enable_server_certificate_validation", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        Password for Basic, Digest, Windows, or ClientCertificate with EmbeddedCertData authentication.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[Any]:
        """
        User name for Basic, Digest, or Windows authentication. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[Any]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class HttpSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 http_request_timeout: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity source for an HTTP file.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'HttpSource'.
        :param Any http_request_timeout: Specifies the timeout for a HTTP client to get HTTP response from HTTP server. The default value is equivalent to System.Net.HttpWebRequest.Timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'HttpSource')
        if http_request_timeout is not None:
            pulumi.set(__self__, "http_request_timeout", http_request_timeout)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'HttpSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="httpRequestTimeout")
    def http_request_timeout(self) -> Optional[Any]:
        """
        Specifies the timeout for a HTTP client to get HTTP response from HTTP server. The default value is equivalent to System.Net.HttpWebRequest.Timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "http_request_timeout")

    @http_request_timeout.setter
    def http_request_timeout(self, value: Optional[Any]):
        pulumi.set(self, "http_request_timeout", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class HubspotLinkedServiceArgs:
    def __init__(__self__, *,
                 client_id: Any,
                 type: pulumi.Input[str],
                 access_token: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 client_secret: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 refresh_token: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Hubspot Service linked service.
        :param Any client_id: The client ID associated with your Hubspot application.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Hubspot'.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] access_token: The access token obtained when initially authenticating your OAuth integration.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] client_secret: The client secret associated with your Hubspot application.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] refresh_token: The refresh token obtained when initially authenticating your OAuth integration.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "type", 'Hubspot')
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Any:
        """
        The client ID associated with your Hubspot application.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Any):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Hubspot'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The access token obtained when initially authenticating your OAuth integration.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The client secret associated with your Hubspot application.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The refresh token obtained when initially authenticating your OAuth integration.
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "refresh_token", value)

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @use_encrypted_endpoints.setter
    def use_encrypted_endpoints(self, value: Optional[Any]):
        pulumi.set(self, "use_encrypted_endpoints", value)

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_host_verification")

    @use_host_verification.setter
    def use_host_verification(self, value: Optional[Any]):
        pulumi.set(self, "use_host_verification", value)

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_peer_verification")

    @use_peer_verification.setter
    def use_peer_verification(self, value: Optional[Any]):
        pulumi.set(self, "use_peer_verification", value)


@pulumi.input_type
class HubspotObjectDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Hubspot Service dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'HubspotObject'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'HubspotObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'HubspotObject'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class HubspotSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Hubspot Service source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'HubspotSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'HubspotSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'HubspotSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class IfConditionActivityArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input['ExpressionArgs'],
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 if_false_activities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureMLBatchExecutionActivityArgs', 'AzureMLUpdateResourceActivityArgs', 'ControlActivityArgs', 'CopyActivityArgs', 'CustomActivityArgs', 'DataLakeAnalyticsUSQLActivityArgs', 'DatabricksNotebookActivityArgs', 'ExecutePipelineActivityArgs', 'ExecuteSSISPackageActivityArgs', 'ExecutionActivityArgs', 'FilterActivityArgs', 'ForEachActivityArgs', 'GetMetadataActivityArgs', 'HDInsightHiveActivityArgs', 'HDInsightMapReduceActivityArgs', 'HDInsightPigActivityArgs', 'HDInsightSparkActivityArgs', 'HDInsightStreamingActivityArgs', 'IfConditionActivityArgs', 'LookupActivityArgs', 'SqlServerStoredProcedureActivityArgs', 'UntilActivityArgs', 'WaitActivityArgs', 'WebActivityArgs']]]]] = None,
                 if_true_activities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureMLBatchExecutionActivityArgs', 'AzureMLUpdateResourceActivityArgs', 'ControlActivityArgs', 'CopyActivityArgs', 'CustomActivityArgs', 'DataLakeAnalyticsUSQLActivityArgs', 'DatabricksNotebookActivityArgs', 'ExecutePipelineActivityArgs', 'ExecuteSSISPackageActivityArgs', 'ExecutionActivityArgs', 'FilterActivityArgs', 'ForEachActivityArgs', 'GetMetadataActivityArgs', 'HDInsightHiveActivityArgs', 'HDInsightMapReduceActivityArgs', 'HDInsightPigActivityArgs', 'HDInsightSparkActivityArgs', 'HDInsightStreamingActivityArgs', 'IfConditionActivityArgs', 'LookupActivityArgs', 'SqlServerStoredProcedureActivityArgs', 'UntilActivityArgs', 'WaitActivityArgs', 'WebActivityArgs']]]]] = None):
        """
        This activity evaluates a boolean expression and executes either the activities under the ifTrueActivities property or the ifFalseActivities property depending on the result of the expression.
        :param pulumi.Input['ExpressionArgs'] expression: An expression that would evaluate to Boolean. This is used to determine the block of activities (ifTrueActivities or ifFalseActivities) that will be executed.
        :param pulumi.Input[str] name: Activity name.
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'IfCondition'.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureMLBatchExecutionActivityArgs', 'AzureMLUpdateResourceActivityArgs', 'ControlActivityArgs', 'CopyActivityArgs', 'CustomActivityArgs', 'DataLakeAnalyticsUSQLActivityArgs', 'DatabricksNotebookActivityArgs', 'ExecutePipelineActivityArgs', 'ExecuteSSISPackageActivityArgs', 'ExecutionActivityArgs', 'FilterActivityArgs', 'ForEachActivityArgs', 'GetMetadataActivityArgs', 'HDInsightHiveActivityArgs', 'HDInsightMapReduceActivityArgs', 'HDInsightPigActivityArgs', 'HDInsightSparkActivityArgs', 'HDInsightStreamingActivityArgs', 'IfConditionActivityArgs', 'LookupActivityArgs', 'SqlServerStoredProcedureActivityArgs', 'UntilActivityArgs', 'WaitActivityArgs', 'WebActivityArgs']]]] if_false_activities: List of activities to execute if expression is evaluated to false. This is an optional property and if not provided, the activity will exit without any action.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureMLBatchExecutionActivityArgs', 'AzureMLUpdateResourceActivityArgs', 'ControlActivityArgs', 'CopyActivityArgs', 'CustomActivityArgs', 'DataLakeAnalyticsUSQLActivityArgs', 'DatabricksNotebookActivityArgs', 'ExecutePipelineActivityArgs', 'ExecuteSSISPackageActivityArgs', 'ExecutionActivityArgs', 'FilterActivityArgs', 'ForEachActivityArgs', 'GetMetadataActivityArgs', 'HDInsightHiveActivityArgs', 'HDInsightMapReduceActivityArgs', 'HDInsightPigActivityArgs', 'HDInsightSparkActivityArgs', 'HDInsightStreamingActivityArgs', 'IfConditionActivityArgs', 'LookupActivityArgs', 'SqlServerStoredProcedureActivityArgs', 'UntilActivityArgs', 'WaitActivityArgs', 'WebActivityArgs']]]] if_true_activities: List of activities to execute if expression is evaluated to true. This is an optional property and if not provided, the activity will exit without any action.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'IfCondition')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if if_false_activities is not None:
            pulumi.set(__self__, "if_false_activities", if_false_activities)
        if if_true_activities is not None:
            pulumi.set(__self__, "if_true_activities", if_true_activities)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input['ExpressionArgs']:
        """
        An expression that would evaluate to Boolean. This is used to determine the block of activities (ifTrueActivities or ifFalseActivities) that will be executed.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input['ExpressionArgs']):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'IfCondition'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ifFalseActivities")
    def if_false_activities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureMLBatchExecutionActivityArgs', 'AzureMLUpdateResourceActivityArgs', 'ControlActivityArgs', 'CopyActivityArgs', 'CustomActivityArgs', 'DataLakeAnalyticsUSQLActivityArgs', 'DatabricksNotebookActivityArgs', 'ExecutePipelineActivityArgs', 'ExecuteSSISPackageActivityArgs', 'ExecutionActivityArgs', 'FilterActivityArgs', 'ForEachActivityArgs', 'GetMetadataActivityArgs', 'HDInsightHiveActivityArgs', 'HDInsightMapReduceActivityArgs', 'HDInsightPigActivityArgs', 'HDInsightSparkActivityArgs', 'HDInsightStreamingActivityArgs', 'IfConditionActivityArgs', 'LookupActivityArgs', 'SqlServerStoredProcedureActivityArgs', 'UntilActivityArgs', 'WaitActivityArgs', 'WebActivityArgs']]]]]:
        """
        List of activities to execute if expression is evaluated to false. This is an optional property and if not provided, the activity will exit without any action.
        """
        return pulumi.get(self, "if_false_activities")

    @if_false_activities.setter
    def if_false_activities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureMLBatchExecutionActivityArgs', 'AzureMLUpdateResourceActivityArgs', 'ControlActivityArgs', 'CopyActivityArgs', 'CustomActivityArgs', 'DataLakeAnalyticsUSQLActivityArgs', 'DatabricksNotebookActivityArgs', 'ExecutePipelineActivityArgs', 'ExecuteSSISPackageActivityArgs', 'ExecutionActivityArgs', 'FilterActivityArgs', 'ForEachActivityArgs', 'GetMetadataActivityArgs', 'HDInsightHiveActivityArgs', 'HDInsightMapReduceActivityArgs', 'HDInsightPigActivityArgs', 'HDInsightSparkActivityArgs', 'HDInsightStreamingActivityArgs', 'IfConditionActivityArgs', 'LookupActivityArgs', 'SqlServerStoredProcedureActivityArgs', 'UntilActivityArgs', 'WaitActivityArgs', 'WebActivityArgs']]]]]):
        pulumi.set(self, "if_false_activities", value)

    @property
    @pulumi.getter(name="ifTrueActivities")
    def if_true_activities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureMLBatchExecutionActivityArgs', 'AzureMLUpdateResourceActivityArgs', 'ControlActivityArgs', 'CopyActivityArgs', 'CustomActivityArgs', 'DataLakeAnalyticsUSQLActivityArgs', 'DatabricksNotebookActivityArgs', 'ExecutePipelineActivityArgs', 'ExecuteSSISPackageActivityArgs', 'ExecutionActivityArgs', 'FilterActivityArgs', 'ForEachActivityArgs', 'GetMetadataActivityArgs', 'HDInsightHiveActivityArgs', 'HDInsightMapReduceActivityArgs', 'HDInsightPigActivityArgs', 'HDInsightSparkActivityArgs', 'HDInsightStreamingActivityArgs', 'IfConditionActivityArgs', 'LookupActivityArgs', 'SqlServerStoredProcedureActivityArgs', 'UntilActivityArgs', 'WaitActivityArgs', 'WebActivityArgs']]]]]:
        """
        List of activities to execute if expression is evaluated to true. This is an optional property and if not provided, the activity will exit without any action.
        """
        return pulumi.get(self, "if_true_activities")

    @if_true_activities.setter
    def if_true_activities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureMLBatchExecutionActivityArgs', 'AzureMLUpdateResourceActivityArgs', 'ControlActivityArgs', 'CopyActivityArgs', 'CustomActivityArgs', 'DataLakeAnalyticsUSQLActivityArgs', 'DatabricksNotebookActivityArgs', 'ExecutePipelineActivityArgs', 'ExecuteSSISPackageActivityArgs', 'ExecutionActivityArgs', 'FilterActivityArgs', 'ForEachActivityArgs', 'GetMetadataActivityArgs', 'HDInsightHiveActivityArgs', 'HDInsightMapReduceActivityArgs', 'HDInsightPigActivityArgs', 'HDInsightSparkActivityArgs', 'HDInsightStreamingActivityArgs', 'IfConditionActivityArgs', 'LookupActivityArgs', 'SqlServerStoredProcedureActivityArgs', 'UntilActivityArgs', 'WaitActivityArgs', 'WebActivityArgs']]]]]):
        pulumi.set(self, "if_true_activities", value)


@pulumi.input_type
class ImpalaLinkedServiceArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[Union[str, 'ImpalaAuthenticationType']],
                 host: Any,
                 type: pulumi.Input[str],
                 allow_host_name_cn_mismatch: Optional[Any] = None,
                 allow_self_signed_server_cert: Optional[Any] = None,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_ssl: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 port: Optional[Any] = None,
                 trusted_cert_path: Optional[Any] = None,
                 use_system_trust_store: Optional[Any] = None,
                 username: Optional[Any] = None):
        """
        Impala server linked service.
        :param pulumi.Input[Union[str, 'ImpalaAuthenticationType']] authentication_type: The authentication type to use.
        :param Any host: The IP address or host name of the Impala server. (i.e. 192.168.222.160)
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Impala'.
        :param Any allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        :param Any allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from the server. The default value is false.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: The password corresponding to the user name when using UsernameAndPassword.
        :param Any port: The TCP port that the Impala server uses to listen for client connections. The default value is 21050.
        :param Any trusted_cert_path: The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        :param Any use_system_trust_store: Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        :param Any username: The user name used to access the Impala server. The default value is anonymous when using SASLUsername.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'Impala')
        if allow_host_name_cn_mismatch is not None:
            pulumi.set(__self__, "allow_host_name_cn_mismatch", allow_host_name_cn_mismatch)
        if allow_self_signed_server_cert is not None:
            pulumi.set(__self__, "allow_self_signed_server_cert", allow_self_signed_server_cert)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if trusted_cert_path is not None:
            pulumi.set(__self__, "trusted_cert_path", trusted_cert_path)
        if use_system_trust_store is not None:
            pulumi.set(__self__, "use_system_trust_store", use_system_trust_store)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[Union[str, 'ImpalaAuthenticationType']]:
        """
        The authentication type to use.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[Union[str, 'ImpalaAuthenticationType']]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        The IP address or host name of the Impala server. (i.e. 192.168.222.160)
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Any):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Impala'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="allowHostNameCNMismatch")
    def allow_host_name_cn_mismatch(self) -> Optional[Any]:
        """
        Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        """
        return pulumi.get(self, "allow_host_name_cn_mismatch")

    @allow_host_name_cn_mismatch.setter
    def allow_host_name_cn_mismatch(self, value: Optional[Any]):
        pulumi.set(self, "allow_host_name_cn_mismatch", value)

    @property
    @pulumi.getter(name="allowSelfSignedServerCert")
    def allow_self_signed_server_cert(self) -> Optional[Any]:
        """
        Specifies whether to allow self-signed certificates from the server. The default value is false.
        """
        return pulumi.get(self, "allow_self_signed_server_cert")

    @allow_self_signed_server_cert.setter
    def allow_self_signed_server_cert(self, value: Optional[Any]):
        pulumi.set(self, "allow_self_signed_server_cert", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[Any]:
        """
        Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        """
        return pulumi.get(self, "enable_ssl")

    @enable_ssl.setter
    def enable_ssl(self, value: Optional[Any]):
        pulumi.set(self, "enable_ssl", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The password corresponding to the user name when using UsernameAndPassword.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port that the Impala server uses to listen for client connections. The default value is 21050.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[Any]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="trustedCertPath")
    def trusted_cert_path(self) -> Optional[Any]:
        """
        The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        """
        return pulumi.get(self, "trusted_cert_path")

    @trusted_cert_path.setter
    def trusted_cert_path(self, value: Optional[Any]):
        pulumi.set(self, "trusted_cert_path", value)

    @property
    @pulumi.getter(name="useSystemTrustStore")
    def use_system_trust_store(self) -> Optional[Any]:
        """
        Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        """
        return pulumi.get(self, "use_system_trust_store")

    @use_system_trust_store.setter
    def use_system_trust_store(self, value: Optional[Any]):
        pulumi.set(self, "use_system_trust_store", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        The user name used to access the Impala server. The default value is anonymous when using SASLUsername.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[Any]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ImpalaObjectDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Impala server dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'ImpalaObject'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'ImpalaObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'ImpalaObject'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class ImpalaSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Impala server source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'ImpalaSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'ImpalaSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'ImpalaSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class IntegrationRuntimeComputePropertiesArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[str]] = None,
                 max_parallel_executions_per_node: Optional[pulumi.Input[int]] = None,
                 node_size: Optional[pulumi.Input[str]] = None,
                 number_of_nodes: Optional[pulumi.Input[int]] = None,
                 v_net_properties: Optional[pulumi.Input['IntegrationRuntimeVNetPropertiesArgs']] = None):
        """
        The compute resource properties for managed integration runtime.
        :param pulumi.Input[str] location: The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
        :param pulumi.Input[int] max_parallel_executions_per_node: Maximum parallel executions count per node for managed integration runtime.
        :param pulumi.Input[str] node_size: The node size requirement to managed integration runtime.
        :param pulumi.Input[int] number_of_nodes: The required number of nodes for managed integration runtime.
        :param pulumi.Input['IntegrationRuntimeVNetPropertiesArgs'] v_net_properties: VNet properties for managed integration runtime.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_parallel_executions_per_node is not None:
            pulumi.set(__self__, "max_parallel_executions_per_node", max_parallel_executions_per_node)
        if node_size is not None:
            pulumi.set(__self__, "node_size", node_size)
        if number_of_nodes is not None:
            pulumi.set(__self__, "number_of_nodes", number_of_nodes)
        if v_net_properties is not None:
            pulumi.set(__self__, "v_net_properties", v_net_properties)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maxParallelExecutionsPerNode")
    def max_parallel_executions_per_node(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum parallel executions count per node for managed integration runtime.
        """
        return pulumi.get(self, "max_parallel_executions_per_node")

    @max_parallel_executions_per_node.setter
    def max_parallel_executions_per_node(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_parallel_executions_per_node", value)

    @property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> Optional[pulumi.Input[str]]:
        """
        The node size requirement to managed integration runtime.
        """
        return pulumi.get(self, "node_size")

    @node_size.setter
    def node_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_size", value)

    @property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        The required number of nodes for managed integration runtime.
        """
        return pulumi.get(self, "number_of_nodes")

    @number_of_nodes.setter
    def number_of_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_nodes", value)

    @property
    @pulumi.getter(name="vNetProperties")
    def v_net_properties(self) -> Optional[pulumi.Input['IntegrationRuntimeVNetPropertiesArgs']]:
        """
        VNet properties for managed integration runtime.
        """
        return pulumi.get(self, "v_net_properties")

    @v_net_properties.setter
    def v_net_properties(self, value: Optional[pulumi.Input['IntegrationRuntimeVNetPropertiesArgs']]):
        pulumi.set(self, "v_net_properties", value)


@pulumi.input_type
class IntegrationRuntimeCustomSetupScriptPropertiesArgs:
    def __init__(__self__, *,
                 blob_container_uri: Optional[pulumi.Input[str]] = None,
                 sas_token: Optional[pulumi.Input['SecureStringArgs']] = None):
        """
        Custom setup script properties for a managed dedicated integration runtime.
        :param pulumi.Input[str] blob_container_uri: The URI of the Azure blob container that contains the custom setup script.
        :param pulumi.Input['SecureStringArgs'] sas_token: The SAS token of the Azure blob container.
        """
        if blob_container_uri is not None:
            pulumi.set(__self__, "blob_container_uri", blob_container_uri)
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)

    @property
    @pulumi.getter(name="blobContainerUri")
    def blob_container_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the Azure blob container that contains the custom setup script.
        """
        return pulumi.get(self, "blob_container_uri")

    @blob_container_uri.setter
    def blob_container_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "blob_container_uri", value)

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional[pulumi.Input['SecureStringArgs']]:
        """
        The SAS token of the Azure blob container.
        """
        return pulumi.get(self, "sas_token")

    @sas_token.setter
    def sas_token(self, value: Optional[pulumi.Input['SecureStringArgs']]):
        pulumi.set(self, "sas_token", value)


@pulumi.input_type
class IntegrationRuntimeDataProxyPropertiesArgs:
    def __init__(__self__, *,
                 connect_via: Optional[pulumi.Input['EntityReferenceArgs']] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 staging_linked_service: Optional[pulumi.Input['EntityReferenceArgs']] = None):
        """
        Data proxy properties for a managed dedicated integration runtime.
        :param pulumi.Input['EntityReferenceArgs'] connect_via: The self-hosted integration runtime reference.
        :param pulumi.Input[str] path: The path to contain the staged data in the Blob storage.
        :param pulumi.Input['EntityReferenceArgs'] staging_linked_service: The staging linked service reference.
        """
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if staging_linked_service is not None:
            pulumi.set(__self__, "staging_linked_service", staging_linked_service)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['EntityReferenceArgs']]:
        """
        The self-hosted integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['EntityReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to contain the staged data in the Blob storage.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="stagingLinkedService")
    def staging_linked_service(self) -> Optional[pulumi.Input['EntityReferenceArgs']]:
        """
        The staging linked service reference.
        """
        return pulumi.get(self, "staging_linked_service")

    @staging_linked_service.setter
    def staging_linked_service(self, value: Optional[pulumi.Input['EntityReferenceArgs']]):
        pulumi.set(self, "staging_linked_service", value)


@pulumi.input_type
class IntegrationRuntimeReferenceArgs:
    def __init__(__self__, *,
                 reference_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Integration runtime reference type.
        :param pulumi.Input[str] reference_name: Reference integration runtime name.
        :param pulumi.Input[str] type: Type of integration runtime.
        :param pulumi.Input[Mapping[str, Any]] parameters: Arguments for integration runtime.
        """
        pulumi.set(__self__, "reference_name", reference_name)
        pulumi.set(__self__, "type", type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="referenceName")
    def reference_name(self) -> pulumi.Input[str]:
        """
        Reference integration runtime name.
        """
        return pulumi.get(self, "reference_name")

    @reference_name.setter
    def reference_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "reference_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of integration runtime.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Arguments for integration runtime.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class IntegrationRuntimeSsisCatalogInfoArgs:
    def __init__(__self__, *,
                 catalog_admin_password: Optional[pulumi.Input['SecureStringArgs']] = None,
                 catalog_admin_user_name: Optional[pulumi.Input[str]] = None,
                 catalog_pricing_tier: Optional[pulumi.Input[str]] = None,
                 catalog_server_endpoint: Optional[pulumi.Input[str]] = None):
        """
        Catalog information for managed dedicated integration runtime.
        :param pulumi.Input['SecureStringArgs'] catalog_admin_password: The password of the administrator user account of the catalog database.
        :param pulumi.Input[str] catalog_admin_user_name: The administrator user name of catalog database.
        :param pulumi.Input[str] catalog_pricing_tier: The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
        :param pulumi.Input[str] catalog_server_endpoint: The catalog database server URL.
        """
        if catalog_admin_password is not None:
            pulumi.set(__self__, "catalog_admin_password", catalog_admin_password)
        if catalog_admin_user_name is not None:
            pulumi.set(__self__, "catalog_admin_user_name", catalog_admin_user_name)
        if catalog_pricing_tier is not None:
            pulumi.set(__self__, "catalog_pricing_tier", catalog_pricing_tier)
        if catalog_server_endpoint is not None:
            pulumi.set(__self__, "catalog_server_endpoint", catalog_server_endpoint)

    @property
    @pulumi.getter(name="catalogAdminPassword")
    def catalog_admin_password(self) -> Optional[pulumi.Input['SecureStringArgs']]:
        """
        The password of the administrator user account of the catalog database.
        """
        return pulumi.get(self, "catalog_admin_password")

    @catalog_admin_password.setter
    def catalog_admin_password(self, value: Optional[pulumi.Input['SecureStringArgs']]):
        pulumi.set(self, "catalog_admin_password", value)

    @property
    @pulumi.getter(name="catalogAdminUserName")
    def catalog_admin_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The administrator user name of catalog database.
        """
        return pulumi.get(self, "catalog_admin_user_name")

    @catalog_admin_user_name.setter
    def catalog_admin_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_admin_user_name", value)

    @property
    @pulumi.getter(name="catalogPricingTier")
    def catalog_pricing_tier(self) -> Optional[pulumi.Input[str]]:
        """
        The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
        """
        return pulumi.get(self, "catalog_pricing_tier")

    @catalog_pricing_tier.setter
    def catalog_pricing_tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_pricing_tier", value)

    @property
    @pulumi.getter(name="catalogServerEndpoint")
    def catalog_server_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The catalog database server URL.
        """
        return pulumi.get(self, "catalog_server_endpoint")

    @catalog_server_endpoint.setter
    def catalog_server_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_server_endpoint", value)


@pulumi.input_type
class IntegrationRuntimeSsisPropertiesArgs:
    def __init__(__self__, *,
                 catalog_info: Optional[pulumi.Input['IntegrationRuntimeSsisCatalogInfoArgs']] = None,
                 custom_setup_script_properties: Optional[pulumi.Input['IntegrationRuntimeCustomSetupScriptPropertiesArgs']] = None,
                 data_proxy_properties: Optional[pulumi.Input['IntegrationRuntimeDataProxyPropertiesArgs']] = None,
                 edition: Optional[pulumi.Input[Union[str, 'IntegrationRuntimeEdition']]] = None,
                 license_type: Optional[pulumi.Input[Union[str, 'IntegrationRuntimeLicenseType']]] = None):
        """
        SSIS properties for managed integration runtime.
        :param pulumi.Input['IntegrationRuntimeSsisCatalogInfoArgs'] catalog_info: Catalog information for managed dedicated integration runtime.
        :param pulumi.Input['IntegrationRuntimeCustomSetupScriptPropertiesArgs'] custom_setup_script_properties: Custom setup script properties for a managed dedicated integration runtime.
        :param pulumi.Input['IntegrationRuntimeDataProxyPropertiesArgs'] data_proxy_properties: Data proxy properties for a managed dedicated integration runtime.
        :param pulumi.Input[Union[str, 'IntegrationRuntimeEdition']] edition: The edition for the SSIS Integration Runtime
        :param pulumi.Input[Union[str, 'IntegrationRuntimeLicenseType']] license_type: License type for bringing your own license scenario.
        """
        if catalog_info is not None:
            pulumi.set(__self__, "catalog_info", catalog_info)
        if custom_setup_script_properties is not None:
            pulumi.set(__self__, "custom_setup_script_properties", custom_setup_script_properties)
        if data_proxy_properties is not None:
            pulumi.set(__self__, "data_proxy_properties", data_proxy_properties)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)

    @property
    @pulumi.getter(name="catalogInfo")
    def catalog_info(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisCatalogInfoArgs']]:
        """
        Catalog information for managed dedicated integration runtime.
        """
        return pulumi.get(self, "catalog_info")

    @catalog_info.setter
    def catalog_info(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisCatalogInfoArgs']]):
        pulumi.set(self, "catalog_info", value)

    @property
    @pulumi.getter(name="customSetupScriptProperties")
    def custom_setup_script_properties(self) -> Optional[pulumi.Input['IntegrationRuntimeCustomSetupScriptPropertiesArgs']]:
        """
        Custom setup script properties for a managed dedicated integration runtime.
        """
        return pulumi.get(self, "custom_setup_script_properties")

    @custom_setup_script_properties.setter
    def custom_setup_script_properties(self, value: Optional[pulumi.Input['IntegrationRuntimeCustomSetupScriptPropertiesArgs']]):
        pulumi.set(self, "custom_setup_script_properties", value)

    @property
    @pulumi.getter(name="dataProxyProperties")
    def data_proxy_properties(self) -> Optional[pulumi.Input['IntegrationRuntimeDataProxyPropertiesArgs']]:
        """
        Data proxy properties for a managed dedicated integration runtime.
        """
        return pulumi.get(self, "data_proxy_properties")

    @data_proxy_properties.setter
    def data_proxy_properties(self, value: Optional[pulumi.Input['IntegrationRuntimeDataProxyPropertiesArgs']]):
        pulumi.set(self, "data_proxy_properties", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[Union[str, 'IntegrationRuntimeEdition']]]:
        """
        The edition for the SSIS Integration Runtime
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[Union[str, 'IntegrationRuntimeEdition']]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[Union[str, 'IntegrationRuntimeLicenseType']]]:
        """
        License type for bringing your own license scenario.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[Union[str, 'IntegrationRuntimeLicenseType']]]):
        pulumi.set(self, "license_type", value)


@pulumi.input_type
class IntegrationRuntimeVNetPropertiesArgs:
    def __init__(__self__, *,
                 subnet: Optional[pulumi.Input[str]] = None,
                 v_net_id: Optional[pulumi.Input[str]] = None):
        """
        VNet properties for managed integration runtime.
        :param pulumi.Input[str] subnet: The name of the subnet this integration runtime will join.
        :param pulumi.Input[str] v_net_id: The ID of the VNet that this integration runtime will join.
        """
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if v_net_id is not None:
            pulumi.set(__self__, "v_net_id", v_net_id)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the subnet this integration runtime will join.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="vNetId")
    def v_net_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VNet that this integration runtime will join.
        """
        return pulumi.get(self, "v_net_id")

    @v_net_id.setter
    def v_net_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "v_net_id", value)


@pulumi.input_type
class JiraLinkedServiceArgs:
    def __init__(__self__, *,
                 host: Any,
                 type: pulumi.Input[str],
                 username: Any,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 port: Optional[Any] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Jira Service linked service.
        :param Any host: The IP address or host name of the Jira service. (e.g. jira.example.com)
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Jira'.
        :param Any username: The user name that you use to access Jira Service.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: The password corresponding to the user name that you provided in the username field.
        :param Any port: The TCP port that the Jira server uses to listen for client connections. The default value is 443 if connecting through HTTPS, or 8080 if connecting through HTTP.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'Jira')
        pulumi.set(__self__, "username", username)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        The IP address or host name of the Jira service. (e.g. jira.example.com)
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Any):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Jira'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def username(self) -> Any:
        """
        The user name that you use to access Jira Service.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Any):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The password corresponding to the user name that you provided in the username field.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port that the Jira server uses to listen for client connections. The default value is 443 if connecting through HTTPS, or 8080 if connecting through HTTP.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[Any]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @use_encrypted_endpoints.setter
    def use_encrypted_endpoints(self, value: Optional[Any]):
        pulumi.set(self, "use_encrypted_endpoints", value)

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_host_verification")

    @use_host_verification.setter
    def use_host_verification(self, value: Optional[Any]):
        pulumi.set(self, "use_host_verification", value)

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_peer_verification")

    @use_peer_verification.setter
    def use_peer_verification(self, value: Optional[Any]):
        pulumi.set(self, "use_peer_verification", value)


@pulumi.input_type
class JiraObjectDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Jira Service dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'JiraObject'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'JiraObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'JiraObject'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class JiraSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Jira Service source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'JiraSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'JiraSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'JiraSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class JsonFormatArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 deserializer: Optional[Any] = None,
                 encoding_name: Optional[Any] = None,
                 file_pattern: Optional[pulumi.Input[Union[str, 'JsonFormatFilePattern']]] = None,
                 json_node_reference: Optional[Any] = None,
                 json_path_definition: Optional[Any] = None,
                 nesting_separator: Optional[Any] = None,
                 serializer: Optional[Any] = None):
        """
        The data stored in JSON format.
        :param pulumi.Input[str] type: Type of dataset storage format.
               Expected value is 'JsonFormat'.
        :param Any deserializer: Deserializer. Type: string (or Expression with resultType string).
        :param Any encoding_name: The code page name of the preferred encoding. If not provided, the default value is 'utf-8', unless the byte order mark (BOM) denotes another Unicode encoding. The full list of supported values can be found in the 'Name' column of the table of encodings in the following reference: https://go.microsoft.com/fwlink/?linkid=861078. Type: string (or Expression with resultType string).
        :param pulumi.Input[Union[str, 'JsonFormatFilePattern']] file_pattern: File pattern of JSON. To be more specific, the way of separating a collection of JSON objects. The default value is 'setOfObjects'. It is case-sensitive.
        :param Any json_node_reference: The JSONPath of the JSON array element to be flattened. Example: "$.ArrayPath". Type: string (or Expression with resultType string).
        :param Any json_path_definition: The JSONPath definition for each column mapping with a customized column name to extract data from JSON file. For fields under root object, start with "$"; for fields inside the array chosen by jsonNodeReference property, start from the array element. Example: {"Column1": "$.Column1Path", "Column2": "Column2PathInArray"}. Type: object (or Expression with resultType object).
        :param Any nesting_separator: The character used to separate nesting levels. Default value is '.' (dot). Type: string (or Expression with resultType string).
        :param Any serializer: Serializer. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "type", 'JsonFormat')
        if deserializer is not None:
            pulumi.set(__self__, "deserializer", deserializer)
        if encoding_name is not None:
            pulumi.set(__self__, "encoding_name", encoding_name)
        if file_pattern is not None:
            pulumi.set(__self__, "file_pattern", file_pattern)
        if json_node_reference is not None:
            pulumi.set(__self__, "json_node_reference", json_node_reference)
        if json_path_definition is not None:
            pulumi.set(__self__, "json_path_definition", json_path_definition)
        if nesting_separator is not None:
            pulumi.set(__self__, "nesting_separator", nesting_separator)
        if serializer is not None:
            pulumi.set(__self__, "serializer", serializer)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset storage format.
        Expected value is 'JsonFormat'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def deserializer(self) -> Optional[Any]:
        """
        Deserializer. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "deserializer")

    @deserializer.setter
    def deserializer(self, value: Optional[Any]):
        pulumi.set(self, "deserializer", value)

    @property
    @pulumi.getter(name="encodingName")
    def encoding_name(self) -> Optional[Any]:
        """
        The code page name of the preferred encoding. If not provided, the default value is 'utf-8', unless the byte order mark (BOM) denotes another Unicode encoding. The full list of supported values can be found in the 'Name' column of the table of encodings in the following reference: https://go.microsoft.com/fwlink/?linkid=861078. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encoding_name")

    @encoding_name.setter
    def encoding_name(self, value: Optional[Any]):
        pulumi.set(self, "encoding_name", value)

    @property
    @pulumi.getter(name="filePattern")
    def file_pattern(self) -> Optional[pulumi.Input[Union[str, 'JsonFormatFilePattern']]]:
        """
        File pattern of JSON. To be more specific, the way of separating a collection of JSON objects. The default value is 'setOfObjects'. It is case-sensitive.
        """
        return pulumi.get(self, "file_pattern")

    @file_pattern.setter
    def file_pattern(self, value: Optional[pulumi.Input[Union[str, 'JsonFormatFilePattern']]]):
        pulumi.set(self, "file_pattern", value)

    @property
    @pulumi.getter(name="jsonNodeReference")
    def json_node_reference(self) -> Optional[Any]:
        """
        The JSONPath of the JSON array element to be flattened. Example: "$.ArrayPath". Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "json_node_reference")

    @json_node_reference.setter
    def json_node_reference(self, value: Optional[Any]):
        pulumi.set(self, "json_node_reference", value)

    @property
    @pulumi.getter(name="jsonPathDefinition")
    def json_path_definition(self) -> Optional[Any]:
        """
        The JSONPath definition for each column mapping with a customized column name to extract data from JSON file. For fields under root object, start with "$"; for fields inside the array chosen by jsonNodeReference property, start from the array element. Example: {"Column1": "$.Column1Path", "Column2": "Column2PathInArray"}. Type: object (or Expression with resultType object).
        """
        return pulumi.get(self, "json_path_definition")

    @json_path_definition.setter
    def json_path_definition(self, value: Optional[Any]):
        pulumi.set(self, "json_path_definition", value)

    @property
    @pulumi.getter(name="nestingSeparator")
    def nesting_separator(self) -> Optional[Any]:
        """
        The character used to separate nesting levels. Default value is '.' (dot). Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "nesting_separator")

    @nesting_separator.setter
    def nesting_separator(self, value: Optional[Any]):
        pulumi.set(self, "nesting_separator", value)

    @property
    @pulumi.getter
    def serializer(self) -> Optional[Any]:
        """
        Serializer. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "serializer")

    @serializer.setter
    def serializer(self, value: Optional[Any]):
        pulumi.set(self, "serializer", value)


@pulumi.input_type
class LinkedIntegrationRuntimeKeyArgs:
    def __init__(__self__, *,
                 authorization_type: pulumi.Input[str],
                 key: pulumi.Input['SecureStringArgs']):
        """
        The base definition of a secret type.
        :param pulumi.Input[str] authorization_type: Type of the secret.
               Expected value is 'Key'.
        :param pulumi.Input['SecureStringArgs'] key: Type of the secret.
        """
        pulumi.set(__self__, "authorization_type", 'Key')
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Input[str]:
        """
        Type of the secret.
        Expected value is 'Key'.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input['SecureStringArgs']:
        """
        Type of the secret.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input['SecureStringArgs']):
        pulumi.set(self, "key", value)


@pulumi.input_type
class LinkedIntegrationRuntimeRbacArgs:
    def __init__(__self__, *,
                 authorization_type: pulumi.Input[str],
                 resource_id: pulumi.Input[str]):
        """
        The base definition of a secret type.
        :param pulumi.Input[str] authorization_type: Type of the secret.
               Expected value is 'RBAC'.
        :param pulumi.Input[str] resource_id: The resource ID of the integration runtime to be shared.
        """
        pulumi.set(__self__, "authorization_type", 'RBAC')
        pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Input[str]:
        """
        Type of the secret.
        Expected value is 'RBAC'.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The resource ID of the integration runtime to be shared.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class LinkedServiceReferenceArgs:
    def __init__(__self__, *,
                 reference_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Linked service reference type.
        :param pulumi.Input[str] reference_name: Reference LinkedService name.
        :param pulumi.Input[str] type: Linked service reference type.
        :param pulumi.Input[Mapping[str, Any]] parameters: Arguments for LinkedService.
        """
        pulumi.set(__self__, "reference_name", reference_name)
        pulumi.set(__self__, "type", type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="referenceName")
    def reference_name(self) -> pulumi.Input[str]:
        """
        Reference LinkedService name.
        """
        return pulumi.get(self, "reference_name")

    @reference_name.setter
    def reference_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "reference_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Linked service reference type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Arguments for LinkedService.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class LookupActivityArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input['DatasetReferenceArgs'],
                 name: pulumi.Input[str],
                 source: pulumi.Input[Union['AmazonMWSSourceArgs', 'AmazonRedshiftSourceArgs', 'AzureDataLakeStoreSourceArgs', 'AzureMySqlSourceArgs', 'AzurePostgreSqlSourceArgs', 'AzureTableSourceArgs', 'BlobSourceArgs', 'CassandraSourceArgs', 'ConcurSourceArgs', 'CouchbaseSourceArgs', 'DocumentDbCollectionSourceArgs', 'DrillSourceArgs', 'DynamicsSourceArgs', 'EloquaSourceArgs', 'FileSystemSourceArgs', 'GoogleBigQuerySourceArgs', 'GreenplumSourceArgs', 'HBaseSourceArgs', 'HdfsSourceArgs', 'HiveSourceArgs', 'HttpSourceArgs', 'HubspotSourceArgs', 'ImpalaSourceArgs', 'JiraSourceArgs', 'MagentoSourceArgs', 'MariaDBSourceArgs', 'MarketoSourceArgs', 'MongoDbSourceArgs', 'NetezzaSourceArgs', 'OracleSourceArgs', 'PaypalSourceArgs', 'PhoenixSourceArgs', 'PrestoSourceArgs', 'QuickBooksSourceArgs', 'RelationalSourceArgs', 'ResponsysSourceArgs', 'SalesforceMarketingCloudSourceArgs', 'SalesforceSourceArgs', 'SapCloudForCustomerSourceArgs', 'SapEccSourceArgs', 'ServiceNowSourceArgs', 'ShopifySourceArgs', 'SparkSourceArgs', 'SqlDWSourceArgs', 'SqlSourceArgs', 'SquareSourceArgs', 'VerticaSourceArgs', 'WebSourceArgs', 'XeroSourceArgs', 'ZohoSourceArgs']],
                 type: pulumi.Input[str],
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 first_row_only: Optional[Any] = None,
                 linked_service_name: Optional[pulumi.Input['LinkedServiceReferenceArgs']] = None,
                 policy: Optional[pulumi.Input['ActivityPolicyArgs']] = None):
        """
        Lookup activity.
        :param pulumi.Input['DatasetReferenceArgs'] dataset: Lookup activity dataset reference.
        :param pulumi.Input[str] name: Activity name.
        :param pulumi.Input[Union['AmazonMWSSourceArgs', 'AmazonRedshiftSourceArgs', 'AzureDataLakeStoreSourceArgs', 'AzureMySqlSourceArgs', 'AzurePostgreSqlSourceArgs', 'AzureTableSourceArgs', 'BlobSourceArgs', 'CassandraSourceArgs', 'ConcurSourceArgs', 'CouchbaseSourceArgs', 'DocumentDbCollectionSourceArgs', 'DrillSourceArgs', 'DynamicsSourceArgs', 'EloquaSourceArgs', 'FileSystemSourceArgs', 'GoogleBigQuerySourceArgs', 'GreenplumSourceArgs', 'HBaseSourceArgs', 'HdfsSourceArgs', 'HiveSourceArgs', 'HttpSourceArgs', 'HubspotSourceArgs', 'ImpalaSourceArgs', 'JiraSourceArgs', 'MagentoSourceArgs', 'MariaDBSourceArgs', 'MarketoSourceArgs', 'MongoDbSourceArgs', 'NetezzaSourceArgs', 'OracleSourceArgs', 'PaypalSourceArgs', 'PhoenixSourceArgs', 'PrestoSourceArgs', 'QuickBooksSourceArgs', 'RelationalSourceArgs', 'ResponsysSourceArgs', 'SalesforceMarketingCloudSourceArgs', 'SalesforceSourceArgs', 'SapCloudForCustomerSourceArgs', 'SapEccSourceArgs', 'ServiceNowSourceArgs', 'ShopifySourceArgs', 'SparkSourceArgs', 'SqlDWSourceArgs', 'SqlSourceArgs', 'SquareSourceArgs', 'VerticaSourceArgs', 'WebSourceArgs', 'XeroSourceArgs', 'ZohoSourceArgs']] source: Dataset-specific source properties, same as copy activity source.
        :param pulumi.Input[str] type: Type of activity.
               Expected value is 'Lookup'.
        :param pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]] depends_on: Activity depends on condition.
        :param pulumi.Input[str] description: Activity description.
        :param Any first_row_only: Whether to return first row or all rows. Default value is true. Type: boolean (or Expression with resultType boolean).
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input['ActivityPolicyArgs'] policy: Activity policy.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "type", 'Lookup')
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if first_row_only is not None:
            pulumi.set(__self__, "first_row_only", first_row_only)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Input['DatasetReferenceArgs']:
        """
        Lookup activity dataset reference.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input['DatasetReferenceArgs']):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Activity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[Union['AmazonMWSSourceArgs', 'AmazonRedshiftSourceArgs', 'AzureDataLakeStoreSourceArgs', 'AzureMySqlSourceArgs', 'AzurePostgreSqlSourceArgs', 'AzureTableSourceArgs', 'BlobSourceArgs', 'CassandraSourceArgs', 'ConcurSourceArgs', 'CouchbaseSourceArgs', 'DocumentDbCollectionSourceArgs', 'DrillSourceArgs', 'DynamicsSourceArgs', 'EloquaSourceArgs', 'FileSystemSourceArgs', 'GoogleBigQuerySourceArgs', 'GreenplumSourceArgs', 'HBaseSourceArgs', 'HdfsSourceArgs', 'HiveSourceArgs', 'HttpSourceArgs', 'HubspotSourceArgs', 'ImpalaSourceArgs', 'JiraSourceArgs', 'MagentoSourceArgs', 'MariaDBSourceArgs', 'MarketoSourceArgs', 'MongoDbSourceArgs', 'NetezzaSourceArgs', 'OracleSourceArgs', 'PaypalSourceArgs', 'PhoenixSourceArgs', 'PrestoSourceArgs', 'QuickBooksSourceArgs', 'RelationalSourceArgs', 'ResponsysSourceArgs', 'SalesforceMarketingCloudSourceArgs', 'SalesforceSourceArgs', 'SapCloudForCustomerSourceArgs', 'SapEccSourceArgs', 'ServiceNowSourceArgs', 'ShopifySourceArgs', 'SparkSourceArgs', 'SqlDWSourceArgs', 'SqlSourceArgs', 'SquareSourceArgs', 'VerticaSourceArgs', 'WebSourceArgs', 'XeroSourceArgs', 'ZohoSourceArgs']]:
        """
        Dataset-specific source properties, same as copy activity source.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[Union['AmazonMWSSourceArgs', 'AmazonRedshiftSourceArgs', 'AzureDataLakeStoreSourceArgs', 'AzureMySqlSourceArgs', 'AzurePostgreSqlSourceArgs', 'AzureTableSourceArgs', 'BlobSourceArgs', 'CassandraSourceArgs', 'ConcurSourceArgs', 'CouchbaseSourceArgs', 'DocumentDbCollectionSourceArgs', 'DrillSourceArgs', 'DynamicsSourceArgs', 'EloquaSourceArgs', 'FileSystemSourceArgs', 'GoogleBigQuerySourceArgs', 'GreenplumSourceArgs', 'HBaseSourceArgs', 'HdfsSourceArgs', 'HiveSourceArgs', 'HttpSourceArgs', 'HubspotSourceArgs', 'ImpalaSourceArgs', 'JiraSourceArgs', 'MagentoSourceArgs', 'MariaDBSourceArgs', 'MarketoSourceArgs', 'MongoDbSourceArgs', 'NetezzaSourceArgs', 'OracleSourceArgs', 'PaypalSourceArgs', 'PhoenixSourceArgs', 'PrestoSourceArgs', 'QuickBooksSourceArgs', 'RelationalSourceArgs', 'ResponsysSourceArgs', 'SalesforceMarketingCloudSourceArgs', 'SalesforceSourceArgs', 'SapCloudForCustomerSourceArgs', 'SapEccSourceArgs', 'ServiceNowSourceArgs', 'ShopifySourceArgs', 'SparkSourceArgs', 'SqlDWSourceArgs', 'SqlSourceArgs', 'SquareSourceArgs', 'VerticaSourceArgs', 'WebSourceArgs', 'XeroSourceArgs', 'ZohoSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of activity.
        Expected value is 'Lookup'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]:
        """
        Activity depends on condition.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActivityDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Activity description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="firstRowOnly")
    def first_row_only(self) -> Optional[Any]:
        """
        Whether to return first row or all rows. Default value is true. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "first_row_only")

    @first_row_only.setter
    def first_row_only(self, value: Optional[Any]):
        pulumi.set(self, "first_row_only", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input['LinkedServiceReferenceArgs']]:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input['LinkedServiceReferenceArgs']]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ActivityPolicyArgs']]:
        """
        Activity policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ActivityPolicyArgs']]):
        pulumi.set(self, "policy", value)


@pulumi.input_type
class MagentoLinkedServiceArgs:
    def __init__(__self__, *,
                 host: Any,
                 type: pulumi.Input[str],
                 access_token: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Magento server linked service.
        :param Any host: The URL of the Magento instance. (i.e. 192.168.222.110/magento3)
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Magento'.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] access_token: The access token from Magento.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'Magento')
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        The URL of the Magento instance. (i.e. 192.168.222.110/magento3)
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Any):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Magento'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The access token from Magento.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @use_encrypted_endpoints.setter
    def use_encrypted_endpoints(self, value: Optional[Any]):
        pulumi.set(self, "use_encrypted_endpoints", value)

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_host_verification")

    @use_host_verification.setter
    def use_host_verification(self, value: Optional[Any]):
        pulumi.set(self, "use_host_verification", value)

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_peer_verification")

    @use_peer_verification.setter
    def use_peer_verification(self, value: Optional[Any]):
        pulumi.set(self, "use_peer_verification", value)


@pulumi.input_type
class MagentoObjectDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Magento server dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'MagentoObject'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'MagentoObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'MagentoObject'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class MagentoSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Magento server source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'MagentoSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'MagentoSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'MagentoSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class ManagedIntegrationRuntimeArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 compute_properties: Optional[pulumi.Input['IntegrationRuntimeComputePropertiesArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ssis_properties: Optional[pulumi.Input['IntegrationRuntimeSsisPropertiesArgs']] = None):
        """
        Managed integration runtime, including managed elastic and managed dedicated integration runtimes.
        :param pulumi.Input[str] type: The type of integration runtime.
               Expected value is 'Managed'.
        :param pulumi.Input['IntegrationRuntimeComputePropertiesArgs'] compute_properties: The compute resource for managed integration runtime.
        :param pulumi.Input[str] description: Integration runtime description.
        :param pulumi.Input['IntegrationRuntimeSsisPropertiesArgs'] ssis_properties: SSIS properties for managed integration runtime.
        """
        pulumi.set(__self__, "type", 'Managed')
        if compute_properties is not None:
            pulumi.set(__self__, "compute_properties", compute_properties)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ssis_properties is not None:
            pulumi.set(__self__, "ssis_properties", ssis_properties)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of integration runtime.
        Expected value is 'Managed'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="computeProperties")
    def compute_properties(self) -> Optional[pulumi.Input['IntegrationRuntimeComputePropertiesArgs']]:
        """
        The compute resource for managed integration runtime.
        """
        return pulumi.get(self, "compute_properties")

    @compute_properties.setter
    def compute_properties(self, value: Optional[pulumi.Input['IntegrationRuntimeComputePropertiesArgs']]):
        pulumi.set(self, "compute_properties", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Integration runtime description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ssisProperties")
    def ssis_properties(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisPropertiesArgs']]:
        """
        SSIS properties for managed integration runtime.
        """
        return pulumi.get(self, "ssis_properties")

    @ssis_properties.setter
    def ssis_properties(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisPropertiesArgs']]):
        pulumi.set(self, "ssis_properties", value)


@pulumi.input_type
class MariaDBLinkedServiceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 connection_string: Optional[Any] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None):
        """
        MariaDB server linked service.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'MariaDB'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param Any connection_string: An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "type", 'MariaDB')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'MariaDB'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[Any]:
        """
        An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[Any]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class MariaDBSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity MariaDB server source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'MariaDBSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'MariaDBSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'MariaDBSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class MariaDBTableDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        MariaDB server dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'MariaDBTable'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'MariaDBTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'MariaDBTable'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class MarketoLinkedServiceArgs:
    def __init__(__self__, *,
                 client_id: Any,
                 endpoint: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 client_secret: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Marketo server linked service.
        :param Any client_id: The client Id of your Marketo service.
        :param Any endpoint: The endpoint of the Marketo server. (i.e. 123-ABC-321.mktorest.com)
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Marketo'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] client_secret: The client secret of your Marketo service.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "type", 'Marketo')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Any:
        """
        The client Id of your Marketo service.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Any):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Any:
        """
        The endpoint of the Marketo server. (i.e. 123-ABC-321.mktorest.com)
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Any):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Marketo'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The client secret of your Marketo service.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @use_encrypted_endpoints.setter
    def use_encrypted_endpoints(self, value: Optional[Any]):
        pulumi.set(self, "use_encrypted_endpoints", value)

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_host_verification")

    @use_host_verification.setter
    def use_host_verification(self, value: Optional[Any]):
        pulumi.set(self, "use_host_verification", value)

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_peer_verification")

    @use_peer_verification.setter
    def use_peer_verification(self, value: Optional[Any]):
        pulumi.set(self, "use_peer_verification", value)


@pulumi.input_type
class MarketoObjectDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Marketo server dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'MarketoObject'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'MarketoObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'MarketoObject'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class MarketoSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Marketo server source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'MarketoSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'MarketoSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'MarketoSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class MongoDbCollectionDatasetArgs:
    def __init__(__self__, *,
                 collection_name: Any,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        The MongoDB database dataset.
        :param Any collection_name: The table name of the MongoDB database. Type: string (or Expression with resultType string).
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'MongoDbCollection'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "collection_name", collection_name)
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'MongoDbCollection')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="collectionName")
    def collection_name(self) -> Any:
        """
        The table name of the MongoDB database. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "collection_name")

    @collection_name.setter
    def collection_name(self, value: Any):
        pulumi.set(self, "collection_name", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'MongoDbCollection'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class MongoDbLinkedServiceArgs:
    def __init__(__self__, *,
                 database_name: Any,
                 server: Any,
                 type: pulumi.Input[str],
                 allow_self_signed_server_cert: Optional[Any] = None,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 auth_source: Optional[Any] = None,
                 authentication_type: Optional[pulumi.Input[Union[str, 'MongoDbAuthenticationType']]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_ssl: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 port: Optional[Any] = None,
                 username: Optional[Any] = None):
        """
        Linked service for MongoDb data source.
        :param Any database_name: The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string).
        :param Any server: The IP address or server name of the MongoDB server. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'MongoDb'.
        :param Any allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from the server. The default value is false. Type: boolean (or Expression with resultType boolean).
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param Any auth_source: Database to verify the username and password. Type: string (or Expression with resultType string).
        :param pulumi.Input[Union[str, 'MongoDbAuthenticationType']] authentication_type: The authentication type to be used to connect to the MongoDB database.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The default value is false. Type: boolean (or Expression with resultType boolean).
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: Password for authentication.
        :param Any port: The TCP port number that the MongoDB server uses to listen for client connections. The default value is 27017. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any username: Username for authentication. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "type", 'MongoDb')
        if allow_self_signed_server_cert is not None:
            pulumi.set(__self__, "allow_self_signed_server_cert", allow_self_signed_server_cert)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if auth_source is not None:
            pulumi.set(__self__, "auth_source", auth_source)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Any:
        """
        The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Any):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def server(self) -> Any:
        """
        The IP address or server name of the MongoDB server. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Any):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'MongoDb'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="allowSelfSignedServerCert")
    def allow_self_signed_server_cert(self) -> Optional[Any]:
        """
        Specifies whether to allow self-signed certificates from the server. The default value is false. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "allow_self_signed_server_cert")

    @allow_self_signed_server_cert.setter
    def allow_self_signed_server_cert(self, value: Optional[Any]):
        pulumi.set(self, "allow_self_signed_server_cert", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="authSource")
    def auth_source(self) -> Optional[Any]:
        """
        Database to verify the username and password. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "auth_source")

    @auth_source.setter
    def auth_source(self, value: Optional[Any]):
        pulumi.set(self, "auth_source", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[Union[str, 'MongoDbAuthenticationType']]]:
        """
        The authentication type to be used to connect to the MongoDB database.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[Union[str, 'MongoDbAuthenticationType']]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[Any]:
        """
        Specifies whether the connections to the server are encrypted using SSL. The default value is false. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "enable_ssl")

    @enable_ssl.setter
    def enable_ssl(self, value: Optional[Any]):
        pulumi.set(self, "enable_ssl", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        Password for authentication.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port number that the MongoDB server uses to listen for client connections. The default value is 27017. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[Any]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        Username for authentication. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[Any]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class MongoDbSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity source for a MongoDB database.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'MongoDbSource'.
        :param Any query: Database query. Should be a SQL-92 query expression. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'MongoDbSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'MongoDbSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        Database query. Should be a SQL-92 query expression. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class MultiplePipelineTriggerArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 pipelines: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerPipelineReferenceArgs']]]] = None):
        """
        Base class for all triggers that support one to many model for trigger to pipeline.
        :param pulumi.Input[str] type: Trigger type.
               Expected value is 'MultiplePipelineTrigger'.
        :param pulumi.Input[str] description: Trigger description.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerPipelineReferenceArgs']]] pipelines: Pipelines that need to be started.
        """
        pulumi.set(__self__, "type", 'MultiplePipelineTrigger')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if pipelines is not None:
            pulumi.set(__self__, "pipelines", pipelines)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Trigger type.
        Expected value is 'MultiplePipelineTrigger'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Trigger description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def pipelines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerPipelineReferenceArgs']]]]:
        """
        Pipelines that need to be started.
        """
        return pulumi.get(self, "pipelines")

    @pipelines.setter
    def pipelines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerPipelineReferenceArgs']]]]):
        pulumi.set(self, "pipelines", value)


@pulumi.input_type
class MySqlLinkedServiceArgs:
    def __init__(__self__, *,
                 connection_string: pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None):
        """
        Linked service for MySQL data source.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] connection_string: The connection string.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'MySql'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'MySql')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]:
        """
        The connection string.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'MySql'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class NetezzaLinkedServiceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 connection_string: Optional[Any] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None):
        """
        Netezza linked service.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Netezza'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param Any connection_string: An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "type", 'Netezza')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Netezza'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[Any]:
        """
        An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[Any]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class NetezzaSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Netezza source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'NetezzaSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'NetezzaSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'NetezzaSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class NetezzaTableDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Netezza dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'NetezzaTable'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'NetezzaTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'NetezzaTable'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class ODataLinkedServiceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 url: Any,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 authentication_type: Optional[pulumi.Input[Union[str, 'ODataAuthenticationType']]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 user_name: Optional[Any] = None):
        """
        Open Data Protocol (OData) linked service.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'OData'.
        :param Any url: The URL of the OData service endpoint. Type: string (or Expression with resultType string).
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[Union[str, 'ODataAuthenticationType']] authentication_type: Type of authentication used to connect to the OData service.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: Password of the OData service.
        :param Any user_name: User name of the OData service. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "type", 'OData')
        pulumi.set(__self__, "url", url)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'OData'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def url(self) -> Any:
        """
        The URL of the OData service endpoint. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Any):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[Union[str, 'ODataAuthenticationType']]]:
        """
        Type of authentication used to connect to the OData service.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[Union[str, 'ODataAuthenticationType']]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        Password of the OData service.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[Any]:
        """
        User name of the OData service. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[Any]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class ODataResourceDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 path: Optional[Any] = None,
                 structure: Optional[Any] = None):
        """
        The Open Data Protocol (OData) resource dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'ODataResource'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any path: The OData resource path. Type: string (or Expression with resultType string).
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'ODataResource')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'ODataResource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[Any]:
        """
        The OData resource path. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[Any]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class OdbcLinkedServiceArgs:
    def __init__(__self__, *,
                 connection_string: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 authentication_type: Optional[Any] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 credential: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 user_name: Optional[Any] = None):
        """
        Open Database Connectivity (ODBC) linked service.
        :param Any connection_string: The non-access credential portion of the connection string as well as an optional encrypted credential. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Odbc'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param Any authentication_type: Type of authentication used to connect to the ODBC data store. Possible values are: Anonymous and Basic. Type: string (or Expression with resultType string).
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] credential: The access credential portion of the connection string specified in driver-specific property-value format.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: Password for Basic authentication.
        :param Any user_name: User name for Basic authentication. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'Odbc')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if credential is not None:
            pulumi.set(__self__, "credential", credential)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Any:
        """
        The non-access credential portion of the connection string as well as an optional encrypted credential. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Any):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Odbc'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[Any]:
        """
        Type of authentication used to connect to the ODBC data store. Possible values are: Anonymous and Basic. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[Any]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def credential(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The access credential portion of the connection string specified in driver-specific property-value format.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "credential", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        Password for Basic authentication.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[Any]:
        """
        User name for Basic authentication. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[Any]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class OdbcSinkArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 pre_copy_script: Optional[Any] = None,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity ODBC sink.
        :param pulumi.Input[str] type: Copy sink type.
               Expected value is 'OdbcSink'.
        :param Any pre_copy_script: A query to execute before starting the copy. Type: string (or Expression with resultType string).
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'OdbcSink')
        if pre_copy_script is not None:
            pulumi.set(__self__, "pre_copy_script", pre_copy_script)
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy sink type.
        Expected value is 'OdbcSink'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="preCopyScript")
    def pre_copy_script(self) -> Optional[Any]:
        """
        A query to execute before starting the copy. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "pre_copy_script")

    @pre_copy_script.setter
    def pre_copy_script(self, value: Optional[Any]):
        pulumi.set(self, "pre_copy_script", value)

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @sink_retry_count.setter
    def sink_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_count", value)

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @sink_retry_wait.setter
    def sink_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_wait", value)

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @write_batch_size.setter
    def write_batch_size(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_size", value)

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")

    @write_batch_timeout.setter
    def write_batch_timeout(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_timeout", value)


@pulumi.input_type
class OracleLinkedServiceArgs:
    def __init__(__self__, *,
                 connection_string: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None):
        """
        Oracle database.
        :param Any connection_string: The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Oracle'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'Oracle')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Any:
        """
        The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Any):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Oracle'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class OracleSinkArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 pre_copy_script: Optional[Any] = None,
                 sink_retry_count: Optional[Any] = None,
                 sink_retry_wait: Optional[Any] = None,
                 write_batch_size: Optional[Any] = None,
                 write_batch_timeout: Optional[Any] = None):
        """
        A copy activity Oracle sink.
        :param pulumi.Input[str] type: Copy sink type.
               Expected value is 'OracleSink'.
        :param Any pre_copy_script: SQL pre-copy script. Type: string (or Expression with resultType string).
        :param Any sink_retry_count: Sink retry count. Type: integer (or Expression with resultType integer).
        :param Any sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any write_batch_size: Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        :param Any write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'OracleSink')
        if pre_copy_script is not None:
            pulumi.set(__self__, "pre_copy_script", pre_copy_script)
        if sink_retry_count is not None:
            pulumi.set(__self__, "sink_retry_count", sink_retry_count)
        if sink_retry_wait is not None:
            pulumi.set(__self__, "sink_retry_wait", sink_retry_wait)
        if write_batch_size is not None:
            pulumi.set(__self__, "write_batch_size", write_batch_size)
        if write_batch_timeout is not None:
            pulumi.set(__self__, "write_batch_timeout", write_batch_timeout)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy sink type.
        Expected value is 'OracleSink'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="preCopyScript")
    def pre_copy_script(self) -> Optional[Any]:
        """
        SQL pre-copy script. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "pre_copy_script")

    @pre_copy_script.setter
    def pre_copy_script(self, value: Optional[Any]):
        pulumi.set(self, "pre_copy_script", value)

    @property
    @pulumi.getter(name="sinkRetryCount")
    def sink_retry_count(self) -> Optional[Any]:
        """
        Sink retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "sink_retry_count")

    @sink_retry_count.setter
    def sink_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_count", value)

    @property
    @pulumi.getter(name="sinkRetryWait")
    def sink_retry_wait(self) -> Optional[Any]:
        """
        Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "sink_retry_wait")

    @sink_retry_wait.setter
    def sink_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "sink_retry_wait", value)

    @property
    @pulumi.getter(name="writeBatchSize")
    def write_batch_size(self) -> Optional[Any]:
        """
        Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "write_batch_size")

    @write_batch_size.setter
    def write_batch_size(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_size", value)

    @property
    @pulumi.getter(name="writeBatchTimeout")
    def write_batch_timeout(self) -> Optional[Any]:
        """
        Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "write_batch_timeout")

    @write_batch_timeout.setter
    def write_batch_timeout(self, value: Optional[Any]):
        pulumi.set(self, "write_batch_timeout", value)


@pulumi.input_type
class OracleSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 oracle_reader_query: Optional[Any] = None,
                 query_timeout: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Oracle source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'OracleSource'.
        :param Any oracle_reader_query: Oracle reader query. Type: string (or Expression with resultType string).
        :param Any query_timeout: Query timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'OracleSource')
        if oracle_reader_query is not None:
            pulumi.set(__self__, "oracle_reader_query", oracle_reader_query)
        if query_timeout is not None:
            pulumi.set(__self__, "query_timeout", query_timeout)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'OracleSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="oracleReaderQuery")
    def oracle_reader_query(self) -> Optional[Any]:
        """
        Oracle reader query. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "oracle_reader_query")

    @oracle_reader_query.setter
    def oracle_reader_query(self, value: Optional[Any]):
        pulumi.set(self, "oracle_reader_query", value)

    @property
    @pulumi.getter(name="queryTimeout")
    def query_timeout(self) -> Optional[Any]:
        """
        Query timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "query_timeout")

    @query_timeout.setter
    def query_timeout(self, value: Optional[Any]):
        pulumi.set(self, "query_timeout", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class OracleTableDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 table_name: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        The on-premises Oracle database dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param Any table_name: The table name of the on-premises Oracle database. Type: string (or Expression with resultType string).
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'OracleTable'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "type", 'OracleTable')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Any:
        """
        The table name of the on-premises Oracle database. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Any):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'OracleTable'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class OrcFormatArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 deserializer: Optional[Any] = None,
                 serializer: Optional[Any] = None):
        """
        The data stored in Optimized Row Columnar (ORC) format.
        :param pulumi.Input[str] type: Type of dataset storage format.
               Expected value is 'OrcFormat'.
        :param Any deserializer: Deserializer. Type: string (or Expression with resultType string).
        :param Any serializer: Serializer. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "type", 'OrcFormat')
        if deserializer is not None:
            pulumi.set(__self__, "deserializer", deserializer)
        if serializer is not None:
            pulumi.set(__self__, "serializer", serializer)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset storage format.
        Expected value is 'OrcFormat'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def deserializer(self) -> Optional[Any]:
        """
        Deserializer. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "deserializer")

    @deserializer.setter
    def deserializer(self, value: Optional[Any]):
        pulumi.set(self, "deserializer", value)

    @property
    @pulumi.getter
    def serializer(self) -> Optional[Any]:
        """
        Serializer. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "serializer")

    @serializer.setter
    def serializer(self, value: Optional[Any]):
        pulumi.set(self, "serializer", value)


@pulumi.input_type
class ParameterSpecificationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'ParameterType']],
                 default_value: Optional[Any] = None):
        """
        Definition of a single parameter for an entity.
        :param pulumi.Input[Union[str, 'ParameterType']] type: Parameter type.
        :param Any default_value: Default value of parameter.
        """
        pulumi.set(__self__, "type", type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ParameterType']]:
        """
        Parameter type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ParameterType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[Any]:
        """
        Default value of parameter.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[Any]):
        pulumi.set(self, "default_value", value)


@pulumi.input_type
class ParquetFormatArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 deserializer: Optional[Any] = None,
                 serializer: Optional[Any] = None):
        """
        The data stored in Parquet format.
        :param pulumi.Input[str] type: Type of dataset storage format.
               Expected value is 'ParquetFormat'.
        :param Any deserializer: Deserializer. Type: string (or Expression with resultType string).
        :param Any serializer: Serializer. Type: string (or Expression with resultType string).
        """
        pulumi.set(__self__, "type", 'ParquetFormat')
        if deserializer is not None:
            pulumi.set(__self__, "deserializer", deserializer)
        if serializer is not None:
            pulumi.set(__self__, "serializer", serializer)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset storage format.
        Expected value is 'ParquetFormat'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def deserializer(self) -> Optional[Any]:
        """
        Deserializer. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "deserializer")

    @deserializer.setter
    def deserializer(self, value: Optional[Any]):
        pulumi.set(self, "deserializer", value)

    @property
    @pulumi.getter
    def serializer(self) -> Optional[Any]:
        """
        Serializer. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "serializer")

    @serializer.setter
    def serializer(self, value: Optional[Any]):
        pulumi.set(self, "serializer", value)


@pulumi.input_type
class PaypalLinkedServiceArgs:
    def __init__(__self__, *,
                 client_id: Any,
                 host: Any,
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 client_secret: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 use_encrypted_endpoints: Optional[Any] = None,
                 use_host_verification: Optional[Any] = None,
                 use_peer_verification: Optional[Any] = None):
        """
        Paypal Service linked service.
        :param Any client_id: The client ID associated with your PayPal application.
        :param Any host: The URL of the PayPal instance. (i.e. api.sandbox.paypal.com)
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Paypal'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] client_secret: The client secret associated with your PayPal application.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param Any use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        :param Any use_host_verification: Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        :param Any use_peer_verification: Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'Paypal')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if use_encrypted_endpoints is not None:
            pulumi.set(__self__, "use_encrypted_endpoints", use_encrypted_endpoints)
        if use_host_verification is not None:
            pulumi.set(__self__, "use_host_verification", use_host_verification)
        if use_peer_verification is not None:
            pulumi.set(__self__, "use_peer_verification", use_peer_verification)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Any:
        """
        The client ID associated with your PayPal application.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Any):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        The URL of the PayPal instance. (i.e. api.sandbox.paypal.com)
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Any):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Paypal'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The client secret associated with your PayPal application.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="useEncryptedEndpoints")
    def use_encrypted_endpoints(self) -> Optional[Any]:
        """
        Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
        """
        return pulumi.get(self, "use_encrypted_endpoints")

    @use_encrypted_endpoints.setter
    def use_encrypted_endpoints(self, value: Optional[Any]):
        pulumi.set(self, "use_encrypted_endpoints", value)

    @property
    @pulumi.getter(name="useHostVerification")
    def use_host_verification(self) -> Optional[Any]:
        """
        Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_host_verification")

    @use_host_verification.setter
    def use_host_verification(self, value: Optional[Any]):
        pulumi.set(self, "use_host_verification", value)

    @property
    @pulumi.getter(name="usePeerVerification")
    def use_peer_verification(self) -> Optional[Any]:
        """
        Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
        """
        return pulumi.get(self, "use_peer_verification")

    @use_peer_verification.setter
    def use_peer_verification(self, value: Optional[Any]):
        pulumi.set(self, "use_peer_verification", value)


@pulumi.input_type
class PaypalObjectDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Paypal Service dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'PaypalObject'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'PaypalObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'PaypalObject'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class PaypalSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Paypal Service source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'PaypalSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'PaypalSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'PaypalSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class PhoenixLinkedServiceArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[Union[str, 'PhoenixAuthenticationType']],
                 host: Any,
                 type: pulumi.Input[str],
                 allow_host_name_cn_mismatch: Optional[Any] = None,
                 allow_self_signed_server_cert: Optional[Any] = None,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_ssl: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 http_path: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 port: Optional[Any] = None,
                 trusted_cert_path: Optional[Any] = None,
                 use_system_trust_store: Optional[Any] = None,
                 username: Optional[Any] = None):
        """
        Phoenix server linked service.
        :param pulumi.Input[Union[str, 'PhoenixAuthenticationType']] authentication_type: The authentication mechanism used to connect to the Phoenix server.
        :param Any host: The IP address or host name of the Phoenix server. (i.e. 192.168.222.160)
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Phoenix'.
        :param Any allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        :param Any allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from the server. The default value is false.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param Any http_path: The partial URL corresponding to the Phoenix server. (i.e. /gateway/sandbox/phoenix/version). The default value is hbasephoenix if using WindowsAzureHDInsightService.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: The password corresponding to the user name.
        :param Any port: The TCP port that the Phoenix server uses to listen for client connections. The default value is 8765.
        :param Any trusted_cert_path: The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        :param Any use_system_trust_store: Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        :param Any username: The user name used to connect to the Phoenix server.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "type", 'Phoenix')
        if allow_host_name_cn_mismatch is not None:
            pulumi.set(__self__, "allow_host_name_cn_mismatch", allow_host_name_cn_mismatch)
        if allow_self_signed_server_cert is not None:
            pulumi.set(__self__, "allow_self_signed_server_cert", allow_self_signed_server_cert)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if http_path is not None:
            pulumi.set(__self__, "http_path", http_path)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if trusted_cert_path is not None:
            pulumi.set(__self__, "trusted_cert_path", trusted_cert_path)
        if use_system_trust_store is not None:
            pulumi.set(__self__, "use_system_trust_store", use_system_trust_store)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[Union[str, 'PhoenixAuthenticationType']]:
        """
        The authentication mechanism used to connect to the Phoenix server.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[Union[str, 'PhoenixAuthenticationType']]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        The IP address or host name of the Phoenix server. (i.e. 192.168.222.160)
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Any):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Phoenix'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="allowHostNameCNMismatch")
    def allow_host_name_cn_mismatch(self) -> Optional[Any]:
        """
        Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        """
        return pulumi.get(self, "allow_host_name_cn_mismatch")

    @allow_host_name_cn_mismatch.setter
    def allow_host_name_cn_mismatch(self, value: Optional[Any]):
        pulumi.set(self, "allow_host_name_cn_mismatch", value)

    @property
    @pulumi.getter(name="allowSelfSignedServerCert")
    def allow_self_signed_server_cert(self) -> Optional[Any]:
        """
        Specifies whether to allow self-signed certificates from the server. The default value is false.
        """
        return pulumi.get(self, "allow_self_signed_server_cert")

    @allow_self_signed_server_cert.setter
    def allow_self_signed_server_cert(self, value: Optional[Any]):
        pulumi.set(self, "allow_self_signed_server_cert", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[Any]:
        """
        Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        """
        return pulumi.get(self, "enable_ssl")

    @enable_ssl.setter
    def enable_ssl(self, value: Optional[Any]):
        pulumi.set(self, "enable_ssl", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter(name="httpPath")
    def http_path(self) -> Optional[Any]:
        """
        The partial URL corresponding to the Phoenix server. (i.e. /gateway/sandbox/phoenix/version). The default value is hbasephoenix if using WindowsAzureHDInsightService.
        """
        return pulumi.get(self, "http_path")

    @http_path.setter
    def http_path(self, value: Optional[Any]):
        pulumi.set(self, "http_path", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The password corresponding to the user name.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port that the Phoenix server uses to listen for client connections. The default value is 8765.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[Any]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="trustedCertPath")
    def trusted_cert_path(self) -> Optional[Any]:
        """
        The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        """
        return pulumi.get(self, "trusted_cert_path")

    @trusted_cert_path.setter
    def trusted_cert_path(self, value: Optional[Any]):
        pulumi.set(self, "trusted_cert_path", value)

    @property
    @pulumi.getter(name="useSystemTrustStore")
    def use_system_trust_store(self) -> Optional[Any]:
        """
        Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        """
        return pulumi.get(self, "use_system_trust_store")

    @use_system_trust_store.setter
    def use_system_trust_store(self, value: Optional[Any]):
        pulumi.set(self, "use_system_trust_store", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[Any]:
        """
        The user name used to connect to the Phoenix server.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[Any]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class PhoenixObjectDatasetArgs:
    def __init__(__self__, *,
                 linked_service_name: pulumi.Input['LinkedServiceReferenceArgs'],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 structure: Optional[Any] = None):
        """
        Phoenix server dataset.
        :param pulumi.Input['LinkedServiceReferenceArgs'] linked_service_name: Linked service reference.
        :param pulumi.Input[str] type: Type of dataset.
               Expected value is 'PhoenixObject'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input[str] description: Dataset description.
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for dataset.
        :param Any structure: Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        pulumi.set(__self__, "type", 'PhoenixObject')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if structure is not None:
            pulumi.set(__self__, "structure", structure)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input['LinkedServiceReferenceArgs']:
        """
        Linked service reference.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input['LinkedServiceReferenceArgs']):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of dataset.
        Expected value is 'PhoenixObject'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def structure(self) -> Optional[Any]:
        """
        Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
        """
        return pulumi.get(self, "structure")

    @structure.setter
    def structure(self, value: Optional[Any]):
        pulumi.set(self, "structure", value)


@pulumi.input_type
class PhoenixSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 query: Optional[Any] = None,
                 source_retry_count: Optional[Any] = None,
                 source_retry_wait: Optional[Any] = None):
        """
        A copy activity Phoenix server source.
        :param pulumi.Input[str] type: Copy source type.
               Expected value is 'PhoenixSource'.
        :param Any query: A query to retrieve data from source. Type: string (or Expression with resultType string).
        :param Any source_retry_count: Source retry count. Type: integer (or Expression with resultType integer).
        :param Any source_retry_wait: Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        pulumi.set(__self__, "type", 'PhoenixSource')
        if query is not None:
            pulumi.set(__self__, "query", query)
        if source_retry_count is not None:
            pulumi.set(__self__, "source_retry_count", source_retry_count)
        if source_retry_wait is not None:
            pulumi.set(__self__, "source_retry_wait", source_retry_wait)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Copy source type.
        Expected value is 'PhoenixSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[Any]:
        """
        A query to retrieve data from source. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[Any]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sourceRetryCount")
    def source_retry_count(self) -> Optional[Any]:
        """
        Source retry count. Type: integer (or Expression with resultType integer).
        """
        return pulumi.get(self, "source_retry_count")

    @source_retry_count.setter
    def source_retry_count(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_count", value)

    @property
    @pulumi.getter(name="sourceRetryWait")
    def source_retry_wait(self) -> Optional[Any]:
        """
        Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        """
        return pulumi.get(self, "source_retry_wait")

    @source_retry_wait.setter
    def source_retry_wait(self, value: Optional[Any]):
        pulumi.set(self, "source_retry_wait", value)


@pulumi.input_type
class PipelineReferenceArgs:
    def __init__(__self__, *,
                 reference_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        Pipeline reference type.
        :param pulumi.Input[str] reference_name: Reference pipeline name.
        :param pulumi.Input[str] type: Pipeline reference type.
        :param pulumi.Input[str] name: Reference name.
        """
        pulumi.set(__self__, "reference_name", reference_name)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="referenceName")
    def reference_name(self) -> pulumi.Input[str]:
        """
        Reference pipeline name.
        """
        return pulumi.get(self, "reference_name")

    @reference_name.setter
    def reference_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "reference_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Pipeline reference type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Reference name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class PolybaseSettingsArgs:
    def __init__(__self__, *,
                 reject_sample_value: Optional[Any] = None,
                 reject_type: Optional[pulumi.Input[Union[str, 'PolybaseSettingsRejectType']]] = None,
                 reject_value: Optional[Any] = None,
                 use_type_default: Optional[Any] = None):
        """
        PolyBase settings.
        :param Any reject_sample_value: Determines the number of rows to attempt to retrieve before the PolyBase recalculates the percentage of rejected rows. Type: integer (or Expression with resultType integer), minimum: 0.
        :param pulumi.Input[Union[str, 'PolybaseSettingsRejectType']] reject_type: Reject type.
        :param Any reject_value: Specifies the value or the percentage of rows that can be rejected before the query fails. Type: number (or Expression with resultType number), minimum: 0.
        :param Any use_type_default: Specifies how to handle missing values in delimited text files when PolyBase retrieves data from the text file. Type: boolean (or Expression with resultType boolean).
        """
        if reject_sample_value is not None:
            pulumi.set(__self__, "reject_sample_value", reject_sample_value)
        if reject_type is not None:
            pulumi.set(__self__, "reject_type", reject_type)
        if reject_value is not None:
            pulumi.set(__self__, "reject_value", reject_value)
        if use_type_default is not None:
            pulumi.set(__self__, "use_type_default", use_type_default)

    @property
    @pulumi.getter(name="rejectSampleValue")
    def reject_sample_value(self) -> Optional[Any]:
        """
        Determines the number of rows to attempt to retrieve before the PolyBase recalculates the percentage of rejected rows. Type: integer (or Expression with resultType integer), minimum: 0.
        """
        return pulumi.get(self, "reject_sample_value")

    @reject_sample_value.setter
    def reject_sample_value(self, value: Optional[Any]):
        pulumi.set(self, "reject_sample_value", value)

    @property
    @pulumi.getter(name="rejectType")
    def reject_type(self) -> Optional[pulumi.Input[Union[str, 'PolybaseSettingsRejectType']]]:
        """
        Reject type.
        """
        return pulumi.get(self, "reject_type")

    @reject_type.setter
    def reject_type(self, value: Optional[pulumi.Input[Union[str, 'PolybaseSettingsRejectType']]]):
        pulumi.set(self, "reject_type", value)

    @property
    @pulumi.getter(name="rejectValue")
    def reject_value(self) -> Optional[Any]:
        """
        Specifies the value or the percentage of rows that can be rejected before the query fails. Type: number (or Expression with resultType number), minimum: 0.
        """
        return pulumi.get(self, "reject_value")

    @reject_value.setter
    def reject_value(self, value: Optional[Any]):
        pulumi.set(self, "reject_value", value)

    @property
    @pulumi.getter(name="useTypeDefault")
    def use_type_default(self) -> Optional[Any]:
        """
        Specifies how to handle missing values in delimited text files when PolyBase retrieves data from the text file. Type: boolean (or Expression with resultType boolean).
        """
        return pulumi.get(self, "use_type_default")

    @use_type_default.setter
    def use_type_default(self, value: Optional[Any]):
        pulumi.set(self, "use_type_default", value)


@pulumi.input_type
class PostgreSqlLinkedServiceArgs:
    def __init__(__self__, *,
                 connection_string: pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None):
        """
        Linked service for PostgreSQL data source.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] connection_string: The connection string.
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'PostgreSql'.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "type", 'PostgreSql')
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]:
        """
        The connection string.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'PostgreSql'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class PrestoLinkedServiceArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[Union[str, 'PrestoAuthenticationType']],
                 catalog: Any,
                 host: Any,
                 server_version: Any,
                 type: pulumi.Input[str],
                 allow_host_name_cn_mismatch: Optional[Any] = None,
                 allow_self_signed_server_cert: Optional[Any] = None,
                 annotations: Optional[pulumi.Input[Sequence[Any]]] = None,
                 connect_via: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_ssl: Optional[Any] = None,
                 encrypted_credential: Optional[Any] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]] = None,
                 password: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]] = None,
                 port: Optional[Any] = None,
                 time_zone_id: Optional[Any] = None,
                 trusted_cert_path: Optional[Any] = None,
                 use_system_trust_store: Optional[Any] = None,
                 username: Optional[Any] = None):
        """
        Presto server linked service.
        :param pulumi.Input[Union[str, 'PrestoAuthenticationType']] authentication_type: The authentication mechanism used to connect to the Presto server.
        :param Any catalog: The catalog context for all request against the server.
        :param Any host: The IP address or host name of the Presto server. (i.e. 192.168.222.160)
        :param Any server_version: The version of the Presto server. (i.e. 0.148-t)
        :param pulumi.Input[str] type: Type of linked service.
               Expected value is 'Presto'.
        :param Any allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        :param Any allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from the server. The default value is false.
        :param pulumi.Input[Sequence[Any]] annotations: List of tags that can be used for describing the Dataset.
        :param pulumi.Input['IntegrationRuntimeReferenceArgs'] connect_via: The integration runtime reference.
        :param pulumi.Input[str] description: Linked service description.
        :param Any enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        :param Any encrypted_credential: The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        :param pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]] parameters: Parameters for linked service.
        :param pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']] password: The password corresponding to the user name.
        :param Any port: The TCP port that the Presto server uses to listen for client connections. The default value is 8080.
        :param Any time_zone_id: The local time zone used by the connection. Valid values for this option are specified in the IANA Time Zone Database. The default value is the system time zone.
        :param Any trusted_cert_path: The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        :param Any use_system_trust_store: Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        :param Any username: The user name used to connect to the Presto server.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "catalog", catalog)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "server_version", server_version)
        pulumi.set(__self__, "type", 'Presto')
        if allow_host_name_cn_mismatch is not None:
            pulumi.set(__self__, "allow_host_name_cn_mismatch", allow_host_name_cn_mismatch)
        if allow_self_signed_server_cert is not None:
            pulumi.set(__self__, "allow_self_signed_server_cert", allow_self_signed_server_cert)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if time_zone_id is not None:
            pulumi.set(__self__, "time_zone_id", time_zone_id)
        if trusted_cert_path is not None:
            pulumi.set(__self__, "trusted_cert_path", trusted_cert_path)
        if use_system_trust_store is not None:
            pulumi.set(__self__, "use_system_trust_store", use_system_trust_store)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[Union[str, 'PrestoAuthenticationType']]:
        """
        The authentication mechanism used to connect to the Presto server.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[Union[str, 'PrestoAuthenticationType']]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter
    def catalog(self) -> Any:
        """
        The catalog context for all request against the server.
        """
        return pulumi.get(self, "catalog")

    @catalog.setter
    def catalog(self, value: Any):
        pulumi.set(self, "catalog", value)

    @property
    @pulumi.getter
    def host(self) -> Any:
        """
        The IP address or host name of the Presto server. (i.e. 192.168.222.160)
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Any):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Any:
        """
        The version of the Presto server. (i.e. 0.148-t)
        """
        return pulumi.get(self, "server_version")

    @server_version.setter
    def server_version(self, value: Any):
        pulumi.set(self, "server_version", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of linked service.
        Expected value is 'Presto'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="allowHostNameCNMismatch")
    def allow_host_name_cn_mismatch(self) -> Optional[Any]:
        """
        Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
        """
        return pulumi.get(self, "allow_host_name_cn_mismatch")

    @allow_host_name_cn_mismatch.setter
    def allow_host_name_cn_mismatch(self, value: Optional[Any]):
        pulumi.set(self, "allow_host_name_cn_mismatch", value)

    @property
    @pulumi.getter(name="allowSelfSignedServerCert")
    def allow_self_signed_server_cert(self) -> Optional[Any]:
        """
        Specifies whether to allow self-signed certificates from the server. The default value is false.
        """
        return pulumi.get(self, "allow_self_signed_server_cert")

    @allow_self_signed_server_cert.setter
    def allow_self_signed_server_cert(self, value: Optional[Any]):
        pulumi.set(self, "allow_self_signed_server_cert", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of tags that can be used for describing the Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]:
        """
        The integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['IntegrationRuntimeReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Linked service description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[Any]:
        """
        Specifies whether the connections to the server are encrypted using SSL. The default value is false.
        """
        return pulumi.get(self, "enable_ssl")

    @enable_ssl.setter
    def enable_ssl(self, value: Optional[Any]):
        pulumi.set(self, "enable_ssl", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[Any]:
        """
        The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[Any]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]:
        """
        Parameters for linked service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ParameterSpecificationArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]:
        """
        The password corresponding to the user name.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[Union['AzureKeyVaultSecretReferenceArgs', 'SecureStringArgs']]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        The TCP port that the Presto server uses to listen for client connections. The default value is 8080.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[Any]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="timeZoneID")
    def time_zone_id(self) -> Optional[Any]:
        """
        The local time zone used by the connection. Valid values for this option are specified in the IANA Time Zone Database. The default value is the system time zone.
        """
        return pulumi.get(self, "time_zone_id")

    @time_zone_id.setter
    def time_zone_id(self, value: Optional[Any]):
        pulumi.set(self, "time_zone_id", value)

    @property
    @pulumi.getter(name="trustedCertPath")
    def trusted_cert_path(self) -> Optional[Any]:
        """
        The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
        """
        return pulumi.get(self, "trusted_cert_path")

    @trusted_cert_path.setter
    def trusted_cert_path(self, value: Optional[Any]):
        pulumi.set(self, "trusted_cert_path", value)

    @property
    @pulumi.getter(name="useSystemTrustStore")
    def use_system_trust_store(self) -> Optional[Any]:
        """
        Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
        """
        return pulumi.get(self, "use_system_trust_store")

    @use_system_trust_store.setter
    def use_system_trust_store(self, value: Optional[Any]):
        p