# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetRunbookResult',
    'AwaitableGetRunbookResult',
    'get_runbook',
    'get_runbook_output',
]

@pulumi.output_type
class GetRunbookResult:
    """
    Definition of the runbook type.
    """
    def __init__(__self__, creation_time=None, description=None, draft=None, etag=None, id=None, job_count=None, last_modified_by=None, last_modified_time=None, location=None, log_activity_trace=None, log_progress=None, log_verbose=None, name=None, output_types=None, parameters=None, provisioning_state=None, publish_content_link=None, runbook_type=None, state=None, tags=None, type=None):
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if draft and not isinstance(draft, dict):
            raise TypeError("Expected argument 'draft' to be a dict")
        pulumi.set(__self__, "draft", draft)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if job_count and not isinstance(job_count, int):
            raise TypeError("Expected argument 'job_count' to be a int")
        pulumi.set(__self__, "job_count", job_count)
        if last_modified_by and not isinstance(last_modified_by, str):
            raise TypeError("Expected argument 'last_modified_by' to be a str")
        pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_time and not isinstance(last_modified_time, str):
            raise TypeError("Expected argument 'last_modified_time' to be a str")
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if log_activity_trace and not isinstance(log_activity_trace, int):
            raise TypeError("Expected argument 'log_activity_trace' to be a int")
        pulumi.set(__self__, "log_activity_trace", log_activity_trace)
        if log_progress and not isinstance(log_progress, bool):
            raise TypeError("Expected argument 'log_progress' to be a bool")
        pulumi.set(__self__, "log_progress", log_progress)
        if log_verbose and not isinstance(log_verbose, bool):
            raise TypeError("Expected argument 'log_verbose' to be a bool")
        pulumi.set(__self__, "log_verbose", log_verbose)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if output_types and not isinstance(output_types, list):
            raise TypeError("Expected argument 'output_types' to be a list")
        pulumi.set(__self__, "output_types", output_types)
        if parameters and not isinstance(parameters, dict):
            raise TypeError("Expected argument 'parameters' to be a dict")
        pulumi.set(__self__, "parameters", parameters)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if publish_content_link and not isinstance(publish_content_link, dict):
            raise TypeError("Expected argument 'publish_content_link' to be a dict")
        pulumi.set(__self__, "publish_content_link", publish_content_link)
        if runbook_type and not isinstance(runbook_type, str):
            raise TypeError("Expected argument 'runbook_type' to be a str")
        pulumi.set(__self__, "runbook_type", runbook_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[str]:
        """
        Gets or sets the creation time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Gets or sets the description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def draft(self) -> Optional['outputs.RunbookDraftResponse']:
        """
        Gets or sets the draft runbook properties.
        """
        return pulumi.get(self, "draft")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Gets or sets the etag of the resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource Id for the resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="jobCount")
    def job_count(self) -> Optional[int]:
        """
        Gets or sets the job count of the runbook.
        """
        return pulumi.get(self, "job_count")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        Gets or sets the last modified by.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[str]:
        """
        Gets or sets the last modified time.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The Azure Region where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="logActivityTrace")
    def log_activity_trace(self) -> Optional[int]:
        """
        Gets or sets the option to log activity trace of the runbook.
        """
        return pulumi.get(self, "log_activity_trace")

    @property
    @pulumi.getter(name="logProgress")
    def log_progress(self) -> Optional[bool]:
        """
        Gets or sets progress log option.
        """
        return pulumi.get(self, "log_progress")

    @property
    @pulumi.getter(name="logVerbose")
    def log_verbose(self) -> Optional[bool]:
        """
        Gets or sets verbose log option.
        """
        return pulumi.get(self, "log_verbose")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputTypes")
    def output_types(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the runbook output types.
        """
        return pulumi.get(self, "output_types")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.RunbookParameterResponse']]:
        """
        Gets or sets the runbook parameters.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets or sets the provisioning state of the runbook.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publishContentLink")
    def publish_content_link(self) -> Optional['outputs.ContentLinkResponse']:
        """
        Gets or sets the published runbook content link.
        """
        return pulumi.get(self, "publish_content_link")

    @property
    @pulumi.getter(name="runbookType")
    def runbook_type(self) -> Optional[str]:
        """
        Gets or sets the type of the runbook.
        """
        return pulumi.get(self, "runbook_type")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Gets or sets the state of the runbook.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")


class AwaitableGetRunbookResult(GetRunbookResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRunbookResult(
            creation_time=self.creation_time,
            description=self.description,
            draft=self.draft,
            etag=self.etag,
            id=self.id,
            job_count=self.job_count,
            last_modified_by=self.last_modified_by,
            last_modified_time=self.last_modified_time,
            location=self.location,
            log_activity_trace=self.log_activity_trace,
            log_progress=self.log_progress,
            log_verbose=self.log_verbose,
            name=self.name,
            output_types=self.output_types,
            parameters=self.parameters,
            provisioning_state=self.provisioning_state,
            publish_content_link=self.publish_content_link,
            runbook_type=self.runbook_type,
            state=self.state,
            tags=self.tags,
            type=self.type)


def get_runbook(automation_account_name: Optional[str] = None,
                resource_group_name: Optional[str] = None,
                runbook_name: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRunbookResult:
    """
    Retrieve the runbook identified by runbook name.


    :param str automation_account_name: The name of the automation account.
    :param str resource_group_name: Name of an Azure Resource group.
    :param str runbook_name: The runbook name.
    """
    __args__ = dict()
    __args__['automationAccountName'] = automation_account_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['runbookName'] = runbook_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:automation/v20220808:getRunbook', __args__, opts=opts, typ=GetRunbookResult).value

    return AwaitableGetRunbookResult(
        creation_time=__ret__.creation_time,
        description=__ret__.description,
        draft=__ret__.draft,
        etag=__ret__.etag,
        id=__ret__.id,
        job_count=__ret__.job_count,
        last_modified_by=__ret__.last_modified_by,
        last_modified_time=__ret__.last_modified_time,
        location=__ret__.location,
        log_activity_trace=__ret__.log_activity_trace,
        log_progress=__ret__.log_progress,
        log_verbose=__ret__.log_verbose,
        name=__ret__.name,
        output_types=__ret__.output_types,
        parameters=__ret__.parameters,
        provisioning_state=__ret__.provisioning_state,
        publish_content_link=__ret__.publish_content_link,
        runbook_type=__ret__.runbook_type,
        state=__ret__.state,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_runbook)
def get_runbook_output(automation_account_name: Optional[pulumi.Input[str]] = None,
                       resource_group_name: Optional[pulumi.Input[str]] = None,
                       runbook_name: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRunbookResult]:
    """
    Retrieve the runbook identified by runbook name.


    :param str automation_account_name: The name of the automation account.
    :param str resource_group_name: Name of an Azure Resource group.
    :param str runbook_name: The runbook name.
    """
    ...
