# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetGovernanceAssignmentResult',
    'AwaitableGetGovernanceAssignmentResult',
    'get_governance_assignment',
    'get_governance_assignment_output',
]

@pulumi.output_type
class GetGovernanceAssignmentResult:
    """
    Governance assignment over a given scope
    """
    def __init__(__self__, additional_data=None, governance_email_notification=None, id=None, is_grace_period=None, name=None, owner=None, remediation_due_date=None, remediation_eta=None, type=None):
        if additional_data and not isinstance(additional_data, dict):
            raise TypeError("Expected argument 'additional_data' to be a dict")
        pulumi.set(__self__, "additional_data", additional_data)
        if governance_email_notification and not isinstance(governance_email_notification, dict):
            raise TypeError("Expected argument 'governance_email_notification' to be a dict")
        pulumi.set(__self__, "governance_email_notification", governance_email_notification)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_grace_period and not isinstance(is_grace_period, bool):
            raise TypeError("Expected argument 'is_grace_period' to be a bool")
        pulumi.set(__self__, "is_grace_period", is_grace_period)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if remediation_due_date and not isinstance(remediation_due_date, str):
            raise TypeError("Expected argument 'remediation_due_date' to be a str")
        pulumi.set(__self__, "remediation_due_date", remediation_due_date)
        if remediation_eta and not isinstance(remediation_eta, dict):
            raise TypeError("Expected argument 'remediation_eta' to be a dict")
        pulumi.set(__self__, "remediation_eta", remediation_eta)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="additionalData")
    def additional_data(self) -> Optional['outputs.GovernanceAssignmentAdditionalDataResponse']:
        """
        The additional data for the governance assignment - e.g. links to ticket (optional), see example
        """
        return pulumi.get(self, "additional_data")

    @property
    @pulumi.getter(name="governanceEmailNotification")
    def governance_email_notification(self) -> Optional['outputs.GovernanceEmailNotificationResponse']:
        """
        The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
        """
        return pulumi.get(self, "governance_email_notification")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isGracePeriod")
    def is_grace_period(self) -> Optional[bool]:
        """
        Defines whether there is a grace period on the governance assignment
        """
        return pulumi.get(self, "is_grace_period")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> Optional[str]:
        """
        The Owner for the governance assignment - e.g. user@contoso.com - see example
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="remediationDueDate")
    def remediation_due_date(self) -> str:
        """
        The remediation due-date - after this date Secure Score will be affected (in case of  active grace-period)
        """
        return pulumi.get(self, "remediation_due_date")

    @property
    @pulumi.getter(name="remediationEta")
    def remediation_eta(self) -> Optional['outputs.RemediationEtaResponse']:
        """
        The ETA (estimated time of arrival) for remediation (optional), see example
        """
        return pulumi.get(self, "remediation_eta")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type
        """
        return pulumi.get(self, "type")


class AwaitableGetGovernanceAssignmentResult(GetGovernanceAssignmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGovernanceAssignmentResult(
            additional_data=self.additional_data,
            governance_email_notification=self.governance_email_notification,
            id=self.id,
            is_grace_period=self.is_grace_period,
            name=self.name,
            owner=self.owner,
            remediation_due_date=self.remediation_due_date,
            remediation_eta=self.remediation_eta,
            type=self.type)


def get_governance_assignment(assessment_name: Optional[str] = None,
                              assignment_key: Optional[str] = None,
                              scope: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGovernanceAssignmentResult:
    """
    Governance assignment over a given scope


    :param str assessment_name: The Assessment Key - A unique key for the assessment type
    :param str assignment_key: The governance assignment key - the assessment key of the required governance assignment
    :param str scope: The scope of the Governance assignments. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'), or security connector (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
    """
    __args__ = dict()
    __args__['assessmentName'] = assessment_name
    __args__['assignmentKey'] = assignment_key
    __args__['scope'] = scope
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:security/v20220101preview:getGovernanceAssignment', __args__, opts=opts, typ=GetGovernanceAssignmentResult).value

    return AwaitableGetGovernanceAssignmentResult(
        additional_data=__ret__.additional_data,
        governance_email_notification=__ret__.governance_email_notification,
        id=__ret__.id,
        is_grace_period=__ret__.is_grace_period,
        name=__ret__.name,
        owner=__ret__.owner,
        remediation_due_date=__ret__.remediation_due_date,
        remediation_eta=__ret__.remediation_eta,
        type=__ret__.type)


@_utilities.lift_output_func(get_governance_assignment)
def get_governance_assignment_output(assessment_name: Optional[pulumi.Input[str]] = None,
                                     assignment_key: Optional[pulumi.Input[str]] = None,
                                     scope: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGovernanceAssignmentResult]:
    """
    Governance assignment over a given scope


    :param str assessment_name: The Assessment Key - A unique key for the assessment type
    :param str assignment_key: The governance assignment key - the assessment key of the required governance assignment
    :param str scope: The scope of the Governance assignments. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'), or security connector (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
    """
    ...
